/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPoolTask;
import com.biglybt.core.util.Timer;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;

public class TimerEvent
extends ThreadPoolTask
implements Comparable<TimerEvent> {
    private String name;
    private final Timer timer;
    private final long created;
    private long when;
    private final TimerEventPerformer performer;
    private final boolean absolute;
    private boolean cancelled;
    private boolean has_run;
    private final long unique_id;
    private volatile long exec_start = -1L;

    protected TimerEvent(Timer _timer, long _unique_id, long _created, long _when, boolean _absolute, TimerEventPerformer _performer) {
        this.timer = _timer;
        this.unique_id = _unique_id;
        this.when = _when;
        this.absolute = _absolute;
        this.performer = _performer;
        this.created = _created;
        if (Constants.IS_CVS_VERSION) {
            if (this.when != 0L && this.when <= 604800000L) {
                new Exception("You sure you want to schedule an event in the past? Time should be absolute!").printStackTrace();
            } else if (this.when > 94608000000000L) {
                new Exception("You sure you want to schedule an event so far in the future?! (" + this.when + ")").printStackTrace();
            }
        }
    }

    public void setName(String _name) {
        this.name = _name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getCreatedTime() {
        return this.created;
    }

    public long getWhen() {
        return this.when;
    }

    protected void setWhen(long new_when) {
        this.when = new_when;
    }

    protected AERunnable getRunnable() {
        return this;
    }

    protected TimerEventPerformer getPerformer() {
        return this.performer;
    }

    protected boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public void runSupport() {
        this.performer.perform(this);
    }

    public synchronized void cancel() {
        this.cancelled = true;
        this.timer.cancelEvent(this);
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected void setHasRun() {
        this.has_run = true;
    }

    public boolean hasRun() {
        return this.has_run;
    }

    protected long getUniqueId() {
        return this.unique_id;
    }

    @Override
    public int compareTo(TimerEvent other) {
        long res = this.when - other.when;
        if (res == 0L && (res = this.unique_id - other.unique_id) == 0L) {
            return 0;
        }
        return res < 0L ? -1 : 1;
    }

    @Override
    public void interruptTask() {
    }

    protected void execute() {
        this.exec_start = SystemTime.getMonotonousTime();
        this.timer.execute(this);
    }

    public long getExecutionStartMonoTime() {
        return this.exec_start;
    }

    protected long getSlowEventLimit() {
        return this.timer.getSlowEventLimit();
    }

    public String getString() {
        if (this.performer instanceof TimerEventPeriodic) {
            TimerEventPeriodic tep = (TimerEventPeriodic)this.performer;
            return "when=" + this.getWhen() + ",run=" + this.hasRun() + ", can=" + this.isCancelled() + "/" + tep.isCancelled() + ",freq=" + tep.getFrequency() + ",target=" + tep.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
        }
        return "when=" + this.getWhen() + ",run=" + this.hasRun() + ", can=" + this.isCancelled() + ",target=" + this.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
    }

    protected static class TimerEventLogged
    extends TimerEvent {
        protected TimerEventLogged(Timer timer, long unique_id, long created, long when, boolean absolute, TimerEventPerformer performer) {
            super(timer, unique_id, created, when, absolute, performer);
        }

        @Override
        public void runSupport() {
            try {
                super.runSupport();
            }
            finally {
                long elapsed = SystemTime.getMonotonousTime() - this.getExecutionStartMonoTime();
                if (elapsed > this.getSlowEventLimit()) {
                    System.out.println("Timer event '" + this.getName() + "' took " + elapsed);
                }
            }
        }
    }
}

