/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.protocol.URLConnectionExt;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAnnounceURLList;
import com.biglybt.pif.torrent.TorrentAnnounceURLListSet;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourceuploader.ResourceUploader;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.plugin.magnet.MagnetPlugin;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.gudy.bouncycastle.util.encoders.Base64;

public class UrlUtils {
    private static Pattern patMagnetSHA1HashFinder = Pattern.compile("(?i)xt=urn:(?:btih|sha1):([^&]+)");
    private static Pattern patMagnetMultiHashFinder = Pattern.compile("(?i)xt=urn:btmh:([^&]+)");
    private static final String[] prefixes = new String[]{"http://", "https://", "udp://", "biglybt://", "ftp://", "dht://", "magnet:?", "magnet://?", "maggot://"};
    private static final int MAGNETURL_STARTS_AT = 5;
    private static final Object[] XMLescapes = new Object[]{new String[]{"&", "&amp;"}, new String[]{">", "&gt;"}, new String[]{"<", "&lt;"}, new String[]{"\"", "&quot;"}, new String[]{"'", "&apos;"}};
    private static String last_headers = COConfigurationManager.getStringParameter("metasearch.web.last.headers", null);
    private static final String default_headers = "QWNjZXB0OiB0ZXh0L2h0bWwsYXBwbGljYXRpb24veGh0bWwreG1sLGFwcGxpY2F0aW9uL3htbDtxPTAuOSwqLyo7cT0wLjgKQWNjZXB0LUNoYXJzZXQ6IElTTy04ODU5LTEsdXRmLTg7cT0wLjcsKjtxPTAuMwpBY2NlcHQtRW5jb2Rpbmc6IGd6aXAsZGVmbGF0ZQpBY2NlcHQtTGFuZ3VhZ2U6IGVuLVVTLGVuO3E9MC44CkNhY2hlLUNvbnRyb2w6IG1heC1hZ2U9MApDb25uZWN0aW9uOiBrZWVwLWFsaXZlClVzZXItQWdlbnQ6IE1vemlsbGEvNS4wIChXaW5kb3dzIE5UIDYuMTsgV09XNjQpIEFwcGxlV2ViS2l0LzUzNi4xMSAoS0hUTUwsIGxpa2UgR2Vja28pIENocm9tZS8yMC4wLjExMzIuNDcgU2FmYXJpLzUzNi4xMQ==";

    public static Map<String, String> decodeArgs(String args) {
        String[] bits;
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = bits = (args.startsWith("?") ? args.substring(1) : args).split("&");
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String bit = stringArray[n2];
            String[] temp = bit.split("=", 2);
            if (temp.length == 2) {
                String lhs = temp[0].toLowerCase(Locale.US);
                String rhs = UrlUtils.decode(temp[1]);
                result.put(lhs, rhs);
            } else {
                result.put("", UrlUtils.decode(temp[0]));
            }
            ++n2;
        }
        return result;
    }

    public static String getMagnetURI(byte[] hash) {
        int length = hash.length;
        if (length == 32) {
            return "magnet:?xt=urn:btmh:1220" + ByteFormatter.encodeString(hash);
        }
        if (length != 20) {
            Debug.out("Invalid hash length " + length);
        }
        return "magnet:?xt=urn:btih:" + ByteFormatter.encodeString(hash).toLowerCase(Locale.US);
    }

    public static String getURLForm(InetSocketAddress address) {
        return String.valueOf(AddressUtils.getHostAddressForURL(address)) + ":" + address.getPort();
    }

    public static String getURLForm(InetAddress address, int port) {
        if (address instanceof Inet6Address) {
            return "[" + (address.isLoopbackAddress() ? "::1" : address.getHostAddress()) + "]:" + port;
        }
        return String.valueOf(address.getHostAddress()) + ":" + port;
    }

    public static String getURLForm(String address, int port) {
        if (address.indexOf(58) != -1) {
            return "[" + address + "]:" + port;
        }
        return String.valueOf(address) + ":" + port;
    }

    public static String extractURLHost(String str) {
        int pos;
        if (str.startsWith("[") && (pos = str.indexOf(93)) != -1) {
            return str.substring(0, pos + 1);
        }
        pos = str.lastIndexOf(58);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String getMagnetURI(byte[] hash, String name, String[] networks) {
        String magnet_uri = UrlUtils.getMagnetURI(hash);
        magnet_uri = String.valueOf(magnet_uri) + UrlUtils.encodeName(name);
        magnet_uri = String.valueOf(magnet_uri) + UrlUtils.encodeNetworks(networks);
        return magnet_uri;
    }

    public static String getMagnetURI(byte[] hash, byte[] hash_v2, String name, String[] networks) {
        String magnet_uri = UrlUtils.getMagnetURI(hash);
        if (hash_v2 != null) {
            magnet_uri = String.valueOf(magnet_uri) + "&xt=urn:btmh:1220" + ByteFormatter.encodeString(hash_v2);
        }
        magnet_uri = String.valueOf(magnet_uri) + UrlUtils.encodeName(name);
        magnet_uri = String.valueOf(magnet_uri) + UrlUtils.encodeNetworks(networks);
        return magnet_uri;
    }

    private static String encodeName(String name) {
        if (name == null) {
            return "";
        }
        return "&dn=" + UrlUtils.encode(name);
    }

    private static String encodeNetworks(String[] networks) {
        String net_str = "";
        if (networks != null && networks.length > 0) {
            String[] stringArray = networks;
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public" && networks.length == 1) break;
                net_str = String.valueOf(net_str) + "&net=" + net;
                ++n2;
            }
        }
        return net_str;
    }

    public static Set<String> extractNetworks(String[] magnet_uri) {
        String magnet_uri_in = magnet_uri[0];
        HashSet<String> result = new HashSet<String>();
        int pos = magnet_uri_in.indexOf(63);
        if (pos != -1) {
            String[] bits;
            String magnet_uri_out = magnet_uri_in.substring(0, pos + 1);
            String[] stringArray = bits = magnet_uri_in.substring(pos + 1).split("&");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String lhs;
                String bit = stringArray[n2];
                String[] temp = bit.split("=", 2);
                boolean remove = false;
                if (temp.length == 2 && (lhs = temp[0]).equalsIgnoreCase("net")) {
                    String rhs = UrlUtils.decode(temp[1]);
                    result.add(AENetworkClassifier.internalise(rhs));
                    remove = true;
                }
                if (!remove) {
                    if (!magnet_uri_out.endsWith("?")) {
                        magnet_uri_out = String.valueOf(magnet_uri_out) + "&";
                    }
                    magnet_uri_out = String.valueOf(magnet_uri_out) + bit;
                }
                ++n2;
            }
            if (result.size() > 0) {
                magnet_uri[0] = magnet_uri_out;
            }
        }
        return result;
    }

    public static String getMagnetURI(Download download) {
        return UrlUtils.getMagnetURI(PluginCoreUtils.unwrap(download));
    }

    public static String getMagnetURI(Download download, int max_name_len) {
        return UrlUtils.getMagnetURI(PluginCoreUtils.unwrap(download), max_name_len);
    }

    public static String getMagnetURI(DownloadManager dm) {
        return UrlUtils.getMagnetURI(dm, Integer.MAX_VALUE);
    }

    public static String truncateForURI(String str, int max_utf8_bytes) {
        if (max_utf8_bytes == Integer.MAX_VALUE) {
            return str;
        }
        boolean truncated = false;
        while (str.length() > 4) {
            int enc_len = UrlUtils.encode(str).getBytes(Constants.UTF_8).length;
            if (enc_len <= max_utf8_bytes) break;
            if (!truncated) {
                truncated = true;
                max_utf8_bytes -= 3;
            }
            if (!Character.isHighSurrogate((str = str.substring(0, str.length() - 1)).charAt(str.length() - 1))) continue;
            str = str.substring(0, str.length() - 1);
        }
        if (truncated) {
            str = String.valueOf(str) + "...";
        }
        return str;
    }

    public static String getMagnetURI(DownloadManager dm, int max_name_len) {
        if (dm == null) {
            return null;
        }
        TOTorrent to_torrent = dm.getTorrent();
        if (to_torrent == null) {
            return null;
        }
        String name = UrlUtils.truncateForURI(dm.getDisplayName(), max_name_len);
        String[] networks = dm.getDownloadState().getNetworks();
        String magnet_uri = UrlUtils.getMagnetURI(name, PluginCoreUtils.wrap(to_torrent), networks);
        return magnet_uri;
    }

    public static String getMagnetURI(TOTorrent to_torrent) {
        return UrlUtils.getMagnetURI(new TorrentImpl(to_torrent));
    }

    public static String getMagnetURI(Torrent torrent) {
        return UrlUtils.getMagnetURI(torrent.getName(), torrent, null);
    }

    public static String getMagnetURI(String name, Torrent torrent) {
        return UrlUtils.getMagnetURI(name, torrent, null);
    }

    public static String getMagnetURI(String name, Torrent torrent, String[] networks) {
        byte[] v1_hash = torrent.getFullHash(1);
        if (v1_hash == null) {
            v1_hash = torrent.getHash();
        }
        String magnet_str = UrlUtils.getMagnetURI(v1_hash);
        byte[] v2_hash = torrent.getFullHash(3);
        if (v2_hash != null) {
            magnet_str = String.valueOf(magnet_str) + "&xt=urn:btmh:1220" + ByteFormatter.encodeString(v2_hash);
        }
        magnet_str = String.valueOf(magnet_str) + UrlUtils.encodeName(name);
        if (networks != null) {
            magnet_str = String.valueOf(magnet_str) + UrlUtils.encodeNetworks(networks);
        }
        ArrayList<String> tracker_urls = new ArrayList<String>();
        URL announce_url = torrent.getAnnounceURL();
        if (announce_url != null && !TorrentUtils.isDecentralised(announce_url)) {
            tracker_urls.add(announce_url.toExternalForm());
        }
        TorrentAnnounceURLList list = torrent.getAnnounceURLList();
        TorrentAnnounceURLListSet[] sets = list.getSets();
        TorrentAnnounceURLListSet[] torrentAnnounceURLListSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            URL set_url;
            TorrentAnnounceURLListSet set = torrentAnnounceURLListSetArray[n2];
            URL[] set_urls = set.getURLs();
            if (set_urls.length > 0 && !TorrentUtils.isDecentralised(set_url = set_urls[0]) && !tracker_urls.contains(str = set_url.toExternalForm())) {
                tracker_urls.add(str);
            }
            ++n2;
        }
        for (String str : tracker_urls) {
            magnet_str = String.valueOf(magnet_str) + "&tr=" + UrlUtils.encode(str);
        }
        ArrayList<String> ws_urls = new ArrayList<String>();
        Object obj = torrent.getAdditionalProperty("url-list");
        if (obj instanceof byte[]) {
            try {
                ws_urls.add(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof List) {
            for (Object o : (List)obj) {
                try {
                    if (o instanceof byte[]) {
                        ws_urls.add(new URL(new String((byte[])o, "UTF-8")).toExternalForm());
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    ws_urls.add(new URL((String)o).toExternalForm());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } else if (obj instanceof String) {
            try {
                ws_urls.add(new URL((String)obj).toExternalForm());
            }
            catch (Throwable o) {
                // empty catch block
            }
        }
        for (String str : ws_urls) {
            magnet_str = String.valueOf(magnet_str) + "&ws=" + UrlUtils.encode(str);
        }
        return magnet_str;
    }

    public static String addSource(Download download, String magnet, InetSocketAddress address) {
        MagnetPlugin magnet_plugin;
        if (address != null && (magnet_plugin = (MagnetPlugin)CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class).getPlugin()) != null) {
            magnet = magnet_plugin.addSource(download, magnet, address);
        }
        return magnet;
    }

    public static String normaliseMagnetURI(String base_hash) {
        byte[] hash = UrlUtils.decodeSHA1Hash(base_hash);
        if (hash != null) {
            return UrlUtils.getMagnetURI(hash);
        }
        hash = UrlUtils.decodeMultiHash(base_hash);
        if (hash != null) {
            return UrlUtils.getMagnetURI(hash);
        }
        return null;
    }

    public static byte[] getTruncatedHashFromMagnetURI(String magnetURI) {
        if (magnetURI == null) {
            return null;
        }
        Matcher matcher = patMagnetSHA1HashFinder.matcher(magnetURI);
        if (matcher.find()) {
            return UrlUtils.decodeSHA1Hash(matcher.group(1));
        }
        matcher = patMagnetMultiHashFinder.matcher(magnetURI);
        if (matcher.find()) {
            return UrlUtils.decodeTruncatedMultiHash(matcher.group(1));
        }
        return null;
    }

    public static byte[] decodeTruncatedHashFromMagnetURI(String hash_str) {
        if (hash_str == null) {
            return null;
        }
        byte[] hash = UrlUtils.decodeSHA1Hash(hash_str);
        if (hash == null) {
            hash = UrlUtils.decodeTruncatedMultiHash(hash_str);
        }
        return hash;
    }

    private static byte[] decodeTruncatedMultiHash(String hash_str) {
        byte[] hash = UrlUtils.decodeMultiHash(hash_str);
        if (hash != null && hash.length > 20) {
            byte[] trunc = new byte[20];
            System.arraycopy(hash, 0, trunc, 0, 20);
            return trunc;
        }
        return hash;
    }

    public static byte[] decodeTruncatedHash(String hash_str) {
        byte[] hash = UrlUtils.decodeTruncatedHashFromMagnetURI(hash_str);
        if (hash == null && (hash = UrlUtils.decodeSHA256Hash(hash_str)) != null) {
            byte[] trunc = new byte[20];
            System.arraycopy(hash, 0, trunc, 0, 20);
            return trunc;
        }
        return hash;
    }

    public static byte[] decodeSHA1Hash(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        byte[] hash = null;
        try {
            if (str.length() == 40) {
                hash = ByteFormatter.decodeString(str);
            } else if (str.length() == 32) {
                hash = Base32.decode(str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hash != null && hash.length != 20) {
            hash = null;
        }
        return hash;
    }

    private static byte[] decodeSHA256Hash(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        byte[] hash = null;
        try {
            if (str.length() == 64) {
                hash = ByteFormatter.decodeString(str);
            } else if (str.length() == 52) {
                hash = Base32.decode(str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hash != null && hash.length != 32) {
            hash = null;
        }
        return hash;
    }

    private static byte[] decodeMultiHash(String str) {
        byte[] multi_hash;
        byte[] hash;
        block9: {
            if (str == null) {
                return null;
            }
            str = str.trim();
            hash = null;
            int len = str.length();
            if (len == 44 || len == 68) {
                multi_hash = ByteFormatter.decodeString(str);
                break block9;
            }
            if (len == 36 || len == 55) {
                multi_hash = Base32.decode(str);
                break block9;
            }
            return null;
        }
        try {
            if (multi_hash[0] == 17 && multi_hash[1] == 20 && multi_hash.length == 22) {
                hash = new byte[20];
                System.arraycopy(multi_hash, 2, hash, 0, 20);
            } else if (multi_hash[0] == 18 && multi_hash[1] == 32 && multi_hash.length == 34) {
                hash = new byte[32];
                System.arraycopy(multi_hash, 2, hash, 0, 32);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hash;
    }

    public static URL getRawURL(String url) {
        int pos;
        if (url.endsWith("]]") && (pos = url.lastIndexOf("[[")) != -1) {
            url = url.substring(0, pos);
        }
        try {
            URL u = new URL(url);
            String protocol = u.getProtocol();
            if (protocol != null && !protocol.isEmpty()) {
                return u;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFriendlyName(URL url, String url_str) {
        int pos;
        if (url_str.endsWith("]]") && (pos = url_str.lastIndexOf("[[")) != -1) {
            return UrlUtils.decode(url_str.substring(pos + 2, url_str.length() - 2));
        }
        try {
            URLConnection con = url.openConnection();
            try {
                if (!(con instanceof URLConnectionExt)) return url.toExternalForm();
                String string = ((URLConnectionExt)((Object)con)).getFriendlyName();
                return string;
            }
            finally {
                if (con instanceof HttpURLConnection) {
                    try {
                        ((HttpURLConnection)con).disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return url.toExternalForm();
    }

    public static boolean isURL(String sURL) {
        return UrlUtils.parseTextForURL(sURL, true) != null;
    }

    public static boolean isURL(String sURL, boolean bGuess) {
        return UrlUtils.parseTextForURL(sURL, true, bGuess) != null;
    }

    public static String parseTextForURL(String text, boolean accept_magnets) {
        return UrlUtils.parseTextForURL(text, accept_magnets, true);
    }

    public static String getURL(String text) {
        return UrlUtils.parseTextForURL(text, false, false);
    }

    public static boolean isInternalProtocol(String url) {
        return (url = url.toLowerCase()).startsWith("magnet:") || url.startsWith("chat:") || url.startsWith("azplug:") || url.startsWith("vuze:") || url.startsWith("biglybt:") || url.startsWith("tor:") || url.startsWith("i2p:");
    }

    public static String parseTextForURL(String text, boolean accept_magnets, boolean guess) {
        String args;
        String textLower;
        String href;
        if (text == null || text.length() < 5) {
            return null;
        }
        if ((text = text.trim()).startsWith("azplug:")) {
            return text;
        }
        if (text.startsWith("chat:")) {
            return "azplug:?id=azbuddy&arg=" + UrlUtils.encode(text);
        }
        if (text.startsWith("tor:") && (href = UrlUtils.parseTextForURL(text.substring(4), false, false)) != null) {
            return "tor:" + href;
        }
        if (text.startsWith("i2p:") && (href = UrlUtils.parseTextForURL(text.substring(4), false, false)) != null) {
            return "i2p:" + href;
        }
        href = UrlUtils.parseHTMLforURL(text);
        if (href != null) {
            return href;
        }
        try {
            text = text.trim();
            text = UrlUtils.decodeIfNeeded(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            textLower = text.toLowerCase();
        }
        catch (Throwable e) {
            textLower = text;
        }
        int max = accept_magnets ? prefixes.length : 5;
        int end = -1;
        int start = textLower.length();
        String strURL = null;
        int i = 0;
        while (i < max) {
            block35: {
                int testBegin = textLower.indexOf(prefixes[i]);
                if (testBegin >= 0 && testBegin < start) {
                    end = text.indexOf("\n", testBegin + prefixes[i].length());
                    String strURLTest = end >= 0 ? text.substring(testBegin, end) : text.substring(testBegin);
                    try {
                        URL parsedURL = new URL(strURLTest);
                        strURL = parsedURL.toExternalForm();
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                        if (i < 5) break block35;
                        strURL = strURLTest;
                    }
                }
            }
            ++i;
        }
        if (strURL != null) {
            char[] chars = strURL.toCharArray();
            int i2 = 0;
            while (i2 < chars.length) {
                if (Character.isWhitespace(chars[i2])) {
                    strURL = strURL.substring(0, i2);
                    break;
                }
                ++i2;
            }
            return strURL;
        }
        if (FileUtil.newFile(text, new String[0]).exists()) {
            return null;
        }
        try {
            URL u = new URL("http://" + text);
            String host = u.getHost();
            if (host != null && AENetworkClassifier.categoriseAddress(host) != "Public") {
                return u.toExternalForm();
            }
        }
        catch (Throwable u) {
            // empty catch block
        }
        if (accept_magnets && (text.startsWith("bc://") || text.startsWith("bctp://"))) {
            return UrlUtils.parseTextForMagnets(text);
        }
        String text_prefix = text;
        String text_suffix = "";
        int a_pos = text_prefix.indexOf(63);
        if (a_pos == -1) {
            a_pos = text_prefix.indexOf(38);
        }
        if (a_pos != -1 && (args = text_prefix.substring(a_pos + 1).trim()).contains("=")) {
            int s_pos = args.indexOf(32);
            if (s_pos != -1) {
                args = args.substring(0, s_pos);
            }
            text_prefix = text_prefix.substring(0, a_pos);
            text_suffix = "&" + args;
        }
        if (accept_magnets) {
            int hex_len;
            int i3 = 0;
            while (i3 < 2) {
                int n = hex_len = i3 == 0 ? 40 : 64;
                if (text_prefix.matches("^[a-fA-F0-9]{" + hex_len + "}$")) {
                    byte[] infohash = ByteFormatter.decodeString(text_prefix.toUpperCase());
                    return String.valueOf(UrlUtils.getMagnetURI(infohash)) + text_suffix;
                }
                String temp_text = text_prefix.replaceAll("\\s+", "");
                if (temp_text.matches("^[a-fA-F0-9]{" + hex_len + "}$")) {
                    byte[] infohash = ByteFormatter.decodeString(temp_text.toUpperCase());
                    return String.valueOf(UrlUtils.getMagnetURI(infohash)) + text_suffix;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < 2) {
                int b32_len;
                int n = b32_len = i3 == 0 ? 32 : 52;
                if (text_prefix.matches("^[a-zA-Z2-7]{" + b32_len + "}$")) {
                    return String.valueOf(UrlUtils.getMagnetURI(Base32.decode(text_prefix))) + text_suffix;
                }
                ++i3;
            }
            if (guess) {
                i3 = 0;
                while (i3 < 2) {
                    hex_len = i3 == 0 ? 40 : 64;
                    int b32_len = i3 == 0 ? 32 : 52;
                    String garbageText = "-" + text + "-";
                    Pattern pattern = Pattern.compile("[^a-zA-Z2-7]([a-zA-Z2-7]{" + b32_len + "})[^a-zA-Z2-7]");
                    Matcher matcher = pattern.matcher(garbageText);
                    if (matcher.find()) {
                        String infohash = matcher.group(1);
                        return UrlUtils.getMagnetURI(Base32.decode(infohash));
                    }
                    pattern = Pattern.compile("[^a-fA-F0-9]([a-fA-F0-9]{" + hex_len + "})[^a-fA-F0-9]");
                    matcher = pattern.matcher(garbageText);
                    if (matcher.find()) {
                        String hash = matcher.group(1);
                        byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
                        return UrlUtils.getMagnetURI(infohash);
                    }
                    ++i3;
                }
            }
        }
        return null;
    }

    public static String parseTextForMagnets(String text) {
        return UrlUtils.parseTextForMagnets(text, true);
    }

    public static String parseTextForMagnets(String text, boolean check_raw_embeded_hashes) {
        String decodeString;
        String magnet;
        String base64;
        byte[] decode;
        if (text.startsWith("magnet:") || text.startsWith("maggot:")) {
            return text;
        }
        int i = 0;
        while (i < 2) {
            int b32_len;
            int hex_len = i == 0 ? 40 : 64;
            int n = b32_len = i == 0 ? 32 : 52;
            if (text.matches("^[a-fA-F0-9]{" + hex_len + "}$")) {
                byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
                return UrlUtils.getMagnetURI(infohash);
            }
            String temp_text = text.replaceAll("\\s+", "");
            if (temp_text.matches("^[a-fA-F0-9]{" + hex_len + "}$")) {
                byte[] infohash = ByteFormatter.decodeString(temp_text.toUpperCase());
                return UrlUtils.getMagnetURI(infohash);
            }
            if (text.matches("^[a-zA-Z2-7]{" + b32_len + "}$")) {
                return UrlUtils.getMagnetURI(Base32.decode(text));
            }
            ++i;
        }
        Pattern pattern = Pattern.compile("magnet:\\?[a-z%0-9=_:&.]+", 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        pattern = Pattern.compile("maggot://[a-z0-9]+:[a-z0-9]", 2);
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        pattern = Pattern.compile("bc://bt/([a-z0-9=\\+/]+)", 2);
        matcher = pattern.matcher(text.replaceAll(" ", "+"));
        if (matcher.find() && (decode = Base64.decode(base64 = matcher.group(1))) != null && decode.length > 0) {
            try {
                String hash;
                String magnet2;
                String decodeString2 = new String(decode, "utf8");
                pattern = Pattern.compile("AA.*/(.*)/ZZ", 2);
                matcher = pattern.matcher(decodeString2);
                if (matcher.find() && (magnet2 = UrlUtils.parseTextForMagnets(hash = matcher.group(1))) != null) {
                    pattern = Pattern.compile("AA/(.*)/[0-9]+", 2);
                    matcher = pattern.matcher(decodeString2);
                    if (matcher.find()) {
                        String name = matcher.group(1);
                        return String.valueOf(magnet2) + "&dn=" + UrlUtils.encode(name);
                    }
                    return magnet2;
                }
            }
            catch (UnsupportedEncodingException decodeString2) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("bctp://task/(.*)", 2)).matcher(text)).find() && (magnet = UrlUtils.parseTextForMagnets(decodeString = matcher.group(1))) != null) {
            pattern = Pattern.compile("(.*)/[0-9]+", 2);
            matcher = pattern.matcher(decodeString);
            if (matcher.find()) {
                String name = matcher.group(1);
                return String.valueOf(magnet) + "&dn=" + UrlUtils.encode(name);
            }
            return magnet;
        }
        if (check_raw_embeded_hashes) {
            String garbageText = "-" + text + "-";
            int i2 = 0;
            while (i2 < 2) {
                String hash;
                int hex_len = i2 == 0 ? 40 : 64;
                int b32_len = i2 == 0 ? 32 : 52;
                pattern = Pattern.compile("[^a-zA-Z2-7]([a-zA-Z2-7]{" + b32_len + "})[^a-zA-Z2-7]");
                matcher = pattern.matcher(garbageText);
                if (matcher.find()) {
                    hash = matcher.group(1);
                    return UrlUtils.getMagnetURI(Base32.decode(hash));
                }
                pattern = Pattern.compile("[^a-fA-F0-9]([a-fA-F0-9]{" + hex_len + "})[^a-fA-F0-9]");
                matcher = pattern.matcher(garbageText);
                if (matcher.find()) {
                    hash = matcher.group(1);
                    byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
                    return UrlUtils.getMagnetURI(infohash);
                }
                ++i2;
            }
        }
        return null;
    }

    private static String parseHTMLforURL(String text) {
        if (text == null) {
            return null;
        }
        Pattern pat = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher m = pat.matcher(text);
        if (m.find()) {
            String sURL = m.group(1);
            try {
                sURL = UrlUtils.decodeIfNeeded(sURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sURL;
        }
        return null;
    }

    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
            return s;
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return "";
        }
        try {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (IllegalArgumentException e) {
                int pos = s.lastIndexOf("%");
                if (pos >= s.length() - 2) {
                    return URLDecoder.decode(s.substring(0, pos), "UTF-8");
                }
                throw e;
            }
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
            return s;
        }
    }

    public static String decodeIfNeeded(String s) {
        if (s == null) {
            return "";
        }
        try {
            int q_pos = s.indexOf(63);
            int a_pos = s.indexOf(38);
            if (q_pos == -1 && a_pos == -1) {
                return UrlUtils.decode(s);
            }
            int start = Math.min(q_pos, a_pos);
            return String.valueOf(UrlUtils.decode(s.substring(0, start))) + s.substring(start);
        }
        catch (Throwable e) {
            return s;
        }
    }

    public static String escapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        int i = 0;
        while (i < XMLescapes.length) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[0], escapeEntry[1]);
            ++i;
        }
        return ret;
    }

    public static String unescapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        int i = 0;
        while (i < XMLescapes.length) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[1], escapeEntry[0]);
            ++i;
        }
        return ret;
    }

    public static String convertIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            int zone_index = host.indexOf(37);
            if (zone_index != -1) {
                host = String.valueOf(host.substring(0, zone_index)) + UrlUtils.encode(host.substring(zone_index));
            }
            return "[" + host + "]";
        }
        return host;
    }

    public static String expandIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            try {
                return InetAddress.getByAddress(InetAddress.getByName(host).getAddress()).getHostAddress();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return host;
    }

    public static String resolveIPv6Host(String url) throws Exception {
        String str = url;
        try {
            DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
            URL http_server_url = new URL(url);
            str = http_server_url.getHost();
            return UrlUtils.setHost(http_server_url, "[" + dns_utils.getIPV6ByName(http_server_url.getHost()).getHostAddress() + "]").toExternalForm();
        }
        catch (Throwable e) {
            throw new Exception("Failed to resolve IPv6 address for '" + str + "'");
        }
    }

    public static String resolveIPv4Host(String url) {
        try {
            DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
            URL http_server_url = new URL(url);
            return UrlUtils.setHost(http_server_url, dns_utils.getIPV4ByName(http_server_url.getHost()).getHostAddress()).toExternalForm();
        }
        catch (Throwable e) {
            Debug.out(e);
            return url;
        }
    }

    public static void connectWithTimeout(URLConnection connection, long connect_timeout) throws IOException {
        UrlUtils.connectWithTimeouts(connection, connect_timeout, -1L);
    }

    public static void connectWithTimeouts(URLConnection connection, long connect_timeout, long read_timeout) throws IOException {
        if (connect_timeout != -1L) {
            connection.setConnectTimeout((int)connect_timeout);
        }
        if (read_timeout != -1L) {
            connection.setReadTimeout((int)read_timeout);
        }
        connection.connect();
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String referer) {
        UrlUtils.setBrowserHeaders(rd, null, referer);
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            int i = 0;
            while (i < headers.length) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos != -1) {
                    String lhs = header.substring(0, pos).trim();
                    String rhs = header.substring(pos + 1).trim();
                    if (!lhs.equalsIgnoreCase("Host") && !lhs.equalsIgnoreCase("Referer")) {
                        rd.setProperty("URL_" + lhs, rhs);
                    }
                }
                ++i;
            }
            if (referer != null && referer.length() > 0) {
                rd.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(ResourceUploader ru, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            int i = 0;
            while (i < headers.length) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos != -1) {
                    String lhs = header.substring(0, pos).trim();
                    String rhs = header.substring(pos + 1).trim();
                    if (!lhs.equalsIgnoreCase("Host") && !lhs.equalsIgnoreCase("Referer")) {
                        ru.setProperty("URL_" + lhs, rhs);
                    }
                }
                ++i;
            }
            if (referer != null && referer.length() > 0) {
                ru.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(URLConnection connection, String referer) {
        UrlUtils.setBrowserHeaders(connection, null, referer);
    }

    public static void setBrowserHeaders(URLConnection connection, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            int i = 0;
            while (i < headers.length) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos != -1) {
                    String lhs = header.substring(0, pos).trim();
                    String rhs = header.substring(pos + 1).trim();
                    if (!lhs.equalsIgnoreCase("Host") && !lhs.equalsIgnoreCase("Referer")) {
                        connection.setRequestProperty(lhs, rhs);
                    }
                }
                ++i;
            }
            if (referer != null && referer.length() > 0) {
                connection.setRequestProperty("Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Map getBrowserHeaders(String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(null);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            int i = 0;
            while (i < headers.length) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos != -1) {
                    String lhs = header.substring(0, pos).trim();
                    String rhs = header.substring(pos + 1).trim();
                    if (!lhs.equalsIgnoreCase("Host") && !lhs.equalsIgnoreCase("Referer")) {
                        result.put(lhs, rhs);
                    }
                }
                ++i;
            }
            if (referer != null && referer.length() > 0) {
                result.put("Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBrowserHeadersToUse(String encoded_headers) {
        String headers_to_use = encoded_headers;
        Class<UrlUtils> clazz = UrlUtils.class;
        synchronized (UrlUtils.class) {
            if (headers_to_use == null) {
                headers_to_use = last_headers != null ? last_headers : default_headers;
            } else {
                if (last_headers == null || !headers_to_use.equals(last_headers)) {
                    COConfigurationManager.setParameter("metasearch.web.last.headers", headers_to_use);
                }
                last_headers = headers_to_use;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return headers_to_use;
        }
    }

    public static boolean queryHasParameter(String query_string, String param_name, boolean case_sensitive) {
        if (!case_sensitive) {
            query_string = query_string.toLowerCase();
            param_name = param_name.toLowerCase();
        }
        if (query_string.charAt(0) == '?') {
            query_string = String.valueOf('&') + query_string.substring(1);
        } else if (query_string.charAt(0) != '&') {
            query_string = String.valueOf('&') + query_string;
        }
        return query_string.contains("&" + param_name + "=");
    }

    public static boolean containsPasskey(URL url) {
        if (url == null) {
            return false;
        }
        String url_str = url.toExternalForm();
        return url_str.matches(".*[0-9a-z]{20,40}.*");
    }

    public static URL setPort(URL u, int port) {
        if (port == -1) {
            port = u.getDefaultPort();
        }
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            if ((pos = authority.lastIndexOf(58)) == -1) {
                if (port > 0) {
                    result.append(authority).append(":").append(port);
                } else {
                    result.append(authority);
                }
            } else if (port > 0) {
                result.append(authority.substring(0, pos + 1)).append(port);
            } else {
                result.append(authority.substring(0, pos));
            }
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL setHost(URL u, String host) {
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            if ((pos = authority.lastIndexOf(58)) == -1) {
                result.append(host);
            } else {
                result.append(host).append(authority.substring(pos));
            }
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL setProtocol(URL u, String protocol) {
        String str = u.toExternalForm();
        int pos = str.indexOf(":");
        try {
            return new URL(String.valueOf(protocol) + str.substring(pos));
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL getBaseURL(URL u) {
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            pos = authority.lastIndexOf(58);
            int port = u.getPort();
            if (port == -1) {
                port = u.getDefaultPort();
            }
            if (pos == -1) {
                result.append(authority).append(":").append(port);
            } else {
                result.append(authority.substring(0, pos + 1)).append(port);
            }
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static String getCanonicalString(String str) {
        try {
            return UrlUtils.getCanonicalString(new URL(str));
        }
        catch (Throwable throwable) {
            return str;
        }
    }

    public static String getCanonicalString(URL url) {
        int default_port;
        int port;
        String protocol = url.getProtocol();
        if (!protocol.equals(protocol.toLowerCase(Locale.US))) {
            protocol = protocol.toLowerCase(Locale.US);
            url = UrlUtils.setProtocol(url, protocol);
        }
        if ((port = url.getPort()) == (default_port = url.getDefaultPort())) {
            url = UrlUtils.setPort(url, 0);
        }
        return url.toExternalForm();
    }

    public static URL getIPV4Fallback(URL url) {
        try {
            InetAddress[] addresses = AddressUtils.getAllByName(url.getHost());
            if (addresses.length > 0) {
                InetAddress ipv4 = null;
                InetAddress ipv6 = null;
                InetAddress[] inetAddressArray = addresses;
                int n = addresses.length;
                int n2 = 0;
                while (n2 < n) {
                    InetAddress a = inetAddressArray[n2];
                    if (a instanceof Inet4Address) {
                        ipv4 = a;
                    } else {
                        ipv6 = a;
                    }
                    ++n2;
                }
                if (ipv4 != null && ipv6 != null) {
                    url = UrlUtils.setHost(url, ipv4.getHostAddress());
                    return url;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static long getContentLength(URLConnection con) {
        long res = con.getContentLength();
        if (res == -1L) {
            try {
                String str = con.getHeaderField("content-length");
                if (str != null) {
                    res = Long.parseLong(str);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return res;
    }

    public static boolean SSLSocketSNIHack(String host_name, SSLSocket socket) {
        try {
            SNIHostName serverName = new SNIHostName(host_name);
            ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
            serverNames.add(serverName);
            SSLParameters params = socket.getSSLParameters();
            params.setServerNames(serverNames);
            socket.setSSLParameters(params);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static SSLSocketFactory DHHackIt(final SSLSocketFactory factory) {
        SSLSocketFactory hack = new SSLSocketFactory(){

            @Override
            public Socket createSocket() throws IOException {
                Socket result = factory.createSocket();
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                Socket result = factory.createSocket(address, port, localAddress, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                Socket result = factory.createSocket(s, host, port, autoClose);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port, localHost, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                String[] result = factory.getDefaultCipherSuites();
                result = this.hack(result);
                return result;
            }

            @Override
            public String[] getSupportedCipherSuites() {
                String[] result = factory.getSupportedCipherSuites();
                result = this.hack(result);
                return result;
            }

            private void hack(Socket socket) {
                SSLSocket ssl_socket = (SSLSocket)socket;
                ssl_socket.setEnabledCipherSuites(this.hack(ssl_socket.getEnabledCipherSuites()));
            }

            private String[] hack(String[] cs) {
                ArrayList<String> new_cs = new ArrayList<String>();
                String[] stringArray = cs;
                int n = cs.length;
                int n2 = 0;
                while (n2 < n) {
                    String x = stringArray[n2];
                    if (!x.contains("_DH_") && !x.contains("_DHE_")) {
                        new_cs.add(x);
                    }
                    ++n2;
                }
                return new_cs.toArray(new String[new_cs.size()]);
            }
        };
        return hack;
    }

    public static void HTTPSURLConnectionSNIHack(final String host_name, HttpsURLConnection con) {
        final SSLSocketFactory factory = con.getSSLSocketFactory();
        SSLSocketFactory hack = new SSLSocketFactory(){

            @Override
            public Socket createSocket() throws IOException {
                Socket result = factory.createSocket();
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                Socket result = factory.createSocket(address, port, localAddress, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                Socket result = factory.createSocket(s, host, port, autoClose);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port, localHost, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                String[] result = factory.getDefaultCipherSuites();
                result = this.hack(result);
                return result;
            }

            @Override
            public String[] getSupportedCipherSuites() {
                String[] result = factory.getSupportedCipherSuites();
                result = this.hack(result);
                return result;
            }

            private void hack(Socket socket) {
                SSLSocket ssl_socket = (SSLSocket)socket;
                UrlUtils.SSLSocketSNIHack(host_name, ssl_socket);
            }

            private String[] hack(String[] cs) {
                return cs;
            }
        };
        con.setSSLSocketFactory(hack);
    }

    public static void DHHackIt(HttpsURLConnection ssl_con) {
        SSLSocketFactory factory = ssl_con.getSSLSocketFactory();
        SSLSocketFactory hack = UrlUtils.DHHackIt(factory);
        ssl_con.setSSLSocketFactory(hack);
    }

    public static Socket connectSocketAndWrite(boolean is_ssl, String target_host, int target_port, byte[] bytes, int connect_timeout, int read_timeout) throws Throwable {
        return UrlUtils.connectSocketAndWrite(is_ssl, target_host, target_port, bytes, connect_timeout, read_timeout, false);
    }

    public static Socket connectSocketAndWrite(boolean is_ssl, String target_host, int target_port, byte[] bytes, int connect_timeout, int read_timeout, boolean unconnected_socket_hack) throws Throwable {
        List<InetAddress[]> binds = NetworkAdmin.getSingleton().getSingleHomedServiceBindings(target_host);
        Throwable last_error = null;
        for (InetAddress[] bind : binds) {
            try {
                return UrlUtils.connectSocketAndWrite(is_ssl, target_host, bind[1], bind[0], target_port, bytes, connect_timeout, read_timeout, unconnected_socket_hack);
            }
            catch (Throwable e) {
                last_error = e;
            }
        }
        if (last_error != null) {
            throw last_error;
        }
        throw new Exception("hmm");
    }

    public static Socket connectSocketAndWrite(boolean is_ssl, String target_host_name, InetAddress bind_ip, InetAddress target_host, int target_port, byte[] bytes, int connect_timeout, int read_timeout, boolean unconnected_socket_hack) throws Throwable {
        boolean cert_hack = false;
        boolean dh_hack = false;
        boolean internal_error_hack = false;
        boolean hacks_to_do = true;
        Exception last_error = null;
        while (hacks_to_do) {
            hacks_to_do = false;
            Socket target = null;
            boolean ok = false;
            try {
                InetSocketAddress targetSockAddress = new InetSocketAddress(target_host, target_port);
                if (is_ssl) {
                    TrustManager[] tms_delegate = SESecurityManager.getAllTrustingTrustManager();
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, tms_delegate, RandomUtils.SECURE_RANDOM);
                    SSLSocketFactory factory = sc.getSocketFactory();
                    factory = dh_hack ? UrlUtils.DHHackIt(factory) : UrlUtils.DHHackIt(factory);
                    target = unconnected_socket_hack ? (bind_ip == null ? factory.createSocket(targetSockAddress.getAddress(), targetSockAddress.getPort()) : factory.createSocket(targetSockAddress.getAddress(), targetSockAddress.getPort(), bind_ip, 0)) : factory.createSocket();
                } else {
                    target = unconnected_socket_hack ? (bind_ip == null ? new Socket(targetSockAddress.getAddress(), targetSockAddress.getPort()) : new Socket(targetSockAddress.getAddress(), targetSockAddress.getPort(), bind_ip, 0)) : new Socket();
                }
                if (internal_error_hack) {
                    UrlUtils.SSLSocketSNIHack(target_host_name, (SSLSocket)target);
                }
                target.setSoTimeout(read_timeout);
                if (!unconnected_socket_hack) {
                    if (bind_ip != null) {
                        target.bind(new InetSocketAddress(bind_ip, 0));
                    }
                    target.connect(targetSockAddress, connect_timeout);
                }
                target.getOutputStream().write(bytes);
                ok = true;
                Socket socket = target;
                return socket;
            }
            catch (Exception e) {
                last_error = e;
                if (e instanceof SSLException) {
                    String msg = Debug.getNestedExceptionMessage(e);
                    if (msg.contains("DH keypair")) {
                        if (!dh_hack) {
                            dh_hack = true;
                            hacks_to_do = true;
                        }
                    } else if ((msg.contains("internal_error") || msg.contains("handshake_failure")) && !internal_error_hack) {
                        internal_error_hack = true;
                        hacks_to_do = true;
                    }
                    if (!cert_hack) {
                        cert_hack = true;
                        SESecurityManager.installServerCertificates(new URL("https://" + target_host.getHostAddress() + ":" + target_port + "/"));
                        hacks_to_do = true;
                    }
                }
                if (hacks_to_do) continue;
                throw e;
            }
            finally {
                if (!ok && target != null) {
                    target.close();
                }
            }
        }
        throw last_error;
    }

    public static List<InetSocketAddress> getURLAddresses(URL url) {
        int port;
        String host = url.getHost();
        int n = port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        if (port == -1) {
            port = 80;
        }
        List<InetAddress> addresses = null;
        try {
            addresses = DNSUtils.getSingleton().getAllByName(host);
        }
        catch (Throwable e) {
            try {
                addresses = Arrays.asList(InetAddress.getAllByName(host));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        if (addresses == null) {
            result.add(new InetSocketAddress(host, port));
        } else {
            for (InetAddress ia : addresses) {
                result.add(new InetSocketAddress(ia, port));
            }
        }
        return result;
    }
}

