/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.dns;

import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class DNSUtilsImpl
implements DNSUtils.DNSUtilsIntf {
    private static final String[] REC_ALL = new String[]{"A", "AAAA", "CNAME"};
    private static final String[] REC_V4 = new String[]{"A", "CNAME"};
    private static final String[] REC_V6 = new String[]{"AAAA", "CNAME"};
    private static final Map<String, String> test_records = new HashMap<String, String>();

    static {
        test_records.put("test1.test.null", "BITTORRENT DENY ALL");
        test_records.put("test2.test.null", "BITTORRENT");
        test_records.put("test3.test.null", "BITTORRENT TCP:1 TCP:2 UDP:1 UDP:2");
        test_records.put("test4.test.null", "BITTORRENT TCP:3");
        test_records.put("test5.test.null", "BITTORRENT UDP:4");
    }

    private static String getFactory() {
        return System.getProperty("azureus.dns.context.factory", "com.sun.jndi.dns.DnsContextFactory");
    }

    @Override
    public DNSDirContextImpl getInitialDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", DNSUtilsImpl.getFactory());
        return new DNSDirContextImpl(new InitialDirContext(env));
    }

    @Override
    public DNSDirContextImpl getDirContextForServer(String dns_server_ip) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", DNSUtilsImpl.getFactory());
        env.put("java.naming.provider.url", "dns://" + dns_server_ip + "/");
        return new DNSDirContextImpl(new InitialDirContext(env));
    }

    @Override
    public Inet6Address getIPV6ByName(String host) throws UnknownHostException {
        List<Inet6Address> all = this.getAllIPV6ByName(host);
        return all.get(0);
    }

    @Override
    public Inet4Address getIPV4ByName(String host) throws UnknownHostException {
        List<Inet4Address> all = this.getAllIPV4ByName(host);
        return all.get(0);
    }

    public List<Inet6Address> getAllIPV6ByName(String host) throws UnknownHostException {
        try {
            List<InetAddress> result = this.getAllByName(this.getInitialDirContext(), host, REC_V6);
            if (result.size() > 0) {
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new UnknownHostException(host);
    }

    public List<Inet4Address> getAllIPV4ByName(String host) throws UnknownHostException {
        try {
            List<InetAddress> result = this.getAllByName(this.getInitialDirContext(), host, REC_V4);
            if (result.size() > 0) {
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new UnknownHostException(host);
    }

    @Override
    public List<InetAddress> getAllByName(String host) throws UnknownHostException {
        try {
            return this.getAllByName(this.getInitialDirContext(), host);
        }
        catch (NamingException e) {
            throw new UnknownHostException(host);
        }
    }

    @Override
    public List<InetAddress> getAllByName(DNSUtils.DNSDirContext context2, String host) throws UnknownHostException {
        List<InetAddress> result = this.getAllByName(context2, host, REC_ALL);
        if (result.size() > 0) {
            return result;
        }
        throw new UnknownHostException(host);
    }

    private List<InetAddress> getAllByName(DNSUtils.DNSDirContext context2, String host, String[] attributes) throws UnknownHostException {
        if (AENetworkClassifier.categoriseAddress(host) != "Public") {
            throw new UnknownHostException(host);
        }
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        this.getAllByNameSupport(context2, host, attributes, 1, result);
        return result;
    }

    private void getAllByNameSupport(DNSUtils.DNSDirContext context2, String host, String[] attributes, int depth, List<InetAddress> result) throws UnknownHostException {
        if (depth > 16) {
            return;
        }
        try {
            Attributes attrs = ((DNSDirContextImpl)context2).ctx.getAttributes(host, attributes);
            if (attrs != null) {
                NamingEnumeration<String> ids = attrs.getIDs();
                while (ids.hasMore()) {
                    Attribute attr;
                    String id = ids.next();
                    boolean wanted = false;
                    String[] stringArray = attributes;
                    int n = attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String a = stringArray[n2];
                        if (id.equalsIgnoreCase(a)) {
                            wanted = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!wanted || (attr = attrs.get(id)) == null) continue;
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMore()) {
                        Object _value = values.next();
                        if (!(_value instanceof String)) continue;
                        String value = (String)_value;
                        if (id.equalsIgnoreCase("cname")) {
                            this.getAllByNameSupport(context2, value, attributes, depth + 1, result);
                            continue;
                        }
                        try {
                            result.add(InetAddress.getByName(value));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public List<String> getTXTRecords(String query) {
        ArrayList<String> result;
        block17: {
            result = new ArrayList<String>();
            String test_reply = test_records.get(query);
            if (test_reply != null) {
                result.add(test_reply);
                return result;
            }
            DirContext context2 = null;
            try {
                try {
                    context2 = this.getInitialDirContext().ctx;
                    Attributes attrs = context2.getAttributes(query, new String[]{"TXT"});
                    NamingEnumeration<? extends Attribute> n_enum = attrs.getAll();
                    while (n_enum.hasMoreElements()) {
                        Attribute attr = n_enum.next();
                        NamingEnumeration<?> n_enum2 = attr.getAll();
                        while (n_enum2.hasMoreElements()) {
                            String attribute = (String)n_enum2.nextElement();
                            if (attribute == null) continue;
                            if ((attribute = attribute.trim()).startsWith("\"")) {
                                attribute = attribute.substring(1);
                            }
                            if (attribute.endsWith("\"")) {
                                attribute = attribute.substring(0, attribute.length() - 1);
                            }
                            if (attribute.length() <= 0) continue;
                            result.add(attribute);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (context2 == null) break block17;
                    try {
                        context2.close();
                    }
                    catch (Throwable throwable2) {}
                }
            }
            finally {
                if (context2 != null) {
                    try {
                        context2.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getTXTRecord(String query) throws UnknownHostException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        try {
            DNSUtilsImpl impl = new DNSUtilsImpl();
            DNSDirContextImpl ctx = impl.getDirContextForServer("8.8.4.4");
            System.out.println(impl.getAllByName(ctx, "www.google.com"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class DNSDirContextImpl
    implements DNSUtils.DNSDirContext {
        final DirContext ctx;

        private DNSDirContextImpl(DirContext _ctx) {
            this.ctx = _ctx;
        }

        @Override
        public String getString() {
            try {
                return String.valueOf(this.ctx.getEnvironment());
            }
            catch (Throwable e) {
                return Debug.getNestedExceptionMessage(e);
            }
        }
    }
}

