/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.protocol.chat;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.util.protocol.URLConnectionExt;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Locale;

public class Handler
extends URLStreamHandler {
    @Override
    public URLConnection openConnection(URL u) throws IOException {
        return new Connection(u);
    }

    @Override
    public URLConnection openConnection(URL u, Proxy proxy) throws IOException {
        return new Connection(u);
    }

    private class Connection
    extends HttpURLConnection
    implements URLConnectionExt {
        Connection(URL u) {
            super(u);
            this.url = u;
        }

        @Override
        public String getFriendlyName() {
            String url_str = this.url.toExternalForm();
            String lc_url_str = url_str.toLowerCase(Locale.US);
            if (lc_url_str.startsWith("chat:")) {
                int pos;
                boolean anon = lc_url_str.startsWith("chat:anon:");
                String rem = url_str.substring(anon ? 10 : 5);
                if (rem.startsWith("?")) {
                    rem = rem.substring(1);
                }
                if ((pos = (rem = UrlUtils.decode(rem)).indexOf(91)) != -1) {
                    rem = rem.substring(0, pos);
                }
                return String.valueOf(MessageText.getString(anon ? "label.anon.chat" : "label.public.chat")) + " - " + rem;
            }
            return url_str;
        }

        @Override
        public void connect() throws IOException {
            throw new IOException("chat: URIs can't be used directly");
        }

        @Override
        public void disconnect() {
        }

        @Override
        public boolean usingProxy() {
            return false;
        }
    }
}

