/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.protocol.magnet;

import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.util.protocol.URLConnectionExt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MagnetConnection2
extends HttpURLConnection
implements URLConnectionExt {
    private static final String NL = "\r\n";
    static final LinkedList<MagnetOutputStream> active_os = new LinkedList();
    private static TimerEventPeriodic active_os_event;
    private final MagnetHandler handler;
    private OutputStream output_stream;
    private InputStream input_stream;
    private final LinkedList<String> status_list = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addActiveStream(MagnetOutputStream os) {
        LinkedList<MagnetOutputStream> linkedList = active_os;
        synchronized (linkedList) {
            active_os.add(os);
            if (active_os.size() == 1 && active_os_event == null) {
                active_os_event = SimpleTimer.addPeriodicEvent("mos:checker", 30000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        ArrayList<MagnetOutputStream> active;
                        LinkedList<MagnetOutputStream> linkedList = active_os;
                        synchronized (linkedList) {
                            active = new ArrayList<MagnetOutputStream>(active_os);
                        }
                        for (MagnetOutputStream os : active) {
                            os.timerCheck();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeActiveStream(MagnetOutputStream os) {
        LinkedList<MagnetOutputStream> linkedList = active_os;
        synchronized (linkedList) {
            active_os.remove(os);
            if (active_os.size() == 0 && active_os_event != null) {
                active_os_event.cancel();
                active_os_event = null;
            }
        }
    }

    public MagnetConnection2(URL _url, MagnetHandler _handler) {
        super(_url);
        this.handler = _handler;
    }

    @Override
    public String getFriendlyName() {
        try {
            String str = this.url.toExternalForm();
            Map<String, String> args = UrlUtils.decodeArgs(str.substring(str.indexOf(63) + 1));
            String name = args.get("dn");
            if (name == null) {
                name = args.get("xt");
            }
            if (name != null) {
                return "magnet - " + name;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.url.toExternalForm();
    }

    @Override
    public void connect() throws IOException {
        MagnetOutputStream mos = new MagnetOutputStream();
        MagnetInputStream mis = new MagnetInputStream(mos);
        this.input_stream = mis;
        this.output_stream = mos;
        this.handler.process(this.getURL(), mos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        int len;
        String line = "";
        byte[] buffer = new byte[1];
        byte[] line_bytes = new byte[2048];
        int line_bytes_pos = 0;
        while ((len = this.input_stream.read(buffer)) != -1) {
            line = String.valueOf(line) + (char)buffer[0];
            line_bytes[line_bytes_pos++] = buffer[0];
            if (!line.endsWith(NL)) continue;
            if ((line = line.trim()).length() == 0) break;
            if (line.startsWith("X-Report:")) {
                line = new String(line_bytes, 0, line_bytes_pos, "UTF-8");
                line = line.substring(9);
                line = line.trim();
                LinkedList<String> linkedList = this.status_list;
                synchronized (linkedList) {
                    String str = String.valueOf(Character.toUpperCase(line.charAt(0))) + line.substring(1);
                    if (this.status_list.size() == 0) {
                        this.status_list.addLast(str);
                    } else if (!this.status_list.getLast().equals(str)) {
                        this.status_list.addLast(str);
                    }
                }
            }
            line = "";
            line_bytes_pos = 0;
        }
        return this.input_stream;
    }

    @Override
    public int getResponseCode() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResponseMessage() {
        LinkedList<String> linkedList = this.status_list;
        synchronized (linkedList) {
            block5: {
                if (this.status_list.size() != 0) break block5;
                return "";
            }
            if (this.status_list.size() == 1) {
                return this.status_list.get(0);
            }
            return this.status_list.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResponseMessages(boolean error_only) {
        LinkedList<String> linkedList = this.status_list;
        synchronized (linkedList) {
            if (error_only) {
                ArrayList<String> response = new ArrayList<String>();
                for (String s : this.status_list) {
                    if (!s.toLowerCase().startsWith("error:")) continue;
                    response.add(s);
                }
                return response;
            }
            return new ArrayList<String>(this.status_list);
        }
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void disconnect() {
        try {
            if (this.output_stream != null) {
                this.output_stream.close();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            if (this.input_stream != null) {
                this.input_stream.close();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static interface MagnetHandler {
        public void process(URL var1, OutputStream var2) throws IOException;
    }

    private static class MagnetInputStream
    extends InputStream {
        private final MagnetOutputStream out;

        private MagnetInputStream(MagnetOutputStream _out) {
            this.out = _out;
        }

        @Override
        public int read() throws IOException {
            return this.out.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.out.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.out.available();
        }

        @Override
        public long skip(long n) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private class MagnetOutputStream
    extends OutputStream {
        private final LinkedList<byte[]> buffers = new LinkedList();
        private int available;
        private final AESemaphore buffer_sem = new AESemaphore("mos:buffers");
        private boolean closed;
        private long last_read = SystemTime.getMonotonousTime();
        private int read_active;

        private MagnetOutputStream() {
            MagnetConnection2.addActiveStream(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timerCheck() {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                if (this.closed || this.read_active > 0 || SystemTime.getMonotonousTime() - this.last_read < 60000L) {
                    return;
                }
            }
            Debug.out("Abandoning magnet download for " + MagnetConnection2.this.getURL() + " as no active reader");
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                if (this.closed) {
                    throw new IOException("Connection closed");
                }
                this.buffers.addLast(new byte[]{(byte)b});
                ++this.available;
                this.buffer_sem.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                if (this.closed) {
                    throw new IOException("Connection closed");
                }
                if (len > 0) {
                    byte[] new_b = new byte[len];
                    System.arraycopy(b, off, new_b, 0, len);
                    this.buffers.addLast(new_b);
                    this.available += len;
                    this.buffer_sem.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read() throws IOException {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                this.last_read = SystemTime.getMonotonousTime();
                ++this.read_active;
            }
            try {
                this.buffer_sem.reserve();
            }
            catch (Throwable throwable) {
                LinkedList<byte[]> linkedList2 = this.buffers;
                synchronized (linkedList2) {
                    this.last_read = SystemTime.getMonotonousTime();
                    --this.read_active;
                }
                throw throwable;
            }
            LinkedList<byte[]> linkedList3 = this.buffers;
            synchronized (linkedList3) {
                this.last_read = SystemTime.getMonotonousTime();
                --this.read_active;
            }
            linkedList = this.buffers;
            synchronized (linkedList) {
                block17: {
                    if (!this.closed || this.buffers.size() != 0) break block17;
                    return -1;
                }
                byte[] b = this.buffers.removeFirst();
                if (b.length > 1) {
                    int i = b.length - 1;
                    while (i > 0) {
                        this.buffers.addFirst(new byte[]{b[i]});
                        this.buffer_sem.release();
                        --i;
                    }
                }
                --this.available;
                return b[0] & 0xFF;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read(byte[] buffer, int off, int len) throws IOException {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                this.last_read = SystemTime.getMonotonousTime();
                ++this.read_active;
            }
            try {
                this.buffer_sem.reserve();
            }
            catch (Throwable throwable) {
                LinkedList<byte[]> linkedList2 = this.buffers;
                synchronized (linkedList2) {
                    this.last_read = SystemTime.getMonotonousTime();
                    --this.read_active;
                }
                throw throwable;
            }
            LinkedList<byte[]> linkedList3 = this.buffers;
            synchronized (linkedList3) {
                this.last_read = SystemTime.getMonotonousTime();
                --this.read_active;
            }
            linkedList = this.buffers;
            synchronized (linkedList) {
                int read = 0;
                do {
                    if (this.closed && this.buffers.size() == 0) {
                        return read == 0 ? -1 : read;
                    }
                    byte[] b = this.buffers.removeFirst();
                    int b_len = b.length;
                    if (b_len >= len) {
                        read += len;
                        System.arraycopy(b, 0, buffer, off, len);
                        if (b_len <= len) break;
                        byte[] new_b = new byte[b_len - len];
                        System.arraycopy(b, len, new_b, 0, new_b.length);
                        this.buffers.addFirst(new_b);
                        this.buffer_sem.release();
                        break;
                    }
                    read += b_len;
                    System.arraycopy(b, 0, buffer, off, b_len);
                    off += b_len;
                    len -= b_len;
                } while (this.buffer_sem.reserveIfAvailable());
                this.available -= read;
                return read;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int available() throws IOException {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                if (this.available > 0) {
                    return this.available;
                }
                if (this.closed) {
                    throw new IOException("Connection closed");
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            LinkedList<byte[]> linkedList = this.buffers;
            synchronized (linkedList) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.buffer_sem.releaseForever();
            }
            MagnetConnection2.removeActiveStream(this);
        }
    }
}

