/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util.protocol.trackerlist;

import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TrackerListURLConnection
extends HttpURLConnection {
    private static final String NL = "\r\n";
    private final String list_url;
    private boolean loaded;
    private String list;
    private IOException error;
    private static Map<String, Long> last_downloads = new HashMap<String, Long>();

    public TrackerListURLConnection(URL _url) {
        super(_url);
        this.list_url = _url.toExternalForm().substring(12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        TrackerListURLConnection trackerListURLConnection = this;
        synchronized (trackerListURLConnection) {
            if (!this.loaded) {
                this.loaded = true;
                try {
                    this.list = TrackerListURLConnection.readList(this.list_url);
                }
                catch (IOException e) {
                    this.error = e;
                }
            }
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return new ByteArrayInputStream(this.list.getBytes("UTF-8"));
    }

    @Override
    public int getResponseCode() {
        try {
            this.connect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.list == null ? 500 : 200;
    }

    @Override
    public String getResponseMessage() throws IOException {
        try {
            this.connect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.error == null ? "OK" : Debug.getNestedExceptionMessage(this.error);
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void disconnect() {
    }

    private static synchronized String readList(String url_str) throws IOException {
        String string;
        if (url_str.contains("info_hash=")) {
            throw new IOException("Tracker list URLs can't be directly used as announce URLs");
        }
        String key = "tl_" + Base32.encode(url_str.getBytes("UTF-8")) + ".txt";
        long now = SystemTime.getMonotonousTime();
        URL url = new URL(url_str);
        boolean do_cache = !url.getProtocol().equals("file");
        File cache_dir = FileUtil.newFile(SystemProperties.getUserPath(), "cache");
        if (!cache_dir.exists()) {
            cache_dir.mkdirs();
        }
        File cache_file = FileUtil.newFile(cache_dir, key);
        if (do_cache) {
            long cache_time = cache_file.exists() ? 3600000 : 300000;
            Long last = last_downloads.get(key);
            if (last != null && now - last < cache_time) {
                if (cache_file.exists()) {
                    try {
                        String result = FileUtil.readFileAsString(cache_file, 32768, "UTF-8");
                        return result;
                    }
                    catch (Throwable e) {
                        cache_file.delete();
                    }
                } else {
                    return "";
                }
            }
            last_downloads.put(key, now);
        }
        ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(url);
        rd.setProperty("URL_Connect_Timeout", 20000);
        rd.setProperty("URL_Read_Timeout", 10000);
        InputStream is = rd.download();
        try {
            String result = FileUtil.readInputStreamAsString(is, 32768, "UTF-8");
            if (do_cache) {
                FileUtil.writeStringAsFile(cache_file, result);
            }
            string = result;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(true, 3, "Failed to load Tracker List from  '" + url_str + "'", e));
                if (do_cache && cache_file.exists()) {
                    try {
                        String result = FileUtil.readFileAsString(cache_file, 32768, "UTF-8");
                        return result;
                    }
                    catch (Throwable f) {
                        cache_file.delete();
                    }
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(Debug.getNestedExceptionMessage(e));
            }
        }
        is.close();
        return string;
    }
}

