/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.versioncheck;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.impl.DownloadManagerStateImpl;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminASN;
import com.biglybt.core.networkmanager.impl.udp.UDPNetworkManager;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.stats.transfer.OverallStats;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AEVerifier;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.versioncheck.VersionCheckClientListener;
import com.biglybt.core.versioncheck.VersionCheckClientUDPCodecs;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class VersionCheckClient {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String REASON_UPDATE_CHECK_START = "us";
    public static final String REASON_UPDATE_CHECK_PERIODIC = "up";
    public static final String REASON_CHECK_SWT = "sw";
    public static final String REASON_DHT_FLAGS = "df";
    public static final String REASON_DHT_EXTENDED_ALLOWED = "dx";
    public static final String REASON_DHT_ENABLE_ALLOWED = "de";
    public static final String REASON_EXTERNAL_IP = "ip";
    public static final String REASON_RECOMMENDED_PLUGINS = "rp";
    public static final String REASON_SECONDARY_CHECK = "sc";
    public static final String REASON_PLUGIN_UPDATE = "pu";
    public static final String REASON_DHT_BOOTSTRAP = "db";
    public static final String HTTP_SERVER_ADDRESS_V4 = "version.biglybt.com";
    public static final int HTTP_SERVER_PORT = 80;
    public static final String TCP_SERVER_ADDRESS_V4 = "version.biglybt.com";
    public static final int TCP_SERVER_PORT = 80;
    public static final String UDP_SERVER_ADDRESS_V4 = "version.biglybt.com";
    public static final int UDP_SERVER_PORT = 2080;
    public static final String HTTP_SERVER_ADDRESS_V6 = "version6.biglybt.com";
    public static final String TCP_SERVER_ADDRESS_V6 = "version6.biglybt.com";
    public static final String UDP_SERVER_ADDRESS_V6 = "version6.biglybt.com";
    private static final long CACHE_PERIOD = 300000L;
    private static boolean secondary_check_done;
    private final CopyOnWriteList<VersionCheckClientListener> listeners = new CopyOnWriteList(5);
    private static final int AT_V4 = 1;
    private static final int AT_V6 = 2;
    private static final int AT_EITHER = 3;
    private static VersionCheckClient instance;
    private boolean enable_v6;
    private boolean prefer_v6;
    private Map last_check_data_v4 = null;
    private Map last_check_data_v6 = null;
    private volatile Throwable last_error_v4 = null;
    private volatile Throwable last_error_v6 = null;
    private final AEMonitor check_mon = new AEMonitor("versioncheckclient");
    private long last_check_time_v4 = 0L;
    private long last_check_time_v6 = 0L;
    private long last_feature_flag_cache;
    private long last_feature_flag_cache_time;
    private volatile boolean check_has_worked;

    static {
        VersionCheckClientUDPCodecs.registerCodecs();
    }

    public static synchronized VersionCheckClient getSingleton() {
        if (instance == null) {
            instance = new VersionCheckClient();
        }
        return instance;
    }

    private VersionCheckClient() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"IPV6 Prefer Addresses", "IPV6 Enable Support"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                VersionCheckClient.this.enable_v6 = COConfigurationManager.getBooleanParameter("IPV6 Enable Support");
                VersionCheckClient.this.prefer_v6 = COConfigurationManager.getBooleanParameter("IPV6 Prefer Addresses");
            }
        });
    }

    public void initialise() {
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("VersionCheck", new Runnable(){

            @Override
            public void run() {
                final AESemaphore sem = new AESemaphore("VCC:init");
                new AEThread2("VCC:init", true){

                    @Override
                    public void run() {
                        try {
                            VersionCheckClient.this.getVersionCheckInfo(VersionCheckClient.REASON_UPDATE_CHECK_START);
                        }
                        finally {
                            sem.release();
                        }
                    }
                }.start();
                if (!sem.reserve(5000L)) {
                    Debug.out("Timeout waiting for version check to complete");
                }
            }
        });
        delayed_task.queue();
    }

    public Map getVersionCheckInfo(String reason) {
        return this.getVersionCheckInfo(reason, 3);
    }

    public Map getVersionCheckInfo(String reason, int address_type) {
        if (address_type == 1) {
            return this.getVersionCheckInfoSupport(reason, false, false, false);
        }
        if (address_type == 2) {
            return this.getVersionCheckInfoSupport(reason, false, false, true);
        }
        Map reply = this.getVersionCheckInfoSupport(reason, false, false, this.prefer_v6);
        if (reply == null || reply.size() == 0) {
            reply = this.getVersionCheckInfoSupport(reason, false, false, !this.prefer_v6);
        }
        return reply;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getVersionCheckInfoSupport(String reason, boolean only_if_cached, boolean force, boolean v6) {
        listeners_clone = this.listeners.getList();
        var7_6 = listeners_clone.iterator();
        while (true) {
            if (!var7_6.hasNext()) {
                changed = false;
                ** try [egrp 1[TRYBLOCK] [16 : 64->169)] { 
lbl7:
                // 1 sources

                break;
            }
            l = var7_6.next();
            try {
                l.versionCheckStarted(reason);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        {
            block57: {
                block56: {
                    block58: {
                        block55: {
                            if (!v6) break block58;
                            if (this.enable_v6) {
                                block54: {
                                    this.check_mon.enter();
                                    time_diff = SystemTime.getCurrentTime() - this.last_check_time_v6;
                                    v0 = force = force != false || time_diff > 300000L || time_diff < 0L;
                                    if (this.last_check_data_v6 != null && this.last_check_data_v6.size() != 0 && !force) break block54;
                                    if (only_if_cached && this.last_check_data_v6 != null) {
                                        var11_12 = new HashMap<K, V>();
                                        this.check_mon.exit();
                                    }
                                    ** try [egrp 5[TRYBLOCK] [6 : 236->388)] { 
lbl29:
                                    // 1 sources

                                    try {
                                        this.last_error_v6 = null;
                                        this.last_check_data_v6 = this.performVersionCheck(VersionCheckClient.constructVersionCheckMessage(reason), true, true, true);
                                        if (this.last_check_data_v6 != null && this.last_check_data_v6.size() > 0) {
                                            COConfigurationManager.setParameter("versioncheck.cache.v6", this.last_check_data_v6);
                                            changed = true;
                                        }
                                        break block55;
                                    }
                                    catch (SocketException t) {
                                        this.last_error_v6 = t;
                                    }
                                    catch (UnknownHostException t) {
                                        this.last_error_v6 = t;
                                    }
                                    catch (Throwable t) {
                                        Debug.out(t);
                                        this.last_check_data_v6 = new HashMap<K, V>();
                                        this.last_error_v6 = t;
                                    }
                                    break block55;
                                }
                                Logger.log(new LogEvent(VersionCheckClient.LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data_v6.size() + " reply keys."));
                                break block55;
lbl52:
                                // 1 sources

                                finally {
                                    this.check_mon.exit();
                                }
                            }
                        }
                        if (this.last_check_data_v6 == null) {
                            this.last_check_data_v6 = new HashMap<K, V>();
                        }
                        var16_40 = this.last_check_data_v6;
                        return var16_40;
                    }
                    this.check_mon.enter();
                    time_diff = SystemTime.getCurrentTime() - this.last_check_time_v4;
                    v1 = force = force != false || time_diff > 300000L || time_diff < 0L;
                    if (this.last_check_data_v4 != null && this.last_check_data_v4.size() != 0 && !force) break block56;
                    if (only_if_cached && this.last_check_data_v4 != null) {
                        var14_42 = new HashMap<K, V>();
                        this.check_mon.exit();
                    }
                    ** try [egrp 12[TRYBLOCK] [14 : 658->1027)] { 
lbl73:
                    // 1 sources

                    try {
                        this.last_error_v4 = null;
                        this.last_check_data_v4 = this.performVersionCheck(VersionCheckClient.constructVersionCheckMessage(reason), true, true, false);
                        if (this.last_check_data_v4 != null && this.last_check_data_v4.size() > 0) {
                            COConfigurationManager.setParameter("versioncheck.cache.v4", this.last_check_data_v4);
                            changed = true;
                        }
                        try {
                            if (CoreFactory.isCoreAvailable() && CoreFactory.getSingleton().getPluginManager().isInitialized()) {
                                plugins = CoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                                i = 0;
                                while (i < plugins.length) {
                                    plugin = plugins[i];
                                    data = plugin.getPluginconfig().getPluginMapParameter("plugin.versionserver.data", null);
                                    if (data != null) {
                                        plugin.getPluginconfig().setPluginMapParameter("plugin.versionserver.data", new HashMap<K, V>());
                                    }
                                    ++i;
                                }
                            }
                            break block57;
                        }
                        catch (Throwable plugins) {}
                        break block57;
                    }
                    catch (UnknownHostException t) {
                        Debug.outNoStack("VersionCheckClient - " + t.getClass().getName() + ": " + t.getMessage());
                        if (Constants.isCVSVersion()) {
                            Debug.out(t);
                        }
                        this.last_error_v4 = t;
                    }
                    catch (IOException t) {
                        Debug.outNoStack("VersionCheckClient - " + t.getClass().getName() + ": " + t.getMessage());
                        if (Constants.isCVSVersion()) {
                            Debug.out(t);
                        }
                        this.last_error_v4 = t;
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                        this.last_check_data_v4 = new HashMap<K, V>();
                        this.last_error_v4 = t;
                    }
                    break block57;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(VersionCheckClient.LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data_v4.size() + " reply keys."));
                }
                break block57;
lbl115:
                // 1 sources

                finally {
                    this.check_mon.exit();
                }
            }
            if (this.last_check_data_v4 == null) {
                this.last_check_data_v4 = new HashMap<K, V>();
            }
            this.last_feature_flag_cache_time = 0L;
            var16_41 = this.last_check_data_v4;
            return var16_41;
        }
lbl124:
        // 1 sources

        finally {
            if (changed) {
                this.check_has_worked = true;
            }
            var18_14 = listeners_clone.iterator();
        }
        while (true) {
            if (!var18_14.hasNext()) {
                return var11_12;
            }
            l = var18_14.next();
            try {
                l.versionCheckCompleted(reason, changed);
                continue;
            }
            catch (Throwable e) {
                Debug.out(e);
                continue;
            }
            break;
        }
    }

    public Map getMostRecentVersionCheckData() {
        if (this.last_check_data_v4 != null) {
            return this.last_check_data_v4;
        }
        Map res = COConfigurationManager.getMapParameter("versioncheck.cache.v4", null);
        if (res != null) {
            return res;
        }
        if (this.last_check_data_v6 != null) {
            return this.last_check_data_v6;
        }
        res = COConfigurationManager.getMapParameter("versioncheck.cache.v6", null);
        return res;
    }

    private boolean isVersionCheckDataValid(int address_type) {
        boolean v4_ok;
        boolean v6_ok = this.last_check_data_v6 != null && this.last_check_data_v6.size() > 0;
        boolean bl = v4_ok = this.last_check_data_v4 != null && this.last_check_data_v4.size() > 0;
        if (address_type == 1) {
            return v4_ok;
        }
        if (address_type == 2) {
            return v6_ok;
        }
        return v4_ok | v6_ok;
    }

    public long getCacheTime(boolean v6) {
        return v6 ? this.last_check_time_v6 : this.last_check_time_v4;
    }

    public void clearCache() {
        this.last_check_time_v6 = 0L;
        this.last_check_time_v4 = 0L;
    }

    public Throwable getError() {
        if (!this.check_has_worked) {
            if (this.last_error_v4 != null) {
                return this.last_error_v4;
            }
            return this.last_error_v6;
        }
        return null;
    }

    public long getFeatureFlags() {
        long result;
        long now = SystemTime.getCurrentTime();
        if (now > this.last_feature_flag_cache_time && now - this.last_feature_flag_cache_time < 60000L) {
            return this.last_feature_flag_cache;
        }
        Map m = this.getMostRecentVersionCheckData();
        if (m == null) {
            result = 0L;
        } else {
            byte[] b_feat_flags = (byte[])m.get("feat_flags");
            if (b_feat_flags != null) {
                try {
                    result = Long.parseLong(new String(b_feat_flags));
                }
                catch (Throwable e) {
                    result = 0L;
                }
            } else {
                result = 0L;
            }
        }
        this.last_feature_flag_cache = result;
        this.last_feature_flag_cache_time = now;
        return result;
    }

    public Set<String> getDisabledPluginIDs() {
        byte[] x;
        HashSet<String> result = new HashSet<String>();
        Map m = this.getMostRecentVersionCheckData();
        if (m != null && (x = (byte[])m.get("disabled_pids")) != null) {
            String[] bits;
            String str = new String(x);
            String latest = COConfigurationManager.getStringParameter("vc.disabled_pids.latest", "");
            if (!str.equals(latest)) {
                byte[] sig = (byte[])m.get("disabled_pids_sig");
                if (sig == null) {
                    Debug.out("disabled plugins sig missing");
                    return result;
                }
                try {
                    AEVerifier.verifyData(str, sig);
                    COConfigurationManager.setParameter("vc.disabled_pids.latest", str);
                }
                catch (Throwable e) {
                    return result;
                }
            }
            String[] stringArray = bits = str.split(",");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String b = stringArray[n2];
                if ((b = b.trim()).length() > 0) {
                    result.add(b);
                }
                ++n2;
            }
        }
        return result;
    }

    public Set<String> getAutoInstallPluginIDs() {
        byte[] x;
        HashSet<String> result = new HashSet<String>();
        Map m = this.getMostRecentVersionCheckData();
        if (m != null && (x = (byte[])m.get("autoinstall_pids")) != null) {
            String[] bits;
            String str = new String(x);
            String latest = COConfigurationManager.getStringParameter("vc.autoinstall_pids.latest", "");
            if (!str.equals(latest)) {
                byte[] sig = (byte[])m.get("autoinstall_pids_sig");
                if (sig == null) {
                    Debug.out("autoinstall plugins sig missing");
                    return result;
                }
                try {
                    AEVerifier.verifyData(str, sig);
                    COConfigurationManager.setParameter("vc.autoinstall_pids.latest", str);
                }
                catch (Throwable e) {
                    return result;
                }
            }
            String[] stringArray = bits = str.split(",");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String b = stringArray[n2];
                if ((b = b.trim()).length() > 0) {
                    result.add(b);
                }
                ++n2;
            }
        }
        return result;
    }

    public String getExternalIpAddress(boolean only_if_cached, boolean v6) {
        return this.getExternalIpAddress(only_if_cached, v6, false);
    }

    public String getExternalIpAddress(boolean only_if_cached, boolean v6, boolean force) {
        Map reply = this.getVersionCheckInfoSupport(REASON_EXTERNAL_IP, only_if_cached, force, v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        if (address != null) {
            return new String(address);
        }
        return null;
    }

    public boolean DHTEnableAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_ENABLE_ALLOWED, 3);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid(3);
        }
        return res;
    }

    public boolean DHTExtendedUseAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_EXTENDED_ALLOWED, 3);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht_extended_use");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid(3);
        }
        return res;
    }

    public byte getDHTFlags() {
        byte[] b_flags;
        Map map = this.getMostRecentVersionCheckData();
        if (map != null && (b_flags = (byte[])map.get("dht_flags")) != null) {
            return new Integer(new String(b_flags)).byteValue();
        }
        return -1;
    }

    public String[] getRecommendedPlugins() {
        Map reply = this.getVersionCheckInfo(REASON_RECOMMENDED_PLUGINS, 3);
        List l = (List)reply.get("recommended_plugins");
        if (l == null) {
            return new String[0];
        }
        String[] res = new String[l.size()];
        int i = 0;
        while (i < l.size()) {
            res[i] = new String((byte[])l.get(i));
            ++i;
        }
        return res;
    }

    public List<InetSocketAddress> getDHTBootstrap(boolean ipv4) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        try {
            Map reply = this.getVersionCheckInfo(REASON_DHT_BOOTSTRAP, ipv4 ? 1 : 2);
            List l = (List)reply.get("dht_boot");
            if (l != null) {
                for (Map m : l) {
                    InetAddress iaddress;
                    byte[] address = (byte[])m.get("a");
                    int port = ((Long)m.get("p")).intValue();
                    if ((!ipv4 || address.length != 4) && (ipv4 || address.length != 16) || (iaddress = InetAddress.getByAddress(address)).isLoopbackAddress() || iaddress.isLinkLocalAddress() || iaddress.isSiteLocalAddress()) continue;
                    result.add(new InetSocketAddress(iaddress, port));
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return result;
    }

    public Map<String, Object> getCountryInfo() {
        Map reply = this.getVersionCheckInfo(REASON_EXTERNAL_IP, 3);
        Map info = (Map)reply.get("source_info");
        if (info == null) {
            return new HashMap<String, Object>();
        }
        return BDecoder.decodeStrings(info);
    }

    private Map performVersionCheck(Map data_to_send, boolean use_az_message, boolean use_http, boolean v6) throws Exception {
        Exception error = null;
        Map reply = null;
        if (use_http) {
            try {
                reply = this.executeHTTP(data_to_send, v6);
                reply.put("protocol_used", "HTTP");
                error = null;
            }
            catch (IOException e) {
                error = e;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient server version check successful. Received " + (reply == null ? "null" : Integer.valueOf(reply.size())) + " reply keys."));
        }
        if (v6) {
            this.last_check_time_v6 = SystemTime.getCurrentTime();
        } else {
            this.last_check_time_v4 = SystemTime.getCurrentTime();
        }
        return reply;
    }

    private Map executeHTTP(Map data_to_send, boolean v6) throws Exception {
        if (v6 && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String host = this.getHost(v6, "version6.biglybt.com", "version.biglybt.com");
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + host + ":" + 80 + " via HTTP"));
        }
        String url_str = "http://" + (v6 ? UrlUtils.convertIPV6Host(host) : host) + "/version?";
        url_str = String.valueOf(url_str) + URLEncoder.encode(new String(BEncoder.encode(data_to_send), "ISO-8859-1"), "ISO-8859-1");
        URL url = new URL(url_str);
        boolean anon = COConfigurationManager.getBooleanParameter("update.anonymous");
        if (anon) {
            throw new Exception("Direct HTTP disabled for anonymous updates");
        }
        Properties http_properties = new Properties();
        http_properties.put("URL", url);
        try {
            ClientIDManagerImpl cman = ClientIDManagerImpl.getSingleton();
            if (cman != null && cman.getGenerator() != null) {
                cman.generateHTTPProperties(null, http_properties);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            throw new IOException(e.getMessage());
        }
        url = (URL)http_properties.get("URL");
        HttpURLConnection url_connection = (HttpURLConnection)url.openConnection();
        url_connection.setConnectTimeout(10000);
        url_connection.setReadTimeout(10000);
        url_connection.connect();
        try {
            InputStream is = url_connection.getInputStream();
            Map<String, Object> reply = BDecoder.decode(new BufferedInputStream(is));
            this.preProcessReply(reply, v6);
            Map<String, Object> map = reply;
            url_connection.disconnect();
            return map;
        }
        catch (Throwable throwable) {
            try {
                url_connection.disconnect();
                throw throwable;
            }
            catch (Exception e) {
                AEProxyFactory.PluginProxy proxy;
                if (!v6 && (proxy = AEProxyFactory.getPluginProxy(String.valueOf(Constants.APP_NAME) + " version check", url)) != null) {
                    boolean worked = false;
                    try {
                        HttpURLConnection url_connection2 = (HttpURLConnection)proxy.getURL().openConnection(proxy.getProxy());
                        url_connection2.setConnectTimeout(30000);
                        url_connection2.setReadTimeout(30000);
                        url_connection2.connect();
                        try {
                            InputStream is = url_connection2.getInputStream();
                            Map<String, Object> reply = BDecoder.decode(new BufferedInputStream(is));
                            if (reply != null) {
                                reply.remove("source_ip_address");
                            }
                            this.preProcessReply(reply, v6);
                            worked = true;
                            Map<String, Object> map = reply;
                            url_connection2.disconnect();
                            return map;
                        }
                        catch (Throwable throwable2) {
                            url_connection2.disconnect();
                            throw throwable2;
                        }
                    }
                    finally {
                        proxy.setOK(worked);
                    }
                }
                if (anon) {
                    throw new Exception("Tor helper plugin failed or not available");
                }
                throw e;
            }
        }
    }

    public String getHTTPGetString(boolean for_proxy, boolean v6) {
        return this.getHTTPGetString(new HashMap(), for_proxy, v6);
    }

    private String getHTTPGetString(Map content, boolean for_proxy, boolean v6) {
        String host = this.getHost(v6, "version6.biglybt.com", "version.biglybt.com");
        String get_str = "GET " + (for_proxy ? "http://" + (v6 ? UrlUtils.convertIPV6Host(host) : host) + ":" + 80 : "") + "/version?";
        try {
            get_str = String.valueOf(get_str) + URLEncoder.encode(new String(BEncoder.encode(content), "ISO-8859-1"), "ISO-8859-1");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        get_str = String.valueOf(get_str) + " HTTP/1.1\r\n\r\n";
        return get_str;
    }

    private Map executeTCP(Map data_to_send, InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        if (COConfigurationManager.getBooleanParameter("update.anonymous")) {
            throw new Exception("TCP disabled for anonymous updates");
        }
        if (v6 && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String host = this.getHost(v6, "version6.biglybt.com", "version.biglybt.com");
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + host + ":" + 80 + " via TCP"));
        }
        String get_str = this.getHTTPGetString(data_to_send, false, v6);
        Socket socket = null;
        try {
            int len;
            socket = new Socket();
            if (bind_ip != null) {
                socket.bind(new InetSocketAddress(bind_ip, bind_port));
            } else if (bind_port != 0) {
                socket.bind(new InetSocketAddress(bind_port));
            }
            socket.setSoTimeout(10000);
            socket.connect(new InetSocketAddress(host, 80), 10000);
            OutputStream os = socket.getOutputStream();
            os.write(get_str.getBytes("ISO-8859-1"));
            os.flush();
            InputStream is = socket.getInputStream();
            byte[] buffer = new byte[1];
            String header = "";
            int content_length = -1;
            while ((len = is.read(buffer)) > 0) {
                if ((header = String.valueOf(header) + (char)buffer[0]).endsWith("\r\n\r\n")) {
                    int pos = (header = header.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("content-length:");
                    if (pos == -1) {
                        throw new IOException("content length missing");
                    }
                    header = header.substring(pos + 15);
                    pos = header.indexOf(13);
                    content_length = Integer.parseInt(header = header.substring(0, pos).trim());
                    if (content_length <= 10000) break;
                    throw new IOException("content length too large");
                }
                if (header.length() <= 2048) continue;
                throw new IOException("header too large");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(content_length);
            buffer = new byte[content_length];
            while (content_length > 0) {
                int len2 = is.read(buffer);
                if (len2 <= 0) break;
                baos.write(buffer, 0, len2);
                content_length -= len2;
            }
            if (content_length != 0) {
                throw new IOException("error reading reply");
            }
            byte[] reply_bytes = baos.toByteArray();
            Map<String, Object> reply = BDecoder.decode(new BufferedInputStream(new ByteArrayInputStream(reply_bytes)));
            this.preProcessReply(reply, v6);
            Map<String, Object> map = reply;
            return map;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Map executeUDP(Map data_to_send, InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void preProcessReply(Map reply, final boolean v6) {
        Long lEnabledUISwitcher;
        String done_asn;
        long advice;
        NetworkAdminASN current_asn;
        String asn;
        Long as_advice;
        NetworkAdmin admin;
        block9: {
            admin = NetworkAdmin.getSingleton();
            try {
                byte[] address = (byte[])reply.get("source_ip_address");
                if (address != null) {
                    InetAddress my_ip = InetAddress.getByName(new String(address));
                    NetworkAdminASN old_asn = admin.getCurrentASN();
                    NetworkAdminASN new_asn = admin.lookupCurrentASN(my_ip);
                    if (!new_asn.sameAs(old_asn) && !secondary_check_done) {
                        secondary_check_done = true;
                        new AEThread("Secondary version check", true){

                            @Override
                            public void runSupport() {
                                VersionCheckClient.this.getVersionCheckInfoSupport(VersionCheckClient.REASON_SECONDARY_CHECK, false, true, v6);
                            }
                        }.start();
                    }
                }
            }
            catch (Throwable e) {
                if (Debug.containsException(e, UnknownHostException.class)) break block9;
                Debug.printStackTrace(e);
            }
        }
        if ((as_advice = (Long)reply.get("as_advice")) != null && (asn = (current_asn = admin.getCurrentASN()).getASName()) != null && (advice = as_advice.longValue()) != 0L && !(done_asn = COConfigurationManager.getStringParameter("ASN Advice Followed", "")).equals(asn)) {
            boolean alert;
            COConfigurationManager.setParameter("ASN Advice Followed", asn);
            boolean change = advice == 1L || advice == 2L;
            boolean bl = alert = advice == 1L || advice == 3L;
            if (!COConfigurationManager.getBooleanParameter("network.transport.encrypted.require")) {
                if (change) {
                    COConfigurationManager.setParameter("network.transport.encrypted.require", true);
                }
                if (alert) {
                    String msg = MessageText.getString("crypto.alert.as.warning", new String[]{asn});
                    Logger.log(new LogAlert(false, 1, msg));
                }
            }
        }
        if ((lEnabledUISwitcher = (Long)reply.get("ui.toolbar.uiswitcher")) != null) {
            COConfigurationManager.setBooleanDefault("ui.toolbar.uiswitcher", lEnabledUISwitcher == 1L);
        }
    }

    public InetAddress getExternalIpAddressHTTP(boolean v6) throws Exception {
        Map reply = this.executeHTTP(new HashMap(), v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        return address == null ? null : InetAddress.getByName(new String(address));
    }

    public InetAddress getExternalIpAddressTCP(InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        Map reply = this.executeTCP(new HashMap(), bind_ip, bind_port, v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        return address == null ? null : InetAddress.getByName(new String(address));
    }

    public InetAddress getExternalIpAddressUDP(InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        Map reply = this.executeUDP(new HashMap(), bind_ip, bind_port, v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        return address == null ? null : InetAddress.getByName(new String(address));
    }

    protected String getHost(boolean v6, String v6_address, String v4_address) {
        if (v6) {
            v6_address = this.getTestAddress(true, v6_address);
            try {
                return InetAddress.getByName(v6_address).getHostAddress();
            }
            catch (UnknownHostException e) {
                DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
                if (dns_utils != null) {
                    try {
                        return dns_utils.getIPV6ByName(v6_address).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                return v6_address;
            }
        }
        v4_address = this.getTestAddress(false, v4_address);
        return v4_address;
    }

    private String getTestAddress(boolean v6, String address) {
        return COConfigurationManager.getStringParameter("versioncheck.test.address." + v6, address);
    }

    public static Map<String, Object> constructVersionCheckMessage(String reason) {
        int last_send_time = COConfigurationManager.getIntParameter("Send Version Info Last Time", -1);
        int current_send_time = (int)(SystemTime.getCurrentTime() / 1000L);
        COConfigurationManager.setParameter("Send Version Info Last Time", current_send_time);
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("appid", SystemProperties.getApplicationIdentifier());
        message.put("appname", SystemProperties.getApplicationName());
        message.put("version", "3.9.0.0");
        message.put("first_version", COConfigurationManager.getStringParameter("First Recorded Version", ""));
        String sub_ver = "";
        if (sub_ver.length() > 0) {
            message.put("subver", sub_ver);
        }
        if (COConfigurationManager.getBooleanParameter("Beta Programme Enabled")) {
            message.put("beta_prog", "true");
        }
        if (System.getProperty(SystemProperties.SYSPROP_PORTABLE_ENABLE, "false").equalsIgnoreCase("true")) {
            message.put("portable", "true");
        }
        message.put("ui", COConfigurationManager.getStringParameter("ui", "unknown"));
        message.put("os", Constants.OSName);
        message.put("os_version", Constants.OSVersion);
        message.put("os_arch", Constants.OSArch);
        message.put("os_arch_dm", System.getProperty("sun.arch.data.model"));
        message.put("imode", COConfigurationManager.getStringParameter("installer.mode", ""));
        if (Constants.isAndroid) {
            int api_level = Constants.API_LEVEL;
            if (api_level > 0) {
                message.put("api_level", api_level);
            }
        } else {
            String java_rt_version;
            try {
                Class<?> c = Class.forName("com.biglybt.ui.swt.Utils");
                String swt_platform = (String)c.getMethod("getSWTPlatform", new Class[0]).invoke(null, new Object[0]);
                message.put("swt_platform", swt_platform);
                Integer swt_version = (Integer)c.getMethod("getSWTVersion", new Class[0]).invoke(null, new Object[0]);
                message.put("swt_version", new Long(swt_version.longValue()));
                Integer swt_revision = (Integer)c.getMethod("getSWTRevision", new Class[0]).invoke(null, new Object[0]);
                message.put("swt_revision", new Long(swt_revision.longValue()));
            }
            catch (ClassNotFoundException c) {
            }
            catch (NoClassDefFoundError c) {
            }
            catch (InvocationTargetException c) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            String java_version = Constants.JAVA_VERSION;
            if (java_version == null) {
                java_version = "unknown";
            }
            message.put("java", java_version);
            String java_vendor = System.getProperty("java.vm.vendor");
            if (java_vendor == null) {
                java_vendor = "unknown";
            }
            message.put("javavendor", java_vendor);
            String java_rt_name = System.getProperty("java.runtime.name");
            if (java_rt_name != null) {
                message.put("java_rt_name", java_rt_name);
            }
            if ((java_rt_version = System.getProperty("java.runtime.version")) != null) {
                message.put("java_rt_version", java_rt_version);
            }
            try {
                if (CoreFactory.isCoreAvailable() && CoreFactory.getSingleton().getPluginManager().isInitialized()) {
                    PluginInterface[] plugins = CoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                    ArrayList<String> pids = new ArrayList<String>();
                    ArrayList vs_data = new ArrayList();
                    int i = 0;
                    while (i < plugins.length) {
                        Map data;
                        PluginInterface plugin = plugins[i];
                        String pid = plugin.getPluginID();
                        String info = plugin.getPluginconfig().getPluginStringParameter("plugin.info");
                        if (info != null && info.length() > 0 || !pid.startsWith("<") && !pid.startsWith("azbp") && !pid.startsWith("azupdater") && !pid.startsWith("azplatform") && !pids.contains(pid)) {
                            if (info != null && info.length() > 0) {
                                if (info.length() < 256) {
                                    pid = String.valueOf(pid) + ":" + info;
                                } else {
                                    Debug.out("Plugin '" + pid + "' reported excessive info string '" + info + "'");
                                }
                            }
                            pids.add(pid);
                        }
                        if ((data = plugin.getPluginconfig().getPluginMapParameter("plugin.versionserver.data", null)) != null) {
                            HashMap<String, Object> payload = new HashMap<String, Object>();
                            byte[] data_bytes = BEncoder.encode(data);
                            if (data_bytes.length > 16384) {
                                Debug.out("Plugin '" + pid + "' reported excessive version server data (length=" + data_bytes.length + ")");
                                payload.put("error", "data too long: " + data_bytes.length);
                            } else {
                                payload.put("data", data_bytes);
                            }
                            payload.put("id", pid);
                            payload.put("version", plugin.getPluginVersion());
                            vs_data.add(payload);
                        }
                        ++i;
                    }
                    message.put("plugins", pids);
                    if (vs_data.size() > 0) {
                        message.put("plugin_data", vs_data);
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            String id = COConfigurationManager.getStringParameter("ID", null);
            boolean send_info = COConfigurationManager.getBooleanParameter("Send Version Info");
            if (id != null && send_info) {
                boolean using_phe;
                message.put("id", id);
                try {
                    byte[] id2 = CryptoManagerFactory.getSingleton().getSecureID();
                    message.put("id2", id2);
                }
                catch (Throwable id2) {
                    // empty catch block
                }
                if (last_send_time != -1 && last_send_time < current_send_time) {
                    message.put("tsl", new Long(current_send_time - last_send_time));
                }
                message.put("reason", reason);
                long max_mem = Runtime.getRuntime().maxMemory() / 0x100000L;
                message.put("javamx", new Long(max_mem));
                OverallStats stats2 = StatsFactory.getStats();
                if (stats2 != null) {
                    long total_uptime = stats2.getTotalUpTime();
                    message.put("total_uptime", new Long(total_uptime));
                }
                message.put("using_phe", (using_phe = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require")) ? new Long(1L) : new Long(0L));
                try {
                    int port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                    message.put("dht", port);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                try {
                    NetworkAdminASN current_asn = NetworkAdmin.getSingleton().getCurrentASN();
                    message.put("ip_as", current_asn.getAS());
                    String asn = current_asn.getASName();
                    if (asn.length() > 64) {
                        asn = asn.substring(0, 64);
                    }
                    message.put("ip_asn", asn);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                message.put("locale", Locale.getDefault().toString());
                String originalLocale = String.valueOf(System.getProperty("user.language")) + "_" + System.getProperty("user.country");
                String variant = System.getProperty("user.variant");
                if (variant != null && variant.length() > 0) {
                    originalLocale = String.valueOf(originalLocale) + "_" + variant;
                }
                message.put("orig_locale", originalLocale);
                message.put("user_mode", COConfigurationManager.getIntParameter("User Mode", -1));
            }
        }
        return message;
    }

    public void addVersionCheckClientListener(VersionCheckClientListener l) {
        this.listeners.add(l);
    }

    public void removeVersionCheckClientListener(VersionCheckClientListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        try {
            COConfigurationManager.initialise();
            COConfigurationManager.setParameter("IPV6 Enable Support", true);
            boolean v6 = true;
            System.out.println("HTTP: " + VersionCheckClient.getSingleton().getExternalIpAddressHTTP(v6));
            Map<String, Object> data = VersionCheckClient.constructVersionCheckMessage(REASON_UPDATE_CHECK_START);
            System.out.println("Sending (pre-initialisation):");
            VersionCheckClient.printDataMap(data);
            System.out.println("-----------");
            System.out.println("Receiving (pre-initialisation):");
            VersionCheckClient.printDataMap(VersionCheckClient.getSingleton().getVersionCheckInfo(REASON_UPDATE_CHECK_START));
            System.out.println("-----------");
            System.out.println();
            System.out.print("Initialising core... ");
            DownloadManagerStateImpl.SUPPRESS_FIXUP_ERRORS = true;
            Core core = CoreFactory.create();
            core.start();
            System.out.println("done.");
            System.out.println();
            System.out.println("-----------");
            data = VersionCheckClient.constructVersionCheckMessage(REASON_UPDATE_CHECK_START);
            System.out.println("Sending (post-initialisation):");
            VersionCheckClient.printDataMap(data);
            System.out.println("-----------");
            System.out.println("Receiving (post-initialisation):");
            VersionCheckClient.printDataMap(VersionCheckClient.getSingleton().getVersionCheckInfo(REASON_UPDATE_CHECK_START));
            System.out.println("-----------");
            System.out.println();
            System.out.print("Shutting down core... ");
            core.stop();
            System.out.println("done.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void printDataMap(Map map) throws Exception {
        TreeMap res = new TreeMap(map);
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (!(val instanceof byte[])) continue;
            String as_bytes = ByteFormatter.nicePrint((byte[])val);
            String as_text = new String((byte[])val, Constants.BYTE_ENCODING_CHARSET);
            res.put(key, String.valueOf(as_text) + " [" + as_bytes + "]");
        }
        for (Map.Entry entry : res.entrySet()) {
            System.out.print("  ");
            System.out.print(entry.getKey());
            System.out.print(": ");
            System.out.print(entry.getValue());
            System.out.println();
        }
    }
}

