/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.udp.uc.impl;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.net.udp.uc.PRUDPPacketHandler;
import com.biglybt.net.udp.uc.PRUDPReleasablePacketHandler;
import com.biglybt.net.udp.uc.PRUDPRequestHandler;
import com.biglybt.net.udp.uc.impl.PRUDPPacketHandlerImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PRUDPPacketHandlerFactoryImpl {
    private static Map<Integer, PRUDPPacketHandlerImpl> receiver_map = new HashMap<Integer, PRUDPPacketHandlerImpl>();
    private static AEMonitor class_mon = new AEMonitor("PRUDPPHF");
    private static Map releasable_map = new HashMap();
    private static Set non_releasable_set = new HashSet();

    public static List<PRUDPPacketHandler> getHandlers() {
        try {
            class_mon.enter();
            ArrayList<PRUDPPacketHandler> arrayList = new ArrayList<PRUDPPacketHandler>(receiver_map.values());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    public static PRUDPPacketHandler getHandler(int port, InetAddress bind_ip, PRUDPRequestHandler request_handler) {
        Integer f_port = new Integer(port);
        try {
            class_mon.enter();
            non_releasable_set.add(f_port);
            PRUDPPacketHandlerImpl receiver = receiver_map.get(f_port);
            if (receiver == null) {
                receiver = PRUDPPacketHandlerImpl.createPacketHandler(port, bind_ip, null);
                receiver_map.put(f_port, receiver);
            }
            if (request_handler != null) {
                receiver.setRequestHandler(request_handler);
            }
            PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = receiver;
            return pRUDPPacketHandlerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    public static PRUDPReleasablePacketHandler getReleasableHandler(int port, PRUDPRequestHandler request_handler) {
        final Integer f_port = new Integer(port);
        try {
            class_mon.enter();
            PRUDPPacketHandlerImpl receiver = receiver_map.get(f_port);
            if (receiver == null) {
                receiver = PRUDPPacketHandlerImpl.createPacketHandler(port, null, null);
                receiver_map.put(f_port, receiver);
            }
            if (request_handler != null) {
                receiver.setRequestHandler(request_handler);
            }
            final PRUDPPacketHandlerImpl f_receiver = receiver;
            PRUDPReleasablePacketHandler rel = new PRUDPReleasablePacketHandler(){

                @Override
                public PRUDPPacketHandler getHandler() {
                    return f_receiver;
                }

                @Override
                public void release() {
                    try {
                        class_mon.enter();
                        List l = (List)releasable_map.get(f_port);
                        if (l == null) {
                            Debug.out("hmm");
                        } else if (!l.remove(this)) {
                            Debug.out("hmm");
                        } else if (l.size() == 0) {
                            if (!non_releasable_set.contains(f_port)) {
                                f_receiver.destroy();
                                receiver_map.remove(f_port);
                            }
                            releasable_map.remove(f_port);
                        }
                    }
                    finally {
                        class_mon.exit();
                    }
                }
            };
            ArrayList<1> l = (ArrayList<1>)releasable_map.get(f_port);
            if (l == null) {
                l = new ArrayList<1>();
                releasable_map.put(f_port, l);
            }
            l.add(rel);
            if (l.size() > 1024) {
                Debug.out("things going wrong here");
            }
            PRUDPReleasablePacketHandler pRUDPReleasablePacketHandler = rel;
            return pRUDPReleasablePacketHandler;
        }
        finally {
            class_mon.exit();
        }
    }
}

