/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.udp.uc.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.net.udp.uc.PRUDPPacket;
import com.biglybt.net.udp.uc.PRUDPPacketHandler;
import com.biglybt.net.udp.uc.PRUDPPacketHandlerException;
import com.biglybt.net.udp.uc.PRUDPPacketHandlerStats;
import com.biglybt.net.udp.uc.PRUDPPacketReceiver;
import com.biglybt.net.udp.uc.PRUDPPrimordialHandler;
import com.biglybt.net.udp.uc.PRUDPRequestHandler;
import com.biglybt.net.udp.uc.impl.PRUDPPacketHandlerImpl;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;

public class PRUDPPacketHandlerSocks
implements PRUDPPacketHandler,
PRUDPPacketHandlerImpl.PacketTransformer {
    private static String socks_host;
    private static int socks_port;
    private static String socks_user;
    private static String socks_password;
    private final InetSocketAddress target;
    private Socket control_socket;
    private InetSocketAddress relay;
    private PRUDPPacketHandler delegate;
    private byte[] packet_out_header;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Host", "Proxy.Port", "Proxy.Username", "Proxy.Password"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameter_name) {
                socks_host = COConfigurationManager.getStringParameter("Proxy.Host").trim();
                socks_port = Integer.parseInt(COConfigurationManager.getStringParameter("Proxy.Port").trim());
                socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                socks_password = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    socks_user = "";
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected PRUDPPacketHandlerSocks(InetSocketAddress _target) throws PRUDPPacketHandlerException {
        super();
        this.target = _target;
        ok = false;
        proxy_selector = AEProxySelectorFactory.getSelector();
        proxy = proxy_selector.getSOCKSProxy(PRUDPPacketHandlerSocks.socks_host, PRUDPPacketHandlerSocks.socks_port, this.target);
        proxy_connected = false;
        error = null;
        try {
            this.delegate = PRUDPPacketHandlerImpl.createPacketHandler(0, null, this);
            this.control_socket = new Socket(Proxy.NO_PROXY);
            proxy_address = (InetSocketAddress)proxy.address();
            this.control_socket.connect(proxy_address);
            proxy_connected = true;
            dos = new DataOutputStream(new BufferedOutputStream(this.control_socket.getOutputStream(), 256));
            dis = new DataInputStream(this.control_socket.getInputStream());
            dos.writeByte(5);
            dos.writeByte(2);
            dos.writeByte(0);
            dos.writeByte(2);
            dos.flush();
            dis.readByte();
            method = dis.readByte();
            if (method != 0 && method != 2) {
                throw new IOException("SOCKS 5: no valid method [" + method + "]");
            }
            if (method == 2) {
                dos.writeByte(1);
                dos.writeByte((byte)PRUDPPacketHandlerSocks.socks_user.length());
                dos.write(PRUDPPacketHandlerSocks.socks_user.getBytes());
                dos.writeByte((byte)PRUDPPacketHandlerSocks.socks_password.length());
                dos.write(PRUDPPacketHandlerSocks.socks_password.getBytes());
                dos.flush();
                dis.readByte();
                status = dis.readByte();
                if (status != 0) {
                    throw new IOException("SOCKS 5: authentication fails [status=" + status + "]");
                }
            }
            mapped_ip = this.target.isUnresolved() != false || this.target.getAddress() == null ? AEProxyFactory.getAddressMapper().internalise(this.target.getHostName()) : AddressUtils.getHostNameNoResolve(this.target);
            dos.writeByte(5);
            dos.writeByte(3);
            dos.writeByte(0);
            dos.writeByte(1);
            dos.write(new byte[4]);
            dos.writeShort((short)this.delegate.getPort());
            dos.flush();
            dis.readByte();
            reply = dis.readByte();
            if (reply == 0) ** GOTO lbl57
            if (reply == 69 && proxy_address.getAddress().isLoopbackAddress()) {
                this.control_socket.close();
                this.control_socket = null;
                ok = true;
                return;
            }
            try {
                throw new IOException("SOCKS 5: udp association fails [reply=" + reply + "]");
lbl57:
                // 1 sources

                dis.readByte();
                atype = dis.readByte();
                if (atype == 1) {
                    bytes = new byte[4];
                    dis.readFully(bytes);
                    relay_address = InetAddress.getByAddress(bytes);
                } else if (atype == 3) {
                    len = dis.readByte();
                    bytes = new byte[len & 255];
                    dis.readFully(bytes);
                    relay_address = InetAddress.getByName(new String(bytes));
                } else {
                    bytes = new byte[16];
                    dis.readFully(bytes);
                    relay_address = InetAddress.getByAddress(bytes);
                }
                relay_port = dis.readByte() << 8 & 65280 | dis.readByte() & 255;
                if (relay_address.isAnyLocalAddress()) {
                    relay_address = this.control_socket.getInetAddress();
                }
                this.relay = new InetSocketAddress(relay_address, relay_port);
                baos_temp = new ByteArrayOutputStream();
                dos_temp = new DataOutputStream(baos_temp);
                dos_temp.writeByte(0);
                dos_temp.writeByte(0);
                dos_temp.writeByte(0);
                try {
                    ip_bytes = HostNameToIPResolver.syncResolve(mapped_ip).getAddress();
                    dos_temp.writeByte(ip_bytes.length == 4 ? 1 : 4);
                    dos_temp.write(ip_bytes);
                }
                catch (Throwable e) {
                    dos_temp.writeByte(3);
                    dos_temp.writeByte((byte)mapped_ip.length());
                    dos_temp.write(mapped_ip.getBytes());
                }
                dos_temp.writeShort((short)this.target.getPort());
                dos_temp.flush();
                this.packet_out_header = baos_temp.toByteArray();
                ok = true;
                Thread.sleep(1000L);
            }
            catch (Throwable e) {
                error = e;
                throw new PRUDPPacketHandlerException("socks setup failed: " + Debug.getNestedExceptionMessage(e), e);
            }
        }
        finally {
            if (!proxy_connected) {
                proxy_selector.connectFailed(proxy, error);
            }
            if (!ok) {
                block41: {
                    try {
                        try {
                            this.control_socket.close();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            this.control_socket = null;
                            break block41;
                        }
                    }
                    catch (Throwable var21_21) {
                        this.control_socket = null;
                        throw var21_21;
                    }
                    this.control_socket = null;
                }
                if (this.delegate != null) {
                    try {
                        this.delegate.destroy();
                    }
                    finally {
                        this.delegate = null;
                    }
                }
            }
        }
    }

    @Override
    public void transformSend(DatagramPacket packet) {
        if (this.relay == null) {
            return;
        }
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        byte[] new_data = new byte[data_len + this.packet_out_header.length];
        System.arraycopy(this.packet_out_header, 0, new_data, 0, this.packet_out_header.length);
        System.arraycopy(data, 0, new_data, this.packet_out_header.length, data_len);
        packet.setData(new_data);
    }

    @Override
    public void transformReceive(DatagramPacket packet) {
        if (this.relay == null) {
            return;
        }
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, 0, data_len));
        try {
            dis.readByte();
            dis.readByte();
            dis.readByte();
            byte atype = dis.readByte();
            int encap_len = 4;
            encap_len = atype == 1 ? (encap_len += 4) : (atype == 3 ? (encap_len += 1 + (dis.readByte() & 0xFF)) : (encap_len += 16));
            byte[] new_data = new byte[data_len - (encap_len += 2)];
            System.arraycopy(data, encap_len, new_data, 0, data_len - encap_len);
            packet.setData(new_data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void checkAddress(InetSocketAddress destination) throws PRUDPPacketHandlerException {
        if (!destination.equals(this.target)) {
            throw new PRUDPPacketHandlerException("Destination mismatch");
        }
    }

    @Override
    public void sendAndReceive(PRUDPPacket request_packet, InetSocketAddress destination_address, PRUDPPacketReceiver receiver, long timeout, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        this.delegate.sendAndReceive(request_packet, destination_address, receiver, timeout, priority);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address, timeout_millis);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address, timeout_millis, priority);
    }

    @Override
    public void send(PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        this.delegate.send(request_packet, destination_address);
    }

    @Override
    public PRUDPRequestHandler getRequestHandler() {
        return this.delegate.getRequestHandler();
    }

    @Override
    public void setRequestHandler(PRUDPRequestHandler request_handler) {
        this.delegate.setRequestHandler(request_handler);
    }

    @Override
    public void primordialSend(byte[] data, InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not imp");
    }

    @Override
    public boolean hasPrimordialHandler() {
        return this.delegate.hasPrimordialHandler();
    }

    @Override
    public void addPrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    @Override
    public void removePrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public InetAddress getCurrentBindAddress() {
        return this.delegate.getCurrentBindAddress();
    }

    @Override
    public void setDelays(int send_delay, int receive_delay, int queued_request_timeout) {
        this.delegate.setDelays(send_delay, receive_delay, queued_request_timeout);
    }

    @Override
    public void setExplicitBindAddress(InetAddress address, boolean autoDelegate) {
        this.delegate.setExplicitBindAddress(address, autoDelegate);
    }

    @Override
    public InetAddress getExplicitBindAddress() {
        return this.delegate.getExplicitBindAddress();
    }

    @Override
    public PRUDPPacketHandlerStats getStats() {
        return this.delegate.getStats();
    }

    @Override
    public PRUDPPacketHandler openSession(InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not supported");
    }

    @Override
    public void closeSession() throws PRUDPPacketHandlerException {
        if (this.control_socket != null) {
            try {
                this.control_socket.close();
                this.control_socket = null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    @Override
    public void destroy() {
        try {
            this.closeSession();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }
}

