/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnp.impl.device;

import com.biglybt.core.util.GeneralUtils;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.net.upnp.UPnPDeviceImage;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.impl.UPnPImpl;
import com.biglybt.net.upnp.impl.device.UPnPDeviceImageImpl;
import com.biglybt.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.biglybt.net.upnp.impl.services.UPnPServiceImpl;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class UPnPDeviceImpl
implements UPnPDevice {
    private UPnPRootDeviceImpl root_device;
    private String device_type;
    private String friendly_name;
    private String manufacturer;
    private String manufacturer_url;
    private String model_description;
    private String model_name;
    private String model_number;
    private String model_url;
    private String presentation_url;
    private List devices = new ArrayList();
    private List services = new ArrayList();
    private List<UPnPDeviceImage> images = new ArrayList<UPnPDeviceImage>();

    protected UPnPDeviceImpl(UPnPRootDeviceImpl _root_device, String indent, SimpleXMLParserDocumentNode device_node) {
        SimpleXMLParserDocumentNode icon_list;
        SimpleXMLParserDocumentNode dev_list;
        this.root_device = _root_device;
        this.device_type = this.getMandatoryField(device_node, "DeviceType");
        this.friendly_name = this.getOptionalField(device_node, "FriendlyName");
        this.manufacturer = this.getOptionalField(device_node, "manufacturer");
        this.manufacturer_url = this.getOptionalField(device_node, "manufacturerURL");
        this.model_description = this.getOptionalField(device_node, "modelDescription");
        this.model_name = this.getOptionalField(device_node, "modelName");
        this.model_number = this.getOptionalField(device_node, "modelNumber");
        this.model_url = this.getOptionalField(device_node, "modelURL");
        this.presentation_url = this.getOptionalField(device_node, "presentationURL");
        if (this.friendly_name == null) {
            String[] bits = new String[]{this.manufacturer, this.model_description, this.model_number};
            this.friendly_name = "";
            String[] stringArray = bits;
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                if (bit != null) {
                    this.friendly_name = String.valueOf(this.friendly_name) + (this.friendly_name.length() == 0 ? "" : "/") + bit;
                }
                ++n2;
            }
            if (this.friendly_name.length() == 0) {
                this.friendly_name = "UPnP Device";
            }
        }
        boolean interested = GeneralUtils.startsWithIgnoreCase(this.device_type, "urn:schemas-upnp-org:device:WANConnectionDevice:");
        this.root_device.getUPnP().log(String.valueOf(indent) + this.friendly_name + (interested ? " *" : ""));
        SimpleXMLParserDocumentNode service_list = device_node.getChild("ServiceList");
        if (service_list != null) {
            SimpleXMLParserDocumentNode[] service_nodes = service_list.getChildren();
            int i = 0;
            while (i < service_nodes.length) {
                this.services.add(new UPnPServiceImpl(this, String.valueOf(indent) + "  ", service_nodes[i]));
                ++i;
            }
        }
        if ((dev_list = device_node.getChild("DeviceList")) != null) {
            SimpleXMLParserDocumentNode[] device_nodes = dev_list.getChildren();
            int i = 0;
            while (i < device_nodes.length) {
                this.devices.add(new UPnPDeviceImpl(this.root_device, String.valueOf(indent) + "  ", device_nodes[i]));
                ++i;
            }
        }
        if ((icon_list = device_node.getChild("iconList")) != null) {
            SimpleXMLParserDocumentNode[] children;
            SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = children = icon_list.getChildren();
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                String oUrl;
                SimpleXMLParserDocumentNode child = simpleXMLParserDocumentNodeArray[n3];
                if ("icon".equalsIgnoreCase(child.getName()) && (oUrl = this.getOptionalField(child, "url")) != null) {
                    int width = -1;
                    int height = -1;
                    String oWidth = this.getOptionalField(child, "width");
                    String oHeight = this.getOptionalField(child, "height");
                    try {
                        width = Integer.parseInt(oWidth);
                        height = Integer.parseInt(oHeight);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.images.add(new UPnPDeviceImageImpl(width, height, oUrl, this.getOptionalField(child, "mime")));
                }
                ++n3;
            }
        }
    }

    public String getAbsoluteURL(String url) {
        return this.root_device.getAbsoluteURL(url);
    }

    public InetAddress getLocalAddress() {
        return this.root_device.getLocalAddress();
    }

    public synchronized void clearRelativeBaseURL() {
        this.root_device.clearRelativeBaseURL();
    }

    public synchronized void restoreRelativeBaseURL() {
        this.root_device.restoreRelativeBaseURL();
    }

    public UPnPImpl getUPnP() {
        return (UPnPImpl)this.root_device.getUPnP();
    }

    @Override
    public UPnPRootDeviceImpl getRootDevice() {
        return this.root_device;
    }

    @Override
    public String getDeviceType() {
        return this.device_type;
    }

    @Override
    public String getFriendlyName() {
        return this.friendly_name;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public String getManufacturerURL() {
        return this.manufacturer_url;
    }

    @Override
    public String getModelDescription() {
        return this.model_description;
    }

    @Override
    public String getModelName() {
        return this.model_name;
    }

    @Override
    public String getModelNumber() {
        return this.model_number;
    }

    @Override
    public String getModelURL() {
        return this.model_url;
    }

    @Override
    public String getPresentation() {
        return this.presentation_url == null ? null : this.getAbsoluteURL(this.presentation_url);
    }

    @Override
    public UPnPDevice[] getSubDevices() {
        UPnPDevice[] res = new UPnPDevice[this.devices.size()];
        this.devices.toArray(res);
        return res;
    }

    @Override
    public UPnPService[] getServices() {
        UPnPService[] res = new UPnPService[this.services.size()];
        this.services.toArray(res);
        return res;
    }

    @Override
    public UPnPDeviceImage[] getImages() {
        UPnPDevice root;
        if (this.images.isEmpty() && (root = this.getRootDevice().getDevice()) != this) {
            return root.getImages();
        }
        return this.images.toArray(new UPnPDeviceImage[0]);
    }

    protected String getOptionalField(SimpleXMLParserDocumentNode node, String name) {
        SimpleXMLParserDocumentNode child = node.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getValue().trim();
    }

    protected String getMandatoryField(SimpleXMLParserDocumentNode node, String name) {
        SimpleXMLParserDocumentNode child = node.getChild(name);
        if (child == null) {
            this.root_device.getUPnP().log("Mandatory field '" + name + "' is missing");
            return "<missing field '" + name + "'>";
        }
        return child.getValue().trim();
    }
}

