/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.upnp.impl.ssdp;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.net.udp.mc.MCGroup;
import com.biglybt.net.udp.mc.MCGroupAdapter;
import com.biglybt.net.udp.mc.MCGroupFactory;
import com.biglybt.net.upnp.UPnPException;
import com.biglybt.net.upnp.UPnPSSDP;
import com.biglybt.net.upnp.UPnPSSDPAdapter;
import com.biglybt.net.upnp.UPnPSSDPListener;
import com.biglybt.pif.utils.UTTimer;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SSDPCore
implements UPnPSSDP,
MCGroupAdapter {
    private static final String HTTP_VERSION = "1.1";
    private static final String NL = "\r\n";
    private static Map singletons = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("SSDPCore:class");
    private MCGroup mc_group;
    private UPnPSSDPAdapter adapter;
    private String group_address_str;
    private int group_port;
    private boolean first_response = true;
    private List listeners = new ArrayList();
    private UTTimer timer;
    private List timer_queue = new ArrayList();
    private long time_event_next;
    protected AEMonitor this_mon = new AEMonitor("SSDP");
    private Set<String> ignore_mx = new HashSet<String>();

    public static SSDPCore getSingleton(UPnPSSDPAdapter adapter, String group_address, int group_port, int control_port, String[] selected_interfaces) throws UPnPException {
        try {
            class_mon.enter();
            String key = String.valueOf(group_address) + ":" + group_port + ":" + control_port;
            SSDPCore singleton = (SSDPCore)singletons.get(key);
            if (singleton == null) {
                singleton = new SSDPCore(adapter, group_address, group_port, control_port, selected_interfaces);
                singletons.put(key, singleton);
            }
            SSDPCore sSDPCore = singleton;
            return sSDPCore;
        }
        finally {
            class_mon.exit();
        }
    }

    private SSDPCore(UPnPSSDPAdapter _adapter, String _group_address, int _group_port, int _control_port, String[] _selected_interfaces) throws UPnPException {
        this.adapter = _adapter;
        this.group_address_str = _group_address;
        this.group_port = _group_port;
        try {
            this.mc_group = MCGroupFactory.getSingleton(this, _group_address, this.group_port, _control_port, _selected_interfaces);
        }
        catch (Throwable e) {
            throw new UPnPException("Failed to initialise SSDP", e);
        }
    }

    @Override
    public int getControlPort() {
        return this.mc_group.getControlPort();
    }

    @Override
    public void trace(String str) {
        this.adapter.log(str);
    }

    @Override
    public void log(Throwable e) {
        this.adapter.log(e);
    }

    @Override
    public void notify(String NT, String NTS, String UUID, String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        String str = "NOTIFY * HTTP/1.1\r\nHOST: " + this.group_address_str + ":" + this.group_port + NL + "CACHE-CONTROL: max-age=3600" + NL + "LOCATION: http://%AZINTERFACE%:" + this.mc_group.getControlPort() + "/" + url + NL + "NT: " + NT + NL + "NTS: " + NTS + NL + "SERVER: " + this.getServerName() + NL + "USN: " + (UUID == null ? "" : String.valueOf(UUID) + "::") + NT + NL + NL;
        try {
            this.mc_group.sendToGroup(str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getServerName() {
        return String.valueOf(Constants.OSName) + "/" + Constants.OSVersion + " UPnP/1.0 " + "BiglyBT" + "/" + "3.9.0.0";
    }

    @Override
    public void search(String[] STs) {
        String[] stringArray = STs;
        int n = STs.length;
        int n2 = 0;
        while (n2 < n) {
            String ST = stringArray[n2];
            String str = "M-SEARCH * HTTP/1.1\r\nST: " + ST + NL + "MX: 3" + NL + "MAN: \"ssdp:discover\"" + NL + "HOST: " + this.group_address_str + ":" + this.group_port + NL + NL;
            this.sendMC(str);
            ++n2;
        }
    }

    protected void sendMC(String str) {
        byte[] data = str.getBytes();
        try {
            this.mc_group.sendToGroup(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void interfaceChanged(NetworkInterface network_interface) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).interfaceChanged(network_interface);
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(NetworkInterface network_interface, InetAddress local_address, final InetSocketAddress originator, byte[] packet_data, int length) {
        Object line;
        int p1;
        String str = new String(packet_data, 0, length);
        if (this.first_response) {
            this.first_response = false;
            this.adapter.trace("UPnP:SSDP: first response:\n" + str);
        }
        ArrayList<String> lines = new ArrayList<String>();
        int pos = 0;
        do {
            String line2;
            if ((p1 = str.indexOf(NL, pos)) == -1) {
                line2 = str.substring(pos);
            } else {
                line2 = str.substring(pos, p1);
                pos = p1 + 1;
            }
            lines.add(line2.trim());
        } while (p1 != -1);
        if (lines.size() == 0) {
            this.adapter.trace("SSDP::receive packet - 0 line reply");
            return;
        }
        String header = (String)lines.get(0);
        URL location = null;
        String usn = null;
        String nt = null;
        String nts = null;
        String st = null;
        String al = null;
        String mx = null;
        String server = null;
        int i = 1;
        while (i < lines.size()) {
            block62: {
                line = (String)lines.get(i);
                int c_pos = ((String)line).indexOf(":");
                if (c_pos != -1) {
                    String key = ((String)line).substring(0, c_pos).trim().toUpperCase();
                    String val = ((String)line).substring(c_pos + 1).trim();
                    if (key.equals("LOCATION")) {
                        try {
                            if (!val.equals("*")) {
                                location = new URL(val);
                            }
                            break block62;
                        }
                        catch (MalformedURLException e) {
                            if (!val.contains("//")) {
                                val = "http://" + val;
                                try {
                                    location = new URL(val);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (location == null) {
                                this.adapter.log(e);
                            }
                            break block62;
                        }
                    }
                    if (key.equals("NT")) {
                        nt = val;
                    } else if (key.equals("USN")) {
                        usn = val;
                    } else if (key.equals("NTS")) {
                        nts = val;
                    } else if (key.equals("ST")) {
                        st = val;
                    } else if (key.equals("AL")) {
                        al = val;
                    } else if (key.equals("MX")) {
                        mx = val;
                    } else if (key.equals("SERVER")) {
                        server = val;
                    }
                }
            }
            ++i;
        }
        if (server != null && server.toLowerCase().startsWith("xbox")) {
            String host = originator.getAddress().getHostAddress();
            line = this.ignore_mx;
            synchronized (line) {
                this.ignore_mx.add(host);
            }
        }
        if (mx != null) {
            String host = originator.getAddress().getHostAddress();
            line = this.ignore_mx;
            synchronized (line) {
                if (this.ignore_mx.contains(host)) {
                    mx = null;
                }
            }
        }
        if (header.startsWith("M-SEARCH")) {
            if (st != null) {
                String[] response = this.informSearch(network_interface, local_address, originator.getAddress(), st);
                if (response != null) {
                    String UUID = response[0];
                    String url = response[1];
                    if (url.startsWith("/")) {
                        url = url.substring(1);
                    }
                    String data = "HTTP/1.1 200 OK\r\nUSN: " + UUID + "::" + st + NL + "ST: " + st + NL + "EXT:" + NL + "Location: http://" + local_address.getHostAddress() + ":" + this.mc_group.getControlPort() + "/" + url + NL + "Server: " + Constants.APP_NAME + "/" + "3.9.0.0" + " UPnP/1.0 " + Constants.APP_NAME + "/" + "3.9.0.0" + NL + "Cache-Control: max-age=3600" + NL + "Date: " + TimeFormatter.getHTTPDate(SystemTime.getCurrentTime()) + NL + "Content-Length: 0" + NL + NL;
                    final byte[] data_bytes = data.getBytes();
                    if (this.timer == null) {
                        this.timer = this.adapter.createTimer("SSDPCore:MX");
                    }
                    int delay = 0;
                    if (mx != null) {
                        try {
                            delay = Integer.parseInt(mx) * 1000;
                            delay = RandomUtils.nextInt(delay);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    Runnable task2 = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SSDPCore.this.mc_group.sendToMember(originator, data_bytes);
                            }
                            catch (Throwable e) {
                                SSDPCore.this.adapter.log(e);
                            }
                        }
                    };
                    if (delay == 0) {
                        task2.run();
                    } else {
                        boolean schedule_event;
                        long target_time = SystemTime.getCurrentTime() + (long)delay;
                        List list = this.timer_queue;
                        synchronized (list) {
                            this.timer_queue.add(task2);
                            boolean bl = schedule_event = this.time_event_next == 0L || target_time < this.time_event_next;
                            if (schedule_event) {
                                this.time_event_next = target_time;
                            }
                        }
                        if (schedule_event) {
                            this.timer.addEvent(target_time, new UTTimerEventPerformer(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void perform(UTTimerEvent event2) {
                                    while (true) {
                                        Runnable t;
                                        List list = SSDPCore.this.timer_queue;
                                        synchronized (list) {
                                            if (SSDPCore.this.timer_queue.size() <= 0) {
                                                SSDPCore.this.time_event_next = 0L;
                                                return;
                                            }
                                            t = (Runnable)SSDPCore.this.timer_queue.remove(0);
                                        }
                                        try {
                                            t.run();
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
            } else {
                this.adapter.trace("SSDP::receive M-SEARCH - bad header:" + header);
            }
        } else if (header.startsWith("NOTIFY")) {
            if (nt != null && nts != null) {
                this.informNotify(network_interface, local_address, originator.getAddress(), usn, location, nt, nts);
            } else {
                this.adapter.trace("SSDP::receive NOTIFY - bad header:" + header);
            }
        } else if (header.startsWith("HTTP") && header.contains("200")) {
            if (location != null && st != null) {
                this.informResult(network_interface, local_address, originator.getAddress(), usn, location, st, al);
            } else {
                this.adapter.trace("SSDP::receive HTTP - bad header:" + header);
            }
        } else {
            this.adapter.trace("SSDP::receive packet - bad header:" + header);
        }
    }

    protected void informResult(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String usn, URL location, String st, String al) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).receivedResult(network_interface, local_address, originator, usn, location, st, al);
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
            ++i;
        }
    }

    protected void informNotify(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String usn, URL location, String nt, String nts) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).receivedNotify(network_interface, local_address, originator, usn, location, nt, nts);
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
            ++i;
        }
    }

    protected String[] informSearch(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String st) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                String[] res = ((UPnPSSDPListener)this.listeners.get(i)).receivedSearch(network_interface, local_address, originator, st);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addListener(UPnPSSDPListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(UPnPSSDPListener l) {
        this.listeners.remove(l);
    }
}

