/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.ddb;

import com.biglybt.pif.ddb.DistributedDatabaseContact;
import com.biglybt.pif.ddb.DistributedDatabaseException;
import com.biglybt.pif.ddb.DistributedDatabaseKey;
import com.biglybt.pif.ddb.DistributedDatabaseListener;
import com.biglybt.pif.ddb.DistributedDatabaseTransferHandler;
import com.biglybt.pif.ddb.DistributedDatabaseTransferType;
import com.biglybt.pif.ddb.DistributedDatabaseValue;
import com.biglybt.plugin.dht.DHTPluginInterface;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;

public interface DistributedDatabase {
    public static final int OP_NONE = 0;
    public static final int OP_EXHAUSTIVE_READ = 1;
    public static final int OP_PRIORITY_HIGH = 2;
    public static final byte DT_NONE = 1;
    public static final byte DT_FREQUENCY = 2;
    public static final byte DT_SIZE = 3;

    public boolean isAvailable();

    public boolean isInitialized();

    public boolean isExtendedUseAllowed();

    public String getNetwork();

    public DHTPluginInterface getDHTPlugin();

    public DistributedDatabaseContact getLocalContact();

    public DistributedDatabaseKey createKey(Object var1) throws DistributedDatabaseException;

    public DistributedDatabaseKey createKey(Object var1, String var2) throws DistributedDatabaseException;

    public DistributedDatabaseValue createValue(Object var1) throws DistributedDatabaseException;

    public DistributedDatabaseContact importContact(InetSocketAddress var1) throws DistributedDatabaseException;

    public DistributedDatabaseContact importContact(InetSocketAddress var1, byte var2) throws DistributedDatabaseException;

    public DistributedDatabaseContact importContact(InetSocketAddress var1, byte var2, int var3) throws DistributedDatabaseException;

    public DistributedDatabaseContact importContact(Map<String, Object> var1) throws DistributedDatabaseException;

    public void write(DistributedDatabaseListener var1, DistributedDatabaseKey var2, DistributedDatabaseValue var3) throws DistributedDatabaseException;

    public void write(DistributedDatabaseListener var1, DistributedDatabaseKey var2, DistributedDatabaseValue[] var3) throws DistributedDatabaseException;

    public void read(DistributedDatabaseListener var1, DistributedDatabaseKey var2, long var3) throws DistributedDatabaseException;

    public void read(DistributedDatabaseListener var1, DistributedDatabaseKey var2, long var3, int var5) throws DistributedDatabaseException;

    public void readKeyStats(DistributedDatabaseListener var1, DistributedDatabaseKey var2, long var3) throws DistributedDatabaseException;

    public List<DistributedDatabaseValue> getValues(DistributedDatabaseKey var1) throws DistributedDatabaseException;

    public void delete(DistributedDatabaseListener var1, DistributedDatabaseKey var2) throws DistributedDatabaseException;

    public void delete(DistributedDatabaseListener var1, DistributedDatabaseKey var2, DistributedDatabaseContact[] var3) throws DistributedDatabaseException;

    public void addTransferHandler(DistributedDatabaseTransferType var1, DistributedDatabaseTransferHandler var2) throws DistributedDatabaseException;

    public DistributedDatabaseTransferType getStandardTransferType(int var1) throws DistributedDatabaseException;

    public void addListener(DistributedDatabaseListener var1);

    public void removeListener(DistributedDatabaseListener var1);
}

