/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local;

import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.tracker.server.TRTrackerServerTorrent;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.disk.DiskManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.disk.DiskManagerFileInfoImpl;
import com.biglybt.pifimpl.local.disk.DiskManagerImpl;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.pifimpl.local.network.ConnectionImpl;
import com.biglybt.pifimpl.local.peers.PeerImpl;
import com.biglybt.pifimpl.local.peers.PeerManagerImpl;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.tracker.TrackerTorrentImpl;
import java.io.File;
import java.io.IOException;

public class PluginCoreUtils {
    public static Torrent wrap(TOTorrent t) {
        return new TorrentImpl(t);
    }

    public static TOTorrent unwrap(Torrent t) {
        return ((TorrentImpl)t).getTorrent();
    }

    public static DiskManager wrap(com.biglybt.core.disk.DiskManager dm) {
        return new DiskManagerImpl(dm);
    }

    public static com.biglybt.core.disk.DiskManager unwrap(DiskManager dm) {
        return ((DiskManagerImpl)dm).getDiskmanager();
    }

    public static Download wrap(DownloadManager dm) {
        try {
            return DownloadManagerImpl.getDownloadStatic(dm);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static NetworkConnection unwrap(Connection connection) {
        if (connection instanceof ConnectionImpl) {
            return ((ConnectionImpl)connection).getCoreConnection();
        }
        return null;
    }

    public static Connection wrap(NetworkConnection connection) {
        return new ConnectionImpl(connection, connection.isIncoming());
    }

    public static DiskManagerFileInfo wrap(com.biglybt.core.disk.DiskManagerFileInfo info) throws DownloadException {
        if (info == null) {
            return null;
        }
        return new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(info.getDownloadManager()), info);
    }

    public static com.biglybt.core.disk.DiskManagerFileInfo unwrap(final DiskManagerFileInfo info) throws DownloadException {
        if (info instanceof DiskManagerFileInfoImpl) {
            return ((DiskManagerFileInfoImpl)info).getCore();
        }
        if (info == null) {
            return null;
        }
        try {
            Download dl = info.getDownload();
            if (dl != null) {
                DownloadManager dm = PluginCoreUtils.unwrap(dl);
                return dm.getDiskManagerFileInfo()[info.getIndex()];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new com.biglybt.core.disk.DiskManagerFileInfo(){

            @Override
            public void setPriority(int b) {
                info.setNumericPriority(b);
            }

            @Override
            public void setSkipped(boolean b) {
                info.setSkipped(b);
            }

            @Override
            public Boolean isSkipping() {
                return info.isSkipping();
            }

            @Override
            public boolean setLink(File link_destination, boolean dont_delete) {
                info.setLink(link_destination, dont_delete);
                return true;
            }

            @Override
            public boolean setLinkAtomic(File link_destination, boolean dont_delete) {
                info.setLink(link_destination, dont_delete);
                return true;
            }

            @Override
            public String getLastError() {
                return null;
            }

            @Override
            public boolean setLinkAtomic(File link_destination, boolean dont_delete, FileUtil.ProgressListener pl) {
                info.setLink(link_destination, dont_delete);
                return true;
            }

            @Override
            public File getLink() {
                return info.getLink();
            }

            @Override
            public boolean setStorageType(int type, boolean force) {
                return false;
            }

            @Override
            public int getStorageType() {
                return 1;
            }

            @Override
            public int getAccessMode() {
                return info.getAccessMode();
            }

            @Override
            public long getDownloaded() {
                return info.getDownloaded();
            }

            @Override
            public long getLastModified() {
                return info.getLastModified();
            }

            @Override
            public String getExtension() {
                return "";
            }

            @Override
            public int getFirstPieceNumber() {
                return info.getFirstPieceNumber();
            }

            @Override
            public int getLastPieceNumber() {
                return (int)((info.getLength() + info.getPieceSize() - 1L) / info.getPieceSize());
            }

            @Override
            public long getLength() {
                return info.getLength();
            }

            @Override
            public int getNbPieces() {
                return info.getNumPieces();
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public int getPriority() {
                return info.getNumericPriority();
            }

            @Override
            public boolean isSkipped() {
                return info.isSkipped();
            }

            @Override
            public int getIndex() {
                return info.getIndex();
            }

            @Override
            public DownloadManager getDownloadManager() {
                return null;
            }

            @Override
            public com.biglybt.core.disk.DiskManager getDiskManager() {
                return null;
            }

            @Override
            public File getFile(boolean follow_link) {
                if (follow_link) {
                    return info.getLink();
                }
                return info.getFile();
            }

            @Override
            public TOTorrentFile getTorrentFile() {
                return null;
            }

            @Override
            public DirectByteBuffer read(long offset, int length) throws IOException {
                throw new IOException("unsupported");
            }

            @Override
            public void flushCache() throws Exception {
            }

            @Override
            public int getReadBytesPerSecond() {
                return 0;
            }

            @Override
            public int getWriteBytesPerSecond() {
                return 0;
            }

            @Override
            public long getETA() {
                return -1L;
            }

            @Override
            public void recheck() {
            }

            @Override
            public void close() {
            }

            @Override
            public void addListener(DiskManagerFileInfoListener listener) {
            }

            @Override
            public void removeListener(DiskManagerFileInfoListener listener) {
            }
        };
    }

    public static Object convert(Object datasource, boolean toCore) {
        if (datasource instanceof Object[]) {
            Object[] array = (Object[])datasource;
            if (array.length == 0) {
                return null;
            }
            Object[] newArray = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                Object o = array[i];
                newArray[i] = PluginCoreUtils.convert(o, toCore);
                ++i;
            }
            return newArray;
        }
        try {
            if (toCore) {
                if (datasource instanceof DownloadManager) {
                    return datasource;
                }
                if (datasource instanceof DownloadImpl) {
                    return ((DownloadImpl)datasource).getDownload();
                }
                if (datasource instanceof com.biglybt.core.disk.DiskManager) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerImpl) {
                    return ((DiskManagerImpl)datasource).getDiskmanager();
                }
                if (datasource instanceof PEPeerManager) {
                    return datasource;
                }
                if (datasource instanceof PeerManagerImpl) {
                    return ((PeerManagerImpl)datasource).getDelegate();
                }
                if (datasource instanceof PEPeer) {
                    return datasource;
                }
                if (datasource instanceof PeerImpl) {
                    return ((PeerImpl)datasource).getPEPeer();
                }
                if (datasource instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
                    return datasource;
                }
                if (datasource instanceof DiskManagerFileInfoImpl) {
                    return ((DiskManagerFileInfoImpl)datasource).getCore();
                }
                if (datasource instanceof TRHostTorrent) {
                    return datasource;
                }
                if (datasource instanceof TrackerTorrentImpl) {
                    ((TrackerTorrentImpl)datasource).getHostTorrent();
                }
            } else {
                com.biglybt.core.disk.DiskManagerFileInfo fileInfo2;
                if (datasource instanceof DownloadManager) {
                    return PluginCoreUtils.wrap((DownloadManager)datasource);
                }
                if (datasource instanceof DownloadImpl) {
                    return datasource;
                }
                if (datasource instanceof com.biglybt.core.disk.DiskManager) {
                    return PluginCoreUtils.wrap((com.biglybt.core.disk.DiskManager)datasource);
                }
                if (datasource instanceof DiskManagerImpl) {
                    return datasource;
                }
                if (datasource instanceof PEPeerManager) {
                    return PluginCoreUtils.wrap((PEPeerManager)datasource);
                }
                if (datasource instanceof PeerManagerImpl) {
                    return datasource;
                }
                if (datasource instanceof PEPeer) {
                    return PeerManagerImpl.getPeerForPEPeer((PEPeer)datasource);
                }
                if (datasource instanceof Peer) {
                    return datasource;
                }
                if (datasource instanceof com.biglybt.core.disk.DiskManagerFileInfo && (fileInfo2 = (com.biglybt.core.disk.DiskManagerFileInfo)datasource) != null) {
                    try {
                        DownloadManager dm = fileInfo2.getDownloadManager();
                        return new DiskManagerFileInfoImpl(dm == null ? null : DownloadManagerImpl.getDownloadStatic(dm), fileInfo2);
                    }
                    catch (DownloadException downloadException) {
                        // empty catch block
                    }
                }
                if (datasource instanceof DiskManagerFileInfoImpl) {
                    return datasource;
                }
                if (datasource instanceof TRHostTorrent) {
                    TRHostTorrent item = (TRHostTorrent)datasource;
                    return new TrackerTorrentImpl(item);
                }
                if (datasource instanceof TrackerTorrentImpl) {
                    return datasource;
                }
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return datasource;
    }

    public static DownloadManager unwrapIfPossible(Download dm) {
        if (dm instanceof DownloadImpl) {
            return ((DownloadImpl)dm).getDownload();
        }
        return null;
    }

    public static DownloadManager unwrap(Download dm) {
        if (dm instanceof DownloadImpl) {
            return ((DownloadImpl)dm).getDownload();
        }
        Debug.out("Can't unwrap " + dm);
        return null;
    }

    public static PeerManager wrap(PEPeerManager pm) {
        return PeerManagerImpl.getPeerManager(pm);
    }

    public static PEPeerManager unwrap(PeerManager pm) {
        return ((PeerManagerImpl)pm).getDelegate();
    }

    public static TRTrackerServerTorrent unwrap(TrackerTorrent torrent) {
        return ((TrackerTorrentImpl)torrent).getHostTorrent().getTrackerTorrent();
    }

    public static Peer wrap(PEPeer peer) {
        return PeerManagerImpl.getPeerForPEPeer(peer);
    }

    public static PEPeer unwrap(Peer peer) {
        if (peer instanceof PeerImpl) {
            return ((PeerImpl)peer).getDelegate();
        }
        return null;
    }

    public static boolean isInitialisationComplete() {
        return PluginInitializer.getDefaultInterface().getPluginState().isInitialisationComplete();
    }
}

