/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local;

import com.biglybt.core.CoreComponent;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.PluginState;
import com.biglybt.pif.clientid.ClientIDManager;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.dht.mainline.MainlineDHTManager;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.ipfilter.IPFilter;
import com.biglybt.pif.logging.Logger;
import com.biglybt.pif.messaging.MessageManager;
import com.biglybt.pif.network.ConnectionManager;
import com.biglybt.pif.platform.PlatformManager;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.pif.utils.ShortCuts;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pifimpl.local.FailedPlugin;
import com.biglybt.pifimpl.local.PluginConfigImpl;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.PluginStateImpl;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.pifimpl.local.ddb.DDBaseImpl;
import com.biglybt.pifimpl.local.dht.mainline.MainlineDHTManagerImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.pifimpl.local.ipc.IPCInterfaceImpl;
import com.biglybt.pifimpl.local.ipfilter.IPFilterImpl;
import com.biglybt.pifimpl.local.logging.LoggerImpl;
import com.biglybt.pifimpl.local.messaging.MessageManagerImpl;
import com.biglybt.pifimpl.local.network.ConnectionManagerImpl;
import com.biglybt.pifimpl.local.sharing.ShareManagerImpl;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.pifimpl.local.tracker.TrackerImpl;
import com.biglybt.pifimpl.local.ui.UIManagerImpl;
import com.biglybt.pifimpl.local.update.UpdateManagerImpl;
import com.biglybt.pifimpl.local.utils.ShortCutsImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public final class PluginInterfaceImpl
implements PluginInterface,
CoreComponent {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Plugin plugin;
    private PluginInitializer initialiser;
    private Object initialiser_key;
    protected ClassLoader class_loader;
    private CopyOnWriteList<PluginListener> listeners = new CopyOnWriteList();
    private Set<PluginListener> init_complete_fired_set = new HashSet<PluginListener>();
    private CopyOnWriteList<PluginEventListener> event_listeners = new CopyOnWriteList();
    private String key;
    private String pluginConfigKey;
    private Properties props;
    private String pluginDir;
    private PluginConfigImpl config;
    private String plugin_version;
    private Logger logger;
    private IPCInterfaceImpl ipc_interface;
    protected List children = new ArrayList();
    private final PluginStateImpl state;
    private String given_plugin_id;
    private String plugin_id_to_use;

    protected PluginInterfaceImpl(Plugin _plugin, PluginInitializer _initialiser, Object _initialiser_key, ClassLoader _class_loader, List<File> _verified_files, String _key, Properties _props, String _pluginDir, String _plugin_id, String _plugin_version) throws PluginException {
        this.plugin = _plugin;
        this.initialiser = _initialiser;
        this.initialiser_key = _initialiser_key;
        this.class_loader = _class_loader;
        this.key = _key;
        this.pluginConfigKey = "Plugin." + _key;
        this.props = new propertyWrapper(_props);
        this.pluginDir = _pluginDir;
        this.config = new PluginConfigImpl(this, this.pluginConfigKey);
        this.given_plugin_id = _plugin_id;
        this.plugin_version = _plugin_version;
        this.ipc_interface = new IPCInterfaceImpl(this.initialiser, this.plugin);
        this.state = new PluginStateImpl(this, this.initialiser);
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public Object getInitializerKey() {
        return this.initialiser_key;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.initialiser.getPluginManager();
    }

    @Override
    public String getApplicationName() {
        return Constants.APP_NAME;
    }

    @Override
    public String getAzureusName() {
        return "BiglyBT";
    }

    @Override
    public String getApplicationVersion() {
        return "3.9.0.0";
    }

    public void setPluginName(String name) {
        this.props.put("plugin.name", name);
    }

    @Override
    public String getPluginName() {
        String name = null;
        if (this.props != null) {
            name = (String)this.props.get("plugin.name");
        }
        if (name == null) {
            try {
                name = FileUtil.newFile(this.pluginDir, new String[0]).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (name == null || name.length() == 0) {
            name = this.plugin.getClass().getName();
        }
        return name;
    }

    public void setPluginVersion(String version) {
        this.props.put("plugin.version", version);
    }

    @Override
    public String getPluginVersion() {
        String version = (String)this.props.get("plugin.version");
        if (version == null) {
            version = this.plugin_version;
        }
        return version;
    }

    @Override
    public String getPluginID() {
        String id = (String)this.props.get("plugin.id");
        if (id != null && id.equals("azupdater")) {
            this.plugin_id_to_use = id;
        }
        if (this.plugin_id_to_use != null) {
            return this.plugin_id_to_use;
        }
        if (id == null) {
            id = this.given_plugin_id;
        }
        if (id == null) {
            id = "<none>";
        }
        this.plugin_id_to_use = id;
        return this.plugin_id_to_use;
    }

    @Override
    public Properties getPluginProperties() {
        return this.props;
    }

    @Override
    public String getPluginDirectoryName() {
        return this.pluginDir;
    }

    @Override
    public String getPerUserPluginDirectoryName() {
        String name = this.pluginDir == null ? this.getPluginID() : FileUtil.newFile(this.pluginDir, new String[0]).getName();
        String str = FileUtil.newFile(SystemProperties.getUserPath(), "plugins", name).getAbsolutePath();
        if (this.pluginDir == null) {
            return str;
        }
        try {
            if (FileUtil.newFile(this.pluginDir, new String[0]).getCanonicalPath().equals(FileUtil.newFile(str, new String[0]).getCanonicalPath())) {
                return this.pluginDir;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return str;
    }

    public void setPluginDirectoryName(String name) {
        this.initialiser_key = FileUtil.newFile(name, new String[0]);
        this.pluginDir = name;
    }

    @Override
    public PluginConfig getPluginconfig() {
        return this.config;
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    @Override
    public Tracker getTracker() {
        return TrackerImpl.getSingleton();
    }

    @Override
    public ShareManager getShareManager() throws ShareException {
        return ShareManagerImpl.getSingleton();
    }

    @Override
    public DownloadManager getDownloadManager() {
        return DownloadManagerImpl.getSingleton(this.initialiser.getCore());
    }

    @Override
    public MainlineDHTManager getMainlineDHTManager() {
        return new MainlineDHTManagerImpl(this.initialiser.getCore());
    }

    @Override
    public TorrentManager getTorrentManager() {
        return TorrentManagerImpl.getSingleton().specialise(this);
    }

    @Override
    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl(this);
        }
        return this.logger;
    }

    @Override
    public IPFilter getIPFilter() {
        return new IPFilterImpl();
    }

    @Override
    public Utilities getUtilities() {
        return new UtilitiesImpl(this.initialiser.getCore(), this);
    }

    @Override
    public ShortCuts getShortCuts() {
        return new ShortCutsImpl(this);
    }

    @Override
    public UIManager getUIManager() {
        return new UIManagerImpl(this);
    }

    @Override
    public UpdateManager getUpdateManager() {
        return UpdateManagerImpl.getSingleton(this.initialiser.getCore());
    }

    protected void unloadSupport() {
        this.ipc_interface.unload();
        UIManagerImpl.unload(this);
    }

    @Override
    public boolean isInitialisationThread() {
        return this.initialiser.isInitialisationThread();
    }

    @Override
    public ClientIDManager getClientIDManager() {
        return ClientIDManagerImpl.getSingleton();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return ConnectionManagerImpl.getSingleton(this.initialiser.getCore());
    }

    @Override
    public MessageManager getMessageManager() {
        return MessageManagerImpl.getSingleton(this.initialiser.getCore());
    }

    @Override
    public DistributedDatabase getDistributedDatabase() {
        return DDBaseImpl.getSingleton(this.initialiser.getCore());
    }

    @Override
    public PlatformManager getPlatformManager() {
        return PlatformManagerFactory.getPlatformManager();
    }

    protected void initialisationComplete() {
        Iterator<PluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                this.fireInitComplete(it.next());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < this.children.size()) {
            ((PluginInterfaceImpl)this.children.get(i)).initialisationComplete();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInitComplete(PluginListener listener) {
        Set<PluginListener> set = this.init_complete_fired_set;
        synchronized (set) {
            if (this.init_complete_fired_set.contains(listener)) {
                return;
            }
            this.init_complete_fired_set.add(listener);
        }
        try {
            listener.initializationComplete();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    protected void closedownInitiated() {
        Iterator<PluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().closedownInitiated();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < this.children.size()) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownInitiated();
            ++i;
        }
    }

    protected void closedownComplete() {
        Iterator<PluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().closedownComplete();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < this.children.size()) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownComplete();
            ++i;
        }
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.class_loader;
    }

    @Override
    public PluginInterface getLocalPluginInterface(Class plugin_class, String id) throws PluginException {
        try {
            Plugin p = (Plugin)plugin_class.newInstance();
            Properties local_props = new Properties(this.props);
            local_props.remove("plugin.id");
            if (id.endsWith("_v")) {
                throw new Exception("Verified plugins must be loaded from a jar");
            }
            PluginInterfaceImpl pi = new PluginInterfaceImpl(p, this.initialiser, this.initialiser_key, this.class_loader, null, String.valueOf(this.key) + "." + id, local_props, this.pluginDir, String.valueOf(this.getPluginID()) + "." + id, this.plugin_version);
            this.initialiser.fireCreated(pi);
            p.initialize(pi);
            this.children.add(pi);
            return pi;
        }
        catch (Throwable e) {
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Local initialisation fails", e);
        }
    }

    @Override
    public IPCInterfaceImpl getIPC() {
        return this.ipc_interface;
    }

    void setAsFailed() {
        this.getPluginState().setDisabled(true);
        this.state.failed = true;
    }

    protected void destroy() {
        this.class_loader = null;
        this.plugin = new FailedPlugin("Plugin '" + this.getPluginID() + "' has been unloaded!", null);
    }

    @Override
    public void addListener(PluginListener l) {
        this.listeners.add(l);
        if (this.initialiser.isInitialisationComplete()) {
            this.fireInitComplete(l);
        }
    }

    @Override
    public void removeListener(final PluginListener l) {
        this.listeners.remove(l);
        new DelayedEvent("PIL:clear", 10000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                Set set = PluginInterfaceImpl.this.init_complete_fired_set;
                synchronized (set) {
                    PluginInterfaceImpl.this.init_complete_fired_set.remove(l);
                }
            }
        });
    }

    @Override
    public void addEventListener(final PluginEventListener l) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                List<PluginEvent> events = PluginInterfaceImpl.this.initialiser.getPEVHistory();
                for (PluginEvent event2 : events) {
                    try {
                        l.handleEvent(event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                PluginInterfaceImpl.this.event_listeners.add(l);
            }
        });
    }

    @Override
    public void removeEventListener(final PluginEventListener l) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                PluginInterfaceImpl.this.event_listeners.remove(l);
            }
        });
    }

    @Override
    public void firePluginEvent(final PluginEvent event2) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                PluginInterfaceImpl.this.firePluginEventSupport(event2);
            }
        });
    }

    protected void firePluginEventSupport(PluginEvent event2) {
        Iterator<PluginEventListener> it = this.event_listeners.iterator();
        while (it.hasNext()) {
            try {
                PluginEventListener listener = it.next();
                listener.handleEvent(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < this.children.size()) {
            ((PluginInterfaceImpl)this.children.get(i)).firePluginEvent(event2);
            ++i;
        }
    }

    protected void generateEvidence(IndentWriter writer) {
        block15: {
            writer.println(this.getPluginName());
            try {
                String[] files;
                File dir;
                String type;
                writer.indent();
                writer.println("id:" + this.getPluginID() + ",version:" + this.getPluginVersion());
                String user_dir = FileUtil.getUserFile("plugins").toString();
                String shared_dir = FileUtil.getApplicationFile("plugins").toString();
                String plugin_dir = this.getPluginDirectoryName();
                boolean built_in = false;
                if (plugin_dir.startsWith(shared_dir)) {
                    type = "shared";
                } else if (plugin_dir.startsWith(user_dir)) {
                    type = "per-user";
                } else {
                    built_in = true;
                    type = "built-in";
                }
                PluginState ps = this.getPluginState();
                String info = this.getPluginconfig().getPluginStringParameter("plugin.info");
                writer.println("type:" + type + ",enabled=" + !ps.isDisabled() + ",load_at_start=" + ps.isLoadedAtStartup() + ",operational=" + ps.isOperational() + (info == null || info.length() == 0 ? "" : ",info=" + info));
                if (ps.isOperational()) {
                    Plugin plugin = this.getPlugin();
                    if (!(plugin instanceof AEDiagnosticsEvidenceGenerator)) break block15;
                    try {
                        try {
                            writer.indent();
                            ((AEDiagnosticsEvidenceGenerator)((Object)plugin)).generate(writer);
                        }
                        catch (Throwable e) {
                            writer.println("Failed to generate plugin-specific info: " + Debug.getNestedExceptionMessage(e));
                            writer.exdent();
                        }
                        break block15;
                    }
                    finally {
                        writer.exdent();
                    }
                }
                if (!built_in && (dir = FileUtil.newFile(plugin_dir, new String[0])).exists() && (files = dir.list()) != null) {
                    String files_str = "";
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        files_str = String.valueOf(files_str) + (files_str.length() == 0 ? "" : ", ") + f;
                        ++n2;
                    }
                    writer.println("    files: " + files_str);
                }
            }
            finally {
                writer.exdent();
            }
        }
    }

    @Override
    public PluginState getPluginState() {
        return this.state;
    }

    PluginStateImpl getPluginStateImpl() {
        return this.state;
    }

    protected class propertyWrapper
    extends Properties {
        protected boolean initialising = true;

        protected propertyWrapper(Properties _props) {
            for (Object key : _props.keySet()) {
                this.put(key, _props.get(key));
            }
            this.initialising = false;
        }

        @Override
        public Object setProperty(String str, String val) {
            if (!(PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") || PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") || PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.biglybt.") || !str.equalsIgnoreCase("plugin.id") && !str.equalsIgnoreCase("plugin.version"))) {
                if (com.biglybt.core.logging.Logger.isEnabled()) {
                    com.biglybt.core.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + str + "' - action ignored"));
                }
                return null;
            }
            return super.setProperty(str, val);
        }

        @Override
        public Object put(Object key, Object value) {
            String k_str;
            if (!(PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") || PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") || PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.biglybt.") || this.initialising || !(key instanceof String) || !(k_str = (String)key).equalsIgnoreCase("plugin.id") && !k_str.equalsIgnoreCase("plugin.version"))) {
                if (com.biglybt.core.logging.Logger.isEnabled()) {
                    com.biglybt.core.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + k_str + "' - action ignored"));
                }
                return null;
            }
            return super.put(key, value);
        }

        @Override
        public Object get(Object key) {
            return super.get(key);
        }
    }
}

