/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.PluginInterfaceImpl;
import com.biglybt.pifimpl.local.installer.PluginInstallerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PluginManagerImpl
extends PluginManager {
    protected static boolean running = false;
    private static final boolean GET_PI_METHODS_OPERATIONAL_FLAG_DEFAULT = true;
    protected static PluginManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected static Core core;
    protected PluginInitializer pi;

    static {
        class_mon = new AEMonitor("PluginManager");
    }

    protected static PluginManagerImpl getSingleton(PluginInitializer pi) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginManagerImpl(pi);
            }
            PluginManagerImpl pluginManagerImpl = singleton;
            return pluginManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void startClient(String ui, Properties properties, final PluginManager.StartClientListener startClientListener) throws PluginException {
        String disable_native;
        String doc_dir;
        String user_dir;
        try {
            class_mon.enter();
            if (running) {
                throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " is already running");
            }
            running = true;
        }
        finally {
            class_mon.exit();
        }
        String config_dir = (String)properties.get("USER_DIR");
        if (config_dir != null) {
            System.setProperty(SystemProperties.SYSPROP_CONFIG_PATH, config_dir);
        }
        if ((user_dir = (String)properties.get("APP_DIR")) != null) {
            System.setProperty(SystemProperties.SYSPROP_INSTALL_PATH, user_dir);
            System.setProperty("user.dir", user_dir);
        }
        if ((doc_dir = (String)properties.get("DOC_DIR")) != null) {
            System.setProperty(SystemProperties.SYSPROP_DOC_PATH, doc_dir);
        }
        if ((disable_native = (String)properties.get("DISABLE_NATIVE")) != null && disable_native.equalsIgnoreCase("true")) {
            System.setProperty(SystemProperties.SYSPROP_PLATFORM_MANAGER_DISABLE, "true");
        }
        if (startClientListener != null) {
            CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    startClientListener.clientStarted(core.getPluginManager());
                }
            });
        }
        if (ui == null) {
            try {
                core = CoreFactory.create();
                core.start();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new PluginException(String.valueOf(Constants.APP_NAME) + " failed to start", e);
            }
        }
        System.setProperty("USE_OUR_PRIMARYCLASSLOADER", "0");
        String mi = (String)properties.get("MULTI_INSTANCE");
        if (mi != null && mi.equalsIgnoreCase("true")) {
            System.setProperty("MULTI_INSTANCE", "true");
        }
        try {
            Class.forName("com.biglybt.ui.Main").getMethod("main", String[].class).invoke(null, new Object[]{new String[]{"--ui=" + ui}});
        }
        catch (Throwable e) {
            throw new PluginException("Main method invocation failed", e);
        }
    }

    public static void stopClient() throws PluginException {
        try {
            class_mon.enter();
            if (!running) {
                throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " is not running");
            }
            try {
                core.requestStop();
            }
            catch (Throwable e) {
                throw new PluginException("PluginManager: " + Constants.APP_NAME + " close action failed", e);
            }
            running = false;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void restartClient() throws PluginException {
        if (!running) {
            throw new RuntimeException(String.valueOf(Constants.APP_NAME) + " is not running");
        }
        try {
            core.requestRestart();
        }
        catch (Throwable e) {
            throw new PluginException("PluginManager: " + Constants.APP_NAME + " restart action failed", e);
        }
        running = false;
    }

    public static void setStartDetails(Core _core) {
        core = _core;
        running = true;
    }

    public static void registerPlugin(Class<? extends Plugin> plugin_class) {
        PluginInitializer.queueRegistration(plugin_class);
    }

    public static void registerPlugin(Plugin plugin, String id, String config_key) {
        PluginInitializer.queueRegistration(plugin, id, config_key);
    }

    @Override
    public PluginInterface getPluginInterfaceByID(String id) {
        return this.getPluginInterfaceByID(id, true);
    }

    @Override
    public PluginInterface getPluginInterfaceByID(String id, boolean operational) {
        PluginInterface[] p = this.getPluginInterfaces();
        int i = 0;
        while (i < p.length) {
            if (p[i].getPluginID().equalsIgnoreCase(id)) {
                if (operational && !p[i].getPluginState().isOperational()) {
                    return null;
                }
                return p[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(Class c) {
        return this.getPluginInterfaceByClass(c, true);
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(Class c, boolean operational) {
        PluginInterface[] p = this.getPluginInterfaces();
        int i = 0;
        while (i < p.length) {
            if (p[i].getPlugin().getClass().equals(c)) {
                if (operational && !p[i].getPluginState().isOperational()) {
                    return null;
                }
                return p[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(String class_name) {
        return this.getPluginInterfaceByClass(class_name, true);
    }

    @Override
    public PluginInterface getPluginInterfaceByClass(String class_name, boolean operational) {
        PluginInterface[] p = this.getPluginInterfaces();
        int i = 0;
        while (i < p.length) {
            if (p[i].getPlugin().getClass().getName().equals(class_name)) {
                if (operational && !p[i].getPluginState().isOperational()) {
                    return null;
                }
                return p[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public PluginInterface[] getPluginInterfaces() {
        List<PluginInterfaceImpl> l = PluginInitializer.getPluginInterfaces();
        PluginInterface[] res = new PluginInterface[l.size()];
        l.toArray(res);
        return res;
    }

    @Override
    public PluginInterface getDefaultPluginInterface() {
        return PluginInitializer.getDefaultInterface();
    }

    protected PluginManagerImpl(PluginInitializer _pi) {
        this.pi = _pi;
        this.getPluginInstaller();
    }

    @Override
    public PluginInterface[] getPlugins() {
        return this.pi.getPlugins();
    }

    @Override
    public PluginInterface[] getPlugins(boolean expect_partial_result) {
        return this.pi.getPlugins(expect_partial_result);
    }

    @Override
    public void firePluginEvent(int ev) {
        PluginInitializer.fireEvent(ev);
    }

    @Override
    public PluginInstaller getPluginInstaller() {
        return PluginInstallerImpl.getSingleton(this);
    }

    @Override
    public void refreshPluginList(boolean initialise) {
        List loadedPlugins = this.pi.loadPlugins(this.pi.getCore(), true, true, false, initialise);
        for (PluginInterfaceImpl plugin : loadedPlugins) {
            if (plugin.getPluginState().isOperational()) continue;
            try {
                this.pi.reloadPlugin(plugin, false, initialise);
            }
            catch (PluginException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean isSilentRestartEnabled() {
        PluginInterface[] pis = this.pi.getPlugins();
        int i = 0;
        while (i < pis.length) {
            if (pis[i].getPluginProperties().getProperty("plugin.silentrestart.disabled", "").equalsIgnoreCase("true")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isInitialized() {
        return this.pi.isInitialized();
    }

    @Override
    public void executeCloseAction(String action) throws PluginException {
        if (core == null) {
            throw new PluginException(String.valueOf(Constants.APP_NAME) + " is not running");
        }
        try {
            core.executeCloseAction(action, "plugin requested");
        }
        catch (Throwable e) {
            throw new PluginException("PluginManager: " + Constants.APP_NAME + " restart action failed", e);
        }
    }

    @Override
    public List<PluginInterface> getPluginsWithMethod(String name, Class<?>[] parameters) {
        ArrayList<PluginInterface> result = new ArrayList<PluginInterface>();
        List<PluginInterfaceImpl> pis = PluginInitializer.getPluginInterfaces();
        for (PluginInterfaceImpl pi : pis) {
            if (!pi.getIPC().canInvoke(name, parameters)) continue;
            result.add(pi);
        }
        return result;
    }
}

