/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.config;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.LightHashSet;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.config.PluginConfigSource;
import java.io.File;
import java.util.Iterator;
import java.util.Map;

public class PluginConfigSourceImpl
implements COConfigurationListener,
ParameterListener,
PluginConfigSource {
    private PluginConfig plugin_config;
    private File source_file;
    private boolean initialised;
    private Map data_map;
    private String key_prefix = null;
    private boolean dirty = false;
    private boolean migrate_settings = false;
    private LightHashSet params_monitored;

    public PluginConfigSourceImpl(PluginConfig plugin_config, String plugin_id) {
        this.plugin_config = plugin_config;
        this.key_prefix = null;
        this.initialised = false;
        this.params_monitored = new LightHashSet();
        this.setConfigFilename(String.valueOf(plugin_id) + ".config");
    }

    @Override
    public void initialize() {
        this.shouldBeInitialised(false);
        this.initialised = true;
        this.data_map = FileUtil.readResilientFile(this.source_file.getParentFile(), this.source_file.getName(), true);
        this.key_prefix = this.plugin_config.getPluginConfigKeyPrefix();
        Iterator itr = this.data_map.entrySet().iterator();
        ConfigurationManager config = ConfigurationManager.getInstance();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = String.valueOf(this.key_prefix) + (String)entry.getKey();
            this.params_monitored.add(key);
            config.registerTransientParameter(key);
            config.setParameterRawNoNotify(key, entry.getValue());
            config.addParameterListener(key, this);
        }
        config.addListener(this);
    }

    @Override
    public File getConfigFile() {
        return this.source_file;
    }

    @Override
    public void setConfigFilename(String filename) {
        this.shouldBeInitialised(false);
        this.source_file = this.plugin_config.getPluginUserFile(FileUtil.convertOSSpecificChars(filename, false));
    }

    @Override
    public void save(boolean force) {
        this.shouldBeInitialised(true);
        if (!force && !this.dirty) {
            return;
        }
        FileUtil.writeResilientFile(this.source_file.getParentFile(), this.source_file.getName(), this.data_map, true);
        this.dirty = false;
    }

    @Override
    public void configurationSaved() {
        this.save(false);
    }

    @Override
    public void parameterChanged(String full_param) {
        this.shouldBeInitialised(true);
        String plugin_param = this.toPluginName(full_param);
        if (COConfigurationManager.hasParameter(full_param, true)) {
            Object val = ConfigurationManager.getInstance().getParameter(full_param);
            this.data_map.put(plugin_param, val);
        } else {
            this.data_map.remove(plugin_param);
        }
        this.dirty = true;
    }

    public void registerParameter(String full_param) {
        this.shouldBeInitialised(true);
        if (!this.params_monitored.add(full_param)) {
            return;
        }
        ConfigurationManager config = ConfigurationManager.getInstance();
        config.registerTransientParameter(full_param);
        config.addParameterListener(full_param, this);
        if (this.migrate_settings && COConfigurationManager.hasParameter(full_param, true)) {
            this.parameterChanged(full_param);
        }
    }

    public String getUsedKeyPrefix() {
        return this.key_prefix;
    }

    private String toPluginName(String name) {
        if (!name.startsWith(this.key_prefix)) {
            throw new RuntimeException("mismatch key prefix: " + name + ", " + this.key_prefix);
        }
        return name.substring(this.key_prefix.length());
    }

    private void shouldBeInitialised(boolean yes) {
        if (yes && !this.initialised) {
            throw new RuntimeException("source not yet initialised");
        }
        if (!yes && this.initialised) {
            throw new RuntimeException("source already initialised");
        }
    }

    @Override
    public void forceSettingsMigration() {
        this.shouldBeInitialised(false);
        this.migrate_settings = true;
    }
}

