/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ddb;

import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ddb.DistributedDatabaseContact;
import com.biglybt.pif.ddb.DistributedDatabaseException;
import com.biglybt.pif.ddb.DistributedDatabaseKey;
import com.biglybt.pif.ddb.DistributedDatabaseProgressListener;
import com.biglybt.pif.ddb.DistributedDatabaseTransferHandler;
import com.biglybt.pif.ddb.DistributedDatabaseTransferType;
import com.biglybt.pif.ddb.DistributedDatabaseValue;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.ddb.DDBaseContactImpl;
import com.biglybt.pifimpl.local.ddb.DDBaseHelpers;
import com.biglybt.pifimpl.local.ddb.DDBaseImpl;
import com.biglybt.pifimpl.local.ddb.DDBaseKeyImpl;
import com.biglybt.pifimpl.local.ddb.DDBaseValueImpl;
import com.biglybt.plugin.dht.DHTPluginProgressListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DDBaseTTTorrent
implements DistributedDatabaseTransferType,
DistributedDatabaseTransferHandler {
    private static final boolean TRACE = false;
    private static final byte CRYPTO_VERSION = 1;
    private DDBaseImpl ddb;
    private TorrentAttribute ta_sha1;
    private boolean crypto_tested;
    private boolean crypto_available;
    private List external_downloads;
    private Map data_cache = new LinkedHashMap(5, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    };

    protected DDBaseTTTorrent(DDBaseImpl _ddb) {
        this.ddb = _ddb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownload(Download download) {
        DDBaseTTTorrent dDBaseTTTorrent = this;
        synchronized (dDBaseTTTorrent) {
            if (this.external_downloads == null) {
                this.external_downloads = new ArrayList();
            }
            this.external_downloads.add(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownload(Download download) {
        DDBaseTTTorrent dDBaseTTTorrent = this;
        synchronized (dDBaseTTTorrent) {
            if (this.external_downloads != null) {
                this.external_downloads.remove(download);
                if (this.external_downloads.size() == 0) {
                    this.external_downloads = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key) throws DistributedDatabaseException {
        search_key = ((DDBaseKeyImpl)key).getBytes();
        download = null;
        pi = PluginInitializer.getDefaultInterface();
        search_sha1 = pi.getUtilities().getFormatters().encodeBytesToString(search_key);
        if (this.ta_sha1 == null) {
            this.ta_sha1 = pi.getTorrentManager().getPluginAttribute("DDBaseTTTorrent::sha1");
        }
        downloads = pi.getDownloadManager().getDownloads();
        i = 0;
        while (i < downloads.length) {
            dl = downloads[i];
            if (dl.getTorrent() != null && !dl.getFlag(512L)) {
                sha1 = dl.getAttribute(this.ta_sha1);
                if (sha1 == null) {
                    sha1 = pi.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(dl.getTorrent().getHash()));
                    dl.setAttribute(this.ta_sha1, sha1);
                }
                if (sha1.equals(search_sha1)) {
                    download = dl;
                    break;
                }
            }
            ++i;
        }
        if (download == null) {
            i = this;
            synchronized (i) {
                if (this.external_downloads != null) {
                    i = 0;
                    while (i < this.external_downloads.size()) {
                        dl = (Download)this.external_downloads.get(i);
                        if (dl.getTorrent() != null) {
                            sha1 = dl.getAttribute(this.ta_sha1);
                            if (sha1 == null) {
                                sha1 = pi.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(dl.getTorrent().getHash()));
                                dl.setAttribute(this.ta_sha1, sha1);
                            }
                            if (sha1.equals(search_sha1)) {
                                download = dl;
                                break;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        originator = String.valueOf(contact.getName()) + " (" + contact.getAddress() + ")";
        if (download == null) {
            msg = "TorrentDownload: request from " + originator + " for '" + pi.getUtilities().getFormatters().encodeBytesToString(search_key) + "' not found";
            this.ddb.log(msg);
            return null;
        }
        if (!this.ddb.isTorrentXferEnabled()) {
            this.ddb.log("TorrentDownload: request from " + originator + "  for '" + download.getName() + "' denied as torrent transfer is disabled");
            return null;
        }
        torrent = download.getTorrent();
        if (torrent.isPrivate()) {
            Debug.out("Attempt to download private torrent");
            this.ddb.log("TorrentDownload: request from " + originator + "  for '" + download.getName() + "' denied as it is private");
            return null;
        }
        {
            catch (Throwable e) {
                throw new DistributedDatabaseException("Torrent write fails", e);
            }
            try {
                dm = PluginCoreUtils.unwrapIfPossible(download);
                if (dm != null) {
                    dms = dm.getDownloadState();
                    if (!dms.isPeerSourceEnabled("DHT")) {
                        this.ddb.log("TorrentDownload: request from " + originator + "  for '" + download.getName() + "' denied as DHT peer source disabled");
                        return null;
                    }
                    contact_net = AENetworkClassifier.categoriseAddress(contact.getAddress());
                    nets = dms.getNetworks();
                    net_ok = false;
                    var19_22 = nets;
                    var18_23 = nets.length;
                    var17_24 = 0;
                    while (var17_24 < var18_23) {
                        n = var19_22[var17_24];
                        if (n == contact_net) {
                            net_ok = true;
                            break;
                        }
                        ++var17_24;
                    }
                    if (!net_ok) {
                        this.ddb.log("TorrentDownload: request from " + originator + "  for '" + download.getName() + "' denied as network '" + (String)contact_net + "' is disabled");
                        return null;
                    }
                    if (dms.getFlag(512L)) {
                        return null;
                    }
                }
                ** GOTO lbl87
            }
            catch (Throwable e) {}
            {
                Debug.out(e);
lbl87:
                // 2 sources

                msg = "TorrentDownload: request from " + originator + "  for '" + download.getName() + "' OK";
                this.ddb.log(msg);
                hw = new HashWrapper(torrent.getHash());
                contact_net = this.data_cache;
                synchronized (contact_net) {
                    data = (Object[])this.data_cache.get(hw);
                    if (data != null) {
                        data[1] = new Long(SystemTime.getCurrentTime());
                        return this.ddb.createValue((byte[])data[0]);
                    }
                }
                torrent = torrent.removeAdditionalProperties();
                torrent.setDecentralisedBackupRequested(true);
                data = torrent.writeToBEncodedData();
                data = this.encrypt(torrent.getHash(), data);
                if (data == null) {
                    return null;
                }
                var14_19 = this.data_cache;
                synchronized (var14_19) {
                    if (this.data_cache.size() == 0) {
                        pe = new TimerEventPeriodic[]{SimpleTimer.addPeriodicEvent("DDBTorrent:timeout", 30000L, new TimerEventPerformer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform(TimerEvent event2) {
                                long now = SystemTime.getCurrentTime();
                                Map map = DDBaseTTTorrent.this.data_cache;
                                synchronized (map) {
                                    Iterator it = DDBaseTTTorrent.this.data_cache.values().iterator();
                                    while (it.hasNext()) {
                                        long time = (Long)((Object[])it.next())[1];
                                        if (now >= time && now - time <= 120000L) continue;
                                        it.remove();
                                    }
                                    if (DDBaseTTTorrent.this.data_cache.size() == 0) {
                                        pe[0].cancel();
                                    }
                                }
                            }
                        })};
                    }
                    this.data_cache.put(hw, new Object[]{data, new Long(SystemTime.getCurrentTime())});
                    return this.ddb.createValue(data);
                }
            }
        }
    }

    @Override
    public DistributedDatabaseValue write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        byte[] torrent_hash = ((DDBaseKeyImpl)key).getBytes();
        byte[] lookup_key = new SHA1Simple().calculateHash(torrent_hash);
        byte[] data = contact.getContact().read(listener == null ? null : new DHTPluginProgressListener(){

            @Override
            public void reportSize(long size) {
                listener.reportSize(size);
            }

            @Override
            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            @Override
            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, DDBaseHelpers.getKey(type).getHash(), lookup_key, timeout);
        if (data == null) {
            return null;
        }
        if ((data = this.decrypt(torrent_hash, data)) == null) {
            return null;
        }
        return new DDBaseValueImpl(contact, data, SystemTime.getCurrentTime(), -1L);
    }

    protected byte[] encrypt(byte[] hash, byte[] data) {
        if (!this.testCrypto()) {
            return null;
        }
        byte[] enc = this.doCrypt(1, hash, data, 0);
        if (enc == null) {
            byte[] res = new byte[data.length + 2];
            res[0] = 1;
            res[1] = 0;
            System.arraycopy(data, 0, res, 2, data.length);
            return res;
        }
        byte[] res = new byte[enc.length + 2];
        res[0] = 1;
        res[1] = 1;
        System.arraycopy(enc, 0, res, 2, enc.length);
        return res;
    }

    protected byte[] decrypt(byte[] hash, byte[] data) {
        if (!this.testCrypto()) {
            return null;
        }
        if (data[0] != 1) {
            Debug.out("Invalid crypto version received");
            return data;
        }
        if (data[1] == 0) {
            byte[] res = new byte[data.length - 2];
            System.arraycopy(data, 2, res, 0, res.length);
            return res;
        }
        byte[] res = this.doCrypt(2, hash, data, 2);
        return res;
    }

    protected byte[] doCrypt(int mode, byte[] hash, byte[] data, int data_offset) {
        try {
            byte[] key_data = new byte[24];
            System.arraycopy(hash, 0, key_data, 0, hash.length);
            SecretKeySpec tdes_key = new SecretKeySpec(key_data, "DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(mode, tdes_key);
            return cipher.doFinal(data, data_offset, data.length - data_offset);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected boolean testCrypto() {
        if (!this.crypto_tested) {
            this.crypto_tested = true;
            try {
                Cipher.getInstance("DESede");
                this.crypto_available = true;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(false, "Unable to initialise cryptographic framework for magnet-based torrent downloads, please re-install Java", e));
            }
        }
        return this.crypto_available;
    }
}

