/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.disk;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRandomReadRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pifimpl.local.disk.DiskManagerChannelImpl;
import com.biglybt.pifimpl.local.disk.DiskManagerRandomReadController;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import java.io.File;

public class DiskManagerFileInfoImpl
implements com.biglybt.pif.disk.DiskManagerFileInfo {
    protected DownloadImpl download;
    protected DiskManagerFileInfo core;

    public DiskManagerFileInfoImpl(DownloadImpl _download, DiskManagerFileInfo coreFileInfo) {
        this.core = coreFileInfo;
        this.download = _download;
    }

    @Override
    public void setPriority(boolean b) {
        this.core.setPriority(b ? 1 : 0);
    }

    @Override
    public void setSkipped(boolean b) {
        this.core.setSkipped(b);
    }

    @Override
    public Boolean isSkipping() {
        return this.core.isSkipping();
    }

    @Override
    public int getNumericPriority() {
        return this.core.getPriority();
    }

    @Override
    public void setNumericPriority(int priority) {
        this.core.setPriority(priority);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDeleted(boolean b) {
        int target_st;
        int st = this.core.getStorageType();
        if (b) {
            if (st == 1) {
                target_st = 2;
            } else {
                if (st != 3) return;
                target_st = 4;
            }
        } else if (st == 2) {
            target_st = 1;
        } else {
            if (st != 4) return;
            target_st = 3;
        }
        this.core.setStorageType(target_st);
    }

    @Override
    public boolean isDeleted() {
        int st = this.core.getStorageType();
        return st == 2 || st == 4;
    }

    @Override
    public void setLink(File link_destination, boolean no_delete) {
        this.core.setLink(link_destination, no_delete);
    }

    @Override
    public File getLink() {
        return this.core.getLink();
    }

    @Override
    public int getAccessMode() {
        return this.core.getAccessMode();
    }

    @Override
    public long getDownloaded() {
        return this.core.getDownloaded();
    }

    @Override
    public long getLastModified() {
        return this.core.getLastModified();
    }

    @Override
    public long getLength() {
        return this.core.getLength();
    }

    @Override
    public File getFile() {
        return this.core.getFile(false);
    }

    @Override
    public File getFile(boolean follow_link) {
        return this.core.getFile(follow_link);
    }

    @Override
    public int getFirstPieceNumber() {
        return this.core.getFirstPieceNumber();
    }

    @Override
    public long getPieceSize() {
        try {
            return this.getDownload().getTorrent().getPieceSize();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0L;
        }
    }

    @Override
    public int getNumPieces() {
        return this.core.getNbPieces();
    }

    @Override
    public boolean isPriority() {
        return this.core.getPriority() != 0;
    }

    @Override
    public boolean isSkipped() {
        return this.core.isSkipped();
    }

    @Override
    public int getIndex() {
        return this.core.getIndex();
    }

    @Override
    public byte[] getDownloadHash() throws DownloadException {
        return this.getDownload().getTorrent().getHash();
    }

    @Override
    public Download getDownload() throws DownloadException {
        if (this.download != null) {
            return this.download;
        }
        return DownloadManagerImpl.getDownloadStatic(this.core.getDownloadManager());
    }

    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        return new DiskManagerChannelImpl(this.download, this);
    }

    @Override
    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        return DiskManagerRandomReadController.createRequest(this.download, this, file_offset, length, reverse_order, listener);
    }

    public DiskManagerFileInfo getCore() {
        return this.core;
    }
}

