/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.disk;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.pif.disk.DiskManagerException;
import com.biglybt.pif.disk.DiskManagerReadRequestListener;
import com.biglybt.pif.disk.DiskManagerWriteRequest;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerImpl
implements com.biglybt.pif.disk.DiskManager {
    private DiskManager disk_manager;

    public DiskManagerImpl(DiskManager _disk_manager) {
        this.disk_manager = _disk_manager;
    }

    public DiskManager getDiskmanager() {
        return this.disk_manager;
    }

    @Override
    public com.biglybt.pif.disk.DiskManagerReadRequest read(int piece_number, int offset, int length, final DiskManagerReadRequestListener listener) throws DiskManagerException {
        if (!this.disk_manager.checkBlockConsistencyForRead("plugin", false, piece_number, offset, length)) {
            throw new DiskManagerException("read invalid - parameters incorrect or piece incomplete");
        }
        final DMRR request2 = new DMRR(this.disk_manager.createReadRequest(piece_number, offset, length));
        this.disk_manager.enqueueReadRequest(request2.getDelegate(), new com.biglybt.core.disk.DiskManagerReadRequestListener(){

            @Override
            public void readCompleted(DiskManagerReadRequest _request, DirectByteBuffer _data) {
                listener.complete(request2, new PooledByteBufferImpl(_data));
            }

            @Override
            public void readFailed(DiskManagerReadRequest _request, Throwable _cause) {
                listener.failed(request2, new DiskManagerException("read failed", _cause));
            }

            @Override
            public int getPriority() {
                return 0;
            }

            @Override
            public void requestExecuted(long bytes) {
            }
        });
        return request2;
    }

    @Override
    public DiskManagerWriteRequest write(final int piece_number, final int offset, PooledByteBuffer data, final com.biglybt.pif.disk.DiskManagerWriteRequestListener listener) throws DiskManagerException {
        DirectByteBuffer buffer = ((PooledByteBufferImpl)data).getBuffer();
        if (!this.disk_manager.checkBlockConsistencyForWrite("plugin", piece_number, offset, buffer)) {
            throw new DiskManagerException("write invalid - parameters incorrect");
        }
        final int length = buffer.remaining((byte)1);
        final DMWR request2 = new DMWR(this.disk_manager.createWriteRequest(piece_number, offset, buffer, null), length);
        this.disk_manager.enqueueWriteRequest(request2.getDelegate(), new DiskManagerWriteRequestListener(){

            @Override
            public void writeCompleted(com.biglybt.core.disk.DiskManagerWriteRequest _request) {
                DiskManagerPiece[] dm_pieces = DiskManagerImpl.this.disk_manager.getPieces();
                DiskManagerPiece dm_piece = dm_pieces[piece_number];
                if (!dm_piece.isDone()) {
                    int current_offset = offset;
                    int i = 0;
                    while (i < length) {
                        dm_piece.setWritten(current_offset / 16384);
                        current_offset += 16384;
                        i += 16384;
                    }
                }
                listener.complete(request2);
            }

            @Override
            public void writeFailed(com.biglybt.core.disk.DiskManagerWriteRequest _request, Throwable _cause) {
                listener.failed(request2, new DiskManagerException("read failed", _cause));
            }
        });
        return request2;
    }

    private static class DMRR
    implements com.biglybt.pif.disk.DiskManagerReadRequest {
        private DiskManagerReadRequest request;

        private DMRR(DiskManagerReadRequest _request) {
            this.request = _request;
        }

        private DiskManagerReadRequest getDelegate() {
            return this.request;
        }

        @Override
        public int getPieceNumber() {
            return this.request.getPieceNumber();
        }

        @Override
        public int getOffset() {
            return this.request.getOffset();
        }

        @Override
        public int getLength() {
            return this.request.getLength();
        }
    }

    private static class DMWR
    implements DiskManagerWriteRequest {
        private com.biglybt.core.disk.DiskManagerWriteRequest request;
        private int length;

        private DMWR(com.biglybt.core.disk.DiskManagerWriteRequest _request, int _length) {
            this.request = _request;
        }

        private com.biglybt.core.disk.DiskManagerWriteRequest getDelegate() {
            return this.request;
        }

        @Override
        public int getPieceNumber() {
            return this.request.getPieceNumber();
        }

        @Override
        public int getOffset() {
            return this.request.getOffset();
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

