/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.messaging;

import com.biglybt.core.Core;
import com.biglybt.core.nat.NATTraversalHandler;
import com.biglybt.core.nat.NATTraverser;
import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.ProtocolEndpoint;
import com.biglybt.core.networkmanager.impl.TransportHelper;
import com.biglybt.core.peermanager.messaging.MessageException;
import com.biglybt.core.peermanager.messaging.MessageStreamDecoder;
import com.biglybt.core.peermanager.messaging.MessageStreamEncoder;
import com.biglybt.core.peermanager.messaging.MessageStreamFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.messaging.Message;
import com.biglybt.pif.messaging.MessageManager;
import com.biglybt.pif.messaging.MessageManagerListener;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.messaging.generic.GenericMessageEndpoint;
import com.biglybt.pif.messaging.generic.GenericMessageHandler;
import com.biglybt.pif.messaging.generic.GenericMessageRegistration;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerEvent;
import com.biglybt.pif.peers.PeerListener2;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerEvent;
import com.biglybt.pif.peers.PeerManagerListener2;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionDirect;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionImpl;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionIndirect;
import com.biglybt.pifimpl.local.messaging.GenericMessageDecoder;
import com.biglybt.pifimpl.local.messaging.GenericMessageEncoder;
import com.biglybt.pifimpl.local.messaging.GenericMessageEndpointImpl;
import com.biglybt.pifimpl.local.messaging.MessageAdapter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MessageManagerImpl
implements MessageManager,
NATTraversalHandler {
    private static MessageManagerImpl instance;
    private final HashMap compat_checks = new HashMap();
    private final DownloadManagerListener download_manager_listener = new DownloadManagerListener(){

        @Override
        public void downloadAdded(Download dwnld) {
            dwnld.addPeerListener(new DownloadPeerListener(){

                @Override
                public void peerManagerAdded(final Download download, PeerManager peer_manager) {
                    peer_manager.addListener(new PeerManagerListener2(){

                        @Override
                        public void eventOccurred(PeerManagerEvent event2) {
                            final Peer peer = event2.getPeer();
                            if (event2.getType() == 1) {
                                peer.addListener(new PeerListener2(){

                                    @Override
                                    public void eventOccurred(PeerEvent event2) {
                                        int new_state;
                                        if (event2.getType() == 1 && (new_state = ((Integer)event2.getData()).intValue()) == 30 && peer.supportsMessaging()) {
                                            Message[] messages = peer.getSupportedMessages();
                                            int i = 0;
                                            while (i < messages.length) {
                                                Message msg = messages[i];
                                                for (Map.Entry entry : MessageManagerImpl.this.compat_checks.entrySet()) {
                                                    Message message = (Message)entry.getKey();
                                                    if (!msg.getID().equals(message.getID())) continue;
                                                    MessageManagerListener listener = (MessageManagerListener)entry.getValue();
                                                    listener.compatiblePeerFound(download, peer, message);
                                                }
                                                ++i;
                                            }
                                        }
                                    }
                                });
                            } else if (event2.getType() == 2) {
                                for (MessageManagerListener listener : MessageManagerImpl.this.compat_checks.values()) {
                                    listener.peerRemoved(download, peer);
                                }
                            }
                        }
                    });
                }

                @Override
                public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                }
            });
        }

        @Override
        public void downloadRemoved(Download download) {
        }
    };
    private Core core;
    private Map message_handlers = new HashMap();

    public static int adjustCrypto(GenericMessageEndpointImpl endpoint, int crypto) {
        return MessageManagerImpl.adjustCrypto(endpoint.getConnectionEndpoint(), crypto);
    }

    public static int adjustCrypto(ConnectionEndpoint endpoint, int crypto) {
        InetSocketAddress isa;
        ProtocolEndpoint[] pes = endpoint.getProtocols();
        if (pes.length == 1 && pes[0].getType() == 1 && AENetworkClassifier.categoriseAddress(isa = pes[0].getAddress()) != "Public") {
            crypto = 1;
        }
        return crypto;
    }

    public static synchronized MessageManagerImpl getSingleton(Core core) {
        if (instance == null) {
            instance = new MessageManagerImpl(core);
        }
        return instance;
    }

    private MessageManagerImpl(Core _core) {
        this.core = _core;
        this.core.getNATTraverser().registerHandler(this);
    }

    public NATTraverser getNATTraverser() {
        return this.core.getNATTraverser();
    }

    @Override
    public void registerMessageType(Message message) throws com.biglybt.pif.messaging.MessageException {
        try {
            com.biglybt.core.peermanager.messaging.MessageManager.getSingleton().registerMessageType(new MessageAdapter(message));
        }
        catch (MessageException me) {
            throw new com.biglybt.pif.messaging.MessageException(me.getMessage());
        }
    }

    @Override
    public void deregisterMessageType(Message message) {
        com.biglybt.core.peermanager.messaging.MessageManager.getSingleton().deregisterMessageType(new MessageAdapter(message));
    }

    @Override
    public void locateCompatiblePeers(PluginInterface plug_interface, Message message, MessageManagerListener listener) {
        this.compat_checks.put(message, listener);
        if (this.compat_checks.size() == 1) {
            plug_interface.getDownloadManager().addListener(this.download_manager_listener);
        }
    }

    @Override
    public void cancelCompatiblePeersLocation(MessageManagerListener orig_listener) {
        Iterator it = this.compat_checks.values().iterator();
        while (it.hasNext()) {
            MessageManagerListener listener = (MessageManagerListener)it.next();
            if (listener != orig_listener) continue;
            it.remove();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericMessageRegistration registerGenericMessageType(String _type, final String description, final int stream_crypto, final GenericMessageHandler handler) throws com.biglybt.pif.messaging.MessageException {
        final String type = "AEGEN:" + _type;
        final byte[] type_bytes = type.getBytes();
        final byte[][] shared_secrets = new byte[][]{new SHA1Simple().calculateHash(type_bytes)};
        Map map = this.message_handlers;
        synchronized (map) {
            this.message_handlers.put(type, handler);
        }
        final NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            @Override
            public int matchThisSizeOrBigger() {
                return this.maxSize();
            }

            @Override
            public int maxSize() {
                return type_bytes.length;
            }

            @Override
            public int minSize() {
                return this.maxSize();
            }

            @Override
            public Object matches(TransportHelper transport, ByteBuffer to_compare, int port) {
                int old_limit = to_compare.limit();
                to_compare.limit(to_compare.position() + this.maxSize());
                boolean matches = to_compare.equals(ByteBuffer.wrap(type_bytes));
                to_compare.limit(old_limit);
                return matches ? "" : null;
            }

            @Override
            public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                return this.matches(transport, to_compare, port);
            }

            @Override
            public byte[][] getSharedSecrets() {
                return shared_secrets;
            }

            @Override
            public int getSpecificPort() {
                return -1;
            }

            @Override
            public String getDescription() {
                return type;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            @Override
            public void connectionRouted(NetworkConnection connection, Object routing_data) {
                try {
                    ByteBuffer[] skip_buffer = new ByteBuffer[]{ByteBuffer.allocate(type_bytes.length)};
                    connection.getTransport().read(skip_buffer, 0, 1);
                    if (skip_buffer[0].remaining() != 0) {
                        Debug.out("incomplete read");
                    }
                    GenericMessageEndpointImpl endpoint = new GenericMessageEndpointImpl(connection.getEndpoint());
                    GenericMessageConnectionDirect direct_connection = GenericMessageConnectionDirect.receive(endpoint, type, description, stream_crypto, shared_secrets);
                    GenericMessageConnectionImpl new_connection = new GenericMessageConnectionImpl(MessageManagerImpl.this, direct_connection);
                    direct_connection.connect(connection);
                    if (handler.accept(new_connection)) {
                        new_connection.accepted();
                    } else {
                        connection.close("connection not accepted");
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    connection.close(e == null ? null : Debug.getNestedExceptionMessage(e));
                }
            }

            @Override
            public boolean autoCryptoFallback() {
                return stream_crypto != 3;
            }
        }, new MessageStreamFactory(){

            @Override
            public MessageStreamEncoder createEncoder() {
                return new GenericMessageEncoder();
            }

            @Override
            public MessageStreamDecoder createDecoder() {
                return new GenericMessageDecoder(type, description);
            }
        });
        return new GenericMessageRegistration(){

            @Override
            public GenericMessageEndpoint createEndpoint(InetSocketAddress notional_target) {
                return new GenericMessageEndpointImpl(notional_target);
            }

            @Override
            public GenericMessageConnection createConnection(GenericMessageEndpoint endpoint) throws com.biglybt.pif.messaging.MessageException {
                return new GenericMessageConnectionImpl(MessageManagerImpl.this, type, description, (GenericMessageEndpointImpl)endpoint, stream_crypto, shared_secrets);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(matcher);
                Map map = MessageManagerImpl.this.message_handlers;
                synchronized (map) {
                    MessageManagerImpl.this.message_handlers.remove(type);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericMessageHandler getHandler(String type) {
        Map map = this.message_handlers;
        synchronized (map) {
            return (GenericMessageHandler)this.message_handlers.get(type);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getName() {
        return "Generic Messaging";
    }

    @Override
    public Map process(InetSocketAddress originator, Map message) {
        return GenericMessageConnectionIndirect.receive(this, originator, message);
    }
}

