/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.html.HTMLUtils;
import com.biglybt.pif.ui.config.ColorParameter;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;

public class ColorParameterImpl
extends ParameterImpl
implements ColorParameter {
    private String suffixLabelKey;

    public ColorParameterImpl(String configKey, String label) {
        super(configKey, label);
    }

    @Override
    public Object getValueObject() {
        return "#" + HTMLUtils.toColorHexString(this.getRedValue(), this.getGreenValue(), this.getBlueValue(), 255);
    }

    @Override
    public int getRedValue() {
        return COConfigurationManager.getIntParameter(String.valueOf(this.configKey) + ".red");
    }

    @Override
    public int getGreenValue() {
        return COConfigurationManager.getIntParameter(String.valueOf(this.configKey) + ".green");
    }

    @Override
    public int getBlueValue() {
        return COConfigurationManager.getIntParameter(String.valueOf(this.configKey) + ".blue");
    }

    @Override
    public void setRGBValue(int r, int g, int b) {
        COConfigurationManager.setRGBParameter(this.configKey, r, g, b, true);
    }

    @Override
    public boolean resetToDefault() {
        if (this.configKey == null) {
            return false;
        }
        return COConfigurationManager.removeRGBParameter(this.configKey);
    }

    public boolean isOverridden() {
        return COConfigurationManager.getBooleanParameter(String.valueOf(this.configKey) + ".override");
    }

    @Override
    public String getSuffixLabelKey() {
        return this.suffixLabelKey;
    }

    @Override
    public void setSuffixLabelKey(String suffixLabelKey) {
        this.suffixLabelKey = suffixLabelKey;
        this.refreshControl();
    }

    @Override
    public void setSuffixLabelText(String text) {
        this.suffixLabelKey = text == null ? null : "!" + text + "!";
        this.refreshControl();
    }
}

