/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.update;

import com.biglybt.core.Core;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateException;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.pif.update.UpdateManagerListener;
import com.biglybt.pif.update.UpdateManagerVerificationListener;
import com.biglybt.pifimpl.local.update.UpdatableComponentImpl;
import com.biglybt.pifimpl.local.update.UpdateCheckInstanceImpl;
import com.biglybt.pifimpl.local.update.UpdateInstallerImpl;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class UpdateManagerImpl
implements UpdateManager,
UpdateCheckInstanceListener {
    private static UpdateManagerImpl singleton;
    private Core core;
    private List<UpdateCheckInstanceImpl> checkers = new ArrayList<UpdateCheckInstanceImpl>();
    private List<UpdatableComponentImpl> components = new ArrayList<UpdatableComponentImpl>();
    private List listeners = new ArrayList();
    private List verification_listeners = new ArrayList();
    private List<UpdateInstaller> installers = new ArrayList<UpdateInstaller>();
    protected AEMonitor this_mon = new AEMonitor("UpdateManager");

    public static UpdateManager getSingleton(Core core) {
        if (singleton == null) {
            singleton = new UpdateManagerImpl(core);
        }
        return singleton;
    }

    protected UpdateManagerImpl(Core _core) {
        this.core = _core;
        UpdateInstallerImpl.checkForFailedInstalls(this);
        try {
            PlatformManagerFactory.getPlatformManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Core getCore() {
        return this.core;
    }

    @Override
    public void registerUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        try {
            this.this_mon.enter();
            this.components.add(new UpdatableComponentImpl(component, mandatory));
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateCheckInstance[] getCheckInstances() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] updateCheckInstanceArray = this.checkers.toArray(new UpdateCheckInstance[this.checkers.size()]);
            return updateCheckInstanceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateCheckInstance createUpdateCheckInstance() {
        return this.createUpdateCheckInstance(2, "");
    }

    @Override
    public UpdateCheckInstance createUpdateCheckInstance(int type, String name) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[this.components.size()];
            this.components.toArray(comps);
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            this.checkers.add(res);
            res.addListener(this);
            int i = 0;
            while (i < this.listeners.size()) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
                ++i;
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            return updateCheckInstanceImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int type, String name) {
        return this.createEmptyUpdateCheckInstance(type, name, false);
    }

    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int type, String name, boolean low_noise) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] comps = new UpdatableComponentImpl[]{};
            UpdateCheckInstanceImpl res = new UpdateCheckInstanceImpl(this, type, name, comps);
            res.setLowNoise(low_noise);
            this.checkers.add(res);
            res.addListener(this);
            int i = 0;
            while (i < this.listeners.size()) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(res);
                ++i;
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl = res;
            return updateCheckInstanceImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateInstaller createInstaller() throws UpdateException {
        UpdateInstallerImpl installer = new UpdateInstallerImpl(this);
        this.installers.add(installer);
        return installer;
    }

    @Override
    public UpdateInstaller[] getInstallers() {
        UpdateInstaller[] res = new UpdateInstaller[this.installers.size()];
        this.installers.toArray(res);
        return res;
    }

    @Override
    public boolean hasPendingInstalls() {
        if (this.installers.size() > 0) {
            return true;
        }
        File update_dir = new File(String.valueOf(this.getUserDir()) + File.separator + "updates");
        File[] dirs = update_dir.listFiles();
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                if (dir.isDirectory() && !new File(dir, "install.fail").exists()) {
                    if (new File(dir, "install.act.utf8").exists()) {
                        return true;
                    }
                    if (new File(dir, "install.act").exists()) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void cancelled(UpdateCheckInstance instance) {
        this.complete(instance);
    }

    @Override
    public void complete(UpdateCheckInstance instance) {
        try {
            this.this_mon.enter();
            this.checkers.remove(instance);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeInstaller(UpdateInstaller installer) {
        this.installers.remove(installer);
    }

    @Override
    public String getInstallDir() {
        String str = SystemProperties.getApplicationPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getUserDir() {
        String str = SystemProperties.getUserPath();
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public void applyUpdates(boolean restart_after) throws UpdateException {
        try {
            if (restart_after) {
                this.core.requestRestart();
            } else {
                this.core.requestStop();
            }
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateManager:applyUpdates fails", e);
        }
    }

    /*
     * Exception decompiling
     */
    public InputStream verifyData(Update update, InputStream is, boolean force) throws UpdateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addVerificationListener(UpdateManagerVerificationListener l) {
        this.verification_listeners.add(l);
    }

    @Override
    public void removeVerificationListener(UpdateManagerVerificationListener l) {
        this.verification_listeners.add(l);
    }

    @Override
    public void addListener(UpdateManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(UpdateManagerListener l) {
        this.listeners.remove(l);
    }
}

