/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils;

import com.biglybt.core.util.RegExUtil;
import java.util.regex.Pattern;

public class SearchMatcher {
    private String[] bits;
    private int[] bit_types;
    private Pattern[] bit_patterns;

    public SearchMatcher(String term) {
        this.bits = RegExUtil.PAT_SPLIT_SPACE.split(term.toLowerCase());
        this.bit_types = new int[this.bits.length];
        this.bit_patterns = new Pattern[this.bits.length];
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = this.bits[i].trim();
            String bit = this.bits[i];
            if (bit.length() > 0) {
                char c = bit.charAt(0);
                if (c == '+') {
                    this.bit_types[i] = 1;
                    bit = this.bits[i] = bit.substring(1);
                } else if (c == '-') {
                    this.bit_types[i] = 2;
                    bit = this.bits[i] = bit.substring(1);
                }
                if (bit.startsWith("(") && bit.endsWith(")")) {
                    bit = bit.substring(1, bit.length() - 1);
                    try {
                        this.bit_patterns[i] = Pattern.compile(bit, 66);
                    }
                    catch (Throwable throwable) {}
                } else if (bit.contains("|")) {
                    try {
                        this.bit_patterns[i] = Pattern.compile(bit, 66);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    public boolean matches(String str) {
        str = str.toLowerCase();
        boolean match = true;
        boolean at_least_one = false;
        int i = 0;
        while (i < this.bits.length) {
            String bit = this.bits[i];
            if (bit.length() > 0) {
                boolean hit = this.bit_patterns[i] == null ? str.contains(bit) : this.bit_patterns[i].matcher(str).find();
                int type = this.bit_types[i];
                if (hit) {
                    if (type == 2) {
                        match = false;
                        break;
                    }
                    at_least_one = true;
                } else if (type == 2) {
                    at_least_one = true;
                } else {
                    match = false;
                    break;
                }
            }
            ++i;
        }
        boolean res = match && at_least_one;
        return res;
    }
}

