/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.remote.download;

import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadEventNotifier;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadManagerStats;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadStubListener;
import com.biglybt.pif.download.DownloadWillBeAddedListener;
import com.biglybt.pif.download.savelocation.DefaultSaveLocationManager;
import com.biglybt.pif.download.savelocation.SaveLocationManager;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pifimpl.remote.RPException;
import com.biglybt.pifimpl.remote.RPObject;
import com.biglybt.pifimpl.remote.RPReply;
import com.biglybt.pifimpl.remote.RPRequest;
import com.biglybt.pifimpl.remote.download.RPDownload;
import com.biglybt.pifimpl.remote.torrent.RPTorrent;
import java.io.File;
import java.net.URL;
import java.util.Map;

public class RPDownloadManager
extends RPObject
implements DownloadManager {
    protected transient DownloadManager delegate;

    public static RPDownloadManager create(DownloadManager _delegate) {
        RPDownloadManager res = (RPDownloadManager)RPDownloadManager._lookupLocal(_delegate);
        if (res == null) {
            res = new RPDownloadManager(_delegate);
        }
        return res;
    }

    protected RPDownloadManager(DownloadManager _delegate) {
        super(_delegate);
    }

    @Override
    protected void _setDelegate(Object _delegate) {
        this.delegate = (DownloadManager)_delegate;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("getDownloads")) {
            Download[] downloads = this.delegate.getDownloads();
            RPDownload[] res = new RPDownload[downloads.length];
            int i = 0;
            while (i < res.length) {
                res[i] = RPDownload.create(downloads[i]);
                ++i;
            }
            return new RPReply(res);
        }
        if (method.equals("getDownloads[boolean]")) {
            Download[] downloads = this.delegate.getDownloads((Boolean)request2.getParams()[0]);
            RPDownload[] res = new RPDownload[downloads.length];
            int i = 0;
            while (i < res.length) {
                res[i] = RPDownload.create(downloads[i]);
                ++i;
            }
            return new RPReply(res);
        }
        if (method.equals("addDownload[Torrent]")) {
            try {
                RPTorrent torrent = (RPTorrent)request2.getParams()[0];
                Download res = this.delegate.addDownload((Torrent)torrent._setLocal());
                return new RPReply(RPDownload.create(res));
            }
            catch (DownloadException e) {
                throw new RPException("DownloadManager::addDownload failed", e);
            }
        }
        if (method.equals("addDownload[Torrent,String,String]")) {
            try {
                RPTorrent torrent = (RPTorrent)request2.getParams()[0];
                File f1 = params[1] == null ? null : FileUtil.newFile((String)params[1], new String[0]);
                File f2 = params[2] == null ? null : FileUtil.newFile((String)params[2], new String[0]);
                Download res = this.delegate.addDownload((Torrent)torrent._setLocal(), f1, f2);
                return new RPReply(RPDownload.create(res));
            }
            catch (DownloadException e) {
                throw new RPException("DownloadManager::addDownload failed", e);
            }
        }
        if (method.equals("addDownload[URL]")) {
            try {
                this.delegate.addDownload((URL)request2.getParams()[0]);
            }
            catch (DownloadException e) {
                throw new RPException("DownloadManager::addDownload failed", e);
            }
            return new RPReply(null);
        }
        if (method.equals("pauseDownloads")) {
            this.delegate.pauseDownloads();
            return null;
        }
        if (method.equals("resumeDownloads")) {
            this.delegate.resumeDownloads();
            return null;
        }
        if (method.equals("stopAllDownloads")) {
            this.delegate.stopAllDownloads();
            return null;
        }
        if (method.equals("startAllDownloads")) {
            this.delegate.startAllDownloads();
            return null;
        }
        throw new RPException("Unknown method: " + method);
    }

    @Override
    public void addDownload(File torrent_file) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void addDownload(URL url, URL referer) {
        this.notSupported();
    }

    @Override
    public void addDownload(URL url) throws DownloadException {
        this._dispatcher.dispatch(new RPRequest(this, "addDownload[URL]", new Object[]{url})).getResponse();
    }

    @Override
    public void addDownload(URL url, boolean auto_download) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void addDownload(URL url, Map request_properties) {
        this.notSupported();
    }

    @Override
    public Download addDownload(Torrent torrent) throws DownloadException {
        try {
            RPDownload res = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "addDownload[Torrent]", new Object[]{torrent})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Download addDownload(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        try {
            RPDownload res = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "addDownload[Torrent,String,String]", new Object[]{torrent, torrent_location == null ? null : torrent_location.toString(), data_location == null ? null : data_location.toString()})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Download addDownloadStopped(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        this.notSupported();
        return null;
    }

    @Override
    public Download addNonPersistentDownload(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        this.notSupported();
        return null;
    }

    @Override
    public Download addNonPersistentDownloadStopped(Torrent torrent, File torrentLocation, File dataLocation) throws DownloadException {
        this.notSupported();
        return null;
    }

    @Override
    public void clearNonPersistentDownloadState(byte[] hash) {
        this.notSupported();
    }

    @Override
    public Download getDownload(Torrent torrent) {
        this.notSupported();
        return null;
    }

    @Override
    public Download getDownload(byte[] hash, boolean check_truncated) {
        this.notSupported();
        return null;
    }

    @Override
    public Download[] getDownloads() {
        Download[] res = (RPDownload[])this._dispatcher.dispatch(new RPRequest(this, "getDownloads", null)).getResponse();
        int i = 0;
        while (i < res.length) {
            ((RPDownload)res[i])._setRemote(this._dispatcher);
            ++i;
        }
        return res;
    }

    @Override
    public Download[] getDownloads(boolean bSort) {
        Download[] res = (RPDownload[])this._dispatcher.dispatch(new RPRequest(this, "getDownloads[boolean]", new Object[]{bSort})).getResponse();
        int i = 0;
        while (i < res.length) {
            ((RPDownload)res[i])._setRemote(this._dispatcher);
            ++i;
        }
        return res;
    }

    @Override
    public void pauseDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "pauseDownloads", null)).getResponse();
    }

    @Override
    public boolean canPauseDownloads() {
        this.notSupported();
        return false;
    }

    @Override
    public void resumeDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "resumeDownloads", null)).getResponse();
    }

    @Override
    public boolean canResumeDownloads() {
        this.notSupported();
        return false;
    }

    @Override
    public void startAllDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "startAllDownloads", null)).getResponse();
    }

    @Override
    public void stopAllDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "stopAllDownloads", null)).getResponse();
    }

    @Override
    public DownloadManagerStats getStats() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isSeedingOnly() {
        this.notSupported();
        return false;
    }

    @Override
    public void addListener(DownloadManagerListener l) {
        this.notSupported();
    }

    @Override
    public void addListener(DownloadManagerListener l, boolean notify) {
        this.notSupported();
    }

    @Override
    public void removeListener(DownloadManagerListener l) {
        this.notSupported();
    }

    @Override
    public void removeListener(DownloadManagerListener l, boolean notify) {
        this.notSupported();
    }

    @Override
    public void addDownloadWillBeAddedListener(DownloadWillBeAddedListener listener) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeAddedListener(DownloadWillBeAddedListener listener) {
        this.notSupported();
    }

    @Override
    public DownloadEventNotifier getGlobalDownloadEventNotifier() {
        this.notSupported();
        return null;
    }

    @Override
    public void setSaveLocationManager(SaveLocationManager manager) {
        this.notSupported();
    }

    @Override
    public SaveLocationManager getSaveLocationManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DefaultSaveLocationManager getDefaultSaveLocationManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DownloadStub[] getDownloadStubs() {
        this.notSupported();
        return null;
    }

    @Override
    public int getDownloadStubCount() {
        this.notSupported();
        return 0;
    }

    @Override
    public DownloadStub lookupDownloadStub(byte[] hash) {
        this.notSupported();
        return null;
    }

    @Override
    public void addDownloadStubListener(DownloadStubListener l, boolean inform_of_current) {
        this.notSupported();
    }

    @Override
    public void removeDownloadStubListener(DownloadStubListener l) {
        this.notSupported();
    }
}

