/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.remote.tracker;

import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.tracker.TrackerException;
import com.biglybt.pif.tracker.TrackerListener;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.tracker.web.TrackerAuthenticationListener;
import com.biglybt.pif.tracker.web.TrackerWebContext;
import com.biglybt.pif.tracker.web.TrackerWebPageGenerator;
import com.biglybt.pifimpl.remote.RPException;
import com.biglybt.pifimpl.remote.RPObject;
import com.biglybt.pifimpl.remote.RPReply;
import com.biglybt.pifimpl.remote.RPRequest;
import com.biglybt.pifimpl.remote.torrent.RPTorrent;
import com.biglybt.pifimpl.remote.tracker.RPTrackerTorrent;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;

public class RPTracker
extends RPObject
implements Tracker {
    protected transient Tracker delegate;

    public static RPTracker create(Tracker _delegate) {
        RPTracker res = (RPTracker)RPTracker._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTracker(_delegate);
        }
        return res;
    }

    protected RPTracker(Tracker _delegate) {
        super(_delegate);
    }

    @Override
    protected void _setDelegate(Object _delegate) {
        this.delegate = (Tracker)_delegate;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("host[Torrent,boolean]")) {
            try {
                Torrent torrent;
                Torrent torrent2 = torrent = params[0] == null ? null : (Torrent)((RPTorrent)params[0])._setLocal();
                if (torrent == null) {
                    throw new RPException("Invalid torrent");
                }
                TrackerTorrent tt = this.delegate.host(torrent, (Boolean)params[1]);
                RPTrackerTorrent res = RPTrackerTorrent.create(tt);
                return new RPReply(res);
            }
            catch (TrackerException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("getTorrents")) {
            TrackerTorrent[] torrents = this.delegate.getTorrents();
            RPTrackerTorrent[] res = new RPTrackerTorrent[torrents.length];
            int i = 0;
            while (i < res.length) {
                res[i] = RPTrackerTorrent.create(torrents[i]);
                ++i;
            }
            return new RPReply(res);
        }
        throw new RPException("Unknown method: " + method);
    }

    @Override
    public TrackerTorrent host(Torrent torrent, boolean persistent) throws TrackerException {
        try {
            RPTrackerTorrent resp = (RPTrackerTorrent)this._dispatcher.dispatch(new RPRequest(this, "host[Torrent,boolean]", new Object[]{torrent, persistent})).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TrackerException) {
                throw (TrackerException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public TrackerTorrent host(Torrent torrent, boolean persistent, boolean passive) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerTorrent publish(Torrent torrent) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerTorrent[] getTorrents() {
        TrackerTorrent[] res = (RPTrackerTorrent[])this._dispatcher.dispatch(new RPRequest(this, "getTorrents", null)).getResponse();
        int i = 0;
        while (i < res.length) {
            ((RPTrackerTorrent)res[i])._setRemote(this._dispatcher);
            ++i;
        }
        return res;
    }

    @Override
    public TrackerTorrent getTorrent(Torrent t) {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(int port, int protocol) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip, Map<String, Object> properties) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public void addListener(TrackerListener listener) {
    }

    @Override
    public void removeListener(TrackerListener listener) {
    }

    @Override
    public String getName() {
        this.notSupported();
        return null;
    }

    @Override
    public void setEnableKeepAlive(boolean enable) {
        this.notSupported();
    }

    @Override
    public URL[] getURLs() {
        this.notSupported();
        return null;
    }

    @Override
    public InetAddress getBindIP() {
        this.notSupported();
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        this.notSupported();
        return null;
    }

    @Override
    public void addPageGenerator(TrackerWebPageGenerator generator) {
    }

    @Override
    public void removePageGenerator(TrackerWebPageGenerator generator) {
    }

    @Override
    public TrackerWebPageGenerator[] getPageGenerators() {
        this.notSupported();
        return null;
    }

    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener l) {
    }

    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
    }

    @Override
    public void destroy() {
        this.notSupported();
    }
}

