/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.platform.macosx.access.jnilib;

import com.biglybt.core.drivedetector.DriveDetectedInfo;
import com.biglybt.core.drivedetector.DriveDetectorFactory;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.platform.macosx.access.jnilib.OSXDriveDetectListener;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OSXAccess {
    private static boolean bLoaded = false;
    private static boolean DEBUG = false;
    private static List<String> parameters = new ArrayList<String>(1);

    static {
        OSXAccess.loadLibrary("OSXAccess_10.5");
    }

    private static boolean loadLibrary(String lib) {
        try {
            OSXAccess.SystemLoadLibrary(lib);
            bLoaded = true;
            OSXAccess.initialize();
        }
        catch (Throwable e1) {
            System.err.println("Could not find lib" + lib + ".jnilib; " + e1.toString());
        }
        return bLoaded;
    }

    private static void SystemLoadLibrary(String lib) throws Throwable {
        try {
            System.loadLibrary(lib);
        }
        catch (Throwable t) {
            try {
                File f = new File(new File(SystemProperties.getApplicationPath(), "dll"), "lib" + lib + ".jnilib");
                System.load(f.getAbsolutePath());
            }
            catch (Throwable t2) {
                throw t;
            }
        }
    }

    public static void passParameter(String s) {
        if (DEBUG) {
            System.err.println("passing Parameter " + s);
        }
        if (s != null) {
            parameters.add(s);
        }
    }

    public static String[] runLight(String[] args) {
        if (args != null) {
            Collections.addAll(parameters, args);
        }
        return parameters.toArray(new String[0]);
    }

    private static void initialize() {
        try {
            if (System.getProperty("osxaccess.light", "0").equals("1")) {
                OSXAccess.initializeLight();
                Class<?> claOSXFileOpen = Class.forName("com.biglybt.ui.swt.osx.OSXFileOpen");
                if (claOSXFileOpen != null) {
                    Method method = claOSXFileOpen.getMethod("initLight", new Class[0]);
                    method.invoke(null, new Object[0]);
                }
                return;
            }
            OSXAccess.initializeDriveDetection(new OSXDriveDetectListener(){

                @Override
                public void driveRemoved(File mount, Map driveInfo) {
                    if (DEBUG) {
                        System.out.println("UNMounted " + mount);
                        for (Object key : driveInfo.keySet()) {
                            Object val = driveInfo.get(key);
                            System.out.println("\t" + key + "\t:\t" + val);
                        }
                    }
                    DriveDetectorFactory.getDeviceDetector().driveRemoved(mount);
                }

                @Override
                public void driveDetected(File mount, Map driveInfo) {
                    if (DEBUG) {
                        System.out.println("Mounted " + mount);
                        for (Object key : driveInfo.keySet()) {
                            Object val = driveInfo.get(key);
                            System.out.println("\t" + key + "\t:\t" + val);
                        }
                    }
                    boolean isOptical = MapUtils.getMapLong(driveInfo, "isOptical", 0L) != 0L;
                    boolean isRemovable = MapUtils.getMapLong(driveInfo, "Removable", 0L) != 0L;
                    boolean isWritable = MapUtils.getMapLong(driveInfo, "Writable", 0L) != 0L;
                    boolean isWritableUSB = isRemovable && isWritable && !isOptical;
                    driveInfo.put("isWritableUSB", isWritableUSB);
                    DriveDetectorFactory.getDeviceDetector().driveDetected(mount, driveInfo);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static native int AEGetParamDesc(int var0, int var1, int var2, Object var3);

    public static native String getVersion();

    public static native String getDocDir();

    public static native void memmove(byte[] var0, int var1, int var2);

    public static native void initializeDriveDetection(OSXDriveDetectListener var0);

    public static native void initializeLight();

    public static native boolean setDefaultAppForExt(String var0, String var1);

    public static native boolean setDefaultAppForMime(String var0, String var1);

    public static native boolean setDefaultAppForScheme(String var0, String var1);

    public static native String getDefaultAppForExt(String var0);

    public static native String getDefaultAppForMime(String var0);

    public static native String getDefaultAppForScheme(String var0);

    public static native boolean canSetDefaultApp();

    public static native void disableAppNap();

    public static boolean isLoaded() {
        return bLoaded;
    }

    public static void main(String[] args) {
        DriveDetectedInfo[] infos;
        DriveDetectedInfo[] driveDetectedInfoArray = infos = DriveDetectorFactory.getDeviceDetector().getDetectedDriveInfo();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            DriveDetectedInfo info = driveDetectedInfoArray[n2];
            System.out.println(info.getLocation());
            Map<String, Object> infoMap = info.getInfoMap();
            for (String key : infoMap.keySet()) {
                Object val = infoMap.get(key);
                System.out.println("\t" + key + ": " + val);
            }
            ++n2;
        }
    }
}

