/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.dht;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.DHTLogger;
import com.biglybt.core.dht.control.DHTControlActivity;
import com.biglybt.core.dht.control.DHTControlContact;
import com.biglybt.core.dht.nat.DHTNATPuncher;
import com.biglybt.core.dht.router.DHTRouterContact;
import com.biglybt.core.dht.transport.DHTTransportAlternativeContact;
import com.biglybt.core.dht.transport.DHTTransportAlternativeNetwork;
import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.dht.transport.DHTTransportFullStats;
import com.biglybt.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.biglybt.core.dht.transport.udp.DHTTransportUDP;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.impl.udp.UDPNetworkManager;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunStateHandler;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginConfigListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.ddb.DistributedDatabaseEvent;
import com.biglybt.pif.ddb.DistributedDatabaseKey;
import com.biglybt.pif.ddb.DistributedDatabaseListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.logging.LoggerChannelListener;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.components.UITextField;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.LabelParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import com.biglybt.plugin.dht.DHTPluginBasicInterface;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginInterface;
import com.biglybt.plugin.dht.DHTPluginKeyStats;
import com.biglybt.plugin.dht.DHTPluginListener;
import com.biglybt.plugin.dht.DHTPluginOperationListener;
import com.biglybt.plugin.dht.DHTPluginTransferHandler;
import com.biglybt.plugin.dht.DHTPluginValue;
import com.biglybt.plugin.dht.impl.DHTPluginContactImpl;
import com.biglybt.plugin.dht.impl.DHTPluginImpl;
import com.biglybt.plugin.dht.impl.DHTPluginImplAdapter;
import com.biglybt.plugin.upnp.UPnPMapping;
import com.biglybt.plugin.upnp.UPnPPlugin;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DHTPlugin
implements Plugin,
DHTPluginInterface {
    public static final int EVENT_DHT_AVAILABLE = 1024;
    public static final int STATUS_DISABLED = 1;
    public static final int STATUS_INITALISING = 2;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_FAILED = 4;
    public static final byte FLAG_SINGLE_VALUE = 0;
    public static final byte FLAG_DOWNLOADING = 1;
    public static final byte FLAG_SEEDING = 2;
    public static final byte FLAG_MULTI_VALUE = 4;
    public static final byte FLAG_STATS = 8;
    public static final byte FLAG_ANON = 16;
    public static final byte FLAG_PRECIOUS = 32;
    public static final byte DT_NONE = 1;
    public static final byte DT_FREQUENCY = 2;
    public static final byte DT_SIZE = 3;
    public static final int NW_MAIN = 0;
    public static final int NW_AZ_MAIN = 0;
    public static final int NW_AZ_MAIN_V6 = 3;
    public static final int NW_AZ_CVS = 1;
    public static final int NW_BIGLYBT_MAIN = 4;
    public static final int MAX_VALUE_SIZE = 512;
    private static final String PLUGIN_VERSION = "1.0";
    private static final String PLUGIN_NAME = "Distributed DB";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dht";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.dht";
    private static final boolean AZ_MAIN_DHT_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.main_v4.enable", true);
    private static final boolean AZ_CVS_DHT_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.cvs_v4.enable", false);
    private static final boolean AZ_MAIN_DHT_V6_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.main_v6.enable", true);
    private static final boolean BIGLYBT_MAIN_DHT_ENABLE = COConfigurationManager.getBooleanParameter("dht.net.biglybt_main_v4.enable", true);
    private PluginInterface plugin_interface;
    private int status = 1;
    private DHTPluginImpl[] dhts;
    private DHTPluginImpl main_dht;
    private DHTPluginImpl cvs_dht;
    private DHTPluginImpl main_v6_dht;
    private DHTPluginImpl biglybt_dht;
    private ActionParameter reseed;
    private boolean enabled;
    private int dht_data_port;
    private boolean got_extended_use;
    private boolean extended_use;
    private AESemaphore init_sem = new AESemaphore("DHTPlugin:init");
    private AEMonitor port_change_mon = new AEMonitor("DHTPlugin:portChanger");
    private boolean port_changing;
    private int port_change_outstanding;
    private boolean[] ipfilter_logging = new boolean[1];
    private BooleanParameter warn_user;
    private BooleanParameter prefer_i2p;
    private BooleanParameter torrent_xfer;
    private UPnPMapping upnp_mapping;
    private LoggerChannel log;
    private DHTLogger dht_log;
    private List listeners = new ArrayList();
    private long start_mono_time = SystemTime.getMonotonousTime();

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", PLUGIN_VERSION);
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.status = 2;
        this.plugin_interface = _plugin_interface;
        this.dht_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("dht.info");
        BooleanParameter enabled_param = config.addBooleanParameter2("dht.enabled", "dht.enabled", true);
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            @Override
            public void configSaved() {
                int new_dht_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                if (new_dht_data_port != DHTPlugin.this.dht_data_port) {
                    DHTPlugin.this.changePort(new_dht_data_port);
                }
            }
        });
        LabelParameter reseed_label = config.addLabelParameter2("dht.reseed.label");
        final StringParameter reseed_ip = config.addStringParameter2("dht.reseed.ip", "dht.reseed.ip", "");
        final IntParameter reseed_port = config.addIntParameter2("dht.reseed.port", "dht.reseed.port", 0);
        this.reseed = config.addActionParameter2("dht.reseed.info", "dht.reseed");
        this.reseed.setEnabled(false);
        config.createGroup("dht.reseed.group", reseed_label, reseed_ip, reseed_port, this.reseed);
        final BooleanParameter ipfilter_logging_param = config.addBooleanParameter2("dht.ipfilter.log", "dht.ipfilter.log", true);
        this.ipfilter_logging[0] = ipfilter_logging_param.getValue();
        ipfilter_logging_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter p) {
                ((DHTPlugin)DHTPlugin.this).ipfilter_logging[0] = ipfilter_logging_param.getValue();
            }
        });
        this.warn_user = config.addBooleanParameter2("dht.warn.user", "dht.warn.user", true);
        this.prefer_i2p = config.addBooleanParameter2("dht.prefer.i2p", "dht.prefer.i2p", false);
        final BooleanParameter sleeping = config.addBooleanParameter2("dht.is.sleeping", "dht.is.sleeping", false);
        AERunStateHandler.addListener(new AERunStateHandler.RunStateChangeListener(){

            @Override
            public void runStateChanged(long run_state) {
                sleeping.setValue(AERunStateHandler.isDHTSleeping());
            }
        }, true);
        sleeping.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                AERunStateHandler.setDHTSleeping(sleeping.getValue());
            }
        });
        this.torrent_xfer = config.addBooleanParameter2("dht.torrent_xfer.enable", "dht.torrent_xfer.enable", true);
        final BooleanParameter advanced = config.addBooleanParameter2("dht.advanced", "dht.advanced", false);
        LabelParameter advanced_label = config.addLabelParameter2("dht.advanced.label");
        final StringParameter override_ip = config.addStringParameter2("dht.override.ip", "dht.override.ip", "");
        config.createGroup("dht.advanced.group", advanced_label, override_ip);
        advanced.addEnabledOnSelection((Parameter)advanced_label);
        advanced.addEnabledOnSelection((Parameter)override_ip);
        final StringParameter command = config.addStringParameter2("dht.execute.command", "dht.execute.command", "print");
        ActionParameter execute = config.addActionParameter2("dht.execute.info", "dht.execute");
        final BooleanParameter logging = config.addBooleanParameter2("dht.logging", "dht.logging", false);
        config.createGroup("dht.diagnostics.group", command, execute, logging);
        logging.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                if (DHTPlugin.this.dhts != null) {
                    int i = 0;
                    while (i < DHTPlugin.this.dhts.length) {
                        DHTPlugin.this.dhts[i].setLogging(logging.getValue());
                        ++i;
                    }
                }
            }
        });
        final DHTPluginOperationListener log_polistener = new DHTPluginOperationListener(){

            @Override
            public boolean diversified() {
                return true;
            }

            @Override
            public void starts(byte[] key) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                DHTPlugin.this.log.log("valueRead: " + new String(value.getValue()) + " from " + originator.getName() + "/" + originator.getAddress() + ", flags=" + Integer.toHexString(value.getFlags() & 0xFF));
                if ((value.getFlags() & 8) != 0) {
                    DHTPluginKeyStats stats2 = DHTPlugin.this.decodeStats(value);
                    DHTPlugin.this.log.log("    stats: size=" + (stats2 == null ? "null" : Integer.valueOf(stats2.getSize())));
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                DHTPlugin.this.log.log("valueWritten:" + new String(value.getValue()) + " to " + target.getName() + "/" + target.getAddress());
            }

            @Override
            public void complete(byte[] key, boolean timeout_occurred) {
                DHTPlugin.this.log.log("complete: timeout = " + timeout_occurred);
            }
        };
        execute.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                AEThread2 t = new AEThread2("DHT:commandrunner", true){

                    @Override
                    public void run() {
                        try {
                            if (DHTPlugin.this.dhts == null) {
                                return;
                            }
                            String c = command.getValue().trim();
                            String lc = c.toLowerCase();
                            if (lc.equals("suspend")) {
                                if (!DHTPlugin.this.setSuspended(true)) {
                                    Debug.out("Suspend failed");
                                }
                                return;
                            }
                            if (lc.equals("resume")) {
                                if (!DHTPlugin.this.setSuspended(false)) {
                                    Debug.out("Resume failed");
                                }
                                return;
                            }
                            if (lc.equals("seed_test")) {
                                List<DHTTransportAlternativeContact> contacts;
                                int net;
                                int[] nArray = DHTTransportAlternativeNetwork.AT_ALL_PUB;
                                int n = DHTTransportAlternativeNetwork.AT_ALL_PUB.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    net = nArray[n2];
                                    DHTPlugin.this.log.log("Network " + net);
                                    contacts = DHTUDPUtils.getAlternativeContacts(net, 16);
                                    for (DHTTransportAlternativeContact contact : contacts) {
                                        DHTPlugin.this.log.log("    " + contact.getProperties());
                                    }
                                    ++n2;
                                }
                                nArray = DHTTransportAlternativeNetwork.AT_ALL_I2P;
                                n = DHTTransportAlternativeNetwork.AT_ALL_I2P.length;
                                n2 = 0;
                                while (n2 < n) {
                                    net = nArray[n2];
                                    DHTPlugin.this.log.log("Network " + net);
                                    contacts = DHTUDPUtils.getAlternativeContacts(net, 16);
                                    for (DHTTransportAlternativeContact contact : contacts) {
                                        DHTPlugin.this.log.log("    " + contact.getProperties());
                                    }
                                    ++n2;
                                }
                                return;
                            }
                            if (lc.equals("bridge_put")) {
                                try {
                                    List<DistributedDatabase> ddbs = DHTPlugin.this.plugin_interface.getUtilities().getDistributedDatabases(new String[]{"I2P"});
                                    DistributedDatabase ddb = ddbs.get(0);
                                    DistributedDatabaseKey key = ddb.createKey("fred");
                                    key.setFlags(2);
                                    ddb.write(new DistributedDatabaseListener(){

                                        @Override
                                        public void event(DistributedDatabaseEvent event2) {
                                        }
                                    }, key, ddb.createValue("bill"));
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                            int i = 0;
                            while (i < DHTPlugin.this.dhts.length) {
                                DHT dht = DHTPlugin.this.dhts[i].getDHT();
                                DHTTransportUDP transport = (DHTTransportUDP)dht.getTransport();
                                if (lc.equals("print")) {
                                    dht.print(true);
                                    DHTPlugin.this.dhts[i].logStats();
                                } else if (lc.equals("pingall")) {
                                    if (i == 1) {
                                        dht.getControl().pingAll();
                                    }
                                } else if (lc.equals("versions")) {
                                    List<DHTRouterContact> contacts = dht.getRouter().getAllContacts();
                                    TreeMap<Byte, Integer> counts = new TreeMap<Byte, Integer>();
                                    for (DHTRouterContact r : contacts) {
                                        DHTControlContact contact = (DHTControlContact)((Object)r.getAttachment());
                                        byte v = contact.getTransportContact().getProtocolVersion();
                                        Integer count = (Integer)counts.get(v);
                                        if (count == null) {
                                            counts.put(v, 1);
                                            continue;
                                        }
                                        counts.put(v, count + 1);
                                    }
                                    DHTPlugin.this.log.log("Net " + dht.getTransport().getNetwork());
                                    int total = contacts.size();
                                    if (total == 0) {
                                        DHTPlugin.this.log.log("   no contacts");
                                    } else {
                                        String ver = "";
                                        for (Map.Entry entry : counts.entrySet()) {
                                            ver = String.valueOf(ver) + (ver.length() == 0 ? "" : ", ") + entry.getKey() + "=" + 100 * (Integer)entry.getValue() / total + "%";
                                        }
                                        DHTPlugin.this.log.log("    contacts=" + total + ": " + ver);
                                    }
                                } else if (lc.equals("testca")) {
                                    ((DHTTransportUDPImpl)transport).testExternalAddressChange();
                                } else if (lc.equals("testnd")) {
                                    ((DHTTransportUDPImpl)transport).testNetworkAlive(false);
                                } else if (lc.equals("testna")) {
                                    ((DHTTransportUDPImpl)transport).testNetworkAlive(true);
                                } else {
                                    int pos = c.indexOf(32);
                                    if (pos != -1) {
                                        String lhs = lc.substring(0, pos);
                                        String rhs = c.substring(pos + 1);
                                        if (lhs.equals("set")) {
                                            pos = rhs.indexOf(61);
                                            if (pos != -1) {
                                                DHTPlugin.this.put(rhs.substring(0, pos).getBytes(), "DHT Plugin: set", rhs.substring(pos + 1).getBytes(), (byte)0, log_polistener);
                                            }
                                        } else if (lhs.equals("get")) {
                                            DHTPlugin.this.get(rhs.getBytes("UTF-8"), "DHT Plugin: get", (byte)0, 1, 10000L, true, false, log_polistener);
                                        } else if (lhs.equals("query")) {
                                            DHTPlugin.this.get(rhs.getBytes("UTF-8"), "DHT Plugin: get", (byte)8, 1, 10000L, true, false, log_polistener);
                                        } else if (lhs.equals("punch")) {
                                            HashMap<String, String> originator_data = new HashMap<String, String>();
                                            originator_data.put("hello", "mum");
                                            DHTNATPuncher puncher = dht.getNATPuncher();
                                            if (puncher != null) {
                                                puncher.punch("Test", transport.getLocalContact(), null, originator_data);
                                            }
                                        } else {
                                            try {
                                                DHTTransportContact contact;
                                                pos = rhs.lastIndexOf(":");
                                                if (pos == -1) {
                                                    contact = transport.getLocalContact();
                                                } else {
                                                    String host = rhs.substring(0, pos);
                                                    int port = Integer.parseInt(rhs.substring(pos + 1));
                                                    contact = transport.importContact(new InetSocketAddress(host, port), transport.getProtocolVersion(), false);
                                                }
                                                if (lhs.equals("stats")) {
                                                    DHTPlugin.this.log.log("Stats request to " + contact.getAddress());
                                                    DHTTransportFullStats stats2 = contact.getStats();
                                                    DHTPlugin.this.log.log("Stats:" + (stats2 == null ? "<null>" : stats2.getString()));
                                                    DHTControlActivity[] activities = dht.getControl().getActivities();
                                                    int j = 0;
                                                    while (j < activities.length) {
                                                        DHTPlugin.this.log.log("    act:" + activities[j].getString());
                                                        ++j;
                                                    }
                                                } else if (lhs.equals("ping")) {
                                                    DHTPlugin.this.log.log("Pinging " + contact.getAddress());
                                                    contact.sendImmediatePing(new DHTTransportReplyHandlerAdapter(){

                                                        @Override
                                                        public void failed(DHTTransportContact contact, Throwable error) {
                                                            DHTPlugin.this.log.log("Ping to " + contact.getAddress() + " FAILED - " + Debug.getNestedExceptionMessage(error));
                                                        }

                                                        @Override
                                                        public void pingReply(DHTTransportContact contact) {
                                                            DHTPlugin.this.log.log("Ping to " + contact.getAddress() + " OK");
                                                        }
                                                    }, 10000L);
                                                }
                                            }
                                            catch (Throwable e) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                };
                t.start();
            }
        });
        this.reseed.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DHTPlugin.this.reseed.setEnabled(false);
                AEThread2 t = new AEThread2("DHT:reseeder", true){

                    @Override
                    public void run() {
                        try {
                            String ip = reseed_ip.getValue().trim();
                            if (DHTPlugin.this.dhts == null) {
                                return;
                            }
                            int port = reseed_port.getValue();
                            int i = 0;
                            while (i < DHTPlugin.this.dhts.length) {
                                DHTPluginImpl dht = DHTPlugin.this.dhts[i];
                                if (ip.length() == 0 || port == 0) {
                                    dht.checkForReSeed(true);
                                } else {
                                    DHTTransportContact seed = dht.importSeed(ip, port);
                                    if (seed != null) {
                                        dht.integrateDHT(false, seed);
                                    }
                                }
                                ++i;
                            }
                        }
                        finally {
                            DHTPlugin.this.reseed.setEnabled(true);
                        }
                    }
                };
                t.start();
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        this.dht_log = new DHTLogger(){

            @Override
            public void log(String str) {
                DHTPlugin.this.log.log(str);
            }

            @Override
            public void log(Throwable e) {
                DHTPlugin.this.log.log(e);
            }

            @Override
            public void log(int log_type, String str) {
                if (this.isEnabled(log_type)) {
                    DHTPlugin.this.log.log(str);
                }
            }

            @Override
            public boolean isEnabled(int log_type) {
                if (log_type == 2) {
                    return DHTPlugin.this.ipfilter_logging[0];
                }
                return true;
            }

            @Override
            public PluginInterface getPluginInterface() {
                return DHTPlugin.this.log.getLogger().getPluginInterface();
            }
        };
        if (!enabled_param.getValue()) {
            model.getStatus().setText("Disabled");
            this.status = 1;
            this.init_sem.releaseForever();
            return;
        }
        this.setPluginInfo();
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                PluginInterface pi_upnp = DHTPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                if (pi_upnp == null) {
                    DHTPlugin.this.log.log("UPnP plugin not found, can't map port");
                } else {
                    DHTPlugin.this.upnp_mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(DHTPlugin.this.plugin_interface.getPluginName(), false, DHTPlugin.this.dht_data_port, true);
                }
                String ip = null;
                if (advanced.getValue() && (ip = override_ip.getValue().trim()).length() == 0) {
                    ip = null;
                }
                DHTPlugin.this.initComplete(model.getStatus(), logging.getValue(), ip);
            }

            @Override
            public void closedownInitiated() {
                if (DHTPlugin.this.dhts != null) {
                    int i = 0;
                    while (i < DHTPlugin.this.dhts.length) {
                        DHTPlugin.this.dhts[i].closedownInitiated();
                        ++i;
                    }
                }
                DHTPlugin.this.saveClockSkew();
            }

            @Override
            public void closedownComplete() {
            }
        });
        int sample_frequency = 60000;
        int sample_stats_ticks = 15;
        this.plugin_interface.getUtilities().createTimer("DHTStats", true).addPeriodicEvent(60000L, new UTTimerEventPerformer(){

            @Override
            public void perform(UTTimerEvent event2) {
                if (DHTPlugin.this.dhts != null) {
                    int i = 0;
                    while (i < DHTPlugin.this.dhts.length) {
                        DHTPlugin.this.dhts[i].updateStats(15);
                        ++i;
                    }
                }
                DHTPlugin.this.setPluginInfo();
                DHTPlugin.this.saveClockSkew();
            }
        });
    }

    @Override
    public InetSocketAddress getConnectionOrientedEndpoint() {
        return this.getLocalAddress().getAddress();
    }

    @Override
    public InetSocketAddress[] getConnectionOrientedEndpoints() {
        DHTPluginContact[] locals = this.getLocalAddresses();
        HashSet<InetSocketAddress> endpoints = new HashSet<InetSocketAddress>();
        DHTPluginContact[] dHTPluginContactArray = locals;
        int n = locals.length;
        int n2 = 0;
        while (n2 < n) {
            DHTPluginContact c = dHTPluginContactArray[n2];
            endpoints.add(c.getAddress());
            ++n2;
        }
        return endpoints.toArray(new InetSocketAddress[0]);
    }

    protected void changePort(int _new_port) {
        try {
            this.port_change_mon.enter();
            this.port_change_outstanding = _new_port;
            if (this.port_changing) {
                return;
            }
            this.port_changing = true;
        }
        finally {
            this.port_change_mon.exit();
        }
        new AEThread2("DHTPlugin:portChanger", true){

            @Override
            public void run() {
                block11: while (true) {
                    int new_port;
                    try {
                        DHTPlugin.this.port_change_mon.enter();
                        new_port = DHTPlugin.this.port_change_outstanding;
                    }
                    finally {
                        DHTPlugin.this.port_change_mon.exit();
                    }
                    try {
                        DHTPlugin.this.dht_data_port = new_port;
                        if (DHTPlugin.this.upnp_mapping != null && DHTPlugin.this.upnp_mapping.getPort() != new_port) {
                            DHTPlugin.this.upnp_mapping.setPort(new_port);
                        }
                        if (DHTPlugin.this.status != 3 || DHTPlugin.this.dhts == null) continue;
                        int i = 0;
                        while (true) {
                            if (i >= DHTPlugin.this.dhts.length) continue block11;
                            if (DHTPlugin.this.dhts[i].getPort() != new_port) {
                                DHTPlugin.this.dhts[i].setPort(new_port);
                            }
                            ++i;
                        }
                    }
                    finally {
                        try {
                            DHTPlugin.this.port_change_mon.enter();
                            if (new_port != DHTPlugin.this.port_change_outstanding) continue;
                            DHTPlugin.this.port_changing = false;
                        }
                        finally {
                            DHTPlugin.this.port_change_mon.exit();
                            continue;
                        }
                    }
                    break;
                }
            }
        }.start();
    }

    protected void initComplete(final UITextField status_area, final boolean logging, final String override_ip) {
        AEThread2 t = new AEThread2("DHTPlugin.init", true){

            @Override
            public void run() {
                block8: {
                    boolean went_async = false;
                    try {
                        try {
                            DHTPlugin.this.enabled = VersionCheckClient.getSingleton().DHTEnableAllowed();
                            if (DHTPlugin.this.enabled) {
                                status_area.setText("Initialising");
                                DelayedTask dt = DHTPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                                    @Override
                                    public void run() {
                                        new AEThread2("DHTPlugin.init2", true){

                                            @Override
                                            public void run() {
                                                block10: {
                                                    try {
                                                        try {
                                                            ArrayList<DHTPluginImpl> plugins = new ArrayList<DHTPluginImpl>();
                                                            boolean hasV4 = NetworkAdmin.getSingleton().hasDHTIPV4();
                                                            DHTPluginImplAdapter adapter = new DHTPluginImplAdapter(){

                                                                @Override
                                                                public void localContactChanged(DHTPluginContact local_contact) {
                                                                    int i = 0;
                                                                    while (i < DHTPlugin.this.listeners.size()) {
                                                                        ((DHTPluginListener)DHTPlugin.this.listeners.get(i)).localAddressChanged(local_contact);
                                                                        ++i;
                                                                    }
                                                                }
                                                            };
                                                            if (AZ_MAIN_DHT_ENABLE && hasV4) {
                                                                DHTPlugin.this.main_dht = new DHTPluginImpl(DHTPlugin.this, DHTPlugin.this.plugin_interface, CoreFactory.getSingleton().getNATTraverser(), adapter, DHTTransportUDP.PROTOCOL_VERSION_AZ_MAIN, 0, false, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                                plugins.add(DHTPlugin.this.main_dht);
                                                                adapter = null;
                                                            }
                                                            if (AZ_MAIN_DHT_V6_ENABLE && NetworkAdmin.getSingleton().hasDHTIPV6()) {
                                                                DHTPlugin.this.main_v6_dht = new DHTPluginImpl(DHTPlugin.this, DHTPlugin.this.plugin_interface, CoreFactory.getSingleton().getNATTraverser(), adapter, DHTTransportUDP.PROTOCOL_VERSION_AZ_MAIN, 3, true, null, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                                plugins.add(DHTPlugin.this.main_v6_dht);
                                                                adapter = null;
                                                            }
                                                            if (Constants.isCVSVersion() && AZ_CVS_DHT_ENABLE && hasV4) {
                                                                DHTPlugin.this.cvs_dht = new DHTPluginImpl(DHTPlugin.this, DHTPlugin.this.plugin_interface, CoreFactory.getSingleton().getNATTraverser(), adapter, DHTTransportUDP.PROTOCOL_VERSION_AZ_CVS, 1, false, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                                plugins.add(DHTPlugin.this.cvs_dht);
                                                                adapter = null;
                                                            }
                                                            if (BIGLYBT_MAIN_DHT_ENABLE && hasV4) {
                                                                DHTPlugin.this.biglybt_dht = new DHTPluginImpl(DHTPlugin.this, DHTPlugin.this.plugin_interface, CoreFactory.getSingleton().getNATTraverser(), adapter, DHTTransportUDP.PROTOCOL_VERSION_BIGLYBT, 4, false, override_ip, DHTPlugin.this.dht_data_port, DHTPlugin.this.reseed, DHTPlugin.this.warn_user, logging, DHTPlugin.this.log, DHTPlugin.this.dht_log);
                                                                plugins.add(DHTPlugin.this.biglybt_dht);
                                                                adapter = null;
                                                            }
                                                            DHTPluginImpl[] _dhts = new DHTPluginImpl[plugins.size()];
                                                            plugins.toArray(_dhts);
                                                            DHTPlugin.this.dhts = _dhts;
                                                            DHTPlugin.this.status = DHTPlugin.this.dhts[0].getStatus();
                                                            status_area.setText(DHTPlugin.this.dhts[0].getStatusText());
                                                        }
                                                        catch (Throwable e) {
                                                            DHTPlugin.this.enabled = false;
                                                            DHTPlugin.this.status = 1;
                                                            status_area.setText("Disabled due to error during initialisation");
                                                            DHTPlugin.this.log.log(e);
                                                            Debug.printStackTrace(e);
                                                            DHTPlugin.this.init_sem.releaseForever();
                                                            break block10;
                                                        }
                                                    }
                                                    catch (Throwable throwable) {
                                                        DHTPlugin.this.init_sem.releaseForever();
                                                        throw throwable;
                                                    }
                                                    DHTPlugin.this.init_sem.releaseForever();
                                                }
                                                if (DHTPlugin.this.status == 3) {
                                                    DHTPlugin.this.changePort(DHTPlugin.this.dht_data_port);
                                                }
                                            }
                                        }.start();
                                    }
                                });
                                dt.queue();
                                went_async = true;
                                break block8;
                            }
                            DHTPlugin.this.status = 1;
                            status_area.setText("Disabled administratively due to network problems");
                        }
                        catch (Throwable e) {
                            DHTPlugin.this.enabled = false;
                            DHTPlugin.this.status = 1;
                            status_area.setText("Disabled due to error during initialisation");
                            DHTPlugin.this.log.log(e);
                            Debug.printStackTrace(e);
                            if (!went_async) {
                                DHTPlugin.this.init_sem.releaseForever();
                            }
                        }
                    }
                    finally {
                        if (!went_async) {
                            DHTPlugin.this.init_sem.releaseForever();
                        }
                    }
                }
            }
        };
        t.start();
    }

    protected void setPluginInfo() {
        boolean reachable = this.plugin_interface.getPluginconfig().getPluginBooleanParameter("dht.reachable.0", true);
        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", reachable ? "1" : "0");
    }

    @Override
    public boolean isEnabled() {
        if (this.plugin_interface == null) {
            Debug.out("Called too early!");
            return false;
        }
        if (this.plugin_interface.isInitialisationThread() && !this.init_sem.isReleasedForever()) {
            Debug.out("Initialisation deadlock detected");
            return true;
        }
        this.init_sem.reserve();
        return this.enabled;
    }

    public boolean peekEnabled() {
        if (this.init_sem.isReleasedForever()) {
            return this.enabled;
        }
        return true;
    }

    @Override
    public boolean isInitialising() {
        return !this.init_sem.isReleasedForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSuspended(boolean susp) {
        if (!this.init_sem.isReleasedForever()) {
            return false;
        }
        DHTPlugin dHTPlugin = this;
        synchronized (dHTPlugin) {
            DHTPluginImpl[] dHTPluginImplArray = this.dhts;
            int n = this.dhts.length;
            int n2 = 0;
            while (n2 < n) {
                DHTPluginImpl dht = dHTPluginImplArray[n2];
                dht.setSuspended(susp);
                ++n2;
            }
        }
        return true;
    }

    @Override
    public boolean isExtendedUseAllowed() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.got_extended_use) {
            this.got_extended_use = true;
            this.extended_use = VersionCheckClient.getSingleton().DHTExtendedUseAllowed();
        }
        return this.extended_use;
    }

    @Override
    public String getNetwork() {
        return "Public";
    }

    public boolean isReachable() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].isReachable();
    }

    public boolean isDiversified(byte[] key) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].isDiversified(key);
    }

    @Override
    public void put(byte[] key, String description, byte[] value, byte flags, DHTPluginOperationListener listener) {
        this.put(key, description, value, flags, true, listener);
    }

    public void put(byte[] key, String description, byte[] value, byte flags, boolean high_priority, final DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.dhts.length == 1) {
            this.dhts[0].put(key, description, value, flags, high_priority, listener);
        } else {
            final int[] completes_to_go = new int[]{this.dhts.length};
            DHTPluginOperationListener main_listener = new DHTPluginOperationListener(){

                @Override
                public boolean diversified() {
                    return listener.diversified();
                }

                @Override
                public void starts(byte[] key) {
                    listener.starts(key);
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    listener.valueRead(originator, value);
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    listener.valueWritten(target, value);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        if (completes_to_go[0] == 0) {
                            listener.complete(key, timeout_occurred);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            this.dhts[0].put(key, description, value, flags, high_priority, main_listener);
            int i = 1;
            while (i < this.dhts.length) {
                this.dhts[i].put(key, description, value, flags, high_priority, new DHTPluginOperationListener(){

                    @Override
                    public boolean diversified() {
                        return true;
                    }

                    @Override
                    public void starts(byte[] key) {
                    }

                    @Override
                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    }

                    @Override
                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete(byte[] key, boolean timeout_occurred) {
                        int[] nArray = completes_to_go;
                        synchronized (completes_to_go) {
                            completes_to_go[0] = completes_to_go[0] - 1;
                            if (completes_to_go[0] == 0) {
                                listener.complete(key, timeout_occurred);
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                });
                ++i;
            }
        }
    }

    private DHTPluginImpl[] getDHTsToUse() {
        if (this.main_dht != null && this.main_v6_dht != null) {
            DHTPluginImpl to_remove = null;
            if (!this.main_v6_dht.isHealthy()) {
                to_remove = this.main_v6_dht;
            } else if (!this.main_dht.isHealthy()) {
                to_remove = this.main_dht;
            }
            if (to_remove == null) {
                return this.dhts;
            }
            DHTPluginImpl[] result = new DHTPluginImpl[this.dhts.length - 1];
            int pos = 0;
            DHTPluginImpl[] dHTPluginImplArray = this.dhts;
            int n = this.dhts.length;
            int n2 = 0;
            while (n2 < n) {
                DHTPluginImpl dht = dHTPluginImplArray[n2];
                if (dht != to_remove) {
                    result[pos++] = dht;
                }
                ++n2;
            }
            return result;
        }
        return this.dhts;
    }

    @Override
    public void put(byte[] key, String description, byte[] value, short flags, boolean high_priority, final DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.dhts.length == 1) {
            this.dhts[0].putEx(key, description, value, flags, high_priority, listener);
        } else {
            DHTPluginImpl[] dhts_to_use = this.getDHTsToUse();
            final int[] completes_to_go = new int[]{dhts_to_use.length};
            DHTPluginOperationListener main_listener = new DHTPluginOperationListener(){

                @Override
                public boolean diversified() {
                    return listener.diversified();
                }

                @Override
                public void starts(byte[] key) {
                    listener.starts(key);
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    listener.valueRead(originator, value);
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    listener.valueWritten(target, value);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        if (completes_to_go[0] == 0) {
                            listener.complete(key, timeout_occurred);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            dhts_to_use[0].putEx(key, description, value, flags, high_priority, main_listener);
            int i = 1;
            while (i < dhts_to_use.length) {
                dhts_to_use[i].putEx(key, description, value, flags, high_priority, new DHTPluginOperationListener(){

                    @Override
                    public boolean diversified() {
                        return true;
                    }

                    @Override
                    public void starts(byte[] key) {
                    }

                    @Override
                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    }

                    @Override
                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete(byte[] key, boolean timeout_occurred) {
                        int[] nArray = completes_to_go;
                        synchronized (completes_to_go) {
                            completes_to_go[0] = completes_to_go[0] - 1;
                            if (completes_to_go[0] == 0) {
                                listener.complete(key, timeout_occurred);
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                });
                ++i;
            }
        }
    }

    public DHTPluginValue getLocalValue(byte[] key) {
        if (this.main_dht != null) {
            return this.main_dht.getLocalValue(key);
        }
        if (this.cvs_dht != null) {
            return this.cvs_dht.getLocalValue(key);
        }
        if (this.main_v6_dht != null) {
            return this.main_v6_dht.getLocalValue(key);
        }
        return null;
    }

    @Override
    public List<DHTPluginValue> getValues() {
        if (this.main_dht != null) {
            return this.main_dht.getValues();
        }
        if (this.cvs_dht != null) {
            return this.cvs_dht.getValues();
        }
        if (this.main_v6_dht != null) {
            return this.main_v6_dht.getValues();
        }
        return new ArrayList<DHTPluginValue>();
    }

    @Override
    public List<DHTPluginValue> getValues(byte[] key) {
        if (this.main_dht != null) {
            return this.main_dht.getValues(key);
        }
        if (this.cvs_dht != null) {
            return this.cvs_dht.getValues(key);
        }
        if (this.main_v6_dht != null) {
            return this.main_v6_dht.getValues(key);
        }
        return new ArrayList<DHTPluginValue>();
    }

    public List<DHTPluginValue> getValues(int network) {
        DHTPluginImpl dht = null;
        switch (network) {
            case 0: {
                dht = this.main_dht;
                break;
            }
            case 3: {
                dht = this.main_v6_dht;
                break;
            }
            case 1: {
                dht = this.cvs_dht;
                break;
            }
            case 4: {
                dht = this.biglybt_dht;
            }
        }
        if (dht == null) {
            return new ArrayList<DHTPluginValue>();
        }
        return dht.getValues();
    }

    @Override
    public void get(final byte[] original_key, String description, byte flags, int max_values, final long timeout, boolean exhaustive, boolean high_priority, final DHTPluginOperationListener original_listener) {
        DHTPluginOperationListener main_listener;
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        if (this.cvs_dht == null) {
            main_listener = original_listener;
        } else {
            if (this.main_dht == null && this.main_v6_dht == null) {
                this.cvs_dht.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, original_listener);
                return;
            }
            final int[] completes_to_go = new int[]{2};
            final boolean[] main_timeout = new boolean[1];
            main_listener = new DHTPluginOperationListener(){

                @Override
                public boolean diversified() {
                    return original_listener.diversified();
                }

                @Override
                public void starts(byte[] key) {
                    original_listener.starts(original_key);
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    original_listener.valueRead(originator, value);
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    original_listener.valueWritten(target, value);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        main_timeout[0] = timeout_occurred;
                        if (completes_to_go[0] == 0) {
                            original_listener.complete(original_key, timeout_occurred);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            };
            this.cvs_dht.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, new DHTPluginOperationListener(){

                @Override
                public boolean diversified() {
                    return true;
                }

                @Override
                public void starts(byte[] key) {
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] nArray = completes_to_go;
                    synchronized (completes_to_go) {
                        completes_to_go[0] = completes_to_go[0] - 1;
                        if (completes_to_go[0] == 0) {
                            original_listener.complete(original_key, main_timeout[0]);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        DHTPluginImpl main_dht_to_use = this.main_dht;
        DHTPluginImpl main_v6_dht_to_use = this.main_v6_dht;
        if (main_dht_to_use != null && main_v6_dht_to_use != null) {
            if (!main_v6_dht_to_use.isHealthy()) {
                main_v6_dht_to_use = null;
            } else if (!main_dht_to_use.isHealthy()) {
                main_dht_to_use = null;
            }
        }
        if (main_dht_to_use != null && main_v6_dht_to_use == null) {
            main_dht_to_use.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, main_listener);
        } else if (main_dht_to_use == null && main_v6_dht_to_use != null) {
            main_v6_dht_to_use.get(original_key, description, flags, max_values, timeout, exhaustive, high_priority, main_listener);
        } else {
            byte[] v4_key = original_key;
            final byte[] v6_key = (byte[])original_key.clone();
            DHTPluginOperationListener dual_listener = new DHTPluginOperationListener(){
                private long start_time = SystemTime.getCurrentTime();
                private boolean started;
                private int complete_count = 0;
                private int result_count = 0;

                @Override
                public boolean diversified() {
                    return main_listener.diversified();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void starts(byte[] key) {
                    21 var2_2 = this;
                    synchronized (var2_2) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    main_listener.starts(original_key);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    21 var3_3 = this;
                    synchronized (var3_3) {
                        ++this.result_count;
                        if (this.complete_count < 2) {
                            main_listener.valueRead(originator, value);
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    Debug.out("eh?");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(final byte[] timeout_key, boolean timeout_occurred) {
                    21 var3_3 = this;
                    synchronized (var3_3) {
                        ++this.complete_count;
                        if (this.complete_count == 2) {
                            main_listener.complete(original_key, this.result_count > 0 ? false : timeout_occurred);
                            return;
                        }
                        if (this.complete_count > 2) {
                            return;
                        }
                        if (timeout_occurred) {
                            return;
                        }
                        if (timeout_key == v6_key) {
                            return;
                        }
                        long now = SystemTime.getCurrentTime();
                        long elapsed = now - this.start_time;
                        long rem = timeout - elapsed;
                        if (rem <= 0L) {
                            this.complete(timeout_key, true);
                        } else {
                            SimpleTimer.addEvent("DHTPlugin:dual_dht_early_timeout", now + rem, new TimerEventPerformer(){

                                @Override
                                public void perform(TimerEvent event2) {
                                    this.complete(timeout_key, true);
                                }
                            });
                        }
                    }
                }
            };
            main_dht_to_use.get(v4_key, description, flags, max_values, timeout, exhaustive, high_priority, dual_listener);
            main_v6_dht_to_use.get(v6_key, description, flags, max_values, timeout, exhaustive, high_priority, dual_listener);
        }
    }

    public boolean hasLocalKey(byte[] hash) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalValue(hash) != null;
    }

    @Override
    public void remove(byte[] key, String description, DHTPluginOperationListener listener) {
        this.remove(key, description, (short)0, listener);
    }

    @Override
    public void remove(final byte[] key, final String description, final short flags, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        this.dhts[0].remove(key, description, flags, listener);
        int i = 1;
        while (i < this.dhts.length) {
            final int f_i = i++;
            new AEThread2("multi-dht: remove", true){

                @Override
                public void run() {
                    DHTPlugin.this.dhts[f_i].remove(key, description, flags, new DHTPluginOperationListener(){

                        @Override
                        public boolean diversified() {
                            return true;
                        }

                        @Override
                        public void starts(byte[] key) {
                        }

                        @Override
                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        @Override
                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        @Override
                        public void complete(byte[] key, boolean timeout_occurred) {
                        }
                    });
                }
            }.start();
        }
    }

    @Override
    public void remove(DHTPluginContact[] targets, byte[] key, String description, DHTPluginOperationListener listener) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        HashMap<DHTPluginImpl, ArrayList<DHTPluginContactImpl>> dht_map = new HashMap<DHTPluginImpl, ArrayList<DHTPluginContactImpl>>();
        int i = 0;
        while (i < targets.length) {
            DHTPluginContactImpl target = (DHTPluginContactImpl)targets[i];
            DHTPluginImpl dht = target.getDHT();
            ArrayList<DHTPluginContactImpl> c = (ArrayList<DHTPluginContactImpl>)dht_map.get(dht);
            if (c == null) {
                c = new ArrayList<DHTPluginContactImpl>();
                dht_map.put(dht, c);
            }
            c.add(target);
            ++i;
        }
        Iterator it = dht_map.entrySet().iterator();
        boolean primary = true;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DHTPluginImpl dht = (DHTPluginImpl)entry.getKey();
            List contacts = (List)entry.getValue();
            DHTPluginContact[] dht_targets = new DHTPluginContact[contacts.size()];
            contacts.toArray(dht_targets);
            if (primary) {
                primary = false;
                dht.remove(dht_targets, key, description, listener);
                continue;
            }
            dht.remove(dht_targets, key, description, new DHTPluginOperationListener(){

                @Override
                public boolean diversified() {
                    return true;
                }

                @Override
                public void starts(byte[] key) {
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                }
            });
        }
    }

    @Override
    public DHTPluginContact importContact(Map<String, Object> map) {
        boolean want_ipv6;
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        DHTPluginImpl dht0 = this.dhts[0];
        DHTPluginContact result = dht0.importContact(map);
        if (result != null && (want_ipv6 = result.getAddress().getAddress() instanceof Inet6Address) != dht0.isIPV6()) {
            try {
                DHTPluginImpl[] dHTPluginImplArray = this.dhts;
                int n = this.dhts.length;
                int n2 = 0;
                while (n2 < n) {
                    DHTPluginContact temp;
                    DHTPluginImpl dht = dHTPluginImplArray[n2];
                    if (want_ipv6 == dht.isIPV6() && (temp = dht.importContact(map)) != null) {
                        result = temp;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public DHTPluginContact importContact(InetSocketAddress address) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        InetAddress contact_address = address.getAddress();
        DHTPluginImpl[] dHTPluginImplArray = this.dhts;
        int n = this.dhts.length;
        int n2 = 0;
        while (n2 < n) {
            DHTPluginImpl dht = dHTPluginImplArray[n2];
            InetAddress dht_address = dht.getLocalAddress().getAddress().getAddress();
            if (contact_address instanceof Inet4Address && dht_address instanceof Inet4Address || contact_address instanceof Inet6Address && dht_address instanceof Inet6Address) {
                return dht.importContact(address);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public DHTPluginContact importContact(InetSocketAddress address, byte version) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        InetAddress contact_address = address.getAddress();
        DHTPluginImpl[] dHTPluginImplArray = this.dhts;
        int n = this.dhts.length;
        int n2 = 0;
        while (n2 < n) {
            DHTPluginImpl dht = dHTPluginImplArray[n2];
            InetAddress dht_address = dht.getLocalAddress().getAddress().getAddress();
            if (contact_address instanceof Inet4Address && dht_address instanceof Inet4Address || contact_address instanceof Inet6Address && dht_address instanceof Inet6Address) {
                return dht.importContact(address, version);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public DHTPluginContact importContact(InetSocketAddress address, byte version, boolean is_cvs) {
        int preferred_net = is_cvs ? 1 : 0;
        return this.importContact(address, version, preferred_net);
    }

    @Override
    public DHTPluginContact importContact(InetSocketAddress address, byte version, int preferred_net) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        InetAddress contact_address = address.getAddress();
        DHTPluginImpl[] dHTPluginImplArray = this.dhts;
        int n = this.dhts.length;
        int n2 = 0;
        while (n2 < n) {
            DHTPluginImpl dht = dHTPluginImplArray[n2];
            if (dht.getDHT().getTransport().getNetwork() == preferred_net) {
                InetAddress dht_address = dht.getLocalAddress().getAddress().getAddress();
                if (contact_address instanceof Inet4Address && dht_address instanceof Inet4Address || contact_address instanceof Inet6Address && dht_address instanceof Inet6Address) {
                    return dht.importContact(address, version);
                }
            }
            ++n2;
        }
        return this.importContact(address, version);
    }

    @Override
    public DHTPluginContact getLocalAddress() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        return this.dhts[0].getLocalAddress();
    }

    @Override
    public DHTPluginContact[] getLocalAddresses() {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        DHTPluginContact[] result = new DHTPluginContact[this.dhts.length];
        int pos = 0;
        DHTPluginImpl[] dHTPluginImplArray = this.dhts;
        int n = this.dhts.length;
        int n2 = 0;
        while (n2 < n) {
            DHTPluginImpl d = dHTPluginImplArray[n2];
            result[pos++] = d.getLocalAddress();
            ++n2;
        }
        return result;
    }

    @Override
    public void registerHandler(byte[] handler_key, DHTPluginTransferHandler handler, Map<String, Object> options) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        int i = 0;
        while (i < this.dhts.length) {
            this.dhts[i].registerHandler(handler_key, handler, options);
            ++i;
        }
    }

    @Override
    public void unregisterHandler(byte[] handler_key, DHTPluginTransferHandler handler) {
        if (!this.isEnabled()) {
            throw new RuntimeException("DHT isn't enabled");
        }
        int i = 0;
        while (i < this.dhts.length) {
            this.dhts[i].unregisterHandler(handler_key, handler);
            ++i;
        }
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isSleeping() {
        return AERunStateHandler.isDHTSleeping();
    }

    public boolean isTorrentXferEnabled() {
        if (this.torrent_xfer == null) {
            return false;
        }
        return this.torrent_xfer.getValue();
    }

    public DHT[] getDHTs() {
        if (this.dhts == null) {
            return new DHT[0];
        }
        DHT[] res = new DHT[this.dhts.length];
        int i = 0;
        while (i < res.length) {
            res[i] = this.dhts[i].getDHT();
            ++i;
        }
        return res;
    }

    public DHT getDHT(int network) {
        if (this.dhts == null) {
            return null;
        }
        int i = 0;
        while (i < this.dhts.length) {
            if (this.dhts[i].getDHT().getTransport().getNetwork() == network) {
                return this.dhts[i].getDHT();
            }
            ++i;
        }
        return null;
    }

    public DHTPluginBasicInterface getDHTPlugin(int network) {
        if (this.dhts == null) {
            return null;
        }
        int i = 0;
        while (i < this.dhts.length) {
            if (this.dhts[i].getDHT().getTransport().getNetwork() == network) {
                return this.dhts[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public DHTPluginInterface.DHTInterface[] getDHTInterfaces() {
        if (this.dhts == null) {
            return new DHTPluginInterface.DHTInterface[0];
        }
        DHTPluginInterface.DHTInterface[] result = new DHTPluginInterface.DHTInterface[this.dhts.length];
        System.arraycopy(this.dhts, 0, result, 0, this.dhts.length);
        return result;
    }

    protected long loadClockSkew() {
        return this.plugin_interface.getPluginconfig().getPluginLongParameter("dht.skew", 0L);
    }

    protected void saveClockSkew() {
        long current;
        long existing = this.loadClockSkew();
        if (Math.abs(existing - (current = this.getClockSkew())) > 5000L) {
            this.plugin_interface.getPluginconfig().setPluginParameter("dht.skew", this.getClockSkew());
        }
    }

    public long getClockSkew() {
        if (this.dhts == null || this.dhts.length == 0) {
            return 0L;
        }
        long uptime = SystemTime.getMonotonousTime() - this.start_mono_time;
        if (uptime < 300000L) {
            return this.loadClockSkew();
        }
        long skew = this.dhts[0].getClockSkew();
        if (skew > 86400000L) {
            skew = 0L;
        }
        skew = skew / 500L * 500L;
        return skew;
    }

    @Override
    public DHTPluginKeyStats decodeStats(DHTPluginValue value) {
        return this.dhts[0].decodeStats(value);
    }

    @Override
    public void addListener(DHTPluginListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(DHTPluginListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void log(String str) {
        this.log.log(str);
    }
}

