/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.dht;

import com.biglybt.core.util.Debug;
import com.biglybt.plugin.dht.DHTPluginBasicInterface;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginKeyStats;
import com.biglybt.plugin.dht.DHTPluginListener;
import com.biglybt.plugin.dht.DHTPluginOperationListener;
import com.biglybt.plugin.dht.DHTPluginTransferHandler;
import com.biglybt.plugin.dht.DHTPluginValue;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;

public interface DHTPluginInterface
extends DHTPluginBasicInterface {
    public static final byte FLAG_SINGLE_VALUE = 0;
    public static final byte FLAG_DOWNLOADING = 1;
    public static final byte FLAG_SEEDING = 2;
    public static final byte FLAG_MULTI_VALUE = 4;
    public static final byte FLAG_STATS = 8;
    public static final byte FLAG_ANON = 16;
    public static final byte FLAG_PRECIOUS = 32;
    public static final byte FLAG_BRIDGED = 64;
    public static final short FLAG_PUT_AND_FORGET = 256;
    public static final int MAX_VALUE_SIZE = 512;

    public String getNetwork();

    @Override
    default public String getAENetwork() {
        return this.getNetwork();
    }

    public boolean isExtendedUseAllowed();

    public DHTPluginContact getLocalAddress();

    default public DHTPluginContact[] getLocalAddresses() {
        return new DHTPluginContact[]{this.getLocalAddress()};
    }

    public InetSocketAddress getConnectionOrientedEndpoint();

    default public InetSocketAddress[] getConnectionOrientedEndpoints() {
        return new InetSocketAddress[]{this.getConnectionOrientedEndpoint()};
    }

    public DHTPluginKeyStats decodeStats(DHTPluginValue var1);

    public void registerHandler(byte[] var1, DHTPluginTransferHandler var2, Map<String, Object> var3);

    public void unregisterHandler(byte[] var1, DHTPluginTransferHandler var2);

    public DHTPluginContact importContact(InetSocketAddress var1);

    public DHTPluginContact importContact(InetSocketAddress var1, byte var2);

    public DHTPluginContact importContact(InetSocketAddress var1, byte var2, boolean var3);

    default public DHTPluginContact importContact(InetSocketAddress address, byte version, int preferred_net) {
        return this.importContact(address, version, preferred_net == 1);
    }

    public DHTPluginContact importContact(Map<String, Object> var1);

    public List<DHTPluginValue> getValues(byte[] var1);

    public void remove(byte[] var1, String var2, DHTPluginOperationListener var3);

    default public void remove(byte[] key, String description, short flags, DHTPluginOperationListener listener) {
        if (flags != 0) {
            Debug.out("Flag loss!");
        }
        this.remove(key, description, listener);
    }

    public void remove(DHTPluginContact[] var1, byte[] var2, String var3, DHTPluginOperationListener var4);

    public void addListener(DHTPluginListener var1);

    public void removeListener(DHTPluginListener var1);

    public void log(String var1);

    public static interface DHTInterface {
        public byte[] getID();

        public boolean isIPV6();

        public int getNetwork();

        public DHTPluginContact[] getReachableContacts();

        public DHTPluginContact[] getRecentContacts();

        public List<DHTPluginContact> getClosestContacts(byte[] var1, boolean var2);
    }
}

