/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.magnet;

import com.biglybt.core.category.Category;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerEvent;
import com.biglybt.pif.peers.PeerListener2;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.peers.PeerManagerEvent;
import com.biglybt.pif.peers.PeerManagerListener2;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.magnet.MagnetPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MagnetPluginMDDownloader {
    private static final Object ACTIVE_SET_LOCK = new Object();
    private static final Set<String> active_set = new HashSet<String>();
    private final Object INSTANCE_LOCK = new Object();
    private final PluginInterface plugin_interface;
    private final MagnetPlugin plugin;
    private final byte[] hash;
    private final Set<String> networks;
    private final InetSocketAddress[] addresses;
    private final List<String> tags;
    private final Map<String, Object> initial_metadata;
    private final String args;
    final DownloadActivity activity;
    private volatile com.biglybt.core.download.DownloadManager core_dm;
    private volatile boolean started;
    private volatile boolean cancelled;
    private volatile boolean completed;
    private List<DiskManagerRequest> requests = new ArrayList<DiskManagerRequest>();
    private boolean run_complete;
    private AESemaphore complete_sem = new AESemaphore("MPMDD:comp");

    protected MagnetPluginMDDownloader(MagnetPlugin _plugin, PluginInterface _plugin_interface, byte[] _hash, Set<String> _networks, InetSocketAddress[] _addresses, List<String> _tags, Map<String, Object> _initial_metadata, String _args) {
        this.plugin = _plugin;
        this.plugin_interface = _plugin_interface;
        this.hash = _hash;
        this.networks = _networks;
        this.addresses = _addresses;
        this.tags = _tags;
        this.initial_metadata = _initial_metadata;
        this.args = _args;
        this.activity = new DownloadActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(final DownloadListener listener) {
        Object object = this.INSTANCE_LOCK;
        synchronized (object) {
            if (this.started) {
                listener.failed(false, new Exception("Already started"));
                return;
            }
            if (this.cancelled || this.completed) {
                listener.failed(false, new Exception("Already cancelled/completed"));
                return;
            }
            this.started = true;
            new AEThread2("MagnetPluginMDDownloader"){

                @Override
                public void run() {
                    MagnetPluginMDDownloader.this.activity.start(listener);
                }
            }.start();
        }
    }

    protected boolean cancel() {
        return this.activity.cancel(false);
    }

    protected com.biglybt.core.download.DownloadManager getDownloadManager() {
        return this.core_dm;
    }

    private class DownloadActivity {
        final int TIMER_PERIOD = 10000;
        final int PEER_CHECK_PERIOD = 30000;
        final int PEER_LOG_PERIOD = 10000;
        final int PEER_CHECK_TICKS = 3;
        final int PEER_LOG_TICKS = 1;
        final String hash_str;
        final Map<String, String> magnet_args;
        final String display_name;
        final List<String> trackers;
        File md_dir;
        File data_file;
        File torrent_file;
        DownloadManager download_manager;
        DownloadManagerListener download_manager_listener;
        Download download;
        final Set<String> peer_networks;
        final List<Map<String, Object>> peers_for_cache;
        final Throwable[] error;
        final boolean[] manually_removed;
        ByteArrayOutputStream result;
        TOTorrentAnnounceURLSet[] url_sets;
        DownloadListener activity_listener;
        boolean activity_listener_informed;
        TimerEventPeriodic timer;

        DownloadActivity() {
            this.hash_str = ByteFormatter.encodeString(MagnetPluginMDDownloader.this.hash);
            this.magnet_args = new HashMap<String, String>();
            this.trackers = new ArrayList<String>();
            this.md_dir = null;
            this.data_file = null;
            this.torrent_file = null;
            this.download_manager = MagnetPluginMDDownloader.this.plugin_interface.getDownloadManager();
            this.download_manager_listener = null;
            this.download = null;
            this.peer_networks = new HashSet<String>();
            this.peers_for_cache = new ArrayList<Map<String, Object>>();
            this.error = new Throwable[1];
            this.manually_removed = new boolean[1];
            this.result = new ByteArrayOutputStream(32768);
            this.url_sets = null;
            this.activity_listener_informed = false;
            String[] bits = MagnetPluginMDDownloader.this.args.split("&");
            String name = "magnet:" + Base32.encode(MagnetPluginMDDownloader.this.hash);
            String[] stringArray = bits;
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] x = bit.split("=");
                if (x.length == 2) {
                    String lhs = x[0].toLowerCase();
                    String rhs = UrlUtils.decode(x[1]);
                    this.magnet_args.put(lhs, rhs);
                    if (lhs.equals("tr")) {
                        String tracker = rhs;
                        this.trackers.add(tracker);
                    } else if (lhs.equals("dn")) {
                        name = rhs;
                    }
                }
                ++n2;
            }
            this.display_name = String.valueOf(MessageText.getString("MagnetPlugin.use.md.download.name", new String[]{name})) + ".torrent";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start(DownloadListener _listener) {
            this.activity_listener = _listener;
            boolean setup_started = false;
            boolean setup_complete = false;
            try {
                try {
                    Object object = ACTIVE_SET_LOCK;
                    synchronized (object) {
                        if (active_set.contains(this.hash_str)) {
                            throw new Exception("Download already active for hash " + this.hash_str);
                        }
                        active_set.add(this.hash_str);
                    }
                    object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                    synchronized (object) {
                        Download existing_download = this.download_manager.getDownload(MagnetPluginMDDownloader.this.hash);
                        if (existing_download != null) {
                            throw new Exception("download already exists");
                        }
                        setup_started = true;
                        File storage_dir = MagnetPluginMDDownloader.this.plugin.getStorageDir();
                        this.md_dir = FileUtil.newFile(storage_dir, this.hash_str);
                        if (!this.md_dir.exists()) {
                            this.md_dir.mkdirs();
                        }
                        this.data_file = FileUtil.newFile(this.md_dir, String.valueOf(this.hash_str) + ".torrent");
                        this.torrent_file = FileUtil.newFile(this.md_dir, String.valueOf(this.hash_str) + ".metatorrent");
                        int MD_TORRENT_SIZE = 0x4000000;
                        if (!this.data_file.exists() || this.data_file.length() != (long)MD_TORRENT_SIZE) {
                            try (RandomAccessFile raf = new RandomAccessFile(this.data_file, "rw");){
                                byte[] buffer = new byte[524288];
                                Arrays.fill(buffer, (byte)-1);
                                long i = 0L;
                                while (i < (long)MD_TORRENT_SIZE) {
                                    raf.write(buffer);
                                    i += (long)buffer.length;
                                }
                            }
                        }
                        URL announce_url = TorrentUtils.getDecentralisedURL(MagnetPluginMDDownloader.this.hash);
                        TOTorrent meta_torrent = null;
                        if (this.torrent_file.exists()) {
                            try {
                                meta_torrent = TOTorrentFactory.deserialiseFromBEncodedFile(this.torrent_file);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        if (meta_torrent == null) {
                            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(this.data_file, announce_url, 16384L);
                            meta_torrent = creator.create(true);
                        }
                        List<String> extras = MagnetPluginMDDownloader.this.plugin.getExtraTrackers();
                        for (String extra : extras) {
                            try {
                                if (this.trackers.contains(extra)) continue;
                                URL url = new URL(extra);
                                String net = AENetworkClassifier.categoriseAddress(url.getHost());
                                if (net == "Public") {
                                    if (!MagnetPluginMDDownloader.this.networks.isEmpty() && !MagnetPluginMDDownloader.this.networks.contains("Public")) continue;
                                    this.trackers.add(extra);
                                    continue;
                                }
                                if (!MagnetPluginMDDownloader.this.networks.contains(net)) continue;
                                this.trackers.add(extra);
                            }
                            catch (Throwable url) {
                                // empty catch block
                            }
                        }
                        if (this.trackers.size() > 0) {
                            this.trackers.add(0, announce_url.toExternalForm());
                            TOTorrentAnnounceURLGroup ag = meta_torrent.getAnnounceURLGroup();
                            ArrayList<TOTorrentAnnounceURLSet> sets = new ArrayList<TOTorrentAnnounceURLSet>();
                            for (String tracker : this.trackers) {
                                try {
                                    URL tracker_url = new URL(tracker);
                                    sets.add(ag.createAnnounceURLSet(new URL[]{tracker_url}));
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            if (sets.size() > 0) {
                                this.url_sets = sets.toArray(new TOTorrentAnnounceURLSet[sets.size()]);
                                ag.setAnnounceURLSets(this.url_sets);
                            }
                        }
                        meta_torrent.setHashOverride(MagnetPluginMDDownloader.this.hash);
                        TorrentUtils.setFlag(meta_torrent, 2, true);
                        TorrentUtils.setFlag(meta_torrent, 1, true);
                        HashMap<String, Object> debug_data = new HashMap<String, Object>();
                        debug_data.put("args", MagnetPluginMDDownloader.this.args);
                        if (MagnetPluginMDDownloader.this.initial_metadata != null) {
                            debug_data.put("im", MagnetPluginMDDownloader.this.initial_metadata);
                        }
                        meta_torrent.setAdditionalMapProperty("metadata_download_debug", debug_data);
                        meta_torrent.serialiseToBEncodedFile(this.torrent_file);
                        this.download_manager.clearNonPersistentDownloadState(MagnetPluginMDDownloader.this.hash);
                        this.download = this.download_manager.addNonPersistentDownloadStopped(PluginCoreUtils.wrap(meta_torrent), this.torrent_file, this.data_file);
                        MagnetPluginMDDownloader.this.core_dm = PluginCoreUtils.unwrap(this.download);
                        DownloadManagerState state = MagnetPluginMDDownloader.this.core_dm.getDownloadState();
                        if (!state.getFlag(512L)) {
                            FileUtil.log("magnetDownloder: " + ByteFormatter.encodeString(MagnetPluginMDDownloader.this.hash) + ": non-magnet download returned");
                            this.download = null;
                            MagnetPluginMDDownloader.this.core_dm = null;
                            throw new Exception("Non-magnet download already added");
                        }
                        TorrentUtils.setResumeDataTotallyIncomplete(state);
                        state.setDisplayName(this.display_name);
                        if (MagnetPluginMDDownloader.this.networks.size() == 0 || MagnetPluginMDDownloader.this.networks.size() == 1 && MagnetPluginMDDownloader.this.networks.contains("Public")) {
                            String[] stringArray = AENetworkClassifier.AT_NETWORKS;
                            int e = AENetworkClassifier.AT_NETWORKS.length;
                            int net = 0;
                            while (net < e) {
                                String network = stringArray[net];
                                state.setNetworkEnabled(network, true);
                                ++net;
                            }
                        } else {
                            for (String network : MagnetPluginMDDownloader.this.networks) {
                                state.setNetworkEnabled(network, true);
                            }
                            if (!MagnetPluginMDDownloader.this.networks.contains("Public")) {
                                state.setNetworkEnabled("Public", false);
                            }
                        }
                        if (!MagnetPluginMDDownloader.this.plugin.isNetworkEnabled("Public")) {
                            state.setNetworkEnabled("Public", false);
                        }
                        final ArrayList<InetSocketAddress> peers_to_inject = new ArrayList<InetSocketAddress>();
                        if (MagnetPluginMDDownloader.this.addresses != null && MagnetPluginMDDownloader.this.addresses.length > 0) {
                            String[] enabled_nets = state.getNetworks();
                            InetSocketAddress[] inetSocketAddressArray = MagnetPluginMDDownloader.this.addresses;
                            int n = inetSocketAddressArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                InetSocketAddress address = inetSocketAddressArray[n2];
                                String host = AddressUtils.getHostAddress(address);
                                String net = AENetworkClassifier.categoriseAddress(host);
                                String[] stringArray = enabled_nets;
                                int n3 = enabled_nets.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String n5 = stringArray[n4];
                                    if (n5 == net) {
                                        peers_to_inject.add(address);
                                        break;
                                    }
                                    ++n4;
                                }
                                ++n2;
                            }
                        }
                        state.addListener((d, a, t) -> MagnetPluginMDDownloader.this.plugin.setDNChanged(MagnetPluginMDDownloader.this.core_dm), "displayname", 1);
                        MagnetPluginMDDownloader.this.plugin.setInitialMetadata(MagnetPluginMDDownloader.this.core_dm, (List<String>)MagnetPluginMDDownloader.this.tags, (Map<String, Object>)MagnetPluginMDDownloader.this.initial_metadata);
                        this.download.addPeerListener(new DownloadPeerListener(){

                            @Override
                            public void peerManagerAdded(final Download download, final PeerManager peer_manager) {
                                if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed) {
                                    download.removePeerListener(this);
                                    return;
                                }
                                final PEPeerManager pm = PluginCoreUtils.unwrap(peer_manager);
                                peer_manager.addListener(new PeerManagerListener2(){
                                    private PeerManagerListener2 pm_listener = this;
                                    private int md_size;

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void eventOccurred(PeerManagerEvent event2) {
                                        if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed) {
                                            peer_manager.removeListener(this);
                                            return;
                                        }
                                        if (event2.getType() != 1) {
                                            return;
                                        }
                                        final Peer peer = event2.getPeer();
                                        try {
                                            String peer_ip = peer.getIp();
                                            String network = AENetworkClassifier.categoriseAddress(peer_ip);
                                            Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                            synchronized (object) {
                                                (this).DownloadActivity.this.peer_networks.add(network);
                                                HashMap<String, Object> map = new HashMap<String, Object>();
                                                (this).DownloadActivity.this.peers_for_cache.add(map);
                                                map.put("ip", peer_ip.getBytes("UTF-8"));
                                                map.put("port", new Long(peer.getPort()));
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                        peer.addListener(new PeerListener2(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void eventOccurred(PeerEvent event2) {
                                                if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed || md_size > 0) {
                                                    peer.removeListener(this);
                                                    return;
                                                }
                                                if (event2.getType() != 1) {
                                                    return;
                                                }
                                                if ((Integer)event2.getData() != 30) {
                                                    return;
                                                }
                                                Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                                synchronized (object) {
                                                    if (md_size > 0) {
                                                        return;
                                                    }
                                                    md_size = pm.getTorrentInfoDictSize();
                                                    if (md_size <= 0) {
                                                        return;
                                                    }
                                                    peer_manager.removeListener(pm_listener);
                                                }
                                                DownloadActivity.this.reportProgress(0, md_size);
                                                new AEThread2(""){

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     * Loose catch block
                                                     */
                                                    @Override
                                                    public void run() {
                                                        DiskManagerChannel channel2 = null;
                                                        try {
                                                            channel2 = download.getDiskManagerFileInfo()[0].createChannel();
                                                            final DiskManagerRequest request2 = channel2.createRequest();
                                                            request2.setType(1);
                                                            request2.setOffset(0L);
                                                            request2.setLength(md_size);
                                                            request2.setMaximumReadChunkSize(16384);
                                                            request2.addListener(new DiskManagerListener(){

                                                                /*
                                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                                 */
                                                                @Override
                                                                public void eventOccurred(DiskManagerEvent event2) {
                                                                    int type = event2.getType();
                                                                    if (type == 2) {
                                                                        ((((this).this).this).this).DownloadActivity.this.error[0] = event2.getFailure();
                                                                        DownloadActivity.this.runComplete();
                                                                    } else if (type == 1) {
                                                                        PooledByteBuffer buffer = null;
                                                                        try {
                                                                            try {
                                                                                int dl_size;
                                                                                buffer = event2.getBuffer();
                                                                                byte[] bytes = buffer.toByteArray();
                                                                                Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                                                                synchronized (object) {
                                                                                    ((((this).this).this).this).DownloadActivity.this.result.write(bytes);
                                                                                    dl_size = ((((this).this).this).this).DownloadActivity.this.result.size();
                                                                                    if (dl_size == md_size) {
                                                                                        MagnetPluginMDDownloader.this.completed = true;
                                                                                        DownloadActivity.this.reportProgress(md_size, md_size);
                                                                                        DownloadActivity.this.runComplete();
                                                                                    }
                                                                                }
                                                                                if (!MagnetPluginMDDownloader.this.completed) {
                                                                                    DownloadActivity.this.reportProgress(dl_size, md_size);
                                                                                }
                                                                            }
                                                                            catch (Throwable e) {
                                                                                ((((this).this).this).this).DownloadActivity.this.error[0] = e;
                                                                                request2.cancel();
                                                                                DownloadActivity.this.runComplete();
                                                                                if (buffer != null) {
                                                                                    buffer.returnToPool();
                                                                                }
                                                                            }
                                                                        }
                                                                        finally {
                                                                            if (buffer != null) {
                                                                                buffer.returnToPool();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                            Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                                            synchronized (object) {
                                                                block14: {
                                                                    if (!MagnetPluginMDDownloader.this.cancelled) break block14;
                                                                    return;
                                                                    {
                                                                        catch (Throwable throwable) {
                                                                            throw throwable;
                                                                        }
                                                                    }
                                                                }
                                                                try {
                                                                    MagnetPluginMDDownloader.this.requests.add(request2);
                                                                    // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 6] lbl20 : MonitorExitStatement: MONITOREXIT : var3_4
                                                                    request2.run();
                                                                    object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                                                    synchronized (object) {
                                                                        MagnetPluginMDDownloader.this.requests.remove(request2);
                                                                    }
                                                                }
                                                                catch (Throwable e) {
                                                                    (((this).this).this).DownloadActivity.this.error[0] = e;
                                                                    DownloadActivity.this.runComplete();
                                                                }
                                                            }
                                                        }
                                                        finally {
                                                            if (channel2 != null) {
                                                                channel2.destroy();
                                                            }
                                                        }
                                                        {
                                                            return;
                                                        }
                                                    }
                                                }.start();
                                            }
                                        });
                                    }
                                });
                            }

                            @Override
                            public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                            }
                        });
                        final Download f_download = this.download;
                        DownloadManagerListener dl_listener = new DownloadManagerListener(){
                            private TimerEventPeriodic timer_event;
                            private boolean removed;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void downloadAdded(final Download download) {
                                if (download == f_download) {
                                    Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                    synchronized (object) {
                                        if (!this.removed) {
                                            if (this.timer_event == null) {
                                                this.timer_event = SimpleTimer.addPeriodicEvent("announcer", 30000L, new TimerEventPerformer(){

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    @Override
                                                    public void perform(TimerEvent event2) {
                                                        Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                                        synchronized (object) {
                                                            if (removed) {
                                                                return;
                                                            }
                                                            if (MagnetPluginMDDownloader.this.run_complete) {
                                                                if (timer_event != null) {
                                                                    timer_event.cancel();
                                                                    timer_event = null;
                                                                }
                                                                return;
                                                            }
                                                        }
                                                        download.requestTrackerAnnounce(true);
                                                        this.injectPeers(download);
                                                    }
                                                });
                                            }
                                            if (peers_to_inject.size() > 0) {
                                                SimpleTimer.addEvent("injecter", SystemTime.getOffsetTime(5000L), new TimerEventPerformer(){

                                                    @Override
                                                    public void perform(TimerEvent event2) {
                                                        this.injectPeers(download);
                                                    }
                                                });
                                            }
                                        }
                                    }
                                }
                            }

                            private void injectPeers(Download download) {
                                PeerManager pm = download.getPeerManager();
                                if (pm != null) {
                                    for (InetSocketAddress address : peers_to_inject) {
                                        pm.addPeer(AddressUtils.getHostAddress(address), address.getPort());
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void downloadRemoved(Download dl) {
                                if (dl == f_download) {
                                    Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                                    synchronized (object) {
                                        this.removed = true;
                                        if (this.timer_event != null) {
                                            this.timer_event.cancel();
                                            this.timer_event = null;
                                        }
                                    }
                                    if (!MagnetPluginMDDownloader.this.cancelled && !MagnetPluginMDDownloader.this.completed) {
                                        DownloadActivity.this.error[0] = new Exception("Download manually removed");
                                        DownloadActivity.this.manually_removed[0] = true;
                                        DownloadActivity.this.runComplete();
                                    }
                                }
                            }
                        };
                        this.download_manager.addListener(dl_listener, true);
                        this.download_manager_listener = dl_listener;
                        Download[] existing = this.download_manager.getDownloads();
                        int move_to = 1;
                        Download[] downloadArray = existing;
                        int n = existing.length;
                        int n6 = 0;
                        while (n6 < n) {
                            Download e = downloadArray[n6];
                            if (e != this.download && e.isForceStart() && e.getFlag(512L)) {
                                move_to = Math.max(move_to, e.getPosition() + 1);
                            }
                            ++n6;
                        }
                        this.download.moveTo(move_to);
                        this.download.setForceStart(true);
                        this.download.setFlag(4L, true);
                        this.timer = SimpleTimer.addPeriodicEvent("mddownloader", 10000L, new TimerEventPerformer(){
                            int ticks = 0;

                            @Override
                            public void perform(TimerEvent event2) {
                                DownloadActivity.this.update(this.ticks++);
                            }
                        });
                        setup_complete = true;
                    }
                }
                catch (Throwable e) {
                    boolean was_cancelled = MagnetPluginMDDownloader.this.cancelled;
                    this.cancel(true);
                    if (!was_cancelled) {
                        this.reportFailed(this.manually_removed[0], e);
                        Debug.out(e);
                    }
                    if (setup_started && !setup_complete) {
                        this.tidyUp();
                    }
                }
            }
            finally {
                if (setup_started && !setup_complete) {
                    this.tidyUp();
                }
            }
        }

        void update(int tick_count) {
            boolean do_log = tick_count % 1 == 0;
            boolean check_dead = tick_count % 3 == 0;
            PeerManager pm = this.download.getPeerManager();
            if (pm != null && (do_log || check_dead)) {
                Peer[] peers = pm.getPeers();
                int connecting = 0;
                int connected = 0;
                try {
                    Peer[] peerArray = peers;
                    int n = peers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Peer peer = peerArray[n2];
                        PEPeer pe_peer = PluginCoreUtils.unwrap(peer);
                        if (pe_peer instanceof PEPeerTransport) {
                            PEPeerTransport pt = (PEPeerTransport)pe_peer;
                            long connected_at = pt.getConnectionEstablishedMonoTime();
                            if (connected_at >= 0L) {
                                long last_good_data;
                                long connected_for;
                                ++connected;
                                if (check_dead && (connected_for = SystemTime.getMonotonousTime() - connected_at) > 180000L && ((last_good_data = pt.getTimeSinceGoodDataReceived()) == -1L || last_good_data > 180000L)) {
                                    pt.getManager().removePeer(pt, "Metadata dead peer removal", 10);
                                }
                            } else {
                                ++connecting;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (do_log) {
                    this.activity_listener.reportProgress("Peers: connected=" + connected + ", connecting=" + connecting);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel(boolean internal) {
            boolean wait_for_complete = !internal;
            try {
                ArrayList to_cancel;
                Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                synchronized (object) {
                    block11: {
                        if (!MagnetPluginMDDownloader.this.started) {
                            Debug.out("Not started!");
                            wait_for_complete = false;
                        }
                        if (!MagnetPluginMDDownloader.this.cancelled && !MagnetPluginMDDownloader.this.completed) break block11;
                        boolean bl = MagnetPluginMDDownloader.this.cancelled;
                        return bl;
                    }
                    MagnetPluginMDDownloader.this.cancelled = true;
                    to_cancel = new ArrayList(MagnetPluginMDDownloader.this.requests);
                    MagnetPluginMDDownloader.this.requests.clear();
                }
                for (DiskManagerRequest request2 : to_cancel) {
                    request2.cancel();
                }
                return true;
            }
            finally {
                this.runComplete();
                if (wait_for_complete) {
                    MagnetPluginMDDownloader.this.complete_sem.reserve();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runComplete() {
            block29: {
                Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                synchronized (object) {
                    if (MagnetPluginMDDownloader.this.run_complete) {
                        return;
                    }
                    MagnetPluginMDDownloader.this.run_complete = true;
                }
                try {
                    try {
                        if (MagnetPluginMDDownloader.this.completed) {
                            String current_dn;
                            byte[] bytes = this.result.toByteArray();
                            this.result = null;
                            Map<String, Object> info = BDecoder.decode(bytes);
                            bytes = null;
                            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
                            map.put("info", info);
                            TOTorrent torrent = TOTorrentFactory.deserialiseFromMap(map);
                            byte[] torrent_hash = torrent.getHash();
                            if (!Arrays.equals(MagnetPluginMDDownloader.this.hash, torrent_hash)) {
                                byte[] truncated_v2_hash = torrent.getTruncatedHash(3);
                                boolean ok = false;
                                if (truncated_v2_hash != null) {
                                    ok = Arrays.equals(MagnetPluginMDDownloader.this.hash, truncated_v2_hash);
                                }
                                if (!ok) {
                                    throw new Exception("Metadata torrent hash mismatch: expected=" + ByteFormatter.encodeString(MagnetPluginMDDownloader.this.hash) + ", actual=" + ByteFormatter.encodeString(torrent_hash));
                                }
                            }
                            if (this.url_sets != null) {
                                ArrayList<TOTorrentAnnounceURLSet> updated = new ArrayList<TOTorrentAnnounceURLSet>();
                                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = this.url_sets;
                                int n = this.url_sets.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                                    if (!TorrentUtils.isDecentralised(set.getAnnounceURLs()[0])) {
                                        updated.add(set);
                                    }
                                    ++n2;
                                }
                                this.url_sets = updated.size() == 0 ? null : updated.toArray(new TOTorrentAnnounceURLSet[updated.size()]);
                            }
                            if (this.url_sets != null) {
                                torrent.setAnnounceURL(this.url_sets[0].getAnnounceURLs()[0]);
                                torrent.getAnnounceURLGroup().setAnnounceURLSets(this.url_sets);
                            } else {
                                torrent.setAnnounceURL(TorrentUtils.getDecentralisedURL(MagnetPluginMDDownloader.this.hash));
                            }
                            if (this.peers_for_cache.size() > 0) {
                                HashMap<String, List<Map<String, Object>>> peer_cache = new HashMap<String, List<Map<String, Object>>>();
                                peer_cache.put("tracker_peers", this.peers_for_cache);
                                TorrentUtils.setPeerCache(torrent, peer_cache);
                            }
                            if (!(current_dn = MagnetPluginMDDownloader.this.core_dm.getDownloadState().getDisplayName()).equals(this.display_name)) {
                                TorrentUtils.setDisplayName(torrent, current_dn);
                            }
                            try {
                                String pfi_str;
                                String dn;
                                if (MagnetPluginMDDownloader.this.plugin.getRenameDisplayName() && (dn = this.magnet_args.get("dn")) != null) {
                                    PlatformTorrentUtils.setContentTitle(torrent, dn);
                                }
                                if ((pfi_str = this.magnet_args.get("pfi")) != null) {
                                    PlatformTorrentUtils.setContentPrimaryFileIndex(torrent, Integer.parseInt(pfi_str));
                                }
                            }
                            catch (Throwable pfi_str) {
                                // empty catch block
                            }
                            TOTorrent[] t = new TOTorrent[]{torrent};
                            torrent = null;
                            this.reportComplete(t, this.peer_networks);
                            break block29;
                        }
                        if (MagnetPluginMDDownloader.this.cancelled) {
                            throw new Exception("Download cancelled");
                        }
                        this.cancel(true);
                        try {
                            if (this.error[0] != null) {
                                throw this.error[0];
                            }
                            throw new Exception("Download terminated prematurely");
                        }
                        catch (Throwable e) {
                            this.reportFailed(this.manually_removed[0], e);
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        boolean was_cancelled = MagnetPluginMDDownloader.this.cancelled;
                        this.cancel(true);
                        if (!was_cancelled) {
                            this.reportFailed(this.manually_removed[0], e);
                            Debug.out(e);
                        }
                        this.tidyUp();
                    }
                }
                finally {
                    this.tidyUp();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tidyUp() {
            block28: {
                try {
                    try {
                        ArrayList to_cancel;
                        Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
                        synchronized (object) {
                            if (this.download_manager_listener != null) {
                                this.download_manager.removeListener(this.download_manager_listener);
                            }
                            if (this.download != null) {
                                Category cat;
                                List<String> latest_tags = MagnetPluginMDDownloader.this.plugin.getInitialTags(MagnetPluginMDDownloader.this.core_dm);
                                if (!latest_tags.isEmpty()) {
                                    MagnetPluginMDDownloader.this.core_dm.setUserData(MagnetPlugin.DM_TAG_CACHE, latest_tags);
                                }
                                if ((cat = MagnetPluginMDDownloader.this.core_dm.getDownloadState().getCategory()) != null && cat.getType() == 0) {
                                    MagnetPluginMDDownloader.this.core_dm.setUserData(MagnetPlugin.DM_CATEGORY_CACHE, cat.getName());
                                }
                                try {
                                    this.download.stopAndRemove(false, false);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                this.download = null;
                            }
                            to_cancel = new ArrayList(MagnetPluginMDDownloader.this.requests);
                            MagnetPluginMDDownloader.this.requests.clear();
                            if (this.timer != null) {
                                this.timer.cancel();
                                this.timer = null;
                            }
                            if (this.torrent_file != null) {
                                this.torrent_file.delete();
                            }
                            if (this.data_file != null) {
                                this.data_file.delete();
                            }
                            if (this.md_dir != null) {
                                FileUtil.recursiveDeleteNoCheck(this.md_dir);
                            }
                        }
                        for (DiskManagerRequest request2 : to_cancel) {
                            request2.cancel();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        Object object = ACTIVE_SET_LOCK;
                        synchronized (object) {
                            active_set.remove(this.hash_str);
                        }
                        MagnetPluginMDDownloader.this.complete_sem.releaseForever();
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    Object object = ACTIVE_SET_LOCK;
                    synchronized (object) {
                        active_set.remove(this.hash_str);
                    }
                    MagnetPluginMDDownloader.this.complete_sem.releaseForever();
                    throw throwable;
                }
                Object object = ACTIVE_SET_LOCK;
                synchronized (object) {
                    active_set.remove(this.hash_str);
                }
                MagnetPluginMDDownloader.this.complete_sem.releaseForever();
            }
        }

        private void reportProgress(int downloaded, int total_size) {
            DownloadManagerState downloadState = MagnetPluginMDDownloader.this.core_dm.getDownloadState();
            if (downloaded == 0 && total_size > 0) {
                downloadState.setLongAttribute("magnet.torrent.size", total_size);
            }
            downloadState.setLongAttribute("magnet.torrent.downloaded", downloaded);
            this.activity_listener.reportProgress(downloaded, total_size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportFailed(boolean manual_cancel, Throwable e) {
            Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
            synchronized (object) {
                if (this.activity_listener_informed) {
                    return;
                }
                this.activity_listener_informed = true;
            }
            this.activity_listener.failed(manual_cancel, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportComplete(TOTorrent[] torrent, Set<String> peer_networks) {
            Object object = MagnetPluginMDDownloader.this.INSTANCE_LOCK;
            synchronized (object) {
                if (this.activity_listener_informed) {
                    return;
                }
                this.activity_listener_informed = true;
            }
            this.activity_listener.complete(torrent, peer_networks);
        }
    }

    protected static interface DownloadListener {
        public void reportProgress(String var1);

        public void reportProgress(int var1, int var2);

        public void complete(TOTorrent[] var1, Set<String> var2);

        public void failed(boolean var1, Throwable var2);
    }
}

