/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.util.protocol.azplug.AZPluginConnection;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.network.ConnectionManager;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterGroup;
import com.biglybt.pif.ui.config.ParameterTabFolder;
import com.biglybt.pif.ui.config.StringListParameter;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.LocaleListener;
import com.biglybt.pif.utils.LocaleUtilities;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginException;
import com.biglybt.plugin.net.buddy.BuddyPluginListener;
import com.biglybt.plugin.net.buddy.BuddyPluginNetwork;
import com.biglybt.plugin.net.buddy.BuddyPluginViewInterface;
import com.biglybt.plugin.net.buddy.PartialBuddy;
import com.biglybt.plugin.net.buddy.PartialBuddyListener;
import com.biglybt.plugin.net.buddy.tracker.BuddyPluginTracker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class BuddyPlugin
implements Plugin {
    public static final boolean SUPPORT_ONLINE_STATUS = true;
    public static final int TIMER_PERIOD = 5000;
    private static final int FEED_UPDATE_MIN_MILLIS = 21600000;
    public static final String VIEW_ID = "azbuddy";
    private static final boolean BETA_ENABLE_DEFAULT = true;
    private PluginInterface plugin_interface;
    public static final int STATUS_ONLINE = 0;
    public static final int STATUS_AWAY = 1;
    public static final int STATUS_NOT_AVAILABLE = 2;
    public static final int STATUS_BUSY = 3;
    public static final int STATUS_APPEAR_OFFLINE = 4;
    public static final String[] STATUS_VALUES = new String[]{"0", "1", "2", "3", "4"};
    public static final String[] STATUS_KEYS = new String[]{"os_online", "os_away", "os_not_avail", "os_busy", "os_offline"};
    public static final String[] STATUS_STRINGS = new String[STATUS_KEYS.length];
    private BooleanParameter classic_enabled_param;
    private StringParameter nick_name_public_param;
    private StringListParameter online_status_public_param;
    private StringParameter profile_public_param;
    private StringParameter nick_name_anon_param;
    private StringListParameter online_status_anon_param;
    private StringParameter profile_anon_param;
    private List<String> public_profile_list = new ArrayList<String>();
    private List<String> anon_profile_list = new ArrayList<String>();
    private BooleanParameter enable_chat_notifications;
    private StringParameter cat_pub;
    private BooleanParameter beta_enabled_param;
    private BuddyPluginTracker buddy_tracker;
    private TorrentAttribute ta_category;
    private LoggerChannel logger;
    private Set<String> public_tags_or_categories = new HashSet<String>();
    private boolean lan_local_peers;
    private boolean fp_enable;
    private BuddyPluginBeta beta_plugin;
    private BuddyPluginViewInterface swt_ui;
    private List<Runnable> swt_ui_waiters = new ArrayList<Runnable>();
    private CopyOnWriteList<BuddyPluginListener> listeners = new CopyOnWriteList();
    private CopyOnWriteList<PartialBuddyListener> pb_listeners = new CopyOnWriteList();
    private ParameterListener configEnabledListener;
    private AtomicBoolean initialization_complete = new AtomicBoolean(false);
    protected static final int INIT_UNKNOWN = 0;
    protected static final int INIT_OK = 1;
    protected static final int INIT_BAD = 2;
    private volatile int initialisation_state = 0;
    private RateLimiter inbound_limiter;
    private RateLimiter outbound_limiter;
    private BuddyPluginNetwork[] plugin_networks;

    public static boolean isBetaChatEnabled() {
        return COConfigurationManager.getBooleanParameter("Plugin.azbuddy.azbuddy.dchat.decentralized.enabled", true);
    }

    public static void load(PluginInterface plugin_interface) {
        String name = plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.azbuddy.title");
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", name);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.logger = this.plugin_interface.getLogger().getChannel("Friends");
        this.logger.setDiagnostic();
        this.plugin_networks = new BuddyPluginNetwork[]{new BuddyPluginNetwork(this.plugin_interface, this, "Public"), new BuddyPluginNetwork(this.plugin_interface, this, "I2P")};
        final LocaleUtilities lu = this.plugin_interface.getUtilities().getLocaleUtilities();
        Properties l10n_constants = new Properties();
        l10n_constants.put("azbuddy.classic.link.url", "https://wiki.biglybt.com/w/Friends");
        l10n_constants.put("azbuddy.dchat.link.url", "https://wiki.biglybt.com/w/Decentralized_Chat");
        l10n_constants.put("azbuddy.profile.info.url", "https://wiki.biglybt.com/w/Friends#public-profile");
        lu.integrateLocalisedMessageBundle(l10n_constants);
        lu.addListener(new LocaleListener(){

            @Override
            public void localeChanged(Locale l) {
                BuddyPlugin.this.updateLocale(lu);
            }
        });
        this.updateLocale(lu);
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.azbuddy.title");
        this.classic_enabled_param = config.addBooleanParameter2("azbuddy.enabled", "azbuddy.enabled", false);
        final ParameterTabFolder network_tab = config.createTabFolder();
        ParameterGroup network_anon_item = null;
        int i = 0;
        while (i < 2) {
            final boolean is_pub_tab = i == 0;
            String suffix = is_pub_tab ? "" : ".anon";
            final StringParameter nick_param = config.addStringParameter2("azbuddy.nickname" + suffix, "azbuddy.nickname", "");
            nick_param.setGenerateIntermediateEvents(false);
            nick_param.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    BuddyPlugin.this.updateNickName(is_pub_tab, nick_param.getValue());
                }
            });
            String[] os_values = STATUS_VALUES;
            String[] os_labels = STATUS_STRINGS;
            final StringListParameter os_param = config.addStringListParameter2("azbuddy.online_status" + suffix, "azbuddy.online_status", os_values, os_labels, os_values[0]);
            os_param.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    BuddyPlugin.this.updateOnlineStatus(is_pub_tab, Integer.parseInt(os_param.getValue()));
                }
            });
            os_param.setVisible(true);
            StringParameter profile_param = config.addStringParameter2("azbuddy.profile.info" + suffix, "", "");
            profile_param.setLabelText("<a href=\"" + MessageText.getString("azbuddy.profile.info.url") + "\">" + MessageText.getString("azbuddy.profile.info") + "</a>");
            profile_param.setMultiLine(5);
            profile_param.setGenerateIntermediateEvents(false);
            profile_param.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    BuddyPlugin.this.updateProfiles();
                }
            });
            ParameterGroup profile_group = config.createGroup(is_pub_tab ? "azbuddy.public.profile" : "azbuddy.anon.profile", profile_param);
            ParameterGroup network_item = config.createGroup(is_pub_tab ? "label.public" : "label.anon", nick_param, os_param, profile_group);
            if (is_pub_tab) {
                this.nick_name_public_param = nick_param;
                this.online_status_public_param = os_param;
                this.profile_public_param = profile_param;
            } else {
                this.nick_name_anon_param = nick_param;
                this.online_status_anon_param = os_param;
                this.profile_anon_param = profile_param;
                network_anon_item = network_item;
            }
            network_tab.addTab(network_item);
            ++i;
        }
        this.updateProfiles();
        final IntParameter protocol_speed = config.addIntParameter2("azbuddy.protocolspeed", "azbuddy.protocolspeed", 32);
        protocol_speed.setMinimumRequiredUserMode(2);
        ConnectionManager cman = this.plugin_interface.getConnectionManager();
        int inbound_limit = protocol_speed.getValue() * 1024;
        this.inbound_limiter = cman.createRateLimiter("buddy_up", inbound_limit);
        this.outbound_limiter = cman.createRateLimiter("buddy_down", 0);
        protocol_speed.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                BuddyPlugin.this.inbound_limiter.setRateLimitBytesPerSecond(protocol_speed.getValue() * 1024);
            }
        });
        this.enable_chat_notifications = config.addBooleanParameter2("azbuddy.enable_chat_notif", "azbuddy.enable_chat_notif", true);
        this.cat_pub = config.addStringParameter2("azbuddy.enable_cat_pub", "azbuddy.enable_cat_pub", "");
        this.cat_pub.setGenerateIntermediateEvents(false);
        this.setPublicTagsOrCategories(this.cat_pub.getValue(), false);
        final BooleanParameter tracker_enable = config.addBooleanParameter2("azbuddy.tracker.enabled", "azbuddy.tracker.enabled", true);
        final BooleanParameter tracker_so_enable = config.addBooleanParameter2("azbuddy.tracker.seeding.only.enabled", "azbuddy.tracker.seeding.only.enabled", false);
        tracker_so_enable.setLabelText(MessageText.getString("azbuddy.tracker.seeding.only.enabled").trim());
        tracker_so_enable.setIndent(1, true);
        final BooleanParameter buddies_lan_local = config.addBooleanParameter2("azbuddy.tracker.con.lan.local", "azbuddy.tracker.con.lan.local", true);
        buddies_lan_local.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                BuddyPlugin.this.lan_local_peers = buddies_lan_local.getValue();
            }
        });
        this.lan_local_peers = buddies_lan_local.getValue();
        final BooleanParameter buddies_fp_enable = config.addBooleanParameter2("azbuddy.tracker.fp.enable", "azbuddy.tracker.fp.enable", true);
        buddies_fp_enable.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                BuddyPlugin.this.fp_enable = buddies_fp_enable.getValue();
            }
        });
        this.fp_enable = buddies_fp_enable.getValue();
        this.cat_pub.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                BuddyPlugin.this.setPublicTagsOrCategories(BuddyPlugin.this.cat_pub.getValue(), false);
            }
        });
        config.createGroup("label.friends", this.classic_enabled_param, network_tab, protocol_speed, this.enable_chat_notifications, this.cat_pub, tracker_enable, tracker_so_enable, buddies_lan_local, buddies_fp_enable);
        this.beta_enabled_param = config.addBooleanParameter2("azbuddy.dchat.decentralized.enabled", "azbuddy.dchat.decentralized.enabled", true);
        config.createGroup("azbuddy.dchat.decentralized", this.beta_enabled_param);
        config.addLabelParameter2("azbuddy.dchat.more.settings");
        this.beta_plugin = new BuddyPluginBeta(this.plugin_interface, this, this.beta_enabled_param);
        String[] stringArray = TableManager.TABLE_MYTORRENTS_ALL;
        int network_item = TableManager.TABLE_MYTORRENTS_ALL.length;
        int profile_group = 0;
        while (profile_group < network_item) {
            String table_id = stringArray[profile_group];
            final TableContextMenuItem menu_item = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(table_id, "azbuddy.contextmenu");
            menu_item.setStyle(5);
            menu_item.setHeaderCategory("Social");
            MenuItemFillListener menu_fill_listener = new MenuItemFillListener(){

                @Override
                public void menuWillBeShown(MenuItem menu, Object _target) {
                    menu.removeAllChildItems();
                    if (!BuddyPlugin.this.isClassicEnabled() || !BuddyPlugin.this.isAvailable()) {
                        menu.setEnabled(false);
                        return;
                    }
                    final ArrayList<Torrent> torrents = new ArrayList<Torrent>();
                    if (_target instanceof TableRow) {
                        this.addDownload(torrents, (TableRow)_target);
                    } else {
                        TableRow[] rows;
                        TableRow[] tableRowArray = rows = (TableRow[])_target;
                        int n = rows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableRow row = tableRowArray[n2];
                            this.addDownload(torrents, row);
                            ++n2;
                        }
                    }
                    if (torrents.size() == 0) {
                        menu.setEnabled(false);
                    } else {
                        List<BuddyPluginBuddy> buddies = BuddyPlugin.this.getBuddies();
                        int i = 0;
                        while (i < buddies.size()) {
                            final BuddyPluginBuddy buddy = buddies.get(i);
                            boolean online = buddy.isOnline(true);
                            TableContextMenuItem item = BuddyPlugin.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(menu_item, "!" + buddy.getName() + (buddy.isPublicNetwork() ? "" : " (" + MessageText.getString("label.anon.medium") + ")") + (online ? "" : " - " + MessageText.getString("label.disconnected")) + "!");
                            item.addMultiListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    for (Torrent torrent : torrents) {
                                        buddy.getPluginNetwork().getAZ2Handler().sendAZ2Torrent(torrent, buddy);
                                    }
                                }
                            });
                            item.setEnabled(online);
                            ++i;
                        }
                        menu.setEnabled(true);
                    }
                }

                protected void addDownload(List<Torrent> torrents, TableRow row) {
                    Download download;
                    Object obj = row.getDataSource();
                    if (obj instanceof Download) {
                        download = (Download)obj;
                    } else {
                        DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                        try {
                            download = file.getDownload();
                        }
                        catch (DownloadException e) {
                            Debug.printStackTrace(e);
                            return;
                        }
                    }
                    Torrent torrent = download.getTorrent();
                    if (torrent != null && !TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                        torrents.add(torrent);
                    }
                }
            };
            menu_item.addFillListener(menu_fill_listener);
            ++profile_group;
        }
        this.buddy_tracker = new BuddyPluginTracker(this, tracker_enable, tracker_so_enable);
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType().equals("swt")) {
                    try {
                        List list = BuddyPlugin.this.swt_ui_waiters;
                        synchronized (list) {
                            BuddyPlugin.this.swt_ui = (BuddyPluginViewInterface)Class.forName("com.biglybt.ui.swt.plugin.net.buddy.swt.BuddyPluginView").getConstructor(BuddyPlugin.class, UIInstance.class).newInstance(BuddyPlugin.this, instance);
                            for (Runnable r : BuddyPlugin.this.swt_ui_waiters) {
                                try {
                                    r.run();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            BuddyPlugin.this.swt_ui_waiters.clear();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                BuddyPlugin.this.setupDisablePrompt(instance);
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (instance.getUIType().equals("swt") && BuddyPlugin.this.swt_ui != null) {
                    BuddyPlugin.this.swt_ui.destroy();
                    BuddyPlugin.this.swt_ui = null;
                }
            }
        });
        final ParameterGroup f_network_anon_item = network_anon_item;
        final com.biglybt.pif.ui.config.ParameterListener enabled_listener = new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                boolean classic_enabled = BuddyPlugin.this.classic_enabled_param.getValue();
                BuddyPlugin.this.nick_name_public_param.setEnabled(classic_enabled);
                BuddyPlugin.this.online_status_public_param.setEnabled(classic_enabled);
                BuddyPlugin.this.nick_name_anon_param.setEnabled(classic_enabled);
                BuddyPlugin.this.online_status_anon_param.setEnabled(classic_enabled);
                protocol_speed.setEnabled(classic_enabled);
                BuddyPlugin.this.enable_chat_notifications.setEnabled(classic_enabled);
                BuddyPlugin.this.cat_pub.setEnabled(classic_enabled);
                tracker_enable.setEnabled(classic_enabled);
                tracker_so_enable.setEnabled(classic_enabled && tracker_enable.getValue());
                buddies_lan_local.setEnabled(classic_enabled);
                buddies_fp_enable.setEnabled(classic_enabled);
                network_tab.setEnabled(classic_enabled);
                f_network_anon_item.setEnabled(classic_enabled && I2PHelpers.isI2PInstalled());
                if (param != null) {
                    BuddyPluginNetwork[] buddyPluginNetworkArray = BuddyPlugin.this.plugin_networks;
                    int n = buddyPluginNetworkArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
                        pn.setClassicEnabledInternal(classic_enabled);
                        ++n2;
                    }
                    BuddyPlugin.this.fireEnabledStateChanged();
                }
            }
        };
        this.classic_enabled_param.addListener(enabled_listener);
        this.beta_enabled_param.addListener(enabled_listener);
        tracker_enable.addListener(enabled_listener);
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin_networks;
        int n = this.plugin_networks.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            pn.loadConfig();
            pn.registerMessageHandler();
            ++n2;
        }
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                enabled_listener.parameterChanged(null);
                DelayedTask dt = BuddyPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                    @Override
                    public void run() {
                        new AEThread2("BuddyPlugin:init", true){

                            @Override
                            public void run() {
                                BuddyPlugin.this.startup();
                                BuddyPlugin.this.beta_plugin.startup();
                                BuddyPlugin.this.initialization_complete.set(true);
                            }
                        }.start();
                    }
                });
                dt.queue();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
        CoreFactory.getSingleton().addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public boolean syncInvokeRequired() {
                return true;
            }

            @Override
            public void stopping(Core core) {
                BuddyPluginNetwork[] buddyPluginNetworkArray = BuddyPlugin.this.plugin_networks;
                int n = buddyPluginNetworkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
                    pn.saveConfig(true);
                    pn.closedown();
                    ++n2;
                }
                BuddyPlugin.this.beta_plugin.closedown();
            }
        });
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    public BuddyPluginNetwork[] getPluginNetworks() {
        return this.plugin_networks;
    }

    protected int getInitialisationState() {
        return this.initialisation_state;
    }

    public boolean isInitializationComplete() {
        return this.initialization_complete.get();
    }

    public String getOnlineStatus(int status) {
        if (status >= STATUS_STRINGS.length || status < 0) {
            status = 0;
        }
        return STATUS_STRINGS[status];
    }

    public boolean isClassicEnabled() {
        if (this.classic_enabled_param == null) {
            return false;
        }
        return this.classic_enabled_param.getValue();
    }

    public boolean setClassicEnabled(boolean enabled, boolean auto) {
        if (this.classic_enabled_param == null) {
            return false;
        }
        if (enabled && auto && !this.classic_enabled_param.getValue()) {
            PluginConfig config = this.plugin_interface.getPluginconfig();
            if (config.getPluginBooleanParameter("classic.auto.enable.done", false)) {
                return false;
            }
            config.setPluginParameter("classic.auto.enable.done", true);
        }
        this.classic_enabled_param.setValue(enabled);
        return enabled;
    }

    public boolean isBetaEnabled() {
        if (this.beta_enabled_param == null) {
            return false;
        }
        return this.beta_enabled_param.getValue();
    }

    public BuddyPluginBeta getBeta() {
        return this.beta_plugin;
    }

    public BuddyPluginTracker getTracker() {
        return this.buddy_tracker;
    }

    public boolean getPeersAreLANLocal() {
        return this.lan_local_peers;
    }

    public boolean getFPEnabled() {
        return this.fp_enable;
    }

    public boolean isLoggerEnabled() {
        return this.logger.isEnabled();
    }

    protected void updateLocale(LocaleUtilities lu) {
        int i = 0;
        while (i < STATUS_STRINGS.length) {
            BuddyPlugin.STATUS_STRINGS[i] = lu.getLocalisedMessageText("azbuddy." + STATUS_KEYS[i]);
            ++i;
        }
        if (this.online_status_public_param != null) {
            this.online_status_public_param.setLabels(STATUS_STRINGS);
        }
        if (this.online_status_anon_param != null) {
            this.online_status_anon_param.setLabels(STATUS_STRINGS);
        }
    }

    protected void setupDisablePrompt(UIInstance ui) {
        if (this.plugin_interface == null || this.configEnabledListener != null) {
            return;
        }
        String enabledConfigID = "PluginInfo." + this.plugin_interface.getPluginID() + ".enabled";
        this.configEnabledListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                BuddyPlugin.this.fireEnabledStateChanged();
            }
        };
        COConfigurationManager.addParameterListener(enabledConfigID, this.configEnabledListener);
    }

    public String getNickname(boolean public_network) {
        return (public_network ? this.nick_name_public_param : this.nick_name_anon_param).getValue();
    }

    public void setNickname(boolean public_network, String str) {
        if (public_network) {
            this.nick_name_public_param.setValue(str);
        } else {
            this.nick_name_anon_param.setValue(str);
        }
    }

    public int getOnlineStatus(boolean public_network) {
        return Integer.parseInt((public_network ? this.online_status_public_param : this.online_status_anon_param).getValue());
    }

    public void setOnlineStatus(boolean public_network, int status) {
        if (public_network) {
            this.online_status_public_param.setValue("" + status);
        } else {
            this.online_status_anon_param.setValue("" + status);
        }
    }

    public void showConfig() {
        this.plugin_interface.getUIManager().showConfigSection("Views.plugins.azbuddy.title");
    }

    protected void fireEnabledStateChanged() {
        boolean classic_enabled = !this.plugin_interface.getPluginState().isDisabled() && this.isClassicEnabled();
        boolean beta_enabled = !this.plugin_interface.getPluginState().isDisabled() && this.isBetaEnabled();
        List<BuddyPluginListener> listeners_ref = this.listeners.getList();
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                listeners_ref.get(i).enabledStateChanged(classic_enabled, beta_enabled);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void fireUpdated() {
        for (BuddyPluginListener listener : this.listeners) {
            try {
                listener.updated();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public BuddyPluginViewInterface getSWTUI() {
        return this.swt_ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSWTUIWaiter(Runnable r) {
        List<Runnable> list = this.swt_ui_waiters;
        synchronized (list) {
            if (this.swt_ui != null) {
                r.run();
            } else {
                this.swt_ui_waiters.add(r);
            }
        }
    }

    protected void addRateLimiters(GenericMessageConnection connection) {
        connection.addInboundRateLimiter(this.inbound_limiter);
        connection.addOutboundRateLimiter(this.outbound_limiter);
    }

    public List<PartialBuddy> getPartialBuddies() {
        return this.buddy_tracker.getPartialBuddies();
    }

    public boolean isAvailable() {
        try {
            this.checkAvailable();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected void checkAvailable() throws BuddyPluginException {
        if (this.initialisation_state == 0) {
            throw new BuddyPluginException("Plugin not yet initialised");
        }
        if (this.initialisation_state == 2) {
            throw new BuddyPluginException("Plugin unavailable");
        }
    }

    public void addListener(BuddyPluginListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
        if (this.initialisation_state != 0) {
            listener.initialised(this.initialisation_state == 1);
        }
    }

    public void removeListener(BuddyPluginListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAdded(BuddyPluginBuddy buddy) {
        if (buddy.isAuthorised()) {
            buddy.setLocalAuthorisedRSSTagsOrCategories(this.public_tags_or_categories);
            for (BuddyPluginListener l : this.listeners) {
                try {
                    l.buddyAdded(buddy);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void fireRemoved(BuddyPluginBuddy buddy) {
        if (buddy.isAuthorised()) {
            for (BuddyPluginListener l : this.listeners) {
                try {
                    l.buddyRemoved(buddy);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void fireDetailsChanged(BuddyPluginBuddy buddy) {
        if (buddy.isAuthorised()) {
            for (BuddyPluginListener l : this.listeners) {
                try {
                    l.buddyChanged(buddy);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public boolean isFullBuddy(Peer peer) {
        BuddyPluginTracker tracker = this.getTracker();
        return tracker.isFullBuddy(peer);
    }

    public boolean isPartialBuddy(Download download, Peer peer) {
        BuddyPluginTracker tracker = this.getTracker();
        return tracker.isPartialBuddy(download, peer);
    }

    public void setPartialBuddy(Download download, Peer peer, boolean is_partial, boolean manual) {
        if (is_partial && !this.isClassicEnabled()) {
            this.setClassicEnabled(true, true);
        }
        BuddyPluginTracker tracker = this.getTracker();
        if (is_partial) {
            tracker.addPartialBuddy(download, peer, manual);
        } else {
            tracker.removePartialBuddy(download, peer, manual);
        }
    }

    public BooleanParameter getEnableChatNotificationsParameter() {
        return this.enable_chat_notifications;
    }

    private void updateProfiles() {
        this.public_profile_list = this.updateProfileSupport(this.profile_public_param);
        this.anon_profile_list = this.updateProfileSupport(this.profile_anon_param);
    }

    private List<String> updateProfileSupport(StringParameter param) {
        String[] lines;
        String str = param.getValue();
        ArrayList<String> profile = new ArrayList<String>();
        String[] stringArray = lines = str.split("\\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] bits;
            String line = stringArray[n2];
            if (!(line = line.trim()).isEmpty() && (bits = line.split("=", 2)).length == 2) {
                profile.add(String.valueOf(bits[0].trim()) + "=" + bits[1].trim());
            }
            ++n2;
        }
        return profile;
    }

    protected static String normaliseCat(String str) {
        if (str == null) {
            return null;
        }
        if (str.toLowerCase().equals("all")) {
            return "All";
        }
        return str;
    }

    protected static void normaliseCats(Set<String> cats) {
        if (cats != null) {
            boolean all_found = false;
            Iterator<String> it = cats.iterator();
            while (it.hasNext()) {
                if (!it.next().toLowerCase().equals("all")) continue;
                it.remove();
                all_found = true;
            }
            if (all_found) {
                cats.add("All");
            }
        }
    }

    public boolean isPublicTagOrCategory(String cat) {
        cat = BuddyPlugin.normaliseCat(cat);
        return this.public_tags_or_categories.contains(cat);
    }

    public void addPublicTagOrCategory(String cat) {
        HashSet<String> new_cats = new HashSet<String>(this.public_tags_or_categories);
        if (new_cats.add(cat = BuddyPlugin.normaliseCat(cat))) {
            this.setPublicTagsOrCategories(new_cats, true);
        }
    }

    public void removePublicTagOrCategory(String cat) {
        HashSet<String> new_cats = new HashSet<String>(this.public_tags_or_categories);
        if (new_cats.remove(cat = BuddyPlugin.normaliseCat(cat))) {
            this.setPublicTagsOrCategories(new_cats, true);
        }
    }

    protected void setPublicTagsOrCategories(String str, boolean persist) {
        String[] bits;
        HashSet<String> new_pub_cats = new HashSet<String>();
        String[] stringArray = bits = str.split(",");
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            s = s.trim();
            if (bits.length > 0) {
                new_pub_cats.add(BuddyPlugin.normaliseCat(s));
            }
            ++n2;
        }
        this.setPublicTagsOrCategories(new_pub_cats, persist);
    }

    protected void setPublicTagsOrCategories(Set<String> new_pub_tags_or_cats, boolean persist) {
        if (!this.public_tags_or_categories.equals(new_pub_tags_or_cats)) {
            HashSet<String> removed = new HashSet<String>(this.public_tags_or_categories);
            removed.removeAll(new_pub_tags_or_cats);
            this.public_tags_or_categories = new_pub_tags_or_cats;
            if (persist) {
                String cat_str = "";
                for (String s : this.public_tags_or_categories) {
                    cat_str = String.valueOf(cat_str) + (cat_str.length() == 0 ? "" : ",") + s;
                }
                this.cat_pub.setValue(cat_str);
            }
            List<BuddyPluginBuddy> buds = this.getBuddies();
            for (BuddyPluginBuddy b : buds) {
                Set<String> local = b.getLocalAuthorisedRSSTagsOrCategories();
                if (local == null && new_pub_tags_or_cats.size() <= 0) continue;
                local = local == null ? new HashSet<String>() : new HashSet<String>(local);
                local.addAll(new_pub_tags_or_cats);
                local.removeAll(removed);
                b.setLocalAuthorisedRSSTagsOrCategories(local);
            }
        }
    }

    public void addPartialBuddyListener(PartialBuddyListener l) {
        this.pb_listeners.add(l);
    }

    public void removePartialBuddyListener(PartialBuddyListener l) {
        this.pb_listeners.remove(l);
    }

    public void partialBuddyAdded(PartialBuddy pb) {
        for (PartialBuddyListener l : this.pb_listeners) {
            try {
                l.partialBuddyAdded(pb);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void partialBuddyChanged(PartialBuddy pb) {
        for (PartialBuddyListener l : this.pb_listeners) {
            try {
                l.partialBuddyChanged(pb);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void partialBuddyRemoved(PartialBuddy pb) {
        for (PartialBuddyListener l : this.pb_listeners) {
            try {
                l.partialBuddyRemoved(pb);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public InputStream handleURLProtocol(AZPluginConnection connection, String arg_str) throws IPCException {
        if (arg_str.toLowerCase(Locale.US).startsWith("chat:")) {
            if (!this.beta_enabled_param.getValue()) {
                throw new IPCException("Decentralized chat not enabled");
            }
            try {
                InputStream result = this.beta_plugin.handleURI(arg_str, false);
                if (result != null) {
                    return result;
                }
                return new ByteArrayInputStream(VuzeFileHandler.getSingleton().create().exportToBytes());
            }
            catch (Throwable e) {
                throw new IPCException(e);
            }
        }
        String[] args = arg_str.split("&");
        String pk = null;
        String category_or_tag = "All";
        byte[] hash = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] bits = arg.split("=");
            String lhs = bits[0];
            String rhs = UrlUtils.decode(bits[1]);
            if (lhs.equals("pk")) {
                pk = rhs;
            } else if (lhs.equals("cat")) {
                category_or_tag = rhs;
            } else if (lhs.equals("hash")) {
                hash = Base32.decode(rhs);
            }
            ++n2;
        }
        if (pk == null) {
            throw new IPCException("Public key missing from '" + arg_str + "'");
        }
        BuddyPluginBuddy buddy = this.getBuddyFromPublicKey(pk);
        if (buddy == null) {
            throw new IPCException("Buddy with public key '" + pk + "' not found");
        }
        if (hash == null) {
            return buddy.getPluginNetwork().handleUPRSS(connection, buddy, category_or_tag);
        }
        return buddy.getPluginNetwork().handleUPTorrent(connection, buddy, category_or_tag, hash);
    }

    protected long getAddedTime(Download download) {
        DownloadManager core_download = PluginCoreUtils.unwrap(download);
        return core_download.getDownloadState().getLongParameter("stats.download.added.time");
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    public FeedDetails getRSS(BuddyPluginBuddy buddy, String tag_or_category, String if_mod) throws BuddyPluginException {
        if (!buddy.isLocalRSSTagOrCategoryAuthorised(tag_or_category)) {
            throw new BuddyPluginException("Unauthorised tag/category '" + tag_or_category + "'");
        }
        buddy.localRSSTagOrCategoryRead(tag_or_category);
        Download[] downloads = this.plugin_interface.getDownloadManager().getDownloads();
        ArrayList<Download> selected_dls = new ArrayList<Download>();
        long fingerprint = 0L;
        int i = 0;
        while (i < downloads.length) {
            Download download = downloads[i];
            Torrent torrent = download.getTorrent();
            if (torrent != null) {
                boolean match = tag_or_category.equalsIgnoreCase("all");
                if (!match) {
                    String dl_cat = download.getAttribute(this.ta_category);
                    boolean bl = match = dl_cat != null && dl_cat.equals(tag_or_category);
                }
                if (!match) {
                    try {
                        List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)PluginCoreUtils.unwrap(download));
                        for (Tag tag : tags) {
                            if (!tag.getTagName(true).equals(tag_or_category)) continue;
                            match = true;
                            break;
                        }
                    }
                    catch (Throwable tags) {
                        // empty catch block
                    }
                }
                if (match && !TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                    selected_dls.add(download);
                    byte[] hash = torrent.getHash();
                    int num = hash[0] << 24 & 0xFF000000 | hash[1] << 16 & 0xFF0000 | hash[2] << 8 & 0xFF00 | hash[3] & 0xFF;
                    fingerprint += (long)num;
                }
            }
            ++i;
        }
        PluginConfig pc = this.plugin_interface.getPluginconfig();
        String feed_finger_key = "feed_finger.category." + tag_or_category;
        String feed_date_key = "feed_date.category." + tag_or_category;
        long existing_fingerprint = pc.getPluginLongParameter(feed_finger_key, 0L);
        long feed_date = pc.getPluginLongParameter(feed_date_key, 0L);
        long now = SystemTime.getCurrentTime();
        if (existing_fingerprint == fingerprint) {
            if (selected_dls.size() > 0 && (now < feed_date || now - feed_date > 21600000L)) {
                feed_date = now;
                pc.setPluginParameter(feed_date_key, feed_date);
            }
        } else {
            pc.setPluginParameter(feed_finger_key, fingerprint);
            feed_date = now <= feed_date ? ++feed_date : now;
            pc.setPluginParameter(feed_date_key, feed_date);
        }
        String last_modified = TimeFormatter.getHTTPDate(feed_date);
        if (if_mod != null && if_mod.equals(last_modified)) {
            return new FeedDetails(new byte[0], last_modified);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
            pw.println("<channel>");
            pw.println("<title>" + this.escape(tag_or_category) + "</title>");
            Collections.sort(selected_dls, new Comparator<Download>(){

                @Override
                public int compare(Download d1, Download d2) {
                    long added1 = BuddyPlugin.this.getAddedTime(d1) / 1000L;
                    long added2 = BuddyPlugin.this.getAddedTime(d2) / 1000L;
                    return (int)(added2 - added1);
                }
            });
            pw.println("<pubDate>" + last_modified + "</pubDate>");
            int i2 = 0;
            while (i2 < selected_dls.size()) {
                Download download = (Download)selected_dls.get(i2);
                DownloadManager core_download = PluginCoreUtils.unwrap(download);
                Torrent torrent = download.getTorrent();
                String hash_str = Base32.encode(torrent.getHash());
                pw.println("<item>");
                pw.println("<title>" + this.escape(download.getName()) + "</title>");
                pw.println("<guid>" + hash_str + "</guid>");
                long added = core_download.getDownloadState().getLongParameter("stats.download.added.time");
                pw.println("<pubDate>" + TimeFormatter.getHTTPDate(added) + "</pubDate>");
                pw.println("<vuze:size>" + torrent.getSize() + "</vuze:size>");
                pw.println("<vuze:assethash>" + hash_str + "</vuze:assethash>");
                String url = "azplug:?id=azbuddy&name=Friends&arg=";
                String arg = "pk=" + buddy.getPluginNetwork().getPublicKey() + "&cat=" + tag_or_category + "&hash=" + Base32.encode(torrent.getHash());
                url = String.valueOf(url) + URLEncoder.encode(arg, "UTF-8");
                pw.println("<vuze:downloadurl>" + this.escape(url) + "</vuze:downloadurl>");
                DownloadScrapeResult scrape = download.getLastScrapeResult();
                if (scrape != null && scrape.getResponseType() == 1) {
                    pw.println("<vuze:seeds>" + scrape.getSeedCount() + "</vuze:seeds>");
                    pw.println("<vuze:peers>" + scrape.getNonSeedCount() + "</vuze:peers>");
                }
                pw.println("</item>");
                ++i2;
            }
            pw.println("</channel>");
            pw.println("</rss>");
            pw.flush();
            return new FeedDetails(os.toByteArray(), last_modified);
        }
        catch (IOException e) {
            throw new BuddyPluginException("", e);
        }
    }

    public byte[] getRSSTorrent(BuddyPluginBuddy buddy, String category, byte[] hash) throws BuddyPluginException {
        if (!buddy.isLocalRSSTagOrCategoryAuthorised(category)) {
            throw new BuddyPluginException("Unauthorised category '" + category + "'");
        }
        try {
            Torrent torrent;
            Download download = this.plugin_interface.getDownloadManager().getDownload(hash);
            if (download != null && (torrent = download.getTorrent()) != null) {
                String dl_cat = download.getAttribute(this.ta_category);
                if ((category.equalsIgnoreCase("all") || dl_cat != null && dl_cat.equals(category)) && !TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                    torrent = torrent.removeAdditionalProperties();
                    return torrent.writeToBEncodedData();
                }
            }
        }
        catch (Throwable e) {
            throw new BuddyPluginException("getTorrent failed", e);
        }
        throw new BuddyPluginException("Not found");
    }

    public void createChat(BuddyPluginBuddy[] buddies) {
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin_networks;
        int n = this.plugin_networks.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            ArrayList<BuddyPluginBuddy> hits = new ArrayList<BuddyPluginBuddy>();
            BuddyPluginBuddy[] buddyPluginBuddyArray = buddies;
            int n3 = buddies.length;
            int n4 = 0;
            while (n4 < n3) {
                BuddyPluginBuddy buddy = buddyPluginBuddyArray[n4];
                if (buddy.getPluginNetwork() == pn) {
                    hits.add(buddy);
                }
                ++n4;
            }
            if (!hits.isEmpty()) {
                pn.getAZ2Handler().createChat(hits.toArray(new BuddyPluginBuddy[0]));
            }
            ++n2;
        }
    }

    private BuddyPluginNetwork getPluginNetwork(boolean pub) {
        String target = pub ? "Public" : "I2P";
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin_networks;
        int n = this.plugin_networks.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork net = buddyPluginNetworkArray[n2];
            if (net.getTargetNetwork() == target) {
                return net;
            }
            ++n2;
        }
        return null;
    }

    private void startup() {
        boolean ok;
        ArrayList<BuddyPluginNetwork> pn_ok = new ArrayList<BuddyPluginNetwork>();
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin_networks;
        int n = this.plugin_networks.length;
        int n2 = 0;
        while (n2 < n) {
            boolean enabled;
            int status;
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            boolean is_pub = pn.isPublicNetwork();
            String nick = this.getNickname(is_pub);
            if (pn.startup(nick, status = this.getOnlineStatus(is_pub), enabled = this.classic_enabled_param.getValue())) {
                pn_ok.add(pn);
            }
            ++n2;
        }
        if (pn_ok.size() != this.plugin_networks.length) {
            this.plugin_networks = pn_ok.toArray(new BuddyPluginNetwork[0]);
        }
        boolean bl = ok = !pn_ok.isEmpty();
        if (ok) {
            this.initialisation_state = 1;
            BuddyPluginNetwork[] buddyPluginNetworkArray2 = this.plugin_networks;
            int n3 = this.plugin_networks.length;
            n = 0;
            while (n < n3) {
                BuddyPluginNetwork pn = buddyPluginNetworkArray2[n];
                pn.persistentDispatchInit();
                pn.reconnect();
                ++n;
            }
            this.buddy_tracker.initialise();
            this.plugin_interface.getUtilities().createTimer("Buddy checker").addPeriodicEvent(5000L, new UTTimerEventPerformer(){
                int tick_count;

                @Override
                public void perform(UTTimerEvent event2) {
                    ++this.tick_count;
                    if (!BuddyPlugin.this.isClassicEnabled()) {
                        return;
                    }
                    BuddyPlugin.this.buddy_tracker.tick(this.tick_count);
                }
            });
        } else {
            this.initialisation_state = 2;
        }
        List<BuddyPluginListener> listeners_ref = this.listeners.getList();
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                listeners_ref.get(i).initialised(ok);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    private void updateNickName(boolean public_network, String nick) {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            net.updateNickName(nick);
        }
    }

    private void updateOnlineStatus(boolean public_network, int status) {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            net.updateOnlineStatus(status);
        }
    }

    public String getPublicKey(boolean public_network) {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            return net.getPublicKey();
        }
        return null;
    }

    public List<String> getProfileInfo(boolean public_network) {
        if (public_network) {
            return this.public_profile_list;
        }
        return this.anon_profile_list;
    }

    public byte[] sign(boolean public_network, byte[] payload) throws BuddyPluginException {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            return net.sign(payload);
        }
        throw new BuddyPluginException("Invalid net");
    }

    public boolean verify(boolean public_network, String pk, byte[] payload, byte[] signature) throws BuddyPluginException {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            return net.verify(pk, payload, signature);
        }
        throw new BuddyPluginException("Invalid net");
    }

    public boolean verifyPublicKey(boolean public_network, String key) {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            return net.verifyPublicKey(key);
        }
        return false;
    }

    public BuddyPluginBuddy addBuddy(boolean public_network, String key, int subsystem) {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            return net.addBuddy(key, subsystem);
        }
        return null;
    }

    public BuddyPluginBuddy peekBuddy(boolean public_network, String key) {
        BuddyPluginNetwork net = this.getPluginNetwork(public_network);
        if (net != null) {
            return net.peekBuddy(key);
        }
        return null;
    }

    public List<BuddyPluginBuddy> getBuddies() {
        if (this.plugin_networks.length == 1) {
            return this.plugin_networks[0].getBuddies();
        }
        ArrayList<BuddyPluginBuddy> result = new ArrayList<BuddyPluginBuddy>();
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin_networks;
        int n = this.plugin_networks.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            result.addAll(pn.getBuddies());
            ++n2;
        }
        return result;
    }

    public BuddyPluginBuddy getBuddyFromPublicKey(String key) {
        BuddyPluginNetwork[] buddyPluginNetworkArray = this.plugin_networks;
        int n = this.plugin_networks.length;
        int n2 = 0;
        while (n2 < n) {
            BuddyPluginNetwork pn = buddyPluginNetworkArray[n2];
            BuddyPluginBuddy buddy = pn.getBuddyFromPublicKey(key);
            if (buddy != null) {
                return buddy;
            }
            ++n2;
        }
        return null;
    }

    public void logMessage(BuddyPluginBuddy buddy, String str, Throwable e) {
        this.logMessage(buddy, String.valueOf(str) + ": " + Debug.getNestedExceptionMessage(e), true);
    }

    public void logMessage(BuddyPluginBuddy buddy, String str) {
        this.logMessage(buddy, str, false);
    }

    public void logMessage(BuddyPluginBuddy buddy, String str, boolean is_error) {
        if (buddy != null && (buddy.isTransient() || !buddy.isAuthorised())) {
            return;
        }
        this.log(buddy, str);
        Iterator<BuddyPluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().messageLogged(str, is_error);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void log(BuddyPluginBuddy buddy, String str) {
        if (buddy != null && (buddy.isTransient() || !buddy.isAuthorised())) {
            return;
        }
        this.logger.log(str);
    }

    public void log(BuddyPluginBuddy buddy, String str, Throwable e) {
        if (buddy != null && (buddy.isTransient() || !buddy.isAuthorised())) {
            return;
        }
        this.logger.log(String.valueOf(str) + ": " + Debug.getNestedExceptionMessageAndStack(e));
    }

    public static interface CryptoResult {
        public byte[] getChallenge();

        public byte[] getPayload();
    }

    protected static class FeedDetails {
        private byte[] contents;
        private String last_modified;

        protected FeedDetails(byte[] _contents, String _last_modified) {
            this.contents = _contents;
            this.last_modified = _last_modified;
        }

        protected byte[] getContent() {
            return this.contents;
        }

        protected String getLastModified() {
            return this.last_modified;
        }
    }
}

