/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2ChatListener;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2Listener;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2TrackerListener;
import com.biglybt.plugin.net.buddy.BuddyPluginAdapter;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddyReplyListener;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddyRequestListener;
import com.biglybt.plugin.net.buddy.BuddyPluginException;
import com.biglybt.plugin.net.buddy.BuddyPluginNetwork;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BuddyPluginAZ2 {
    public static final int RT_AZ2_REQUEST_MESSAGE = 1;
    public static final int RT_AZ2_REPLY_MESSAGE = 2;
    public static final int RT_AZ2_REQUEST_SEND_TORRENT = 3;
    public static final int RT_AZ2_REPLY_SEND_TORRENT = 4;
    public static final int RT_AZ2_REQUEST_CHAT = 5;
    public static final int RT_AZ2_REPLY_CHAT = 6;
    public static final int RT_AZ2_REQUEST_TRACK = 7;
    public static final int RT_AZ2_REPLY_TRACK = 8;
    public static final int RT_AZ2_REQUEST_RSS = 9;
    public static final int RT_AZ2_REPLY_RSS = 10;
    public static final int RT_AZ2_REQUEST_PROFILE_INFO = 11;
    public static final int RT_AZ2_REPLY_PROFILE_INFO = 12;
    public static final int CHAT_MSG_TYPE_TEXT = 1;
    public static final int CHAT_MSG_TYPE_PARTICIPANTS_ADDED = 2;
    public static final int CHAT_MSG_TYPE_PARTICIPANTS_REMOVED = 3;
    private static final int SEND_TIMEOUT = 120000;
    private BuddyPluginNetwork plugin_network;
    private Map chats = new HashMap();
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private CopyOnWriteList track_listeners = new CopyOnWriteList();

    protected BuddyPluginAZ2(BuddyPluginNetwork _plugin_network) {
        this.plugin_network = _plugin_network;
        this.plugin_network.addRequestListener(new BuddyPluginBuddyRequestListener(){

            @Override
            public Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map request2) throws BuddyPluginException {
                if (subsystem == 1) {
                    int type;
                    if (!from_buddy.isAuthorised() && (type = ((Long)request2.get("type")).intValue()) != 11) {
                        throw new BuddyPluginException("Unauthorised");
                    }
                    return BuddyPluginAZ2.this.processAZ2Request(from_buddy, request2);
                }
                return null;
            }

            @Override
            public void pendingMessages(BuddyPluginBuddy[] from_buddies) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processAZ2Request(final BuddyPluginBuddy from_buddy, Map request2) throws BuddyPluginException {
        this.logMessage(from_buddy, "AZ2 request received: " + from_buddy.getString() + " -> " + request2);
        int type = ((Long)request2.get("type")).intValue();
        HashMap<String, Object> reply = new HashMap<String, Object>();
        if (type == 1) {
            try {
                String msg = new String((byte[])request2.get("msg"), "UTF8");
                from_buddy.setLastMessageReceived(msg);
            }
            catch (Throwable msg) {
                // empty catch block
            }
            reply.put("type", new Long(2L));
        } else {
            if (type == 3) {
                try {
                    final Torrent torrent = this.plugin_network.getPluginInterface().getTorrentManager().createFromBEncodedData((byte[])request2.get("torrent"));
                    new AEThread2("torrentAdder", true){

                        @Override
                        public void run() {
                            PluginInterface pi = BuddyPluginAZ2.this.plugin_network.getPluginInterface();
                            String msg = pi.getUtilities().getLocaleUtilities().getLocalisedMessageText("azbuddy.addtorrent.msg", new String[]{from_buddy.getName(), torrent.getName()});
                            long res = pi.getUIManager().showMessageBox("azbuddy.addtorrent.title", "!" + msg + "!", 12L);
                            if (res == 4L) {
                                pi.getUIManager().openTorrent(torrent);
                            }
                        }
                    }.start();
                    reply.put("type", new Long(4L));
                }
                catch (Throwable e) {
                    throw new BuddyPluginException("Torrent receive failed " + type);
                }
            }
            if (type == 5) {
                chatInstance chat;
                Map msg = (Map)request2.get("msg");
                String id = new String((byte[])msg.get("id"));
                int chat_msg_type = ((Long)msg.get("type")).intValue();
                boolean dont_create_chat = chat_msg_type == 3;
                boolean new_chat = false;
                Map map = this.chats;
                synchronized (map) {
                    chat = (chatInstance)this.chats.get(id);
                    if (chat == null && !dont_create_chat) {
                        if (this.chats.size() > 32) {
                            throw new BuddyPluginException("Too many chats");
                        }
                        chat = new chatInstance(id);
                        this.chats.put(id, chat);
                        new_chat = true;
                    }
                }
                if (chat != null) {
                    if (new_chat) {
                        this.informCreated(chat);
                    }
                    chat.addParticipant(from_buddy);
                    chat.process(from_buddy, msg);
                }
                reply.put("type", new Long(6L));
            } else if (type == 7) {
                Map msg = (Map)request2.get("msg");
                Iterator it = this.track_listeners.iterator();
                boolean ok = false;
                while (it.hasNext()) {
                    try {
                        Map<String, Object> res = ((BuddyPluginAZ2TrackerListener)it.next()).messageReceived(from_buddy, msg);
                        if (res == null) continue;
                        reply.put("msg", res);
                        reply.put("type", new Long(8L));
                        ok = true;
                        break;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (!ok) {
                    throw new BuddyPluginException("Unhandled request type " + type);
                }
            } else if (type == 9) {
                try {
                    HashMap<String, Object> res = new HashMap<String, Object>();
                    reply.put("msg", res);
                    reply.put("type", new Long(10L));
                    Map msg = (Map)request2.get("msg");
                    String category = new String((byte[])msg.get("cat"), "UTF-8");
                    byte[] hash = (byte[])msg.get("hash");
                    if (hash == null) {
                        byte[] if_mod = (byte[])msg.get("if_mod");
                        BuddyPlugin.FeedDetails feed = this.plugin_network.getPlugin().getRSS(from_buddy, category, if_mod == null ? null : new String(if_mod, "UTF-8"));
                        res.put("rss", feed.getContent());
                        res.put("last_mod", feed.getLastModified());
                    }
                    res.put("torrent", this.plugin_network.getPlugin().getRSSTorrent(from_buddy, category, hash));
                }
                catch (BuddyPluginException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new BuddyPluginException("Failed to handle rss", e);
                }
            } else if (type == 11) {
                List<String> info = this.plugin_network.getProfileInfo();
                if (info == null) {
                    throw new BuddyPluginException("Unauthorised");
                }
                HashMap<String, List<String>> res = new HashMap<String, List<String>>();
                reply.put("msg", res);
                reply.put("type", new Long(12L));
                res.put("props", info);
            } else {
                throw new BuddyPluginException("Unrecognised request type " + type);
            }
        }
        this.logMessage(from_buddy, "AZ2 reply sent: " + from_buddy.getString() + " <- " + reply);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public chatInstance createChat(BuddyPluginBuddy[] buddies) {
        chatInstance chat;
        byte[] id_bytes = new byte[20];
        RandomUtils.SECURE_RANDOM.nextBytes(id_bytes);
        String id = Base32.encode(id_bytes);
        Map map = this.chats;
        synchronized (map) {
            chat = new chatInstance(id);
            this.chats.put(id, chat);
        }
        this.logMessage(null, "Chat " + chat.getID() + " created");
        this.informCreated(chat);
        chat.addParticipants(buddies, true);
        return chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyChat(chatInstance chat) {
        Map map = this.chats;
        synchronized (map) {
            this.chats.remove(chat.getID());
        }
        this.logMessage(null, "Chat " + chat.getID() + " destroyed");
        this.informDestroyed(chat);
    }

    protected void informCreated(chatInstance chat) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((BuddyPluginAZ2Listener)it.next()).chatCreated(chat);
        }
    }

    protected void informDestroyed(chatInstance chat) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((BuddyPluginAZ2Listener)it.next()).chatDestroyed(chat);
        }
    }

    public void sendAZ2Message(BuddyPluginBuddy buddy, String msg) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(1L));
            request2.put("msg", msg.getBytes());
            this.sendMessage(buddy, request2);
        }
        catch (Throwable e) {
            this.logMessageAndPopup(buddy, "Send message failed", e);
        }
    }

    protected void sendAZ2Chat(BuddyPluginBuddy buddy, Map msg) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(5L));
            request2.put("msg", msg);
            this.sendMessage(buddy, request2);
        }
        catch (Throwable e) {
            this.logMessageAndPopup(buddy, "Send message failed", e);
        }
    }

    public void sendAZ2Torrent(Torrent torrent, BuddyPluginBuddy buddy) {
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(3L));
            request2.put("torrent", torrent.writeToBEncodedData());
            this.sendMessage(buddy, request2);
        }
        catch (Throwable e) {
            this.logMessageAndPopup(buddy, "Send torrent failed", e);
        }
    }

    public void sendAZ2TrackerMessage(BuddyPluginBuddy buddy, Map msg, final BuddyPluginAZ2TrackerListener listener) {
        this.logMessage(buddy, "AZ2 request sent: " + buddy.getString() + " <- " + msg);
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(7L));
            request2.put("msg", msg);
            buddy.sendMessage(1, request2, 120000, new BuddyPluginBuddyReplyListener(){

                @Override
                public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                    int type = ((Long)reply.get("type")).intValue();
                    if (type != 8) {
                        this.sendFailed(from_buddy, new BuddyPluginException("Mismatched reply type"));
                    }
                    listener.messageReceived(from_buddy, (Map)reply.get("msg"));
                }

                @Override
                public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                    listener.messageFailed(to_buddy, cause);
                }
            });
        }
        catch (Throwable e) {
            this.logMessageAndPopup(buddy, "Send message failed", e);
        }
    }

    public void sendAZ2RSSMessage(BuddyPluginBuddy buddy, Map msg, final BuddyPluginAZ2TrackerListener listener) {
        this.logMessage(buddy, "AZ2 request sent: " + buddy.getString() + " <- " + msg);
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(9L));
            request2.put("msg", msg);
            buddy.sendMessage(1, request2, 120000, new BuddyPluginBuddyReplyListener(){

                @Override
                public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                    int type = ((Long)reply.get("type")).intValue();
                    if (type != 10) {
                        this.sendFailed(from_buddy, new BuddyPluginException("Mismatched reply type"));
                    }
                    listener.messageReceived(from_buddy, (Map)reply.get("msg"));
                }

                @Override
                public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                    listener.messageFailed(to_buddy, cause);
                }
            });
        }
        catch (Throwable e) {
            this.logMessage(buddy, "Send message failed", e);
        }
    }

    public void sendAZ2ProfileInfo(BuddyPluginBuddy buddy, Map msg, final BuddyPluginAZ2TrackerListener listener) {
        this.logMessage(buddy, "AZ2 request sent: " + buddy.getString() + " <- " + msg);
        try {
            HashMap<String, Object> request2 = new HashMap<String, Object>();
            request2.put("type", new Long(11L));
            request2.put("msg", msg);
            buddy.sendMessage(1, request2, 120000, new BuddyPluginBuddyReplyListener(){

                @Override
                public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                    int type = ((Long)reply.get("type")).intValue();
                    if (type != 12) {
                        this.sendFailed(from_buddy, new BuddyPluginException("Mismatched reply type"));
                    }
                    listener.messageReceived(from_buddy, (Map)reply.get("msg"));
                }

                @Override
                public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                    listener.messageFailed(to_buddy, cause);
                }
            });
        }
        catch (Throwable e) {
            this.logMessage(buddy, "Send message failed", e);
        }
    }

    protected void sendMessage(BuddyPluginBuddy buddy, Map request2) throws BuddyPluginException {
        this.logMessage(buddy, "AZ2 request sent: " + buddy.getString() + " <- " + request2);
        buddy.getMessageHandler().queueMessage(1, request2, 120000);
    }

    public void addListener(BuddyPluginAZ2Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BuddyPluginAZ2Listener listener) {
        this.listeners.remove(listener);
    }

    public void addTrackerListener(BuddyPluginAZ2TrackerListener listener) {
        this.track_listeners.add(listener);
    }

    public void removeTrackerListener(BuddyPluginAZ2TrackerListener listener) {
        this.track_listeners.remove(listener);
    }

    protected void logMessageAndPopup(BuddyPluginBuddy buddy, String str, Throwable e) {
        this.logMessageAndPopup(buddy, String.valueOf(str) + ": " + Debug.getNestedExceptionMessage(e));
    }

    protected void logMessageAndPopup(BuddyPluginBuddy buddy, String str) {
        if (buddy.isTransient()) {
            return;
        }
        this.logMessage(buddy, str);
        this.plugin_network.getPluginInterface().getUIManager().showMessageBox("azbuddy.msglog.title", "!" + str + "!", 1L);
    }

    protected void logMessage(BuddyPluginBuddy buddy, String str) {
        this.plugin_network.logMessage(buddy, str);
    }

    protected void logMessage(BuddyPluginBuddy buddy, String str, Throwable e) {
        this.plugin_network.logMessage(buddy, String.valueOf(str) + ": " + Debug.getNestedExceptionMessage(e));
    }

    public class chatInstance
    extends BuddyPluginAdapter {
        private String id;
        private Map participants = new HashMap();
        private CopyOnWriteList<BuddyPluginAZ2ChatListener> listeners = new CopyOnWriteList();
        private List history = new ArrayList();

        protected chatInstance(String _id) {
            this.id = _id;
            BuddyPluginAZ2.this.plugin_network.getPlugin().addListener(this);
        }

        public BuddyPluginNetwork getPluginNetwork() {
            return BuddyPluginAZ2.this.plugin_network;
        }

        public String getID() {
            return this.id;
        }

        @Override
        public void buddyAdded(BuddyPluginBuddy buddy) {
            this.buddyChanged(buddy);
        }

        @Override
        public void buddyRemoved(BuddyPluginBuddy buddy) {
            chatParticipant p = this.getParticipant(buddy);
            if (p != null) {
                for (BuddyPluginAZ2ChatListener l : this.listeners) {
                    try {
                        l.participantRemoved(p);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        @Override
        public void buddyChanged(BuddyPluginBuddy buddy) {
            chatParticipant p = this.getParticipant(buddy);
            if (p != null) {
                for (BuddyPluginAZ2ChatListener l : this.listeners) {
                    try {
                        l.participantChanged(p);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(BuddyPluginBuddy from_buddy, Map msg) {
            block17: {
                int type;
                chatParticipant p;
                block18: {
                    block16: {
                        p = this.getOrAddParticipant(from_buddy);
                        type = ((Long)msg.get("type")).intValue();
                        if (type != 1) break block16;
                        List list = this.history;
                        synchronized (list) {
                            this.history.add(new chatMessage(p.getName(), msg));
                            if (this.history.size() > 128) {
                                this.history.remove(0);
                            }
                        }
                        for (BuddyPluginAZ2ChatListener l : this.listeners) {
                            try {
                                l.messageReceived(p, msg);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        break block17;
                    }
                    if (type != 2) break block18;
                    List added = (List)msg.get("p");
                    int i = 0;
                    while (i < added.size()) {
                        Map participant = (Map)added.get(i);
                        String pk = new String((byte[])participant.get("pk"));
                        if (!pk.equals(BuddyPluginAZ2.this.plugin_network.getPublicKey())) {
                            this.addParticipant(pk);
                        }
                        ++i;
                    }
                    break block17;
                }
                if (type != 3) break block17;
                List added = (List)msg.get("p");
                int i = 0;
                while (i < added.size()) {
                    Map participant = (Map)added.get(i);
                    String pk = new String((byte[])participant.get("pk"));
                    if (!pk.equals(BuddyPluginAZ2.this.plugin_network.getPublicKey())) {
                        this.removeParticipant(pk);
                    }
                    ++i;
                }
                HashMap<String, byte[]> quit_msg = new HashMap<String, byte[]>();
                String quit_str = "/quit";
                try {
                    quit_msg.put("line", quit_str.getBytes("UTF-8"));
                }
                catch (Throwable e) {
                    quit_msg.put("line", quit_str.getBytes());
                }
                for (BuddyPluginAZ2ChatListener l : this.listeners) {
                    try {
                        l.messageReceived(p, quit_msg);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        public void sendMessage(Map msg) {
            msg.put("type", new Long(1L));
            this.sendMessageBase(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMessageBase(Map msg) {
            HashMap ps;
            Map map = this.participants;
            synchronized (map) {
                ps = new HashMap(this.participants);
            }
            msg.put("id", this.id);
            for (chatParticipant participant : ps.values()) {
                if (!participant.isAuthorised()) continue;
                BuddyPluginAZ2.this.sendAZ2Chat(participant.getBuddy(), msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public chatMessage[] getHistory() {
            List list = this.history;
            synchronized (list) {
                chatMessage[] res = new chatMessage[this.history.size()];
                this.history.toArray(res);
                return res;
            }
        }

        protected chatParticipant getOrAddParticipant(BuddyPluginBuddy buddy) {
            return this.addParticipant(buddy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public chatParticipant addParticipant(String pk) {
            chatParticipant p;
            BuddyPluginBuddy buddy = BuddyPluginAZ2.this.plugin_network.getBuddyFromPublicKey(pk);
            Map map = this.participants;
            synchronized (map) {
                p = (chatParticipant)this.participants.get(pk);
                if (p != null) {
                    return p;
                }
                p = buddy == null ? new chatParticipant(pk) : new chatParticipant(buddy);
                this.participants.put(pk, p);
            }
            Iterator<BuddyPluginAZ2ChatListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().participantAdded(p);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeParticipant(String pk) {
            chatParticipant p;
            Map map = this.participants;
            synchronized (map) {
                p = (chatParticipant)this.participants.get(pk);
            }
            if (p != null) {
                this.removeParticipant(p);
            }
        }

        public chatParticipant addParticipant(BuddyPluginBuddy buddy) {
            return this.addParticipant(buddy.getPublicKey());
        }

        public void addParticipants(BuddyPluginBuddy[] buddies, boolean inform_others) {
            int i = 0;
            while (i < buddies.length) {
                this.addParticipant(buddies[i]);
                ++i;
            }
            if (inform_others) {
                HashMap<String, Serializable> msg = new HashMap<String, Serializable>();
                msg.put("type", new Long(2L));
                ArrayList added = new ArrayList();
                msg.put("p", added);
                int i2 = 0;
                while (i2 < buddies.length) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("pk", buddies[i2].getPublicKey());
                    added.add(map);
                    ++i2;
                }
                this.sendMessageBase(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected chatParticipant getParticipant(BuddyPluginBuddy b) {
            String pk = b.getPublicKey();
            Map map = this.participants;
            synchronized (map) {
                chatParticipant p = (chatParticipant)this.participants.get(pk);
                if (p != null) {
                    return p;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public chatParticipant[] getParticipants() {
            Map map = this.participants;
            synchronized (map) {
                chatParticipant[] res = new chatParticipant[this.participants.size()];
                this.participants.values().toArray(res);
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeParticipant(chatParticipant p) {
            boolean removed;
            Map map = this.participants;
            synchronized (map) {
                removed = this.participants.remove(p.getPublicKey()) != null;
            }
            if (removed) {
                Iterator<BuddyPluginAZ2ChatListener> it = this.listeners.iterator();
                while (it.hasNext()) {
                    try {
                        it.next().participantRemoved(p);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        public void destroy() {
            HashMap<String, Serializable> msg = new HashMap<String, Serializable>();
            msg.put("type", new Long(3L));
            ArrayList removed = new ArrayList();
            msg.put("p", removed);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pk", BuddyPluginAZ2.this.plugin_network.getPublicKey());
            removed.add(map);
            this.sendMessageBase(msg);
            BuddyPluginAZ2.this.plugin_network.getPlugin().removeListener(this);
            BuddyPluginAZ2.this.destroyChat(this);
        }

        public void addListener(BuddyPluginAZ2ChatListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(BuddyPluginAZ2ChatListener listener) {
            this.listeners.remove(listener);
        }
    }

    public static class chatMessage {
        private String nick;
        private Map map;

        protected chatMessage(String _nick, Map _map) {
            this.nick = _nick;
            this.map = _map;
        }

        public String getNickName() {
            return this.nick;
        }

        public Map getMessage() {
            return this.map;
        }
    }

    public static class chatParticipant {
        private BuddyPluginBuddy buddy;
        private String public_key;

        protected chatParticipant(BuddyPluginBuddy _buddy) {
            this.buddy = _buddy;
        }

        protected chatParticipant(String pk) {
            this.public_key = pk;
        }

        public boolean isAuthorised() {
            return this.buddy != null;
        }

        public BuddyPluginBuddy getBuddy() {
            return this.buddy;
        }

        public String getPublicKey() {
            if (this.buddy != null) {
                return this.buddy.getPublicKey();
            }
            return this.public_key;
        }

        public String getName() {
            if (this.buddy != null) {
                return this.buddy.getName();
            }
            return this.public_key;
        }
    }
}

