/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.activities.LocalActivityManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.BannedIp;
import com.biglybt.core.ipfilter.IPFilterListener;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.proxy.impl.AEPluginProxyHandler;
import com.biglybt.core.security.BGSpongy;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.PluginEvent;
import com.biglybt.pif.PluginEventListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManagerListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginUI;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.plugin.net.buddy.BuddyPluginViewInterface;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.util.MapUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuddyPluginBeta
implements DataSourceResolver.DataSourceImporter,
AEDiagnosticsEvidenceGenerator {
    public static final boolean DEBUG_ENABLED = System.getProperty("az.chat.buddy.debug", "0").equals("1");
    public static final boolean BETA_CHAN_ENABLED = System.getProperty("az.chat.buddy.beta.chan", "1").equals("1");
    public static final String LEGACY_COMMUNITY_CHAT_KEY = "General: Help";
    public static final String COMMUNITY_CHAT_KEY = String.valueOf(Constants.APP_NAME) + ": " + "General: Help";
    public static final String LEGACY_ANNOUNCE_CHAT_KEY = "General: Announce";
    public static final String ANNOUNCE_CHAT_KEY = String.valueOf(Constants.APP_NAME) + ": " + "General: Announce";
    public static final String LEGACY_BETA_CHAT_KEY_DEAD = "test:beta:chat";
    public static final String BETA_CHAT_KEY = String.valueOf(Constants.APP_NAME) + ": Beta: Chat";
    public static final int PRIVATE_CHAT_DISABLED = 1;
    public static final int PRIVATE_CHAT_PINNED_ONLY = 2;
    public static final int PRIVATE_CHAT_ENABLED = 3;
    private static final String FLAGS_MSG_STATUS_KEY = "s";
    private static final int FLAGS_MSG_STATUS_CHAT_NONE = 0;
    private static final int FLAGS_MSG_STATUS_CHAT_QUIT = 1;
    public static final String FLAGS_MSG_ORIGIN_KEY = "o";
    public static final int FLAGS_MSG_ORIGIN_USER = 0;
    public static final int FLAGS_MSG_ORIGIN_RATINGS = 1;
    public static final int FLAGS_MSG_ORIGIN_SEED_REQ = 2;
    public static final int FLAGS_MSG_ORIGIN_SUBS = 3;
    public static final int FLAGS_MSG_ORIGIN_SEARCH = 4;
    public static final String FLAGS_MSG_FLASH_OVERRIDE = "f";
    public static final int FLAGS_MSG_FLASH_NO = 0;
    public static final int FLAGS_MSG_FLASH_YES = 1;
    public static final String FLAGS_MSG_TYPE_KEY = "t";
    public static final int FLAGS_MSG_TYPE_NORMAL = 0;
    public static final int FLAGS_MSG_TYPE_ME = 1;
    public static final int VIEW_TYPE_DEFAULT = 1;
    public static final int VIEW_TYPE_SHARING = 2;
    public static final String RSS_ITEMS_UNAVAILABLE = "RSS items unavailable until you accept Chat terms and conditions";
    private BuddyPlugin plugin;
    private PluginInterface plugin_interface;
    private BooleanParameter enabled;
    private AsyncDispatcher dispatcher = new AsyncDispatcher("BuddyPluginBeta");
    private Map<String, ChatInstance> chat_instances_map = new ConcurrentHashMap<String, ChatInstance>();
    private CopyOnWriteList<ChatInstance> chat_instances_list = new CopyOnWriteList();
    private PluginInterface azmsgsync_pi;
    private TimerEventPeriodic timer;
    private String shared_public_nickname;
    private String shared_anon_nickname;
    private int max_chat_ui_lines;
    private int max_chat_ui_kb;
    private boolean standalone_windows;
    private boolean windows_to_sidebar;
    private boolean use_ip_filter;
    private boolean enable_auto_dl_chats;
    private boolean hide_ratings;
    private boolean hide_search_subs;
    private int private_chat_state;
    private boolean shared_anon_endpoint;
    private String custom_date_format = "";
    private boolean sound_enabled;
    private String sound_file;
    private boolean post_friend_key;
    private boolean flash_enabled;
    private Map<String, Map<String, Object>> opts_map;
    private CopyOnWriteList<FTUXStateChangeListener> ftux_listeners = new CopyOnWriteList();
    private boolean ftux_accepted = false;
    private CopyOnWriteList<ChatManagerListener> listeners = new CopyOnWriteList();
    private AtomicInteger private_chat_id = new AtomicInteger();
    private AESemaphore init_complete = new AESemaphore("bpb:init");
    private final IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private static final Object DOWNLOAD_PEEK_CACHE_KEY = new Object();
    private static AsyncDispatcher dl_peek_dispatcher = new AsyncDispatcher("dl:peeker");
    private static Pattern auto_dup_pattern1 = Pattern.compile("File '(.*?)' is");
    private static Pattern auto_dup_pattern2 = Pattern.compile(":([a-zA-Z2-7]{32})", 2);
    private static Pattern auto_dup_pattern3 = Pattern.compile("See (http://wiki.(?:vuze|biglybt).com/w/Swarm_Merging)");
    private static Pattern[] auto_dup_patterns = new Pattern[]{auto_dup_pattern1, auto_dup_pattern2, auto_dup_pattern3};

    protected BuddyPluginBeta(PluginInterface _pi, BuddyPlugin _plugin, BooleanParameter _enabled) {
        Map lmi_map;
        Map log_messages_map;
        Map save_messages_map;
        this.plugin_interface = _pi;
        this.plugin = _plugin;
        this.enabled = _enabled;
        this.ftux_accepted = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ftux.accepted", false);
        this.shared_public_nickname = COConfigurationManager.getStringParameter("azbuddy.chat.shared_nick", "");
        this.shared_anon_nickname = COConfigurationManager.getStringParameter("azbuddy.chat.shared_anon_nick", "");
        this.private_chat_state = COConfigurationManager.getIntParameter("azbuddy.chat.private_chat_state", 3);
        this.shared_anon_endpoint = COConfigurationManager.getBooleanParameter("azbuddy.chat.share_i2p_endpoint", true);
        this.custom_date_format = COConfigurationManager.getStringParameter("azbuddy.chat.cdf", "");
        this.sound_enabled = COConfigurationManager.getBooleanParameter("azbuddy.chat.notif.sound.enable", false);
        this.sound_file = COConfigurationManager.getStringParameter("azbuddy.chat.notif.sound.file", "");
        this.post_friend_key = COConfigurationManager.getBooleanParameter("azbuddy.chat.post_friend_key", false);
        this.flash_enabled = COConfigurationManager.getBooleanParameter("azbuddy.chat.notif.flash.enable", true);
        this.opts_map = COConfigurationManager.getMapParameter("azbuddy.dchat.optsmap", new HashMap());
        Map favourite_map = COConfigurationManager.getMapParameter("azbuddy.dchat.favemap", new HashMap());
        if (favourite_map.size() > 0) {
            this.migrateBooleans(favourite_map, "fave");
            COConfigurationManager.removeParameter("azbuddy.dchat.favemap");
        }
        if ((save_messages_map = COConfigurationManager.getMapParameter("azbuddy.dchat.savemsgmap", new HashMap())).size() > 0) {
            this.migrateBooleans(save_messages_map, "save");
            COConfigurationManager.removeParameter("azbuddy.dchat.savemsgmap");
        }
        if ((log_messages_map = COConfigurationManager.getMapParameter("azbuddy.dchat.logmsgmap", new HashMap())).size() > 0) {
            this.migrateBooleans(log_messages_map, "log");
            COConfigurationManager.removeParameter("azbuddy.dchat.logmsgmap");
        }
        if ((lmi_map = COConfigurationManager.getMapParameter("azbuddy.dchat.lmimap", new HashMap())).size() > 0) {
            this.migrateByteArrays(lmi_map, "lmi");
            COConfigurationManager.removeParameter("azbuddy.dchat.lmimap");
        }
        this.max_chat_ui_lines = COConfigurationManager.getIntParameter("azbuddy.dchat.ui.max.lines", 250);
        this.max_chat_ui_kb = COConfigurationManager.getIntParameter("azbuddy.dchat.ui.max.char.kb", 10);
        this.standalone_windows = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ui.standalone.windows", false);
        this.windows_to_sidebar = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ui.windows.to.sidebar", false);
        this.use_ip_filter = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ui.ip.filter.enable", true);
        this.enable_auto_dl_chats = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ui.enable.auto.dl.chat", true);
        this.hide_ratings = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ui.hide.ratings", false);
        this.hide_search_subs = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ui.hide.search_subs", false);
        SimpleTimer.addPeriodicEvent("BPB:timer", 30000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                BuddyPluginBeta.this.tick();
            }
        });
        this.ip_filter.addListener(new IPFilterListener(){

            @Override
            public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
                return true;
            }

            @Override
            public boolean canIPBeBanned(String ip) {
                return true;
            }

            @Override
            public void IPFilterEnabledChanged(boolean is_enabled) {
                if (is_enabled) {
                    BuddyPluginBeta.this.resetIPFilters();
                }
            }

            @Override
            public void IPBlockedListChanged(IpFilter filter2) {
                BuddyPluginBeta.this.resetIPFilters();
            }

            @Override
            public void IPBanListChanged(IpFilter filter2) {
                BuddyPluginBeta.this.resetIPFilters();
            }

            @Override
            public void IPBanned(BannedIp ip) {
            }
        });
        DataSourceResolver.registerExporter(this);
        AEDiagnostics.addWeakEvidenceGenerator(this);
    }

    public boolean isAvailable() {
        return this.plugin_interface.getPluginManager().getPluginInterfaceByID("azmsgsync", true) != null;
    }

    public boolean isInitialised() {
        return this.init_complete.isReleasedForever();
    }

    public int getMaxUILines() {
        return this.max_chat_ui_lines;
    }

    public void setMaxUILines(int num) {
        this.max_chat_ui_lines = num;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.max.lines", num);
        COConfigurationManager.setDirty();
    }

    public int getMaxUICharsKB() {
        return this.max_chat_ui_kb;
    }

    public void setMaxUICharsKB(int num) {
        this.max_chat_ui_kb = num;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.max.char.kb", num);
        COConfigurationManager.setDirty();
    }

    public boolean getStandAloneWindows() {
        return this.standalone_windows;
    }

    public void setStandAloneWindows(boolean b) {
        this.standalone_windows = b;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.standalone.windows", b);
        COConfigurationManager.setDirty();
    }

    public boolean getWindowsToSidebar() {
        return this.windows_to_sidebar;
    }

    public void setWindowsToSidebar(boolean b) {
        this.windows_to_sidebar = b;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.windows.to.sidebar", b);
        COConfigurationManager.setDirty();
    }

    public boolean getUseIPFilter() {
        return this.use_ip_filter;
    }

    public void setUseIPFilter(boolean b) {
        this.use_ip_filter = b;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.ip.filter.enable", b);
        COConfigurationManager.setDirty();
    }

    public boolean getEnableAutoDownloadChats() {
        return this.enable_auto_dl_chats;
    }

    public void setEnableAutoDownloadChats(boolean b) {
        this.enable_auto_dl_chats = b;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.enable.auto.dl.chat", b);
        COConfigurationManager.setDirty();
    }

    public boolean getHideRatings() {
        return this.hide_ratings;
    }

    public void setHideRatings(boolean b) {
        this.hide_ratings = b;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.hide.ratings", b);
        COConfigurationManager.setDirty();
    }

    public boolean getHideSearchSubs() {
        return this.hide_search_subs;
    }

    public void setHideSearchSubs(boolean b) {
        this.hide_search_subs = b;
        COConfigurationManager.setParameter("azbuddy.dchat.ui.hide.search_subs", b);
        COConfigurationManager.setDirty();
    }

    public boolean getFavourite(String net, String key) {
        return this.getBooleanOption(net, key, "fave", false);
    }

    public void setFavourite(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "fave", b);
        this.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> getFavourites() {
        Map<String, Map<String, Object>> map = this.opts_map;
        synchronized (map) {
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (Map.Entry<String, Map<String, Object>> entry : this.opts_map.entrySet()) {
                String net_key = entry.getKey();
                Map<String, Object> map2 = entry.getValue();
                Long value = (Long)map2.get("fave");
                if (value == null || value != 1L) continue;
                String[] bits = net_key.split(":", 2);
                String network = AENetworkClassifier.internalise(bits[0]);
                String key = this.decodeKey(bits[1]);
                result.add(new String[]{network, key});
            }
            return result;
        }
    }

    private void resetIPFilters() {
        for (ChatInstance chat : this.chat_instances_list) {
            chat.resetIPFilters();
        }
    }

    private void tick() {
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    String key;
                    String net;
                    List<String[]> faves = BuddyPluginBeta.this.getFavourites();
                    HashSet<String> set = new HashSet<String>();
                    for (String[] fave : faves) {
                        net = fave[0];
                        key = fave[1];
                        set.add(String.valueOf(net) + ":" + key);
                        ChatInstance chat = BuddyPluginBeta.this.peekChatInstance(net, key, false);
                        if (chat != null && chat.getKeepAlive()) continue;
                        try {
                            chat = BuddyPluginBeta.this.getChat(net, key);
                            chat.setKeepAlive(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    for (ChatInstance chat : BuddyPluginBeta.this.chat_instances_list) {
                        if (!chat.getKeepAlive()) continue;
                        net = chat.getNetwork();
                        key = chat.getKey();
                        if (set.contains(String.valueOf(net) + ":" + key) || net == "Public" && (key.equals(BETA_CHAT_KEY) || key.equals(BuddyPluginBeta.LEGACY_BETA_CHAT_KEY_DEAD))) continue;
                        chat.setKeepAlive(false);
                        chat.destroy();
                    }
                }
                catch (Throwable throwable) {
                    boolean run_init = !BuddyPluginBeta.this.init_complete.isReleasedForever();
                    BuddyPluginBeta.this.init_complete.releaseForever();
                    if (run_init) {
                        BuddyPluginUtils.betaInit(BuddyPluginBeta.this);
                    }
                    throw throwable;
                }
                boolean run_init = !BuddyPluginBeta.this.init_complete.isReleasedForever();
                BuddyPluginBeta.this.init_complete.releaseForever();
                if (run_init) {
                    BuddyPluginUtils.betaInit(BuddyPluginBeta.this);
                }
                for (ChatInstance chat : BuddyPluginBeta.this.chat_instances_list) {
                    ChatParticipant[] participants;
                    if (!chat.getHasBeenViewed()) continue;
                    ChatParticipant[] chatParticipantArray = participants = chat.getParticipants();
                    int n = participants.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ChatParticipant p = chatParticipantArray[n2];
                        p.checkProfileData();
                        ++n2;
                    }
                }
            }
        });
    }

    public String getNick(String net, String key) {
        String old_key = "azbuddy.chat." + net + ": " + key + ".nick";
        if (COConfigurationManager.doesParameterNonDefaultExist(old_key)) {
            String temp = COConfigurationManager.getStringParameter(old_key, "");
            COConfigurationManager.removeParameter(old_key);
            if (temp.length() > 0) {
                this.setNick(net, key, temp);
                return temp;
            }
        }
        String nick = this.getStringOption(net, key, "nick", "");
        return nick;
    }

    public void setNick(String net, String key, String nick) {
        this.setStringOption(net, key, "nick", nick);
    }

    private boolean getSharedNick(String net, String key) {
        String old_key = "azbuddy.chat." + net + ": " + key + ".shared";
        if (COConfigurationManager.doesParameterNonDefaultExist(old_key)) {
            boolean temp = COConfigurationManager.getBooleanParameter(old_key, true);
            COConfigurationManager.removeParameter(old_key);
            if (!temp) {
                this.setSharedNick(net, key, false);
            }
            return temp;
        }
        return this.getBooleanOption(net, key, "sn", true);
    }

    private void setSharedNick(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "sn", b);
    }

    private boolean getSaveMessages(String net, String key) {
        return this.getBooleanOption(net, key, "save", false);
    }

    private void setSaveMessages(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "save", b);
    }

    private boolean getLogMessages(String net, String key) {
        return this.getBooleanOption(net, key, "log", false);
    }

    private void setLogMessages(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "log", b);
    }

    private boolean getAutoMute(String net, String key) {
        return this.getBooleanOption(net, key, "automute", false);
    }

    private void setAutoMute(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "automute", b);
    }

    private boolean getDisableNewMsgIndications(String net, String key) {
        return this.getBooleanOption(net, key, "disnot", false);
    }

    private void setDisableNewMsgIndications(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "disnot", b);
    }

    private boolean getEnableNotificationsPost(String net, String key) {
        return this.getBooleanOption(net, key, "notipost", false);
    }

    private void setEnableNotificationsPost(String net, String key, boolean b) {
        this.setBooleanOption(net, key, "notipost", b);
    }

    public String getLastMessageInfo(String net, String key) {
        return this.getStringOption(net, key, "lmi", null);
    }

    public void setLastMessageInfo(String net, String key, String info) {
        this.setStringOption(net, key, "lmi", info);
    }

    private String getDisplayName(String net, String key) {
        return this.getStringOption(net, key, "dn", null);
    }

    private void setDisplayName(String net, String key, String str) {
        this.setStringOption(net, key, "dn", str);
    }

    private int getViewType(String net, String key) {
        return this.getIntOption(net, key, "vt", 1);
    }

    private void setViewType(String net, String key, int vt) {
        this.setIntOption(net, key, "vt", vt);
    }

    private void migrateBooleans(Map<String, Long> map, String name) {
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            String net_key = entry.getKey();
            Long value = entry.getValue();
            if (value != 1L) continue;
            String[] bits = net_key.split(":", 2);
            String network = AENetworkClassifier.internalise(bits[0]);
            String key = bits[1];
            this.setBooleanOption(network, key, name, true);
        }
    }

    private void migrateByteArrays(Map<String, byte[]> map, String name) {
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            String net_key = entry.getKey();
            byte[] value = entry.getValue();
            String[] bits = net_key.split(":", 2);
            String network = AENetworkClassifier.internalise(bits[0]);
            String key = bits[1];
            this.setByteArrayOption(network, key, name, value);
        }
    }

    private void setBooleanOption(String net, String key, String name, boolean value) {
        this.setGenericOption(net, key, name, value ? 1L : 0L);
    }

    private boolean getBooleanOption(String net, String key, String name, boolean def) {
        Object obj = this.getGenericOption(net, key, name);
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        return def;
    }

    private void setIntOption(String net, String key, String name, int value) {
        this.setGenericOption(net, key, name, value);
    }

    private int getIntOption(String net, String key, String name, int def) {
        Object obj = this.getGenericOption(net, key, name);
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return def;
    }

    private void setStringOption(String net, String key, String name, String value) {
        try {
            this.setByteArrayOption(net, key, name, value.getBytes(Constants.UTF_8));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getStringOption(String net, String key, String name, String def) {
        byte[] bytes = this.getByteArrayOption(net, key, name);
        if (bytes != null) {
            try {
                return new String(bytes, Constants.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return def;
    }

    private void setByteArrayOption(String net, String key, String name, byte[] value) {
        this.setGenericOption(net, key, name, value);
    }

    private byte[] getByteArrayOption(String net, String key, String name) {
        Object obj = this.getGenericOption(net, key, name);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    private String encodeKey(String key) {
        try {
            return Base32.encode(key.getBytes(Constants.UTF_8));
        }
        catch (Throwable e) {
            Debug.out(e);
            return "";
        }
    }

    private String decodeKey(String key) {
        try {
            return new String(Base32.decode(key), Constants.UTF_8);
        }
        catch (Throwable e) {
            Debug.out(e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getGenericOption(String net, String key, String name) {
        String net_key = String.valueOf(net) + ":" + this.encodeKey(key);
        Map<String, Map<String, Object>> map = this.opts_map;
        synchronized (map) {
            Map<String, Object> opts;
            block4: {
                opts = this.opts_map.get(net_key);
                if (opts != null) break block4;
                return null;
            }
            return opts.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenericOption(String net, String key, String name, Object value) {
        String net_key = String.valueOf(net) + ":" + this.encodeKey(key);
        Map<String, Map<String, Object>> map = this.opts_map;
        synchronized (map) {
            try {
                Map<String, Object> opts = this.opts_map.get(net_key);
                if (opts == null) {
                    opts = new HashMap<String, Object>();
                    this.opts_map.put(net_key, opts);
                }
                opts.put(name, value);
                COConfigurationManager.setParameter("azbuddy.dchat.optsmap", this.opts_map);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        COConfigurationManager.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean chatOptionsExists(String net, String key) {
        String net_key = String.valueOf(net) + ":" + this.encodeKey(key);
        Map<String, Map<String, Object>> map = this.opts_map;
        synchronized (map) {
            return this.opts_map.containsKey(net_key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllOptions(String net, String key) {
        String net_key = String.valueOf(net) + ":" + this.encodeKey(key);
        Map<String, Map<String, Object>> map = this.opts_map;
        synchronized (map) {
            try {
                Map<String, Object> opts = this.opts_map.remove(net_key);
                if (opts == null) {
                    return;
                }
                COConfigurationManager.setParameter("azbuddy.dchat.optsmap", this.opts_map);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        COConfigurationManager.setDirty();
    }

    public String getSharedPublicNickname() {
        return this.shared_public_nickname;
    }

    public void setSharedPublicNickname(String _nick) {
        if (!_nick.equals(this.shared_public_nickname)) {
            this.shared_public_nickname = _nick;
            COConfigurationManager.setParameter("azbuddy.chat.shared_nick", _nick);
            COConfigurationManager.setDirty();
            this.allUpdated();
        }
    }

    public String getSharedAnonNickname() {
        return this.shared_anon_nickname;
    }

    public void setSharedAnonNickname(String _nick) {
        if (!_nick.equals(this.shared_anon_nickname)) {
            this.shared_anon_nickname = _nick;
            COConfigurationManager.setParameter("azbuddy.chat.shared_anon_nick", _nick);
            COConfigurationManager.setDirty();
            this.allUpdated();
        }
    }

    public int getPrivateChatState() {
        return this.private_chat_state;
    }

    public void setPrivateChatState(int state) {
        if (state != this.private_chat_state) {
            this.private_chat_state = state;
            COConfigurationManager.setParameter("azbuddy.chat.private_chat_state", state);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public void setPostFriendKey(boolean b) {
        if (b != this.post_friend_key) {
            this.post_friend_key = b;
            if (this.post_friend_key) {
                this.plugin.setClassicEnabled(true, false);
            }
            COConfigurationManager.setParameter("azbuddy.chat.post_friend_key", b);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public boolean getPostFriendKey() {
        return this.post_friend_key;
    }

    public boolean getSharedAnonEndpoint() {
        return this.shared_anon_endpoint;
    }

    public void setSharedAnonEndpoint(boolean b) {
        if (b != this.shared_anon_endpoint) {
            this.shared_anon_endpoint = b;
            COConfigurationManager.setParameter("azbuddy.chat.share_i2p_endpoint", b);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public String getCustomDateFormat() {
        return this.custom_date_format;
    }

    public void setCustomDateFormat(String cdf) {
        if (!(cdf = cdf == null ? "" : cdf.trim()).equals(this.custom_date_format)) {
            this.custom_date_format = cdf;
            COConfigurationManager.setParameter("azbuddy.chat.cdf", cdf);
            COConfigurationManager.setDirty();
            for (ChatInstance chat : this.chat_instances_list) {
                chat.configChanged();
            }
            this.plugin.fireUpdated();
        }
    }

    public void setSoundEnabled(boolean b) {
        if (b != this.sound_enabled) {
            this.sound_enabled = b;
            COConfigurationManager.setParameter("azbuddy.chat.notif.sound.enable", b);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public boolean getSoundEnabled() {
        return this.sound_enabled;
    }

    public String getSoundFile() {
        return this.sound_file;
    }

    public void setSoundFile(String _file) {
        if (!_file.equals(this.sound_file)) {
            this.sound_file = _file;
            COConfigurationManager.setParameter("azbuddy.chat.notif.sound.file", _file);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public void setFlashEnabled(boolean b) {
        if (b != this.flash_enabled) {
            this.flash_enabled = b;
            COConfigurationManager.setParameter("azbuddy.chat.notif.flash.enable", b);
            COConfigurationManager.setDirty();
            this.plugin.fireUpdated();
        }
    }

    public boolean getFlashEnabled() {
        return this.flash_enabled;
    }

    private void allUpdated() {
        for (ChatInstance chat : this.chat_instances_list) {
            chat.updated();
        }
        this.plugin.fireUpdated();
    }

    protected void startup() {
        PluginInterface[] plugins;
        this.plugin_interface.addEventListener(new PluginEventListener(){

            @Override
            public void handleEvent(PluginEvent ev) {
                int type = ev.getType();
                if (type == 8) {
                    BuddyPluginBeta.this.pluginAdded((PluginInterface)ev.getValue());
                } else if (type == 9) {
                    BuddyPluginBeta.this.pluginRemoved((PluginInterface)ev.getValue());
                }
            }
        });
        PluginInterface[] pluginInterfaceArray = plugins = this.plugin_interface.getPluginManager().getPlugins(true);
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            PluginInterface pi = pluginInterfaceArray[n2];
            if (pi.getPluginState().isOperational()) {
                this.pluginAdded(pi);
            }
            ++n2;
        }
        boolean check_all = COConfigurationManager.getBooleanParameter("azbuddy.dchat.autotracker.scan", true);
        COConfigurationManager.setParameter("azbuddy.dchat.autotracker.scan", false);
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){
            private Set<String> checked = new HashSet<String>();

            @Override
            public void downloadAdded(Download download) {
                String tracker;
                Set<String> hosts;
                TOTorrent to_torrent;
                Torrent torrent;
                if (COConfigurationManager.getBooleanParameter("Auto Tag Interesting Trackers") && (torrent = download.getTorrent()) != null && TorrentUtils.isReallyPrivate(to_torrent = PluginCoreUtils.unwrap(download.getTorrent())) && (hosts = TorrentUtils.getUniqueTrackerHosts(to_torrent)).size() == 1 && (tracker = DNSUtils.getInterestingHostSuffix(hosts.iterator().next())) != null && !this.checked.contains(tracker)) {
                    this.checked.add(tracker);
                    try {
                        String config_key = "azbuddy.dchat.autotracker.host." + Base32.encode(tracker.getBytes(Constants.UTF_8));
                        boolean done = COConfigurationManager.getBooleanParameter(config_key, false);
                        if (!done) {
                            TagType tt;
                            Tag tag;
                            COConfigurationManager.setParameter(config_key, true);
                            String chat_key = "Tracker: " + tracker;
                            ChatInstance chat = BuddyPluginBeta.this.getChat("Public", chat_key);
                            chat.setFavourite(true);
                            BuddyPluginUI.openChat(chat);
                            TagManager tm = TagManagerFactory.getTagManager();
                            if (tm.isEnabled() && (tag = (tt = tm.getTagType(3)).getTag(tracker, true)) == null) {
                                tag = tt.createTag(tracker, false);
                                tag.setPublic(false);
                                tt.addTag(tag);
                                TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                                TagFeatureProperties.TagProperty tp2 = tfp.getProperty("trackers");
                                tp2.setStringList(new String[]{tracker});
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void downloadRemoved(Download download) {
            }
        }, check_all);
    }

    public Tag getDownloadTag() {
        try {
            TagType tt = TagManagerFactory.getTagManager().getTagType(3);
            Tag tag = tt.getTag("tag.azbuddy.dchat.shares", false);
            if (tag == null) {
                tag = tt.createTag("tag.azbuddy.dchat.shares", true);
                tag.setCanBePublic(false);
                tag.setPublic(false);
            }
            return tag;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public void tagDownload(Download download) {
        DownloadManager core_dm;
        Tag tag = this.getDownloadTag();
        if (tag != null && !tag.hasTaggable(core_dm = PluginCoreUtils.unwrap(download))) {
            tag.addTaggable(core_dm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closedown() {
        if (this.azmsgsync_pi != null) {
            try {
                List reply = (List)this.azmsgsync_pi.getIPC().invoke("listMessageHandlers", new Object[]{new HashMap()});
                for (Map map : reply) {
                    String key = new String((byte[])map.get("key"), Constants.UTF_8);
                    if (!BuddyPluginUtils.isUnknownDownloadChatKey(key)) continue;
                    try {
                        String net = (String)map.get("network");
                        if (this.getFavourite(net, key)) continue;
                        this.azmsgsync_pi.getIPC().invoke("destroyMessageHandler", new Object[]{map});
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Map<String, Map<String, Object>> map = this.opts_map;
        synchronized (map) {
            boolean dirty = false;
            Iterator<String> it = this.opts_map.keySet().iterator();
            while (it.hasNext()) {
                String net;
                String net_key = it.next();
                String[] bits = net_key.split(":", 2);
                String key = this.decodeKey(bits[1]);
                if (!BuddyPluginUtils.isUnknownDownloadChatKey(key) || this.getFavourite(net = bits[0], key)) continue;
                it.remove();
                dirty = true;
            }
            if (dirty) {
                COConfigurationManager.setParameter("azbuddy.dchat.optsmap", this.opts_map);
                COConfigurationManager.setDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginAdded(PluginInterface pi) {
        if (pi.getPluginID().equals("azmsgsync")) {
            List<Object> to_bind = new ArrayList();
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                this.azmsgsync_pi = pi;
                to_bind = this.chat_instances_list.getList();
            }
            int i = 0;
            while (i < 2) {
                for (ChatInstance chatInstance2 : to_bind) {
                    if (chatInstance2.getNetwork() == "Public" != (i == 0)) continue;
                    try {
                        this.doBind(chatInstance2, String.valueOf(chatInstance2.getKey()) + ":" + chatInstance2.getNetwork(), pi, null, false);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                ++i;
            }
            this.dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        ChatInstance chat;
                        if (Constants.isCVSVersion() && BuddyPluginBeta.this.enabled.getValue() && BETA_CHAN_ENABLED) {
                            chat = BuddyPluginBeta.this.getChat("Public", BETA_CHAT_KEY);
                            chat.setKeepAlive(true);
                        }
                        if (!COConfigurationManager.getBooleanParameter("azbuddy.dchat.biglybt.chan.joined", false)) {
                            COConfigurationManager.setParameter("azbuddy.dchat.biglybt.chan.joined", true);
                            chat = BuddyPluginBeta.this.getChat("Public", COMMUNITY_CHAT_KEY);
                            chat.setFavourite(true);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginRemoved(PluginInterface pi) {
        if (pi.getPluginID().equals("azmsgsync")) {
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                this.azmsgsync_pi = null;
                Iterator<ChatInstance> it = this.chat_instances_map.values().iterator();
                while (it.hasNext()) {
                    ChatInstance inst = it.next();
                    inst.unbind();
                    if (!inst.isPrivateChat()) continue;
                    it.remove();
                }
            }
        }
    }

    public boolean isI2PAvailable() {
        return AEPluginProxyHandler.hasPluginProxyForNetwork("I2P", false);
    }

    public void selectClassicTab() {
        this.plugin.getSWTUI().selectClassicTab();
    }

    public InputStream handleURI(String url_str, boolean open_only) throws Exception {
        String network;
        String protocol;
        int pos = url_str.indexOf(63);
        String key = null;
        String format = null;
        if (pos != -1) {
            String[] bits;
            protocol = url_str.substring(0, pos).toLowerCase(Locale.US);
            String args = url_str.substring(pos + 1);
            String[] stringArray = bits = args.split("&");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] temp = bit.split("=");
                if (temp.length == 1) {
                    key = UrlUtils.decode(temp[0]);
                } else {
                    String lhs = temp[0].toLowerCase(Locale.US);
                    String rhs = UrlUtils.decode(temp[1]);
                    if (lhs.equals("key")) {
                        key = rhs;
                    } else if (lhs.equals("format")) {
                        format = rhs;
                    }
                }
                ++n2;
            }
        } else {
            throw new Exception("Malformed request");
        }
        if (key == null) {
            throw new Exception("Key missing");
        }
        if (protocol.startsWith("chat:friend") || protocol.startsWith("chat:anon:friend")) {
            boolean is_pub;
            if (!this.plugin.isClassicEnabled()) {
                this.plugin.setClassicEnabled(true, false);
            }
            if (!key.equals(this.plugin.getPublicKey(is_pub = protocol.startsWith("chat:friend")))) {
                this.plugin.addBuddy(is_pub, key, 1);
                this.plugin.getSWTUI().selectClassicTab();
            }
            return null;
        }
        if (open_only) {
            format = null;
        }
        if (protocol.startsWith("chat:anon")) {
            if (!this.isI2PAvailable()) {
                boolean[] result = new boolean[1];
                I2PHelpers.installI2PHelper(MessageText.getString("azbuddy.dchat.anon.requested"), "azbuddy.dchat.uri.based.i2p.install", result, new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                throw new Exception("I2P unavailable");
            }
            network = "I2P";
        } else if (protocol.startsWith("chat")) {
            network = "Public";
        } else {
            throw new Exception("Invalid protocol: " + protocol);
        }
        if (format == null || !format.equalsIgnoreCase("rss")) {
            BuddyPluginViewInterface ui = this.plugin.getSWTUI();
            if (ui == null) {
                throw new Exception("UI unavailable");
            }
            ChatInstance chat = this.getChat(network, key);
            ui.openChat(chat);
            return null;
        }
        ChatInstance chat = this.peekChatInstance(network, key, true);
        if (chat == null) {
            throw new Exception("Chat unavailable");
        }
        if (!chat.isFavourite()) {
            chat.setFavourite(true);
            chat.setKeepAlive(true);
        }
        if (!chat.getSaveMessages()) {
            chat.setSaveMessages(true);
        }
        List<ChatMessage> messages = chat.getMessages();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Constants.UTF_8));
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
        pw.println("<channel>");
        pw.println("<title>" + this.escape(chat.getName()) + "</title>");
        if (this.ftux_accepted) {
            long last_modified = messages.size() == 0 ? SystemTime.getCurrentTime() : messages.get(messages.size() - 1).getTimeStamp();
            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(last_modified) + "</pubDate>");
            int message_num = messages.size();
            long[] message_times = new long[message_num];
            if (message_num > 0) {
                long max = messages.get(message_num - 1).getTimeStamp() + 1L;
                int i = message_num - 1;
                while (i >= 0) {
                    long time = messages.get(i).getTimeStamp();
                    if (time > max) {
                        time = max;
                    } else if (time == max) {
                        time = --max;
                    } else {
                        max = time;
                    }
                    message_times[i] = time;
                    --i;
                }
            }
            int i = 0;
            while (i < message_num) {
                ChatMessage message = messages.get(i);
                List<Map<String, Object>> message_links = this.extractLinks(message.getMessage());
                if (message_links.size() != 0) {
                    long message_time = message_times[i];
                    String item_date = TimeFormatter.getHTTPDate(message_time);
                    for (Map<String, Object> message_link : message_links) {
                        if (message_link.containsKey("magnet")) {
                            String str;
                            List nets;
                            String link;
                            Map<String, Object> magnet = message_link;
                            String hash = (String)magnet.get("hash");
                            if (hash == null) continue;
                            String title = (String)magnet.get("title");
                            if (title == null) {
                                title = hash;
                            }
                            if ((link = (String)magnet.get("link")) == null) {
                                link = (String)magnet.get("magnet");
                            }
                            boolean public_magnet = (nets = (List)magnet.get("networks")).isEmpty() || nets.contains("Public");
                            String pub_str = MessageText.getString(public_magnet ? "subs.prop.is_public" : "label.anon");
                            pw.println("<item>");
                            pw.println("<title>" + this.escape(String.valueOf(pub_str) + ": " + title) + "</title>");
                            pw.println("<guid>" + hash + "</guid>");
                            String cdp = (String)magnet.get("cdp");
                            if (cdp != null) {
                                pw.println("<link>" + this.escape(cdp) + "</link>");
                            }
                            Long size = (Long)magnet.get("size");
                            Long seeds = (Long)magnet.get("seeds");
                            Long leechers = (Long)magnet.get("leechers");
                            Long magnet_date = (Long)magnet.get("date");
                            Long magnet_item_date = magnet_date;
                            if (magnet_item_date != null) {
                                if (magnet_item_date < message_time) {
                                    magnet_item_date = null;
                                } else if (i < message_num - 1) {
                                    if (magnet_item_date >= message_times[i + 1]) {
                                        magnet_item_date = null;
                                    }
                                } else {
                                    magnet_item_date = null;
                                }
                            }
                            String enclosure = "<enclosure type=\"application/x-bittorrent\" url=\"" + this.escape(link) + "\"";
                            if (size != null) {
                                enclosure = String.valueOf(enclosure) + " length=\"" + size + "\"";
                            }
                            enclosure = String.valueOf(enclosure) + " />";
                            pw.println(enclosure);
                            String date_str = magnet_item_date == null || magnet_item_date <= 0L ? item_date : TimeFormatter.getHTTPDate(magnet_item_date);
                            pw.println("<pubDate>" + date_str + "</pubDate>");
                            if (size != null) {
                                pw.println("<vuze:size>" + size + "</vuze:size>");
                            }
                            if (seeds != null) {
                                pw.println("<vuze:seeds>" + seeds + "</vuze:seeds>");
                            }
                            if (leechers != null) {
                                pw.println("<vuze:peers>" + leechers + "</vuze:peers>");
                            }
                            if (magnet_date != null && !(str = TimeFormatter.getHTTPDate(magnet_date)).equalsIgnoreCase(date_str)) {
                                pw.println("<vuze:assetdate>" + str + "</vuze:assetdate>");
                            }
                            pw.println("<vuze:assethash>" + hash + "</vuze:assethash>");
                            pw.println("<vuze:downloadurl>" + this.escape(link) + "</vuze:downloadurl>");
                            pw.println("</item>");
                            continue;
                        }
                        String title = (String)message_link.get("title");
                        String link = (String)message_link.get("link");
                        pw.println("<item>");
                        pw.println("<title>" + this.escape(title) + "</title>");
                        pw.println("<guid>" + this.escape(link) + "</guid>");
                        pw.println("<link>" + this.escape(link) + "</link>");
                        pw.println("<pubDate>" + item_date + "</pubDate>");
                        pw.println("<vuze:rank></vuze:rank>");
                        String enclosure = "<enclosure type=\"application/x-bittorrent\" url=\"" + this.escape(link) + "\"";
                        enclosure = String.valueOf(enclosure) + " />";
                        pw.println(enclosure);
                        pw.println("</item>");
                    }
                }
                ++i;
            }
        } else {
            String link = "chat:?BiglyBT%3A%20General%3A%20Help";
            pw.println("<item>");
            pw.println("<title>" + this.escape(RSS_ITEMS_UNAVAILABLE) + "</title>");
            pw.println("<guid>23232329090909</guid>");
            pw.println("<link>" + link + "</link>");
            pw.println("<vuze:downloadurl>" + link + "</vuze:downloadurl>");
            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(SystemTime.getCurrentTime()) + "</pubDate>");
            pw.println("</item>");
        }
        pw.println("</channel>");
        pw.println("</rss>");
        pw.flush();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private List<Map<String, Object>> extractLinks(String str) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int len = str.length();
        String lc_str = str.toLowerCase(Locale.US);
        int pos = 0;
        while (pos < len) {
            int temp_pos = lc_str.indexOf("magnet:", pos);
            int type = -1;
            if (temp_pos != -1) {
                pos = temp_pos;
                type = 0;
            } else {
                String[] protocols;
                String[] stringArray = protocols = new String[]{"azplug:", "chat:"};
                int n = protocols.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    temp_pos = lc_str.indexOf(p, pos);
                    if (temp_pos != -1) {
                        pos = temp_pos;
                        type = 1;
                        break;
                    }
                    ++n2;
                }
                if (type == -1) break;
            }
            int start = pos;
            while (pos < len) {
                char c = str.charAt(pos);
                if (Character.isWhitespace(c) || c == '\"' && start > 0 && lc_str.charAt(start - 1) == '\"') break;
                ++pos;
            }
            String link = str.substring(start, pos);
            if (type == 0) {
                String magnet = link;
                int x = magnet.indexOf(63);
                if (x == -1) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                int p1 = magnet.lastIndexOf("[[");
                if (p1 != -1 && magnet.endsWith("]]")) {
                    magnet = magnet.substring(0, p1);
                }
                map.put("magnet", magnet);
                ArrayList<String> trackers = new ArrayList<String>();
                map.put("trackers", trackers);
                ArrayList<String> nets = new ArrayList<String>();
                map.put("networks", nets);
                String[] bits = magnet.substring(x + 1).split("&");
                byte[] hash = UrlUtils.getTruncatedHashFromMagnetURI(magnet);
                if (hash != null) {
                    map.put("hash", Base32.encode(hash).toUpperCase(Locale.US));
                }
                String[] stringArray = bits;
                int n = bits.length;
                int n3 = 0;
                while (n3 < n) {
                    String bit = stringArray[n3];
                    String[] temp = bit.split("=");
                    if (temp.length == 2) {
                        try {
                            String lhs = temp[0].toLowerCase(Locale.US);
                            String rhs = UrlUtils.decode(temp[1]);
                            if (lhs.equals("dn")) {
                                map.put("title", rhs);
                            } else if (lhs.equals("tr")) {
                                trackers.add(rhs);
                            } else if (lhs.equals("net")) {
                                nets.add(AENetworkClassifier.internalise(rhs));
                            } else if (lhs.equals("fl")) {
                                map.put("link", rhs);
                            } else if (lhs.equals("xl")) {
                                long size = Long.parseLong(rhs);
                                map.put("size", size);
                            } else if (lhs.equals("_d")) {
                                long date = Long.parseLong(rhs);
                                map.put("date", date);
                            } else if (lhs.equals("_s")) {
                                long seeds = Long.parseLong(rhs);
                                map.put("seeds", seeds);
                            } else if (lhs.equals("_l")) {
                                long leechers = Long.parseLong(rhs);
                                map.put("leechers", leechers);
                            } else if (lhs.equals("_c")) {
                                map.put("cdp", rhs);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n3;
                }
                result.add(map);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int p1 = link.lastIndexOf("[[");
            if (p1 == -1 || !link.endsWith("]]")) continue;
            String title = UrlUtils.decode(link.substring(p1 + 2, link.length() - 2));
            map.put("title", title);
            link = link.substring(0, p1);
            map.put("link", link);
            result.add(map);
        }
        return result;
    }

    private String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    public boolean getFTUXAccepted() {
        return this.ftux_accepted;
    }

    public void setFTUXAccepted(boolean accepted) {
        this.ftux_accepted = accepted;
        COConfigurationManager.setParameter("azbuddy.dchat.ftux.accepted", accepted);
        COConfigurationManager.save();
        for (FTUXStateChangeListener l : this.ftux_listeners) {
            l.stateChanged(accepted);
        }
    }

    public void addFTUXStateChangeListener(FTUXStateChangeListener listener) {
        this.ftux_listeners.add(listener);
        listener.stateChanged(this.ftux_accepted);
    }

    public void removeFTUXStateChangeListener(FTUXStateChangeListener listener) {
        this.ftux_listeners.remove(listener);
    }

    private void logMessage(ChatInstance chat, ChatMessage message) {
        File log_dir = AEDiagnostics.getLogDir();
        if (!(log_dir = FileUtil.newFile(log_dir, "chat")).exists()) {
            log_dir.mkdir();
        }
        File log_file = FileUtil.newFile(log_dir, String.valueOf(FileUtil.convertOSSpecificChars(chat.getName(), false)) + ".log");
        try (PrintWriter pw = null;){
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)FileUtil.newFileOutputStream(log_file, true), Constants.UTF_8));
                SimpleDateFormat time_format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                String msg = "[" + time_format.format(new Date(message.getTimeStamp())) + "]";
                msg = String.valueOf(msg) + " <" + message.getParticipant().getName(true) + "> " + message.getMessage();
                pw.println(msg);
            }
            catch (Throwable throwable) {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    public ChatInstance getAndShowChat(String network, String key) throws Exception {
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        ChatInstance chat = this.getChat(network, key);
        ui.openChat(chat);
        return chat;
    }

    public ChatInstance showChat(ChatInstance inst) throws Exception {
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        ui.openChat(inst);
        return inst;
    }

    private String pkToString(byte[] pk) {
        byte[] temp = new byte[3];
        if (pk != null) {
            System.arraycopy(pk, 8, temp, 0, 3);
        }
        return ByteFormatter.encodeString(temp);
    }

    public ChatInstance importChat(String import_data) throws Exception {
        if (this.azmsgsync_pi == null) {
            throw new Exception("Plugin unavailable ");
        }
        HashMap<String, byte[]> options = new HashMap<String, byte[]>();
        options.put("import_data", import_data.getBytes(Constants.UTF_8));
        Map reply = (Map)this.azmsgsync_pi.getIPC().invoke("importMessageHandler", new Object[]{options});
        String key = new String((byte[])reply.get("key"), Constants.UTF_8);
        String network = (String)reply.get("network");
        Object handler = reply.get("handler");
        return this.getChat(network, key, null, handler, false, null);
    }

    public ChatInstance getChat(Download download) {
        String key = BuddyPluginUtils.getChatKey(download);
        if (key != null) {
            String[] networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
            boolean has_i2p = false;
            String[] stringArray = networks;
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    try {
                        ChatInstance inst = this.getChat(net, key);
                        return inst;
                    }
                    catch (Throwable throwable) {}
                } else if (net == "I2P") {
                    has_i2p = true;
                }
                ++n2;
            }
            if (has_i2p) {
                try {
                    ChatInstance inst = this.getChat("I2P", key);
                    return inst;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object importDataSource(Map<String, Object> map) {
        final Runnable callback = (Runnable)map.get("callback");
        if (callback != null && this.plugin.getSWTUI() == null) {
            final TimerEventPeriodic[] event2 = new TimerEventPeriodic[1];
            final long start = SystemTime.getMonotonousTime();
            TimerEventPeriodic[] timerEventPeriodicArray = event2;
            // MONITORENTER : event2
            event2[0] = SimpleTimer.addPeriodicEvent("initwait", 1000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent e) {
                    TimerEventPeriodic[] timerEventPeriodicArray = event2;
                    synchronized (event2) {
                        if (BuddyPluginBeta.this.plugin.getSWTUI() != null) {
                            callback.run();
                            event2[0].cancel();
                        } else if (SystemTime.getMonotonousTime() - start > 30000L) {
                            event2[0].cancel();
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            // MONITOREXIT : timerEventPeriodicArray
        }
        String network = AENetworkClassifier.internalise((String)map.get("network"));
        String key = (String)map.get("key");
        try {
            ChatInstance chat = this.peekChatInstance(network, key);
            if (chat != null) {
                return chat;
            }
            boolean apply_options = !this.chatOptionsExists(network, key);
            chat = this.getChat(network, key);
            if (apply_options) {
                Number vt;
                String dn = (String)map.get("dn");
                if (dn != null) {
                    chat.setDisplayName(dn);
                }
                if ((vt = (Number)map.get("vt")) != null) {
                    chat.setViewType(vt.intValue());
                }
                chat.setSharedNickname(false);
            }
            chat.setFavourite(true);
            chat.addVirtualReference();
            return chat;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public ChatInstance getChat(String network, String key) throws Exception {
        return this.getChat(network, key, null, null, false, null);
    }

    public ChatInstance getChat(String network, String key, Map<String, Object> options) throws Exception {
        return this.getChat(network, key, null, null, false, options);
    }

    public ChatInstance getChat(ChatParticipant participant) throws Exception {
        String key = String.valueOf(participant.getChat().getKey()) + " - " + participant.getName() + " (outgoing)[" + this.private_chat_id.getAndIncrement() + "]";
        return this.getChat(participant.getChat().getNetwork(), key, participant, null, true, null);
    }

    public ChatInstance getChat(ChatParticipant parent_participant, Object handler) throws Exception {
        String key = String.valueOf(parent_participant.getChat().getKey()) + " - " + parent_participant.getName() + " (incoming)[" + this.private_chat_id.getAndIncrement() + "]";
        return this.getChat(parent_participant.getChat().getNetwork(), key, null, handler, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatInstance getChat(String network, String key, ChatParticipant private_target, Object handler, boolean is_private_chat, Map<String, Object> options) throws Exception {
        ChatInstance result;
        if (!this.enabled.getValue()) {
            throw new Exception("Plugin not enabled");
        }
        String meta_key = String.valueOf(network) + ":" + key;
        ChatInstance added = null;
        PluginInterface bind_pi = null;
        Map<String, ChatInstance> map = this.chat_instances_map;
        synchronized (map) {
            result = this.chat_instances_map.get(meta_key);
            if (result == null) {
                result = new ChatInstance(network, key, private_target, is_private_chat, options);
                this.chat_instances_map.put(meta_key, result);
                this.chat_instances_list.add(result);
                added = result;
                if (this.azmsgsync_pi != null) {
                    bind_pi = this.azmsgsync_pi;
                }
            } else {
                result.addReference();
            }
            if (this.timer == null) {
                this.timer = SimpleTimer.addPeriodicEvent("BPB:timer", 2500L, new TimerEventPerformer(){
                    int tick_count;
                    AsyncDispatcher rebinder = new AsyncDispatcher();
                    boolean rebind_active;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        ++this.tick_count;
                        for (ChatInstance inst : BuddyPluginBeta.this.chat_instances_list) {
                            inst.update();
                        }
                        if (this.tick_count % 25 == 0) {
                            AsyncDispatcher asyncDispatcher = this.rebinder;
                            synchronized (asyncDispatcher) {
                                if (!this.rebind_active) {
                                    this.rebind_active = true;
                                    this.rebinder.dispatch(new AERunnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void runSupport() {
                                            try {
                                                for (ChatInstance inst : BuddyPluginBeta.this.chat_instances_list) {
                                                    inst.checkRebind();
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                AsyncDispatcher asyncDispatcher = rebinder;
                                                synchronized (asyncDispatcher) {
                                                    rebind_active = false;
                                                }
                                                throw throwable;
                                            }
                                            AsyncDispatcher asyncDispatcher = rebinder;
                                            synchronized (asyncDispatcher) {
                                                rebind_active = false;
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    }
                });
            }
        }
        if (bind_pi != null) {
            this.doBind(result, meta_key, bind_pi, handler, true);
        }
        if (added != null) {
            for (ChatManagerListener l : this.listeners) {
                try {
                    l.chatAdded(added);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBind(ChatInstance chat, String meta_key, PluginInterface pi, Object handler, boolean destroy_on_fail) throws Exception {
        try {
            chat.bind(this.azmsgsync_pi, handler, -1L);
        }
        catch (Throwable e) {
            if (destroy_on_fail) {
                Map<String, ChatInstance> map = this.chat_instances_map;
                synchronized (map) {
                    this.chat_instances_map.remove(meta_key);
                    this.chat_instances_list.remove(chat);
                }
                chat.destroy();
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e);
        }
    }

    public ChatInstance peekChatInstance(String network, String key) {
        return this.peekChatInstance(network, key, false);
    }

    public ChatInstance peekChatInstance(Download download) {
        String key = BuddyPluginUtils.getChatKey(download);
        if (key != null) {
            String[] networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
            boolean has_i2p = false;
            String[] stringArray = networks;
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    try {
                        return this.peekChatInstance(net, key);
                    }
                    catch (Throwable throwable) {
                    }
                } else if (net == "I2P") {
                    has_i2p = true;
                }
                ++n2;
            }
            if (has_i2p) {
                try {
                    return this.peekChatInstance("I2P", key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public List<ChatInstance> peekChatInstances(Download download) {
        ArrayList<ChatInstance> result = new ArrayList<ChatInstance>();
        String key = BuddyPluginUtils.getChatKey(download);
        if (key != null) {
            String[] networks;
            String[] stringArray = networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                ChatInstance ci = this.peekChatInstance(net, key);
                if (ci != null) {
                    result.add(ci);
                }
                ++n2;
            }
        }
        return result;
    }

    public ChatInstance peekChatInstance(String network, String key, boolean create_if_missing) {
        String meta_key = String.valueOf(network) + ":" + key;
        ChatInstance inst = this.chat_instances_map.get(meta_key);
        if (inst == null && create_if_missing) {
            try {
                inst = this.getChat(network, key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> peekChat(final Download download, boolean async) {
        String key = BuddyPluginUtils.getChatKey(download);
        if (key != null) {
            if (async) {
                Object object = DOWNLOAD_PEEK_CACHE_KEY;
                synchronized (object) {
                    HashMap map;
                    block16: {
                        map = (HashMap)download.getUserData(DOWNLOAD_PEEK_CACHE_KEY);
                        if (map != null) {
                            return map;
                        }
                        if (dl_peek_dispatcher.getQueueSize() <= 200) break block16;
                        return null;
                    }
                    map = new HashMap();
                    download.setUserData(DOWNLOAD_PEEK_CACHE_KEY, map);
                    dl_peek_dispatcher.dispatch(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void runSupport() {
                            try {
                                Map<String, Object> map = BuddyPluginBeta.this.peekChat(download, false);
                                if (map != null && map.isEmpty()) {
                                    map = null;
                                }
                                if (map == null) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (Throwable throwable) {}
                                } else if (!map.containsKey("m")) {
                                    map.put("m", 0);
                                }
                                Object object = DOWNLOAD_PEEK_CACHE_KEY;
                                synchronized (object) {
                                    download.setUserData(DOWNLOAD_PEEK_CACHE_KEY, map);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            String[] networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
            boolean has_i2p = false;
            String[] stringArray = networks;
            int n = networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    try {
                        return this.peekChat(net, key);
                    }
                    catch (Throwable throwable) {
                    }
                } else if (net == "I2P") {
                    has_i2p = true;
                }
                ++n2;
            }
            if (has_i2p) {
                try {
                    return this.peekChat("I2P", key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> peekChat(String network, String key) {
        Map<String, Object> reply = new HashMap<String, Object>();
        try {
            PluginInterface pi;
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                pi = this.azmsgsync_pi;
            }
            if (pi != null) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("network", network);
                options.put("key", key.getBytes(Constants.UTF_8));
                if (network == "Public") {
                    options.put("timeout", 30000);
                } else {
                    options.put("timeout", 60000);
                    options.put("server_id", this.getSharedAnonEndpoint() ? "dchat_shared" : "dchat");
                }
                reply = (Map)pi.getIPC().invoke("peekMessageHandler", new Object[]{options});
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return reply;
    }

    public List<ChatInstance> getChats() {
        return this.chat_instances_list.getList();
    }

    private void addChatActivity(ChatInstance inst, ChatMessage message) {
        if (inst.getEnableNotificationsPost() && message != null) {
            BuddyPluginViewInterface ui = this.plugin.getSWTUI();
            String str = ui != null ? ui.renderMessage(inst, message) : message.getMessage();
            String chan_name = inst.getName(true);
            int pos = chan_name.lastIndexOf(91);
            if (pos != -1 && chan_name.endsWith("]")) {
                chan_name = chan_name.substring(0, pos);
            }
            str = String.valueOf(chan_name) + ": " + str;
            HashMap<String, String> cb_data = new HashMap<String, String>();
            cb_data.put("allowReAdd", "true");
            cb_data.put("net", inst.getNetwork());
            cb_data.put("key", inst.getKey());
            LocalActivityManager.addLocalActivity(inst.getNetAndKey(), "image.sidebar.chat-overview", str, new String[]{MessageText.getString("label.view")}, ActivityCallback.class, cb_data);
        }
    }

    public long getMyZoneOffset() {
        ZoneId zid = TimeZone.getDefault().toZoneId();
        ZoneOffset zo = LocalDateTime.now().atZone(zid).getOffset();
        return zo.getTotalSeconds();
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Chat (active=" + this.chat_instances_list.size() + ")");
        try {
            writer.indent();
            for (ChatInstance inst : this.chat_instances_list) {
                writer.println("users=" + inst.getEstimatedNodes() + ", msg=" + inst.getMessageCount(true) + ", status=" + inst.getStatus());
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void addListener(ChatManagerListener l, boolean fire_for_existing) {
        this.listeners.add(l);
        if (fire_for_existing) {
            for (ChatInstance inst : this.chat_instances_list) {
                l.chatAdded(inst);
            }
        }
    }

    public void removeListener(ChatManagerListener l) {
        this.listeners.remove(l);
    }

    static /* synthetic */ Map access$25(BuddyPluginBeta buddyPluginBeta) {
        return buddyPluginBeta.chat_instances_map;
    }

    static /* synthetic */ TimerEventPeriodic access$27(BuddyPluginBeta buddyPluginBeta) {
        return buddyPluginBeta.timer;
    }

    static /* synthetic */ void access$28(BuddyPluginBeta buddyPluginBeta, TimerEventPeriodic timerEventPeriodic) {
        buddyPluginBeta.timer = timerEventPeriodic;
    }

    static /* synthetic */ CopyOnWriteList access$29(BuddyPluginBeta buddyPluginBeta) {
        return buddyPluginBeta.listeners;
    }

    public static class ActivityCallback
    implements LocalActivityManager.LocalActivityCallback {
        @Override
        public void actionSelected(String action, Map<String, String> data) {
            String net = data.get("net");
            String key = data.get("key");
            if (net != null && key != null) {
                BuddyPluginUtils.createBetaChat(net, key, null);
            }
        }
    }

    public static class ChatAdapter
    implements ChatListener {
        @Override
        public void updated() {
        }

        @Override
        public void configChanged() {
        }

        @Override
        public void stateChanged(boolean avail) {
        }

        @Override
        public void participantRemoved(ChatParticipant participant) {
        }

        @Override
        public void participantChanged(ChatParticipant participant) {
        }

        @Override
        public void participantAdded(ChatParticipant participant) {
        }

        @Override
        public void messagesChanged() {
        }

        @Override
        public void messageReceived(ChatMessage message, boolean sort_outstanding) {
        }
    }

    public class ChatInstance
    implements DataSourceResolver.ExportableDataSource {
        public static final String OPT_INVISIBLE = "invisible";
        private static final int MSG_HISTORY_MAX = 512;
        private final String network;
        private final String key;
        private boolean is_private_chat;
        private boolean is_invisible_chat;
        private final ChatParticipant private_target;
        private Object binding_lock = new Object();
        private AESemaphore binding_sem;
        private volatile PluginInterface msgsync_pi;
        private volatile Object handler;
        private byte[] my_public_key;
        private byte[] managing_public_key;
        private boolean read_only;
        private int ipc_version;
        private InetSocketAddress my_address;
        private Object chat_lock = this;
        private AtomicInteger message_uid_next = new AtomicInteger();
        private List<ChatMessage> messages = new ArrayList<ChatMessage>();
        private ByteArrayHashMap<String> message_ids = new ByteArrayHashMap();
        private int messages_not_mine_count;
        private ByteArrayHashMap<ChatParticipant> participants = new ByteArrayHashMap();
        private Map<String, List<ChatParticipant>> nick_clash_map = new HashMap<String, List<ChatParticipant>>();
        private CopyOnWriteList<ChatListener> listeners = new CopyOnWriteList();
        private Map<Object, Object> user_data = new HashMap<Object, Object>();
        private LinkedHashMap<String, String> auto_dup_set = new LinkedHashMap<String, String>(500, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > 500;
            }
        };
        private boolean keep_alive;
        private boolean have_interest;
        private Map<String, Object> status;
        private boolean is_shared_nick;
        private String instance_nick;
        private volatile int reference_count;
        private int virtual_reference_count;
        private ChatMessage last_message_requiring_attention;
        private boolean message_outstanding;
        private boolean is_favourite;
        private boolean auto_notify;
        private boolean save_messages;
        private boolean log_messages;
        private boolean auto_mute;
        private boolean enable_notification_posts;
        private boolean disable_new_msg_indications;
        private String display_name;
        private boolean has_been_viewed;
        private volatile String last_bind_fail = null;
        private volatile boolean destroyed;
        private TimerEvent sort_event;
        private boolean sort_force_changed;
        AsyncDispatcher dispatcher = new AsyncDispatcher("sendAsync");

        private ChatInstance(String _network, String _key, ChatParticipant _private_target, boolean _is_private_chat, Map<String, Object> _options) {
            Boolean invis;
            this.network = _network;
            this.key = _key;
            this.private_target = _private_target;
            this.is_private_chat = _is_private_chat;
            this.is_shared_nick = BuddyPluginBeta.this.getSharedNick(this.network, this.key);
            this.instance_nick = BuddyPluginBeta.this.getNick(this.network, this.key);
            if (!this.is_private_chat) {
                this.is_favourite = BuddyPluginBeta.this.getFavourite(this.network, this.key);
                this.save_messages = BuddyPluginBeta.this.getSaveMessages(this.network, this.key);
                this.log_messages = BuddyPluginBeta.this.getLogMessages(this.network, this.key);
                this.auto_mute = BuddyPluginBeta.this.getAutoMute(this.network, this.key);
                this.disable_new_msg_indications = BuddyPluginBeta.this.getDisableNewMsgIndications(this.network, this.key);
                this.display_name = BuddyPluginBeta.this.getDisplayName(this.network, this.key);
            }
            this.enable_notification_posts = BuddyPluginBeta.this.getEnableNotificationsPost(this.network, this.key);
            if (_options != null && (invis = (Boolean)_options.get(OPT_INVISIBLE)) != null && invis.booleanValue()) {
                this.is_invisible_chat = true;
            }
            this.addReference();
        }

        public ChatInstance getClone() throws Exception {
            if (this.is_private_chat) {
                this.addReference();
                return this;
            }
            return BuddyPluginBeta.this.getChat(this.network, this.key);
        }

        @Override
        public DataSourceResolver.ExportedDataSource exportDataSource() {
            return new DataSourceResolver.ExportedDataSource(){

                @Override
                public Class<? extends DataSourceResolver.DataSourceImporter> getExporter() {
                    return BuddyPluginBeta.class;
                }

                @Override
                public Map<String, Object> getExport() {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("network", ChatInstance.this.network);
                    map.put("key", ChatInstance.this.key);
                    String dn = ChatInstance.this.getDisplayName();
                    if (dn != null && !dn.isEmpty()) {
                        map.put("dn", dn);
                    }
                    map.put("vt", ChatInstance.this.getViewType());
                    return map;
                }
            };
        }

        @Override
        public Boolean getBooleanOption(int opt) {
            if (opt == 1) {
                return true;
            }
            if (opt == 0) {
                return !BuddyPluginBeta.this.plugin.getBeta().getStandAloneWindows();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addVirtualReference() {
            Object object = this.chat_lock;
            synchronized (object) {
                ++this.virtual_reference_count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addReference() {
            Object object = this.chat_lock;
            synchronized (object) {
                if (this.isDestroyed()) {
                    Debug.out("Adding reference to a destroyed chat...");
                }
                if (this.virtual_reference_count > 0) {
                    --this.virtual_reference_count;
                } else {
                    ++this.reference_count;
                }
            }
        }

        public int getReferenceCount() {
            return this.reference_count;
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean abbreviated) {
            String dn = this.display_name;
            if (dn != null) {
                if (this.network != "Public") {
                    dn = String.valueOf(MessageText.getString(abbreviated ? "label.anon.medium" : "label.anon")) + " - " + dn;
                }
                return dn;
            }
            String str = this.getShortKey();
            if (abbreviated) {
                return String.valueOf(MessageText.getString(this.network == "Public" ? "label.public.medium" : "label.anon.medium")) + " - '" + str + "'";
            }
            return String.valueOf(MessageText.getString(this.network == "Public" ? "label.public" : "label.anon")) + " - '" + str + "'";
        }

        public String getShortKey() {
            String str = this.key;
            int pos = str.lastIndexOf(91);
            if (pos != -1 && str.endsWith("]")) {
                String temp = str.substring(pos + 1, str.length() - 1);
                if (temp.contains("pk=")) {
                    str = str.substring(0, pos);
                    str = temp.contains("ro=1") ? String.valueOf(str) + "[R]" : String.valueOf(str) + "[M]";
                } else {
                    str = str.substring(0, pos);
                }
            }
            return str;
        }

        public String getShortName() {
            String short_name = this.getName();
            if (short_name.length() > 60) {
                short_name = String.valueOf(short_name.substring(0, 60)) + "...";
            }
            return short_name;
        }

        public String getNetwork() {
            return this.network;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isFavourite() {
            return this.is_favourite;
        }

        public void setAutoNotify(boolean b) {
            this.auto_notify = b;
        }

        public boolean isAutoNotify() {
            return this.auto_notify;
        }

        public boolean isInteresting() {
            return this.have_interest;
        }

        public void setInteresting(boolean b) {
            this.have_interest = b;
        }

        public boolean isStatistics() {
            return this.key.startsWith("Statistics:");
        }

        public void setFavourite(boolean b) {
            if (!this.is_private_chat && b != this.is_favourite) {
                this.is_favourite = b;
                BuddyPluginBeta.this.setFavourite(this.network, this.key, b);
            }
        }

        public void setHasBeenViewed() {
            this.has_been_viewed = true;
        }

        public boolean getHasBeenViewed() {
            return this.has_been_viewed;
        }

        public boolean getSaveMessages() {
            return this.save_messages;
        }

        public void setSaveMessages(boolean b) {
            if (!this.is_private_chat && b != this.save_messages) {
                this.save_messages = b;
                BuddyPluginBeta.this.setSaveMessages(this.network, this.key, b);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("save_messages", b);
                try {
                    this.updateOptions(options);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        public boolean getLogMessages() {
            return this.log_messages;
        }

        public void setLogMessages(boolean b) {
            if (!this.is_private_chat && b != this.log_messages) {
                this.log_messages = b;
                BuddyPluginBeta.this.setLogMessages(this.network, this.key, b);
            }
        }

        public boolean getAutoMute() {
            return this.auto_mute;
        }

        public void setAutoMute(boolean b) {
            if (!this.is_private_chat && b != this.auto_mute) {
                this.auto_mute = b;
                BuddyPluginBeta.this.setAutoMute(this.network, this.key, b);
            }
        }

        public int getViewType() {
            return BuddyPluginBeta.this.getViewType(this.network, this.key);
        }

        public void setViewType(int t) {
            BuddyPluginBeta.this.setViewType(this.network, this.key, t);
        }

        public boolean getDisableNewMsgIndications() {
            return this.disable_new_msg_indications;
        }

        public void setDisableNewMsgIndications(boolean b) {
            if (!this.is_private_chat && b != this.disable_new_msg_indications) {
                this.disable_new_msg_indications = b;
                BuddyPluginBeta.this.setDisableNewMsgIndications(this.network, this.key, b);
            }
        }

        public boolean getEnableNotificationsPost() {
            return this.enable_notification_posts;
        }

        public void setEnableNotificationsPost(boolean b) {
            if (b != this.enable_notification_posts) {
                this.enable_notification_posts = b;
                BuddyPluginBeta.this.setEnableNotificationsPost(this.network, this.key, b);
            }
        }

        public String getDisplayName() {
            return this.display_name;
        }

        public void setDisplayName(String str) {
            if (str != null && str.isEmpty()) {
                str = null;
            }
            this.display_name = str;
            BuddyPluginBeta.this.setDisplayName(this.network, this.key, str);
        }

        public String getDisplayNameEx() {
            String str = this.getDisplayName();
            if (str == null) {
                str = this.getName();
            }
            return str;
        }

        private void setSpammer(ChatParticipant participant, boolean is_spammer) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("pk", participant.getPublicKey());
            options.put("spammer", is_spammer);
            try {
                this.updateOptions(options);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public boolean isManaged() {
            return this.managing_public_key != null;
        }

        public boolean amManager() {
            return this.managing_public_key != null && Arrays.equals(this.my_public_key, this.managing_public_key);
        }

        public boolean isManagedFor(String network, String key) {
            if (this.getNetwork() != network) {
                return false;
            }
            return this.getKey().equals(String.valueOf(key) + "[pk=" + Base32.encode(this.getPublicKey()) + "]");
        }

        public ChatInstance getManagedChannel() throws Exception {
            if (this.isManaged()) {
                throw new Exception("Channel is already managed");
            }
            String new_key = String.valueOf(this.getKey()) + "[pk=" + Base32.encode(this.getPublicKey()) + "]";
            ChatInstance inst = BuddyPluginBeta.this.getChat(this.getNetwork(), new_key);
            return inst;
        }

        public boolean isReadOnlyFor(String network, String key) {
            if (this.getNetwork() != network) {
                return false;
            }
            return this.getKey().equals(String.valueOf(key) + "[pk=" + Base32.encode(this.getPublicKey()) + "&ro=1]");
        }

        public ChatInstance getReadOnlyChannel() throws Exception {
            if (this.isManaged()) {
                throw new Exception("Channel is already managed");
            }
            String new_key = String.valueOf(this.getKey()) + "[pk=" + Base32.encode(this.getPublicKey()) + "&ro=1]";
            ChatInstance inst = BuddyPluginBeta.this.getChat(this.getNetwork(), new_key);
            return inst;
        }

        public boolean isReadOnly() {
            return this.read_only && !this.amManager();
        }

        public String getURL() {
            if (this.network == "Public") {
                return "chat:?" + UrlUtils.encode(this.key);
            }
            return "chat:anon:?" + UrlUtils.encode(this.key);
        }

        public byte[] getPublicKey() {
            return this.my_public_key;
        }

        public boolean isInvisible() {
            return this.is_invisible_chat;
        }

        public boolean isPrivateChat() {
            return this.is_private_chat;
        }

        public boolean isAnonymous() {
            return this.network != "Public";
        }

        public String getNetAndKey() {
            return String.valueOf(this.network) + ": " + this.key;
        }

        public void setKeepAlive(boolean b) {
            this.keep_alive = b;
        }

        public boolean getKeepAlive() {
            return this.keep_alive;
        }

        public String getDefaultNickname() {
            return BuddyPluginBeta.this.pkToString(this.getPublicKey());
        }

        public boolean isSharedNickname() {
            return this.is_shared_nick;
        }

        public void setSharedNickname(boolean _shared) {
            if (_shared != this.is_shared_nick) {
                this.is_shared_nick = _shared;
                BuddyPluginBeta.this.setSharedNick(this.network, this.key, _shared);
                this.updated();
            }
        }

        public String getInstanceNickname() {
            return this.instance_nick;
        }

        public void setInstanceNickname(String _nick) {
            if (!_nick.equals(this.instance_nick)) {
                this.instance_nick = _nick;
                BuddyPluginBeta.this.setNick(this.network, this.key, _nick);
                this.updated();
            }
        }

        public String getNickname(boolean use_default) {
            String nick = this.is_shared_nick ? (this.network == "Public" ? BuddyPluginBeta.this.shared_public_nickname : BuddyPluginBeta.this.shared_anon_nickname) : this.instance_nick;
            if (nick.length() == 0 && use_default) {
                return this.getDefaultNickname();
            }
            return nick;
        }

        private Object getHandler() {
            return this.handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bind(PluginInterface _msgsync_pi, Object _handler, long timeout) throws Exception {
            Object uif;
            if (timeout != -1L && this.getNetwork() == "I2P" && !I2PHelpers.isI2POperational()) {
                return;
            }
            boolean inform_avail = false;
            if (timeout == -1L && (uif = UIFunctionsManager.getUIFunctions()) != null && uif.isUIThread()) {
                timeout = 250L;
            }
            uif = this.binding_lock;
            synchronized (uif) {
                block23: {
                    this.last_bind_fail = null;
                    this.binding_sem = new AESemaphore("bpb:bind");
                    try {
                        Number ipc_v;
                        Boolean ro;
                        Map reply;
                        HashMap<String, Object> options;
                        this.msgsync_pi = _msgsync_pi;
                        if (_handler != null) {
                            this.handler = _handler;
                            try {
                                options = new HashMap();
                                options.put("handler", _handler);
                                options.put("addlistener", this);
                                if (timeout > 0L) {
                                    options.put("timeout", timeout);
                                }
                                reply = (Map)this.msgsync_pi.getIPC().invoke("updateMessageHandler", new Object[]{options});
                                this.my_public_key = (byte[])reply.get("pk");
                                this.managing_public_key = (byte[])reply.get("mpk");
                                ro = (Boolean)reply.get("ro");
                                this.read_only = ro != null && ro != false;
                                ipc_v = (Number)reply.get("ipc_version");
                                this.ipc_version = ipc_v == null ? 1 : ipc_v.intValue();
                                inform_avail = true;
                                break block23;
                            }
                            catch (Throwable e) {
                                throw new Exception(e);
                            }
                        }
                        try {
                            options = new HashMap<String, Object>();
                            options.put("network", this.network);
                            options.put("key", this.key.getBytes(Constants.UTF_8));
                            if (this.private_target != null) {
                                options.put("parent_handler", this.private_target.getChat().getHandler());
                                options.put("target_pk", this.private_target.getPublicKey());
                                options.put("target_contact", this.private_target.getContact());
                            }
                            if (this.network != "Public") {
                                options.put("server_id", BuddyPluginBeta.this.getSharedAnonEndpoint() ? "dchat_shared" : "dchat");
                            }
                            if (timeout > 0L) {
                                options.put("timeout", timeout);
                            }
                            options.put("listener", this);
                            if (this.getSaveMessages()) {
                                options.put("save_messages", true);
                            }
                            reply = (Map)this.msgsync_pi.getIPC().invoke("getMessageHandler", new Object[]{options});
                            this.handler = reply.get("handler");
                            this.my_public_key = (byte[])reply.get("pk");
                            this.managing_public_key = (byte[])reply.get("mpk");
                            ro = (Boolean)reply.get("ro");
                            this.read_only = ro != null && ro != false;
                            ipc_v = (Number)reply.get("ipc_version");
                            this.ipc_version = ipc_v == null ? 1 : ipc_v.intValue();
                            inform_avail = true;
                        }
                        catch (Throwable e) {
                            this.last_bind_fail = Debug.getNestedExceptionMessage(e);
                            throw new Exception(e);
                        }
                    }
                    finally {
                        this.binding_sem.releaseForever();
                        this.binding_sem = null;
                    }
                }
            }
            if (inform_avail) {
                for (ChatListener l : this.listeners) {
                    try {
                        l.stateChanged(true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                String key = this.getKey();
                if (key.startsWith("General: ") || key.startsWith(String.valueOf(Constants.APP_NAME) + ": General: ")) {
                    this.sendLocalMessage("!*" + MessageText.getString("azbuddy.dchat.welcome.general") + "*!", null, 2);
                }
            }
        }

        private void checkRebind() {
            block3: {
                String last_fail = this.last_bind_fail;
                if (last_fail != null) {
                    try {
                        this.bind(this.msgsync_pi, null, 1000L);
                    }
                    catch (Throwable e) {
                        if (last_fail.equals(this.last_bind_fail)) break block3;
                        Debug.out(e);
                    }
                }
            }
        }

        private void updateOptions(Map<String, Object> options) throws Exception {
            if (this.handler == null || this.msgsync_pi == null) {
                Debug.out("No handler!");
            } else {
                options.put("handler", this.handler);
                this.msgsync_pi.getIPC().invoke("updateMessageHandler", new Object[]{options});
            }
        }

        private void unbind() {
            for (ChatListener l : this.listeners) {
                try {
                    l.stateChanged(false);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.handler = null;
            this.msgsync_pi = null;
        }

        public boolean isAvailable() {
            return this.handler != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatMessage[] getHistory() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.messages.toArray(new ChatMessage[this.messages.size()]);
            }
        }

        private void update() {
            PluginInterface current_pi = this.msgsync_pi;
            Object current_handler = this.handler;
            if (current_handler != null && current_pi != null) {
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("handler", current_handler);
                    this.status = (Map)current_pi.getIPC().invoke("getStatus", new Object[]{options});
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.updated();
        }

        private void updated() {
            for (ChatListener l : this.listeners) {
                try {
                    l.updated();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        private void configChanged() {
            for (ChatListener l : this.listeners) {
                try {
                    l.configChanged();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        public void handleDrop(String str) {
        }

        public int getEstimatedNodes() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return -1;
            }
            return ((Number)map.get("node_est")).intValue();
        }

        public int getMessageCount(boolean not_mine) {
            if (not_mine) {
                return this.messages_not_mine_count;
            }
            return this.messages.size();
        }

        public int getIncomingSyncState() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return -3;
            }
            Number in_pending = (Number)map.get("msg_in_pending");
            return in_pending == null ? -2 : in_pending.intValue();
        }

        public int getOutgoingSyncState() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return -3;
            }
            Number out_pending = (Number)map.get("msg_out_pending");
            return out_pending == null ? -2 : out_pending.intValue();
        }

        public boolean isInitialised() {
            Map<String, Object> map = this.status;
            if (map == null) {
                return false;
            }
            int status = ((Number)map.get("status")).intValue();
            return status > 0;
        }

        public String getStatus() {
            if (this.isDestroyed()) {
                return MessageText.getString("azbuddy.dchat.status.destroyed");
            }
            PluginInterface current_pi = this.msgsync_pi;
            Object current_handler = this.handler;
            if (current_pi == null) {
                if (BuddyPluginBeta.this.plugin.isInitializationComplete()) {
                    return MessageText.getString("azbuddy.dchat.status.noplugin");
                }
                return MessageText.getString("ManagerItem.initializing");
            }
            if (current_handler == null) {
                return MessageText.getString("azbuddy.dchat.status.nohandler");
            }
            Map<String, Object> map = this.status;
            if (map == null) {
                return MessageText.getString("azbuddy.dchat.status.notavail");
            }
            int status = ((Number)map.get("status")).intValue();
            int dht_count = ((Number)map.get("dht_nodes")).intValue();
            int nodes_local = ((Number)map.get("nodes_local")).intValue();
            int nodes_live = ((Number)map.get("nodes_live")).intValue();
            int nodes_dying = ((Number)map.get("nodes_dying")).intValue();
            int req_in = ((Number)map.get("req_in")).intValue();
            double req_in_rate = ((Number)map.get("req_in_rate")).doubleValue();
            int req_out_ok = ((Number)map.get("req_out_ok")).intValue();
            int req_out_fail = ((Number)map.get("req_out_fail")).intValue();
            double req_out_rate = ((Number)map.get("req_out_rate")).doubleValue();
            if (status == 0 || status == 1) {
                String arg2;
                String arg1;
                if (this.isPrivateChat()) {
                    arg1 = String.valueOf(MessageText.getString("label.private.chat")) + ": ";
                    arg2 = "";
                } else if (status == 0) {
                    arg1 = String.valueOf(MessageText.getString("pairing.status.initialising")) + ": ";
                    arg2 = "DHT=" + (dht_count < 0 ? "..." : String.valueOf(dht_count)) + ", ";
                } else if (status == 1) {
                    arg1 = "";
                    arg2 = "DHT=" + dht_count + ", ";
                } else {
                    arg1 = "";
                    arg2 = "";
                }
                String arg3 = String.valueOf(nodes_local) + "/" + nodes_live + "/" + nodes_dying;
                String arg4 = String.valueOf(DisplayFormatters.formatDecimal(req_out_rate, 1)) + "/" + DisplayFormatters.formatDecimal(req_in_rate, 1);
                String str = MessageText.getString("azbuddy.dchat.node.status", new String[]{arg1, arg2, arg3, arg4});
                if (this.isReadOnly()) {
                    str = String.valueOf(str) + ", R-";
                } else if (this.amManager()) {
                    str = this.read_only ? String.valueOf(str) + ", R+" : String.valueOf(str) + ", M+";
                } else if (this.isManaged()) {
                    str = String.valueOf(str) + ", M-";
                }
                if (Constants.isCVSVersion()) {
                    str = String.valueOf(str) + ", refs=" + this.reference_count;
                }
                str = String.valueOf(str) + ": '" + this.getShortKey() + "'";
                return str;
            }
            return MessageText.getString("azbuddy.dchat.status.destroyed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortMessages(boolean force_change) {
            Object object = this.chat_lock;
            synchronized (object) {
                if (force_change) {
                    this.sort_force_changed = true;
                }
                if (this.sort_event != null) {
                    return;
                }
                this.sort_event = SimpleTimer.addEvent("msgsort", SystemTime.getOffsetTime(500L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        boolean changed = false;
                        Object object = ChatInstance.this.chat_lock;
                        synchronized (object) {
                            ChatInstance.this.sort_event = null;
                            changed = ChatInstance.this.sortMessagesSupport();
                            if (ChatInstance.this.sort_force_changed) {
                                changed = true;
                                ChatInstance.this.sort_force_changed = false;
                            }
                        }
                        if (changed) {
                            for (ChatListener l : ChatInstance.this.listeners) {
                                l.messagesChanged();
                            }
                        }
                    }
                });
            }
        }

        private boolean sortMessagesSupport() {
            ChatMessage prev_msg;
            int num_messages = this.messages.size();
            ByteArrayHashMap<ChatMessage> id_map = new ByteArrayHashMap<ChatMessage>(num_messages);
            HashMap<ChatMessage, ChatMessage> prev_map = new HashMap<ChatMessage, ChatMessage>(num_messages);
            HashMap<ChatMessage, Object> next_map = new HashMap<ChatMessage, Object>(num_messages);
            for (ChatMessage msg : this.messages) {
                byte[] id = msg.getID();
                id_map.put(id, msg);
            }
            for (ChatMessage msg : this.messages) {
                ChatMessage prev_msg2;
                byte[] prev_id = msg.getPreviousID();
                if (prev_id == null || (prev_msg2 = (ChatMessage)id_map.get(prev_id)) == null) continue;
                msg.setPreviousID(prev_msg2.getID());
                prev_map.put(msg, prev_msg2);
                Object existing = next_map.get(prev_msg2);
                if (existing == null) {
                    next_map.put(prev_msg2, msg);
                    continue;
                }
                if (existing instanceof ChatMessage) {
                    ArrayList<ChatMessage> list = new ArrayList<ChatMessage>();
                    list.add((ChatMessage)existing);
                    list.add(msg);
                    next_map.put(prev_msg2, list);
                    continue;
                }
                ((List)existing).add(msg);
            }
            Comparator<ChatMessage> message_comparator = new Comparator<ChatMessage>(){

                @Override
                public int compare(ChatMessage o1, ChatMessage o2) {
                    return o1.getUID() - o2.getUID();
                }
            };
            TreeSet<ChatMessage> linked_messages = new TreeSet<ChatMessage>(message_comparator);
            linked_messages.addAll(prev_map.keySet());
            block2: while (linked_messages.size() > 0) {
                ChatMessage start = (ChatMessage)linked_messages.iterator().next();
                linked_messages.remove(start);
                ChatMessage current = start;
                int loops = 0;
                while (true) {
                    if (++loops > num_messages) {
                        Debug.out("infinte loop");
                        continue block2;
                    }
                    prev_msg = (ChatMessage)prev_map.get(current);
                    if (prev_msg == null) continue block2;
                    linked_messages.remove(prev_msg);
                    if (prev_msg == start) {
                        prev_map.put(current, null);
                        next_map.put(prev_msg, null);
                        Debug.out("Loopage");
                        continue block2;
                    }
                    current = prev_msg;
                }
            }
            TreeSet<ChatMessage> tree_heads = new TreeSet<ChatMessage>(message_comparator);
            block4: for (ChatMessage msg : this.messages) {
                prev_msg = (ChatMessage)prev_map.get(msg);
                if (prev_msg == null) continue;
                int loops = 0;
                while (true) {
                    if (++loops > num_messages) {
                        Debug.out("infinte loop");
                        continue block4;
                    }
                    ChatMessage prev_prev = (ChatMessage)prev_map.get(prev_msg);
                    if (prev_prev == null) {
                        tree_heads.add(prev_msg);
                        continue block4;
                    }
                    prev_msg = prev_prev;
                }
            }
            HashSet<ChatMessage> remainder_set = new HashSet<ChatMessage>(this.messages);
            List<ChatMessage> result = null;
            for (ChatMessage head : tree_heads) {
                List<ChatMessage> chain = this.flattenTree(head, next_map, num_messages);
                remainder_set.removeAll(chain);
                result = result == null ? chain : this.merge(result, chain);
            }
            if (remainder_set.size() > 0) {
                ArrayList<ChatMessage> remainder = new ArrayList<ChatMessage>(remainder_set);
                Collections.sort(remainder, new Comparator<ChatMessage>(){

                    @Override
                    public int compare(ChatMessage m1, ChatMessage m2) {
                        long l;
                        long t2;
                        long t1 = m1.getSequence();
                        if (t1 == (t2 = m2.getSequence())) {
                            t1 = m1.getTimeStamp();
                            t2 = m2.getTimeStamp();
                        }
                        if ((l = t1 - t2) < 0L) {
                            return -1;
                        }
                        if (l > 0L) {
                            return 1;
                        }
                        return m1.getUID() - m2.getUID();
                    }
                });
                result = result == null ? remainder : this.merge(result, remainder);
            }
            if (result == null) {
                return false;
            }
            boolean changed = false;
            if (this.messages.size() != result.size()) {
                Debug.out("Inconsistent: " + this.messages.size() + "/" + result.size());
                changed = true;
            }
            HashSet<ChatParticipant> new_participants = new HashSet<ChatParticipant>();
            int i = 0;
            while (i < result.size()) {
                ChatMessage chatMessage2 = result.get(i);
                ChatParticipant p = chatMessage2.getParticipant();
                new_participants.add(p);
                if (!changed && this.messages.get(i) != chatMessage2) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                this.messages = result;
                for (ChatParticipant p : new_participants) {
                    p.resetMessages();
                }
                HashSet<ChatParticipant> updated = new HashSet<ChatParticipant>();
                for (ChatMessage chatMessage3 : this.messages) {
                    ChatParticipant p = chatMessage3.getParticipant();
                    if (!p.replayMessage(chatMessage3)) continue;
                    updated.add(p);
                }
                for (ChatParticipant chatParticipant2 : updated) {
                    this.updated(chatParticipant2);
                }
                for (ChatParticipant chatParticipant3 : new_participants) {
                    if (chatParticipant3.getMessageCount(false) != 0 || chatParticipant3.isMe()) continue;
                    this.removeParticipant(chatParticipant3);
                    for (ChatListener l : this.listeners) {
                        l.participantRemoved(chatParticipant3);
                    }
                }
            }
            return changed;
        }

        private List<ChatMessage> flattenTree(ChatMessage head, Map<ChatMessage, Object> next_map, int num_messages) {
            Object entry;
            if (num_messages <= 0) {
                return new ArrayList<ChatMessage>();
            }
            ArrayList<ChatMessage> chain = new ArrayList<ChatMessage>(num_messages);
            ChatMessage msg = head;
            while (true) {
                chain.add(msg);
                --num_messages;
                entry = next_map.get(msg);
                if (!(entry instanceof ChatMessage)) break;
                msg = (ChatMessage)entry;
            }
            if (entry instanceof List) {
                List list = (List)entry;
                List<ChatMessage> current = null;
                for (ChatMessage node : list) {
                    List<ChatMessage> temp = this.flattenTree(node, next_map, num_messages);
                    num_messages -= temp.size();
                    current = current == null ? temp : this.merge(current, temp);
                }
                chain.addAll(current);
            }
            return chain;
        }

        private List<ChatMessage> merge(List<ChatMessage> list1, List<ChatMessage> list2) {
            int size1 = list1.size();
            int size2 = list2.size();
            ArrayList<ChatMessage> result = new ArrayList<ChatMessage>(size1 + size2);
            int pos1 = 0;
            int pos2 = 0;
            while (true) {
                long t2;
                if (pos1 == size1) {
                    int i = pos2;
                    while (i < size2) {
                        result.add(list2.get(i));
                        ++i;
                    }
                    break;
                }
                if (pos2 == size2) {
                    int i = pos1;
                    while (i < size1) {
                        result.add(list1.get(i));
                        ++i;
                    }
                    break;
                }
                ChatMessage m1 = list1.get(pos1);
                ChatMessage m2 = list2.get(pos2);
                long t1 = m1.getSequence();
                if (t1 == (t2 = m2.getSequence())) {
                    t1 = m1.getTimeStamp();
                    t2 = m2.getTimeStamp();
                }
                if (t1 < t2 || t1 == t2 && m1.getUID() < m2.getUID()) {
                    result.add(m1);
                    ++pos1;
                    continue;
                }
                result.add(m2);
                ++pos2;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(Map<String, Object> message_map) throws IPCException {
            AESemaphore sem;
            Object object = this.binding_lock;
            synchronized (object) {
                sem = this.binding_sem;
            }
            if (sem != null) {
                sem.reserve();
            }
            ChatMessage msg = new ChatMessage(this.message_uid_next.incrementAndGet(), message_map);
            ChatParticipant new_participant = null;
            ChatParticipant dead_participant = null;
            boolean sort_outstanding = false;
            byte[] prev_id = msg.getPreviousID();
            Object object2 = this.chat_lock;
            synchronized (object2) {
                ChatParticipant participant;
                int origin;
                byte[] id = msg.getID();
                if (this.message_ids.containsKey(id)) {
                    return;
                }
                this.message_ids.put(id, "");
                int old_msgs = this.messages.size();
                this.messages.add(msg);
                byte[] pk = msg.getPublicKey();
                if (this.messages.size() > 512) {
                    ChatMessage removed = this.messages.remove(0);
                    --old_msgs;
                    this.message_ids.remove(removed.getID());
                    ChatParticipant rem_part = removed.getParticipant();
                    if (rem_part.removeMessage(removed) == 0 && !rem_part.isMe() && !Arrays.equals(pk, rem_part.getPublicKey())) {
                        dead_participant = this.removeParticipant(rem_part);
                    }
                    if (!rem_part.isMe()) {
                        --this.messages_not_mine_count;
                    }
                }
                if ((origin = msg.getFlagOrigin()) != 0) {
                    String auto_msg = msg.getMessage();
                    if (auto_msg.contains("File")) {
                        auto_msg = auto_msg.replace('\\', '/');
                    }
                    Pattern[] patternArray = auto_dup_patterns;
                    int n = patternArray.length;
                    int n2 = 0;
                    block6: while (n2 < n) {
                        Pattern p = patternArray[n2];
                        Matcher m = p.matcher(auto_msg);
                        while (m.find()) {
                            String dup_key = m.group(1);
                            if (this.auto_dup_set.containsKey(dup_key)) {
                                msg.setDuplicate();
                                break block6;
                            }
                            this.auto_dup_set.put(dup_key, "");
                        }
                        ++n2;
                    }
                }
                if ((participant = this.participants.get(pk)) == null) {
                    new_participant = participant = new ChatParticipant(this, pk);
                    this.participants.put(pk, participant);
                    participant.addMessage(msg);
                    if (this.auto_mute && !participant.isMe()) {
                        participant.setIgnored(true);
                    }
                } else {
                    participant.addMessage(msg);
                }
                if (this.log_messages && !msg.isIgnored()) {
                    BuddyPluginBeta.this.logMessage(this, msg);
                }
                if (participant.isMe()) {
                    InetSocketAddress address = msg.getAddress();
                    if (address != null) {
                        this.my_address = address;
                    }
                    if (!(!msg.getFlagFlashOverride() || BuddyPluginBeta.this.getHideRatings() && msg.getFlagOrigin() == 1 || BuddyPluginBeta.this.getHideSearchSubs() && msg.getFlagOrigin() == 3)) {
                        this.last_message_requiring_attention = msg;
                    }
                } else {
                    if (!(msg.isIgnored() || BuddyPluginBeta.this.getHideRatings() && msg.getFlagOrigin() == 1 || BuddyPluginBeta.this.getHideSearchSubs() && msg.getFlagOrigin() == 3)) {
                        this.last_message_requiring_attention = msg;
                    }
                    ++this.messages_not_mine_count;
                }
                if (this.sort_event != null) {
                    sort_outstanding = true;
                } else if (!(old_msgs == 0 || prev_id != null && Arrays.equals(prev_id, this.messages.get(old_msgs - 1).getID()) || msg.getMessageType() != 1)) {
                    this.sortMessages(true);
                    sort_outstanding = true;
                }
            }
            if (dead_participant != null) {
                for (ChatListener l : this.listeners) {
                    l.participantRemoved(dead_participant);
                }
            }
            if (new_participant != null) {
                for (ChatListener l : this.listeners) {
                    l.participantAdded(new_participant);
                }
            }
            for (ChatListener l : this.listeners) {
                l.messageReceived(msg, sort_outstanding);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> chatRequested(Map<String, Object> message_map) throws IPCException {
            AESemaphore sem;
            Object object = this.binding_lock;
            synchronized (object) {
                sem = this.binding_sem;
            }
            if (sem != null) {
                sem.reserve();
            }
            if (this.isStatistics()) {
                throw new IPCException("Private chat disabled for statistical channels");
            }
            if (BuddyPluginBeta.this.private_chat_state == 1) {
                throw new IPCException("Private chat disabled by recipient");
            }
            try {
                ChatParticipant participant;
                Object new_handler = message_map.get("handler");
                byte[] remote_pk = (byte[])message_map.get("pk");
                Object object2 = this.chat_lock;
                synchronized (object2) {
                    participant = this.participants.get(remote_pk);
                }
                if (participant == null) {
                    throw new IPCException("Private chat requires you send at least one message to the main chat first");
                }
                if (BuddyPluginBeta.this.private_chat_state == 2 && !participant.isPinned()) {
                    throw new IPCException("Recipient will only accept private chats from pinned participants");
                }
                BuddyPluginViewInterface ui = BuddyPluginBeta.this.plugin.getSWTUI();
                if (ui == null) {
                    throw new IPCException("Chat unavailable");
                }
                ChatInstance inst = BuddyPluginBeta.this.getChat(participant, new_handler);
                if (!this.isSharedNickname()) {
                    inst.setSharedNickname(false);
                    inst.setInstanceNickname(this.getInstanceNickname());
                }
                ui.openChat(inst);
                HashMap<String, Object> reply = new HashMap<String, Object>();
                reply.put("nickname", participant.getName());
                return reply;
            }
            catch (IPCException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IPCException(e);
            }
        }

        public void sendMessage(Download download) {
            this.sendMessage(this.getMagnet(download, 400), new HashMap<String, Object>());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetIPFilters() {
            Object object = this.chat_lock;
            synchronized (object) {
                for (ChatMessage m : this.messages) {
                    m.resetIPFilters();
                }
            }
        }

        public String getMagnet(Download download, int size_hint) {
            String magnet = UrlUtils.getMagnetURI(download, 80);
            magnet = this.trimMagnet(magnet, size_hint);
            magnet = String.valueOf(magnet) + "&xl=" + download.getTorrentSize();
            DownloadScrapeResult scrape = download.getLastScrapeResult();
            if (scrape != null && scrape.getResponseType() == 1) {
                int seeds = scrape.getSeedCount();
                int leechers = scrape.getNonSeedCount();
                if (seeds != -1) {
                    magnet = String.valueOf(magnet) + "&_s=" + seeds;
                }
                if (leechers != -1) {
                    magnet = String.valueOf(magnet) + "&_l=" + leechers;
                }
            }
            long added = PluginCoreUtils.unwrap(download).getDownloadState().getLongParameter("stats.download.added.time");
            magnet = String.valueOf(magnet) + "&_d=" + added;
            magnet = UrlUtils.addSource(download, magnet, this.getMyAddress());
            magnet = String.valueOf(magnet) + "[[$dn]]";
            return magnet;
        }

        private String trimMagnet(String magnet, int max) {
            while (magnet.length() > max) {
                int pos = magnet.lastIndexOf(38);
                if (pos <= 0) continue;
                String x = magnet.substring(pos + 1);
                if (!x.startsWith("ws=") && !x.startsWith("tr=")) break;
                magnet = magnet.substring(0, pos);
            }
            return magnet;
        }

        public void sendMessage(String message, Map<String, Object> options) {
            this.sendMessage(message, null, options);
        }

        public void sendMessage(final String message, final Map<String, Object> flags, final Map<String, Object> options) {
            this.dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    ChatInstance.this.sendMessageSupport(message, flags, options);
                }
            });
        }

        public void sendRawMessage(final byte[] message, final Map<String, Object> flags, final Map<String, Object> options) {
            this.dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    ChatInstance.this.sendMessageSupport(message, flags, options);
                }
            });
        }

        public void sendLocalMessage(final String message, final String[] args, final int message_type) {
            if (this.ipc_version < 2) {
                return;
            }
            this.dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    String raw_message = message.startsWith("!") && message.endsWith("!") ? message.substring(1, message.length() - 1) : MessageText.getString(message, args);
                    options.put("is_local", true);
                    options.put("message", raw_message);
                    options.put("message_type", message_type);
                    ChatInstance.this.sendMessageSupport("", null, options);
                }
            });
        }

        public void sendControlMessage(final String cmd) {
            if (this.ipc_version < 3) {
                return;
            }
            this.dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("is_control", true);
                    options.put("cmd", cmd);
                    ChatInstance.this.sendMessageSupport("", null, options);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendMessageSupport(Object o_message, Map<String, Object> flags, Map<String, Object> options) {
            Object command;
            if (this.handler == null || this.msgsync_pi == null) {
                Debug.out("No handler/plugin");
                return;
            }
            if (o_message instanceof String) {
                String message = (String)o_message;
                if (message.equals("!dump!")) {
                    Object object = this.chat_lock;
                    synchronized (object) {
                        for (ChatMessage msg : this.messages) {
                            System.out.println(String.valueOf(msg.getTimeStamp()) + ": " + BuddyPluginBeta.this.pkToString(msg.getID()) + ", " + BuddyPluginBeta.this.pkToString(msg.getPreviousID()) + ", " + msg.getSequence() + " - " + msg.getMessage());
                        }
                        return;
                    }
                }
                if (message.equals("!sort!")) {
                    this.sortMessages(false);
                    return;
                }
                if (message.equals("!flood!")) {
                    if (!DEBUG_ENABLED) return;
                    SimpleTimer.addPeriodicEvent("flooder", 1500L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            ChatInstance.this.sendMessage("flood - " + SystemTime.getCurrentTime(), null);
                        }
                    });
                    return;
                }
                if (message.equals("!spongy!")) {
                    MessageDigest md = BGSpongy.getDigest("SHA3-256", 100000L);
                    if (md != null) {
                        byte[] hash = md.digest(new byte[10]);
                        System.out.println("hash=" + ByteFormatter.encodeString(hash));
                    } else {
                        System.out.println("digest is null");
                    }
                } else if (message.equals("!ftux!")) {
                    BuddyPluginBeta.this.plugin.getBeta().setFTUXAccepted(false);
                    return;
                }
                boolean is_me_msg = false;
                if (message.startsWith("/")) {
                    String[] bits = message.split("[\\s]+", 3);
                    command = bits[0].toLowerCase(Locale.US);
                    boolean ok = false;
                    boolean missing_params = false;
                    try {
                        ChatParticipant p;
                        String nick;
                        String key;
                        if (((String)command).equals("/help")) {
                            String link = "https://wiki.biglybt.com/w/Decentralized_Chat";
                            this.sendLocalMessage("label.see.x.for.help", new String[]{link}, 2);
                            ok = true;
                        } else if (((String)command).equals("/join")) {
                            if (bits.length > 1) {
                                bits = message.split("[\\s]+", 2);
                                key = bits[1];
                                if (key.startsWith("\"") && key.endsWith("\"")) {
                                    key = key.substring(1, key.length() - 1);
                                }
                                BuddyPluginBeta.this.getAndShowChat(this.getNetwork(), key);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/nick")) {
                            if (bits.length > 1) {
                                bits = message.split("[\\s]+", 2);
                                this.setSharedNickname(false);
                                this.setInstanceNickname(bits[1]);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/pjoin")) {
                            if (bits.length > 1) {
                                bits = message.split("[\\s]+", 2);
                                key = bits[1];
                                if (key.startsWith("\"") && key.endsWith("\"")) {
                                    key = key.substring(1, key.length() - 1);
                                }
                                BuddyPluginBeta.this.getAndShowChat("Public", key);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/ajoin")) {
                            if (bits.length <= 1) {
                                missing_params = true;
                            } else {
                                if (!BuddyPluginBeta.this.isI2PAvailable()) {
                                    throw new Exception("I2P not available");
                                }
                                bits = message.split("[\\s]+", 2);
                                key = bits[1];
                                if (key.startsWith("\"") && key.endsWith("\"")) {
                                    key = key.substring(1, key.length() - 1);
                                }
                                BuddyPluginBeta.this.getAndShowChat("I2P", key);
                                ok = true;
                            }
                        } else if (((String)command).equals("/msg") || ((String)command).equals("/query")) {
                            if (bits.length > 1) {
                                nick = bits[1];
                                String pm = bits.length == 2 ? "" : bits[2].trim();
                                p = this.getParticipant(nick);
                                if (p == null) {
                                    throw new Exception("Nick not found: " + nick);
                                }
                                if (p.isMe()) {
                                    throw new Exception("Can't chat to yourself");
                                }
                                ChatInstance ci = p.createPrivateChat();
                                if (pm.length() > 0) {
                                    ci.sendMessage(pm, new HashMap<String, Object>());
                                }
                                BuddyPluginBeta.this.showChat(ci);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/me")) {
                            if (bits.length > 1) {
                                is_me_msg = true;
                                o_message = message.substring(3).trim();
                                if (flags == null) {
                                    flags = new HashMap<String, Object>();
                                }
                                flags.put(BuddyPluginBeta.FLAGS_MSG_TYPE_KEY, 1);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/ignore")) {
                            if (bits.length > 1) {
                                nick = bits[1];
                                boolean ignore = true;
                                if (nick.equals("-r") && bits.length > 2) {
                                    nick = bits[2];
                                    ignore = false;
                                }
                                if ((p = this.getParticipant(nick)) == null) {
                                    throw new Exception("Nick not found: " + nick);
                                }
                                p.setIgnored(ignore);
                                this.updated(p);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/control")) {
                            if (this.ipc_version >= 3) {
                                String[] bits2 = message.split("[\\s]+", 2);
                                if (bits2.length <= 1) throw new Exception("Invalid command: " + message);
                                this.sendControlMessage(bits2[1]);
                                ok = true;
                            }
                        } else if (((String)command).equals("/peek")) {
                            if (bits.length > 1) {
                                Map<String, Object> result = BuddyPluginBeta.this.peekChat(this.getNetwork(), message.substring(5).trim());
                                this.sendLocalMessage("!" + result + "!", null, 2);
                                ok = true;
                            } else {
                                missing_params = true;
                            }
                        } else if (((String)command).equals("/clone")) {
                            BuddyPluginBeta.this.getAndShowChat(this.getNetwork(), this.getKey());
                            ok = true;
                        }
                        if (!ok) {
                            if (!missing_params) throw new Exception("Error: Unhandled command: " + message);
                            throw new Exception("Error: Insufficient parameters for '" + (String)command + "'");
                        }
                    }
                    catch (Throwable e) {
                        this.sendLocalMessage("!" + Debug.getNestedExceptionMessage(e) + "!", null, 3);
                    }
                    if (!is_me_msg) {
                        return;
                    }
                }
            }
            try {
                ChatMessage prev_message = null;
                long prev_sequence = -1L;
                command = this.chat_lock;
                synchronized (command) {
                    int pos = this.messages.size() - 1;
                    int missing_seq = 0;
                    while (pos >= 0) {
                        ChatMessage m;
                        if ((m = this.messages.get(pos--)).getMessageType() != 1) continue;
                        if (prev_message == null) {
                            prev_message = m;
                        }
                        if ((prev_sequence = m.getSequence()) > 0L) break;
                        ++missing_seq;
                    }
                    if (prev_message != null) {
                        prev_sequence += (long)missing_seq;
                    }
                }
                options = options == null ? new HashMap<String, Object>() : new HashMap<String, Object>(options);
                options.put("handler", this.handler);
                HashMap<String, Object> payload = new HashMap<String, Object>();
                if (o_message instanceof String) {
                    payload.put("msg", ((String)o_message).getBytes(Constants.UTF_8));
                } else {
                    payload.put("msg", (byte[])o_message);
                }
                payload.put("nick", this.getNickname(false).getBytes(Constants.UTF_8));
                if (prev_message != null) {
                    payload.put("pre", prev_message.getID());
                    payload.put("seq", prev_sequence + 1L);
                }
                if (flags != null) {
                    payload.put(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE, flags);
                }
                if (BuddyPluginBeta.this.plugin.isClassicEnabled() && BuddyPluginBeta.this.getPostFriendKey()) {
                    try {
                        String key_str = BuddyPluginBeta.this.plugin.getPublicKey(!this.isAnonymous());
                        if (key_str != null && !key_str.isEmpty() && !this.getNickname(true).equals(this.getDefaultNickname())) {
                            payload.put("f_pk", Base32.decode(key_str));
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                try {
                    if (this.getNetwork() == "Public") {
                        payload.put("zo", BuddyPluginBeta.this.getMyZoneOffset());
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                options.put("content", BEncoder.encode(payload));
                Map reply = (Map)this.msgsync_pi.getIPC().invoke("sendMessage", new Object[]{options});
                this.have_interest = true;
                return;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public String export() {
            if (this.handler == null || this.msgsync_pi == null) {
                return "";
            }
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("handler", this.handler);
                Map reply = (Map)this.msgsync_pi.getIPC().invoke("exportMessageHandler", new Object[]{options});
                return (String)reply.get("export_data");
            }
            catch (Throwable e) {
                Debug.out(e);
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ChatMessage> getMessages() {
            Object object = this.chat_lock;
            synchronized (object) {
                return new ArrayList<ChatMessage>(this.messages);
            }
        }

        public boolean hasUnseenMessageWithNick() {
            List<ChatMessage> messages = this.getUnseenMessages();
            for (ChatMessage msg : messages) {
                if (msg.getNickLocations().length <= 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ChatMessage> getUnseenMessages() {
            Object object = this.chat_lock;
            synchronized (object) {
                LinkedList<ChatMessage> result = new LinkedList<ChatMessage>();
                if (this.messages.size() > 0) {
                    int loop = 0;
                    while (loop < 2) {
                        ArrayList<ChatMessage> need_fixup = new ArrayList<ChatMessage>();
                        int i = this.messages.size() - 1;
                        while (i >= 0) {
                            ChatMessage msg = this.messages.get(i);
                            if (!msg.isIgnored() && !msg.getParticipant().isMe()) {
                                int seen_state = msg.getSeenState();
                                if (seen_state == 1) break;
                                if (seen_state == 0) {
                                    need_fixup.add(msg);
                                } else {
                                    result.addFirst(msg);
                                }
                            }
                            --i;
                        }
                        if (loop != 0 || need_fixup.size() <= 0) {
                            if (need_fixup.size() <= 0) break;
                            Debug.out("Hmm");
                            break;
                        }
                        this.fixupSeenState(need_fixup);
                        result.clear();
                        ++loop;
                    }
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatParticipant[] getParticipants() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.participants.values().toArray(new ChatParticipant[this.participants.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatParticipant getParticipant(String nick) {
            Object object = this.chat_lock;
            synchronized (object) {
                for (ChatParticipant cp : this.participants.values()) {
                    if (!cp.getName().equals(nick)) continue;
                    return cp;
                }
            }
            return null;
        }

        private ChatParticipant removeParticipant(ChatParticipant p) {
            ChatParticipant result = this.participants.remove(p.getPublicKey());
            Iterator<List<ChatParticipant>> it = this.nick_clash_map.values().iterator();
            while (it.hasNext()) {
                List<ChatParticipant> list = it.next();
                list.remove(p);
                if (!list.isEmpty()) continue;
                it.remove();
            }
            return result;
        }

        protected void updated(ChatParticipant p) {
            for (ChatListener l : this.listeners) {
                l.participantChanged(p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerNick(ChatParticipant p, String old_nick, String new_nick) {
            Object object = this.chat_lock;
            synchronized (object) {
                List<ChatParticipant> list;
                if (old_nick != null) {
                    list = this.nick_clash_map.get(old_nick);
                    if (list != null && list.remove(p)) {
                        if (list.size() == 0) {
                            this.nick_clash_map.remove(old_nick);
                        } else if (list.size() == 1) {
                            list.get(0).setNickClash(false);
                        }
                    } else {
                        Debug.out("inconsistent");
                    }
                }
                if ((list = this.nick_clash_map.get(new_nick)) == null) {
                    list = new ArrayList<ChatParticipant>();
                    this.nick_clash_map.put(new_nick, list);
                }
                if (list.contains(p)) {
                    Debug.out("inconsistent");
                } else {
                    list.add(p);
                    if (list.size() > 1) {
                        p.setNickClash(true);
                        if (list.size() == 2) {
                            list.get(0).setNickClash(true);
                        }
                    } else {
                        p.setNickClash(false);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean getOtherNickClashesHidden(ChatParticipant p) {
            Object object = this.chat_lock;
            synchronized (object) {
                ChatParticipant x;
                List<ChatParticipant> list = this.nick_clash_map.get(p.getName(true));
                if (list == null) return true;
                Iterator<ChatParticipant> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while ((x = iterator.next()) == p || x.isSpammer() || x.isIgnored());
                return false;
            }
        }

        public ChatMessage getLastMessageRequiringAttention() {
            return this.last_message_requiring_attention;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUserData(Object key, Object value) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                this.user_data.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getUserData(Object key) {
            Map<Object, Object> map = this.user_data;
            synchronized (map) {
                return this.user_data.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getMessageOutstanding() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.message_outstanding;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMessageOutstanding(ChatMessage message) {
            boolean outstanding = message != null;
            boolean changed = false;
            BuddyPluginBeta.this.addChatActivity(this, message);
            Object object = this.chat_lock;
            synchronized (object) {
                if (this.message_outstanding == outstanding) {
                    return;
                }
                this.message_outstanding = outstanding;
                changed = true;
                if (!outstanding && this.messages.size() > 0) {
                    ChatMessage last_read_msg = this.messages.get(this.messages.size() - 1);
                    long last_read_time = last_read_msg.getTimeStamp();
                    String last_info = String.valueOf(SystemTime.getCurrentTime() / 1000L) + "/" + last_read_time / 1000L + "/" + Base32.encode(last_read_msg.getID());
                    BuddyPluginBeta.this.setLastMessageInfo(this.network, this.key, last_info);
                }
            }
            if (changed) {
                this.updated();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isOldOutstandingMessage(ChatMessage msg) {
            Object object = this.chat_lock;
            synchronized (object) {
                String info = BuddyPluginBeta.this.getLastMessageInfo(this.network, this.key);
                if (info == null) return false;
                String[] bits = info.split("/");
                try {
                    long old_time_secs = Long.parseLong(bits[0]);
                    long old_msg_secs = Long.parseLong(bits[1]);
                    byte[] old_id = Base32.decode(bits[2]);
                    long msg_secs = msg.getTimeStamp() / 1000L;
                    byte[] id = msg.getID();
                    if (Arrays.equals(id, old_id)) {
                        return true;
                    }
                    long old_cuttoff = old_time_secs - 300L;
                    if (old_msg_secs > old_cuttoff) {
                        old_cuttoff = old_msg_secs;
                    }
                    if (msg_secs <= old_cuttoff) {
                        return true;
                    }
                    if (!this.message_ids.containsKey(old_id)) return false;
                    if (!this.message_ids.containsKey(id)) return false;
                    int msg_index = -1;
                    int old_msg_index = -1;
                    int i = 0;
                    while (true) {
                        if (i >= this.messages.size()) {
                            if (msg_index > old_msg_index) return false;
                            return true;
                        }
                        ChatMessage m = this.messages.get(i);
                        if (m == msg) {
                            msg_index = i;
                        } else if (Arrays.equals(m.getID(), old_id)) {
                            old_msg_index = i;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fixupSeenState(List<ChatMessage> msgs) {
            for (ChatMessage msg : msgs) {
                msg.setSeen(false);
            }
            Object object = this.chat_lock;
            synchronized (object) {
                String info = BuddyPluginBeta.this.getLastMessageInfo(this.network, this.key);
                if (info != null) {
                    String[] bits = info.split("/");
                    try {
                        long old_time_secs = Long.parseLong(bits[0]);
                        long old_msg_secs = Long.parseLong(bits[1]);
                        byte[] old_id = Base32.decode(bits[2]);
                        for (ChatMessage msg : msgs) {
                            long msg_secs = msg.getTimeStamp() / 1000L;
                            byte[] id = msg.getID();
                            if (Arrays.equals(id, old_id)) {
                                msg.setSeen(true);
                                continue;
                            }
                            long old_cuttoff = old_time_secs - 300L;
                            if (old_msg_secs > old_cuttoff) {
                                old_cuttoff = old_msg_secs;
                            }
                            if (msg_secs > old_cuttoff) continue;
                            msg.setSeen(true);
                        }
                        if (this.message_ids.containsKey(old_id)) {
                            HashMap<ChatMessage, Integer> msg_map = new HashMap<ChatMessage, Integer>();
                            int old_msg_index = -1;
                            int i = 0;
                            while (i < this.messages.size()) {
                                ChatMessage m = this.messages.get(i);
                                msg_map.put(m, i);
                                if (Arrays.equals(m.getID(), old_id)) {
                                    old_msg_index = i;
                                }
                                ++i;
                            }
                            for (ChatMessage msg : msgs) {
                                Integer msg_index = (Integer)msg_map.get(msg);
                                if (msg_index == null || msg_index > old_msg_index) continue;
                                msg.setSeen(true);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        public InetSocketAddress getMyAddress() {
            return this.my_address;
        }

        public void addListener(ChatListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ChatListener listener) {
            this.listeners.remove(listener);
        }

        public void remove() {
            this.destroy(true);
            BuddyPluginBeta.this.removeAllOptions(this.network, this.key);
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        public void destroy() {
            this.destroy(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void destroy(boolean force) {
            block45: {
                var3_2 = this.chat_lock;
                synchronized (var3_2) {
                    if (force) {
                        this.reference_count = 0;
                        this.keep_alive = false;
                        this.have_interest = false;
                    } else {
                        --this.reference_count;
                        if (this.reference_count > 0) {
                            return;
                        }
                    }
                    if (!(this.keep_alive || this.have_interest && !this.is_private_chat)) {
                        v0 = do_destroy = this.destroyed == false;
                        if (do_destroy) {
                            this.destroyed = true;
                        }
                    } else {
                        do_destroy = false;
                    }
                }
                if (do_destroy) {
                    block44: {
                        block46: {
                            for (ChatListener l : this.listeners) {
                                try {
                                    l.stateChanged(false);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            try {
                                try {
                                    if (this.handler != null) {
                                        if (this.is_private_chat) {
                                            flags = new HashMap<String, Object>();
                                            flags.put("s", 1);
                                            this.sendMessageSupport("", flags, new HashMap<String, Object>());
                                        }
                                        options = new HashMap<String, Object>();
                                        options.put("handler", this.handler);
                                        var4_5 = (Map)this.msgsync_pi.getIPC().invoke("removeMessageHandler", new Object[]{options});
                                    }
                                    break block44;
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    meta_key = String.valueOf(this.network) + ":" + this.key;
                                    removed = null;
                                    var8_14 = BuddyPluginBeta.access$25(BuddyPluginBeta.this);
                                    synchronized (var8_14) {
                                        inst = (ChatInstance)BuddyPluginBeta.access$25(BuddyPluginBeta.this).remove(meta_key);
                                        if (inst != null) {
                                            removed = inst;
                                            BuddyPluginBeta.access$26(BuddyPluginBeta.this).remove(inst);
                                        }
                                        if (BuddyPluginBeta.access$25(BuddyPluginBeta.this).size() == 0 && BuddyPluginBeta.access$27(BuddyPluginBeta.this) != null) {
                                            BuddyPluginBeta.access$27(BuddyPluginBeta.this).cancel();
                                            BuddyPluginBeta.access$28(BuddyPluginBeta.this, null);
                                        }
                                    }
                                    if (removed == null) break block45;
                                    ** for (l : BuddyPluginBeta.access$29((BuddyPluginBeta)BuddyPluginBeta.this))
                                }
                            }
                            catch (Throwable var5_7) {
                                meta_key = String.valueOf(this.network) + ":" + this.key;
                                removed = null;
                                l = BuddyPluginBeta.access$25(BuddyPluginBeta.this);
                                synchronized (l) {
                                    inst = (ChatInstance)BuddyPluginBeta.access$25(BuddyPluginBeta.this).remove(meta_key);
                                    if (inst != null) {
                                        removed = inst;
                                        BuddyPluginBeta.access$26(BuddyPluginBeta.this).remove(inst);
                                    }
                                    if (BuddyPluginBeta.access$25(BuddyPluginBeta.this).size() == 0 && BuddyPluginBeta.access$27(BuddyPluginBeta.this) != null) {
                                        BuddyPluginBeta.access$27(BuddyPluginBeta.this).cancel();
                                        BuddyPluginBeta.access$28(BuddyPluginBeta.this, null);
                                    }
                                }
                                if (removed == null) break block46;
                                ** for (l : BuddyPluginBeta.access$29((BuddyPluginBeta)BuddyPluginBeta.this))
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    l.chatRemoved(removed);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                continue;
lbl68:
                                // 1 sources

                                break block45;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    l.chatRemoved(removed);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                continue;
                            }
                        }
                        throw var5_7;
                    }
                    meta_key = String.valueOf(this.network) + ":" + this.key;
                    removed = null;
                    l = BuddyPluginBeta.access$25(BuddyPluginBeta.this);
                    synchronized (l) {
                        inst = (ChatInstance)BuddyPluginBeta.access$25(BuddyPluginBeta.this).remove(meta_key);
                        if (inst != null) {
                            removed = inst;
                            BuddyPluginBeta.access$26(BuddyPluginBeta.this).remove(inst);
                        }
                        if (BuddyPluginBeta.access$25(BuddyPluginBeta.this).size() == 0 && BuddyPluginBeta.access$27(BuddyPluginBeta.this) != null) {
                            BuddyPluginBeta.access$27(BuddyPluginBeta.this).cancel();
                            BuddyPluginBeta.access$28(BuddyPluginBeta.this, null);
                        }
                    }
                    if (removed != null) {
                        for (Object l : BuddyPluginBeta.access$29(BuddyPluginBeta.this)) {
                            try {
                                l.chatRemoved(removed);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface ChatListener {
        public void messageReceived(ChatMessage var1, boolean var2);

        public void messagesChanged();

        public void participantAdded(ChatParticipant var1);

        public void participantChanged(ChatParticipant var1);

        public void participantRemoved(ChatParticipant var1);

        public void stateChanged(boolean var1);

        public void updated();

        public void configChanged();
    }

    public static interface ChatManagerListener {
        public void chatAdded(ChatInstance var1);

        public void chatRemoved(ChatInstance var1);
    }

    public class ChatMessage {
        public static final int MT_NORMAL = 1;
        public static final int MT_INFO = 2;
        public static final int MT_ERROR = 3;
        protected static final int SEEN_UNKNOWN = 0;
        protected static final int SEEN_YES = 1;
        protected static final int SEEN_NO = 2;
        private final int uid;
        private final Map<String, Object> map;
        private WeakReference<Map<String, Object>> payload_ref;
        private final byte[] message_id;
        private final long timestamp;
        private ChatParticipant participant;
        private byte[] previous_id;
        private long sequence;
        private boolean is_ignored;
        private boolean is_duplicate;
        private Boolean is_ip_filtered;
        private boolean is_nick_clash;
        private int seen_state = 0;
        private int[] nick_locations;
        private byte[] friend_key;
        private long zone_offset;

        private ChatMessage(int _uid, Map<String, Object> _map) {
            this.uid = _uid;
            this.map = _map;
            this.message_id = (byte[])this.map.get("id");
            this.timestamp = SystemTime.getCurrentTime() - (long)this.getAgeWhenReceived() * 1000L;
            Map<String, Object> payload = this.getPayload();
            this.previous_id = (byte[])payload.get("pre");
            Number l_seq = (Number)payload.get("seq");
            this.sequence = l_seq == null ? 0L : l_seq.longValue();
            this.friend_key = (byte[])payload.get("f_pk");
            Number l_zo = (Number)payload.get("zo");
            this.zone_offset = l_zo == null ? Long.MIN_VALUE : l_zo.longValue();
        }

        protected int getUID() {
            return this.uid;
        }

        private void setParticipant(ChatParticipant p) {
            this.participant = p;
        }

        public ChatParticipant getParticipant() {
            return this.participant;
        }

        private byte[] getFriendKey() {
            return this.friend_key;
        }

        public long getZoneOffset() {
            return this.zone_offset;
        }

        private void setNickClash(boolean clash) {
            this.is_nick_clash = clash;
        }

        public boolean isNickClash() {
            return this.is_nick_clash;
        }

        public boolean isNickClash(boolean ignore_hidden) {
            if (this.is_nick_clash && ignore_hidden) {
                return this.participant.isNickClash(true);
            }
            return this.is_nick_clash;
        }

        public void setSeen(boolean is_seen) {
            this.seen_state = is_seen ? 1 : 2;
        }

        public int getSeenState() {
            return this.seen_state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getNickLocations() {
            ChatMessage chatMessage2 = this;
            synchronized (chatMessage2) {
                if (this.nick_locations == null) {
                    if (this.participant == null) {
                        return new int[0];
                    }
                    String my_nick = this.participant.getChat().getNickname(true);
                    my_nick = my_nick.replaceAll(" ", "\u00a0");
                    int nick_len = my_nick.length();
                    ArrayList<Integer> hits = new ArrayList<Integer>();
                    if (my_nick.length() > 0) {
                        String text = this.getMessage();
                        int text_len = text.length();
                        int pos = 0;
                        while (pos < text_len) {
                            int nick_end;
                            if ((pos = text.indexOf(my_nick, pos)) < 0) break;
                            boolean match = true;
                            if (pos > 0 && Character.isLetterOrDigit(text.charAt(pos - 1))) {
                                match = false;
                            }
                            if ((nick_end = pos + nick_len) < text_len && Character.isLetterOrDigit(text.charAt(nick_end))) {
                                match = false;
                            }
                            if (match) {
                                hits.add(pos);
                            }
                            pos += nick_len;
                        }
                    }
                    if (hits.size() == 0) {
                        this.nick_locations = new int[0];
                    } else {
                        this.nick_locations = new int[hits.size() + 1];
                        this.nick_locations[0] = nick_len;
                        int i = 0;
                        while (i < hits.size()) {
                            this.nick_locations[i + 1] = (Integer)hits.get(i);
                            ++i;
                        }
                    }
                }
                return this.nick_locations;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getPayload() {
            ChatMessage chatMessage2 = this;
            synchronized (chatMessage2) {
                Map<String, Object> payload = null;
                if (this.payload_ref != null && (payload = (HashMap<String, Object>)this.payload_ref.get()) != null) {
                    return payload;
                }
                try {
                    byte[] content_bytes = (byte[])this.map.get("content");
                    if (content_bytes != null && content_bytes.length > 0) {
                        payload = BDecoder.decode(content_bytes);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (payload == null) {
                    payload = new HashMap<String, Object>();
                }
                this.payload_ref = new WeakReference(payload);
                return payload;
            }
        }

        private int getMessageStatus() {
            Number status;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null && (status = (Number)flags.get(BuddyPluginBeta.FLAGS_MSG_STATUS_KEY)) != null) {
                return status.intValue();
            }
            return 0;
        }

        private boolean getFlagFlashOverride() {
            Number override;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null && (override = (Number)flags.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null) {
                return override.intValue() != 0;
            }
            return false;
        }

        public int getFlagOrigin() {
            Number origin;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null && (origin = (Number)flags.get(BuddyPluginBeta.FLAGS_MSG_ORIGIN_KEY)) != null) {
                return origin.intValue();
            }
            String msg_text = this.getMessage();
            if (msg_text.startsWith("See http://wiki.vuze.com/w/Swarm_Merging") || msg_text.startsWith("See http://wiki.biglybt.com/w/Swarm_Merging")) {
                return 1;
            }
            return 0;
        }

        public int getFlagType() {
            Number type;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get(BuddyPluginBeta.FLAGS_MSG_FLASH_OVERRIDE)) != null && (type = (Number)flags.get(BuddyPluginBeta.FLAGS_MSG_TYPE_KEY)) != null) {
                return type.intValue();
            }
            return 0;
        }

        public String getMessage() {
            try {
                byte[] msg_bytes;
                String report = (String)this.map.get("error");
                if (report != null) {
                    if (report.length() > 2 && report.charAt(1) == ':') {
                        return report.substring(2);
                    }
                    return report;
                }
                if (this.getMessageStatus() == 1) {
                    return MessageText.getString("azbuddy.dchat.hasquit", new String[]{this.participant == null ? "<unknown>" : this.participant.getName()});
                }
                Map<String, Object> payload = this.getPayload();
                if (payload != null && (msg_bytes = (byte[])payload.get("msg")) != null) {
                    return new String(msg_bytes, Constants.UTF_8);
                }
                return new String((byte[])this.map.get("content"), Constants.UTF_8);
            }
            catch (Throwable e) {
                Debug.out(e);
                return "";
            }
        }

        public byte[] getRawMessage() {
            byte[] msg_bytes;
            block6: {
                block5: {
                    try {
                        String report = (String)this.map.get("error");
                        if (report == null) break block5;
                        return null;
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        return null;
                    }
                }
                if (this.getMessageStatus() != 1) break block6;
                return null;
            }
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (msg_bytes = (byte[])payload.get("msg")) != null) {
                return msg_bytes;
            }
            return (byte[])this.map.get("content");
        }

        public int getMessageType() {
            return this.getMessageType(true);
        }

        private int getMessageType(boolean treat_quit_as_info) {
            String report = (String)this.map.get("error");
            if (report == null) {
                if (treat_quit_as_info && this.getMessageStatus() == 1) {
                    return 2;
                }
                return 1;
            }
            if (report.length() < 2 || report.charAt(1) != ':') {
                return 3;
            }
            char type = report.charAt(0);
            if (type == 'i') {
                return 2;
            }
            return 3;
        }

        public void setDuplicate() {
            this.is_duplicate = true;
        }

        void resetIPFilters() {
            this.is_ip_filtered = null;
        }

        public boolean isIPFiltered() {
            if (BuddyPluginBeta.this.getUseIPFilter()) {
                if (this.participant != null && this.participant.isMe()) {
                    return false;
                }
                if (this.is_ip_filtered == null) {
                    this.is_ip_filtered = BuddyPluginBeta.this.ip_filter.isInRange(AddressUtils.getHostAddress(this.getAddress()), "D-Chat", null, false, true);
                }
                return this.is_ip_filtered;
            }
            return false;
        }

        public boolean isIgnored() {
            if (this.isIPFiltered()) {
                return true;
            }
            return this.is_duplicate || this.is_ignored;
        }

        public void setIgnored(boolean b) {
            this.is_ignored = b;
        }

        public byte[] getID() {
            return this.message_id;
        }

        public byte[] getPreviousID() {
            return this.previous_id;
        }

        private void setPreviousID(byte[] pid) {
            this.previous_id = pid;
        }

        public long getSequence() {
            return this.sequence;
        }

        public byte[] getPublicKey() {
            return (byte[])this.map.get("pk");
        }

        public Map<String, Object> getContact() {
            return (Map)this.map.get("contact");
        }

        public InetSocketAddress getAddress() {
            return (InetSocketAddress)this.map.get("address");
        }

        private int getAgeWhenReceived() {
            return ((Number)this.map.get("age")).intValue();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public String getNickName() {
            Object nick;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (nick = (byte[])payload.get("nick")) != null) {
                try {
                    String str = new String((byte[])nick, Constants.UTF_8);
                    if (str.length() > 0) {
                        return str;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.getMessageType(false) != 1 && ((String)(nick = (Object)this.participant.getChat().getNickname(false))).length() > 0) {
                return nick;
            }
            return BuddyPluginBeta.this.pkToString(this.getPublicKey());
        }

        public String getString() {
            return "a=" + new SimpleDateFormat("D HH:mm:ss").format(this.getTimeStamp()) + ", i=" + BuddyPluginBeta.this.pkToString(this.message_id) + ", p=" + BuddyPluginBeta.this.pkToString(this.previous_id) + ": " + this.getMessage();
        }
    }

    public class ChatParticipant {
        private final ChatInstance chat;
        private final byte[] pk;
        private String nickname;
        private boolean is_ignored;
        private boolean is_spammer;
        private boolean is_pinned;
        private boolean nick_clash;
        private List<ChatMessage> participant_messages = new ArrayList<ChatMessage>();
        private Boolean is_me;
        private byte[] friend_key;
        private long zone_offset;
        private List<String> profile_data_cache;
        private List<String> profile_data;
        private boolean profile_data_peeked;
        private long profile_data_set;

        private ChatParticipant(ChatInstance _chat, byte[] _pk) {
            String old_pinned_key;
            boolean was_pinned;
            this.chat = _chat;
            this.pk = _pk;
            this.nickname = BuddyPluginBeta.this.pkToString(this.pk);
            Map props = COConfigurationManager.getMapParameter(this.getPropsKey(), null);
            if (props != null) {
                this.is_pinned = MapUtils.getMapBoolean(props, "pinned", false);
                this.is_ignored = MapUtils.getMapBoolean(props, "ignored", false);
                this.profile_data_cache = BDecoder.decodeStrings((List)props.get("profile"));
            }
            if (was_pinned = COConfigurationManager.getBooleanParameter(old_pinned_key = "azbuddy.chat.pinned." + ByteFormatter.encodeString(this.pk, 0, 16), false)) {
                COConfigurationManager.removeParameter(old_pinned_key);
                this.setPinned(true);
            }
            this.chat.registerNick(this, null, this.nickname);
        }

        public ChatInstance getChat() {
            return this.chat;
        }

        public byte[] getPublicKey() {
            return this.pk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> getContact() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                block4: {
                    if (!this.participant_messages.isEmpty()) break block4;
                    return null;
                }
                return this.participant_messages.get(this.participant_messages.size() - 1).getContact();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetSocketAddress getAddress() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                block4: {
                    if (!this.participant_messages.isEmpty()) break block4;
                    return null;
                }
                return this.participant_messages.get(this.participant_messages.size() - 1).getAddress();
            }
        }

        public boolean isMe() {
            if (this.is_me != null) {
                return this.is_me;
            }
            byte[] chat_key = this.chat.getPublicKey();
            if (chat_key != null) {
                this.is_me = Arrays.equals(this.pk, chat_key);
            }
            return this.is_me == null ? false : this.is_me;
        }

        public String getName() {
            return this.getName(true);
        }

        public String getName(boolean use_nick) {
            if (use_nick) {
                return this.nickname;
            }
            return BuddyPluginBeta.this.pkToString(this.pk);
        }

        public boolean hasNickname() {
            return !this.nickname.equals(BuddyPluginBeta.this.pkToString(this.pk));
        }

        public String getFriendKey() {
            byte[] fk = this.friend_key;
            return fk == null ? null : Base32.encode(fk);
        }

        public int getFriendStatus() {
            boolean is_buddy;
            String fk = this.getFriendKey();
            if (fk == null) {
                return 0;
            }
            BuddyPluginBuddy buddy = BuddyPluginBeta.this.plugin.getBuddyFromPublicKey(fk);
            boolean bl = is_buddy = buddy != null && buddy.isAuthorised() && !buddy.isTransient();
            if (is_buddy) {
                return buddy.isConnected() ? 2 : 1;
            }
            return 0;
        }

        protected void checkProfileData() {
            String fk = this.getFriendKey();
            if (fk != null) {
                if (this.profile_data != null && this.getProfileDataAgeMillis() < 3600000L) {
                    return;
                }
                this.profile_data_peeked = true;
                BuddyPluginBuddy buddy = BuddyPluginBeta.this.plugin.peekBuddy(!this.chat.isAnonymous(), fk);
                if (buddy != null) {
                    long age;
                    if (buddy.isTransient() && (age = this.getProfileDataAgeMillis()) >= 0L && age < 3600000L) {
                        buddy.remove();
                        return;
                    }
                    buddy.getProfileInfo((profile_info, failed) -> {
                        this.setProfileData(profile_info, failed);
                        if (buddy.isTransient()) {
                            buddy.remove();
                        }
                    });
                }
            }
        }

        public String getZoneOffset() {
            long zo = this.zone_offset;
            if (zo == Long.MIN_VALUE) {
                return MessageText.getString("SpeedView.stats.unknown");
            }
            long my_zo = BuddyPluginBeta.this.getMyZoneOffset();
            if (my_zo == zo) {
                return "0";
            }
            String str = new SimpleDateFormat("E hh:mm a").format(new Date(SystemTime.getCurrentTime() + (zo - my_zo) * 1000L));
            return this.formatZone(zo) + " (" + this.formatZone(my_zo) + ") -> " + this.formatZone(zo - my_zo) + " -> " + str;
        }

        private String formatZone(long zone_secs) {
            long z = Math.abs(zone_secs);
            long hour = z / 3600L;
            long sec = z % 3600L;
            String str = String.valueOf(zone_secs >= 0L ? "+" : "-") + String.valueOf(hour);
            if (sec != 0L) {
                String m = String.valueOf(sec / 60L);
                if (m.length() < 2) {
                    m = "0" + m;
                }
                str = String.valueOf(str) + ":" + m;
            }
            return str;
        }

        public List<String> getProfileData() {
            String fk = this.getFriendKey();
            if (fk != null) {
                boolean is_pub;
                boolean bl = is_pub = !this.chat.isAnonymous();
                if (fk.equals(BuddyPluginBeta.this.plugin.getPublicKey(is_pub))) {
                    InetSocketAddress ip;
                    List<String> info = BuddyPluginBeta.this.plugin.getProfileInfo(is_pub);
                    BuddyPluginBuddy buddy = BuddyPluginBeta.this.plugin.getBuddyFromPublicKey(fk);
                    if (buddy != null && (ip = buddy.getIP()) != null) {
                        ArrayList<String> result = new ArrayList<String>();
                        for (String i : info) {
                            if (i.contains("{ip}")) {
                                String address = AddressUtils.getHostAddress(ip);
                                if (ip.getAddress() instanceof Inet6Address && i.contains("://")) {
                                    address = "[" + address + "]";
                                }
                                i = i.replaceAll("(?i)\\Q${ip}\\E", address);
                            }
                            if (i.contains("{ip4}")) {
                                InetSocketAddress ip4 = buddy.getLatestIP(true);
                                if (ip4 == null) continue;
                                i = i.replaceAll("(?i)\\Q${ip4}\\E", AddressUtils.getHostAddress(ip4));
                            }
                            if (i.contains("{ip6}")) {
                                InetSocketAddress ip6 = buddy.getLatestIP(false);
                                if (ip6 == null) continue;
                                String address = AddressUtils.getHostAddress(ip6);
                                if (i.contains("://")) {
                                    address = "[" + address + "]";
                                }
                                i = i.replaceAll("(?i)\\Q${ip6}\\E", address);
                            }
                            result.add(i);
                        }
                        info = result;
                    }
                    return info;
                }
            }
            if (this.profile_data == null && !this.profile_data_peeked) {
                this.checkProfileData();
            }
            return this.profile_data == null ? this.profile_data_cache : this.profile_data;
        }

        public void setProfileData(List<String> d, boolean failed) {
            this.profile_data_set = SystemTime.getMonotonousTime();
            if (!failed) {
                this.profile_data = d;
                this.profile_data_cache = null;
                if (!this.isMe()) {
                    this.setProperty("profile", d);
                }
                this.chat.updated(this);
            }
        }

        private long getProfileDataAgeMillis() {
            if (this.profile_data_set == 0L) {
                return -1L;
            }
            return SystemTime.getMonotonousTime() - this.profile_data_set;
        }

        private void addMessage(ChatMessage message) {
            String new_nickname;
            this.participant_messages.add(message);
            message.setParticipant(this);
            if (this.is_spammer && BuddyPluginBeta.this.getUseIPFilter() && !message.isIPFiltered()) {
                BuddyPluginBeta.this.ip_filter.ban(AddressUtils.getHostAddress(message.getAddress()), "D-Chat/" + this.chat.getName() + "/" + this.getName(), false);
            }
            message.setIgnored(this.is_ignored || this.is_spammer);
            if (message.getMessageType() == 1) {
                this.friend_key = message.getFriendKey();
                this.zone_offset = message.getZoneOffset();
            }
            if (!this.nickname.equals(new_nickname = message.getNickName())) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                message.setNickClash(this.isNickClash());
                this.nickname = new_nickname;
            } else {
                message.setNickClash(this.isNickClash());
            }
            this.chat.updated(this);
        }

        private boolean replayMessage(ChatMessage message) {
            String new_nickname;
            this.participant_messages.add(message);
            message.setIgnored(this.is_ignored || this.is_spammer);
            if (message.getMessageType() == 1) {
                this.friend_key = message.getFriendKey();
                this.zone_offset = message.getZoneOffset();
            }
            if (!this.nickname.equals(new_nickname = message.getNickName())) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                message.setNickClash(this.isNickClash());
                this.nickname = new_nickname;
                return true;
            }
            message.setNickClash(this.isNickClash());
            return false;
        }

        private int removeMessage(ChatMessage message) {
            this.participant_messages.remove(message);
            return this.participant_messages.size();
        }

        private void resetMessages() {
            String new_nickname = BuddyPluginBeta.this.pkToString(this.pk);
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                this.nickname = new_nickname;
            }
            this.participant_messages.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ChatMessage> getMessages() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                return new ArrayList<ChatMessage>(this.participant_messages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMessageCount(boolean explicit_only) {
            if (explicit_only) {
                int total = 0;
                Object object = this.chat.chat_lock;
                synchronized (object) {
                    for (ChatMessage message : this.participant_messages) {
                        if (message.getMessageType() != 1 || message.isIgnored()) continue;
                        ++total;
                    }
                }
                return total;
            }
            return this.participant_messages.size();
        }

        public boolean isIgnored() {
            return this.is_ignored;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIgnored(boolean b) {
            if (b != this.is_ignored) {
                this.is_ignored = b;
                this.setProperty("ignored", b);
                Object object = this.chat.chat_lock;
                synchronized (object) {
                    for (ChatMessage message : this.participant_messages) {
                        message.setIgnored(b || this.is_spammer);
                    }
                }
            }
        }

        public boolean isSpammer() {
            return this.is_spammer;
        }

        public boolean canSpammer() {
            return this.participant_messages.size() >= 5 && !this.is_spammer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSpammer(boolean b) {
            if (b != this.is_spammer) {
                this.is_spammer = b;
                this.setProperty("spammer", b);
                this.chat.setSpammer(this, b);
                HashSet<String> addresses = new HashSet<String>();
                Object object = this.chat.chat_lock;
                synchronized (object) {
                    for (ChatMessage message : this.participant_messages) {
                        message.setIgnored(b || this.is_ignored);
                        InetSocketAddress originator = message.getAddress();
                        addresses.add(AddressUtils.getHostAddress(originator));
                    }
                }
                if (BuddyPluginBeta.this.getUseIPFilter()) {
                    for (String a : addresses) {
                        if (b) {
                            BuddyPluginBeta.this.ip_filter.ban(a, "D-Chat/" + this.chat.getName() + "/" + this.getName(), false);
                            continue;
                        }
                        BuddyPluginBeta.this.ip_filter.unban(a);
                    }
                }
            }
        }

        public boolean isPinned() {
            return this.is_pinned;
        }

        private String getPropsKey() {
            return "azbuddy.chat.props." + ByteFormatter.encodeString(this.pk, 0, 16);
        }

        public void setPinned(boolean b) {
            if (b != this.is_pinned) {
                this.is_pinned = b;
                this.setProperty("pinned", b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setProperty(String name, boolean value) {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                String key = this.getPropsKey();
                HashMap<String, Long> props = COConfigurationManager.getMapParameter(key, null);
                if (props == null) {
                    if (!value) {
                        return;
                    }
                    props = new HashMap<String, Long>();
                } else {
                    props = BEncoder.cloneMap(props);
                }
                if (value) {
                    props.put(name, 1L);
                } else {
                    props.remove(name);
                }
                if (props.isEmpty()) {
                    COConfigurationManager.removeParameter(key);
                } else {
                    COConfigurationManager.setParameter(key, props);
                }
                COConfigurationManager.setDirty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setProperty(String name, List<String> value) {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                HashMap<String, List<String>> new_props;
                String key = this.getPropsKey();
                Map old_props = COConfigurationManager.getMapParameter(key, null);
                if (old_props == null) {
                    if (value == null) {
                        return;
                    }
                    new_props = new HashMap<String, List<String>>();
                } else {
                    new_props = BEncoder.cloneMap(old_props);
                }
                if (value != null) {
                    new_props.put(name, value);
                } else {
                    new_props.remove(name);
                }
                if (new_props.isEmpty()) {
                    COConfigurationManager.removeParameter(key);
                    COConfigurationManager.setDirty();
                } else if (!BEncoder.mapsAreIdentical(old_props, new_props)) {
                    COConfigurationManager.setParameter(key, new_props);
                    COConfigurationManager.setDirty();
                }
            }
        }

        public boolean isNickClash() {
            return this.nick_clash;
        }

        public boolean isNickClash(boolean ignore_hidden) {
            if (ignore_hidden && this.nick_clash) {
                return !this.chat.getOtherNickClashesHidden(this);
            }
            return this.nick_clash;
        }

        private void setNickClash(boolean b) {
            this.nick_clash = b;
        }

        public ChatInstance createPrivateChat() throws Exception {
            ChatInstance inst = BuddyPluginBeta.this.getChat(this);
            ChatInstance parent = this.getChat();
            if (!parent.isSharedNickname()) {
                inst.setSharedNickname(false);
                inst.setInstanceNickname(parent.getInstanceNickname());
            }
            return inst;
        }
    }

    public static interface FTUXStateChangeListener {
        public void stateChanged(boolean var1);
    }
}

