/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.security.CryptoHandler;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.security.CryptoManagerKeyListener;
import com.biglybt.core.security.CryptoManagerPasswordException;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.core.util.protocol.azplug.AZPluginConnection;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.ddb.DistributedDatabaseContact;
import com.biglybt.pif.ddb.DistributedDatabaseEvent;
import com.biglybt.pif.ddb.DistributedDatabaseKey;
import com.biglybt.pif.ddb.DistributedDatabaseListener;
import com.biglybt.pif.ddb.DistributedDatabaseValue;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.messaging.MessageException;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.messaging.generic.GenericMessageHandler;
import com.biglybt.pif.messaging.generic.GenericMessageRegistration;
import com.biglybt.pif.messaging.generic.GenericMessageStartpoint;
import com.biglybt.pif.utils.UTTimerEvent;
import com.biglybt.pif.utils.UTTimerEventPerformer;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pif.utils.security.SEPublicKey;
import com.biglybt.pif.utils.security.SEPublicKeyLocator;
import com.biglybt.pif.utils.security.SESecurityManager;
import com.biglybt.plugin.magnet.MagnetPlugin;
import com.biglybt.plugin.magnet.MagnetPluginProgressListener;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2;
import com.biglybt.plugin.net.buddy.BuddyPluginAZ2TrackerListener;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddyRequestListener;
import com.biglybt.plugin.net.buddy.BuddyPluginException;
import com.biglybt.plugin.net.buddy.BuddyPluginPasswordException;
import com.biglybt.util.MapUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class BuddyPluginNetwork {
    public static final int VERSION_INITIAL = 1;
    public static final int VERSION_CHAT = 2;
    public static final int VERSION_CURRENT = 2;
    public static final int MT_V3_CHAT = 1;
    public static final int MAX_MESSAGE_SIZE = 0x400000;
    public static final int SUBSYSTEM_INTERNAL = 0;
    public static final int SUBSYSTEM_AZ2 = 1;
    public static final int SUBSYSTEM_AZ3 = 2;
    protected static final int SUBSYSTEM_MSG_TYPE_BASE = 1024;
    protected static final int RT_INTERNAL_REQUEST_PING = 1;
    protected static final int RT_INTERNAL_REPLY_PING = 2;
    protected static final int RT_INTERNAL_REQUEST_CLOSE = 3;
    protected static final int RT_INTERNAL_REPLY_CLOSE = 4;
    protected static final int RT_INTERNAL_FRAGMENT = 5;
    protected static final boolean TRACE = false;
    private static final int MAX_UNAUTH_BUDDIES = 1024;
    private static final int BUDDY_STATUS_CHECK_PERIOD_MIN = 180000;
    private static final int BUDDY_STATUS_CHECK_PERIOD_INC = 60000;
    private static final int TIMER_PERIOD = 5000;
    protected static final int STATUS_REPUBLISH_PERIOD = 600000;
    private static final int STATUS_REPUBLISH_PERIOD_WHEN_DIVERSIFIED = 3600000;
    private static final int STATUS_REPUBLISH_TICKS = 120;
    private static final int CHECK_YGM_PERIOD = 300000;
    private static final int CHECK_YGM_TICKS = 60;
    private static final int YGM_BLOOM_LIFE_PERIOD = 3600000;
    private static final int YGM_BLOOM_LIFE_TICKS = 720;
    private static final int SAVE_CONFIG_PERIOD = 60000;
    private static final int SAVE_CONFIG_TICKS = 12;
    public static final int PERSISTENT_MSG_RETRY_PERIOD = 300000;
    private static final int PERSISTENT_MSG_CHECK_PERIOD = 60000;
    private static final int PERSISTENT_MSG_CHECK_TICKS = 12;
    private static final int UNAUTH_BLOOM_RECREATE = 120000;
    private static final int UNAUTH_BLOOM_CHUNK = 1000;
    private static final int BLOOM_CHECK_PERIOD = 60000;
    private static final int BLOOM_CHECK_TICKS = 12;
    public static final int STREAM_CRYPTO = 3;
    public static final int BLOCK_CRYPTO = 2;
    private final PluginInterface plugin_interface;
    private final BuddyPlugin plugin;
    private final String target_network;
    private final String config_file_name;
    private boolean ready_to_publish;
    private CopyOnWriteList<DDBDetails> ddb_details = new CopyOnWriteList();
    private BloomFilter unauth_bloom;
    private long unauth_bloom_create_time;
    private BloomFilter ygm_unauth_bloom;
    private CopyOnWriteList<BuddyPluginBuddyRequestListener> request_listeners = new CopyOnWriteList();
    private List<BuddyPluginBuddy> buddies = new ArrayList<BuddyPluginBuddy>();
    private List<BuddyPluginBuddy> connected_at_close;
    private Map<String, BuddyPluginBuddy> buddies_map = new HashMap<String, BuddyPluginBuddy>();
    private SESecurityManager sec_man;
    private CryptoHandler ecc_handler;
    private GenericMessageRegistration msg_registration;
    private boolean config_dirty;
    private Random random = RandomUtils.SECURE_RANDOM;
    private BuddyPluginAZ2 az2_handler;
    private Set<BuddyPluginBuddy> pd_preinit = new HashSet<BuddyPluginBuddy>();
    private List<BuddyPluginBuddy> pd_queue = new ArrayList<BuddyPluginBuddy>();
    private AESemaphore pd_queue_sem = new AESemaphore("BuddyPlugin:persistDispatch");
    private AEThread2 pd_thread;
    private volatile boolean closing;

    protected BuddyPluginNetwork(PluginInterface _plugin_interface, BuddyPlugin _plugin, String _target_network) {
        this.plugin_interface = _plugin_interface;
        this.plugin = _plugin;
        this.target_network = _target_network;
        boolean is_pub = this.isPublicNetwork();
        this.config_file_name = is_pub ? "friends.config" : "friends_a.config";
        this.sec_man = this.plugin_interface.getUtilities().getSecurityManager();
        this.ecc_handler = CryptoManagerFactory.getSingleton().getECCHandler(is_pub ? 1 : 2);
        this.az2_handler = new BuddyPluginAZ2(this);
    }

    protected BuddyPlugin getPlugin() {
        return this.plugin;
    }

    public String getTargetNetwork() {
        return this.target_network;
    }

    public boolean isPublicNetwork() {
        return this.target_network == "Public";
    }

    public String[] getDDBNetworks() {
        if (this.isPublicNetwork()) {
            return new String[]{"Public", "I2P"};
        }
        return new String[]{"I2P"};
    }

    protected void checkAvailable() throws BuddyPluginException {
        this.plugin.checkAvailable();
    }

    public boolean getPeersAreLANLocal() {
        return this.plugin.getPeersAreLANLocal();
    }

    protected boolean startup(String initial_nick, int initial_status, boolean initial_enabled) {
        try {
            List<DistributedDatabase> ddbs = this.plugin_interface.getUtilities().getDistributedDatabases(this.getDDBNetworks());
            for (DistributedDatabase ddb : ddbs) {
                if (!ddb.isAvailable()) continue;
                DDBDetails details = new DDBDetails(ddb);
                this.ddb_details.add(details);
                ddb.addListener(new DistributedDatabaseListener(){

                    @Override
                    public void event(DistributedDatabaseEvent event2) {
                        if (event2.getType() == 10) {
                            BuddyPluginNetwork.this.updateIP();
                        }
                    }
                });
            }
            this.updateIP();
            this.updateNickName(initial_nick);
            this.updateOnlineStatus(initial_status);
            COConfigurationManager.addAndFireParameterListeners(new String[]{"TCP.Listen.Port", "TCP.Listen.Port.Enable", "UDP.Listen.Port", "UDP.Listen.Port.Enable"}, new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    BuddyPluginNetwork.this.updateListenPorts();
                }
            });
            CryptoManagerFactory.getSingleton().addKeyListener(new CryptoManagerKeyListener(){

                @Override
                public void keyChanged(CryptoHandler handler) {
                    for (DDBDetails details : BuddyPluginNetwork.this.ddb_details) {
                        details.updateKey();
                    }
                }

                @Override
                public void keyLockStatusChanged(CryptoHandler handler) {
                    boolean unlocked = handler.isUnlocked();
                    if (unlocked) {
                        for (DDBDetails details : BuddyPluginNetwork.this.ddb_details) {
                            details.updatePublish();
                        }
                    } else {
                        new AEThread2("BuddyPlugin:disc", true){

                            @Override
                            public void run() {
                                for (BuddyPluginBuddy buddy : BuddyPluginNetwork.this.getAllBuddies()) {
                                    buddy.disconnect();
                                }
                            }
                        }.start();
                    }
                }
            });
            this.ready_to_publish = true;
            this.setClassicEnabledInternal(initial_enabled);
            this.checkBuddiesAndRepublish();
            return true;
        }
        catch (Throwable e) {
            this.log(null, "Initialisation failed", e);
            return false;
        }
    }

    protected void reconnect() {
        List<BuddyPluginBuddy> buddies = this.getBuddies();
        for (BuddyPluginBuddy buddy : buddies) {
            if (buddy.getIP() == null || buddy.isConnected()) continue;
            this.log(buddy, "Attempting reconnect to " + buddy.getString());
            buddy.sendKeepAlive();
        }
    }

    protected void setClassicEnabledInternal(boolean enabled) {
        for (DDBDetails details : this.ddb_details) {
            details.setEnabled(enabled);
        }
    }

    public int getOnlineStatus() {
        List<DDBDetails> temp = this.ddb_details.getList();
        if (temp.size() > 0) {
            return temp.get(0).getOnlineStatus();
        }
        return 0;
    }

    protected List<String> getProfileInfo() {
        return this.plugin.getProfileInfo(this.isPublicNetwork());
    }

    protected void fireAdded(BuddyPluginBuddy buddy) {
        this.plugin.fireAdded(buddy);
    }

    protected void fireRemoved(BuddyPluginBuddy buddy) {
        this.plugin.fireRemoved(buddy);
    }

    protected void fireDetailsChanged(BuddyPluginBuddy buddy) {
        this.plugin.fireDetailsChanged(buddy);
    }

    protected void registerMessageHandler() {
        try {
            this.addRequestListener(new BuddyPluginBuddyRequestListener(){

                @Override
                public Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map request2) throws BuddyPluginException {
                    if (subsystem == 0) {
                        if (!from_buddy.isAuthorised()) {
                            throw new BuddyPluginException("Unauthorised");
                        }
                        return BuddyPluginNetwork.this.processInternalRequest(from_buddy, request2);
                    }
                    return null;
                }

                @Override
                public void pendingMessages(BuddyPluginBuddy[] from_buddies) {
                }
            });
            this.msg_registration = this.plugin_interface.getMessageManager().registerGenericMessageType(this.isPublicNetwork() ? "AZBUDDY" : "BGBUDDYA", "Buddy message handler (" + this.target_network + ")", 3, new GenericMessageHandler(){

                @Override
                public boolean accept(GenericMessageConnection connection) throws MessageException {
                    if (!BuddyPluginNetwork.this.plugin.isClassicEnabled()) {
                        return false;
                    }
                    DDBDetails details = null;
                    InetSocketAddress address = connection.getEndpoint().getNotionalAddress();
                    final String originator = AddressUtils.getHostAddress(address);
                    String net = AENetworkClassifier.categoriseAddress(address);
                    for (DDBDetails d : BuddyPluginNetwork.this.ddb_details) {
                        if (d.getNetwork() != net) continue;
                        details = d;
                        break;
                    }
                    if (details == null) {
                        return false;
                    }
                    if (details.getNetwork() != "Public") {
                        boolean ok = false;
                        GenericMessageStartpoint start = connection.getStartpoint();
                        InetSocketAddress start_address = null;
                        InetSocketAddress ddb_address1 = null;
                        InetSocketAddress ddb_address2 = null;
                        if (start != null && !(ok = AddressUtils.sameHost(start_address = start.getNotionalAddress(), ddb_address1 = details.getDDB().getDHTPlugin().getConnectionOrientedEndpoint())) && (ddb_address2 = details.getDDB().getLocalContact().getAddress()) != null) {
                            ok = AddressUtils.sameHost(start_address, ddb_address2);
                        }
                        if (!ok) {
                            return false;
                        }
                    }
                    final DDBDetails f_details = details;
                    try {
                        String reason = "Friend: Incoming connection establishment (" + originator + ")";
                        BuddyPluginNetwork.this.plugin.addRateLimiters(connection);
                        connection = BuddyPluginNetwork.this.getSTSConnection(connection, reason, new SEPublicKeyLocator(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public boolean accept(Object context2, SEPublicKey other_key) {
                                String other_key_str = Base32.encode(other_key.encodeRawPublicKey());
                                try {
                                    BuddyPluginNetwork buddyPluginNetwork = BuddyPluginNetwork.this;
                                    synchronized (buddyPluginNetwork) {
                                        int unauth_count = 0;
                                        int i = 0;
                                        while (true) {
                                            if (i >= BuddyPluginNetwork.this.buddies.size()) {
                                                if (unauth_count >= 1024) {
                                                    BuddyPluginNetwork.this.log(null, "Incoming connection from " + originator + " rejected, too many unauthorised buddies");
                                                    return false;
                                                }
                                                if (!BuddyPluginNetwork.this.tooManyUnauthConnections(originator)) break;
                                                BuddyPluginNetwork.this.log(null, "Too many recent unauthorised connections from " + originator);
                                                return false;
                                            }
                                            BuddyPluginBuddy buddy = (BuddyPluginBuddy)BuddyPluginNetwork.this.buddies.get(i);
                                            if (buddy.getPublicKey().equals(other_key_str)) {
                                                if (!buddy.isAuthorised()) {
                                                    BuddyPluginNetwork.this.log(buddy, "Incoming connection from " + originator + " failed as for unauthorised buddy");
                                                    return false;
                                                }
                                                buddy.incomingConnection(f_details, (GenericMessageConnection)context2);
                                                return true;
                                            }
                                            if (!buddy.isAuthorised()) {
                                                ++unauth_count;
                                            }
                                            ++i;
                                        }
                                        BuddyPluginBuddy buddy = BuddyPluginNetwork.this.addBuddy(other_key_str, 1, false, false);
                                        if (buddy != null) {
                                            buddy.incomingConnection(f_details, (GenericMessageConnection)context2);
                                            return true;
                                        }
                                        BuddyPluginNetwork.this.log(null, "Incoming connection from " + originator + " failed due to pk mismatch");
                                        return false;
                                    }
                                }
                                catch (Throwable e) {
                                    BuddyPluginNetwork.this.log(null, "Incomming connection from " + originator + " failed", e);
                                    return false;
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        connection.close();
                        BuddyPluginNetwork.this.log(null, "Incoming connection from " + originator + " failed", e);
                    }
                    return true;
                }
            });
        }
        catch (Throwable e) {
            this.log(null, "Failed to register message listener", e);
        }
    }

    protected GenericMessageConnection getSTSConnection(GenericMessageConnection connection, String reason, SEPublicKeyLocator locator) throws Exception {
        return this.sec_man.getSTSConnection(connection, this.sec_man.getPublicKey(1, this.isPublicNetwork() ? 1 : 2, reason), locator, reason, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tooManyUnauthConnections(String originator) {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            block5: {
                int hit_count;
                if (this.unauth_bloom == null) {
                    this.unauth_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
                    this.unauth_bloom_create_time = SystemTime.getCurrentTime();
                }
                if ((hit_count = this.unauth_bloom.add(originator.getBytes())) < 8) break block5;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkUnauthBloom() {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            if (this.unauth_bloom != null) {
                long now = SystemTime.getCurrentTime();
                if (now < this.unauth_bloom_create_time) {
                    this.unauth_bloom_create_time = now;
                } else if (now - this.unauth_bloom_create_time > 120000L) {
                    this.unauth_bloom = null;
                }
            }
        }
    }

    protected void checkMaxMessageSize(int size) throws BuddyPluginException {
        if (size > 0x400000) {
            throw new BuddyPluginException("Message is too large to send, limit is " + DisplayFormatters.formatByteCountToKiBEtc(0x400000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentDispatch() {
        ArrayList<BuddyPluginBuddy> buddies_copy;
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            buddies_copy = new ArrayList<BuddyPluginBuddy>(this.buddies);
        }
        int i = 0;
        while (i < buddies_copy.size()) {
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies_copy.get(i);
            buddy.checkPersistentDispatch();
            ++i;
        }
    }

    protected void persistentDispatchInit() {
        Iterator<BuddyPluginBuddy> it = this.pd_preinit.iterator();
        while (it.hasNext()) {
            this.persistentDispatchPending(it.next());
        }
        this.pd_preinit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentDispatchPending(BuddyPluginBuddy buddy) {
        List<BuddyPluginBuddy> list = this.pd_queue;
        synchronized (list) {
            if (this.plugin.getInitialisationState() == 0) {
                this.pd_preinit.add(buddy);
                return;
            }
            if (!this.pd_queue.contains(buddy)) {
                this.pd_queue.add(buddy);
                this.pd_queue_sem.release();
                if (this.pd_thread == null) {
                    this.pd_thread = new AEThread2("BuddyPlugin:persistDispatch", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            while (true) {
                                BuddyPluginBuddy buddy;
                                if (!BuddyPluginNetwork.this.pd_queue_sem.reserve(30000L)) {
                                    List list = BuddyPluginNetwork.this.pd_queue;
                                    synchronized (list) {
                                        if (BuddyPluginNetwork.this.pd_queue.isEmpty()) {
                                            BuddyPluginNetwork.this.pd_thread = null;
                                            break;
                                        }
                                    }
                                }
                                List list = BuddyPluginNetwork.this.pd_queue;
                                synchronized (list) {
                                    buddy = (BuddyPluginBuddy)BuddyPluginNetwork.this.pd_queue.remove(0);
                                }
                                buddy.persistentDispatch();
                            }
                        }
                    };
                    this.pd_thread.start();
                }
            }
        }
    }

    protected Map processInternalRequest(BuddyPluginBuddy from_buddy, Map request2) throws BuddyPluginException {
        int type = ((Long)request2.get("type")).intValue();
        if (type == 1) {
            HashMap<String, Long> reply = new HashMap<String, Long>();
            reply.put("type", new Long(2L));
            return reply;
        }
        if (type == 3) {
            from_buddy.receivedCloseRequest(request2);
            HashMap<String, Long> reply = new HashMap<String, Long>();
            reply.put("type", new Long(4L));
            return reply;
        }
        throw new BuddyPluginException("Unrecognised request type " + type);
    }

    protected void updateListenPorts() {
        for (DDBDetails details : this.ddb_details) {
            details.updateListenPorts();
        }
    }

    protected void updateIP() {
        for (DDBDetails details : this.ddb_details) {
            details.updateIP();
        }
    }

    protected void updateNickName(String new_nick) {
        if ((new_nick = new_nick.trim()).length() == 0) {
            new_nick = null;
        }
        for (DDBDetails details : this.ddb_details) {
            details.updateNickName(new_nick);
        }
    }

    protected void updateOnlineStatus(int new_status) {
        boolean changed = false;
        for (DDBDetails details : this.ddb_details) {
            if (!details.updateOnlineStatus(new_status)) continue;
            changed = true;
        }
        if (changed) {
            List<BuddyPluginBuddy> buddies = this.getAllBuddies();
            int i = 0;
            while (i < buddies.size()) {
                BuddyPluginBuddy buddy = buddies.get(i);
                if (buddy.isConnected()) {
                    buddy.sendKeepAlive();
                }
                ++i;
            }
        }
    }

    protected boolean stringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    protected DDBDetails getDDBDetails(String net) {
        for (DDBDetails details : this.ddb_details) {
            if (net != details.getNetwork()) continue;
            return details;
        }
        return null;
    }

    protected int getCurrentStatusSeq(DDBDetails details) {
        return details.current_publish.getSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closedown() {
        this.logMessage(null, "Closing down");
        this.closing = true;
        List<BuddyPluginBuddy> buddies = this.getAllBuddies();
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            this.connected_at_close = new ArrayList<BuddyPluginBuddy>();
            for (BuddyPluginBuddy buddy : buddies) {
                if (!buddy.isConnected()) continue;
                this.connected_at_close.add(buddy);
            }
        }
        for (DDBDetails details : this.ddb_details) {
            details.closedown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            this.config_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        long now = SystemTime.getCurrentTime();
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            Map map = this.readConfig();
            List buddies_config = (List)map.get("friends");
            if (buddies_config != null) {
                if (buddies_config.size() == 0) {
                    this.deleteConfig();
                } else {
                    int i = 0;
                    while (i < buddies_config.size()) {
                        Object o = buddies_config.get(i);
                        if (o instanceof Map) {
                            Long l_subsystem;
                            int subsystem;
                            long last_time_online;
                            long created_time;
                            Map details = (Map)o;
                            Long l_ct = (Long)details.get("ct");
                            long l = created_time = l_ct == null ? now : l_ct;
                            if (created_time > now) {
                                created_time = now;
                            }
                            String key = new String((byte[])details.get("pk"));
                            List recent_ygm = (List)details.get("ygm");
                            String nick = this.decodeString((byte[])details.get("n"));
                            String my_name = this.decodeString((byte[])details.get("mn"));
                            Long l_seq = (Long)details.get("ls");
                            int last_seq = l_seq == null ? 0 : l_seq.intValue();
                            Long l_lo = (Long)details.get("lo");
                            long l2 = last_time_online = l_lo == null ? 0L : l_lo;
                            if (last_time_online > now) {
                                last_time_online = now;
                            }
                            int n = subsystem = (l_subsystem = (Long)details.get("ss")) == null ? 1 : l_subsystem.intValue();
                            if (subsystem != 2) {
                                int udp_port;
                                int tcp_port;
                                Long l_ver = (Long)details.get("v");
                                int ver = l_ver == null ? 1 : l_ver.intValue();
                                String loc_cat = this.decodeString((byte[])details.get("lc"));
                                String rem_cat = this.decodeString((byte[])details.get("rc"));
                                BuddyPluginBuddy buddy = new BuddyPluginBuddy(this, created_time, subsystem, true, key, nick, my_name, ver, loc_cat, rem_cat, last_seq, last_time_online, recent_ygm, false);
                                byte[] ip_bytes = (byte[])details.get("ip");
                                if (ip_bytes != null && ip_bytes.length > 0) {
                                    try {
                                        InetAddress ip = InetAddress.getByAddress(ip_bytes);
                                        tcp_port = ((Long)details.get("tcp")).intValue();
                                        udp_port = ((Long)details.get("udp")).intValue();
                                        buddy.setCachedStatus(new InetSocketAddress(ip, 0), tcp_port, udp_port);
                                    }
                                    catch (Throwable ip) {}
                                } else {
                                    String host = MapUtils.getMapString(details, "host", null);
                                    if (host != null) {
                                        tcp_port = ((Long)details.get("tcp")).intValue();
                                        udp_port = ((Long)details.get("udp")).intValue();
                                        buddy.setCachedStatus(InetSocketAddress.createUnresolved(host, 0), tcp_port, udp_port);
                                    }
                                }
                                this.logMessage(buddy, "Loaded buddy " + buddy.getString());
                                this.buddies.add(buddy);
                                this.buddies_map.put(key, buddy);
                            }
                        }
                        ++i;
                    }
                }
            }
            int num_buddies = this.buddies.size();
            for (BuddyPluginBuddy b : this.buddies) {
                b.setInitialStatus(now, num_buddies);
            }
        }
    }

    protected String decodeString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF8");
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected void saveConfig() {
        this.saveConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig(boolean force) {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            if (this.config_dirty || force) {
                ArrayList buddies_config = new ArrayList();
                int i = 0;
                while (i < this.buddies.size()) {
                    BuddyPluginBuddy buddy = this.buddies.get(i);
                    if (!buddy.isTransient() && buddy.isAuthorised()) {
                        try {
                            boolean connected;
                            String my_nick;
                            String nick;
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("ct", new Long(buddy.getCreatedTime()));
                            map.put("pk", buddy.getPublicKey());
                            List<Long> ygm = buddy.getYGMMarkers();
                            if (ygm != null) {
                                map.put("ygm", ygm);
                            }
                            if ((nick = buddy.getNickName()) != null) {
                                map.put("n", nick);
                            }
                            if ((my_nick = buddy.getMyName()) != null) {
                                map.put("mn", my_nick);
                            }
                            map.put("ls", new Long(buddy.getLastStatusSeq()));
                            map.put("lo", new Long(buddy.getLastTimeOnline()));
                            map.put("ss", new Long(buddy.getSubsystem()));
                            map.put("v", new Long(buddy.getVersion()));
                            if (buddy.getLocalAuthorisedRSSTagsOrCategoriesAsString() != null) {
                                map.put("lc", buddy.getLocalAuthorisedRSSTagsOrCategoriesAsString());
                            }
                            if (buddy.getRemoteAuthorisedRSSTagsOrCategoriesAsString() != null) {
                                map.put("rc", buddy.getRemoteAuthorisedRSSTagsOrCategoriesAsString());
                            }
                            boolean bl = connected = buddy.isConnected() || this.connected_at_close != null && this.connected_at_close.contains(buddy);
                            if (connected) {
                                InetSocketAddress isa = buddy.getIP();
                                int tcp_port = buddy.getTCPPort();
                                int udp_port = buddy.getUDPPort();
                                if (isa != null) {
                                    if (isa.isUnresolved()) {
                                        map.put("host", AddressUtils.getHostAddress(isa));
                                    } else {
                                        map.put("ip", isa.getAddress().getAddress());
                                    }
                                    map.put("tcp", new Long(tcp_port));
                                    map.put("udp", new Long(udp_port));
                                }
                            }
                            buddies_config.add(map);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    ++i;
                }
                HashMap map = new HashMap();
                if (buddies_config.size() > 0) {
                    map.put("friends", buddies_config);
                    this.writeConfig(map);
                } else {
                    this.deleteConfig();
                }
                this.config_dirty = false;
            }
        }
    }

    public BuddyPluginBuddy addBuddy(String key, int subsystem) {
        if (!this.plugin.isClassicEnabled()) {
            this.plugin.setClassicEnabled(true, false);
        }
        return this.addBuddy(key, subsystem, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyPluginBuddy addBuddy(String key, int subsystem, boolean authorised, boolean for_peek) {
        if (key.length() == 0 || !this.verifyPublicKey(key)) {
            return null;
        }
        BuddyPluginBuddy buddy_to_return = null;
        boolean transient_changed = false;
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            int i = 0;
            while (i < this.buddies.size()) {
                BuddyPluginBuddy buddy = this.buddies.get(i);
                if (buddy.getPublicKey().equals(key)) {
                    if (buddy.getSubsystem() != subsystem) {
                        this.log(buddy, "Buddy " + buddy.getString() + ": subsystem changed from " + buddy.getSubsystem() + " to " + subsystem);
                        buddy.setSubsystem(subsystem);
                        this.saveConfig(true);
                    }
                    if (buddy.isTransient() && !for_peek) {
                        buddy.setTransient(false);
                        transient_changed = true;
                        this.saveConfig(true);
                    }
                    if (authorised && !buddy.isAuthorised()) {
                        this.log(buddy, "Buddy " + buddy.getString() + ": now authorised");
                        buddy.setAuthorised(true);
                        buddy_to_return = buddy;
                    } else {
                        return buddy;
                    }
                }
                ++i;
            }
            if (buddy_to_return == null) {
                buddy_to_return = new BuddyPluginBuddy(this, SystemTime.getCurrentTime(), subsystem, authorised, key, null, null, 2, null, null, 0, 0L, null, for_peek);
                this.buddies.add(buddy_to_return);
                this.buddies_map.put(key, buddy_to_return);
                if (!authorised) {
                    this.log(buddy_to_return, "Added unauthorised buddy: " + buddy_to_return.getString());
                }
            }
            if (buddy_to_return.isAuthorised()) {
                this.logMessage(buddy_to_return, "Added buddy " + buddy_to_return.getString());
                this.saveConfig(true);
            }
        }
        if (transient_changed) {
            this.fireRemoved(buddy_to_return);
        }
        this.fireAdded(buddy_to_return);
        return buddy_to_return;
    }

    public BuddyPluginBuddy peekBuddy(String key) {
        if (!this.plugin.isClassicEnabled() && !this.plugin.setClassicEnabled(true, true)) {
            return null;
        }
        return this.addBuddy(key, 1, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuddy(BuddyPluginBuddy buddy) {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            if (!this.buddies.remove(buddy)) {
                return;
            }
            this.buddies_map.remove(buddy.getPublicKey());
            this.logMessage(buddy, "Removed buddy " + buddy.getString());
            this.saveConfig(true);
        }
        buddy.destroy();
        this.fireRemoved(buddy);
    }

    protected Map readConfig() {
        File config_file = FileUtil.newFile(this.plugin_interface.getUtilities().getUserDir(), this.config_file_name);
        return this.readConfigFile(config_file);
    }

    protected void writeConfig(Map map) {
        File config_file = FileUtil.newFile(this.plugin_interface.getUtilities().getUserDir(), this.config_file_name);
        this.writeConfigFile(config_file, map);
    }

    protected void deleteConfig() {
        Utilities utils = this.plugin_interface.getUtilities();
        File config_file = FileUtil.newFile(utils.getUserDir(), this.config_file_name);
        utils.deleteResilientBEncodedFile(config_file.getParentFile(), config_file.getName(), true);
    }

    protected Map readConfigFile(File name) {
        Utilities utils = this.plugin_interface.getUtilities();
        HashMap map = utils.readResilientBEncodedFile(name.getParentFile(), name.getName(), true);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    protected boolean writeConfigFile(File name, Map data) {
        Utilities utils = this.plugin_interface.getUtilities();
        utils.writeResilientBEncodedFile(name.getParentFile(), name.getName(), data, true);
        return name.exists();
    }

    protected File getBuddyConfigDir() {
        return FileUtil.newFile(this.plugin_interface.getUtilities().getUserDir(), "friends");
    }

    public BuddyPluginAZ2 getAZ2Handler() {
        return this.az2_handler;
    }

    public String getPublicKey() {
        try {
            return Base32.encode(this.ecc_handler.getPublicKey("Friend get key"));
        }
        catch (Throwable e) {
            this.logMessage(null, "Failed to access public key", e);
            return null;
        }
    }

    public boolean verifyPublicKey(String key) {
        return this.ecc_handler.verifyPublicKey(Base32.decode(key));
    }

    protected void checkBuddiesAndRepublish() {
        this.updateBuddys();
        this.plugin_interface.getUtilities().createTimer("Buddy checker").addPeriodicEvent(5000L, new UTTimerEventPerformer(){
            int tick_count;

            @Override
            public void perform(UTTimerEvent event2) {
                ++this.tick_count;
                if (BuddyPluginNetwork.this.closing || !BuddyPluginNetwork.this.plugin.isClassicEnabled()) {
                    return;
                }
                BuddyPluginNetwork.this.updateBuddys();
                if (this.tick_count % 120 == 0) {
                    for (DDBDetails details : BuddyPluginNetwork.this.ddb_details) {
                        details.updatePublish();
                    }
                }
                if (this.tick_count % 60 == 0) {
                    BuddyPluginNetwork.this.checkMessagePending(this.tick_count);
                }
                if (this.tick_count % 12 == 0) {
                    BuddyPluginNetwork.this.checkUnauthBloom();
                }
                if (this.tick_count % 12 == 0) {
                    BuddyPluginNetwork.this.saveConfig();
                }
                if (this.tick_count % 12 == 0) {
                    BuddyPluginNetwork.this.checkPersistentDispatch();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuddys() {
        ArrayList<BuddyPluginBuddy> buddies_copy;
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            buddies_copy = new ArrayList<BuddyPluginBuddy>(this.buddies);
        }
        long now = SystemTime.getCurrentTime();
        Random random = new Random();
        int i = 0;
        while (i < buddies_copy.size()) {
            BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies_copy.get(i);
            long last_check = buddy.getLastStatusCheckTime();
            buddy.checkTimeouts();
            int period = 180000 + 60000 * buddies_copy.size() / 5;
            if (now - last_check > (long)(period += random.nextInt(120000)) && !buddy.statusCheckActive() && buddy.isAuthorised()) {
                this.updateBuddyStatus(buddy);
            }
            ++i;
        }
        BuddyPluginNetwork buddyPluginNetwork2 = this;
        synchronized (buddyPluginNetwork2) {
            int i2 = 0;
            while (i2 < buddies_copy.size()) {
                BuddyPluginBuddy buddy = (BuddyPluginBuddy)buddies_copy.get(i2);
                if (buddy.isIdle() && !buddy.isAuthorised()) {
                    this.removeBuddy(buddy);
                }
                ++i2;
            }
        }
    }

    protected void updateBuddyStatus(final BuddyPluginBuddy buddy) {
        if (!buddy.statusCheckStarts()) {
            return;
        }
        this.log(buddy, "Updating buddy status: " + buddy.getString());
        final List<DDBDetails> temp = this.ddb_details.getList();
        Runnable callback = new Runnable(){
            private int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    ++this.count;
                    if (this.count != temp.size()) {
                        return;
                    }
                }
                buddy.statusCheckFailed();
            }
        };
        for (DDBDetails details : temp) {
            details.updateBuddyStatus(buddy, callback);
        }
    }

    protected Map verifyAndExtract(byte[] signed_stuff, byte[] public_key) throws BuddyPluginException {
        int signature_length = signed_stuff[0] & 0xFF;
        byte[] signature = new byte[signature_length];
        byte[] data = new byte[signed_stuff.length - 1 - signature_length];
        System.arraycopy(signed_stuff, 1, signature, 0, signature_length);
        System.arraycopy(signed_stuff, 1 + signature_length, data, 0, data.length);
        try {
            if (this.ecc_handler.verify(public_key, data, signature)) {
                return BDecoder.decode(data);
            }
            this.logMessage(null, "Signature verification failed");
            return null;
        }
        catch (Throwable e) {
            this.rethrow("Verification failed", e);
            return null;
        }
    }

    protected byte[] signAndInsert(Map plain_stuff, String reason) throws BuddyPluginException {
        try {
            byte[] data = BEncoder.encode(plain_stuff);
            byte[] signature = this.ecc_handler.sign(data, reason);
            byte[] signed_payload = new byte[1 + signature.length + data.length];
            signed_payload[0] = (byte)signature.length;
            System.arraycopy(signature, 0, signed_payload, 1, signature.length);
            System.arraycopy(data, 0, signed_payload, 1 + signature.length, data.length);
            return signed_payload;
        }
        catch (Throwable e) {
            this.rethrow("Signing failed", e);
            return null;
        }
    }

    public boolean verify(String pk, byte[] payload, byte[] signature) throws BuddyPluginException {
        return this.verify(Base32.decode(pk), payload, signature);
    }

    protected boolean verify(BuddyPluginBuddy buddy, byte[] payload, byte[] signature) throws BuddyPluginException {
        return this.verify(buddy.getRawPublicKey(), payload, signature);
    }

    protected boolean verify(byte[] pk, byte[] payload, byte[] signature) throws BuddyPluginException {
        try {
            return this.ecc_handler.verify(pk, payload, signature);
        }
        catch (Throwable e) {
            this.rethrow("Verification failed", e);
            return false;
        }
    }

    public byte[] sign(byte[] payload) throws BuddyPluginException {
        try {
            return this.ecc_handler.sign(payload, "Friend message signing");
        }
        catch (Throwable e) {
            this.rethrow("Signing failed", e);
            return null;
        }
    }

    protected BuddyPlugin.CryptoResult encrypt(BuddyPluginBuddy buddy, byte[] payload) throws BuddyPluginException {
        return this.encrypt(buddy.getPublicKey(), payload, buddy.getName());
    }

    public BuddyPlugin.CryptoResult encrypt(String pk, byte[] payload, String forWho) throws BuddyPluginException {
        try {
            byte[] hash = new byte[20];
            this.random.nextBytes(hash);
            HashMap<String, byte[]> content = new HashMap<String, byte[]>();
            content.put("h", hash);
            content.put("p", payload);
            final byte[] encrypted = this.ecc_handler.encrypt(Base32.decode(pk), BEncoder.encode(content), "Encrypting message for " + forWho);
            final byte[] sha1_hash = new SHA1Simple().calculateHash(hash);
            return new BuddyPlugin.CryptoResult(){

                @Override
                public byte[] getChallenge() {
                    return sha1_hash;
                }

                @Override
                public byte[] getPayload() {
                    return encrypted;
                }
            };
        }
        catch (Throwable e) {
            this.rethrow("Encryption failed", e);
            return null;
        }
    }

    protected BuddyPlugin.CryptoResult decrypt(BuddyPluginBuddy buddy, byte[] content, String forName) throws BuddyPluginException {
        try {
            byte[] decrypted = this.ecc_handler.decrypt(buddy.getRawPublicKey(), content, "Decrypting message for " + buddy.getName());
            final Map<String, Object> map = BDecoder.decode(decrypted);
            return new BuddyPlugin.CryptoResult(){

                @Override
                public byte[] getChallenge() {
                    return (byte[])map.get("h");
                }

                @Override
                public byte[] getPayload() {
                    return (byte[])map.get("p");
                }
            };
        }
        catch (Throwable e) {
            this.rethrow("Decryption failed", e);
            return null;
        }
    }

    public BuddyPlugin.CryptoResult decrypt(String public_key, byte[] content) throws BuddyPluginException {
        try {
            byte[] decrypted = this.ecc_handler.decrypt(Base32.decode(public_key), content, "Decrypting message for " + public_key);
            final Map<String, Object> map = BDecoder.decode(decrypted);
            return new BuddyPlugin.CryptoResult(){

                @Override
                public byte[] getChallenge() {
                    return (byte[])map.get("h");
                }

                @Override
                public byte[] getPayload() {
                    return (byte[])map.get("p");
                }
            };
        }
        catch (Throwable e) {
            this.rethrow("Decryption failed", e);
            return null;
        }
    }

    protected void setMessagePending(BuddyPluginBuddy buddy, final operationListener _listener) throws BuddyPluginException {
        final operationListener listener = new operationListener(){
            boolean fired;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete() {
                12 var1_1 = this;
                synchronized (var1_1) {
                    if (this.fired) {
                        return;
                    }
                    this.fired = true;
                }
                _listener.complete();
            }
        };
        try {
            this.checkAvailable();
            final List<DDBDetails> temp = this.ddb_details.getList();
            operationListener listener_wrapper = new operationListener(){
                int count = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete() {
                    13 var1_1 = this;
                    synchronized (var1_1) {
                        ++this.count;
                        if (this.count < temp.size()) {
                            return;
                        }
                    }
                    listener.complete();
                }
            };
            for (DDBDetails details : temp) {
                details.setMessagePending(buddy, listener_wrapper);
            }
        }
        catch (Throwable e) {
            try {
                this.rethrow("Failed to publish YGM", e);
            }
            finally {
                listener.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMessagePending(int tick_count) {
        this.log(null, "Checking YGM");
        if (tick_count % 720 == 0) {
            BuddyPluginNetwork buddyPluginNetwork = this;
            synchronized (buddyPluginNetwork) {
                this.ygm_unauth_bloom = null;
            }
        }
        for (DDBDetails details : this.ddb_details) {
            details.checkMessagePending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddy getBuddyFromPublicKey(String key) {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            return this.buddies_map.get(key);
        }
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected SESecurityManager getSecurityManager() {
        return this.sec_man;
    }

    protected GenericMessageRegistration getMessageRegistration() {
        return this.msg_registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuddyPluginBuddy> getBuddies() {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            ArrayList<BuddyPluginBuddy> result = new ArrayList<BuddyPluginBuddy>();
            int i = 0;
            while (i < this.buddies.size()) {
                BuddyPluginBuddy buddy = this.buddies.get(i);
                if (buddy.isAuthorised() && !buddy.isTransient()) {
                    result.add(buddy);
                }
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BuddyPluginBuddy> getAllBuddies() {
        BuddyPluginNetwork buddyPluginNetwork = this;
        synchronized (buddyPluginNetwork) {
            return new ArrayList<BuddyPluginBuddy>(this.buddies);
        }
    }

    protected Map requestReceived(BuddyPluginBuddy from_buddy, int subsystem, Map content) throws BuddyPluginException {
        List<BuddyPluginBuddyRequestListener> listeners_ref = this.request_listeners.getList();
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                Map reply = listeners_ref.get(i).requestReceived(from_buddy, subsystem, content);
                if (reply != null) {
                    return reply;
                }
            }
            catch (BuddyPluginException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new BuddyPluginException("Request processing failed", e);
            }
            ++i;
        }
        return null;
    }

    protected void fireYGM(BuddyPluginBuddy[] from_buddies) {
        List<BuddyPluginBuddyRequestListener> listeners_ref = this.request_listeners.getList();
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                listeners_ref.get(i).pendingMessages(from_buddies);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void rethrow(String reason, Throwable e) throws BuddyPluginException {
        this.logMessage(null, reason, e);
        if (e instanceof CryptoManagerPasswordException) {
            throw new BuddyPluginPasswordException(((CryptoManagerPasswordException)e).wasIncorrect(), reason, e);
        }
        throw new BuddyPluginException(reason, e);
    }

    protected InputStream handleUPRSS(final AZPluginConnection connection, BuddyPluginBuddy buddy, String tag_or_category) throws IPCException {
        if (buddy.getPluginNetwork() != this) {
            throw new IPCException("Plugin network mismatch");
        }
        if (!buddy.isOnline(true)) {
            throw new IPCException("Buddy isn't online");
        }
        HashMap<String, Object> msg = new HashMap<String, Object>();
        final String if_mod = connection.getRequestProperty("If-Modified-Since");
        try {
            msg.put("cat", tag_or_category.getBytes("UTF-8"));
            if (if_mod != null) {
                msg.put("if_mod", if_mod);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        final Object[] result = new Object[1];
        final AESemaphore result_sem = new AESemaphore("BuddyPlugin:rss");
        final String etag = String.valueOf(buddy.getPublicKey()) + "-" + tag_or_category;
        this.az2_handler.sendAZ2RSSMessage(buddy, msg, new BuddyPluginAZ2TrackerListener(){

            public Map messageReceived(BuddyPluginBuddy buddy, Map message) {
                try {
                    byte[] bytes = (byte[])message.get("rss");
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    result[0] = bais;
                    connection.setHeaderField("ETag", etag);
                    byte[] b_last_mod = (byte[])message.get("last_mod");
                    if (b_last_mod != null) {
                        String last_mod = new String(b_last_mod, "UTF-8");
                        connection.setHeaderField("Last-Modified", last_mod);
                        if (if_mod != null && if_mod.equals(last_mod) && bytes.length == 0) {
                            connection.setResponse(304, "Not Modified");
                        }
                    }
                    result_sem.release();
                }
                catch (Throwable e) {
                    this.messageFailed(buddy, e);
                }
                return null;
            }

            @Override
            public void messageFailed(BuddyPluginBuddy buddy, Throwable cause) {
                result[0] = new IPCException("Read failed", cause);
                result_sem.release();
            }
        });
        result_sem.reserve(this.isPublicNetwork() ? 120000 : 240000);
        if (result[0] == null) {
            this.log(buddy, "    RSS download timeout");
            throw new IPCException("Timeout");
        }
        if (result[0] instanceof InputStream) {
            return (InputStream)result[0];
        }
        IPCException error = (IPCException)result[0];
        this.log(buddy, "    RSS downloaded failed: " + Debug.getNestedExceptionMessage(error));
        throw error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream handleUPTorrent(AZPluginConnection connection, final BuddyPluginBuddy buddy, String tag_or_category, final byte[] hash) throws IPCException {
        if (buddy.getPluginNetwork() != this) {
            throw new IPCException("Plugin network mismatch");
        }
        final long timeout = this.isPublicNetwork() ? 120000 : 240000;
        final Object[] result = new Object[1];
        final AESemaphore result_sem = new AESemaphore("BuddyPlugin:upt");
        this.log(buddy, "Attempting to download torrent for " + Base32.encode(hash));
        if (buddy.isOnline(true)) {
            try {
                HashMap<String, byte[]> msg = new HashMap<String, byte[]>();
                try {
                    msg.put("cat", tag_or_category.getBytes("UTF-8"));
                    msg.put("hash", hash);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                this.az2_handler.sendAZ2RSSMessage(buddy, msg, new BuddyPluginAZ2TrackerListener(){
                    private boolean result_set;

                    public Map messageReceived(BuddyPluginBuddy buddy, Map message) {
                        try {
                            byte[] bytes = (byte[])message.get("torrent");
                            BuddyPluginNetwork.this.log(buddy, "    torrent downloaded from buddy");
                            this.setResult(bytes);
                        }
                        catch (Throwable e) {
                            this.messageFailed(buddy, e);
                        }
                        return null;
                    }

                    @Override
                    public void messageFailed(BuddyPluginBuddy buddy, Throwable cause) {
                        this.setResult(new IPCException("Read failed", cause));
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void setResult(Object obj) {
                        Object[] objectArray = result;
                        synchronized (result) {
                            if (this.result_set) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                            this.result_set = true;
                            if (!(result[0] instanceof byte[])) {
                                result[0] = obj;
                            }
                            result_sem.release();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            catch (Throwable e) {
                result[0] = new IPCException("Buddy torrent get failed", e);
                result_sem.release();
            }
        } else {
            result[0] = new IPCException("Buddy is offline");
            result_sem.release();
        }
        final MagnetPlugin magnet_plugin = this.getMagnetPlugin();
        if (magnet_plugin == null) {
            Object[] e = result;
            synchronized (result) {
                if (result[0] == null) {
                    result[0] = new IPCException("Magnet plugin unavailable");
                }
                // ** MonitorExit[e] (shouldn't be in output)
                result_sem.release();
            }
        } else {
            new AEThread2("BuddyPlugin:mag", true){
                private boolean result_set;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (buddy.isOnline(true)) {
                            Thread.sleep(10000L);
                        }
                        Object[] objectArray = result;
                        synchronized (result) {
                            if (result[0] instanceof byte[]) {
                                this.setResult(null);
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            byte[] torrent_data = magnet_plugin.download(BuddyPluginNetwork.this.plugin.isLoggerEnabled() ? new MagnetPluginProgressListener(){

                                @Override
                                public void reportSize(long size) {
                                }

                                @Override
                                public void reportActivity(String str) {
                                    BuddyPluginNetwork.this.log(buddy, "    MagnetDownload: " + str);
                                }

                                @Override
                                public void reportCompleteness(int percent) {
                                }

                                @Override
                                public void reportContributor(InetSocketAddress address) {
                                }

                                @Override
                                public boolean verbose() {
                                    return false;
                                }

                                @Override
                                public boolean cancelled() {
                                    return false;
                                }
                            } : null, hash, "", new InetSocketAddress[0], Collections.emptyList(), Collections.emptyMap(), timeout, 0);
                            if (torrent_data == null) {
                                this.setResult(new IPCException("Magnet timeout"));
                            } else {
                                BuddyPluginNetwork.this.log(buddy, "    torrent downloaded from magnet");
                                this.setResult(torrent_data);
                            }
                        }
                    }
                    catch (Throwable e) {
                        this.setResult(new IPCException("Magnet get failed", e));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void setResult(Object obj) {
                    Object[] objectArray = result;
                    synchronized (result) {
                        if (this.result_set) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        this.result_set = true;
                        if (obj != null && (result[0] == null || obj instanceof byte[] && !(result[0] instanceof byte[]))) {
                            result[0] = obj;
                        }
                        result_sem.release();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            }.start();
        }
        {
            long rem;
            long start = SystemTime.getMonotonousTime();
            if (result_sem.reserve(timeout) && !(result[0] instanceof byte[]) && (rem = timeout - (SystemTime.getMonotonousTime() - start)) > 0L) {
                result_sem.reserve(rem);
            }
            if (result[0] == null) {
                this.log(buddy, "    torrent download timeout");
                throw new IPCException("Timeout");
            }
            if (result[0] instanceof byte[]) {
                return new ByteArrayInputStream((byte[])result[0]);
            }
            IPCException error = (IPCException)result[0];
            this.log(buddy, "    torrent downloaded failed: " + Debug.getNestedExceptionMessage(error));
            throw error;
        }
    }

    protected MagnetPlugin getMagnetPlugin() {
        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class);
        if (pi == null) {
            return null;
        }
        return (MagnetPlugin)pi.getPlugin();
    }

    protected void addRequestListener(BuddyPluginBuddyRequestListener listener) {
        this.request_listeners.add(listener);
    }

    protected void removeRequestListener(BuddyPluginBuddyRequestListener listener) {
        this.request_listeners.remove(listener);
    }

    protected void logMessage(BuddyPluginBuddy buddy, String str) {
        this.plugin.logMessage(buddy, str);
    }

    protected void logMessage(BuddyPluginBuddy buddy, String str, Throwable e) {
        this.plugin.logMessage(buddy, str, e);
    }

    protected void log(BuddyPluginBuddy buddy, String str) {
        this.plugin.log(buddy, str);
    }

    protected void log(BuddyPluginBuddy buddy, String str, Throwable e) {
        this.plugin.log(buddy, str, e);
    }

    protected class DDBDetails {
        private final DistributedDatabase ddb;
        private PublishDetails current_publish;
        private PublishDetails latest_publish;
        private long last_publish_start;
        private TimerEvent republish_delay_event;
        private TimerEvent update_ip_retry_event;
        private volatile boolean diversified;
        private List<DistributedDatabaseContact> publish_write_contacts = new ArrayList<DistributedDatabaseContact>();
        private AsyncDispatcher publish_dispatcher = new AsyncDispatcher();
        private boolean ygm_active;
        private boolean bogus_ygm_written;
        private int status_seq;
        private byte[] last_payload;

        private DDBDetails(DistributedDatabase _ddb) {
            this.ddb = _ddb;
            while (this.status_seq == 0) {
                this.status_seq = BuddyPluginNetwork.this.random.nextInt();
            }
            this.latest_publish = this.current_publish = new PublishDetails(this.ddb.getNetwork());
        }

        public DistributedDatabase getDDB() {
            return this.ddb;
        }

        public String getNetwork() {
            return this.ddb.getNetwork();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setEnabled(boolean _enabled) {
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                if (this.latest_publish.isEnabled() != _enabled) {
                    PublishDetails new_publish = this.latest_publish.getCopy();
                    new_publish.setEnabled(_enabled);
                    this.updatePublish(new_publish);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateListenPorts() {
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                int udp_port;
                int tcp_port;
                if (this.latest_publish.getNetwork() == "Public") {
                    tcp_port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                    boolean tcp_enabled = COConfigurationManager.getBooleanParameter("TCP.Listen.Port.Enable");
                    udp_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                    boolean udp_enabled = COConfigurationManager.getBooleanParameter("UDP.Listen.Port.Enable");
                    if (!tcp_enabled) {
                        tcp_port = 0;
                    }
                    if (!udp_enabled) {
                        udp_port = 0;
                    }
                } else {
                    tcp_port = 6881;
                    udp_port = 0;
                }
                if (this.latest_publish.getTCPPort() != tcp_port || this.latest_publish.getUDPPort() != udp_port) {
                    PublishDetails new_publish = this.latest_publish.getCopy();
                    new_publish.setTCPPort(tcp_port);
                    new_publish.setUDPPort(udp_port);
                    this.updatePublish(new_publish);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateIPWithDelay() {
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                if (this.update_ip_retry_event == null) {
                    this.update_ip_retry_event = SimpleTimer.addEvent("updateIP", SystemTime.getOffsetTime(60000L), ev -> {
                        DDBDetails dDBDetails = this;
                        synchronized (dDBDetails) {
                            this.update_ip_retry_event = null;
                        }
                        this.updateIP();
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateIP() {
            if (!this.ddb.isAvailable()) {
                return;
            }
            if (!this.ddb.isInitialized()) {
                this.updateIPWithDelay();
                return;
            }
            Object[] public_ips = this.ddb.getDHTPlugin().getConnectionOrientedEndpoints();
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                if (this.latest_publish.getIPs() == null || !Arrays.deepEquals(this.latest_publish.getIPs(), public_ips)) {
                    PublishDetails new_publish = this.latest_publish.getCopy();
                    new_publish.setIPs((InetSocketAddress[])public_ips);
                    this.updatePublish(new_publish);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateNickName(String new_nick) {
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                String old_nick = this.latest_publish.getNickName();
                if (!BuddyPluginNetwork.this.stringsEqual(new_nick, old_nick)) {
                    PublishDetails new_publish = this.latest_publish.getCopy();
                    new_publish.setNickName(new_nick);
                    this.updatePublish(new_publish);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean updateOnlineStatus(int new_status) {
            boolean changed;
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                int old_status = this.latest_publish.getOnlineStatus();
                boolean bl = changed = old_status != new_status;
                if (changed) {
                    PublishDetails new_publish = this.latest_publish.getCopy();
                    new_publish.setOnlineStatus(new_status);
                    this.updatePublish(new_publish);
                }
            }
            return changed;
        }

        private int getOnlineStatus() {
            return this.latest_publish.getOnlineStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMessagePending() {
            block25: {
                DDBDetails dDBDetails = this;
                synchronized (dDBDetails) {
                    if (this.ygm_active) {
                        return;
                    }
                    this.ygm_active = true;
                }
                boolean active = false;
                try {
                    try {
                        String reason = "Friend YGM check";
                        byte[] public_key = BuddyPluginNetwork.this.ecc_handler.getPublicKey(reason);
                        DistributedDatabaseKey key = this.getYGMKey(public_key, reason);
                        this.ddb.read(new DistributedDatabaseListener(){
                            private List new_ygm_buddies = new ArrayList();
                            private boolean unauth_permitted = false;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void event(DistributedDatabaseEvent event2) {
                                block19: {
                                    int type = event2.getType();
                                    if (type == 2) {
                                        try {
                                            long rand;
                                            DistributedDatabaseValue value = event2.getValue();
                                            byte[] envelope = (byte[])value.getValue(byte[].class);
                                            Map<String, Object> map = BDecoder.decode(envelope);
                                            byte[] pk = (byte[])map.get("pk");
                                            if (pk == null) {
                                                return;
                                            }
                                            String pk_str = Base32.encode(pk);
                                            BuddyPluginBuddy buddy = BuddyPluginNetwork.this.getBuddyFromPublicKey(pk_str);
                                            if (buddy == null || !buddy.isAuthorised()) {
                                                if (buddy == null) {
                                                    BuddyPluginNetwork.this.log(buddy, "YGM entry from unknown friend '" + pk_str + "' - ignoring");
                                                } else {
                                                    BuddyPluginNetwork.this.log(buddy, "YGM entry from unauthorised friend '" + pk_str + "' - ignoring");
                                                }
                                                byte[] address = event2.getContact().getAddress().getAddress().getAddress();
                                                BuddyPluginNetwork buddyPluginNetwork = BuddyPluginNetwork.this;
                                                synchronized (buddyPluginNetwork) {
                                                    if (BuddyPluginNetwork.this.ygm_unauth_bloom == null) {
                                                        BuddyPluginNetwork.this.ygm_unauth_bloom = BloomFilterFactory.createAddOnly(512);
                                                    }
                                                    if (!BuddyPluginNetwork.this.ygm_unauth_bloom.contains(address)) {
                                                        BuddyPluginNetwork.this.ygm_unauth_bloom.add(address);
                                                        this.unauth_permitted = true;
                                                    }
                                                    break block19;
                                                }
                                            }
                                            byte[] signed_stuff = (byte[])map.get("ss");
                                            Map payload = BuddyPluginNetwork.this.verifyAndExtract(signed_stuff, pk);
                                            if (payload != null && buddy.addYGMMarker(rand = ((Long)payload.get("r")).longValue())) {
                                                this.new_ygm_buddies.add(buddy);
                                            }
                                        }
                                        catch (Throwable e) {
                                            BuddyPluginNetwork.this.log(null, "Read failed", e);
                                        }
                                    } else if (type == 5 || type == 4) {
                                        DDBDetails e = DDBDetails.this;
                                        synchronized (e) {
                                            DDBDetails.this.ygm_active = false;
                                        }
                                        if (this.new_ygm_buddies.size() > 0 || this.unauth_permitted) {
                                            BuddyPluginBuddy[] b = new BuddyPluginBuddy[this.new_ygm_buddies.size()];
                                            this.new_ygm_buddies.toArray(b);
                                            BuddyPluginNetwork.this.fireYGM(b);
                                        }
                                    }
                                }
                            }
                        }, key, 120000L, 1);
                        active = true;
                        boolean write_bogus_ygm = false;
                        DDBDetails dDBDetails2 = this;
                        synchronized (dDBDetails2) {
                            if (!this.bogus_ygm_written) {
                                write_bogus_ygm = true;
                                this.bogus_ygm_written = true;
                            }
                        }
                        if (write_bogus_ygm) {
                            String reason2 = "Friend YGM write for myself";
                            HashMap envelope = new HashMap();
                            DistributedDatabaseValue value = this.ddb.createValue(BEncoder.encode(envelope));
                            BuddyPluginNetwork.this.logMessage(null, "Friend YGM write for myself starts");
                            this.ddb.write(new DistributedDatabaseListener(){

                                @Override
                                public void event(DistributedDatabaseEvent event2) {
                                    int type = event2.getType();
                                    if (type == 4) {
                                        BuddyPluginNetwork.this.logMessage(null, "Friend YGM write for myself complete");
                                    }
                                }
                            }, key, value);
                        }
                    }
                    catch (Throwable e) {
                        BuddyPluginNetwork.this.logMessage(null, "YGM check failed", e);
                        if (active) break block25;
                        DDBDetails dDBDetails3 = this;
                        synchronized (dDBDetails3) {
                            this.ygm_active = false;
                            break block25;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!active) {
                        DDBDetails dDBDetails4 = this;
                        synchronized (dDBDetails4) {
                            this.ygm_active = false;
                        }
                    }
                    throw throwable;
                }
                if (!active) {
                    DDBDetails dDBDetails5 = this;
                    synchronized (dDBDetails5) {
                        this.ygm_active = false;
                    }
                }
            }
        }

        protected void setMessagePending(final BuddyPluginBuddy buddy, final operationListener listener) throws BuddyPluginException {
            try {
                final String reason = "Friend YGM write for " + buddy.getName();
                HashMap<String, Long> payload = new HashMap<String, Long>();
                payload.put("r", new Long(BuddyPluginNetwork.this.random.nextLong()));
                byte[] signed_payload = BuddyPluginNetwork.this.signAndInsert(payload, reason);
                HashMap<String, byte[]> envelope = new HashMap<String, byte[]>();
                envelope.put("pk", BuddyPluginNetwork.this.ecc_handler.getPublicKey(reason));
                envelope.put("ss", signed_payload);
                DistributedDatabaseValue value = this.ddb.createValue(BEncoder.encode(envelope));
                BuddyPluginNetwork.this.logMessage(buddy, String.valueOf(reason) + " starts: " + payload);
                DistributedDatabaseKey key = this.getYGMKey(buddy.getRawPublicKey(), reason);
                this.ddb.write(new DistributedDatabaseListener(){

                    @Override
                    public void event(DistributedDatabaseEvent event2) {
                        int type = event2.getType();
                        if (type == 5 || type == 4) {
                            BuddyPluginNetwork.this.logMessage(buddy, String.valueOf(reason) + " complete");
                            listener.complete();
                        }
                    }
                }, key, value);
            }
            catch (Throwable e) {
                try {
                    BuddyPluginNetwork.this.rethrow("Failed to publish YGM", e);
                }
                finally {
                    listener.complete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateKey() {
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                PublishDetails new_publish = this.latest_publish.getCopy();
                new_publish.setPublicKey(null);
                this.last_payload = null;
                this.updatePublish(new_publish);
            }
        }

        protected void updatePublish() {
            if (this.latest_publish.isEnabled()) {
                this.updatePublish(this.latest_publish);
            }
        }

        protected void updatePublish(final PublishDetails details) {
            this.latest_publish = details;
            if (!BuddyPluginNetwork.this.ready_to_publish) {
                return;
            }
            this.publish_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    if (DDBDetails.this.publish_dispatcher.getQueueSize() > 0) {
                        return;
                    }
                    if (details.isEnabled()) {
                        boolean valid = false;
                        InetSocketAddress[] isas = details.getIPs();
                        if (isas != null) {
                            InetSocketAddress[] inetSocketAddressArray = isas;
                            int n = isas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                InetSocketAddress isa = inetSocketAddressArray[n2];
                                if (isa != null) {
                                    if (isa.isUnresolved()) {
                                        String host = AddressUtils.getHostAddress(isa);
                                        if (host != null && !host.isEmpty()) {
                                            valid = true;
                                        }
                                    } else {
                                        valid = true;
                                    }
                                }
                                ++n2;
                            }
                        }
                        if (!valid) {
                            DDBDetails.this.updateIPWithDelay();
                            return;
                        }
                    }
                    DDBDetails.this.updatePublishSupport(details);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void updatePublishSupport(PublishDetails details) {
            PublishDetails existing_details;
            boolean log_this;
            byte[] key_to_remove = null;
            DDBDetails dDBDetails = this;
            synchronized (dDBDetails) {
                log_this = !this.current_publish.getString().equals(details.getString());
                existing_details = this.current_publish;
                if (!details.isEnabled()) {
                    if (this.current_publish.isPublished()) {
                        key_to_remove = this.current_publish.getPublicKey();
                    }
                } else {
                    byte[] existing_key;
                    if (details.getPublicKey() == null) {
                        try {
                            details.setPublicKey(BuddyPluginNetwork.this.ecc_handler.getPublicKey("Creating online status key"));
                        }
                        catch (Throwable e) {
                            BuddyPluginNetwork.this.log(null, "Failed to publish details", e);
                            return;
                        }
                    }
                    if (this.current_publish.isPublished() && !Arrays.equals(existing_key = this.current_publish.getPublicKey(), details.getPublicKey())) {
                        key_to_remove = existing_key;
                    }
                }
                this.current_publish = details;
            }
            if (key_to_remove != null) {
                BuddyPluginNetwork.this.log(null, "Removing old status publish: " + existing_details.getString());
                try {
                    this.ddb.delete(new DistributedDatabaseListener(){

                        @Override
                        public void event(DistributedDatabaseEvent event2) {
                        }
                    }, this.getStatusKey(key_to_remove, "Friend status de-registration for old key"));
                }
                catch (Throwable e) {
                    BuddyPluginNetwork.this.log(null, "Failed to remove existing publish", e);
                }
            }
            if (details.isEnabled()) {
                String nick;
                InetSocketAddress[] isas = details.getIPs();
                InetSocketAddress isa = null;
                InetAddress ia = null;
                InetAddress ia6 = null;
                if (isas != null) {
                    InetSocketAddress[] inetSocketAddressArray = isas;
                    int n = isas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InetSocketAddress a = inetSocketAddressArray[n2];
                        InetAddress address = a.getAddress();
                        if (address == null || address instanceof Inet4Address || isas.length == 1) {
                            isa = a;
                            ia = address;
                        } else {
                            ia6 = address;
                        }
                        ++n2;
                    }
                }
                if (ia != null && (ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress())) {
                    BuddyPluginNetwork.this.log(null, "Can't publish as ip address is invalid: " + details.getString());
                    return;
                }
                details.setPublished(true);
                HashMap<String, Object> payload = new HashMap<String, Object>();
                if (details.getTCPPort() > 0) {
                    payload.put("t", new Long(details.getTCPPort()));
                }
                if (details.getUDPPort() > 0) {
                    payload.put("u", new Long(details.getUDPPort()));
                }
                if (ia != null) {
                    payload.put("i", ia.getAddress());
                } else {
                    String ip_str = AddressUtils.getHostAddress(isa);
                    payload.put("h", ip_str);
                }
                if (!(ia6 == null || ia != null && ia.equals(ia6))) {
                    payload.put("i6", ia6.getAddress());
                }
                if ((nick = details.getNickName()) != null) {
                    if (nick.length() > 32) {
                        nick = nick.substring(0, 32);
                    }
                    payload.put("n", nick);
                }
                payload.put("o", new Long(details.getOnlineStatus()));
                DDBDetails dDBDetails2 = this;
                synchronized (dDBDetails2) {
                    try {
                        long elapsed;
                        byte[] test = BEncoder.encode(payload);
                        if (this.last_payload != null && Arrays.equals(this.last_payload, test) && (elapsed = SystemTime.getMonotonousTime() - this.last_publish_start) < (long)(this.diversified ? 3600000 : 600000)) {
                            return;
                        }
                        this.last_payload = test;
                    }
                    catch (Throwable test) {
                        // empty catch block
                    }
                }
                ++this.status_seq;
                int next_seq = this.status_seq++;
                if (next_seq == 0) {
                    next_seq = this.status_seq;
                }
                details.setSequence(next_seq);
                payload.put("s", new Long(next_seq));
                payload.put("v", new Long(2L));
                boolean failed_to_get_key = true;
                try {
                    byte[] data = BEncoder.encode(payload);
                    DistributedDatabaseKey key = this.getStatusKey(details.getPublicKey(), "My buddy status registration " + payload);
                    byte[] signature = BuddyPluginNetwork.this.ecc_handler.sign(data, "Friend online status");
                    failed_to_get_key = false;
                    byte[] signed_payload = new byte[1 + signature.length + data.length];
                    signed_payload[0] = (byte)signature.length;
                    System.arraycopy(signature, 0, signed_payload, 1, signature.length);
                    System.arraycopy(data, 0, signed_payload, 1 + signature.length, data.length);
                    DistributedDatabaseValue value = this.ddb.createValue(signed_payload);
                    final AESemaphore sem = new AESemaphore("BuddyPlugin:reg");
                    if (log_this) {
                        BuddyPluginNetwork.this.logMessage(null, "Publishing status starts: " + details.getString());
                    }
                    this.last_publish_start = SystemTime.getMonotonousTime();
                    this.ddb.write(new DistributedDatabaseListener(){
                        private List<DistributedDatabaseContact> write_contacts = new ArrayList<DistributedDatabaseContact>();

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void event(DistributedDatabaseEvent event2) {
                            int type = event2.getType();
                            if (type == 1) {
                                this.write_contacts.add(event2.getContact());
                            } else if (type == 8) {
                                DDBDetails.this.diversified = true;
                            } else if (type == 5 || type == 4) {
                                List list = DDBDetails.this.publish_write_contacts;
                                synchronized (list) {
                                    DDBDetails.this.publish_write_contacts.clear();
                                    DDBDetails.this.publish_write_contacts.addAll(this.write_contacts);
                                }
                                sem.release();
                            }
                        }
                    }, key, value);
                    sem.reserve();
                    if (!log_this) return;
                    BuddyPluginNetwork.this.logMessage(null, "My status publish complete");
                    return;
                }
                catch (Throwable e) {
                    BuddyPluginNetwork.this.logMessage(null, "Failed to publish online status", e);
                    if (!failed_to_get_key) return;
                    DDBDetails dDBDetails3 = this;
                    synchronized (dDBDetails3) {
                        if (this.republish_delay_event != null) {
                            return;
                        }
                        if (this.last_publish_start != 0L && SystemTime.getMonotonousTime() - this.last_publish_start <= 600000L) return;
                        BuddyPluginNetwork.this.log(null, "Rescheduling publish as failed to get key");
                        this.republish_delay_event = SimpleTimer.addEvent("BuddyPlugin:republish", SystemTime.getCurrentTime() + 60000L, new TimerEventPerformer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform(TimerEvent event2) {
                                BuddyPluginNetwork buddyPluginNetwork = BuddyPluginNetwork.this;
                                synchronized (buddyPluginNetwork) {
                                    DDBDetails.this.republish_delay_event = null;
                                }
                                if ((DDBDetails.this.last_publish_start == 0L || SystemTime.getMonotonousTime() - DDBDetails.this.last_publish_start > 600000L) && DDBDetails.this.latest_publish.isEnabled()) {
                                    DDBDetails.this.updatePublish(DDBDetails.this.latest_publish);
                                }
                            }
                        });
                        return;
                    }
                }
            }
            dDBDetails = this;
            synchronized (dDBDetails) {
                this.last_payload = null;
                return;
            }
        }

        protected void updateBuddyStatus(final BuddyPluginBuddy buddy, final Runnable failed_callback) {
            try {
                final byte[] public_key = buddy.getRawPublicKey();
                DistributedDatabaseKey key = this.getStatusKey(public_key, "Friend status check for " + buddy.getName());
                this.ddb.read(new DistributedDatabaseListener(){
                    private long latest_time;
                    private Map status;
                    private boolean status_ipv4;
                    private boolean status_ipv6;

                    @Override
                    public void event(DistributedDatabaseEvent event2) {
                        block18: {
                            int type = event2.getType();
                            if (type == 2) {
                                try {
                                    DistributedDatabaseValue value = event2.getValue();
                                    long time = value.getCreationTime();
                                    if (time <= this.latest_time) break block18;
                                    byte[] signed_stuff = (byte[])value.getValue(byte[].class);
                                    Map new_status = BuddyPluginNetwork.this.verifyAndExtract(signed_stuff, public_key);
                                    if (new_status == null) break block18;
                                    this.status = new_status;
                                    this.latest_time = time;
                                    InetSocketAddress ias = event2.getContact().getAddress();
                                    InetAddress ia = ias.getAddress();
                                    if (ia == null || ia instanceof Inet4Address) {
                                        this.status_ipv4 = true;
                                        break block18;
                                    }
                                    this.status_ipv6 = true;
                                }
                                catch (Throwable e) {
                                    BuddyPluginNetwork.this.log(buddy, "Read failed", e);
                                }
                            } else if (type == 5 || type == 4) {
                                if (this.status == null) {
                                    failed_callback.run();
                                } else {
                                    try {
                                        boolean valid;
                                        byte[] b_v6;
                                        InetSocketAddress ias;
                                        Long l_tcp_port = (Long)this.status.get("t");
                                        Long l_udp_port = (Long)this.status.get("u");
                                        int tcp_port = l_tcp_port == null ? 0 : l_tcp_port.intValue();
                                        int udp_port = l_udp_port == null ? 0 : l_udp_port.intValue();
                                        byte[] b = (byte[])this.status.get("i");
                                        if (b != null) {
                                            InetAddress ip = InetAddress.getByAddress(b);
                                            ias = new InetSocketAddress(ip, 0);
                                        } else {
                                            String host = MapUtils.getMapString(this.status, "h", null);
                                            ias = InetSocketAddress.createUnresolved(host, 0);
                                        }
                                        if (!this.status_ipv4 && (b_v6 = (byte[])this.status.get("i6")) != null) {
                                            InetAddress ip = InetAddress.getByAddress(b_v6);
                                            ias = new InetSocketAddress(ip, 0);
                                        }
                                        boolean bl = valid = ias != null;
                                        if (valid) {
                                            if (ias.isUnresolved()) {
                                                String host = AddressUtils.getHostAddress(ias);
                                                if (host != null && !host.isEmpty()) {
                                                    valid = true;
                                                }
                                            } else {
                                                valid = true;
                                            }
                                        }
                                        if (valid) {
                                            String nick = BuddyPluginNetwork.this.decodeString((byte[])this.status.get("n"));
                                            Long l_seq = (Long)this.status.get("s");
                                            int seq = l_seq == null ? 0 : l_seq.intValue();
                                            Long l_os = (Long)this.status.get("o");
                                            int os = l_os == null ? 0 : l_os.intValue();
                                            Long l_ver = (Long)this.status.get("v");
                                            int ver = l_ver == null ? 1 : l_ver.intValue();
                                            buddy.statusCheckComplete(DDBDetails.this, this.latest_time, ias, tcp_port, udp_port, nick, os, seq, ver);
                                        }
                                    }
                                    catch (Throwable e) {
                                        failed_callback.run();
                                        BuddyPluginNetwork.this.log(buddy, "Status decode failed", e);
                                    }
                                }
                            }
                        }
                    }
                }, key, 120000L);
            }
            catch (Throwable e) {
                failed_callback.run();
                BuddyPluginNetwork.this.log(buddy, "Friend status update failed: " + buddy.getString(), e);
            }
        }

        protected DistributedDatabaseKey getStatusKey(byte[] public_key, String reason) throws Exception {
            byte[] key_prefix = "azbuddy:status".getBytes();
            byte[] key_bytes = new byte[key_prefix.length + public_key.length];
            System.arraycopy(key_prefix, 0, key_bytes, 0, key_prefix.length);
            System.arraycopy(public_key, 0, key_bytes, key_prefix.length, public_key.length);
            DistributedDatabaseKey key = this.ddb.createKey(key_bytes, reason);
            return key;
        }

        protected DistributedDatabaseKey getYGMKey(byte[] public_key, String reason) throws Exception {
            byte[] key_prefix = "azbuddy:ygm".getBytes();
            byte[] key_bytes = new byte[key_prefix.length + public_key.length];
            System.arraycopy(key_prefix, 0, key_bytes, 0, key_prefix.length);
            System.arraycopy(public_key, 0, key_bytes, key_prefix.length, public_key.length);
            DistributedDatabaseKey key = this.ddb.createKey(key_bytes, reason);
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closedown() {
            boolean restarting = CoreFactory.isCoreAvailable() ? CoreFactory.getSingleton().isRestarting() : false;
            BuddyPluginNetwork.this.logMessage(null, "   closing buddy connections");
            int i = 0;
            while (i < BuddyPluginNetwork.this.buddies.size()) {
                ((BuddyPluginBuddy)BuddyPluginNetwork.this.buddies.get(i)).sendCloseRequest(restarting);
                ++i;
            }
            if (!restarting) {
                byte[] key_to_remove;
                BuddyPluginNetwork.this.logMessage(null, "   updating online status");
                ArrayList<DistributedDatabaseContact> contacts = new ArrayList<DistributedDatabaseContact>();
                List<DistributedDatabaseContact> list = this.publish_write_contacts;
                synchronized (list) {
                    contacts.addAll(this.publish_write_contacts);
                }
                DDBDetails dDBDetails = this;
                synchronized (dDBDetails) {
                    key_to_remove = this.current_publish.getPublicKey();
                }
                if (contacts.size() == 0 || key_to_remove == null) {
                    return;
                }
                DistributedDatabaseContact[] contact_a = new DistributedDatabaseContact[contacts.size()];
                contacts.toArray(contact_a);
                try {
                    this.ddb.delete(new DistributedDatabaseListener(){

                        @Override
                        public void event(DistributedDatabaseEvent event2) {
                            event2.getType();
                        }
                    }, this.getStatusKey(key_to_remove, "Friend status de-registration for closedown"), contact_a);
                }
                catch (Throwable e) {
                    BuddyPluginNetwork.this.log(null, "Failed to remove existing publish", e);
                }
            }
        }
    }

    private static class PublishDetails
    implements Cloneable {
        private final String network;
        private byte[] public_key;
        private InetSocketAddress[] ips;
        private int tcp_port;
        private int udp_port;
        private String nick_name;
        private int online_status = 0;
        private boolean enabled;
        private boolean published;
        private int sequence;

        private PublishDetails(String _network) {
            this.network = _network;
        }

        protected PublishDetails getCopy() {
            try {
                PublishDetails copy = (PublishDetails)this.clone();
                copy.published = false;
                return copy;
            }
            catch (Throwable e) {
                return null;
            }
        }

        protected String getNetwork() {
            return this.network;
        }

        protected boolean isPublished() {
            return this.published;
        }

        protected void setPublished(boolean b) {
            this.published = b;
        }

        protected boolean isEnabled() {
            return this.enabled;
        }

        protected void setEnabled(boolean _enabled) {
            this.enabled = _enabled;
        }

        protected void setSequence(int seq) {
            this.sequence = seq;
        }

        protected int getSequence() {
            return this.sequence;
        }

        protected byte[] getPublicKey() {
            return this.public_key;
        }

        protected void setPublicKey(byte[] k) {
            this.public_key = k;
        }

        protected InetSocketAddress[] getIPs() {
            return this.ips;
        }

        protected void setIPs(InetSocketAddress[] _ips) {
            this.ips = _ips;
        }

        protected int getTCPPort() {
            return this.tcp_port;
        }

        protected void setTCPPort(int _port) {
            this.tcp_port = _port;
        }

        protected int getUDPPort() {
            return this.udp_port;
        }

        protected void setUDPPort(int _port) {
            this.udp_port = _port;
        }

        protected String getNickName() {
            return this.nick_name;
        }

        protected void setNickName(String n) {
            this.nick_name = n;
        }

        protected int getOnlineStatus() {
            return this.online_status;
        }

        protected void setOnlineStatus(int _status) {
            this.online_status = _status;
        }

        protected String getString() {
            String ip_str = "";
            InetSocketAddress[] ips = this.getIPs();
            if (ips == null) {
                ip_str = "null";
            } else {
                InetSocketAddress[] inetSocketAddressArray = ips;
                int n = ips.length;
                int n2 = 0;
                while (n2 < n) {
                    InetSocketAddress a = inetSocketAddressArray[n2];
                    ip_str = String.valueOf(ip_str) + (ip_str.isEmpty() ? "" : "/") + a;
                    ++n2;
                }
            }
            return "enabled=" + this.enabled + ",ip=" + ip_str + ",tcp=" + this.tcp_port + ",udp=" + this.udp_port + ",stat=" + this.online_status + ",key=" + (this.public_key == null ? "<none>" : Base32.encode(this.public_key));
        }
    }

    protected static interface operationListener {
        public void complete();
    }
}

