/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.peers.PeerDescriptor;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginViewInterface;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BuddyPluginUtils {
    private static Object chat_lock = new Object();
    private static BuddyPluginBeta.ChatInstance country_chat;
    private static String[] country_info;
    public static final String CK_CC = "BuddyPluginUtils::CC";
    private static BuddyPluginBeta.ChatInstance language_chat;
    private static String[] language_info;
    public static final String CK_LANG = "BuddyPluginUtils::Lang";
    private static AsyncDispatcher peek_dispatcher;

    static {
        peek_dispatcher = new AsyncDispatcher("peeker");
    }

    protected static void betaInit(BuddyPluginBeta bpb) {
        new AEThread2("BPU"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    block25: {
                        try {
                            String[] info;
                            InetAddress ia = NetworkAdmin.getSingleton().getDefaultPublicAddress();
                            if (ia == null || (info = PeerUtils.getCountryDetails(ia)) == null) break block25;
                            Object object = chat_lock;
                            synchronized (object) {
                                info[0] = info[0].toUpperCase(Locale.US);
                                String cc = info[0];
                                if (country_chat == null || country_info == null || !country_info[0].equals(cc)) {
                                    String key;
                                    country_info = info;
                                    if (country_chat != null) {
                                        country_chat.destroy();
                                        country_chat = null;
                                    }
                                    String chat_key = String.valueOf(Constants.APP_NAME) + ": Country: " + cc;
                                    country_chat = BuddyPluginUtils.getBetaPlugin().peekChatInstance("Public", chat_key);
                                    if (country_chat == null && !COConfigurationManager.getBooleanParameter(key = "dchat.channel.cc.done." + cc, false)) {
                                        country_chat = BuddyPluginUtils.getChat("Public", chat_key);
                                        if (country_chat != null) {
                                            country_chat.setFavourite(true);
                                            COConfigurationManager.setParameter(key, true);
                                        }
                                    }
                                    if (country_chat != null) {
                                        country_chat.setUserData(BuddyPluginUtils.CK_CC, info[1]);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        Object object = chat_lock;
                        synchronized (object) {
                            Locale locale = MessageText.getCurrentLocale();
                            String display_name = locale.getDisplayName();
                            String lang = locale.getLanguage();
                            String country = locale.getCountry();
                            String variant = locale.getVariant();
                            if (country.length() > 0) {
                                lang = String.valueOf(lang) + "_" + country;
                            }
                            if (variant.length() > 0) {
                                lang = String.valueOf(lang) + "_" + variant;
                            }
                            if (language_chat == null || language_info == null || !language_info[0].equals(lang)) {
                                String key;
                                language_info = new String[]{lang, display_name};
                                if (language_chat != null) {
                                    language_chat.destroy();
                                    language_chat = null;
                                }
                                String chat_key = String.valueOf(Constants.APP_NAME) + ": Language: " + lang;
                                language_chat = BuddyPluginUtils.getBetaPlugin().peekChatInstance("Public", chat_key);
                                if (language_chat == null && !COConfigurationManager.getBooleanParameter(key = "dchat.channel.lang.done." + lang, false)) {
                                    language_chat = BuddyPluginUtils.getChat("Public", chat_key);
                                    if (language_chat != null) {
                                        language_chat.setFavourite(true);
                                        COConfigurationManager.setParameter(key, true);
                                    }
                                }
                                if (language_chat != null) {
                                    language_chat.setUserData(BuddyPluginUtils.CK_LANG, display_name);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuddyPluginBeta.ChatInstance getCountryChat() {
        Object object = chat_lock;
        synchronized (object) {
            if (country_chat == null && country_info != null) {
                String chat_key = String.valueOf(Constants.APP_NAME) + ": Country: " + country_info[0];
                country_chat = BuddyPluginUtils.getChat("Public", chat_key);
                country_chat.setUserData(CK_CC, country_info[1]);
            }
        }
        return country_chat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuddyPluginBeta.ChatInstance getLanguageChat() {
        Object object = chat_lock;
        synchronized (object) {
            if (language_chat == null && language_info != null) {
                String chat_key = String.valueOf(Constants.APP_NAME) + ": Language: " + language_info[0];
                language_chat = BuddyPluginUtils.getChat("Public", chat_key);
                language_chat.setUserData(CK_LANG, language_info[1]);
            }
        }
        return language_chat;
    }

    public static BuddyPlugin getPlugin() {
        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azbuddy", true);
        if (pi != null) {
            return (BuddyPlugin)pi.getPlugin();
        }
        return null;
    }

    public static BuddyPluginBeta getBetaPlugin() {
        BuddyPluginBeta beta;
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && (beta = bp.getBeta()).isAvailable()) {
            return beta;
        }
        return null;
    }

    public static boolean isBetaChatEnabled() {
        return BuddyPlugin.isBetaChatEnabled();
    }

    public static boolean isBetaChatAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable();
        }
        return false;
    }

    public static boolean isBetaChatAnonAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable() && bp.getBeta().isI2PAvailable();
        }
        return false;
    }

    public static void createBetaChat(final String network, final String key, final CreateChatCallback callback) {
        new AEThread2("Chat create async"){

            @Override
            public void run() {
                block8: {
                    BuddyPluginBeta.ChatInstance result = null;
                    try {
                        try {
                            BuddyPlugin bp = BuddyPluginUtils.getPlugin();
                            result = bp.getBeta().getAndShowChat(network, key);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            if (callback != null) {
                                callback.complete(result);
                            }
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        if (callback != null) {
                            callback.complete(result);
                        }
                        throw throwable;
                    }
                    if (callback != null) {
                        callback.complete(result);
                    }
                }
            }
        }.start();
    }

    public static Map<String, Object> peekChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(net, key);
        }
        return null;
    }

    public static Map<String, Object> peekChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(download, false);
        }
        return null;
    }

    public static List<BuddyPluginBeta.ChatInstance> peekChatInstances(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChatInstances(download);
        }
        return new ArrayList<BuddyPluginBeta.ChatInstance>();
    }

    public static void peekChatAsync(final String net, final String key, final Runnable done) {
        boolean async = false;
        try {
            if (BuddyPluginUtils.isBetaChatAvailable()) {
                if (net != "Public" && !BuddyPluginUtils.isBetaChatAnonAvailable()) {
                    return;
                }
                if (peek_dispatcher.getQueueSize() > 200) {
                    return;
                }
                peek_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        try {
                            Map<String, Object> peek_data = BuddyPluginUtils.peekChat(net, key);
                            if (peek_data != null) {
                                BuddyPluginBeta.ChatInstance chat;
                                Number message_count = (Number)peek_data.get("m");
                                Number node_count = (Number)peek_data.get("n");
                                if (message_count != null && node_count != null && message_count.intValue() > 0 && (chat = BuddyPluginUtils.getChat(net, key)) != null) {
                                    chat.setAutoNotify(true);
                                }
                            }
                        }
                        finally {
                            done.run();
                        }
                    }
                });
                async = true;
            }
        }
        finally {
            if (!async) {
                done.run();
            }
        }
    }

    public static List<BuddyPluginBeta.ChatInstance> getChats() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().getChats();
        }
        return new ArrayList<BuddyPluginBeta.ChatInstance>();
    }

    public static BuddyPluginBeta.ChatInstance getChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            try {
                return bp.getBeta().getChat(net, key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(String net, String key, Map<String, Object> options) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            try {
                return bp.getBeta().getChat(net, key, options);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().getChat(download);
        }
        return null;
    }

    public static BuddyPluginViewInterface.View buildChatView(Map<String, Object> properties, BuddyPluginViewInterface.ViewListener listener) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && bp.getBeta().isAvailable()) {
            BuddyPluginViewInterface ui = bp.getSWTUI();
            if (ui != null) {
                return ui.buildView(properties, listener);
            }
            ViewWrapper wrapper = new ViewWrapper(bp, properties, listener);
            return wrapper;
        }
        Debug.out("Can't build view - bp=" + bp);
        return null;
    }

    public static String getChatKey(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        return BuddyPluginUtils.getChatKey(PluginCoreUtils.wrap(torrent));
    }

    public static String getChatKey(Download download) {
        return BuddyPluginUtils.getChatKey(download.getTorrent());
    }

    public static String getChatKey(Peer peer) {
        if (peer != null) {
            try {
                InetAddress ia = AddressUtils.getByName(peer.getIp());
                String[] info = PeerUtils.getCountryDetails(ia);
                if (info != null) {
                    String cc = info[0].toUpperCase(Locale.US);
                    String chat_key = String.valueOf(Constants.APP_NAME) + ": Country: " + cc;
                    return chat_key;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getChatKey(PeerDescriptor peer) {
        if (peer != null) {
            try {
                InetAddress ia = AddressUtils.getByName(peer.getIP());
                String[] info = PeerUtils.getCountryDetails(ia);
                if (info != null) {
                    String cc = info[0].toUpperCase(Locale.US);
                    String chat_key = String.valueOf(Constants.APP_NAME) + ": Country: " + cc;
                    return chat_key;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getChatKey(Torrent torrent) {
        if (torrent == null || torrent.isPrivate()) {
            return null;
        }
        String torrent_name = null;
        try {
            TOTorrent to_torrent = PluginCoreUtils.unwrap(torrent);
            torrent_name = to_torrent.getUTF8Name();
            if (torrent_name == null) {
                torrent_name = new String(to_torrent.getName(), "UTF-8");
            }
        }
        catch (Throwable to_torrent) {
            // empty catch block
        }
        if (torrent_name == null) {
            torrent_name = torrent.getName();
        }
        String key = "Download: " + torrent_name + " {" + ByteFormatter.encodeString(torrent.getHash()) + "}";
        return key;
    }

    public static boolean isUnknownDownloadChatKey(String key) {
        byte[] hash;
        String hash_str;
        if (!key.startsWith("Download:")) {
            return false;
        }
        if (!key.endsWith("}")) {
            return false;
        }
        int pos = key.lastIndexOf("{");
        return pos >= 0 && (hash_str = key.substring(pos + 1, key.length() - 1)).length() == 40 && (hash = ByteFormatter.decodeString(hash_str)) != null && CoreFactory.getSingleton().getGlobalManager().getDownloadManager(new HashWrapper(hash)) == null;
    }

    public static String getTrackerChatKey(String url) {
        try {
            return BuddyPluginUtils.getTrackerChatKey(new URL(url));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getTrackerChatKey(URL url) {
        try {
            return "Tracker: " + DNSUtils.getInterestingHostSuffix(url.getHost().toLowerCase(Locale.US));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static interface CreateChatCallback {
        public void complete(BuddyPluginBeta.ChatInstance var1);
    }

    private static class ViewWrapper
    implements BuddyPluginViewInterface.View {
        private Map<String, Object> properties;
        private BuddyPluginViewInterface.ViewListener listener;
        private BuddyPluginViewInterface.View delegate;
        private boolean activated;
        private List<String> drops = new ArrayList<String>();
        private boolean destroyed;

        private ViewWrapper(final BuddyPlugin bp, Map<String, Object> _properties, BuddyPluginViewInterface.ViewListener _listener) {
            this.properties = _properties;
            this.listener = _listener;
            bp.addSWTUIWaiter(new Runnable(){

                @Override
                public void run() {
                    BuddyPluginViewInterface ui = bp.getSWTUI();
                    if (ui != null) {
                        this.setDelegate(ui);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setDelegate(BuddyPluginViewInterface ui) {
            ViewWrapper viewWrapper = this;
            synchronized (viewWrapper) {
                if (this.destroyed) {
                    return;
                }
                this.delegate = ui.buildView(this.properties, this.listener);
                if (this.delegate != null) {
                    if (this.activated) {
                        this.delegate.activate();
                    }
                    for (String drop : this.drops) {
                        this.delegate.handleDrop(drop);
                    }
                    this.drops.clear();
                } else {
                    Debug.out("Failed to build view");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activate() {
            ViewWrapper viewWrapper = this;
            synchronized (viewWrapper) {
                if (this.destroyed) {
                    return;
                }
                if (this.delegate != null) {
                    this.delegate.activate();
                } else {
                    this.activated = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleDrop(String drop) {
            ViewWrapper viewWrapper = this;
            synchronized (viewWrapper) {
                if (this.destroyed) {
                    return;
                }
                if (this.delegate != null) {
                    this.delegate.handleDrop(drop);
                } else {
                    this.drops.add(drop);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            ViewWrapper viewWrapper = this;
            synchronized (viewWrapper) {
                this.destroyed = true;
                if (this.delegate != null) {
                    this.delegate.destroy();
                }
            }
        }
    }
}

