/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.netstatus;

import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTester;

public class NetStatusPlugin
implements Plugin {
    public static final String VIEW_ID = "aznetstatus";
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private BooleanParameter logging_detailed;
    private ActionParameter test_button;
    private StringParameter test_address;
    private NetStatusProtocolTester protocol_tester;
    private AESemaphore protocol_tester_sem = new AESemaphore("ProtTestSem");

    public static void load(PluginInterface plugin_interface) {
        String name = plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.aznetstatus.title");
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", name);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.logger = this.plugin_interface.getLogger().getChannel("NetStatus");
        this.logger.setDiagnostic();
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.aznetstatus.title");
        this.logging_detailed = config.addBooleanParameter2("plugin.aznetstatus.logfull", "plugin.aznetstatus.logfull", false);
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType().equals("swt")) {
                    try {
                        Class.forName("com.biglybt.ui.swt.plugin.net.netstatus.swt.NetStatusPluginView").getMethod("initSWTUI", UIInstance.class).invoke(null, instance);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                new AEThread2("NetstatusPlugin:init", true){

                    @Override
                    public void run() {
                        try {
                            NetStatusPlugin.this.protocol_tester = new NetStatusProtocolTester(NetStatusPlugin.this, NetStatusPlugin.this.plugin_interface);
                            if (NetStatusPlugin.this.test_button != null) {
                                NetStatusPlugin.this.test_button.setEnabled(true);
                            }
                        }
                        finally {
                            NetStatusPlugin.this.protocol_tester_sem.releaseForever();
                        }
                    }
                }.start();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    public boolean isDetailedLogging() {
        return this.logging_detailed.getValue();
    }

    public NetStatusProtocolTester getProtocolTester() {
        this.protocol_tester_sem.reserve();
        return this.protocol_tester;
    }

    public void setBooleanParameter(String name, boolean value) {
        this.plugin_interface.getPluginconfig().setPluginParameter(name, value);
    }

    public boolean getBooleanParameter(String name, boolean def) {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter(name, def);
    }

    public void log(String str) {
        this.logger.log(str);
    }

    public void log(String str, Throwable e) {
        this.logger.log(String.valueOf(str) + ": " + Debug.getNestedExceptionMessage(e));
    }
}

