/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.netstatus;

import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.ddb.DistributedDatabaseContact;
import com.biglybt.pif.ddb.DistributedDatabaseException;
import com.biglybt.pif.ddb.DistributedDatabaseKey;
import com.biglybt.pif.ddb.DistributedDatabaseTransferHandler;
import com.biglybt.pif.ddb.DistributedDatabaseTransferType;
import com.biglybt.pif.ddb.DistributedDatabaseValue;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.net.netstatus.NetStatusPlugin;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTesterBT;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTesterListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NetStatusProtocolTester
implements DistributedDatabaseTransferHandler {
    private static final int REQUEST_HISTORY_MAX = 64;
    private static final int MAX_ACTIVE_TESTS = 3;
    private static final int MAX_TEST_TIME = 120000;
    private static final int TEST_TYPE_BT = 1;
    private static final int VERSION_INITIAL = 1;
    private static final int CURRENT_VERSION = 1;
    private static final int BT_MAX_SLAVES = 8;
    private NetStatusPlugin plugin;
    private PluginInterface plugin_interface;
    private DistributedDatabase ddb;
    private DHTPlugin dht_plugin;
    private testXferType transfer_type = new testXferType();
    private Map request_history = new LinkedHashMap(64, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 64;
        }
    };
    private List active_tests = new ArrayList();
    private TimerEventPeriodic timer_event = null;

    protected NetStatusProtocolTester(NetStatusPlugin _plugin, PluginInterface _plugin_interface) {
        this.plugin = _plugin;
        this.plugin_interface = _plugin_interface;
        try {
            PluginInterface dht_pi = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi != null) {
                this.dht_plugin = (DHTPlugin)dht_pi.getPlugin();
            }
            this.ddb = this.plugin_interface.getDistributedDatabase();
            if (this.ddb.isAvailable()) {
                this.ddb.addTransferHandler(this.transfer_type, this);
                this.log("DDB transfer type registered");
            } else {
                this.log("DDB transfer type not registered, DDB unavailable");
            }
        }
        catch (Throwable e) {
            this.log("DDB transfer type registration failed", e);
        }
    }

    public NetStatusProtocolTesterBT runTest(NetStatusProtocolTesterListener listener) {
        return this.runTest("", listener);
    }

    public NetStatusProtocolTesterBT runTest(String test_address, final NetStatusProtocolTesterListener listener) {
        NetStatusProtocolTesterBT bt_tester;
        block15: {
            block13: {
                String[] bits;
                block14: {
                    bt_tester = this.createTester(listener);
                    if (test_address.length() == 0) {
                        DHT[] dhts = this.dht_plugin.getDHTs();
                        DHT target_dht = null;
                        InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                        int target_network = bind_ip instanceof Inet6Address && !bind_ip.isAnyLocalAddress() ? 3 : 0;
                        int i = 0;
                        while (i < dhts.length) {
                            if (dhts[i].getTransport().getNetwork() == target_network) {
                                target_dht = dhts[i];
                                break;
                            }
                            ++i;
                        }
                        if (target_dht == null && dhts.length > 0) {
                            target_dht = dhts[0];
                            target_network = target_dht.getTransport().getNetwork();
                        }
                        if (target_dht == null) {
                            listener.logError("Distributed database unavailable");
                        } else {
                            DHTTransportContact[] contacts = target_dht.getTransport().getReachableContacts();
                            final ArrayList<DHTTransportContact> f_contacts = new ArrayList<DHTTransportContact>(Arrays.asList(contacts));
                            final int[] ok = new int[1];
                            final int num_threads = Math.min(8, contacts.length);
                            listener.log("Searching " + contacts.length + " contacts for " + num_threads + " test targets", false);
                            final AESemaphore sem = new AESemaphore("NetStatusProbe");
                            int i2 = 0;
                            while (i2 < num_threads) {
                                new AEThread2("NetStatusProbe", true){

                                    /*
                                     * Exception decompiling
                                     */
                                    @Override
                                    public void run() {
                                        /*
                                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                         * 
                                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                         */
                                        throw new IllegalStateException("Decompilation failed");
                                    }
                                }.start();
                                ++i2;
                            }
                            i2 = 0;
                            while (i2 < num_threads) {
                                sem.reserve();
                                ++i2;
                            }
                            listener.log("Searching complete, " + ok[0] + " targets found", false);
                        }
                        break block13;
                    }
                    bits = test_address.split(":");
                    if (bits.length == 2) break block14;
                    this.log("Invalid address - use <host>:<port> ");
                    NetStatusProtocolTesterBT netStatusProtocolTesterBT = bt_tester;
                    bt_tester.addListener(new NetStatusProtocolTesterListener(){

                        @Override
                        public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                        }

                        @Override
                        public void complete(NetStatusProtocolTesterBT tester) {
                            NetStatusProtocolTester.this.removeFromActive(tester);
                        }

                        @Override
                        public void log(String str, boolean detailed) {
                        }

                        @Override
                        public void logError(String str) {
                        }

                        @Override
                        public void logError(String str, Throwable e) {
                        }
                    });
                    bt_tester.setOutboundConnectionsComplete();
                    new DelayedEvent("NetStatus:killer", 10000L, new AERunnable(listener, bt_tester){
                        private final /* synthetic */ NetStatusProtocolTesterListener val$listener;
                        private final /* synthetic */ NetStatusProtocolTesterBT val$bt_tester;
                        {
                            this.val$listener = netStatusProtocolTesterListener;
                            this.val$bt_tester = netStatusProtocolTesterBT;
                        }

                        @Override
                        public void runSupport() {
                            this.val$listener.log("Destroying tester", false);
                            this.val$bt_tester.destroy();
                        }
                    });
                    return netStatusProtocolTesterBT;
                }
                try {
                    try {
                        InetSocketAddress address = new InetSocketAddress(bits[0].trim(), Integer.parseInt(bits[1].trim()));
                        DistributedDatabaseContact contact = this.ddb.importContact(address);
                        this.tryTest(bt_tester, contact);
                    }
                    catch (Throwable e) {
                        listener.logError("Test failed", e);
                        bt_tester.addListener(new /* invalid duplicate definition of identical inner class */);
                        bt_tester.setOutboundConnectionsComplete();
                        new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    bt_tester.addListener(new /* invalid duplicate definition of identical inner class */);
                    bt_tester.setOutboundConnectionsComplete();
                    new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            bt_tester.addListener(new /* invalid duplicate definition of identical inner class */);
            bt_tester.setOutboundConnectionsComplete();
            new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
        }
        return bt_tester;
    }

    public NetStatusProtocolTesterBT createTester(NetStatusProtocolTesterListener listener) {
        NetStatusProtocolTesterBT bt_tester = new NetStatusProtocolTesterBT(this, true);
        bt_tester.addListener(listener);
        bt_tester.start();
        this.addToActive(bt_tester);
        return bt_tester;
    }

    public boolean tryTest(NetStatusProtocolTesterBT bt_tester, DistributedDatabaseContact contact) {
        byte[] server_hash;
        boolean use_crypto = NetworkManager.getCryptoRequired(0);
        this.log("Trying test to " + contact.getName());
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        request2.put("v", new Long(1L));
        request2.put("t", new Long(1L));
        request2.put("h", bt_tester.getServerHash());
        request2.put("c", new Long(use_crypto ? 1 : 0));
        Map reply = this.sendRequest(contact, request2);
        byte[] byArray = server_hash = reply == null ? null : (byte[])reply.get("h");
        if (server_hash != null) {
            this.log("    " + contact.getName() + " accepted test");
            bt_tester.testOutbound(this.adjustLoopback(contact.getAddress()), server_hash, use_crypto);
            return true;
        }
        this.log("    " + contact.getName() + " declined test");
        return false;
    }

    protected InetSocketAddress adjustLoopback(InetSocketAddress address) {
        InetSocketAddress local = this.dht_plugin.getLocalAddress().getAddress();
        if (local.getAddress().getHostAddress().equals(address.getAddress().getHostAddress())) {
            return new InetSocketAddress("127.0.0.1", address.getPort());
        }
        return address;
    }

    protected Map sendRequest(DistributedDatabaseContact contact, Map request2) {
        DistributedDatabaseValue value;
        block3: {
            try {
                this.log("Sending DDB request to " + contact.getName() + " - " + request2);
                DistributedDatabaseKey key = this.ddb.createKey(BEncoder.encode(request2));
                value = contact.read(null, this.transfer_type, key, 10000L);
                if (value != null) break block3;
                return null;
            }
            catch (Throwable e) {
                this.log("sendRequest failed", e);
                return null;
            }
        }
        Map<String, Object> reply = BDecoder.decode((byte[])value.getValue(byte[].class));
        this.log("    received reply - " + reply);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map receiveRequest(InetSocketAddress originator, Map request2) {
        HashMap<String, Object> reply = new HashMap<String, Object>();
        Long test_type = (Long)request2.get("t");
        reply.put("v", new Long(1L));
        if (test_type != null && test_type.intValue() == 1) {
            byte[] their_hash;
            TCPNetworkManager tcp_man = TCPNetworkManager.getSingleton();
            InetSocketAddress adjusted_originator = this.adjustLoopback(originator);
            boolean test = adjusted_originator.getAddress().isLoopbackAddress();
            if ((test || tcp_man.isDefaultTCPListenerEnabled() && tcp_man.getDefaultTCPListeningPortNumber() == this.ddb.getLocalContact().getAddress().getPort() && SystemTime.getCurrentTime() - tcp_man.getLastIncomingNonLocalConnectionTime() <= 86400000L) && (their_hash = (byte[])request2.get("h")) != null) {
                NetStatusProtocolTesterBT bt_tester;
                List list = this.active_tests;
                synchronized (list) {
                    if (this.active_tests.size() > 3) {
                        this.log("Too many active tests");
                        return reply;
                    }
                    bt_tester = new NetStatusProtocolTesterBT(this, false);
                    bt_tester.start();
                    this.addToActive(bt_tester);
                }
                Long l_crypto = (Long)request2.get("c");
                boolean use_crypto = l_crypto != null && l_crypto == 1L;
                bt_tester.testOutbound(adjusted_originator, their_hash, use_crypto);
                reply.put("h", bt_tester.getServerHash());
            }
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToActive(NetStatusProtocolTesterBT tester) {
        List list = this.active_tests;
        synchronized (list) {
            this.active_tests.add(tester);
            if (this.timer_event == null) {
                this.timer_event = SimpleTimer.addPeriodicEvent("NetStatusProtocolTester:timer", 30000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        long now = SystemTime.getCurrentTime();
                        ArrayList<NetStatusProtocolTesterBT> to_remove = new ArrayList<NetStatusProtocolTesterBT>();
                        List list = NetStatusProtocolTester.this.active_tests;
                        synchronized (list) {
                            int i = 0;
                            while (i < NetStatusProtocolTester.this.active_tests.size()) {
                                NetStatusProtocolTesterBT tester = (NetStatusProtocolTesterBT)NetStatusProtocolTester.this.active_tests.get(i);
                                long start = tester.getStartTime(now);
                                if (now - start > 120000L) {
                                    to_remove.add(tester);
                                }
                                ++i;
                            }
                        }
                        int i = 0;
                        while (i < to_remove.size()) {
                            NetStatusProtocolTester.this.removeFromActive((NetStatusProtocolTesterBT)to_remove.get(i));
                            ++i;
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromActive(NetStatusProtocolTesterBT tester) {
        tester.destroy();
        List list = this.active_tests;
        synchronized (list) {
            this.active_tests.remove(tester);
            if (this.active_tests.size() == 0 && this.timer_event != null) {
                this.timer_event.cancel();
                this.timer_event = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey ddb_key) throws DistributedDatabaseException {
        Object o_key = ddb_key.getKey();
        try {
            byte[] key = (byte[])o_key;
            HashWrapper hw = new HashWrapper(key);
            Map map = this.request_history;
            synchronized (map) {
                if (this.request_history.containsKey(hw)) {
                    return null;
                }
                this.request_history.put(hw, "");
            }
            Map<String, Object> request2 = BDecoder.decode((byte[])o_key);
            this.log("Received DDB request from " + contact.getName() + " - " + request2);
            Map result = this.receiveRequest(contact.getAddress(), request2);
            return this.ddb.createValue(BEncoder.encode(result));
        }
        catch (Throwable e) {
            this.log("DDB read failed", e);
            return null;
        }
    }

    @Override
    public DistributedDatabaseValue write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    public void log(String str) {
        this.plugin.log(str);
    }

    public void log(String str, Throwable e) {
        this.plugin.log(str, e);
    }

    static /* synthetic */ DistributedDatabase access$0(NetStatusProtocolTester netStatusProtocolTester) {
        return netStatusProtocolTester.ddb;
    }

    protected static class testXferType
    implements DistributedDatabaseTransferType {
        protected testXferType() {
        }
    }
}

