/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.simpleapi;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.history.DownloadHistoryManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.subs.util.SubscriptionResultFilterable;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentDownloader;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.webplugin.WebPlugin;
import com.biglybt.util.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SimpleAPIPlugin
extends WebPlugin {
    public static final String PLUGIN_NAME = "Simple API";
    public static final int DEFAULT_PORT = 6906;
    public static final String DEFAULT_ACCESS = "local";
    private static volatile SimpleAPIPlugin singleton;
    private static boolean loaded;
    private static final Properties defaults;
    private static LoggerChannel log_channel;
    private PluginInterface plugin_interface;
    private StringParameter api_key;
    private HyperlinkParameter test_param;

    static {
        defaults = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        Class<SimpleAPIPlugin> clazz = SimpleAPIPlugin.class;
        synchronized (SimpleAPIPlugin.class) {
            if (loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            log_channel = plugin_interface.getLogger().getChannel(PLUGIN_NAME);
            defaults.put("Enable", (Object)false);
            defaults.put("Disablable", (Object)true);
            defaults.put("Root Dir", AETemporaryFileHandler.getTempDirectory().getAbsolutePath());
            defaults.put("Port", (Object)6906);
            defaults.put("Access", DEFAULT_ACCESS);
            defaults.put("DefaultEnableKeepAlive", (Object)true);
            defaults.put("DefaultHideResourceConfig", (Object)true);
            defaults.put("EnablePairing", (Object)false);
            defaults.put("EnableUPNP", (Object)false);
            defaults.put("EnableI2P", (Object)false);
            defaults.put("EnableTor", (Object)false);
            defaults.put("DefaultLoggerChannel", log_channel);
            return;
        }
    }

    public static SimpleAPIPlugin getSingleton() {
        return singleton;
    }

    public SimpleAPIPlugin() {
        super(defaults);
    }

    @Override
    public void initialize(PluginInterface pi) throws PluginException {
        this.plugin_interface = pi;
        singleton = this;
        pi.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        super.initialize(pi);
    }

    @Override
    protected void initStage(int num) {
        if (num == 1) {
            BasicPluginConfigModel config = this.getConfigModel();
            this.api_key = config.addStringParameter2("apikey", "plugin.simpleapi.apikey", "");
            if (this.api_key.getValue().isEmpty()) {
                this.api_key.setValue(this.createAPIKey());
            }
            ActionParameter change = config.addActionParameter2("plugin.simpleapi.apikey.new", "pairing.srp.setpw.doit");
            change.addListener(n -> {
                this.api_key.setValue(this.createAPIKey());
                this.updateTestParam();
            });
            this.test_param = config.addHyperlinkParameter2("plugin.simpleapi.test", "");
        } else if (num == 2) {
            this.updateTestParam();
        }
    }

    @Override
    protected boolean verifyReferrer() {
        return false;
    }

    @Override
    protected void setupServer() {
        try {
            super.setupServer();
        }
        finally {
            this.updateTestParam();
        }
    }

    private void updateTestParam() {
        this.test_param.setHyperlink(String.valueOf(this.getServerURL()) + "?apikey=" + this.api_key.getValue() + "&method=test");
    }

    private String createAPIKey() {
        byte[] bytes = new byte[32];
        RandomUtils.nextSecureBytes(bytes);
        return Base32.encode(bytes).toLowerCase();
    }

    @Override
    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String key;
        String url = request2.getURL();
        if (url.contains("favicon.ico")) {
            try {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/ui/icons/favicon.ico");
                response.useStream("image/x-icon", stream);
                return true;
            }
            catch (Throwable stream) {
                // empty catch block
            }
        }
        log_channel.log(String.valueOf(request2.getClientAddress()) + ": " + url);
        int pos = url.indexOf(63);
        HashMap<String, String> args = new HashMap<String, String>();
        HashMap<String, List<String>> multi_args = new HashMap<String, List<String>>();
        if (pos != -1) {
            String[] arg_strs;
            String[] stringArray = arg_strs = url.substring(pos + 1).split("&");
            int n = arg_strs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg_str = stringArray[n2];
                String[] bits = arg_str.split("=");
                String name = bits[0].toLowerCase(Locale.US);
                String value = bits.length == 2 ? UrlUtils.decode(bits[1]) : "";
                args.put(name, value);
                ArrayList<String> multi_value = (ArrayList<String>)multi_args.get(name);
                if (multi_value == null) {
                    multi_value = new ArrayList<String>();
                    multi_args.put(name, multi_value);
                }
                multi_value.add(value);
                ++n2;
            }
        }
        if ((key = (String)args.get("apikey")) == null || !key.equals(this.api_key.getValue())) {
            response.setReplyStatus(403);
            log_channel.log("    access denied");
            return true;
        }
        try {
            String result = this.process(response, args, multi_args);
            if (result != null) {
                response.getOutputStream().write(result.getBytes(Constants.UTF_8));
            }
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setReplyStatus(200);
            return true;
        }
        catch (Throwable e) {
            log_channel.log("    error: " + Debug.getNestedExceptionMessage(e));
            Debug.out(e);
            response.setReplyStatus(500);
            response.getOutputStream().write(Debug.getNestedExceptionMessage(e).getBytes(Constants.UTF_8));
            return true;
        }
    }

    private com.biglybt.core.download.DownloadManager getDownloadFromHash(Map<String, String> args) throws Exception {
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        String hash = args.get("hash");
        if (hash == null) {
            throw new Exception("missing 'hash' parameter");
        }
        byte[] hash_bytes = UrlUtils.decodeTruncatedHash(hash);
        if (hash_bytes == null) {
            throw new Exception("Invalid hash (" + hash + ")");
        }
        com.biglybt.core.download.DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash_bytes));
        if (dm == null) {
            throw new Exception("Download not found for hash " + ByteFormatter.encodeString(hash_bytes));
        }
        return dm;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String process(TrackerWebPageResponse response, Map<String, String> args, Map<String, List<String>> multi_args) throws Exception {
        void var10_88;
        void var10_86;
        File f3;
        String method = args.get("method");
        if (method == null) throw new Exception("method missing");
        method = method.toLowerCase(Locale.US);
        TagManager tm = TagManagerFactory.getTagManager();
        if (method.equals("test")) {
            return "OK";
        }
        if (method.equals("listdownloads")) {
            JSONArray json = new JSONArray();
            List<com.biglybt.core.download.DownloadManager> dms = CoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
            for (com.biglybt.core.download.DownloadManager dm : dms) {
                try {
                    boolean sp_is_file;
                    Download download = PluginCoreUtils.wrap(dm);
                    TOTorrent torrent = dm.getTorrent();
                    JSONObject obj = new JSONObject();
                    obj.put("DisplayName", dm.getDisplayName());
                    obj.put("InfoHash", torrent == null ? "" : ByteFormatter.encodeString(torrent.getHash()));
                    String string = download.getSavePath();
                    obj.put("SavePath", string);
                    if (torrent.isSimpleTorrent()) {
                        sp_is_file = true;
                    } else {
                        File sp_file = new File(string);
                        if (sp_file.exists()) {
                            sp_is_file = sp_file.isFile();
                        } else {
                            DiskManagerFileInfo[] diskManagerFileInfoArray = dm.getDiskManagerFileInfoSet().getFiles();
                            if (diskManagerFileInfoArray.length > 1) {
                                sp_is_file = false;
                            } else {
                                File f2 = diskManagerFileInfoArray[0].getFile(true);
                                sp_is_file = FileUtil.areFilePathsIdentical(sp_file, f2);
                            }
                        }
                    }
                    obj.put("SavePathType", sp_is_file ? "File" : "Directory");
                    try {
                        List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)dm);
                        JSONArray jSONArray = new JSONArray();
                        for (Tag t : tags) {
                            jSONArray.add(t.getTagName(true));
                        }
                        obj.put("Tags", jSONArray);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    json.add(obj);
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
            if (response == null) return JSONUtils.encodeToJSON(json);
            response.setContentType("application/json; charset=UTF-8");
            return JSONUtils.encodeToJSON(json);
        }
        if (method.equals("listdownloadhistory")) {
            JSONArray json = new JSONArray();
            DownloadManager download_manager = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager();
            DownloadHistoryManager dh_manager = (DownloadHistoryManager)CoreFactory.getSingleton().getGlobalManager().getDownloadHistoryManager();
            List<DownloadHistory> history = dh_manager.getHistory();
            Collections.sort(history, (h1, h2) -> Long.compare(h2.getAddTime(), h1.getAddTime()));
            for (DownloadHistory downloadHistory : history) {
                try {
                    DownloadStub stub;
                    JSONObject obj = new JSONObject();
                    obj.put("DisplayName", downloadHistory.getName());
                    byte[] byArray = downloadHistory.getTorrentHash();
                    obj.put("InfoHash", byArray == null ? "" : ByteFormatter.encodeString(byArray));
                    String save_path = downloadHistory.getSaveLocation();
                    obj.put("SavePath", save_path);
                    obj.put("AddTime", (Object)downloadHistory.getAddTime());
                    obj.put("CompleteTime", (Object)downloadHistory.getCompleteTime());
                    obj.put("RemoveTime", (Object)downloadHistory.getRemoveTime());
                    long archive_time = 0L;
                    if (byArray != null && (stub = download_manager.lookupDownloadStub(byArray)) instanceof DownloadStub.DownloadStubEx) {
                        archive_time = ((DownloadStub.DownloadStubEx)stub).getCreationDate();
                    }
                    obj.put("ArchiveTime", (Object)archive_time);
                    obj.put("Size", (Object)downloadHistory.getSize());
                    try {
                        String[] tags = downloadHistory.getTags();
                        JSONArray tags_a = new JSONArray();
                        String[] stringArray = tags;
                        int n = tags.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            tags_a.add(t);
                            ++n2;
                        }
                        obj.put("Tags", tags_a);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    json.add(obj);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (response == null) return JSONUtils.encodeToJSON(json);
            response.setContentType("application/json; charset=UTF-8");
            return JSONUtils.encodeToJSON(json);
        }
        if (method.equals("listarchiveddownloads")) {
            JSONArray json = new JSONArray();
            DownloadManager download_manager = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager();
            DownloadStub[] temp = download_manager.getDownloadStubs();
            ArrayList<DownloadStub.DownloadStubEx> stubs = new ArrayList<DownloadStub.DownloadStubEx>(temp.length);
            DownloadStub[] downloadStubArray = temp;
            int e = temp.length;
            int torrent = 0;
            while (torrent < e) {
                DownloadStub downloadStub = downloadStubArray[torrent];
                if (downloadStub instanceof DownloadStub.DownloadStubEx) {
                    stubs.add((DownloadStub.DownloadStubEx)downloadStub);
                }
                ++torrent;
            }
            Collections.sort(stubs, (h1, h2) -> Long.compare(h2.getCreationDate(), h1.getCreationDate()));
            for (DownloadStub.DownloadStubEx downloadStubEx : stubs) {
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("DisplayName", downloadStubEx.getName());
                    byte[] byArray = downloadStubEx.getTorrentHash();
                    obj.put("InfoHash", byArray == null ? "" : ByteFormatter.encodeString(byArray));
                    String save_path = downloadStubEx.getSavePath();
                    obj.put("SavePath", save_path);
                    obj.put("AddTime", (Object)downloadStubEx.getCreationDate());
                    obj.put("CompleteTime", (Object)downloadStubEx.getCompletionDate());
                    obj.put("Size", (Object)downloadStubEx.getTorrentSize());
                    try {
                        String[] tags = downloadStubEx.getManualTags();
                        JSONArray jSONArray = new JSONArray();
                        String[] stringArray = tags;
                        int t = tags.length;
                        int tags_a = 0;
                        while (tags_a < t) {
                            String t2 = stringArray[tags_a];
                            jSONArray.add(t2);
                            ++tags_a;
                        }
                        obj.put("Tags", jSONArray);
                    }
                    catch (Throwable e2) {
                        Debug.out(e2);
                    }
                    json.add(obj);
                }
                catch (Throwable e3) {
                    Debug.out(e3);
                }
            }
            if (response == null) return JSONUtils.encodeToJSON(json);
            response.setContentType("application/json; charset=UTF-8");
            return JSONUtils.encodeToJSON(json);
        }
        if (method.equals("listfiles")) {
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            TOTorrent torrent = dm.getTorrent();
            HashMap<String, byte[]> rh_cache = TorrentUtils.getV2RootHashCache(torrent);
            boolean rh_cache_updated = false;
            String string = args.get("calc_root_hashes");
            boolean calc_root_hashes = string != null && this.getBoolean(string);
            DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
            JSONArray jSONArray = new JSONArray();
            DiskManagerFileInfo[] t2 = files;
            int n = files.length;
            int e2 = 0;
            while (e2 < n) {
                DiskManagerFileInfo file = t2[e2];
                TOTorrentFile t_file = file.getTorrentFile();
                JSONObject obj = new JSONObject();
                int index = t_file.getIndex();
                long size = t_file.getLength();
                long downloaded = file.getDownloaded();
                obj.put("Index", (Object)index);
                obj.put("Size", (Object)size);
                obj.put("Downloaded", (Object)downloaded);
                String relative_path = t_file.getRelativePath();
                int pos = relative_path.lastIndexOf(File.separator);
                obj.put("Name", pos < 0 ? relative_path : relative_path.substring(pos + 1));
                obj.put("RelativePath", relative_path);
                File data_file = file.getFile(true);
                obj.put("DataPath", data_file.getAbsolutePath());
                boolean is_pad = t_file.isPadFile();
                obj.put("IsPad", (Object)is_pad);
                obj.put("IsSkipped", (Object)file.isSkipped());
                obj.put("Priority", (Object)file.getPriority());
                byte[] root_hash = null;
                if (!is_pad && (root_hash = t_file.getRootHash()) == null && calc_root_hashes && size > 0L && size == downloaded && data_file.length() == size && !t_file.isPadFile()) {
                    String key = String.valueOf(index);
                    if (rh_cache != null) {
                        root_hash = (byte[])rh_cache.get(key);
                    }
                    if (root_hash == null) {
                        try {
                            root_hash = TOTorrentFactory.getV2RootHash(data_file);
                            if (root_hash != null) {
                                if (rh_cache == null) {
                                    rh_cache = new HashMap<String, byte[]>();
                                }
                                rh_cache.put(key, root_hash);
                                rh_cache_updated = true;
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                if (root_hash != null) {
                    obj.put("RootHash", Base32.encode(root_hash));
                }
                jSONArray.add(obj);
                ++e2;
            }
            if (rh_cache_updated) {
                try {
                    TorrentUtils.setV2RootHashCache(torrent, rh_cache);
                    TorrentUtils.writeToFile(torrent);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (response == null) return JSONUtils.encodeToJSON(jSONArray);
            response.setContentType("application/json; charset=UTF-8");
            return JSONUtils.encodeToJSON(jSONArray);
        }
        if (method.equals("addtag") || method.equals("addcategory") || method.equals("setcategory")) {
            int tag_type;
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            String tag_name = args.get("tag");
            if (tag_name == null) {
                tag_name = args.get("category");
            }
            if (tag_name == null) {
                throw new Exception("missing parameter");
            }
            int n = tag_type = method.equals("addtag") ? 3 : 1;
            if (tag_type == 1 && tag_name.isEmpty()) {
                Category uncat = CategoryManager.getCategory(2);
                dm.getDownloadState().setCategory(uncat);
                return null;
            } else {
                void var10_72;
                TagType tt = tm.getTagType(tag_type);
                Tag tag = tt.getTag(tag_name, true);
                if (tag == null) {
                    Tag tag2 = tt.createTag(tag_name, true);
                }
                if (var10_72.hasTaggable(dm)) return null;
                var10_72.addTaggable(dm);
            }
            return null;
        }
        if (method.equals("removetag")) {
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            String tag_name = args.get("tag");
            if (tag_name == null) {
                throw new Exception("missing parameter");
            }
            TagType tt = tm.getTagType(3);
            Tag tag = tt.getTag(tag_name, true);
            if (tag == null) {
                throw new Exception("Tag '" + tag_name + "' not found");
            }
            if (!tag.hasTaggable(dm)) return null;
            tag.removeTaggable(dm);
            return null;
        }
        if (method.equals("setnetworks")) {
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            String networks = args.get("networks");
            if (networks == null) {
                throw new Exception("missing parameter");
            }
            if ((networks = networks.trim()).isEmpty()) {
                dm.getDownloadState().setNetworks(new String[0]);
                return null;
            } else {
                void var10_74;
                String[] bits = networks.split(",");
                String[] nets = new String[bits.length];
                boolean bl = false;
                while (var10_74 < bits.length) {
                    String bit = bits[var10_74].trim();
                    String net = AENetworkClassifier.internalise(bit);
                    if (net == null) {
                        throw new Exception("Invalid network (" + bit + ")");
                    }
                    nets[var10_74] = net;
                    ++var10_74;
                }
                dm.getDownloadState().setNetworks(nets);
            }
            return null;
        }
        if (method.equals("setpeersources")) {
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            DownloadManagerState dms = dm.getDownloadState();
            String peersources = args.get("peersources");
            if (peersources == null) {
                throw new Exception("missing parameter");
            }
            if ((peersources = peersources.trim()).isEmpty()) {
                dms.setPeerSources(new String[0]);
                return null;
            } else if (peersources.equalsIgnoreCase("all")) {
                dms.setPeerSources(PEPeerSource.PS_SOURCES);
                return null;
            } else {
                String[] bits = peersources.split(",");
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean has_b = false;
                int i = 0;
                while (i < bits.length) {
                    void var13_132;
                    String ps;
                    String string = bits[i].trim();
                    Boolean b = null;
                    if (string.startsWith("+")) {
                        b = true;
                    } else if (string.startsWith("-")) {
                        b = false;
                    }
                    if (b != null) {
                        String string2 = string.substring(1);
                        has_b = true;
                    }
                    if ((ps = PEPeerSource.internalise((String)var13_132)) == null) {
                        throw new Exception("Invalid peer source (" + (String)var13_132 + ")");
                    }
                    if (b != null) {
                        dms.setPeerSourceEnabled(ps, b);
                    } else {
                        arrayList.add(ps);
                    }
                    ++i;
                }
                if (has_b) {
                    if (arrayList.isEmpty()) return null;
                    throw new Exception("Unsupported peer source options");
                }
                dms.setPeerSources(arrayList.toArray(new String[0]));
            }
            return null;
        }
        if (method.equals("setdownloadattribute")) {
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            List<String> names = multi_args.get("name");
            if (names == null) {
                throw new Exception("missing 'name' parameter");
            }
            List<String> values = multi_args.get("value");
            if (values == null) {
                throw new Exception("missing 'value' parameter");
            }
            if (names.size() != values.size()) {
                throw new Exception("'name' and 'value' parameter count mismatch");
            }
            int i = 0;
            while (i < names.size()) {
                String string = names.get(i);
                String value = values.get(i);
                String string3 = string.toLowerCase(Locale.US);
                if (string3.equals("completedon")) {
                    try {
                        long time = Long.parseLong(value) * 1000L;
                        DownloadManagerState dms = dm.getDownloadState();
                        dms.setLongParameter("stats.download.completed.time", time);
                        dms.setLongAttribute("complt", time);
                    }
                    catch (Throwable e) {
                        throw new Exception("invalid 'value' parameter (" + value + ")");
                    }
                }
                if (string3.equals("displayname")) {
                    dm.getDownloadState().setDisplayName(value);
                } else if (string3.equals("savepath")) {
                    void var13_138;
                    if (value.contains(File.pathSeparator)) {
                        throw new Exception("invalid savepath, must not contain path separators");
                    }
                    boolean save_loc_is_folder = dm.getSaveLocation().isDirectory();
                    String string4 = FileUtil.convertOSSpecificChars(value, save_loc_is_folder);
                    try {
                        String dnd_sf;
                        if (dm.getTorrent().isSimpleTorrent() && (dnd_sf = dm.getDownloadState().getAttribute("incompfilesuffix")) != null) {
                            dnd_sf = dnd_sf.trim();
                            String existing_name = dm.getSaveLocation().getName();
                            if (existing_name.endsWith(dnd_sf) && !string4.endsWith(dnd_sf)) {
                                String string5 = String.valueOf(string4) + dnd_sf;
                            }
                        }
                    }
                    catch (Throwable dnd_sf) {
                        // empty catch block
                    }
                    dm.renameDownload((String)var13_138);
                } else if (string3.equals("torrentname")) {
                    if (value.contains(File.pathSeparator)) {
                        throw new Exception("invalid torrentname, must not contain path separators");
                    }
                    String new_torrent_name = FileUtil.convertOSSpecificChars(value, false);
                    dm.renameTorrentSafe(new_torrent_name);
                } else if (string3.equals("usercomment")) {
                    dm.getDownloadState().setUserComment(value);
                } else if (string3.equals("ipfilterenable")) {
                    boolean enable = this.getBoolean(value);
                    dm.getDownloadState().setFlag(256L, !enable);
                } else if (string3.equals("uploadspeedlimit")) {
                    try {
                        int rate = Integer.parseInt(value);
                        dm.getStats().setUploadRateLimitBytesPerSecond(rate);
                    }
                    catch (Throwable e) {
                        throw new Exception("invalid rate limit '" + value + "'");
                    }
                } else if (string3.equals("downloadspeedlimit")) {
                    try {
                        int rate = Integer.parseInt(value);
                        dm.getStats().setDownloadRateLimitBytesPerSecond(rate);
                    }
                    catch (Throwable e) {
                        throw new Exception("invalid rate limit '" + value + "'");
                    }
                } else {
                    void var16_183;
                    void var13_144;
                    void var13_140;
                    void var16_185;
                    if (!string3.equals("pluginoption")) throw new Exception("invalid 'name' parameter (" + string3 + ")");
                    String[] opt_strs = value.split("&");
                    Object var13_139 = null;
                    Boolean enable_announce = null;
                    String[] t_file = opt_strs;
                    int t2 = opt_strs.length;
                    boolean bl = false;
                    while (var16_185 < t2) {
                        String opt_str = t_file[var16_185];
                        String[] bits = opt_str.split("=");
                        String opt_name = bits[0].toLowerCase(Locale.US);
                        String opt_value = bits.length == 2 ? UrlUtils.decode(bits[1]) : "";
                        if (opt_name.equals("id")) {
                            String string6 = opt_value;
                        } else if (opt_name.equals("enableannounce")) {
                            enable_announce = this.getBoolean(opt_value);
                        }
                        ++var16_185;
                    }
                    if (var13_140 == null) {
                        throw new Exception("Plugin id parameter missing");
                    }
                    if (var13_140.equalsIgnoreCase("dht")) {
                        String string7 = "azbpdhdtracker";
                    } else if (var13_140.equalsIgnoreCase("I2P")) {
                        String string8 = "azneti2phelper";
                    }
                    PluginInterface pi = this.plugin_interface.getPluginManager().getPluginInterfaceByID((String)var13_144);
                    if (pi == null) {
                        throw new Exception("Plugin id '" + (String)var13_144 + "' not found");
                    }
                    if (enable_announce == null) {
                        throw new Exception("No plugin options supplied");
                    }
                    String string9 = var13_144.toLowerCase(Locale.US);
                    Map map = dm.getDownloadState().getMapAttribute("pluginoptions");
                    if (map == null) {
                        HashMap hashMap = new HashMap();
                    } else {
                        Map map2 = BEncoder.cloneMap(map);
                    }
                    HashMap<String, Integer> opt_map = (HashMap<String, Integer>)var16_183.get(string9);
                    if (opt_map == null) {
                        opt_map = new HashMap<String, Integer>();
                        var16_183.put(string9, opt_map);
                    }
                    opt_map.put("enableannounce", enable_announce != false ? 1 : 0);
                    dm.getDownloadState().setMapAttribute("pluginoptions", (Map)var16_183);
                }
                ++i;
            }
            return null;
        }
        if (method.equals("setdownloadfileattribute")) {
            com.biglybt.core.download.DownloadManager dm = this.getDownloadFromHash(args);
            boolean paused = false;
            try {
                void var13_147;
                List<String> names = multi_args.get("name");
                if (names == null) {
                    throw new Exception("missing 'name' parameter");
                }
                List<String> values = multi_args.get("value");
                if (values == null) {
                    throw new Exception("missing 'value' parameter");
                }
                List<String> list = multi_args.get("index");
                if (list == null) {
                    throw new Exception("missing 'index' parameter");
                }
                if (names.size() != values.size() || values.size() != list.size()) {
                    throw new Exception("'index', 'name' and 'value' parameter count mismatch");
                }
                DiskManagerFileInfoSet info_set = dm.getDiskManagerFileInfoSet();
                DiskManagerFileInfo[] files = info_set.getFiles();
                boolean bl = false;
                while (var13_147 < names.size()) {
                    int index;
                    String name = names.get((int)var13_147);
                    String value = values.get((int)var13_147);
                    name = name.toLowerCase(Locale.US);
                    String string = list.get((int)var13_147);
                    try {
                        index = Integer.parseInt(string);
                    }
                    catch (Throwable e) {
                        throw new Exception("'index' parameter invalid (" + string + ")");
                    }
                    if (index < 0 || index >= files.length) {
                        throw new Exception("'index' parameter out of range (files=" + files.length + ")");
                    }
                    DiskManagerFileInfo file = files[index];
                    if (name.equals("datapath")) {
                        String data_path = value;
                        if (dm.pause(true)) {
                            paused = true;
                        }
                        file.setLink(new File(data_path), true);
                    } else if (name.equals("skipped")) {
                        file.setSkipped(this.getBoolean(value));
                    } else if (name.equals("priority")) {
                        try {
                            file.setPriority(Integer.parseInt(value));
                        }
                        catch (Throwable e) {
                            throw new Exception("'value' parameter invalid for priority(" + value + ")");
                        }
                    }
                    ++var13_147;
                }
                return null;
            }
            finally {
                if (paused) {
                    dm.resume();
                }
            }
        }
        if (method.equals("alert")) {
            String details;
            com.biglybt.core.download.DownloadManager dm = null;
            try {
                dm = this.getDownloadFromHash(args);
            }
            catch (Throwable paused) {
                // empty catch block
            }
            String caption = args.get("caption");
            if (caption == null) {
                caption = "";
            }
            int atype = 0;
            String type = args.get("type");
            if (type != null && !type.equals("info")) {
                if (!type.equals("error")) throw new Exception("invalid type (" + type + ")");
                atype = 3;
            }
            LogAlert logAlert = new LogAlert(true, atype, caption);
            if (dm != null) {
                logAlert.details = dm.getDisplayName();
            }
            if ((details = args.get("details")) != null && !details.isEmpty()) {
                logAlert.details = dm != null ? String.valueOf(logAlert.details) + "\n\n" + details : details;
            }
            logAlert.isNative = true;
            Logger.log(logAlert);
            return null;
        }
        if (method.equals("playsound")) {
            String optional_file = args.get("file");
            GeneralUtils.playSound(optional_file);
            return null;
        }
        if (method.equals("markresultsread") || method.equals("markallresultsread") || method.equals("markresultsreadinall")) {
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            String subs_id = args.get("subscription_id");
            if (subs_id == null) {
                throw new Exception("missing 'subscription_id' parameter");
            }
            Subscription subs = subs_man.getSubscriptionByID(subs_id);
            if (subs == null) {
                throw new Exception("subscripton '" + subs_id + "' not found");
            }
            ArrayList<String> result_ids = new ArrayList<String>();
            String string = args.get("subscription_result_id");
            if (string == null) {
                String result_ids_str = args.get("subscription_result_ids");
                if (result_ids_str == null) {
                    throw new Exception("missing 'subscription_result_id(s)' parameter");
                }
                String[] bits = result_ids_str.split(",");
                String[] stringArray = bits;
                int value = bits.length;
                int name = 0;
                while (name < value) {
                    String string11 = stringArray[name];
                    string11 = string11.trim();
                    if (!string11.isEmpty()) {
                        result_ids.add(string11);
                    }
                    ++name;
                }
            } else {
                result_ids.add(string);
            }
            if (method.equals("markresultsread")) {
                boolean[] blArray = new boolean[result_ids.size()];
                Arrays.fill(blArray, true);
                subs.getHistory().markResults(result_ids.toArray(new String[blArray.length]), blArray);
                return null;
            } else {
                ArrayList<SubscriptionResultFilterable> arrayList = new ArrayList<SubscriptionResultFilterable>(result_ids.size());
                for (String result_id : result_ids) {
                    SubscriptionResult subscriptionResult = subs.getHistory().getResult(result_id);
                    if (subscriptionResult == null) {
                        throw new Exception("subscription result '" + result_id + "' not found");
                    }
                    arrayList.add(new SubscriptionResultFilterable(subs, subscriptionResult));
                }
                SearchSubsResultBase[] results = arrayList.toArray(new SubscriptionResultFilterable[arrayList.size()]);
                subs_man.markReadInAllSubscriptions(results);
            }
            return null;
        }
        if (!method.equals("addtorrent") && !method.equals("adddownload")) throw new Exception("unsupported method '" + method + "'");
        String[] target_args = new String[]{"file", "magnet", "url", "torrent"};
        String original_target = null;
        String[] results = target_args;
        int n = target_args.length;
        int result_ids = 0;
        while (result_ids < n) {
            String ta = results[result_ids];
            original_target = args.get(ta);
            if (original_target != null) break;
            ++result_ids;
        }
        if (original_target == null) {
            throw new Exception("missing file/magnet/url/torrent parameter");
        }
        String f_original_target = original_target;
        String target = original_target;
        Object var10_84 = null;
        URL url = null;
        try {
            f3 = FileUtil.newFile(target, new String[0]);
            if (f3.exists()) {
                File file = f3;
            }
        }
        catch (Throwable f3) {
            // empty catch block
        }
        if (var10_86 == null) {
            try {
                f3 = FileUtil.newFile(new URI(target));
                if (f3.exists()) {
                    File file = f3;
                }
            }
            catch (Throwable f4) {
                // empty catch block
            }
        }
        if (var10_88 == null) {
            String string;
            target = UrlUtils.decode(target);
            String lc_target = (target = target.trim().replaceAll(" ", "%20")).toLowerCase(Locale.US);
            if (lc_target.startsWith("magnet:")) {
                target = String.valueOf(target) + "&dummy_param=1";
            } else if (!lc_target.startsWith("http") && (string = UrlUtils.parseTextForURL(target, true, true)) != null) {
                target = string;
            }
            try {
                url = new URL(target);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (var10_88 != null) {
            try {
                TOTorrent torrent = TorrentUtils.readFromFile((File)var10_88, false);
                this.addTorrent(torrent);
                return null;
            }
            catch (Throwable e) {
                throw new Exception("failed to read torrent from '" + var10_88.getAbsolutePath() + "'");
            }
        } else {
            if (url == null) throw new Exception("invalid file/magnet/url parameter '" + original_target + "'");
            URL f_url = url;
            TorrentManager torrentManager = this.plugin_interface.getTorrentManager();
            TorrentDownloader dl = torrentManager.getURLDownloader(url, null, null);
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            AEThread2.createAndStartDaemon("SAPI:tdl", () -> {
                Object sk = uif.pushStatusText(String.valueOf(MessageText.getString("fileDownloadWindow.state_downloading")) + ": " + f_original_target);
                try {
                    try {
                        Torrent torrent = dl.download("UTF8");
                        uif.popStatusText(sk, 0, null);
                        sk = null;
                        this.addTorrent(PluginCoreUtils.unwrap(torrent));
                    }
                    catch (Throwable e) {
                        boolean alt_tried = false;
                        try {
                            URL url2;
                            String url_str = f_url.toExternalForm();
                            url_str = url_str.substring(url_str.indexOf(":"));
                            String alt_target = UrlUtils.parseTextForURL(url_str, true, true);
                            if (alt_target != null && !f_url.equals(url2 = new URL(alt_target))) {
                                uif.popStatusText(sk, 1, null);
                                sk = null;
                                TorrentDownloader dl2 = torrentManager.getURLDownloader(url2, null, null);
                                AEThread2.createAndStartDaemon("SAPI:tdl2", () -> {
                                    Object sk2 = uif.pushStatusText(String.valueOf(MessageText.getString("fileDownloadWindow.state_downloading")) + ": " + url2.toExternalForm());
                                    try {
                                        try {
                                            Torrent torrent = dl2.download("UTF8");
                                            uif.popStatusText(sk2, 0, null);
                                            sk2 = null;
                                            this.addTorrent(PluginCoreUtils.unwrap(torrent));
                                        }
                                        catch (Throwable f) {
                                            log_channel.log("Torrent download failed for '" + f_url + "'", e);
                                            uif.popStatusText(sk2, 2, Debug.getNestedExceptionMessage(f));
                                            sk2 = null;
                                            if (sk2 != null) {
                                                uif.popStatusText(sk2, 2, null);
                                            }
                                        }
                                    }
                                    finally {
                                        if (sk2 != null) {
                                            uif.popStatusText(sk2, 2, null);
                                        }
                                    }
                                });
                                alt_tried = true;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!alt_tried) {
                            log_channel.log("Torrent download failed for '" + f_url + "'", e);
                            uif.popStatusText(sk, 2, Debug.getNestedExceptionMessage(e));
                            sk = null;
                        }
                        if (sk != null) {
                            uif.popStatusText(sk, 2, null);
                        }
                    }
                }
                finally {
                    if (sk != null) {
                        uif.popStatusText(sk, 2, null);
                    }
                }
            });
        }
        return null;
    }

    private void addTorrent(TOTorrent torrent) {
        try {
            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
            com.biglybt.core.download.DownloadManager existing_dm = gm.getDownloadManager(torrent);
            if (existing_dm != null) {
                log_channel.log("Download '" + existing_dm.getDisplayName() + "' already added");
                return;
            }
            TorrentOpenOptions torrentOptions = new TorrentOpenOptions(null);
            torrent = TorrentUtils.cloneTorrent(torrent);
            File to_file = AETemporaryFileHandler.createTempFile();
            TorrentUtils.writeToFile(torrent, to_file, false);
            torrent = TorrentUtils.readFromFile(to_file, false);
            torrentOptions.setDeleteFileOnCancel(true);
            torrentOptions.setTorrentFile(to_file.getAbsolutePath());
            torrentOptions.setTorrent(torrent);
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            uif.addTorrentWithOptions(false, torrentOptions);
            log_channel.log("Added download '" + new String(torrent.getName()) + "'");
        }
        catch (Throwable e) {
            log_channel.log("Failed to add download '" + new String(torrent.getName()) + "'", e);
        }
    }

    private boolean getBoolean(String value) throws Exception {
        if ((value = value.toLowerCase(Locale.US)).equals("true") || value.equals("1") || value.equals("y")) {
            return true;
        }
        if (value.equals("false") || value.equals("0") || value.equals("n")) {
            return false;
        }
        throw new Exception("invalid boolean value (" + value + ")");
    }

    public Object evalScript(Map<String, Object> eval_args) throws IPCException {
        String intent = (String)eval_args.get("intent");
        String scripts = (String)eval_args.get("script");
        if ((scripts = scripts.trim()).length() > 2 && GeneralUtils.startsWithDoubleQuote(scripts) && GeneralUtils.endsWithDoubleQuote(scripts)) {
            scripts = scripts.substring(1, scripts.length() - 1);
            scripts = scripts.trim();
        }
        log_channel.log(String.valueOf(intent) + " - " + scripts);
        String[] script_strs = scripts.split(";");
        ArrayList<String> results = new ArrayList<String>();
        Download download = (Download)eval_args.get("download");
        Subscription subscription = (Subscription)eval_args.get("subscription");
        SubscriptionResult subscription_result = (SubscriptionResult)eval_args.get("subscription_result");
        List subscription_results = (List)eval_args.get("subscription_results");
        String[] stringArray = script_strs;
        int n = script_strs.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            if (!(script = script.trim()).isEmpty()) {
                String[] arg_strs;
                HashMap<String, String> args = new HashMap<String, String>();
                HashMap<String, List<String>> multi_args = new HashMap<String, List<String>>();
                String[] stringArray2 = arg_strs = script.split("&");
                int n3 = arg_strs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String arg_str = stringArray2[n4];
                    String[] bits = arg_str.split("=");
                    String name = bits[0].toLowerCase(Locale.US);
                    String value = bits.length == 2 ? UrlUtils.decode(bits[1]) : "";
                    args.put(name, value);
                    ArrayList<String> multi_value = (ArrayList<String>)multi_args.get(name);
                    if (multi_value == null) {
                        multi_value = new ArrayList<String>();
                        multi_args.put(name, multi_value);
                    }
                    multi_value.add(value);
                    ++n4;
                }
                args.put("apikey,", this.api_key.getValue());
                if (download != null) {
                    args.put("hash", ByteFormatter.encodeString(download.getTorrentHash()));
                }
                if (subscription != null) {
                    args.put("subscription_id", subscription.getID());
                }
                if (subscription_result != null) {
                    args.put("subscription_result_id", subscription_result.getID());
                } else if (subscription_results != null) {
                    StringBuffer sr_ids = new StringBuffer();
                    for (SubscriptionResult sr : subscription_results) {
                        if (sr_ids.length() > 0) {
                            sr_ids.append(",");
                        }
                        sr_ids.append(sr.getID());
                    }
                    args.put("subscription_result_ids", sr_ids.toString());
                }
                try {
                    String result = this.process(null, args, multi_args);
                    if (result != null) {
                        results.add(result);
                    }
                }
                catch (Throwable e) {
                    log_channel.log("    error: " + Debug.getNestedExceptionMessage(e));
                    throw new IPCException(e);
                }
            }
            ++n2;
        }
        if (results.isEmpty()) {
            return null;
        }
        String str = "";
        for (String result : results) {
            str = String.valueOf(str) + (str.isEmpty() ? "" : ";") + result;
        }
        return str;
    }
}

