/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.startstoprules.defaultplugin;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.startstoprules.defaultplugin.DefaultRankCalculator;
import com.biglybt.plugin.startstoprules.defaultplugin.RankCalculatorSlotReserver;
import com.biglybt.plugin.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.biglybt.plugin.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RankCalculatorReal
implements DefaultRankCalculator,
DownloadManagerStateAttributeListener {
    private static final TagFeatureRateLimit[] NO_TAG_LIMITS = new TagFeatureRateLimit[0];
    private static final int FORCE_ACTIVE_FOR = 30000;
    private static final int ACTIVE_CHANGE_WAIT = 10000;
    private static int SPRATIO_BASE_LIMIT = 99999;
    private static int SEEDONLY_SHIFT = SPRATIO_BASE_LIMIT + 1;
    private static final long HIGH_LATENCY_MILLIS = 2500L;
    private static final long HIGH_LATENCY_RECOVERY_MILLIS = 60000L;
    private static COConfigurationListener configListener = null;
    private static final long STALE_REFRESH_INTERVAL = 60000L;
    private static int iRankType = -1;
    private static int minPeersToBoostNoSeeds;
    private static int minSpeedForActiveDL;
    private static int minSpeedForActiveSeeding;
    private static int iIgnoreSeedCount;
    private static boolean bIgnore0Peers;
    private static int iIgnoreShareRatio;
    private static int iIgnoreShareRatio_SeedStart;
    private static int iIgnoreRatioPeers;
    private static int iIgnoreRatioPeers_SeedStart;
    private static int iRankTypeSeedFallback;
    private static boolean bPreferLargerSwarms;
    private static int minQueueingShareRatio;
    private static int iFirstPriorityIgnoreSPRatio;
    private static boolean bFirstPriorityIgnore0Peer;
    private static int iFirstPriorityType;
    private static int iFirstPrioritySeedingMinutes;
    private static int iFirstPriorityActiveMinutes;
    private static int iFirstPriorityIgnoreIdleMinutes;
    private static long minTimeAlive;
    private static boolean bAutoStart0Peers;
    private static int iTimed_MinSeedingTimeWithPeers;
    private static int iTimed_MaxSeedingTimeWithPeers;
    private static int numPeersAsFullCopy;
    private static int iFakeFullCopySeedStart;
    private final Download dl;
    private final DownloadManager core_dm;
    private boolean bActivelyDownloading;
    private long lDLActivelyChangedOnMono;
    private long lDownloadingHighLatencyTimeMono = -1L;
    private SR downloadSR = new SR();
    private boolean bActivelySeeding;
    private long lCDActivelyChangedOnMono;
    private long lSeedingHighLatencyTimeMono = -1L;
    private long staleCDSinceMono;
    private long staleCDOffset;
    private long lastStaleCDRefreshMono;
    private boolean bIsFirstPriority;
    private int dlSpecificMinShareRatio;
    private int dlSpecificMaxShareRatio;
    private long dlLastActiveTime;
    private String _sExplainFP = "";
    private String _sExplainSR = "";
    private String sTrace = "";
    private AEMonitor downloadData_this_mon = new AEMonitor("StartStopRules:downloadData");
    private final StartStopRulesDefaultPlugin rules;
    private TagFeatureRateLimit[] tagsWithDLLimits = new TagFeatureRateLimit[0];
    private TagFeatureRateLimit[] tagsWithCDLimits = new TagFeatureRateLimit[0];
    int lastModifiedScrapeResultPeers = 0;
    int lastModifiedScrapeResultSeeds = 0;
    int lastModifiedShareRatio = 0;
    boolean lastScrapeResultOk = false;
    private RankCalculatorSlotReserver reservedSlot;
    private long lastActivationAnnounce;
    private long timedRotationSeedingStart;
    private long timedRotationSeedingStartMinSeeding;
    private Map<Object, Object> userData;
    private boolean dlr_test_active;
    private long dlr_test_start_time;
    private long dlr_test_bytes_start;
    private int dlr_test_average_bytes_per_sec = -1;
    private long dlr_test_eta = -1L;
    private static final ThreadPool activate_pool;

    static {
        activate_pool = new ThreadPool("StartStopRules:activate", 32, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkConfigListener(final PluginConfig config) {
        Class<RankCalculatorReal> clazz = RankCalculatorReal.class;
        synchronized (RankCalculatorReal.class) {
            if (configListener == null) {
                configListener = new COConfigurationListener(){

                    @Override
                    public void configurationSaved() {
                        RankCalculatorReal.reloadConfigParams(config);
                    }
                };
                COConfigurationManager.addListener(configListener);
                configListener.configurationSaved();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public RankCalculatorReal(StartStopRulesDefaultPlugin _rules, Download _dl) {
        this.rules = _rules;
        this.dl = _dl;
        this.dl.setSeedingRank(this.downloadSR);
        this.core_dm = PluginCoreUtils.unwrap(this.dl);
        DownloadManagerState dm_state = this.core_dm.getDownloadState();
        this.dlSpecificMinShareRatio = dm_state.getIntParameter("sr.min");
        this.dlSpecificMaxShareRatio = dm_state.getIntParameter("sr.max");
        this.dlLastActiveTime = dm_state.getLongParameter("stats.download.last.active.time");
        if (this.dlLastActiveTime <= 0L) {
            this.dlLastActiveTime = dm_state.getLongParameter("stats.download.completed.time");
        }
        dm_state.addListener(this, "parameters", 1);
        DownloadScrapeResult sr = this.dl.getAggregatedScrapeResult(false);
        int srSeeds = Math.max(sr.getSeedCount(), 0);
        int srPeers = Math.max(sr.getNonSeedCount(), 0);
        if (sr.getScrapeStartTime() > 0L || srSeeds > 0 || srPeers > 0) {
            this.lastScrapeResultOk = true;
            this.lastModifiedScrapeResultSeeds = srSeeds;
            this.lastModifiedScrapeResultPeers = srPeers;
        }
        this.setupTagData();
        RankCalculatorReal.checkConfigListener(this.rules.plugin_config);
    }

    @Override
    public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
        DownloadManagerState dm_state = this.core_dm.getDownloadState();
        this.dlSpecificMinShareRatio = dm_state.getIntParameter("sr.min");
        this.dlSpecificMaxShareRatio = dm_state.getIntParameter("sr.max");
        this.dlLastActiveTime = dm_state.getLongParameter("stats.download.last.active.time");
        if (this.dlLastActiveTime <= 0L) {
            this.dlLastActiveTime = dm_state.getLongParameter("stats.download.completed.time");
        }
    }

    @Override
    public void destroy() {
        DownloadManagerState dm_state = this.core_dm.getDownloadState();
        dm_state.removeListener(this, "parameters", 1);
    }

    public static void reloadConfigParams(PluginConfig cfg) {
        iRankType = cfg.getUnsafeIntParameter("StartStopManager_iRankType");
        minPeersToBoostNoSeeds = cfg.getUnsafeIntParameter("StartStopManager_iMinPeersToBoostNoSeeds");
        minSpeedForActiveDL = cfg.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveDL");
        minSpeedForActiveSeeding = cfg.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
        iRankTypeSeedFallback = cfg.getUnsafeIntParameter("StartStopManager_iRankTypeSeedFallback");
        bPreferLargerSwarms = cfg.getUnsafeBooleanParameter("StartStopManager_bPreferLargerSwarms");
        minTimeAlive = cfg.getUnsafeIntParameter("StartStopManager_iMinSeedingTime") * 1000;
        bAutoStart0Peers = cfg.getUnsafeBooleanParameter("StartStopManager_bAutoStart0Peers");
        iIgnoreSeedCount = cfg.getUnsafeIntParameter("StartStopManager_iIgnoreSeedCount");
        bIgnore0Peers = cfg.getUnsafeBooleanParameter("StartStopManager_bIgnore0Peers");
        iIgnoreShareRatio = (int)(1000.0f * cfg.getUnsafeFloatParameter("Stop Ratio"));
        iIgnoreShareRatio_SeedStart = cfg.getUnsafeIntParameter("StartStopManager_iIgnoreShareRatioSeedStart");
        iIgnoreRatioPeers = cfg.getUnsafeIntParameter("Stop Peers Ratio", 0);
        iIgnoreRatioPeers_SeedStart = cfg.getUnsafeIntParameter("StartStopManager_iIgnoreRatioPeersSeedStart", 0);
        numPeersAsFullCopy = cfg.getUnsafeIntParameter("StartStopManager_iNumPeersAsFullCopy");
        iFakeFullCopySeedStart = cfg.getUnsafeIntParameter("StartStopManager_iFakeFullCopySeedStart");
        minQueueingShareRatio = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_ShareRatio");
        iFirstPriorityType = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_Type");
        iFirstPrioritySeedingMinutes = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_SeedingMinutes");
        iFirstPriorityActiveMinutes = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_DLMinutes");
        iFirstPriorityIgnoreSPRatio = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio");
        bFirstPriorityIgnore0Peer = cfg.getUnsafeBooleanParameter("StartStopManager_bFirstPriority_ignore0Peer");
        iFirstPriorityIgnoreIdleMinutes = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_ignoreIdleMinutes");
        iTimed_MinSeedingTimeWithPeers = cfg.getUnsafeIntParameter("StartStopManager_iTimed_MinSeedingTimeWithPeers") * 1000;
        iTimed_MaxSeedingTimeWithPeers = cfg.getUnsafeIntParameter("StartStopManager_iTimed_MaxSeedingTimeWithPeers") * 1000;
    }

    @Override
    public int compareTo(DefaultRankCalculator obj) {
        boolean stopped2;
        if (!(obj instanceof RankCalculatorReal)) {
            return 1;
        }
        RankCalculatorReal dlData = (RankCalculatorReal)obj;
        int state1 = this.dl.getState();
        boolean stopped1 = state1 == 7 || state1 == 8;
        int state2 = dlData.dl.getState();
        boolean bl = stopped2 = state2 == 7 || state2 == 8;
        if (stopped1 && stopped2) {
            return this.dl.getPosition() - dlData.dl.getPosition();
        }
        if (stopped1) {
            return 1;
        }
        if (stopped2) {
            return -1;
        }
        return this.compareToIgnoreStopped(obj);
    }

    @Override
    public int compareToIgnoreStopped(DefaultRankCalculator obj) {
        if (!(obj instanceof RankCalculatorReal)) {
            return 1;
        }
        RankCalculatorReal dlData = (RankCalculatorReal)obj;
        if (dlData.bIsFirstPriority && !this.bIsFirstPriority) {
            return 1;
        }
        if (!dlData.bIsFirstPriority && this.bIsFirstPriority) {
            return -1;
        }
        boolean aIsComplete = dlData.dl.isComplete();
        boolean bIsComplete = this.dl.isComplete();
        if (aIsComplete && !bIsComplete) {
            return -1;
        }
        if (!aIsComplete && bIsComplete) {
            return 1;
        }
        if (iRankType == 0) {
            return this.dl.getPosition() - dlData.dl.getPosition();
        }
        int value = dlData.dl.getSeedingRank().getRank() - this.dl.getSeedingRank().getRank();
        if (value != 0) {
            return value;
        }
        if (iRankType != 3) {
            int numPeersThem = dlData.lastModifiedScrapeResultPeers;
            int numPeersUs = this.lastModifiedScrapeResultPeers;
            value = bPreferLargerSwarms ? numPeersThem - numPeersUs : numPeersUs - numPeersThem;
            if (value != 0) {
                return value;
            }
            value = this.lastModifiedShareRatio - dlData.lastModifiedShareRatio;
            if (value != 0) {
                return value;
            }
        }
        return this.dl.getPosition() - dlData.dl.getPosition();
    }

    @Override
    public Object getRelatedTo() {
        return this.dl.getTorrent();
    }

    @Override
    public String getName() {
        return this.dl.getName();
    }

    @Override
    public int getState() {
        return this.dl.getState();
    }

    @Override
    public int getCoreState() {
        return this.core_dm.getState();
    }

    @Override
    public void addStateAttributeListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        this.core_dm.getDownloadState().addListener(l, attribute, event_type);
    }

    @Override
    public void removeStateAttributeListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        this.core_dm.getDownloadState().removeListener(l, attribute, event_type);
    }

    @Override
    public boolean supportsPosition() {
        return true;
    }

    @Override
    public int getPosition() {
        return this.dl.getPosition();
    }

    @Override
    public void setPosition(int pos) {
        this.dl.setPosition(pos);
    }

    @Override
    public void moveTo(int pos) {
        this.dl.moveTo(pos);
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    @Override
    public boolean isForceActive() {
        DownloadStats stats2 = this.dl.getStats();
        return SystemTime.getCurrentTime() - stats2.getTimeStarted() <= 30000L;
    }

    @Override
    public boolean isQueued() {
        return this.dl.getState() == 9;
    }

    @Override
    public boolean isDownloading() {
        return this.dl.getState() == 4;
    }

    @Override
    public boolean isChecking() {
        return this.dl.isChecking();
    }

    @Override
    public boolean isMoving() {
        return this.dl.isMoving() || FileUtil.hasTask(this.core_dm);
    }

    @Override
    public boolean isForceStart() {
        return this.dl.isForceStart();
    }

    @Override
    public boolean isComplete() {
        return this.dl.isComplete();
    }

    @Override
    public void initialize() throws DownloadException {
        this.dl.initialize();
    }

    @Override
    public void start() throws DownloadException {
        this.dl.start();
    }

    @Override
    public void restart() throws DownloadException {
        this.dl.restart();
    }

    @Override
    public void stopAndQueue() throws DownloadException {
        this.dl.stopAndQueue();
    }

    @Override
    public int getShareRatio() {
        return this.dl.getStats().getShareRatio();
    }

    @Override
    public long getUploadAverage() {
        return this.dl.getStats().getUploadAverage();
    }

    @Override
    public long getDownloadAverage() {
        return this.dl.getStats().getDownloadAverage();
    }

    @Override
    public long getTimeStarted() {
        return this.dl.getStats().getTimeStarted();
    }

    @Override
    public long getSizeExcludingDND() {
        return this.core_dm.getStats().getSizeExcludingDND();
    }

    @Override
    public long getRemainingExcludingDND() {
        return this.core_dm.getStats().getRemainingExcludingDND();
    }

    @Override
    public int[] getFilePriorityStats() {
        return this.core_dm.getStats().getFilePriorityStats();
    }

    @Override
    public DownloadScrapeResult getAggregatedScrapeResult(boolean b) {
        return this.dl.getAggregatedScrapeResult(b);
    }

    @Override
    public boolean scrapeResultOk() {
        DownloadScrapeResult sr = this.dl.getAggregatedScrapeResult(false);
        return sr.getResponseType() == 1;
    }

    @Override
    public int calcSeedsNoUs() {
        return this.calcSeedsNoUs(this.dl, this.dl.getAggregatedScrapeResult(false));
    }

    private int calcSeedsNoUs(Download download, DownloadScrapeResult sr) {
        return this.calcSeedsNoUs(download, sr, this.calcPeersNoUs(download, sr));
    }

    private int calcSeedsNoUs(Download download, DownloadScrapeResult sr, int numPeers) {
        DownloadAnnounceResult ar;
        int numSeeds = 0;
        if (sr.getScrapeStartTime() > 0L) {
            long seedingStartedOn = download.getStats().getTimeStartedSeeding();
            numSeeds = sr.getSeedCount();
            if (numSeeds > 0 && seedingStartedOn > 0L && download.getState() == 5 && sr.getScrapeStartTime() > seedingStartedOn) {
                --numSeeds;
            }
        }
        if (numSeeds == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numSeeds = ar.getSeedCount();
        }
        if (numPeersAsFullCopy != 0 && numSeeds >= iFakeFullCopySeedStart) {
            numSeeds += numPeers / numPeersAsFullCopy;
        }
        return Math.max(numSeeds, 0);
    }

    private int calcPeersNoUs() {
        return this.calcPeersNoUs(this.dl, this.dl.getAggregatedScrapeResult(false));
    }

    private int calcPeersNoUs(Download download, DownloadScrapeResult sr) {
        DownloadAnnounceResult ar;
        int numPeers = 0;
        if (sr.getScrapeStartTime() > 0L && (numPeers = sr.getNonSeedCount()) > 0 && download.getState() == 4 && sr.getScrapeStartTime() > download.getStats().getTimeStarted()) {
            --numPeers;
        }
        if (numPeers == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numPeers = ar.getNonSeedCount();
        }
        return Math.max(numPeers, 0);
    }

    @Override
    public boolean getActivelyDownloading() {
        boolean bIsActive = false;
        DownloadStats stats2 = this.dl.getStats();
        int state = this.dl.getState();
        if (state != 4) {
            bIsActive = false;
        } else if (SystemTime.getCurrentTime() - stats2.getTimeStarted() <= 30000L) {
            bIsActive = true;
        } else {
            DiskManager dm;
            long nowMono = SystemTime.getMonotonousTime();
            boolean bl = bIsActive = stats2.getDownloadAverage() >= (long)minSpeedForActiveDL;
            if (!bIsActive && (dm = this.core_dm.getDiskManager()) != null) {
                long[] latency = dm.getLatency();
                if (latency[1] > 2500L) {
                    if (this.lDownloadingHighLatencyTimeMono == -1L && this.rules.bDebugLog) {
                        this.rules.log.log((Object)this.dl.getTorrent(), 1, "download speed is low but write latency high, ignoring");
                    }
                    this.lDownloadingHighLatencyTimeMono = nowMono;
                    bIsActive = true;
                } else if (this.lDownloadingHighLatencyTimeMono != -1L) {
                    if (nowMono - this.lDownloadingHighLatencyTimeMono > 60000L) {
                        this.lDownloadingHighLatencyTimeMono = -1L;
                    } else {
                        bIsActive = true;
                    }
                }
            }
            if (this.bActivelyDownloading != bIsActive) {
                if (this.lDLActivelyChangedOnMono == -1L) {
                    this.lDLActivelyChangedOnMono = nowMono;
                    bIsActive = !bIsActive;
                } else if (nowMono - this.lDLActivelyChangedOnMono < 10000L) {
                    bIsActive = !bIsActive;
                }
            } else {
                this.lDLActivelyChangedOnMono = -1L;
            }
        }
        if (this.bActivelyDownloading != bIsActive) {
            this.bActivelyDownloading = bIsActive;
            if (this.rules != null) {
                this.rules.requestProcessCycle(null);
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelyDownloading changed");
                }
            }
        }
        return this.bActivelyDownloading;
    }

    @Override
    public boolean getActivelySeeding() {
        boolean bIsActive = false;
        DownloadStats stats2 = this.dl.getStats();
        int state = this.dl.getState();
        if (!(iRankType != 3 || this.isFirstPriority() || bAutoStart0Peers && this.calcPeersNoUs() == 0 && this.lastScrapeResultOk)) {
            bIsActive = state == 5;
        } else if (state != 5 || bAutoStart0Peers && this.calcPeersNoUs() == 0) {
            bIsActive = false;
            this.staleCDSinceMono = -1L;
        } else if (SystemTime.getCurrentTime() - stats2.getTimeStarted() <= 30000L) {
            bIsActive = true;
            this.staleCDSinceMono = -1L;
        } else {
            bIsActive = stats2.getUploadAverage() >= (long)minSpeedForActiveSeeding;
            long nowMono = SystemTime.getMonotonousTime();
            DiskManager dm = this.core_dm.getDiskManager();
            if (dm != null) {
                long[] latency = dm.getLatency();
                if (latency[0] > 2500L) {
                    if (this.lSeedingHighLatencyTimeMono == -1L && this.rules.bDebugLog) {
                        this.rules.log.log((Object)this.dl.getTorrent(), 1, "seeding speed is low but read latency high, ignoring");
                    }
                    this.lSeedingHighLatencyTimeMono = nowMono;
                    bIsActive = true;
                } else if (this.lSeedingHighLatencyTimeMono != -1L) {
                    if (nowMono - this.lSeedingHighLatencyTimeMono > 60000L) {
                        this.lSeedingHighLatencyTimeMono = -1L;
                    } else {
                        bIsActive = true;
                    }
                }
            }
            if (this.bActivelySeeding != bIsActive) {
                if (this.lCDActivelyChangedOnMono < 0L) {
                    this.lCDActivelyChangedOnMono = nowMono;
                    bIsActive = !bIsActive;
                } else if (nowMono - this.lCDActivelyChangedOnMono < 10000L) {
                    boolean bl = bIsActive = !bIsActive;
                }
                if (this.bActivelySeeding != bIsActive) {
                    if (bIsActive) {
                        this.staleCDSinceMono = -1L;
                        this.staleCDOffset = 0L;
                    } else {
                        this.staleCDSinceMono = nowMono;
                    }
                }
            } else {
                this.lCDActivelyChangedOnMono = -1L;
            }
        }
        if (this.bActivelySeeding != bIsActive) {
            this.bActivelySeeding = bIsActive;
            if (this.rules != null) {
                this.rules.requestProcessCycle(null);
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelySeeding changed");
                }
            }
        }
        return this.bActivelySeeding;
    }

    private void setupTagData() {
        if (this.rules.hasTagDLorCDLimits()) {
            List<Tag> tags = this.rules.getTagManager().getTagsForTaggable(3, (Taggable)this.core_dm);
            if (tags.isEmpty()) {
                this.tagsWithCDLimits = NO_TAG_LIMITS;
                this.tagsWithDLLimits = NO_TAG_LIMITS;
            } else {
                boolean comp2 = this.dl.isComplete();
                ArrayList<TagFeatureRateLimit> lims = new ArrayList<TagFeatureRateLimit>();
                for (Tag tag : tags) {
                    if (!(tag instanceof TagFeatureRateLimit)) continue;
                    TagFeatureRateLimit t = (TagFeatureRateLimit)((Object)tag);
                    if (comp2) {
                        if (t.getMaxActiveSeeds() <= 0) continue;
                        lims.add(t);
                        continue;
                    }
                    if (t.getMaxActiveDownloads() <= 0) continue;
                    lims.add(t);
                }
                if (comp2) {
                    this.tagsWithDLLimits = NO_TAG_LIMITS;
                    this.tagsWithCDLimits = lims.toArray(new TagFeatureRateLimit[lims.size()]);
                } else {
                    this.tagsWithDLLimits = lims.toArray(new TagFeatureRateLimit[lims.size()]);
                    this.tagsWithCDLimits = NO_TAG_LIMITS;
                }
            }
        } else {
            this.tagsWithCDLimits = NO_TAG_LIMITS;
            this.tagsWithDLLimits = NO_TAG_LIMITS;
        }
    }

    @Override
    public TagFeatureRateLimit[] getTagsWithDLLimits() {
        return this.tagsWithDLLimits;
    }

    @Override
    public TagFeatureRateLimit[] getTagsWithCDLimits() {
        return this.tagsWithCDLimits;
    }

    @Override
    public boolean getLastScrapeResultOk() {
        return this.lastScrapeResultOk;
    }

    @Override
    public void scrapeReceived(DownloadScrapeResult result) {
        if (result.getResponseType() == 1) {
            this.updateScrapeCache();
            this.lastScrapeResultOk = true;
        }
    }

    private void updateScrapeCache() {
        DownloadScrapeResult sr = this.dl.getAggregatedScrapeResult(false);
        this.lastModifiedScrapeResultPeers = this.calcPeersNoUs(this.dl, sr);
        this.lastModifiedScrapeResultSeeds = this.calcSeedsNoUs(this.dl, sr);
    }

    @Override
    public int getLastModifiedScrapeResultPeers() {
        return this.lastModifiedScrapeResultPeers;
    }

    @Override
    public int getLastModifiedScrapeResultSeeds() {
        return this.lastModifiedScrapeResultSeeds;
    }

    @Override
    public String getExplainFP() {
        return this._sExplainFP;
    }

    @Override
    public String getExplainSR() {
        return this._sExplainSR;
    }

    @Override
    public void resetTrace() {
        this.sTrace = "";
    }

    @Override
    public void appendTrace(String str) {
        this.sTrace = String.valueOf(this.sTrace) + str;
    }

    @Override
    public String getTrace() {
        return this.sTrace;
    }

    @Override
    public int getSeedingRank() {
        return this.downloadSR.getRank();
    }

    @Override
    public void recalcSeedingRank() {
        try {
            this.downloadData_this_mon.enter();
            boolean ignore0Peers = bIgnore0Peers;
            int lastSR = this.downloadSR.getRank();
            int newSR = this._recalcSeedingRankSupport(ignore0Peers, lastSR, false);
            int newSRIgnoringIgnore0Peers = newSR == -7 ? this._recalcSeedingRankSupport(false, lastSR, true) : newSR;
            this.downloadSR.update(newSR, newSRIgnoringIgnore0Peers);
        }
        finally {
            this.downloadData_this_mon.exit();
        }
    }

    private int _recalcSeedingRankSupport(boolean ignore0Peers, int oldSR, boolean is_test) {
        String sExplainSR = "";
        try {
            int newSR;
            boolean bScrapeResultsOk;
            DownloadStats stats2 = this.dl.getStats();
            this.setupTagData();
            if (!this.dl.isComplete()) {
                int newSR2 = 1000000000 + (10000 - this.dl.getPosition());
                this.isFirstPriority();
                if (this.rules.bDebugLog) {
                    sExplainSR = String.valueOf(sExplainSR) + "  not complete. SetSR " + newSR2 + "\n";
                }
                int n = newSR2;
                return n;
            }
            this.lastModifiedShareRatio = stats2.getShareRatio();
            this.updateScrapeCache();
            boolean bl = bScrapeResultsOk = (this.lastModifiedScrapeResultPeers > 0 || this.lastModifiedScrapeResultSeeds > 0 || this.lastScrapeResultOk) && this.lastModifiedScrapeResultPeers >= 0 && this.lastModifiedScrapeResultSeeds >= 0;
            if (!this.isFirstPriority()) {
                float ratio;
                int activeMaxSR = this.dlSpecificMaxShareRatio;
                if (activeMaxSR <= 0) {
                    activeMaxSR = iIgnoreShareRatio;
                }
                if (!(activeMaxSR == 0 || this.lastModifiedShareRatio < activeMaxSR || this.lastModifiedScrapeResultSeeds < iIgnoreShareRatio_SeedStart && bScrapeResultsOk || this.lastModifiedShareRatio == -1)) {
                    if (this.rules.bDebugLog) {
                        sExplainSR = String.valueOf(sExplainSR) + "  shareratio met: shareRatio(" + this.lastModifiedShareRatio + ") >= " + activeMaxSR + "\n";
                    }
                    return -8;
                }
                if (this.rules.bDebugLog && activeMaxSR != 0 && this.lastModifiedShareRatio >= activeMaxSR) {
                    sExplainSR = String.valueOf(sExplainSR) + "  shareratio NOT met: ";
                    if (this.lastModifiedScrapeResultSeeds >= iIgnoreShareRatio_SeedStart) {
                        sExplainSR = String.valueOf(sExplainSR) + this.lastModifiedScrapeResultSeeds + " below seed threshold of " + iIgnoreShareRatio_SeedStart;
                    }
                    sExplainSR = String.valueOf(sExplainSR) + "\n";
                }
                if (this.lastModifiedScrapeResultPeers == 0 && bScrapeResultsOk) {
                    if (ignore0Peers) {
                        if (this.rules.bDebugLog) {
                            sExplainSR = String.valueOf(sExplainSR) + "  Ignore 0 Peers criteria met\n";
                        }
                        return -7;
                    }
                } else if (this.rules.bDebugLog && this.lastModifiedScrapeResultPeers == 0) {
                    sExplainSR = String.valueOf(sExplainSR) + "  0 Peer Ignore rule NOT applied: Scrape invalid\n";
                }
                if (iIgnoreSeedCount != 0 && this.lastModifiedScrapeResultSeeds >= iIgnoreSeedCount) {
                    if (this.rules.bDebugLog) {
                        sExplainSR = String.valueOf(sExplainSR) + "  SeedCount Ignore rule met.  numSeeds(" + this.lastModifiedScrapeResultSeeds + " >= iIgnoreSeedCount(" + iIgnoreSeedCount + ")\n";
                    }
                    return -5;
                }
                if (iIgnoreRatioPeers != 0 && this.lastModifiedScrapeResultSeeds != 0 && (ratio = (float)this.lastModifiedScrapeResultPeers / (float)this.lastModifiedScrapeResultSeeds) <= (float)iIgnoreRatioPeers && this.lastModifiedScrapeResultSeeds >= iIgnoreRatioPeers_SeedStart) {
                    if (this.rules.bDebugLog) {
                        sExplainSR = String.valueOf(sExplainSR) + "  P:S Ignore rule met.  ratio(" + ratio + " <= threshold(" + iIgnoreRatioPeers_SeedStart + ")\n";
                    }
                    return -4;
                }
            }
            if (iRankType == 0) {
                if (this.rules.bDebugLog) {
                    sExplainSR = String.valueOf(sExplainSR) + "  Ranking Type set to none.. blanking seeding rank\n";
                }
                return 0;
            }
            if (iRankType == 3) {
                int newSR3;
                if (this.bIsFirstPriority) {
                    int newSR4;
                    int n = newSR4 = 200000000;
                    return n;
                }
                int state = this.dl.getState();
                if (state == 6 || state == 7 || state == 8) {
                    if (this.rules.bDebugLog) {
                        sExplainSR = String.valueOf(sExplainSR) + "  Download stopping, stopped or in error\n";
                    }
                    return -2;
                }
                if (state == 5 || state == 3 || state == 1 || state == 2) {
                    int newSR5;
                    long lMsElapsed = 0L;
                    long lMsTimeToSeedFor = minTimeAlive;
                    if (state == 5 && !this.dl.isForceStart()) {
                        int connectedLeechers;
                        PeerManager peerManager;
                        long seedingStart = stats2.getTimeStartedSeeding();
                        lMsElapsed = SystemTime.getCurrentTime() - seedingStart;
                        if (iTimed_MinSeedingTimeWithPeers > 0 && (peerManager = this.dl.getPeerManager()) != null && (connectedLeechers = peerManager.getStats().getConnectedLeechers()) > 0) {
                            lMsTimeToSeedFor = iTimed_MinSeedingTimeWithPeers;
                            String trDebug = null;
                            if (this.rules.bDebugLog) {
                                trDebug = "  Timed Rotation: connected peers, min seeding set to " + lMsTimeToSeedFor / 1000L;
                            }
                            if (iTimed_MaxSeedingTimeWithPeers > iTimed_MinSeedingTimeWithPeers && this.lastModifiedScrapeResultPeers > 0) {
                                if (this.lastModifiedScrapeResultSeeds == 0) {
                                    lMsTimeToSeedFor = iTimed_MaxSeedingTimeWithPeers;
                                    if (this.rules.bDebugLog) {
                                        trDebug = "  Timed Rotation: connected peers, max seeding set and no seeds, min seeding set to " + lMsTimeToSeedFor / 1000L;
                                    }
                                } else {
                                    float psRatio = (float)this.lastModifiedScrapeResultPeers / (float)this.lastModifiedScrapeResultSeeds;
                                    long diff = iTimed_MaxSeedingTimeWithPeers - iTimed_MinSeedingTimeWithPeers;
                                    lMsTimeToSeedFor = (long)((double)lMsTimeToSeedFor + ((double)diff - (double)diff / (1.0 + (double)psRatio)));
                                    if (this.rules.bDebugLog) {
                                        trDebug = "  Timed Rotation: connected peers, max seeding set and SP ratio of " + psRatio + ", min seeding set to " + lMsTimeToSeedFor / 1000L;
                                    }
                                }
                            }
                            if (this.timedRotationSeedingStart == seedingStart) {
                                long max = Math.max(lMsTimeToSeedFor, this.timedRotationSeedingStartMinSeeding);
                                if (max > lMsTimeToSeedFor) {
                                    trDebug = String.valueOf(trDebug) + "; updated to existing max of " + max / 1000L;
                                }
                                lMsTimeToSeedFor = max;
                            } else {
                                this.timedRotationSeedingStart = seedingStart;
                            }
                            this.timedRotationSeedingStartMinSeeding = lMsTimeToSeedFor;
                            if (this.rules.bDebugLog) {
                                sExplainSR = String.valueOf(sExplainSR) + trDebug + "\n";
                            }
                        }
                    }
                    if (lMsElapsed >= lMsTimeToSeedFor) {
                        newSR5 = 1;
                        if (oldSR > 199999999) {
                            if (!is_test) {
                                this.rules.requestProcessCycle(null);
                            }
                            if (this.rules.bDebugLog) {
                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: TimeUp");
                            }
                        }
                    } else {
                        newSR5 = 200000000 + (int)(lMsElapsed / 1000L);
                        if (oldSR <= 199999999) {
                            if (!is_test) {
                                this.rules.requestProcessCycle(null);
                            }
                            if (this.rules.bDebugLog) {
                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: strange timer change");
                            }
                        }
                    }
                    int n = newSR5;
                    return n;
                }
                if (this.dlLastActiveTime == 0L) {
                    long diff = this.dl.getStats().getSecondsOnlySeeding();
                    if (diff > 199899999L) {
                        diff = 199899999 + this.dl.getPosition();
                    }
                    newSR3 = 199999999 - (int)diff;
                } else {
                    long diff = System.currentTimeMillis() / 1000L - this.dlLastActiveTime / 1000L;
                    newSR3 = diff >= 199999999L ? 199999998 : (int)diff;
                }
                int n = newSR3;
                return n;
            }
            if (bScrapeResultsOk) {
                if (iRankType == 4) {
                    if (this.rules.bDebugLog) {
                        sExplainSR = String.valueOf(sExplainSR) + "  PeerCount seeds=" + this.lastModifiedScrapeResultSeeds + "peers=" + this.lastModifiedScrapeResultPeers + "\n";
                    }
                    newSR = this.lastModifiedScrapeResultPeers > this.lastModifiedScrapeResultSeeds * 10 ? 100 * this.lastModifiedScrapeResultPeers * 10 : (int)(100L * (long)this.lastModifiedScrapeResultPeers * (long)this.lastModifiedScrapeResultPeers / (long)(this.lastModifiedScrapeResultSeeds + 1));
                } else if (iRankType == 2 && (iRankTypeSeedFallback == 0 || iRankTypeSeedFallback > this.lastModifiedScrapeResultSeeds)) {
                    if (this.rules.bDebugLog) {
                        sExplainSR = String.valueOf(sExplainSR) + "  SeedCount seeds=" + this.lastModifiedScrapeResultSeeds + "\n";
                    }
                    newSR = this.lastModifiedScrapeResultSeeds < 10000 ? 10000 - this.lastModifiedScrapeResultSeeds : 1;
                    newSR *= SEEDONLY_SHIFT;
                } else if (this.lastModifiedScrapeResultPeers != 0) {
                    if (this.lastModifiedScrapeResultSeeds == 0) {
                        if (this.lastModifiedScrapeResultPeers >= minPeersToBoostNoSeeds) {
                            newSR = SPRATIO_BASE_LIMIT;
                            if (this.rules.bDebugLog) {
                                sExplainSR = String.valueOf(sExplainSR) + "  Seed:Peer ratio=" + this.lastModifiedScrapeResultSeeds + ":" + this.lastModifiedScrapeResultPeers + "\n";
                            }
                        } else {
                            newSR = 0;
                        }
                    } else {
                        float x = (float)this.lastModifiedScrapeResultSeeds / (float)this.lastModifiedScrapeResultPeers;
                        newSR = (int)((float)SPRATIO_BASE_LIMIT / ((x + 1.0f) * (x + 1.0f)));
                        if (this.rules.bDebugLog) {
                            sExplainSR = String.valueOf(sExplainSR) + "  Seed:Peer ratio=" + this.lastModifiedScrapeResultSeeds + ":" + this.lastModifiedScrapeResultPeers + "\n";
                        }
                    }
                } else {
                    newSR = 0;
                }
            } else {
                if (this.rules.bDebugLog) {
                    sExplainSR = String.valueOf(sExplainSR) + "  Can't calculate SR, no scrape results\n";
                }
                return -9;
            }
            if (this.staleCDOffset > 0L) {
                if ((long)newSR > this.staleCDOffset) {
                    newSR = (int)((long)newSR - this.staleCDOffset);
                    sExplainSR = String.valueOf(sExplainSR) + "  subtracted " + this.staleCDOffset + " due to non-activeness\n";
                } else if (!is_test) {
                    this.staleCDOffset = 0L;
                }
            }
            if (newSR < 0) {
                newSR = 1;
            }
            int n = newSR;
            return n;
        }
        finally {
            if (!is_test) {
                this._sExplainSR = sExplainSR;
            }
        }
    }

    @Override
    public boolean isFirstPriority() {
        boolean ignore0Peers = bFirstPriorityIgnore0Peer;
        boolean bFP = this.pisFirstPriority(ignore0Peers, false, false);
        if (this.rules.getTagFP()) {
            this.rules.setFPTagStatus(this.core_dm, this.pisFirstPriority(ignore0Peers, true, true));
        }
        if (this.bIsFirstPriority != bFP) {
            this.bIsFirstPriority = bFP;
            this.rules.requestProcessCycle(null);
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: FP changed");
            }
        }
        return this.bIsFirstPriority;
    }

    private boolean pisFirstPriority(boolean ignore0Peers, boolean is_test, boolean for_tag_fp) {
        String sExplainFP = "";
        try {
            boolean bLastMatched;
            int state;
            DownloadManagerState dm_state;
            long tFlags;
            if (this.rules.bDebugLog) {
                sExplainFP = "FP if " + (iFirstPriorityType == 0 ? "all" : "any") + " criteria match:\n";
            }
            if (((tFlags = (dm_state = this.core_dm.getDownloadState()).getTransientFlags()) & 3L) != 0L) {
                if (this.rules.bDebugLog) {
                    boolean f_fp = (tFlags & 1L) != 0L;
                    boolean t_fp = (tFlags & 2L) != 0L;
                    String str = "";
                    if (f_fp) {
                        str = "Friend(s) have interest";
                        if (t_fp) {
                            str = String.valueOf(str) + " and Tag(s) are FP";
                        }
                    } else {
                        str = "Tag(s) are FP";
                    }
                    sExplainFP = String.valueOf(sExplainFP) + "Is FP: " + str + "\n";
                }
                return true;
            }
            if ((tFlags & 4L) != 0L) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "Not FP: Tag is Not FP\n";
                }
                return false;
            }
            if (!this.dl.isPersistent()) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "Not FP: Download not persistent\n";
                }
                return false;
            }
            if (!(for_tag_fp || (state = this.dl.getState()) != 8 && state != 7)) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "Not FP: Download is ERROR or STOPPED\n";
                }
                return false;
            }
            if (!this.dl.isComplete()) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "Not FP: Download not complete\n";
                }
                return false;
            }
            List listeners = this.rules.getFPListeners();
            StringBuffer fp_listener_debug = null;
            if (!listeners.isEmpty()) {
                if (this.rules.bDebugLog) {
                    fp_listener_debug = new StringBuffer();
                }
                for (StartStopRulesFPListener l : listeners) {
                    boolean result = l.isFirstPriority(this.dl, this.lastModifiedScrapeResultSeeds, this.lastModifiedScrapeResultPeers, fp_listener_debug);
                    if (fp_listener_debug != null && fp_listener_debug.length() > 0) {
                        char last_ch = fp_listener_debug.charAt(fp_listener_debug.length() - 1);
                        if (last_ch != '\n') {
                            fp_listener_debug.append('\n');
                        }
                        sExplainFP = String.valueOf(sExplainFP) + fp_listener_debug;
                        fp_listener_debug.setLength(0);
                    }
                    if (!result) continue;
                    return true;
                }
            }
            if (this.lastModifiedScrapeResultPeers > 0 && this.lastModifiedScrapeResultSeeds > 0 && this.lastModifiedScrapeResultSeeds / this.lastModifiedScrapeResultPeers >= iFirstPriorityIgnoreSPRatio && iFirstPriorityIgnoreSPRatio != 0) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "Not FP: S:P >= " + iFirstPriorityIgnoreSPRatio + ":1\n";
                }
                return false;
            }
            if (this.lastModifiedScrapeResultPeers == 0 && this.lastScrapeResultOk && ignore0Peers) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "Not FP: 0 peers\n";
                }
                return false;
            }
            if (iFirstPriorityIgnoreIdleMinutes > 0) {
                long lastUploadSecs = this.dl.getStats().getSecondsSinceLastUpload();
                if (lastUploadSecs < 0L) {
                    lastUploadSecs = this.dl.getStats().getSecondsOnlySeeding();
                }
                if (lastUploadSecs > 60L * (long)iFirstPriorityIgnoreIdleMinutes) {
                    if (this.rules.bDebugLog) {
                        sExplainFP = String.valueOf(sExplainFP) + "Not FP: " + lastUploadSecs + "s > " + iFirstPriorityIgnoreIdleMinutes + "m of no upload\n";
                    }
                    return false;
                }
            }
            int shareRatio = this.dl.getStats().getShareRatio();
            int activeMinSR = this.dlSpecificMinShareRatio;
            if (activeMinSR <= 0) {
                activeMinSR = minQueueingShareRatio;
            }
            boolean bl = bLastMatched = shareRatio != -1 && shareRatio < activeMinSR;
            if (this.rules.bDebugLog) {
                sExplainFP = String.valueOf(sExplainFP) + "  shareRatio(" + shareRatio + ") < " + activeMinSR + "=" + bLastMatched + "\n";
            }
            if (!bLastMatched && iFirstPriorityType == 0) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "..Not FP.  Exit Early\n";
                }
                return false;
            }
            if (bLastMatched && iFirstPriorityType == 1) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "..Is FP.  Exit Early\n";
                }
                return true;
            }
            boolean bl2 = bLastMatched = iFirstPrioritySeedingMinutes == 0;
            if (!bLastMatched) {
                long timeSeeding = this.dl.getStats().getSecondsOnlySeeding();
                if (timeSeeding >= 0L) {
                    boolean bl3 = bLastMatched = timeSeeding < (long)(iFirstPrioritySeedingMinutes * 60);
                    if (this.rules.bDebugLog) {
                        sExplainFP = String.valueOf(sExplainFP) + "  SeedingTime(" + timeSeeding + ") < " + iFirstPrioritySeedingMinutes * 60 + "=" + bLastMatched + "\n";
                    }
                    if (!bLastMatched && iFirstPriorityType == 0) {
                        if (this.rules.bDebugLog) {
                            sExplainFP = String.valueOf(sExplainFP) + "..Not FP.  Exit Early\n";
                        }
                        return false;
                    }
                    if (bLastMatched && iFirstPriorityType == 1) {
                        if (this.rules.bDebugLog) {
                            sExplainFP = String.valueOf(sExplainFP) + "..Is FP.  Exit Early\n";
                        }
                        return true;
                    }
                }
            } else if (this.rules.bDebugLog) {
                sExplainFP = String.valueOf(sExplainFP) + "  Skipping Seeding Time check (user disabled)\n";
            }
            boolean bl4 = bLastMatched = iFirstPriorityActiveMinutes == 0;
            if (!bLastMatched) {
                long timeActive = this.dl.getStats().getSecondsDownloading() + this.dl.getStats().getSecondsOnlySeeding();
                if (timeActive >= 0L) {
                    boolean bl5 = bLastMatched = timeActive < (long)(iFirstPriorityActiveMinutes * 60);
                    if (this.rules.bDebugLog) {
                        sExplainFP = String.valueOf(sExplainFP) + "  ActiveTime(" + timeActive + ") < " + iFirstPriorityActiveMinutes * 60 + "=" + bLastMatched + "\n";
                    }
                    if (!bLastMatched && iFirstPriorityType == 0) {
                        if (this.rules.bDebugLog) {
                            sExplainFP = String.valueOf(sExplainFP) + "..Not FP.  Exit Early\n";
                        }
                        return false;
                    }
                    if (bLastMatched && iFirstPriorityType == 1) {
                        if (this.rules.bDebugLog) {
                            sExplainFP = String.valueOf(sExplainFP) + "..Is FP.  Exit Early\n";
                        }
                        return true;
                    }
                }
            } else if (this.rules.bDebugLog) {
                sExplainFP = String.valueOf(sExplainFP) + "  Skipping DL Time check (user disabled)\n";
            }
            if (iFirstPriorityType == 0) {
                if (this.rules.bDebugLog) {
                    sExplainFP = String.valueOf(sExplainFP) + "..Is FP\n";
                }
                return true;
            }
            if (this.rules.bDebugLog) {
                sExplainFP = String.valueOf(sExplainFP) + "..Not FP\n";
            }
            return false;
        }
        finally {
            if (!is_test) {
                this._sExplainFP = sExplainFP;
            }
        }
    }

    @Override
    public boolean getCachedIsFP() {
        return this.bIsFirstPriority;
    }

    @Override
    public void setDLRInactive() {
        this.dlr_test_active = false;
    }

    @Override
    public void setDLRActive(long time) {
        if (this.rules.bDebugLog) {
            this.rules.log.log((Object)this.dl.getTorrent(), 1, "download speed test starts");
        }
        this.dlr_test_active = true;
        this.dlr_test_start_time = time;
        this.dl.moveTo(1);
        this.dlr_test_bytes_start = this.dl.getStats().getDownloaded(true);
    }

    @Override
    public void setDLRComplete(long time) {
        long dlr_test_bytes_end = this.dl.getStats().getDownloaded(true);
        long elapsed = time - this.dlr_test_start_time;
        if (elapsed >= 1000L) {
            this.dlr_test_average_bytes_per_sec = (int)((dlr_test_bytes_end - this.dlr_test_bytes_start) * 1000L / elapsed);
            this.dlr_test_eta = this.core_dm.getStats().getSmoothedETA();
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "download speed test ends - average=" + this.dlr_test_average_bytes_per_sec + ", eta=" + this.dlr_test_eta);
            }
        }
        this.dlr_test_active = false;
    }

    @Override
    public long getDLRLastTestTime() {
        return this.dlr_test_start_time;
    }

    @Override
    public int getDLRLastTestSpeed() {
        return this.dlr_test_average_bytes_per_sec;
    }

    @Override
    public long getDLRLastTestETA() {
        long current;
        if (this.dlr_test_eta == -1L && this.isDownloading() && (current = this.core_dm.getStats().getSmoothedETA()) > 0L) {
            return current;
        }
        return this.dlr_test_eta;
    }

    @Override
    public String getDLRTrace() {
        if (this.dlr_test_active) {
            return "test in progress";
        }
        if (this.dlr_test_start_time > 0L) {
            if (this.dlr_test_average_bytes_per_sec >= 0) {
                return "tested; " + TimeFormatter.format((SystemTime.getMonotonousTime() - this.dlr_test_start_time) / 1000L) + " ago; " + "rate=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.dlr_test_average_bytes_per_sec) + ", eta=" + this.dlr_test_eta;
            }
            return "tested; " + TimeFormatter.format((SystemTime.getMonotonousTime() - this.dlr_test_start_time) / 1000L) + " ago; " + "test did not complete";
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.dl.getSeedingRank().getRank());
    }

    @Override
    public boolean changeChecker() {
        long nowMono;
        if (this.getActivelySeeding()) {
            int shareRatio = this.dl.getStats().getShareRatio();
            int numSeeds = this.calcSeedsNoUs(this.dl, this.dl.getAggregatedScrapeResult(false));
            int activeMaxSR = this.dlSpecificMaxShareRatio;
            if (activeMaxSR <= 0) {
                activeMaxSR = iIgnoreShareRatio;
            }
            if (!(activeMaxSR == 0 || shareRatio < activeMaxSR || numSeeds < iIgnoreShareRatio_SeedStart && this.lastScrapeResultOk || shareRatio == -1)) {
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: shareRatio changeChecker");
                }
                return true;
            }
        }
        if (this.dl.getState() == 3) {
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: Download is ready");
            }
            return true;
        }
        if (this.staleCDSinceMono > 0L && (nowMono = SystemTime.getMonotonousTime()) - this.lastStaleCDRefreshMono > 60000L) {
            this.staleCDOffset += (nowMono - this.lastStaleCDRefreshMono) / 60000L;
            this.lastStaleCDRefreshMono = nowMono;
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: staleCD changeChecker");
            }
            return true;
        }
        return false;
    }

    @Override
    public long getLightSeedEligibility() {
        return this.downloadSR.getLightSeedEligibility();
    }

    @Override
    public boolean updateLightSeedEligibility(boolean has_slots) {
        return this.downloadSR.updateLightSeedEligibility(has_slots);
    }

    @Override
    public RankCalculatorSlotReserver getReservedSlot() {
        return this.reservedSlot;
    }

    @Override
    public void setReservedSlot(RankCalculatorSlotReserver slot) {
        if (slot != null) {
            if (this.reservedSlot != null) {
                Debug.out("hmm");
            }
            this.reservedSlot = slot;
        } else {
            if (this.reservedSlot == null) {
                Debug.out("hmm");
            }
            this.reservedSlot = null;
        }
    }

    @Override
    public boolean activationRequest(Runnable to_do) {
        int peers;
        if (this.dl.isComplete() && (peers = this.calcPeersNoUs()) <= 0 && this.downloadSR.getRank() == -7) {
            long now = SystemTime.getMonotonousTime();
            if (!(this.lastActivationAnnounce != 0L && now - this.lastActivationAnnounce <= 300000L || activate_pool.isFull())) {
                this.lastActivationAnnounce = now;
                activate_pool.run(AERunnable.create(() -> {
                    this.dl.requestTrackerAnnounce(true);
                    to_do.run();
                }));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object value) {
        RankCalculatorReal rankCalculatorReal = this;
        synchronized (rankCalculatorReal) {
            if (this.userData == null) {
                this.userData = new LightHashMap<Object, Object>(2);
            }
            this.userData.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        RankCalculatorReal rankCalculatorReal = this;
        synchronized (rankCalculatorReal) {
            block4: {
                if (this.userData != null) break block4;
                return null;
            }
            return this.userData.get(key);
        }
    }

    private class SR
    implements Download.SeedingRank {
        private int rank;
        private int rankNP;
        private long light_seed_eligible = Long.MAX_VALUE;
        private String activation_status = "";

        private SR() {
        }

        private void update(int _rank, int _rankNP) {
            this.rank = _rank;
            this.rankNP = _rankNP;
            if ((this.rank != -7 || this.rankNP < -1) && this.light_seed_eligible == -1L) {
                this.light_seed_eligible = SystemTime.getMonotonousTime();
            }
        }

        private boolean updateLightSeedEligibility(boolean has_slots) {
            boolean result;
            boolean avail;
            boolean bl = avail = has_slots && this.rank == -7 && this.rankNP >= -1 && TorrentUtils.getPrivate(RankCalculatorReal.this.core_dm.getTorrent());
            if (avail) {
                long time_since_not_eligible;
                if (this.light_seed_eligible == -1L) {
                    return false;
                }
                if (this.light_seed_eligible != Long.MAX_VALUE && (time_since_not_eligible = SystemTime.getMonotonousTime() - this.light_seed_eligible) < 120000L) {
                    return false;
                }
                this.light_seed_eligible = -1L;
                return true;
            }
            boolean bl2 = result = this.light_seed_eligible == -1L;
            if (result) {
                this.light_seed_eligible = SystemTime.getMonotonousTime();
            }
            return result;
        }

        @Override
        public int getRank() {
            return this.rank;
        }

        @Override
        public long getLightSeedEligibility() {
            if (this.light_seed_eligible == -1L) {
                return 0L;
            }
            if (this.light_seed_eligible == Long.MAX_VALUE) {
                return this.light_seed_eligible;
            }
            return SystemTime.getMonotonousTime() - this.light_seed_eligible;
        }

        @Override
        public void setActivationStatus(String str) {
            this.activation_status = str;
        }

        @Override
        public String[] getStatus(boolean verbose) {
            long sr = this.rank;
            String sText = "";
            if (sr >= 0L) {
                if (RankCalculatorReal.this.getCachedIsFP()) {
                    sText = String.valueOf(sText) + MessageText.getString("StartStopRules.firstPriority") + " ";
                }
                if (iRankType == 3) {
                    if (sr > 199999999L) {
                        int connectedLeechers;
                        PeerManager peerManager;
                        long seedingStart = RankCalculatorReal.this.dl.getStats().getTimeStartedSeeding();
                        long lMsTimeToSeedFor = minTimeAlive;
                        if (iTimed_MinSeedingTimeWithPeers > 0 && (peerManager = RankCalculatorReal.this.dl.getPeerManager()) != null && (connectedLeechers = peerManager.getStats().getConnectedLeechers()) > 0) {
                            lMsTimeToSeedFor = iTimed_MinSeedingTimeWithPeers;
                            if (iTimed_MaxSeedingTimeWithPeers > iTimed_MinSeedingTimeWithPeers && RankCalculatorReal.this.lastModifiedScrapeResultPeers > 0) {
                                if (RankCalculatorReal.this.lastModifiedScrapeResultSeeds == 0) {
                                    lMsTimeToSeedFor = iTimed_MaxSeedingTimeWithPeers;
                                } else {
                                    float psRatio = (float)RankCalculatorReal.this.lastModifiedScrapeResultPeers / (float)RankCalculatorReal.this.lastModifiedScrapeResultSeeds;
                                    long diff = iTimed_MaxSeedingTimeWithPeers - iTimed_MinSeedingTimeWithPeers;
                                    lMsTimeToSeedFor = (long)((double)lMsTimeToSeedFor + ((double)diff - (double)diff / (1.0 + (double)psRatio)));
                                }
                            }
                            if (RankCalculatorReal.this.timedRotationSeedingStart == seedingStart) {
                                lMsTimeToSeedFor = Math.max(lMsTimeToSeedFor, RankCalculatorReal.this.timedRotationSeedingStartMinSeeding);
                            }
                        }
                        long timeLeft = RankCalculatorReal.this.dl.isForceStart() ? 31536000L : (seedingStart <= 0L ? lMsTimeToSeedFor : lMsTimeToSeedFor - (SystemTime.getCurrentTime() - seedingStart));
                        sText = String.valueOf(sText) + TimeFormatter.format(timeLeft / 1000L);
                    } else if (sr > 0L) {
                        sText = String.valueOf(sText) + MessageText.getString("StartStopRules.waiting");
                    }
                } else if (sr > 0L) {
                    sText = verbose ? String.valueOf(sText) + MessageText.getString("SubscriptionResults.column.rank") + " " + sr : String.valueOf(sText) + String.valueOf(sr);
                }
            } else {
                sText = sr == -6L ? MessageText.getString("StartStopRules.FP0Peers") : (sr == -3L ? MessageText.getString("StartStopRules.SPratioMet") : (sr == -4L ? MessageText.getString("StartStopRules.ratioMet") : (sr == -5L ? MessageText.getString("StartStopRules.numSeedsMet") : (sr == -2L ? "" : (sr == -7L ? MessageText.getString("StartStopRules.0Peers") : (sr == -8L ? MessageText.getString("StartStopRules.shareRatioMet") : (sr == -9L ? MessageText.getString("StartStopRules.noScrape") : "ERR" + sr)))))));
            }
            if (SystemTime.getCurrentTime() - RankCalculatorReal.this.dl.getStats().getTimeStartedSeeding() < minTimeAlive) {
                sText = verbose ? "< " + MessageText.getString("ConfigView.label.minSeedingTime") + "; " + sText : "* " + sText;
            }
            String ls_str = "Light-Seeding eligible";
            if (this.activation_status != null && !this.activation_status.isEmpty()) {
                ls_str = String.valueOf(ls_str) + ": " + this.activation_status;
            }
            String has_slot = "Light-Seeding active";
            if (verbose) {
                if (RankCalculatorReal.this.downloadSR.getLightSeedEligibility() == 0L) {
                    sText = String.valueOf(sText) + "\n" + ls_str;
                }
                if (RankCalculatorReal.this.reservedSlot != null) {
                    sText = String.valueOf(sText) + "\n" + has_slot;
                }
            }
            String tt = ((RankCalculatorReal)RankCalculatorReal.this).rules.bDebugLog ? "FP:\n" + RankCalculatorReal.this._sExplainFP + "\n" + "SR:" + RankCalculatorReal.this._sExplainSR + (verbose || RankCalculatorReal.this.downloadSR.getLightSeedEligibility() != 0L ? "" : String.valueOf(ls_str) + "\n") + (verbose || RankCalculatorReal.this.reservedSlot == null ? "" : String.valueOf(has_slot) + "\n") + "\n" + "TRACE:\n" + RankCalculatorReal.this.sTrace + "  Free Slots: " + RankCalculatorReal.this.rules.getSlotStatus() : null;
            return new String[]{sText, tt};
        }
    }
}

