/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common;

import com.biglybt.core.config.COConfigurationManager;
import java.util.HashMap;
import java.util.Map;

public class RememberedDecisionsManager {
    static {
        COConfigurationManager.addResetToDefaultsListener(new COConfigurationManager.ResetToDefaultsListener(){

            @Override
            public void reset() {
                RememberedDecisionsManager.clearAll();
            }
        });
    }

    public static void ensureLoaded() {
    }

    public static void clearAll() {
        COConfigurationManager.setParameter("MessageBoxWindow.decisions", new HashMap());
    }

    public static int getRememberedDecision(String id) {
        return RememberedDecisionsManager.getRememberedDecision(id, -1);
    }

    public static int getRememberedDecision(String id, int onlyIfInMask) {
        if (id == null || onlyIfInMask == 0) {
            return -1;
        }
        Map remembered_decisions = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap());
        Long l = (Long)remembered_decisions.get(id);
        if (l != null) {
            int i = l.intValue();
            if (onlyIfInMask == -1 || (i & onlyIfInMask) != 0) {
                return i;
            }
        }
        return -1;
    }

    public static void setRemembered(String id, int value) {
        if (id == null) {
            return;
        }
        Map remembered_decisions = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap());
        boolean changed = false;
        if (value == -1) {
            changed = remembered_decisions.remove(id) != null;
        } else {
            Number existing = (Number)remembered_decisions.get(id);
            if (existing == null || existing.intValue() != value) {
                changed = true;
                remembered_decisions.put(id, new Long(value));
            }
        }
        if (changed) {
            COConfigurationManager.setParameter("MessageBoxWindow.decisions", remembered_decisions);
            COConfigurationManager.save();
        }
    }
}

