/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.Main;
import com.biglybt.ui.common.IUserInterface;
import com.biglybt.ui.common.UserInterfaceFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class UIConst {
    public static Date startTime;
    public static LinkedHashMap<String, IUserInterface> UIS;

    public static synchronized boolean startUI(String ui) {
        if (UIS.containsKey(ui)) {
            return false;
        }
        IUserInterface uif = UserInterfaceFactory.getUI(ui);
        UIS.put(ui, uif);
        uif.init(false, true);
        uif.coreCreated(CoreFactory.getSingleton());
        Main.setNewUI(uif);
        return true;
    }

    public static Options buildOptions() {
        Options options = UIConst.getDefaultOptions();
        for (IUserInterface ui : UIS.values()) {
            ui.buildCommandLine(options);
        }
        return options;
    }

    private static Options getDefaultOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Show this help.");
        Option.Builder builder = Option.builder("u").longOpt("ui").argName("uis").hasArg().desc("Run <uis>. ',' separated list of user interfaces to run (swt, console, telnet). The first one given will respond to requests without determinable source UI (e.g. further torrents added via command line).");
        options.addOption(builder.build());
        builder = Option.builder().longOpt("closedown").desc("shutdown an existing instance of BiglyBT");
        options.addOption(builder.build());
        builder = Option.builder().longOpt("shutdown").desc("shutdown an existing instance of BiglyBT");
        options.addOption(builder.build());
        builder = Option.builder().longOpt("restart").desc("restart an existing instance of BiglyBT");
        options.addOption(builder.build());
        builder = Option.builder().longOpt("open").desc("show the BiglyBT interface");
        options.addOption(builder.build());
        builder = Option.builder().longOpt("share").desc("share a resource");
        options.addOption(builder.build());
        builder = Option.builder().longOpt("savepath").argName("path").hasArg().desc("specify the. Absolute save location for the torrent(s)");
        options.addOption(builder.build());
        if (Constants.isWindows) {
            builder = Option.builder("console").desc("(Windows) keeps a console window open while " + Constants.APP_NAME + " is running");
            options.addOption(builder.build());
        }
        return options;
    }

    public static CommandLine buildCommandLine(Options options, String[] args) {
        try {
            return new DefaultParser().parse(options, args, true);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String processArgs(CommandLine commands, Options options, String[] args) {
        StringBuilder sb = new StringBuilder();
        PrintStream oldOut = System.out;
        try {
            ByteArrayOutputStream newOut = new ByteArrayOutputStream();
            System.setOut(new PrintStreamTempCapture(newOut));
            for (IUserInterface ui : UIS.values()) {
                args = ui.processArgs(commands, args);
                if (args == null) break;
                try {
                    commands = new DefaultParser().parse(options, args, true);
                }
                catch (ParseException e) {
                    commands = null;
                }
            }
            try {
                sb.append(new String(newOut.toByteArray(), "utf8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String string = sb.toString();
            return string;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    public static void removeUI(String ui) {
        if (UIS != null) {
            UIS.remove(ui);
        }
    }

    private static class PrintStreamTempCapture
    extends PrintStream {
        public PrintStreamTempCapture(OutputStream out) {
            super(out);
        }
    }
}

