/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common.table.impl;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableContextMenuManager {
    private static TableContextMenuManager instance;
    private static final AEMonitor class_mon;
    private Map<String, Map<String, TableContextMenuItem>> items;
    private final AEMonitor items_mon = new AEMonitor("TableContextMenuManager:items");

    static {
        class_mon = new AEMonitor("TableContextMenuManager");
    }

    private TableContextMenuManager() {
        this.items = new HashMap<String, Map<String, TableContextMenuItem>>();
    }

    public static TableContextMenuManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableContextMenuManager();
            }
            TableContextMenuManager tableContextMenuManager = instance;
            return tableContextMenuManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addContextMenuItem(TableContextMenuItem item) {
        try {
            String name = item.getResourceKey();
            String sTableID = item.getTableID();
            try {
                this.items_mon.enter();
                Map<String, TableContextMenuItem> mTypes = this.items.get(sTableID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, TableContextMenuItem>();
                    this.items.put(sTableID, mTypes);
                }
                mTypes.put(name, item);
            }
            finally {
                this.items_mon.exit();
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Context Table Menu Item");
            Debug.printStackTrace(e);
        }
    }

    public void removeMenuItemsForDetach(String uiType) {
        ArrayList<TableContextMenuItem> toRemove = new ArrayList<TableContextMenuItem>();
        try {
            this.items_mon.enter();
            for (Map<String, TableContextMenuItem> mTypes : this.items.values()) {
                if (mTypes == null) continue;
                for (TableContextMenuItem item : mTypes.values()) {
                    if (!uiType.equals(item.getDisposeWithUIDetach())) continue;
                    toRemove.add(item);
                }
            }
        }
        finally {
            this.items_mon.exit();
        }
        for (MenuItem menuItem : toRemove) {
            menuItem.remove();
        }
    }

    public void removeContextMenuItem(TableContextMenuItem item) {
        Map<String, TableContextMenuItem> menu_item_map = this.items.get(item.getTableID());
        if (menu_item_map != null) {
            menu_item_map.remove(item.getResourceKey());
        }
    }

    public TableContextMenuItem[] getAllAsArray(String sMenuID) {
        Map<String, TableContextMenuItem> local_menu_item_map = this.items.get(sMenuID);
        Map<String, TableContextMenuItem> global_menu_item_map = this.items.get(null);
        if (local_menu_item_map == null && global_menu_item_map == null) {
            return new TableContextMenuItem[0];
        }
        ArrayList<TableContextMenuItem> l = new ArrayList<TableContextMenuItem>();
        if (local_menu_item_map != null) {
            l.addAll(local_menu_item_map.values());
        }
        if (global_menu_item_map != null) {
            l.addAll(global_menu_item_map.values());
        }
        return l.toArray(new TableContextMenuItem[l.size()]);
    }
}

