/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common.table.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.ui.tables.TableRowRefreshListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableCountChangeListener;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableExpansionChangeListener;
import com.biglybt.ui.common.table.TableGroupRowRunner;
import com.biglybt.ui.common.table.TableGroupRowVisibilityRunner;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRefreshListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableStructureModificationListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.DataSourceCallBackUtil;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.util.DataSourceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.PatternSyntaxException;

public abstract class TableViewImpl<DATASOURCETYPE>
implements TableView<DATASOURCETYPE>,
TableStructureModificationListener<DATASOURCETYPE> {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean DEBUG_SORTER = false;
    public static final boolean DEBUGADDREMOVE = System.getProperty("debug.swt.table.addremove", "0").equals("1");
    public static final boolean DEBUG_SELECTION = false;
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    protected static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    private static boolean confusableFiltering;
    private rowSorterRunnable rowSorterRunnable = new rowSorterRunnable();
    private FrequencyLimitedDispatcher rowSorter = new FrequencyLimitedDispatcher(this.rowSorterRunnable, 250);
    protected String tableID;
    private String textPrefixID;
    private final Class<?> classPluginDataSourceType;
    private boolean bReallyAddingDataSources = false;
    private final List<TableColumnCore> sortColumns = new ArrayList<TableColumnCore>();
    private long lLastSortedOn;
    private AEMonitor listeners_mon = new AEMonitor("tablelisteners");
    private ArrayList<TableRowRefreshListener> listenersRowRefesh;
    private CopyOnWriteList<TableDataSourceChangedListener> listenersDataSourceChanged = new CopyOnWriteList();
    private CopyOnWriteList<TableSelectionListener> listenersSelection = new CopyOnWriteList();
    private CopyOnWriteList<TableLifeCycleListener> listenersLifeCycle = new CopyOnWriteList();
    private CopyOnWriteList<TableRefreshListener> listenersRefresh = new CopyOnWriteList();
    private CopyOnWriteList<TableCountChangeListener> listenersCountChange = new CopyOnWriteList(1);
    private CopyOnWriteList<TableExpansionChangeListener> listenersExpansionChange = new CopyOnWriteList(1);
    private Object parentDataSource;
    private final Object rows_sync;
    private List<TableRowCore> sortedRows;
    private IdentityHashMap<DATASOURCETYPE, TableRowCore> mapDataSourceToRow;
    private IdentityHashMap<DATASOURCETYPE, String> listUnfilteredDataSources;
    private IdentityHashMap<DATASOURCETYPE, String> dataSourcesToAdd = new IdentityHashMap(4);
    private IdentityHashMap<DATASOURCETYPE, String> dataSourcesToRemove = new IdentityHashMap(4);
    private AtomicInteger datsaSourceQueueProcessingCount = new AtomicInteger();
    protected filter<DATASOURCETYPE> filter;
    private DataSourceCallBackUtil.addDataSourceCallback processDataSourceQueueCallback = new DataSourceCallBackUtil.addDataSourceCallback(){

        @Override
        public void process() {
            TableViewImpl.this.processDataSourceQueue(false);
        }

        @Override
        public void debug(String str) {
            TableViewImpl.this.debug(str);
        }
    };
    private TableColumnCore[] basicItems;
    private TableColumnCore[] tableColumns;
    private TableColumnCore[] columnsOrdered;
    private LinkedHashSet<TableRowCore> selectedRows = new LinkedHashSet(1);
    private List<Object> listSelectedCoreDataSources;
    private boolean headerVisible = true;
    private boolean menuEnabled = true;
    private LinkedList<HistoryEntry> historyBefore = new LinkedList();
    private LinkedList<HistoryEntry> historyAfter = new LinkedList();
    private static AsyncDispatcher dispatcher;
    private final AtomicInteger visibleRowChangeDisabled = new AtomicInteger();

    static {
        COConfigurationManager.addAndFireParameterListener("Table.filter.confusable", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                confusableFiltering = COConfigurationManager.getBooleanParameter("Table.filter.confusable");
            }
        });
        dispatcher = new AsyncDispatcher();
    }

    public TableViewImpl(Class<?> pluginDataSourceType, String _sTableID, String _sTextPrefixID, Object rows_sync, TableColumnCore[] _basicItems) {
        this.classPluginDataSourceType = pluginDataSourceType;
        this.textPrefixID = _sTextPrefixID;
        this.tableID = _sTableID;
        this.basicItems = _basicItems;
        this.mapDataSourceToRow = new IdentityHashMap();
        this.sortedRows = new ArrayList<TableRowCore>();
        this.listUnfilteredDataSources = new IdentityHashMap();
        this.rows_sync = rows_sync;
        this.initializeColumnDefs();
    }

    private void initializeColumnDefs() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (this.basicItems != null) {
            if (tcManager.getTableColumnCount(this.tableID) != this.basicItems.length) {
                tcManager.addColumns(this.basicItems);
            }
            this.basicItems = null;
        }
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.getDataSourceType(), this.tableID);
        tcManager.ensureIntegrity(this.classPluginDataSourceType, this.tableID);
    }

    @Override
    public void addSelectionListener(TableSelectionListener listener, boolean bFireSelection) {
        this.listenersSelection.add(listener);
        if (bFireSelection) {
            TableRowCore[] rows = this.getSelectedRows();
            listener.selected(rows);
            listener.selectionChanged(new TableRowCore[0], rows);
            listener.focusChanged(this.getFocusedRow());
        }
    }

    @Override
    public void addTableDataSourceChangedListener(TableDataSourceChangedListener l, boolean trigger) {
        this.listenersDataSourceChanged.add(l);
        if (trigger) {
            l.tableDataSourceChanged(this.parentDataSource);
        }
    }

    @Override
    public void removeTableDataSourceChangedListener(TableDataSourceChangedListener l) {
        this.listenersDataSourceChanged.remove(l);
    }

    @Override
    public void setParentDataSource(Object newDataSource) {
        this.parentDataSource = newDataSource;
        Object[] listeners = this.listenersDataSourceChanged.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableDataSourceChangedListener l = (TableDataSourceChangedListener)listeners[i];
            l.tableDataSourceChanged(newDataSource);
            ++i;
        }
    }

    @Override
    public Object getParentDataSource() {
        return this.parentDataSource;
    }

    public void triggerDefaultSelectedListeners(TableRowCore[] selectedRows, int keyMask, int origin) {
        for (TableSelectionListener l : this.listenersSelection) {
            try {
                l.defaultSelected(selectedRows, keyMask, origin);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void triggerLifeCycleListener(int eventType) {
        for (TableLifeCycleListener l : this.listenersLifeCycle) {
            try {
                l.tableLifeCycleEventOccurred(this, eventType, null);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void triggerSelectionChangeListeners(TableRowCore[] selected_rows, TableRowCore[] deselected_rows) {
        for (TableSelectionListener l : this.listenersSelection) {
            try {
                l.selectionChanged(selected_rows, deselected_rows);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void triggerSelectionListeners(TableRowCore[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        for (TableSelectionListener l : this.listenersSelection) {
            try {
                l.selected(rows);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void triggerDeselectionListeners(TableRowCore[] rows) {
        if (rows == null) {
            return;
        }
        for (TableSelectionListener l : this.listenersSelection) {
            try {
                l.deselected(rows);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void triggerMouseEnterExitRow(TableRowCore row, boolean enter) {
        if (row == null) {
            return;
        }
        for (TableSelectionListener l : this.listenersSelection) {
            if (enter) {
                l.mouseEnter(row);
                continue;
            }
            l.mouseExit(row);
        }
    }

    protected void triggerFocusChangedListeners(TableRowCore row) {
        for (TableSelectionListener l : this.listenersSelection) {
            l.focusChanged(row);
        }
    }

    protected void triggerFocusRequested() {
        for (TableSelectionListener l : this.listenersSelection) {
            l.focusRequested();
        }
    }

    protected void triggerTableRefreshListeners() {
        for (TableRefreshListener l : this.listenersRefresh) {
            l.tableRefresh();
        }
    }

    @Override
    public void addLifeCycleListener(TableLifeCycleListener l) {
        this.listenersLifeCycle.add(l);
        if (!this.isDisposed()) {
            l.tableLifeCycleEventOccurred(this, 0, null);
        }
    }

    @Override
    public void addRefreshListener(TableRefreshListener l, boolean trigger) {
        this.listenersRefresh.add(l);
        if (trigger) {
            l.tableRefresh();
        }
    }

    @Override
    public void addCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.add(listener);
    }

    @Override
    public void removeCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.remove(listener);
    }

    public void triggerListenerRowAdded(final TableRowCore[] rows) {
        if (this.listenersCountChange.size() == 0) {
            return;
        }
        this.getOffUIThread(new AERunnable(){

            @Override
            public void runSupport() {
                for (TableCountChangeListener l : TableViewImpl.this.listenersCountChange) {
                    TableRowCore[] tableRowCoreArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore row = tableRowCoreArray[n2];
                        l.rowAdded(row);
                        ++n2;
                    }
                }
            }
        });
    }

    protected void triggerListenerRowRemoved(TableRowCore row) {
        for (TableCountChangeListener l : this.listenersCountChange) {
            l.rowRemoved(row);
        }
    }

    @Override
    public void addExpansionChangeListener(TableExpansionChangeListener listener) {
        this.listenersExpansionChange.add(listener);
    }

    @Override
    public void removeExpansionChangeListener(TableExpansionChangeListener listener) {
        this.listenersExpansionChange.remove(listener);
    }

    public void invokeExpansionChangeListeners(TableRowCore row, boolean expanded) {
        if (this.listenersExpansionChange.size() == 0) {
            return;
        }
        dispatcher.dispatch(() -> {
            Iterator<TableExpansionChangeListener> iter = this.listenersExpansionChange.iterator();
            while (iter.hasNext()) {
                try {
                    if (expanded) {
                        iter.next().rowExpanded(row);
                        continue;
                    }
                    iter.next().rowCollapsed(row);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
    }

    public void addRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.listenersRowRefesh == null) {
                this.listenersRowRefesh = new ArrayList(1);
            }
            this.listenersRowRefesh.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void removeRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.listenersRowRefesh == null) {
                return;
            }
            this.listenersRowRefesh.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void invokeRefreshListeners(TableRowCore row) {
        Object[] listeners;
        try {
            this.listeners_mon.enter();
            if (this.listenersRowRefesh == null) {
                return;
            }
            listeners = this.listenersRowRefesh.toArray();
        }
        finally {
            this.listeners_mon.exit();
        }
        int i = 0;
        while (i < listeners.length) {
            try {
                TableRowRefreshListener l = (TableRowRefreshListener)listeners[i];
                l.rowRefresh(row);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public int runForAllRows(TableGroupRowRunner runner) {
        return this.runForAllRows(runner, false);
    }

    private int runForAllRows(TableGroupRowRunner runner, boolean doSubRows) {
        int done = 0;
        if (doSubRows) {
            TableRowCore[] rows = this.getRows();
            int i = 0;
            while (i < rows.length) {
                runner.run(rows[i]);
                ++done;
                int numSubRows = rows[i].getSubItemCount();
                if (numSubRows > 0) {
                    TableRowCore[] subRows;
                    TableRowCore[] tableRowCoreArray = subRows = rows[i].getSubRowsRecursive(false);
                    int n = subRows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore subRow = tableRowCoreArray[n2];
                        if (subRow != null) {
                            runner.run(subRow);
                            ++done;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            return done;
        }
        TableRowCore[] rows = this.getRows();
        if (runner.run(rows)) {
            return rows.length;
        }
        int i = 0;
        while (i < rows.length) {
            runner.run(rows[i]);
            ++i;
        }
        return rows.length;
    }

    @Override
    public int runForAllRows(TableGroupRowVisibilityRunner runner) {
        if (this.isDisposed()) {
            return 0;
        }
        TableRowCore[] rows = this.getRows();
        int done = 0;
        int i = 0;
        while (i < rows.length) {
            boolean isRowVisible = this.isRowVisible(rows[i]);
            runner.run(rows[i], isRowVisible);
            ++done;
            int numSubRows = rows[i].getSubItemCount();
            if (numSubRows > 0) {
                TableRowCore[] subRows;
                TableRowCore[] tableRowCoreArray = subRows = rows[i].getSubRowsRecursive(false);
                int n = subRows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore subRow = tableRowCoreArray[n2];
                    if (subRow != null) {
                        runner.run(subRow, this.isRowVisible(subRow));
                        ++done;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runForSelectedRows(TableGroupRowRunner runner) {
        TableRowCore[] rows;
        if (this.isDisposed()) {
            return 0;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            rows = this.selectedRows.toArray(new TableRowCore[0]);
        }
        boolean ran = runner.run(rows);
        if (!ran) {
            int i = 0;
            while (i < rows.length) {
                TableRowCore row = rows[i];
                runner.run(row);
                ++i;
            }
        }
        return rows.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnfilteredDataSourceAdded(Object ds) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.listUnfilteredDataSources.containsKey(ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refilter() {
        if (this.filter == null) {
            return false;
        }
        if (this.filter.eventUpdate != null) {
            this.filter.eventUpdate.cancel();
            this.filter.text = this.filter.nextText;
            this.filter.checker.filterSet(this.filter.text, this.filter.regex);
        }
        this.filter.eventUpdate = null;
        boolean subRowsChanged = false;
        boolean changed = false;
        Object object = this.rows_sync;
        synchronized (object) {
            Object[] unfilteredArray = this.listUnfilteredDataSources.keySet().toArray();
            if (DEBUGADDREMOVE) {
                this.debug("filter: unfilteredArray is " + unfilteredArray.length);
            }
            IdentityHashMap<Object, Object> cache = new IdentityHashMap<Object, Object>();
            try {
                int n;
                this.filter.checker.setRefilterCache(cache);
                if (this.getFilterSubRows()) {
                    for (TableRowCore row : this.sortedRows) {
                        TableRowCore[] tableRowCoreArray = row.getSubRowsWithNull();
                        n = tableRowCoreArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableRowCore sr = tableRowCoreArray[n2];
                            if (sr.refilter()) {
                                subRowsChanged = true;
                                changed = true;
                            }
                            ++n2;
                        }
                    }
                }
                HashSet<DATASOURCETYPE> existing = this.getDataSources();
                ArrayList<Object> listRemoves = new ArrayList<Object>();
                ArrayList<Object> listAdds = new ArrayList<Object>();
                Object[] objectArray = unfilteredArray;
                int n3 = unfilteredArray.length;
                n = 0;
                while (n < n3) {
                    boolean isOurs;
                    Object object2 = objectArray[n];
                    boolean bHave = existing.contains(object2);
                    try {
                        isOurs = this.filterCheck(object2);
                    }
                    catch (PatternSyntaxException e) {
                        isOurs = true;
                    }
                    if (!isOurs) {
                        if (bHave) {
                            listRemoves.add(object2);
                        }
                    } else if (!bHave) {
                        listAdds.add(object2);
                    }
                    ++n;
                }
                if (listRemoves.size() > 0) {
                    this.removeDataSources(listRemoves.toArray());
                    changed = true;
                }
                if (listAdds.size() > 0) {
                    this.addDataSources(listAdds.toArray(), true);
                    changed = true;
                }
                for (Object e : listRemoves) {
                    this.listUnfilteredDataSources.put(e, "");
                }
            }
            finally {
                this.filter.checker.setRefilterCache(null);
            }
        }
        if (subRowsChanged) {
            this.tableMutated();
            this.redrawTable();
        }
        this.processDataSourceQueue(true);
        return changed;
    }

    public boolean isFiltered(DATASOURCETYPE ds) {
        if (this.filter == null) {
            return true;
        }
        try {
            return this.filterCheck(ds);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    protected abstract boolean getFilterSubRows();

    protected abstract void redrawTable();

    protected void debug(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("table");
        diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + ":" + this.getTableID() + ": " + s);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "." + Integer.toHexString(this.hashCode()) + "] " + SystemTime.getCurrentTime() + ": " + this.getTableID() + ": " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processDataSourceQueue(boolean refocus) {
        TableRowCore focusedRow;
        boolean hasRemove;
        boolean hasAdd;
        try {
            this.datsaSourceQueueProcessingCount.incrementAndGet();
            Object[] dataSourcesAdd = null;
            Object[] dataSourcesRemove = null;
            Object object = this.rows_sync;
            synchronized (object) {
                if (this.dataSourcesToAdd.size() > 0) {
                    boolean removed_something = false;
                    for (DATASOURCETYPE ds : this.dataSourcesToRemove.keySet()) {
                        if (this.dataSourcesToAdd.remove(ds) == null) continue;
                        removed_something = true;
                    }
                    if (removed_something && DEBUGADDREMOVE) {
                        this.debug("Saved time by not adding a row that was removed");
                    }
                    dataSourcesAdd = this.dataSourcesToAdd.keySet().toArray();
                    this.dataSourcesToAdd = new IdentityHashMap();
                }
                if (this.dataSourcesToRemove.size() > 0) {
                    dataSourcesRemove = this.dataSourcesToRemove.keySet().toArray();
                    if (DEBUGADDREMOVE && dataSourcesRemove.length > 1) {
                        this.debug("Streamlining removing " + dataSourcesRemove.length + " rows");
                    }
                    this.dataSourcesToRemove = new IdentityHashMap();
                }
            }
            boolean bl = hasAdd = dataSourcesAdd != null && dataSourcesAdd.length > 0;
            if (hasAdd) {
                this.reallyAddDataSources(dataSourcesAdd);
                if (DEBUGADDREMOVE && dataSourcesAdd.length > 1) {
                    this.debug("Streamlined adding " + dataSourcesAdd.length + " rows");
                }
            }
            boolean bl2 = hasRemove = dataSourcesRemove != null && dataSourcesRemove.length > 0;
            if (hasRemove) {
                this.reallyRemoveDataSources(dataSourcesRemove);
            }
        }
        finally {
            this.datsaSourceQueueProcessingCount.decrementAndGet();
        }
        if (hasAdd || hasRemove) {
            this.tableMutated();
        }
        if (refocus && (focusedRow = this.getFocusedRow()) != null && !this.isRowVisible(focusedRow)) {
            this.showRow(focusedRow);
        }
    }

    @Override
    public void addDataSource(DATASOURCETYPE dataSource) {
        this.addDataSource(dataSource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataSource(DATASOURCETYPE dataSource, boolean skipFilterCheck) {
        if (dataSource == null) {
            return;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            this.listUnfilteredDataSources.put(dataSource, "");
        }
        if (DEBUGADDREMOVE) {
            this.debug("AddDS: " + dataSource + "; listUnfilteredDS: " + this.listUnfilteredDataSources.size() + " via " + Debug.getCompressedStackTrace(4));
        }
        try {
            if (!skipFilterCheck && this.filter != null && !this.filterCheck(dataSource)) {
                return;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        object = this.rows_sync;
        synchronized (object) {
            if (this.dataSourcesToRemove.remove(dataSource) != null && DEBUGADDREMOVE) {
                this.debug("AddDS: Removed from toRemove.  Total Removals Queued: " + this.dataSourcesToRemove.size());
            }
            if (this.dataSourcesToAdd.containsKey(dataSource)) {
                if (DEBUGADDREMOVE) {
                    this.debug("AddDS: Already There.  Total Additions Queued: " + this.dataSourcesToAdd.size());
                }
            } else {
                this.dataSourcesToAdd.put(dataSource, "");
                if (DEBUGADDREMOVE) {
                    this.debug("Queued 1 dataSource to add.  Total Additions Queued: " + this.dataSourcesToAdd.size() + "; already=" + this.sortedRows.size());
                }
                this.refreshenProcessDataSourcesTimer();
            }
        }
    }

    @Override
    public void addDataSources(DATASOURCETYPE[] dataSources) {
        this.addDataSources(dataSources, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataSources(DATASOURCETYPE[] dataSources, boolean skipFilterCheck) {
        if (dataSources == null) {
            return;
        }
        if (DEBUGADDREMOVE) {
            this.debug("AddDS: " + dataSources.length);
        }
        Object object = this.rows_sync;
        synchronized (object) {
            DATASOURCETYPE[] DATASOURCETYPEArray = dataSources;
            int n = dataSources.length;
            int n2 = 0;
            while (n2 < n) {
                DATASOURCETYPE ds = DATASOURCETYPEArray[n2];
                if (ds != null) {
                    this.listUnfilteredDataSources.put(ds, null);
                }
                ++n2;
            }
        }
        object = this.rows_sync;
        synchronized (object) {
            int count = 0;
            int i = 0;
            while (i < dataSources.length) {
                block17: {
                    DATASOURCETYPE dataSource = dataSources[i];
                    if (dataSource != null) {
                        block16: {
                            try {
                                if (skipFilterCheck || this.filter == null || this.filterCheck(dataSource)) break block16;
                                break block17;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                // empty catch block
                            }
                        }
                        this.dataSourcesToRemove.remove(dataSource);
                        if (!this.dataSourcesToAdd.containsKey(dataSource)) {
                            ++count;
                            this.dataSourcesToAdd.put(dataSource, "");
                        }
                    }
                }
                ++i;
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + count + " of " + dataSources.length + " dataSources to add.  Total Qd: " + this.dataSourcesToAdd.size() + ";Unfiltered: " + this.listUnfilteredDataSources.size() + "; skipFilterCheck? " + skipFilterCheck + "; via " + Debug.getCompressedStackTrace(5));
            }
        }
        this.refreshenProcessDataSourcesTimer();
    }

    boolean filterCheck(DATASOURCETYPE ds) {
        if (confusableFiltering) {
            boolean regex = this.filter.regex;
            if (regex) {
                return this.filter.checker.filterCheck(ds, this.filter.text, regex, false);
            }
            if (this.filter.checker.filterCheck(ds, this.filter.text, false, false)) {
                return true;
            }
            return this.filter.checker.filterCheck(ds, this.filter.text, false, true);
        }
        return this.filter.checker.filterCheck(ds, this.filter.text, this.filter.regex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPendingDSChanges() {
        Object object = this.rows_sync;
        synchronized (object) {
            block4: {
                if (this.dataSourcesToAdd.isEmpty() && this.dataSourcesToRemove.isEmpty()) break block4;
                return true;
            }
        }
        return this.datsaSourceQueueProcessingCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataSourceExists(DATASOURCETYPE dataSource) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.mapDataSourceToRow.containsKey(dataSource) || this.dataSourcesToAdd.containsKey(dataSource);
        }
    }

    @Override
    public void processDataSourceQueue() {
        this.processDataSourceQueue(false);
    }

    @Override
    public void processDataSourceQueue(final boolean refocus) {
        this.getOffUIThread(new AERunnable(){

            @Override
            public void runSupport() {
                TableViewImpl.this._processDataSourceQueue(refocus);
            }
        });
    }

    public abstract void getOffUIThread(AERunnable var1);

    @Override
    public void processDataSourceQueueSync() {
        this._processDataSourceQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(boolean bIncludeQueue) {
        Object object = this.rows_sync;
        synchronized (object) {
            int size = this.sortedRows.size();
            if (bIncludeQueue) {
                if (this.dataSourcesToAdd != null) {
                    size += this.dataSourcesToAdd.size();
                }
                if (this.dataSourcesToRemove != null) {
                    size -= this.dataSourcesToRemove.size();
                }
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getRows() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortedRows.toArray(new TableRowCore[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getRowsAndSubRows(boolean includeHidden) {
        Object object = this.rows_sync;
        synchronized (object) {
            ArrayList<TableRowCore> result = new ArrayList<TableRowCore>();
            this.getRowsAndSubRows(result, this.sortedRows.toArray(new TableRowCore[this.sortedRows.size()]), includeHidden);
            return result.toArray(new TableRowCore[result.size()]);
        }
    }

    private void getRowsAndSubRows(List<TableRowCore> result, TableRowCore[] rows, boolean includeHidden) {
        TableRowCore[] tableRowCoreArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            if (includeHidden || !row.isHidden()) {
                result.add(row);
                if (includeHidden || row.isExpanded()) {
                    this.getRowsAndSubRows(result, row.getSubRowsWithNull(), includeHidden);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean numberAllVisibleRows() {
        boolean changed = false;
        Object object = this.rows_sync;
        synchronized (object) {
            int pos = 0;
            for (TableRowCore row : this.sortedRows) {
                TableRowCore[] kids;
                if (row.isHidden()) continue;
                if (row.setVisibleRowIndex(pos++)) {
                    changed = true;
                }
                if (!row.isExpanded() || (pos = this.numberAllVisibleRows(kids = row.getSubRowsWithNull(), pos)) >= 0) continue;
                changed = true;
                pos = -pos;
            }
        }
        return changed;
    }

    private int numberAllVisibleRows(TableRowCore[] rows, int pos) {
        boolean changed = false;
        TableRowCore[] tableRowCoreArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            if (!row.isHidden()) {
                TableRowCore[] kids;
                if (row.setVisibleRowIndex(pos++)) {
                    changed = true;
                }
                if (row.isExpanded() && (pos = this.numberAllVisibleRows(kids = row.getSubRowsWithNull(), pos)) < 0) {
                    changed = true;
                    pos = -pos;
                }
            }
            ++n2;
        }
        return changed ? -pos : pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRowAndSubRowCount() {
        int[] result = new int[2];
        Object object = this.rows_sync;
        synchronized (object) {
            this.getRowAndSubRowCount(this.sortedRows.toArray(new TableRowCore[this.sortedRows.size()]), result, false);
        }
        return result;
    }

    private void getRowAndSubRowCount(TableRowCore[] rows, int[] result, boolean isHidden) {
        TableRowCore[] tableRowCoreArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hidden;
            TableRowCore row = tableRowCoreArray[n2];
            result[0] = result[0] + 1;
            boolean bl = hidden = isHidden || row.isHidden();
            if (!hidden) {
                result[1] = result[1] + 1;
                if (!row.isExpanded()) {
                    hidden = true;
                }
            }
            this.getRowAndSubRowCount(row.getSubRowsWithNull(), result, hidden);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getRow(DATASOURCETYPE dataSource) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.mapDataSourceToRow.get(dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getRow(int iPos) {
        Object object = this.rows_sync;
        synchronized (object) {
            if (iPos >= 0 && iPos < this.sortedRows.size()) {
                TableRowCore row = this.sortedRows.get(iPos);
                if (row.getIndex() != iPos) {
                    row.setTableItem(iPos);
                }
                return row;
            }
        }
        return null;
    }

    public TableRowCore getRowQuick(int iPos) {
        try {
            return this.sortedRows.get(iPos);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(TableRowCore row) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortedRows.indexOf(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.mapDataSourceToRow.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<DATASOURCETYPE> getDataSources() {
        Object object = this.rows_sync;
        synchronized (object) {
            return new HashSet<DATASOURCETYPE>(this.mapDataSourceToRow.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<DATASOURCETYPE> getDataSources(boolean include_filtered) {
        Object object = this.rows_sync;
        synchronized (object) {
            if (include_filtered) {
                return new HashSet<DATASOURCETYPE>(this.listUnfilteredDataSources.keySet());
            }
            return new HashSet<DATASOURCETYPE>(this.mapDataSourceToRow.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(DATASOURCETYPE dataSource) {
        if (dataSource == null) {
            return;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            this.listUnfilteredDataSources.remove(dataSource);
        }
        if (DEBUGADDREMOVE) {
            this.debug("RemDS: " + dataSource + "; listUnfilteredDS=" + this.listUnfilteredDataSources.size());
        }
        object = this.rows_sync;
        synchronized (object) {
            this.dataSourcesToAdd.remove(dataSource);
            this.dataSourcesToRemove.put(dataSource, "");
            if (DEBUGADDREMOVE) {
                this.debug("Queued 1 dataSource to remove.  Total Queued: " + this.dataSourcesToRemove.size());
            }
        }
        this.refreshenProcessDataSourcesTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSources(DATASOURCETYPE[] dataSources) {
        int n;
        int n2;
        DATASOURCETYPE[] DATASOURCETYPEArray;
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        if (DEBUGADDREMOVE) {
            this.debug("RemDS: " + dataSources.length);
        }
        Object object = this.rows_sync;
        synchronized (object) {
            DATASOURCETYPEArray = dataSources;
            n2 = dataSources.length;
            n = 0;
            while (n < n2) {
                DATASOURCETYPE ds = DATASOURCETYPEArray[n];
                this.listUnfilteredDataSources.remove(ds);
                ++n;
            }
        }
        object = this.rows_sync;
        synchronized (object) {
            DATASOURCETYPEArray = dataSources;
            n2 = dataSources.length;
            n = 0;
            while (n < n2) {
                DATASOURCETYPE dataSource = DATASOURCETYPEArray[n];
                this.dataSourcesToAdd.remove(dataSource);
                this.dataSourcesToRemove.put(dataSource, "");
                ++n;
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + dataSources.length + " dataSources to remove.  Total Qd: " + this.dataSourcesToRemove.size() + "; Unfiltered: " + this.listUnfilteredDataSources.size() + " via " + Debug.getCompressedStackTrace(4));
            }
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void refreshenProcessDataSourcesTimer() {
        if (this.bReallyAddingDataSources || this.processDataSourceQueueCallback == null) {
            return;
        }
        boolean processQueueImmediately = DataSourceCallBackUtil.addDataSourceAggregated(this.processDataSourceQueueCallback);
        if (processQueueImmediately) {
            this.processDataSourceQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyAddDataSources(Object[] dataSources) {
        if (this.isDisposed()) {
            return;
        }
        this.bReallyAddingDataSources = true;
        if (DEBUGADDREMOVE) {
            this.debug(">> Add " + dataSources.length + " rows;");
        }
        Object object = this.rows_sync;
        synchronized (object) {
            try {
                int i = 0;
                while (i < dataSources.length) {
                    Object ds = dataSources[i];
                    if (ds == null) {
                        if (DEBUGADDREMOVE) {
                            this.debug("-- Null DS for " + i);
                        }
                    } else if (this.mapDataSourceToRow.containsKey(ds)) {
                        if (DEBUGADDREMOVE) {
                            this.debug("-- " + i + " already added: " + ds.getClass());
                        }
                        dataSources[i] = null;
                    } else {
                        TableRowCore rowCore = this.createNewRow(ds);
                        this.mapDataSourceToRow.put(ds, rowCore);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Error while added row to Table " + this.getTableID(), e));
            }
        }
        if (DEBUGADDREMOVE) {
            this.debug("-- Add " + dataSources.length + " rows;");
        }
        this.addSortedDataSource(dataSources);
        this.bReallyAddingDataSources = false;
    }

    public abstract TableRowCore createNewRow(Object var1);

    @Override
    public void delete() {
        this.triggerLifeCycleListener(2);
        this.listenersLifeCycle.clear();
        this.listenersCountChange.clear();
        this.listenersDataSourceChanged.clear();
        this.listenersExpansionChange.clear();
        this.listenersRefresh.clear();
        this.listenersSelection.clear();
        this.listenersRowRefesh = null;
        this.processDataSourceQueueCallback = null;
    }

    public Object getRowsSync() {
        return this.rows_sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Diagnostics for " + this + " (" + this.getTableID() + ")");
        Object object = this.rows_sync;
        synchronized (object) {
            writer.println("DataSources scheduled to Add/Remove: " + this.dataSourcesToAdd.size() + "/" + this.dataSourcesToRemove.size());
            writer.println("TableView: " + this.mapDataSourceToRow.size() + " datasources");
            for (DATASOURCETYPE key : this.mapDataSourceToRow.keySet()) {
                writer.println("  " + key + " -> " + this.mapDataSourceToRow.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllTableRows() {
        boolean hadSelected;
        ArrayList<TableRowCore> itemsToRemove;
        Object object = this.rows_sync;
        synchronized (object) {
            itemsToRemove = new ArrayList<TableRowCore>(this.mapDataSourceToRow.values());
            this.mapDataSourceToRow = new IdentityHashMap();
            this.sortedRows.clear();
            this.dataSourcesToAdd.clear();
            this.dataSourcesToRemove.clear();
            this.listUnfilteredDataSources.clear();
            hadSelected = !this.selectedRows.isEmpty();
            this.selectedRows.clear();
            this.listSelectedCoreDataSources = null;
            if (DEBUGADDREMOVE) {
                this.debug("removeAll");
            }
        }
        if (hadSelected) {
            this.triggerTabViewsDataSourceChanged();
        }
        for (TableRowCore row : itemsToRemove) {
            row.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyRemoveDataSources(Object[] dataSources) {
        long lStart = SystemTime.getCurrentTime();
        int rows_removed = 0;
        StringBuffer sbWillRemove = null;
        if (DEBUGADDREMOVE) {
            this.debug(">>> Remove rows.  Start w/" + this.getRowCount() + "ds;" + (SystemTime.getCurrentTime() - lStart) + "ms wait");
            sbWillRemove = new StringBuffer("Will soon remove row #");
        }
        ArrayList<TableRowCore> itemsToRemove = new ArrayList<TableRowCore>();
        ArrayList indexesToRemove = new ArrayList();
        ArrayList<TableRowCore> removedWithSelection = new ArrayList<TableRowCore>();
        Object object = this.rows_sync;
        synchronized (object) {
            IdentityHashSet<TableRowCore> toRemove = new IdentityHashSet<TableRowCore>();
            int i = 0;
            while (i < dataSources.length) {
                TableRowCore item;
                if (dataSources[i] != null && (item = this.mapDataSourceToRow.get(dataSources[i])) != null) {
                    itemsToRemove.add(item);
                    this.mapDataSourceToRow.remove(dataSources[i]);
                    this.triggerListenerRowRemoved(item);
                    toRemove.add(item);
                    if (this.selectedRows.remove(item)) {
                        removedWithSelection.add(item);
                    }
                    ++rows_removed;
                }
                ++i;
            }
            if (rows_removed > 0) {
                this.listSelectedCoreDataSources = null;
                ArrayList<TableRowCore> newSortedRows = new ArrayList<TableRowCore>(this.sortedRows.size());
                for (TableRowCore row : this.sortedRows) {
                    if (toRemove.contains(row)) continue;
                    newSortedRows.add(row);
                }
                this.sortedRows = newSortedRows;
            }
        }
        if (DEBUGADDREMOVE) {
            this.debug(sbWillRemove.toString());
            this.debug("#itemsToRemove=" + itemsToRemove.size());
        }
        if (itemsToRemove.size() > 0) {
            this.uiRemoveRows(itemsToRemove.toArray(new TableRowCore[0]), indexesToRemove.toArray(new Integer[0]));
            for (TableRowCore row : itemsToRemove) {
                row.delete();
            }
        }
        if (!removedWithSelection.isEmpty()) {
            TableRowCore[] deselected = removedWithSelection.toArray(new TableRowCore[removedWithSelection.size()]);
            this.triggerSelectionChangeListeners(new TableRowCore[0], deselected);
            this.triggerDeselectionListeners(deselected);
            this.triggerTabViewsDataSourceChanged();
        }
        if (DEBUGADDREMOVE) {
            this.debug("<< Remove " + itemsToRemove.size() + " rows. now " + this.mapDataSourceToRow.size() + "ds");
        }
    }

    public void tableMutated() {
        filter<DATASOURCETYPE> f = this.filter;
        if (f != null) {
            TableViewFilterCheck checker = f.checker;
            checker.viewChanged(this);
        }
    }

    protected void fillRowGaps(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, true, false);
    }

    @Override
    public void sortRows(boolean bForceDataRefresh, boolean async) {
        if (async) {
            this.rowSorterRunnable.setForceRefresh(bForceDataRefresh);
            this.rowSorter.dispatch();
        } else {
            this._sortColumn(bForceDataRefresh, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _sortColumn(boolean bForceDataRefresh, boolean bFillGapsOnly, boolean bFollowSelected) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.sortColumns.isEmpty()) {
            Iterator<TableColumnCore> iter = this.sortColumns.iterator();
            while (iter.hasNext()) {
                TableColumnCore sortColumn = iter.next();
                if (sortColumn.isVisible()) continue;
                iter.remove();
            }
        }
        int iNumMoves = 0;
        boolean needsUpdate = false;
        boolean orderChanged = false;
        Object object = this.rows_sync;
        synchronized (object) {
            if (bForceDataRefresh && !this.sortColumns.isEmpty()) {
                for (TableColumnCore sortColumn : this.sortColumns) {
                    Iterator<TableRowCore> sColumnID = sortColumn.getName();
                    for (TableRowCore row : this.sortedRows) {
                        TableRowCore[] subs;
                        TableCellCore[] cells;
                        TableCellCore[] tableCellCoreArray = cells = row.getSortColumnCells((String)((Object)sColumnID));
                        int n = cells.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableCellCore cell = tableCellCoreArray[n2];
                            cell.refresh(true);
                            ++n2;
                        }
                        TableRowCore[] tableRowCoreArray = subs = row.getSubRowsRecursive(false);
                        int n3 = subs.length;
                        n = 0;
                        while (n < n3) {
                            TableRowCore sr = tableRowCoreArray[n];
                            TableCellCore[] tableCellCoreArray2 = cells = sr.getSortColumnCells((String)((Object)sColumnID));
                            int n4 = cells.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                TableCellCore cell = tableCellCoreArray2[n5];
                                cell.refresh(true);
                                ++n5;
                            }
                            ++n;
                        }
                    }
                }
            }
            if (!bFillGapsOnly) {
                boolean hasSortValueChanged = false;
                for (TableColumnCore sortColumn : this.sortColumns) {
                    if (sortColumn.getLastSortValueChange() < this.lLastSortedOn) continue;
                    hasSortValueChanged = true;
                    break;
                }
                if (hasSortValueChanged) {
                    this.lLastSortedOn = SystemTime.getCurrentTime();
                    if (this.sortColumns.size() == 1) {
                        this.sortedRows.sort(this.sortColumns.get(0));
                    } else {
                        this.sortedRows.sort((o1, o2) -> {
                            for (TableColumnCore sortColumn : this.sortColumns) {
                                int compare = sortColumn.compare(o1, o2);
                                if (compare == 0) continue;
                                return compare;
                            }
                            return 0;
                        });
                    }
                    for (TableRowCore r : this.sortedRows) {
                        if (!r.sortSubRows(this.sortColumns)) continue;
                        needsUpdate = true;
                        orderChanged = true;
                    }
                }
            }
            int i = 0;
            while (i < this.sortedRows.size()) {
                TableRowCore row = this.sortedRows.get(i);
                boolean visible = row.isVisible();
                if (row.setTableItem(i)) {
                    orderChanged = true;
                    if (visible) {
                        needsUpdate = true;
                    }
                    ++iNumMoves;
                }
                ++i;
            }
        }
        if (orderChanged) {
            this.tableMutated();
        }
        if (needsUpdate) {
            this.visibleRowsChanged();
        }
    }

    public abstract void visibleRowsChanged();

    public boolean visibleRowChangeDisabled() {
        return this.visibleRowChangeDisabled.get() > 0;
    }

    public abstract void uiRemoveRows(TableRowCore[] var1, Integer[] var2);

    public abstract int uiGuessMaxVisibleRows();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetLastSortedOn() {
        Object object = this.rows_sync;
        synchronized (object) {
            this.lLastSortedOn = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore[] getColumnCells(String sColumnName) {
        Object object = this.rows_sync;
        synchronized (object) {
            TableCellCore[] cells = new TableCellCore[this.sortedRows.size()];
            int i = 0;
            for (TableRowCore row : this.sortedRows) {
                cells[i++] = row.getTableCellCore(sColumnName);
            }
            return cells;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSortedDataSource(Object[] dataSources) {
        if (this.isDisposed()) {
            return;
        }
        TableRowCore[] selectedRows = this.getSelectedRows();
        try {
            this.visibleRowChangeDisabled.incrementAndGet();
            try {
                if (DEBUGADDREMOVE) {
                    this.debug("-- Add " + dataSources.length + " rows to SWT");
                }
                long lStartTime = SystemTime.getCurrentTime();
                ArrayList<TableRowCore> rowsAdded = new ArrayList<TableRowCore>(dataSources.length);
                if (dataSources.length < 100) {
                    int i = 0;
                    while (i < dataSources.length) {
                        Object dataSource = dataSources[i];
                        if (dataSource != null) {
                            TableRowCore row;
                            Object object = this.rows_sync;
                            synchronized (object) {
                                row = this.mapDataSourceToRow.get(dataSource);
                            }
                            if (row != null && !row.isRowDisposed()) {
                                Object cells;
                                if (!this.sortColumns.isEmpty()) {
                                    Object object2 = cells = row.getSortColumnCells(null);
                                    int n = ((TableCellCore[])cells).length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        TableCellCore cell = object2[n2];
                                        try {
                                            cell.invalidate();
                                            cell.refresh(true);
                                        }
                                        catch (Exception e) {
                                            Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + this.getTableID(), e));
                                        }
                                        ++n2;
                                    }
                                }
                                cells = this.rows_sync;
                                synchronized (cells) {
                                    if (row == this.mapDataSourceToRow.get(dataSource)) {
                                        try {
                                            int index = 0;
                                            if (this.sortedRows.size() > 0) {
                                                TableRowCore lastRow = this.sortedRows.get(this.sortedRows.size() - 1);
                                                if (this.sortColumns.isEmpty() || this.sortColumns.get(0).compare(row, lastRow) >= 0) {
                                                    index = this.sortedRows.size();
                                                    this.sortedRows.add(row);
                                                    if (DEBUGADDREMOVE) {
                                                        this.debug("Adding new row to bottom");
                                                    }
                                                } else {
                                                    index = Collections.binarySearch(this.sortedRows, row, this.sortColumns.get(0));
                                                    if (index < 0) {
                                                        index = -1 * index - 1;
                                                    }
                                                    if (index > this.sortedRows.size()) {
                                                        index = this.sortedRows.size();
                                                    }
                                                    if (DEBUGADDREMOVE) {
                                                        this.debug("Adding new row at position " + index + " of " + (this.sortedRows.size() - 1));
                                                    }
                                                    this.sortedRows.add(index, row);
                                                }
                                            } else {
                                                if (DEBUGADDREMOVE) {
                                                    this.debug("Adding new row to bottom (1st Entry)");
                                                }
                                                index = this.sortedRows.size();
                                                this.sortedRows.add(row);
                                            }
                                            rowsAdded.add(row);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            Logger.log(new LogEvent(LOGID, "Error adding a row to table " + this.getTableID(), e));
                                            try {
                                                if (!this.sortedRows.contains(row)) {
                                                    this.sortedRows.add(row);
                                                }
                                            }
                                            catch (Exception e2) {
                                                Debug.out(e2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                } else {
                    Object i = this.rows_sync;
                    synchronized (i) {
                        ArrayList<TableRowCore> newSortedRows = new ArrayList<TableRowCore>(this.sortedRows.size() + dataSources.length);
                        newSortedRows.addAll(this.sortedRows);
                        this.sortedRows = newSortedRows;
                    }
                    int numSortCols = this.sortColumns.size();
                    int i2 = 0;
                    while (i2 < dataSources.length) {
                        Object dataSource = dataSources[i2];
                        if (dataSource != null) {
                            TableRowCore row;
                            Object e = this.rows_sync;
                            synchronized (e) {
                                row = this.mapDataSourceToRow.get(dataSource);
                            }
                            if (row != null && !row.isRowDisposed()) {
                                if (numSortCols > 0) {
                                    for (TableColumnCore sortColumn : this.sortColumns) {
                                        TableRowCore[] subs;
                                        TableCellCore[] cells;
                                        String sColumnID = sortColumn.getName();
                                        TableCellCore[] tableCellCoreArray = cells = row.getSortColumnCells(sColumnID);
                                        int n = cells.length;
                                        int n3 = 0;
                                        while (n3 < n) {
                                            TableCellCore cell = tableCellCoreArray[n3];
                                            try {
                                                cell.invalidate();
                                                cell.refresh(true);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            ++n3;
                                        }
                                        TableRowCore[] tableRowCoreArray = subs = row.getSubRowsRecursive(true);
                                        int n4 = subs.length;
                                        n = 0;
                                        while (n < n4) {
                                            TableRowCore sr = tableRowCoreArray[n];
                                            TableCellCore[] tableCellCoreArray2 = cells = sr.getSortColumnCells(sColumnID);
                                            int n5 = cells.length;
                                            int n6 = 0;
                                            while (n6 < n5) {
                                                TableCellCore cell = tableCellCoreArray2[n6];
                                                try {
                                                    cell.invalidate();
                                                    cell.refresh(true);
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                ++n6;
                                            }
                                            ++n;
                                        }
                                    }
                                }
                                Object object = this.rows_sync;
                                synchronized (object) {
                                    if (row == this.mapDataSourceToRow.get(dataSource)) {
                                        this.sortedRows.add(row);
                                    }
                                    rowsAdded.add(row);
                                }
                            }
                        }
                        ++i2;
                    }
                    if (numSortCols > 0) {
                        Object object = this.rows_sync;
                        synchronized (object) {
                            if (numSortCols == 1) {
                                this.sortedRows.sort(this.sortColumns.get(0));
                            } else {
                                this.sortedRows.sort((o1, o2) -> {
                                    for (TableColumnCore sortColumn : this.sortColumns) {
                                        int compare = sortColumn.compare(o1, o2);
                                        if (compare == 0) continue;
                                        return compare;
                                    }
                                    return 0;
                                });
                            }
                        }
                    }
                }
                this.triggerListenerRowAdded(rowsAdded.toArray(new TableRowCore[0]));
                if (DEBUGADDREMOVE) {
                    this.debug("Adding took " + (SystemTime.getCurrentTime() - lStartTime) + "ms");
                }
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Error while adding row to Table " + this.getTableID(), e));
            }
            this.refreshenProcessDataSourcesTimer();
        }
        finally {
            this.visibleRowChangeDisabled.decrementAndGet();
        }
        this.visibleRowsChanged();
        this.fillRowGaps(false);
        if (selectedRows.length > 0) {
            this.setSelectedRows(selectedRows);
        }
        if (DEBUGADDREMOVE) {
            this.debug("<< " + this.size(false));
        }
    }

    @Override
    public void cellInvalidate(TableColumnCore tableColumn, DATASOURCETYPE data_source) {
        this.cellInvalidate(tableColumn, data_source, true);
    }

    public void cellInvalidate(TableColumnCore tableColumn, final DATASOURCETYPE data_source, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null && cell.getDataSource() != null && cell.getDataSource().equals(data_source)) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    @Override
    public void columnInvalidate(String sColumnName) {
        this.columnInvalidate(sColumnName, false);
    }

    @Override
    public void columnInvalidate(String sColumnName, boolean mustRefresh) {
        TableColumnCore tc = TableColumnManager.getInstance().getTableColumnCore(this.getTableID(), sColumnName);
        if (tc != null) {
            this.columnInvalidate(tc, tc.getType() == 3 || mustRefresh);
        }
    }

    public void columnInvalidate(final TableColumnCore tableColumn, final boolean bMustRefresh) {
        this.runForAllRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(tableColumn.getName());
                if (cell == null) {
                    return;
                }
                cell.invalidate(bMustRefresh);
                if (bMustRefresh && TableViewImpl.this.hasSortColumn(tableColumn)) {
                    cell.refresh(true, true, true);
                }
            }
        }, true);
        this.resetLastSortedOn();
        tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
    }

    @Override
    public void columnInvalidate(TableColumnCore tableColumn) {
        this.columnInvalidate(tableColumn, true);
    }

    @Override
    public String getTextPrefixID() {
        return this.textPrefixID;
    }

    @Override
    public String getTableID() {
        return this.tableID;
    }

    @Override
    public Class<?> getDataSourceType() {
        return this.classPluginDataSourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableStructureChanged(boolean columnAddedOrRemoved, Class forPluginDataSourceType) {
        Object[] unfilteredDS;
        if (forPluginDataSourceType != null && !DataSourceUtils.isPluginTypeCompatible(forPluginDataSourceType, this.getDataSourceType())) {
            return;
        }
        this.triggerLifeCycleListener(1);
        Object object = this.rows_sync;
        synchronized (object) {
            unfilteredDS = this.listUnfilteredDataSources.keySet().toArray();
        }
        if (DEBUGADDREMOVE) {
            this.debug("TSC: #Unfiltered=" + unfilteredDS.length);
        }
        this.removeAllTableRows();
        this.processDataSourceQueueSync();
        boolean orderChanged = false;
        if (this.columnsOrdered.length > 1 && !columnAddedOrRemoved) {
            int i = 0;
            while (i < this.columnsOrdered.length - 2) {
                if (this.columnsOrdered[i].getPosition() > this.columnsOrdered[i + 1].getPosition()) {
                    orderChanged = true;
                    break;
                }
                ++i;
            }
        }
        if (columnAddedOrRemoved || orderChanged) {
            this.tableColumns = TableColumnManager.getInstance().getAllTableColumnCoreAsArray(this.getDataSourceType(), this.tableID);
            ArrayList<TableColumnCore> listVisibleColumns = new ArrayList<TableColumnCore>();
            TableColumnCore[] tableColumnCoreArray = this.tableColumns;
            int n = this.tableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnCore column = tableColumnCoreArray[n2];
                if (column.isVisible()) {
                    listVisibleColumns.add(column);
                }
                ++n2;
            }
            Collections.sort(listVisibleColumns, new Comparator<TableColumnCore>(){

                @Override
                public int compare(TableColumnCore o1, TableColumnCore o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int diff = o1.getPosition() - o2.getPosition();
                    return diff;
                }
            });
            this.columnsOrdered = listVisibleColumns.toArray(new TableColumnCore[0]);
        }
        this.refreshTable(false);
        this.triggerLifeCycleListener(0);
        if (this.listUnfilteredDataSources.size() == 0) {
            this.addDataSources(unfilteredDS);
        }
    }

    @Override
    public TableColumn getTableColumn(String sColumnName) {
        int i = 0;
        while (i < this.tableColumns.length) {
            TableColumnCore tc = this.tableColumns[i];
            if (tc.getName().equals(sColumnName)) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TableColumn getTableColumn(String sColumnName, boolean localized) {
        int i = 0;
        while (i < this.tableColumns.length) {
            TableColumnCore tc = this.tableColumns[i];
            if (localized ? MessageText.getString(tc.getTitleLanguageKey()).equalsIgnoreCase(sColumnName) : tc.getName().equals(sColumnName)) {
                return tc;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TableColumnCore[] getVisibleColumns() {
        return this.columnsOrdered;
    }

    @Override
    public TableColumnCore[] getAllColumns() {
        return this.tableColumns;
    }

    public void setColumnsOrdered(TableColumnCore[] columnsOrdered) {
        this.columnsOrdered = columnsOrdered;
    }

    @Override
    public boolean isColumnVisible(TableColumn column) {
        if (column == null) {
            return false;
        }
        return column.isVisible();
    }

    @Override
    public void refreshTable(boolean bForceSort) {
        this.triggerTableRefreshListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSelectedDataSourcesList() {
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.listSelectedCoreDataSources != null) {
                return this.listSelectedCoreDataSources;
            }
            if (this.isDisposed() || this.selectedRows.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> l = new ArrayList<Object>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                Object ds;
                if (row == null || row.isRowDisposed() || (ds = row.getDataSource(true)) == null) continue;
                l.add(ds);
            }
            this.listSelectedCoreDataSources = l;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSelectedPluginDataSourcesList() {
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.isDisposed() || this.selectedRows.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> l = new ArrayList<Object>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                Object ds;
                if (row == null || row.isRowDisposed() || (ds = row.getDataSource(false)) == null) continue;
                l.add(ds);
            }
            return l;
        }
    }

    @Override
    public List<Object> getSelectedDataSources() {
        return new ArrayList<Object>(this.getSelectedDataSourcesList());
    }

    @Override
    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        if (bCoreDataSource) {
            return this.getSelectedDataSourcesList().toArray();
        }
        return this.getSelectedPluginDataSourcesList().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSelectedRows() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.selectedRows.toArray(new TableRowCore[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectedRowsSize() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.selectedRows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableRowCore> getSelectedRowsList() {
        Object object = this.rows_sync;
        synchronized (object) {
            ArrayList<TableRowCore> l = new ArrayList<TableRowCore>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                if (row == null || row.isRowDisposed()) continue;
                l.add(row);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(TableRow row) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.selectedRows.contains(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getFocusedRow() {
        Object object = this.rows_sync;
        synchronized (object) {
            block4: {
                if (this.selectedRows.size() != 0) break block4;
                return null;
            }
            return (TableRowCore)this.selectedRows.iterator().next();
        }
    }

    @Override
    public Object getFirstSelectedDataSource() {
        return this.getFirstSelectedDataSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirstSelectedDataSource(boolean bCoreObject) {
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.selectedRows.size() > 0) {
                return ((TableRowCore)this.selectedRows.iterator().next()).getDataSource(bCoreObject);
            }
        }
        return null;
    }

    public void tableInvalidate() {
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            @Override
            public void run(TableRowCore row, boolean bVisible) {
                row.invalidate();
                row.refresh(true, bVisible);
            }
        });
    }

    @Override
    public boolean getHeaderVisible() {
        return this.headerVisible;
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        this.headerVisible = visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSortColumn(TableColumn column) {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortColumns.contains(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSortColumnCount() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortColumns.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableColumnCore[] getSortColumns() {
        Object object = this.rows_sync;
        synchronized (object) {
            return this.sortColumns.toArray(new TableColumnCore[0]);
        }
    }

    @Override
    public void addSortColumn(TableColumnCore column) {
        TableColumnCore[] sortColumns = this.getSortColumns();
        ArrayList<TableColumnCore> listNewColumns = new ArrayList<TableColumnCore>();
        boolean alreadySortingByColumn = false;
        HashMap<TableColumnCore, Boolean> originalAscMap = new HashMap<TableColumnCore, Boolean>();
        TableColumnCore[] tableColumnCoreArray = sortColumns;
        int n = sortColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumnCore existingSortColumn = tableColumnCoreArray[n2];
            listNewColumns.add(existingSortColumn);
            if (existingSortColumn == column) {
                boolean asc = column.isSortAscending();
                originalAscMap.put(column, asc);
                column.setSortAscending(!asc);
                alreadySortingByColumn = true;
            }
            ++n2;
        }
        if (!alreadySortingByColumn) {
            listNewColumns.add(column);
        }
        this.setSortColumns(listNewColumns.toArray(new TableColumnCore[0]), false, originalAscMap, true);
    }

    @Override
    public boolean setSortColumns(TableColumnCore[] newSortColumns, boolean allowOrderChange) {
        return this.setSortColumns(newSortColumns, allowOrderChange, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSortColumns(TableColumnCore[] newSortColumns, boolean allowOrderChange, Map<TableColumnCore, Boolean> originalAscMap, boolean doHistory) {
        if (newSortColumns == null) {
            return false;
        }
        Object object = this.rows_sync;
        synchronized (object) {
            boolean columnsChanged;
            TableColumnCore[] originalColumns = null;
            boolean[] originalAscending = null;
            if (doHistory) {
                originalColumns = this.sortColumns.toArray(new TableColumnCore[this.sortColumns.size()]);
                originalAscending = new boolean[originalColumns.length];
                int i = 0;
                while (i < originalColumns.length) {
                    Boolean asc;
                    originalAscending[i] = originalColumns[i].isSortAscending();
                    if (originalAscMap != null && (asc = originalAscMap.get(originalColumns[i])) != null) {
                        originalAscending[i] = asc;
                    }
                    ++i;
                }
            }
            boolean bl = columnsChanged = this.sortColumns.size() != newSortColumns.length;
            if (!columnsChanged) {
                int i = 0;
                while (i < this.sortColumns.size()) {
                    TableColumnCore s1;
                    TableColumnCore s0 = this.sortColumns.get(i);
                    if (!s0.equals(s1 = newSortColumns[i])) {
                        columnsChanged = true;
                        break;
                    }
                    ++i;
                }
            }
            String[] sortColumnNames = new String[newSortColumns.length];
            int i = 0;
            while (i < sortColumnNames.length) {
                sortColumnNames[i] = newSortColumns[i].getName();
                ++i;
            }
            if (allowOrderChange) {
                if (columnsChanged) {
                    this.sortColumns.clear();
                    this.sortColumns.addAll(Arrays.asList(newSortColumns));
                    int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
                    TableColumnCore sortColumn = this.sortColumns.get(0);
                    if (iSortDirection == 0) {
                        sortColumn.setSortAscending(true);
                    } else if (iSortDirection == 1) {
                        sortColumn.setSortAscending(false);
                    } else if (iSortDirection == 2) {
                        sortColumn.setSortAscending(!sortColumn.isSortAscending());
                    }
                    TableColumnManager.getInstance().setSortColumnNames(this.tableID, sortColumnNames);
                } else {
                    TableColumnCore sortColumn;
                    sortColumn.setSortAscending(!(sortColumn = this.sortColumns.get(0)).isSortAscending());
                }
            } else {
                this.sortColumns.clear();
                this.sortColumns.addAll(Arrays.asList(newSortColumns));
                TableColumnManager.getInstance().setSortColumnNames(this.tableID, sortColumnNames);
            }
            if (columnsChanged) {
                for (TableRowCore row : this.sortedRows) {
                    row.setSortColumn(sortColumnNames);
                }
            }
            if (doHistory && originalColumns.length > 0) {
                TableColumnCore[] newColumns = this.sortColumns.toArray(new TableColumnCore[this.sortColumns.size()]);
                boolean[] newAscending = new boolean[newColumns.length];
                int i2 = 0;
                while (i2 < newColumns.length) {
                    newAscending[i2] = newColumns[i2].isSortAscending();
                    ++i2;
                }
                this.addHistory(new HistorySort(originalColumns, originalAscending, newColumns, newAscending));
            }
            this.uiChangeColumnIndicator();
            this.resetLastSortedOn();
            this.sortRows(columnsChanged, false);
            return columnsChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowSelected(TableRowCore row, boolean selected, boolean trigger) {
        if (row == null || row.isRowDisposed()) {
            return;
        }
        if (this.isSingleSelection()) {
            this.setSelectedRows(new TableRowCore[]{row}, trigger);
        } else {
            ArrayList<TableRowCore> newSelectedRows;
            boolean somethingChanged = false;
            Object object = this.rows_sync;
            synchronized (object) {
                newSelectedRows = new ArrayList<TableRowCore>(this.selectedRows);
                if (selected) {
                    if (!newSelectedRows.contains(row)) {
                        newSelectedRows.add(row);
                        somethingChanged = true;
                    }
                } else {
                    somethingChanged = newSelectedRows.remove(row);
                }
            }
            if (somethingChanged) {
                this.setSelectedRows(newSelectedRows.toArray(new TableRowCore[0]), trigger);
            }
        }
    }

    public void setSelectedRows(TableRowCore[] newSelectionArray, boolean trigger) {
        this.setSelectedRows(newSelectionArray, trigger, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedRows(TableRowCore[] newSelectionArray, boolean trigger, boolean updateHistory) {
        boolean somethingChanged;
        if (this.isDisposed()) {
            return;
        }
        LinkedHashSet<TableRowCore> oldSelectionSet = new LinkedHashSet<TableRowCore>();
        LinkedHashSet<TableRowCore> newlySelectedSet = new LinkedHashSet<TableRowCore>();
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.selectedRows.size() == 0 && newSelectionArray.length == 0) {
                return;
            }
            oldSelectionSet.addAll(this.selectedRows);
            this.listSelectedCoreDataSources = null;
            this.selectedRows.clear();
            TableRowCore[] tableRowCoreArray = newSelectionArray;
            int n = newSelectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                if (row != null && !row.isRowDisposed()) {
                    if (oldSelectionSet.contains(row)) {
                        if (!this.selectedRows.contains(row)) {
                            this.selectedRows.add(row);
                        }
                        oldSelectionSet.remove(row);
                    } else {
                        if (!this.selectedRows.contains(row)) {
                            this.selectedRows.add(row);
                        }
                        if (!newlySelectedSet.contains(row)) {
                            newlySelectedSet.add(row);
                        }
                    }
                }
                ++n2;
            }
            boolean bl = somethingChanged = newlySelectedSet.size() > 0 || oldSelectionSet.size() > 0;
            if (somethingChanged && updateHistory) {
                this.addHistory(new HistorySelection(oldSelectionSet.toArray(new TableRowCore[oldSelectionSet.size()]), this.selectedRows.toArray(new TableRowCore[this.selectedRows.size()])));
            }
        }
        if (somethingChanged) {
            TableRowCore[] selected = newlySelectedSet.toArray(new TableRowCore[0]);
            TableRowCore[] deselected = oldSelectionSet.toArray(new TableRowCore[0]);
            this.uiSelectionChanged(selected, deselected);
            if (trigger) {
                this.triggerSelectionChangeListeners(selected, deselected);
            }
        }
        if (trigger && somethingChanged) {
            if (newlySelectedSet.size() > 0) {
                this.triggerSelectionListeners(newlySelectedSet.toArray(new TableRowCore[0]));
            }
            if (oldSelectionSet.size() > 0) {
                this.triggerDeselectionListeners(oldSelectionSet.toArray(new TableRowCore[0]));
            }
            this.triggerTabViewsDataSourceChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reaffirmSelection() {
        if (this.isTableFocused()) {
            ArrayList<TableRowCore> oldSelectionList = new ArrayList<TableRowCore>();
            Object object = this.rows_sync;
            synchronized (object) {
                if (this.selectedRows.size() == 0) {
                    return;
                }
                oldSelectionList.addAll(this.selectedRows);
            }
            TableRowCore[] rows = oldSelectionList.toArray(new TableRowCore[0]);
            this.triggerSelectionChangeListeners(rows, rows);
            this.triggerSelectionListeners(rows);
        }
    }

    public abstract boolean isSingleSelection();

    public abstract void uiSelectionChanged(TableRowCore[] var1, TableRowCore[] var2);

    @Override
    public void setSelectedRows(TableRowCore[] rows) {
        this.setSelectedRows(rows, true);
    }

    @Override
    public void selectAll() {
        this.setSelectedRows(this.getFilterSubRows() ? this.getRowsAndSubRows(false) : this.getRows(), true);
    }

    public String getFilterText() {
        return this.filter == null ? "" : this.filter.text;
    }

    public boolean isMenuEnabled() {
        return this.menuEnabled;
    }

    public void setMenuEnabled(boolean menuEnabled) {
        this.menuEnabled = menuEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLastRow(TableRowCore row) {
        Object object = this.rows_sync;
        synchronized (object) {
            int size = this.sortedRows.size();
            return size == 0 ? false : this.sortedRows.get(size - 1) == row;
        }
    }

    public abstract void triggerTabViewsDataSourceChanged();

    protected abstract void uiChangeColumnIndicator();

    @Override
    public boolean isTableSelected() {
        return SelectedContentManager.getCurrentlySelectedTableView() == this;
    }

    protected abstract boolean isTableFocused();

    @Override
    public boolean canMoveBack() {
        return !this.historyBefore.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveBack() {
        UIFunctions uiFunctions;
        HistoryEntry history;
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.historyBefore.isEmpty()) {
                return;
            }
            history = this.historyBefore.removeLast();
            this.historyAfter.addFirst(history);
        }
        history.applyPrev();
        if (SelectedContentManager.getCurrentlySelectedTableView() == this && (this.historyBefore.isEmpty() || this.historyAfter.size() == 1) && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public boolean canMoveForward() {
        return !this.historyAfter.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveForward() {
        UIFunctions uiFunctions;
        HistoryEntry history;
        Object object = this.rows_sync;
        synchronized (object) {
            if (this.historyAfter.isEmpty()) {
                return;
            }
            history = this.historyAfter.removeFirst();
            this.historyBefore.addLast(history);
        }
        history.applyNext();
        if (SelectedContentManager.getCurrentlySelectedTableView() == this && (this.historyAfter.isEmpty() || this.historyBefore.size() == 1) && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
            uiFunctions.refreshIconBar();
        }
    }

    private void addHistory(HistoryEntry entry) {
        UIFunctions uiFunctions;
        this.historyBefore.add(entry);
        if (this.historyBefore.size() > 32) {
            this.historyBefore.removeFirst();
        }
        boolean historyAfterWasEmpty = this.historyAfter.isEmpty();
        this.historyAfter.clear();
        if (!(SelectedContentManager.getCurrentlySelectedTableView() != this || historyAfterWasEmpty && this.historyBefore.size() != 1 || (uiFunctions = UIFunctionsManager.getUIFunctions()) == null)) {
            uiFunctions.refreshIconBar();
        }
    }

    private static interface HistoryEntry {
        public void applyNext();

        public void applyPrev();
    }

    private class HistorySelection
    implements HistoryEntry {
        private final TableRowCore[] prevSel;
        private final TableRowCore[] nextSel;

        HistorySelection(TableRowCore[] _prev, TableRowCore[] _next) {
            this.prevSel = _prev;
            this.nextSel = _next;
        }

        @Override
        public void applyNext() {
            this.apply(this.nextSel);
        }

        @Override
        public void applyPrev() {
            this.apply(this.prevSel);
        }

        private void apply(TableRowCore[] sel) {
            TableRowCore first;
            TableViewImpl.this.triggerFocusRequested();
            TableViewImpl.this.setSelectedRows(sel, true, false);
            if (sel.length > 0 && !(first = sel[0]).isVisible()) {
                TableViewImpl.this.showRow(first);
            }
        }
    }

    private class HistorySort
    implements HistoryEntry {
        private final TableColumnCore[] prevCols;
        private final TableColumnCore[] nextCols;
        private final boolean[] prevAsc;
        private final boolean[] nextAsc;

        HistorySort(TableColumnCore[] pCols, boolean[] pAsc, TableColumnCore[] nCols, boolean[] nAsc) {
            this.prevCols = pCols;
            this.prevAsc = pAsc;
            this.nextCols = nCols;
            this.nextAsc = nAsc;
        }

        @Override
        public void applyNext() {
            this.apply(this.nextCols, this.nextAsc);
        }

        @Override
        public void applyPrev() {
            this.apply(this.prevCols, this.prevAsc);
        }

        private void apply(TableColumnCore[] columns, boolean[] asc) {
            int i = 0;
            while (i < columns.length) {
                columns[i].setSortAscending(asc[i]);
                ++i;
            }
            TableViewImpl.this.setSortColumns(columns, false, null, false);
        }
    }

    public static class filter<DATASOURCETYPE> {
        public TimerEvent eventUpdate;
        public String text = "";
        public long lastFilterTime;
        public boolean regex = false;
        public TableViewFilterCheck<DATASOURCETYPE> checker;
        public String nextText = "";
    }

    private class rowSorterRunnable
    extends AERunnable {
        private AtomicBoolean forceRefreshPending = new AtomicBoolean();

        private rowSorterRunnable() {
        }

        @Override
        public void runSupport() {
            TableViewImpl.this.sortRows(this.forceRefreshPending.getAndSet(false), false);
        }

        public void setForceRefresh(boolean fs) {
            if (fs) {
                this.forceRefreshPending.set(true);
            }
        }
    }
}

