/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.common.util;

import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.ui.common.util.MenuItemManagerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MenuItemManager {
    private static final boolean DEBUG_MENU_STUFF = Constants.IS_CVS_VERSION;
    private static MenuItemManager instance;
    private static AEMonitor class_mon;
    private Map<String, Map<String, List<MenuItem>>> items_map;
    private AEMonitor items_mon = new AEMonitor("MenuManager:items");
    private ArrayList<MenuItemManagerListener> listeners = new ArrayList(0);

    static {
        class_mon = new AEMonitor("MenuManager");
    }

    private MenuItemManager() {
        this.items_map = new HashMap<String, Map<String, List<MenuItem>>>();
    }

    public static MenuItemManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new MenuItemManager();
            }
            MenuItemManager menuItemManager = instance;
            return menuItemManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addMenuItem(MenuItem item) {
        try {
            String name = item.getResourceKey();
            String sMenuID = item.getMenuID();
            try {
                List<MenuItem> mis;
                this.items_mon.enter();
                Map<String, List<MenuItem>> mTypes = this.items_map.get(sMenuID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, List<MenuItem>>();
                    this.items_map.put(sMenuID, mTypes);
                }
                if ((mis = mTypes.get(name)) == null) {
                    mis = new ArrayList<MenuItem>(1);
                    mTypes.put(name, mis);
                }
                mis.add(item);
            }
            finally {
                this.items_mon.exit();
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Menu Item");
            Debug.printStackTrace(e);
        }
    }

    public List<MenuItem> getMenuItems(String menu_id, String resource_key) {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        try {
            List<MenuItem> mis;
            this.items_mon.enter();
            Map<String, List<MenuItem>> mTypes = this.items_map.get(menu_id);
            if (mTypes != null && (mis = mTypes.get(resource_key)) != null) {
                result.addAll(mis);
            }
        }
        finally {
            this.items_mon.exit();
        }
        return result;
    }

    public void removeMenuItemsForDetach(String uiType) {
        ArrayList<MenuItem> toRemove = new ArrayList<MenuItem>();
        try {
            this.items_mon.enter();
            for (Map<String, List<MenuItem>> mTypes : this.items_map.values()) {
                if (mTypes == null) continue;
                for (List<MenuItem> items : mTypes.values()) {
                    for (MenuItem item : items) {
                        if (!uiType.equals(item.getDisposeWithUIDetach())) continue;
                        toRemove.add(item);
                    }
                }
            }
        }
        finally {
            this.items_mon.exit();
        }
        for (MenuItem menuItem : toRemove) {
            menuItem.remove();
        }
    }

    public void removeAllMenuItems(String sMenuID) {
        try {
            this.items_mon.enter();
            Map<String, List<MenuItem>> mTypes = this.items_map.get(sMenuID);
            if (mTypes == null) {
                return;
            }
            Iterator<Map.Entry<String, List<MenuItem>>> it = mTypes.entrySet().iterator();
            while (it.hasNext()) {
                List<MenuItem> mis = it.next().getValue();
                if (mis.size() > 0) {
                    if (DEBUG_MENU_STUFF) {
                        Debug.out("Removing arbitrary menu item for " + sMenuID);
                    }
                    mis.remove(0);
                }
                if (mis.size() != 0) continue;
                it.remove();
            }
            if (mTypes.isEmpty()) {
                this.items_map.remove(sMenuID);
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public void removeMenuItem(MenuItem item) {
        try {
            this.items_mon.enter();
            Map<String, List<MenuItem>> menu_item_map = this.items_map.get(item.getMenuID());
            if (menu_item_map != null) {
                List<MenuItem> mis = menu_item_map.get(item.getResourceKey());
                if (mis != null) {
                    if (!mis.remove(item) && mis.size() > 0) {
                        if (DEBUG_MENU_STUFF) {
                            Debug.out("Removing arbitrary menu item for " + item.getMenuID() + "/" + item.getResourceKey());
                        }
                        mis.remove(0);
                    }
                    if (mis.size() == 0) {
                        menu_item_map.remove(item.getResourceKey());
                    }
                }
                if (menu_item_map.isEmpty()) {
                    this.items_map.remove(item.getMenuID());
                }
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    public boolean hasMenuItems(String sMenuID) {
        if (sMenuID != null) {
            this.triggerMenuItemQuery(sMenuID);
        }
        try {
            this.items_mon.enter();
            Map<String, List<MenuItem>> local_menu_item_map = this.items_map.get(sMenuID);
            Map<String, List<MenuItem>> global_menu_item_map = this.items_map.get(null);
            if (local_menu_item_map == null && global_menu_item_map == null) {
                return false;
            }
            if (sMenuID == null) {
                local_menu_item_map = null;
            }
            if (local_menu_item_map != null) {
                for (List<MenuItem> mis : local_menu_item_map.values()) {
                    if (mis.size() <= 0) continue;
                    return true;
                }
            }
            if (global_menu_item_map != null) {
                for (List<MenuItem> mis : global_menu_item_map.values()) {
                    if (mis.size() <= 0) continue;
                    return true;
                }
            }
        }
        finally {
            this.items_mon.exit();
        }
        return false;
    }

    public MenuItem[] getAllAsArray(String sMenuID) {
        if (sMenuID != null) {
            this.triggerMenuItemQuery(sMenuID);
        }
        try {
            this.items_mon.enter();
            Map<String, List<MenuItem>> local_menu_item_map = this.items_map.get(sMenuID);
            Map<String, List<MenuItem>> global_menu_item_map = this.items_map.get(null);
            if (local_menu_item_map == null && global_menu_item_map == null) {
                MenuItem[] menuItemArray = new MenuItem[]{};
                return menuItemArray;
            }
            if (sMenuID == null) {
                local_menu_item_map = null;
            }
            ArrayList<MenuItem> l = new ArrayList<MenuItem>();
            if (local_menu_item_map != null) {
                for (List<MenuItem> mis : local_menu_item_map.values()) {
                    if (mis.size() <= 0) continue;
                    if (DEBUG_MENU_STUFF && mis.size() > 1) {
                        Debug.out("Returning arbitrary menu item for " + sMenuID);
                    }
                    l.add(mis.get(0));
                }
            }
            if (global_menu_item_map != null) {
                for (List<MenuItem> mis : global_menu_item_map.values()) {
                    if (mis.size() <= 0) continue;
                    if (DEBUG_MENU_STUFF && mis.size() > 1) {
                        Debug.out("Returning arbitrary menu item for " + sMenuID);
                    }
                    l.add(mis.get(0));
                }
            }
            MenuItem[] menuItemArray = l.toArray(new MenuItem[l.size()]);
            return menuItemArray;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public MenuItem[] getAllAsArray(String[] menu_ids) {
        ArrayList<MenuItem> l = new ArrayList<MenuItem>();
        int i = 0;
        while (i < menu_ids.length) {
            if (menu_ids[i] != null) {
                this.triggerMenuItemQuery(menu_ids[i]);
            }
            this.extractMenuItems(menu_ids[i], l);
            ++i;
        }
        this.extractMenuItems(null, l);
        return l.toArray(new MenuItem[l.size()]);
    }

    private void extractMenuItems(String menu_id, ArrayList<MenuItem> l) {
        try {
            this.items_mon.enter();
            Map<String, List<MenuItem>> menu_map = this.items_map.get(menu_id);
            if (menu_map != null) {
                for (List<MenuItem> mis : menu_map.values()) {
                    if (mis.size() <= 0) continue;
                    if (DEBUG_MENU_STUFF && mis.size() > 1) {
                        Debug.out("Returning arbitrary menu item for " + menu_id);
                    }
                    l.add(mis.get(0));
                }
            }
        }
        finally {
            this.items_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MenuItemManagerListener l) {
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MenuItemManagerListener l) {
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerMenuItemQuery(String id) {
        MenuItemManagerListener[] listenersArray;
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersArray = this.listeners.toArray(new MenuItemManagerListener[0]);
        }
        MenuItemManagerListener[] menuItemManagerListenerArray = listenersArray;
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItemManagerListener l = menuItemManagerListenerArray[n2];
            try {
                l.queryForMenuItem(id);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerMenuItemCleanup(String id) {
        MenuItemManagerListener[] listenersArray;
        ArrayList<MenuItemManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersArray = this.listeners.toArray(new MenuItemManagerListener[0]);
        }
        MenuItemManagerListener[] menuItemManagerListenerArray = listenersArray;
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItemManagerListener l = menuItemManagerListenerArray[n2];
            try {
                l.cleanupMenuItem(id);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++n2;
        }
    }
}

