/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.backup.BackupManager;
import com.biglybt.core.backup.BackupManagerFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.pif.ui.config.DirectoryParameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.InfoParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConfigSectionBackupRestore
extends ConfigSectionImpl {
    public static final String SECTION_ID = "backuprestore";
    public static final String PP_BACKUP_LAST_TIME = "lasttime";
    public static final String PP_BACKUP_LAST_ERR = "lasterr";
    private ConfigSectionImpl.ConfigDetailsCallback cbManualBackup;
    private ConfigSectionImpl.ConfigDetailsCallback cbBackupNow;
    private ConfigSectionImpl.ConfigDetailsCallback cbRestore;

    public ConfigSectionBackupRestore() {
        super(SECTION_ID, "root");
    }

    public void init(ConfigSectionImpl.ConfigDetailsCallback cbManualBackup, ConfigSectionImpl.ConfigDetailsCallback cbBackupNow, ConfigSectionImpl.ConfigDetailsCallback cbRestore) {
        this.cbManualBackup = cbManualBackup;
        this.cbBackupNow = cbBackupNow;
        this.cbRestore = cbRestore;
    }

    @Override
    public void build() {
        Core core = CoreFactory.getSingleton();
        BackupManager backup_manager = BackupManagerFactory.getManager(core);
        ArrayList listBackupParams = new ArrayList();
        this.add("overview", new LabelParameterImpl("ConfigView.section.br.overview"), new List[0]);
        this.add("backuprestore.link", new HyperlinkParameterImpl("ConfigView.label.please.visit.here", "https://wiki.biglybt.com/w/Backup_And_Restore"), new List[0]);
        long backup_time = backup_manager.getLastBackupTime();
        InfoParameterImpl paramInfoLastTime = new InfoParameterImpl(null, "br.backup.last.time", backup_time == 0L ? "" : String.valueOf(new Date(backup_time)));
        this.add(PP_BACKUP_LAST_TIME, paramInfoLastTime, listBackupParams);
        InfoParameterImpl paramInfoLastErr = new InfoParameterImpl(null, "br.backup.last.error", backup_manager.getLastBackupError());
        this.add(PP_BACKUP_LAST_ERR, paramInfoLastErr, listBackupParams);
        if (this.cbManualBackup != null) {
            ActionParameterImpl paramBackupButton = new ActionParameterImpl("br.backup.manual.info", "br.backup");
            paramBackupButton.setStyle(1);
            paramBackupButton.addListener(param -> this.cbManualBackup.run(this.mapPluginParams));
            this.add("btnManualBackup", paramBackupButton, listBackupParams);
        }
        BooleanParameterImpl paramEnableBackup = new BooleanParameterImpl("br.backup.auto.enable", "br.backup.auto.enable");
        this.add(paramEnableBackup, listBackupParams);
        DirectoryParameterImpl paramPath = new DirectoryParameterImpl("br.backup.auto.dir", "ConfigView.section.file.defaultdir.ask");
        this.add(paramPath, listBackupParams);
        paramPath.setDialogTitleKey("ConfigView.section.file.defaultdir.ask");
        paramPath.setDialogMessageKey("br.backup.auto.dir.select");
        if (paramPath.getValue().length() == 0) {
            String def_dir = COConfigurationManager.getStringParameter("br.backup.folder.default");
            paramPath.setValue(def_dir);
        }
        paramPath.addListener(p -> {
            String path = ((DirectoryParameter)p).getValue();
            COConfigurationManager.setParameter("br.backup.folder.default", path);
        });
        BooleanParameterImpl paramDoPlugins = new BooleanParameterImpl("br.restore.doplugins", "br.backup.do.plugins");
        this.add(paramDoPlugins, listBackupParams);
        IntParameterImpl paramBackupDays = new IntParameterImpl("br.backup.auto.everydays", "br.backup.auto.everydays", 0, Integer.MAX_VALUE);
        this.add(paramBackupDays, listBackupParams);
        IntParameterImpl paramBackupHours = new IntParameterImpl("br.backup.auto.everyhours", "br.backup.auto.everyhours", 0, Integer.MAX_VALUE);
        this.add(paramBackupHours, listBackupParams);
        IntParameterImpl paramAutoRetain = new IntParameterImpl("br.backup.auto.retain", "br.backup.auto.retain", 1, Integer.MAX_VALUE);
        this.add(paramAutoRetain, listBackupParams);
        BooleanParameterImpl paramNotify = new BooleanParameterImpl("br.backup.notify", "br.backup.notify");
        paramNotify.setAllowedUiTypes("swt");
        this.add(paramNotify, listBackupParams);
        BooleanParameterImpl pauseDownloads = new BooleanParameterImpl("br.backup.pause.downloads", "br.backup.pause.downloads");
        pauseDownloads.setAllowedUiTypes("swt");
        this.add(pauseDownloads, listBackupParams);
        ActionParameterImpl paramBackupNow = new ActionParameterImpl("br.backup.auto.now", "br.test");
        this.add("backupNow", paramBackupNow, listBackupParams);
        paramBackupNow.addListener(param -> {
            if (this.cbBackupNow == null) {
                backup_manager.runAutoBackup(null);
            } else {
                this.cbBackupNow.run(this.mapPluginParams);
            }
        });
        ParameterListener enableListener = n -> {
            boolean enable = paramEnableBackup.getValue();
            boolean hoursEnable = enable && paramBackupDays.getValue() == 0;
            paramPath.setEnabled(enable);
            paramBackupDays.setEnabled(enable);
            paramBackupHours.setEnabled(hoursEnable);
            paramAutoRetain.setEnabled(enable);
            paramNotify.setEnabled(enable);
            paramBackupNow.setEnabled(enable);
        };
        paramEnableBackup.addListener(enableListener);
        paramBackupDays.addListener(enableListener);
        enableListener.parameterChanged(null);
        this.add(new ParameterGroupImpl("br.backup", listBackupParams), new List[0]);
        if (this.cbRestore != null) {
            ArrayList listRestoreParams = new ArrayList();
            ActionParameterImpl paramButtonRestore = new ActionParameterImpl("br.restore.info", "br.restore");
            this.add("backuprestore.restore", paramButtonRestore, listRestoreParams);
            paramButtonRestore.addListener(param -> this.cbRestore.run(this.mapPluginParams));
            this.add(new BooleanParameterImpl("br.restore.autopause", "br.restore.autopause"), listRestoreParams);
            this.add(new ParameterGroupImpl("br.restore", listRestoreParams), new List[0]);
        }
    }
}

