/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.InfoParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionConnectionAdvanced
extends ConfigSectionImpl {
    public static final String SECTION_ID = "connection.advanced";

    public ConfigSectionConnectionAdvanced() {
        super(SECTION_ID, "server", 2);
    }

    @Override
    public void build() {
        this.add(new HyperlinkParameterImpl("ConfigView.section.connection.advanced.info.link", "https://wiki.biglybt.com/w/UG_Options#Advanced_Network_Settings"), new List[0]);
        ArrayList listSocket = new ArrayList();
        this.add(new IntParameterImpl("network.max.simultaneous.connect.attempts", "ConfigView.section.connection.network.max.simultaneous.connect.attempts", 1, 100), listSocket);
        this.add(new IntParameterImpl("network.tcp.max.connections.outstanding", "ConfigView.section.connection.network.max.outstanding.connect.attempts", 1, 65536), listSocket);
        StringParameterImpl paramBindIP = new StringParameterImpl("Bind IP", "ConfigView.label.bindip");
        this.add(paramBindIP, listSocket);
        InfoParameterImpl paramInterfaceList = new InfoParameterImpl(null, null, "");
        this.add("ifList", paramInterfaceList, listSocket);
        paramInterfaceList.setTextSelectable(true);
        BooleanParameterImpl paramInterfaceWithAddresses = new BooleanParameterImpl("ConfigView.section.connection.show.intf.with.addresses", "ConfigView.label.show.intf.with.addresses");
        paramInterfaceWithAddresses.setDefaultValue(true);
        Runnable set_intf = () -> paramInterfaceList.setValue(MessageText.getString("ConfigView.label.bindip.details", new String[]{"\n\t" + NetworkAdmin.getSingleton().getNetworkInterfacesAsString(paramInterfaceWithAddresses.getValue()).replaceAll("\n", "\n\t")}));
        paramInterfaceWithAddresses.addAndFireListener(n -> set_intf.run());
        this.add(paramInterfaceWithAddresses, listSocket);
        StringParameterImpl paramAdditionServiceBind = new StringParameterImpl("Additional Service Bind IPs", "ConfigView.label.additional.service.bind");
        this.add(paramAdditionServiceBind, listSocket);
        BooleanParameterImpl paramIgnoreBindLAN = new BooleanParameterImpl("Ignore Bind For LAN", "ConfigView.label.ignore.bind.for.lan");
        this.add(paramIgnoreBindLAN, listSocket);
        BooleanParameterImpl paramCheckBind = new BooleanParameterImpl("Check Bind IP On Start", "network.check.ipbinding");
        this.add(paramCheckBind, listSocket);
        BooleanParameterImpl paramForceBind = new BooleanParameterImpl("Enforce Bind IP", "network.enforce.ipbinding");
        this.add(paramForceBind, listSocket);
        BooleanParameterImpl paramForceBindPause = new BooleanParameterImpl("Enforce Bind IP Pause", "network.enforce.ipbinding.pause");
        this.add(paramForceBindPause, listSocket);
        paramForceBindPause.setIndent(1, true);
        paramForceBind.addEnabledOnSelection((Parameter)paramForceBindPause);
        BooleanParameterImpl paramBindIcon = new BooleanParameterImpl("Show IP Bindings Icon", "network.ipbinding.icon.show");
        this.add(paramBindIcon, listSocket);
        paramBindIcon.setAllowedUiTypes("swt");
        BooleanParameterImpl paramVPNGuess = new BooleanParameterImpl("network.admin.maybe.vpn.enable", "network.admin.maybe.vpn.enable");
        paramVPNGuess.setAllowedUiTypes("swt");
        this.add(paramVPNGuess, listSocket);
        IntParameterImpl paramPortBind = new IntParameterImpl("network.bind.local.port", "ConfigView.section.connection.advanced.bind_port", 0, 65535);
        this.add(paramPortBind, listSocket);
        IntParameterImpl paramMtuSize = new IntParameterImpl("network.tcp.mtu.size", "ConfigView.section.connection.advanced.mtu", 0, 524288);
        this.add(paramMtuSize, listSocket);
        IntParameterImpl paramSoSndBuf = new IntParameterImpl("network.tcp.socket.SO_SNDBUF", "ConfigView.section.connection.advanced.SO_SNDBUF");
        this.add(paramSoSndBuf, new List[0]);
        LabelParameterImpl paramSendCurr = new LabelParameterImpl("");
        this.add("sendcur", paramSendCurr, new List[0]);
        ParameterGroupImpl pgSoSnd = new ParameterGroupImpl(null, paramSoSndBuf, paramSendCurr);
        this.add("pgSoSnd", pgSoSnd, listSocket);
        pgSoSnd.setNumberOfColumns(2);
        IntParameterImpl paramSoRcvBuf = new IntParameterImpl("network.tcp.socket.SO_RCVBUF", "ConfigView.section.connection.advanced.SO_RCVBUF");
        this.add(paramSoRcvBuf, new List[0]);
        LabelParameterImpl paramRcvCurr = new LabelParameterImpl("");
        this.add("rcvcur", paramRcvCurr, new List[0]);
        ParameterGroupImpl pgSoRcv = new ParameterGroupImpl(null, paramSoRcvBuf, paramRcvCurr);
        this.add("pgSoRcv", pgSoRcv, listSocket);
        pgSoRcv.setNumberOfColumns(2);
        Runnable buff_updater = () -> {
            int rec_val;
            int snd_val;
            block17: {
                SocketChannel sc = null;
                snd_val = 0;
                rec_val = 0;
                try {
                    try {
                        sc = SocketChannel.open();
                        Socket socket = sc.socket();
                        if (paramSoSndBuf.getValue() == 0) {
                            snd_val = socket.getSendBufferSize();
                        }
                        if (paramSoRcvBuf.getValue() == 0) {
                            rec_val = socket.getReceiveBufferSize();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            sc.close();
                        }
                        catch (Throwable throwable2) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        sc.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    sc.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (snd_val == 0) {
                paramSendCurr.setLabelText("");
            } else {
                paramSendCurr.setLabelText(MessageText.getString("label.current.equals", new String[]{String.valueOf(snd_val)}));
            }
            if (rec_val == 0) {
                paramRcvCurr.setLabelText("");
            } else {
                paramRcvCurr.setLabelText(MessageText.getString("label.current.equals", new String[]{String.valueOf(rec_val)}));
            }
        };
        buff_updater.run();
        paramSoRcvBuf.addListener(param -> buff_updater.run());
        paramSoSndBuf.addListener(param -> buff_updater.run());
        StringParameterImpl paramIPDiffServ = new StringParameterImpl("network.tcp.socket.IPDiffServ", "ConfigView.section.connection.advanced.IPDiffServ");
        this.add(paramIPDiffServ, listSocket);
        paramIPDiffServ.setWidthInCharacters(15);
        paramIPDiffServ.setValidChars("0123456789xABCDEF", false);
        paramIPDiffServ.addStringValidator((p, toValue) -> {
            boolean valid;
            String reason = null;
            if (toValue.length() == 0) {
                valid = true;
            } else {
                try {
                    int value = Integer.decode(toValue);
                    boolean bl = valid = value >= 0 && value <= 255;
                    if (!valid) {
                        reason = "Not within range of 0 - 255";
                    }
                }
                catch (Throwable t) {
                    valid = false;
                    reason = t.getMessage();
                }
            }
            return new ParameterValidator.ValidationInfo(valid, reason);
        });
        paramIPDiffServ.addListener(p -> {
            String raw = ((StringParameterImpl)p).getValue();
            int value = -1;
            try {
                value = Integer.decode(raw);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (value < 0 || value > 255) {
                COConfigurationManager.removeParameter("network.tcp.socket.IPDiffServ");
                ConfigSectionConnectionAdvanced.enableTOSRegistrySetting(false);
            } else {
                ConfigSectionConnectionAdvanced.enableTOSRegistrySetting(true);
            }
        });
        IntParameterImpl paramReadSelect = new IntParameterImpl("network.tcp.read.select.time", "", 10, 250);
        this.add(paramReadSelect, listSocket);
        paramReadSelect.setLabelText(MessageText.getString("ConfigView.section.connection.advanced.read_select", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.read.select.time"))}));
        IntParameterImpl paramReadSelectMin = new IntParameterImpl("network.tcp.read.select.min.time", "", 0, 100);
        this.add(paramReadSelectMin, listSocket);
        paramReadSelectMin.setLabelText(MessageText.getString("ConfigView.section.connection.advanced.read_select_min", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.read.select.min.time"))}));
        IntParameterImpl paramWriteSelect = new IntParameterImpl("network.tcp.write.select.time", "", 10, 250);
        this.add(paramWriteSelect, listSocket);
        paramWriteSelect.setLabelText(MessageText.getString("ConfigView.section.connection.advanced.write_select", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.write.select.time"))}));
        IntParameterImpl paramWriteSelectMin = new IntParameterImpl("network.tcp.write.select.min.time", "", 0, 100);
        this.add(paramWriteSelectMin, listSocket);
        paramWriteSelectMin.setLabelText(MessageText.getString("ConfigView.section.connection.advanced.write_select_min", new String[]{String.valueOf(COConfigurationManager.getDefault("network.tcp.write.select.min.time"))}));
        this.add(new ParameterGroupImpl("ConfigView.section.connection.advanced.socket.group", listSocket), new List[0]);
        BooleanParameterImpl ipv6_enable = this.add(new BooleanParameterImpl("IPV6 Enable Support", "network.ipv6.enable.support"), new List[0]);
        BooleanParameterImpl ipv6_checks = this.add(new BooleanParameterImpl("IPV6 Enable Multiple Address Checks", "network.ipv6.enable.multiple.address.checks"), new List[0]);
        ipv6_checks.setIndent(1, true);
        ipv6_enable.addEnabledOnSelection((Parameter)ipv6_checks);
        StringParameterImpl ipv6_extra_globals = this.add(new StringParameterImpl("IPV6 Extra Globals", "network.ipv6.extra.global"), new List[0]);
        ipv6_extra_globals.setGenerateIntermediateEvents(false);
        ipv6_extra_globals.setIndent(1, true);
        ipv6_enable.addEnabledOnSelection((Parameter)ipv6_extra_globals);
        this.add(new BooleanParameterImpl("IPV6 Prefer Addresses", "network.ipv6.prefer.addresses"), new List[0]);
        if (Constants.isWindowsVistaOrHigher) {
            this.add(new BooleanParameterImpl("IPV4 Prefer Stack", "network.ipv4.prefer.stack"), new List[0]);
        }
        ArrayList listNIIgnore = new ArrayList();
        this.add(new LabelParameterImpl("connection.advanced.ni.ignore.info"), listNIIgnore);
        this.add(new BooleanParameterImpl("IPV4 Ignore Network Addresses", "label.ignore.ipv4"), listNIIgnore);
        this.add(new BooleanParameterImpl("IPV6 Ignore Network Addresses", "label.ignore.ipv6"), listNIIgnore);
        this.add(new ParameterGroupImpl("connection.advanced.ni.ignore.group", listNIIgnore), new List[0]);
        this.add(new StringParameterImpl("Connection.Test.Domain", "connection.test.domain"), new List[0]);
    }

    private static void enableTOSRegistrySetting(boolean enable) {
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.SetTCPTOSEnabled)) {
            try {
                mgr.setTCPTOSEnabled(enable);
            }
            catch (PlatformManagerException pe) {
                Debug.printStackTrace(pe);
            }
        }
    }
}

