/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionFile
extends ConfigSectionImpl {
    public static final String REFID_DEFAULT_DIR_OPTIONS = "default-dir-options";
    public static final String REFID_TORRENT_ADD_AUTO_SKIP = "torrent-add-auto-skip";
    public static final String REFID_TORRENT_ADD_AUTO_PRIORITY = "torrent-add-auto-priority";

    public ConfigSectionFile() {
        super("files", "root");
    }

    @Override
    public void build() {
        ArrayList listDefaultDir = new ArrayList();
        BooleanParameterImpl bestGuess = new BooleanParameterImpl("DefaultDir.BestGuess", "ConfigView.section.file.defaultdir.bestguess");
        this.add(bestGuess, 1, listDefaultDir);
        DirectoryParameterImpl pathParameter = new DirectoryParameterImpl("Default save path", "ConfigView.section.file.defaultdir.ask");
        this.add(pathParameter, listDefaultDir);
        pathParameter.setDialogTitleKey("ConfigView.dialog.choosedefaultsavepath");
        pathParameter.setDialogTitleKey("ConfigView.section.file.defaultdir.ask");
        BooleanParameterImpl alwaysFolder = new BooleanParameterImpl("Always Create Torrent Sub-Folder", "ConfigView.section.file.always.create.sub.folder");
        this.add(alwaysFolder, 1, listDefaultDir);
        String[] openValues = new String[]{"never", "always", "many"};
        String[] openLabels = new String[]{MessageText.getString("OpenTorrentOptions.show.never"), MessageText.getString("OpenTorrentOptions.show.always"), MessageText.getString("OpenTorrentOptions.show.many")};
        StringListParameterImpl paramShowOpenTorrentOptions = new StringListParameterImpl("ui.addtorrent.openoptions", "ConfigView.section.file.showopentorrentoptions", openValues, openLabels);
        paramShowOpenTorrentOptions.setAllowedUiTypes("swt");
        this.add(paramShowOpenTorrentOptions, listDefaultDir);
        BooleanParameterImpl paramShowSep = new BooleanParameterImpl("ui.addtorrent.openoptions.sep", "ConfigView.section.file.showopentorrentoptions.sep");
        paramShowSep.setAllowedUiTypes("swt");
        this.add(paramShowSep, listDefaultDir);
        BooleanParameterImpl paramAlwaysSidebar = new BooleanParameterImpl("ui.addtorrent.openoptions.always.sidebar", "ConfigView.section.file.showopentorrentoptions.always.sidebar");
        paramAlwaysSidebar.setAllowedUiTypes("swt");
        this.add(paramAlwaysSidebar, listDefaultDir);
        paramShowSep.addDisabledOnSelection((Parameter)paramAlwaysSidebar);
        IntParameterImpl autoClose = new IntParameterImpl("ui.addtorrent.openoptions.auto.close.secs", "ConfigView.label.showopentorrentoptions.autoclose");
        this.add(autoClose, 1, listDefaultDir);
        BooleanParameterImpl autoSaveAutoRename = new BooleanParameterImpl("DefaultDir.AutoSave.AutoRename", "ConfigView.section.file.defaultdir.autorename");
        this.add(autoSaveAutoRename, 1, listDefaultDir);
        BooleanParameterImpl autoUpdateSaveDir = new BooleanParameterImpl("DefaultDir.AutoUpdate", "ConfigView.section.file.defaultdir.lastused");
        this.add(autoUpdateSaveDir, 1, listDefaultDir);
        IntParameterImpl saveHistorySize = new IntParameterImpl("saveTo_list.max_entries", "ConfigView.label.save_list.max_entries");
        this.add(saveHistorySize, 1, listDefaultDir);
        ActionParameterImpl btnClearHistory = new ActionParameterImpl("ConfigView.label.save_list.clear", "Button.clear");
        this.add("btnClearHistory", btnClearHistory, listDefaultDir);
        btnClearHistory.setMinimumRequiredUserMode(1);
        btnClearHistory.addListener(p -> {
            COConfigurationManager.setParameter("saveTo_list", new ArrayList());
            btnClearHistory.setEnabled(false);
        });
        List<String> dirList = COConfigurationManager.getStringListParameter("saveTo_list");
        btnClearHistory.setEnabled(dirList.size() > 0);
        ParameterGroupImpl pgDefaultDir = new ParameterGroupImpl("ConfigView.section.file.defaultdir.section", listDefaultDir);
        pgDefaultDir.setReferenceID(REFID_DEFAULT_DIR_OPTIONS);
        this.add(pgDefaultDir, new List[0]);
        if (!Constants.isWindows) {
            BooleanParameterImpl xfsAllocation = new BooleanParameterImpl("XFS Allocation", "ConfigView.label.xfs.allocation");
            this.add(xfsAllocation, 1, new List[0]);
        }
        BooleanParameterImpl zeroNew = new BooleanParameterImpl("Zero New", "ConfigView.label.zeronewfiles");
        this.add(zeroNew, 1, new List[0]);
        BooleanParameterImpl zeroNewStop = new BooleanParameterImpl("Zero New Stop", "ConfigView.label.zeronewfiles.stop");
        this.add(zeroNewStop, 1, new List[0]);
        zeroNewStop.setIndent(1, true);
        BooleanParameterImpl sparseFiles = new BooleanParameterImpl("Enable Sparse Files", "ConfigView.label.spare.file.enable");
        this.add(sparseFiles, 1, new List[0]);
        BooleanParameterImpl pieceReorder = new BooleanParameterImpl("Enable reorder storage mode", "ConfigView.label.piecereorder");
        this.add(pieceReorder, 2, new List[0]);
        IntParameterImpl minMB = new IntParameterImpl("Reorder storage mode min MB", "ConfigView.label.piecereorderminmb");
        this.add(minMB, 1, new List[0]);
        minMB.setIndent(1, true);
        BooleanParameterImpl incremental = new BooleanParameterImpl("Enable incremental file creation", "ConfigView.label.incrementalfile");
        this.add(incremental, 1, new List[0]);
        ParameterListener listener = param -> {
            UIFunctions uiFunctions;
            UIFunctionsUserPrompter promptErr;
            boolean zero = zeroNew.getValue();
            boolean sparse = sparseFiles.getValue();
            boolean reorder = pieceReorder.getValue();
            boolean inc = incremental.getValue();
            if (zero) {
                sparse = false;
                reorder = false;
                inc = false;
            } else if (sparse) {
                reorder = false;
                inc = false;
            } else if (reorder) {
                inc = false;
            } else if (!inc) {
                inc = true;
                reorder = true;
                sparse = true;
                zero = true;
            }
            zeroNew.setEnabled(zero);
            zeroNewStop.setEnabled(zero && zeroNew.getValue());
            sparseFiles.setEnabled(sparse);
            pieceReorder.setEnabled(reorder);
            minMB.setEnabled(reorder && pieceReorder.getValue());
            incremental.setEnabled(inc);
            if (param != null && pieceReorder.getValue() && (promptErr = (uiFunctions = UIFunctionsManager.getUIFunctions()).getUserPrompter(MessageText.getString("label.option.deprecated"), MessageText.getString("ConfigView.section.file.reorder.warn.msg"), new String[]{MessageText.getString("Button.ok")}, 0)) != null) {
                promptErr.setIconResource("warning");
                promptErr.open(null);
            }
        };
        Parameter[] parameterArray = new Parameter[]{zeroNew, zeroNewStop, sparseFiles, pieceReorder, incremental};
        int n2 = parameterArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Parameter p2 = parameterArray[n3];
            p2.addListener(listener);
            ++n3;
        }
        listener.parameterChanged(null);
        BooleanParameterImpl truncateLarge = new BooleanParameterImpl("File.truncate.if.too.large", "ConfigView.section.file.truncate.too.large");
        this.add(truncateLarge, 1, new List[0]);
        BooleanParameterImpl mergeSameSize = new BooleanParameterImpl("Merge Same Size Files", "ConfigView.section.file.merge.same.size");
        this.add(mergeSameSize, 1, new List[0]);
        BooleanParameterImpl mergeSameSizeExt = new BooleanParameterImpl("Merge Same Size Files Extended", "ConfigView.section.file.merge.same.size.extended");
        this.add(mergeSameSizeExt, 1, new List[0]);
        mergeSameSizeExt.setIndent(1, true);
        mergeSameSize.addEnabledOnSelection((Parameter)mergeSameSizeExt);
        IntParameterImpl tol = new IntParameterImpl("Merge Same Size Files Tolerance", "ConfigView.section.file.merge.same.size.tolerance", 0, Integer.MAX_VALUE);
        this.add(tol, 1, new List[0]);
        tol.setIndent(1, true);
        mergeSameSize.addEnabledOnSelection((Parameter)tol);
        IntParameterImpl minmerge = new IntParameterImpl("Merge Same Size Files Min Pieces", "ConfigView.section.file.merge.min.pieces", 0, Integer.MAX_VALUE);
        this.add(minmerge, 1, new List[0]);
        minmerge.setIndent(1, true);
        mergeSameSize.addEnabledOnSelection((Parameter)minmerge);
        BooleanParameterImpl checkPiecesOnCompletion = new BooleanParameterImpl("Check Pieces on Completion", "ConfigView.label.checkOncompletion");
        this.add(checkPiecesOnCompletion, 1, new List[0]);
        BooleanParameterImpl checkPiecesOnCompletionBeforeMove = new BooleanParameterImpl("Check Pieces on Completion Before Move", "ConfigView.label.checkOncompletionBeforeMove");
        this.add(checkPiecesOnCompletionBeforeMove, 1, new List[0]);
        checkPiecesOnCompletionBeforeMove.setIndent(1, true);
        checkPiecesOnCompletion.addEnabledOnSelection((Parameter)checkPiecesOnCompletionBeforeMove);
        BooleanParameterImpl seedingPieceCheckRecheck = new BooleanParameterImpl("Seeding Piece Check Recheck Enable", "ConfigView.label.checkOnSeeding");
        this.add(seedingPieceCheckRecheck, 1, new List[0]);
        BooleanParameterImpl fileStrictLocking = new BooleanParameterImpl("File.strict.locking", "ConfigView.label.strictfilelocking");
        this.add(fileStrictLocking, 1, new List[0]);
        IntParameterImpl maxFileLinksSupported = new IntParameterImpl("Max File Links Supported", "ConfigView.label.max.file.links", 8, Integer.MAX_VALUE);
        this.add(maxFileLinksSupported, 1, new List[0]);
        maxFileLinksSupported.setSuffixLabelKey("ConfigView.label.max.file.links.warning");
        BooleanParameterImpl OOSDRE = new BooleanParameterImpl("Insufficient Space Download Restart Enable", "ConfigView.label.restart.no.space.dls");
        this.add(OOSDRE, 1, new List[0]);
        IntParameterImpl OOSDRInterval = new IntParameterImpl("Insufficient Space Download Restart Period", "ConfigView.label.restart.no.space.dls.interval", 1, Integer.MAX_VALUE);
        this.add(OOSDRInterval, 1, new List[0]);
        OOSDRInterval.setIndent(1, true);
        OOSDRInterval.setSuffixLabelKey("ConfigView.text.minutes");
        OOSDRE.addEnabledOnSelection((Parameter)OOSDRInterval);
        BooleanParameterImpl MFDRE = new BooleanParameterImpl("Missing File Download Restart Enable", "ConfigView.label.restart.missing.file.dls");
        this.add(MFDRE, 1, new List[0]);
        IntParameterImpl MFDRInterval = new IntParameterImpl("Missing File Download Restart Period", "ConfigView.label.restart.no.space.dls.interval", 1, Integer.MAX_VALUE);
        this.add(MFDRInterval, 1, new List[0]);
        MFDRInterval.setIndent(1, true);
        MFDRInterval.setSuffixLabelKey("ConfigView.text.minutes");
        MFDRE.addEnabledOnSelection((Parameter)MFDRInterval);
        BooleanParameterImpl uploadOnlyOnError = new BooleanParameterImpl("Switch To Upload Only On Write Error Enable", "ConfigView.label.upload.only.on.write.error");
        this.add(uploadOnlyOnError, 1, new List[0]);
        ArrayList listResume = new ArrayList();
        IntParameterImpl paramSaveInterval = new IntParameterImpl("Save Resume Interval", "ConfigView.label.saveresumeinterval");
        this.add(paramSaveInterval, 1, listResume);
        paramSaveInterval.setSuffixLabelKey("ConfigView.text.minutes");
        BooleanParameterImpl recheck_all = new BooleanParameterImpl("On Resume Recheck All", "ConfigView.section.file.resume.recheck.all");
        this.add(recheck_all, 1, listResume);
        BooleanParameterImpl save_peers = new BooleanParameterImpl("File.save.peers.enable", "ConfigView.section.file.save.peers.enable");
        this.add(save_peers, 1, listResume);
        IntParameterImpl savePeersMax = new IntParameterImpl("File.save.peers.max", "ConfigView.section.file.save.peers.max");
        this.add(savePeersMax, 1, listResume);
        savePeersMax.setSuffixLabelKey("ConfigView.section.file.save.peers.pertorrent");
        ParameterGroupImpl pgResumeGroup = new ParameterGroupImpl("v3.MainWindow.button.resume", listResume);
        this.add("pgResumeGroup", pgResumeGroup, new List[0]);
        save_peers.addEnabledOnSelection((Parameter)savePeersMax);
        BooleanParameterImpl bDisableSveInterim = new BooleanParameterImpl("Disable Interim Download State Save", "ConfigView.label.disableinterimstatesave");
        this.add(bDisableSveInterim, 2, new List[0]);
        BooleanParameterImpl bSkipIncompDLFileChecks = new BooleanParameterImpl("Skip Incomplete Download File Checks", "ConfigView.label.skipIncompDLFileChecks");
        this.add(bSkipIncompDLFileChecks, 2, new List[0]);
        BooleanParameterImpl bSkipCompDLFileChecks = new BooleanParameterImpl("Skip Complete Download File Checks", "ConfigView.label.skipCompDLFileChecks");
        this.add(bSkipCompDLFileChecks, 2, new List[0]);
        ArrayList listExt = new ArrayList();
        StringParameterImpl priorityExtensions = new StringParameterImpl("priorityExtensions", "ConfigView.label.priorityExtensions");
        this.add(priorityExtensions, 1, new List[0]);
        BooleanParameterImpl priorityExtensionsIgnoreCase = new BooleanParameterImpl("priorityExtensionsIgnoreCase", "ConfigView.label.ignoreCase");
        this.add(priorityExtensionsIgnoreCase, 1, new List[0]);
        ParameterGroupImpl pgPriorityExt = new ParameterGroupImpl(null, priorityExtensions, priorityExtensionsIgnoreCase);
        pgPriorityExt.setReferenceID(REFID_TORRENT_ADD_AUTO_PRIORITY);
        this.add("pgPriorityExt", pgPriorityExt, listExt);
        pgPriorityExt.setNumberOfColumns(2);
        this.add(new StringParameterImpl("file.auto.sequential.exts", "ConfigView.label.sequential.exts"), 1, listExt);
        StringParameterImpl quickViewExts = new StringParameterImpl("quick.view.exts", "ConfigView.label.quickviewexts");
        this.add(quickViewExts, 1, new List[0]);
        IntParameterImpl quickViewMaxKB = new IntParameterImpl("quick.view.maxkb", "ConfigView.label.quickviewmaxkb", 1, 9999);
        this.add(quickViewMaxKB, 1, new List[0]);
        ParameterGroupImpl pgQV = new ParameterGroupImpl(null, quickViewExts, quickViewMaxKB);
        this.add("pgQV", pgQV, listExt);
        pgQV.setNumberOfColumns(2);
        BooleanParameterImpl rename_incomplete = new BooleanParameterImpl("Rename Incomplete Files", "ConfigView.section.file.rename.incomplete");
        this.add(rename_incomplete, 1, new List[0]);
        StringParameterImpl rename_incomplete_ext = new StringParameterImpl("Rename Incomplete Files Extension", null);
        this.add(rename_incomplete_ext, 1, new List[0]);
        rename_incomplete.addEnabledOnSelection((Parameter)rename_incomplete_ext);
        ParameterGroupImpl pgExtRename = new ParameterGroupImpl(null, rename_incomplete, rename_incomplete_ext);
        pgExtRename.setNumberOfColumns(2);
        this.add("pgExtRename", pgExtRename, listExt);
        BooleanParameterImpl enable_subfolder = new BooleanParameterImpl("Enable Subfolder for DND Files", "ConfigView.section.file.subfolder.dnd");
        this.add(enable_subfolder, 1, new List[0]);
        StringParameterImpl subfolder_name = new StringParameterImpl("Subfolder for DND Files", null);
        this.add(subfolder_name, 1, new List[0]);
        enable_subfolder.addEnabledOnSelection((Parameter)subfolder_name);
        ParameterGroupImpl pgExtSubFolder = new ParameterGroupImpl(null, enable_subfolder, subfolder_name);
        pgExtSubFolder.setNumberOfColumns(2);
        this.add("pgExtSubFolder", pgExtSubFolder, listExt);
        BooleanParameterImpl enable_dndaltloc = new BooleanParameterImpl("Enable Alternative Location for DND Files", "ConfigView.section.file.altloc.dnd");
        this.add(enable_dndaltloc, 1, new List[0]);
        DirectoryParameterImpl dndaltloc_name = new DirectoryParameterImpl("Alternative Location for DND Files", null);
        this.add(dndaltloc_name, 1, new List[0]);
        enable_dndaltloc.addEnabledOnSelection((Parameter)dndaltloc_name);
        ParameterListener dnd_fol_listener = n -> {
            boolean sub = enable_subfolder.getValue();
            boolean loc = enable_dndaltloc.getValue();
            if (sub && loc) {
                if (n == null) {
                    enable_dndaltloc.setValue(false);
                } else if (n == enable_subfolder) {
                    enable_dndaltloc.setValue(false);
                } else {
                    enable_subfolder.setValue(false);
                }
            }
        };
        enable_subfolder.addListener(dnd_fol_listener);
        enable_dndaltloc.addAndFireListener(dnd_fol_listener);
        ParameterGroupImpl pgDndAltLoc = new ParameterGroupImpl(null, enable_dndaltloc, dndaltloc_name);
        pgDndAltLoc.setNumberOfColumns(2);
        this.add("pgDndAltLoc", pgDndAltLoc, listExt);
        BooleanParameterImpl enable_dndprefix = new BooleanParameterImpl("Use Incomplete File Prefix", "ConfigView.section.file.dnd.prefix.enable");
        this.add(enable_dndprefix, 1, listExt);
        ParameterListener prefixListener = param -> {
            boolean enabled;
            boolean bl = enabled = enable_subfolder.getValue() || enable_dndaltloc.getValue() || rename_incomplete.getValue();
            if (!enabled) {
                enable_dndprefix.setValue(false);
            }
            enable_dndprefix.setEnabled(enabled);
        };
        enable_subfolder.addListener(prefixListener);
        rename_incomplete.addListener(prefixListener);
        enable_dndaltloc.addListener(prefixListener);
        prefixListener.parameterChanged(null);
        ParameterGroupImpl pgFileExt = new ParameterGroupImpl("ConfigView.group.FileExtensions", listExt);
        this.add("pgFileExt", pgFileExt, 1, new List[0]);
        ArrayList listDownloadHistory = new ArrayList();
        BooleanParameter dlh_enable = this.add(new BooleanParameterImpl("Download History Enabled", "ConfigView.label.record.dl.history"), listDownloadHistory);
        BooleanParameter dlh_no_dup = this.add(new BooleanParameterImpl("Download History Dont Add Duplicate", "ConfigView.label.dl.history.no.dup"), listDownloadHistory);
        dlh_enable.addEnabledOnSelection((Parameter)dlh_no_dup);
        ParameterGroupImpl pgDownloadHistory = new ParameterGroupImpl("downloadhistoryview.view.heading", listDownloadHistory);
        this.add("pgDownloadHistory", pgDownloadHistory, new List[0]);
        ArrayList listIgnoredFiles = new ArrayList();
        StringParameterImpl paramSkipExtensions = new StringParameterImpl("File.Torrent.AutoSkipExtensions", "ConfigView.section.file.torrent.autoskipfiles");
        this.add(paramSkipExtensions, 1, listIgnoredFiles);
        StringParameterImpl paramSkipFiles = new StringParameterImpl("File.Torrent.AutoSkipFiles", "ConfigView.section.file.torrent.autoskipfilenames");
        this.add(paramSkipFiles, 1, new List[0]);
        BooleanParameterImpl paramSkipFilesRegex = new BooleanParameterImpl("File.Torrent.AutoSkipFiles.RegExp", "label.regexps");
        this.add(paramSkipFilesRegex, 1, new List[0]);
        ParameterGroupImpl pgSkipFileNames = new ParameterGroupImpl(null, paramSkipFiles, paramSkipFilesRegex);
        pgSkipFileNames.setNumberOfColumns(2);
        this.add("pgSkipFileNames", pgSkipFileNames, 1, listIgnoredFiles);
        IntParameterImpl paramAutoSkipMinSize = new IntParameterImpl("File.Torrent.AutoSkipMinSizeKB", "ConfigView.section.file.torrent.autoskipfilesminsize", 0, Integer.MAX_VALUE);
        this.add(paramAutoSkipMinSize, 1, listIgnoredFiles);
        StringParameterImpl ignoreCreateDelete = new StringParameterImpl("File.Torrent.IgnoreFiles", "ConfigView.section.file.torrent.ignorefiles");
        this.add(ignoreCreateDelete, 1, listIgnoredFiles);
        ParameterGroupImpl pgIgnoredFiles = new ParameterGroupImpl("ConfigView.section.file.ignore.section", listIgnoredFiles);
        this.add("pgIgnoredFiles", pgIgnoredFiles, new List[0]);
        pgIgnoredFiles.setReferenceID(REFID_TORRENT_ADD_AUTO_SKIP);
        StringParameterImpl paramCharConversions = new StringParameterImpl("File.Character.Conversions", "ConfigView.section.file.char.conversions");
        this.add(paramCharConversions, 2, new List[0]);
        paramCharConversions.setWidthInCharacters(14);
        String[] split = MessageText.getString("ConfigView.section.file.char.conversions").split("\\n\\s+", 2);
        paramCharConversions.setLabelText(split[0]);
        if (split.length > 1) {
            paramCharConversions.setSuffixLabelText(split[1]);
        }
        ArrayList listDeletion = new ArrayList();
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] values = nArray;
        String[] labels = new String[]{MessageText.getString("ConfigView.tb.delete.ask"), MessageText.getString("ConfigView.tb.delete.content"), MessageText.getString("ConfigView.tb.delete.torrent")};
        IntListParameterImpl paramConfirmDelete = new IntListParameterImpl("tb.confirm.delete.content", "ConfigView.section.file.tb.delete", values, labels);
        paramConfirmDelete.setAllowedUiTypes("swt");
        this.add(paramConfirmDelete, 1, listDeletion);
        BooleanParameterImpl paramDeleteTorrentFile = new BooleanParameterImpl("def.deletetorrent", "ConfigView.section.file.delete.torrent");
        paramDeleteTorrentFile.setAllowedUiTypes("swt");
        this.add(paramDeleteTorrentFile, 1, listDeletion);
        BooleanParameterImpl paramDeleteAllDefault = new BooleanParameterImpl("def.deleteallselected", "ConfigView.section.file.delete.all.selected");
        paramDeleteAllDefault.setAllowedUiTypes("swt");
        this.add(paramDeleteAllDefault, 1, listDeletion);
        try {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                BooleanParameterImpl paramRecycleBin = new BooleanParameterImpl("Move Deleted Data To Recycle Bin", "ConfigView.section.file.nativedelete");
                this.add(paramRecycleBin, listDeletion);
            }
        }
        catch (Throwable platform) {
            // empty catch block
        }
        this.add(new BooleanParameterImpl("File.delete.include_files_outside_save_dir", "ConfigView.section.file.delete.include_files_outside_save_dir"), listDeletion);
        this.add(new BooleanParameterImpl("Delete Partial Files On Library Removal", "delete.partial.files"), listDeletion);
        ParameterGroupImpl pgDeletion = new ParameterGroupImpl("ConfigView.section.file.deletion.section", listDeletion);
        this.add("pgDeletion", pgDeletion, new List[0]);
        HyperlinkParameterImpl paramUserPath = new HyperlinkParameterImpl("!" + SystemProperties.getUserPath() + "!", "ConfigView.section.file.config.currentdir", SystemProperties.getUserPath());
        this.add(paramUserPath, new List[0]);
        BooleanParameterImpl paramBackupConfig = new BooleanParameterImpl("Use Config File Backups", "ConfigView.label.backupconfigfiles");
        this.add(paramBackupConfig, new List[0]);
        this.add("pgConfig", new ParameterGroupImpl("ConfigView.section.file.config.section", paramBackupConfig, paramUserPath), new List[0]);
    }
}

