/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.InfoParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.List;

public class ConfigSectionFilePerformance
extends ConfigSectionImpl {
    public static final String SECTION_ID = "file.perf";

    public ConfigSectionFilePerformance() {
        super(SECTION_ID, "files");
    }

    @Override
    public void build() {
        this.add(new LabelParameterImpl("ConfigView.section.file.perf.explain"), new List[0]);
        String[] strategyLabels = new String[3];
        int i = 0;
        while (i < strategyLabels.length) {
            strategyLabels[i] = MessageText.getString("ConfigView.section.file.hashchecking.strategy." + i);
            ++i;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.add(new IntListParameterImpl("diskmanager.hashchecking.strategy", "ConfigView.section.file.hashchecking.strategy", nArray, strategyLabels), new List[0]);
        this.add(new BooleanParameterImpl("diskmanager.hashchecking.smallestfirst", "ConfigView.section.file.hashchecking.smallestfirst"), new List[0]);
        IntParameterImpl recheck_max_active = new IntParameterImpl("diskmanager.hashchecking.maxactive", "ConfigView.section.file.hashchecking.maxactive");
        this.add(recheck_max_active, 1, new List[0]);
        recheck_max_active.setMinValue(0);
        this.add(new BooleanParameterImpl("diskmanager.alloc.smallestfirst", "ConfigView.section.file.alloc.smallestfirst"), new List[0]);
        this.add(new BooleanParameterImpl("diskmanager.move.smallestfirst", "ConfigView.section.file.move.smallestfirst"), new List[0]);
        InfoParameterImpl param_fs_names = new InfoParameterImpl(null, "label.current.file.systems", "{ " + MessageText.getString("PeersView.state.pending") + "... }");
        this.add(param_fs_names, new List[0]);
        FileUtil.getFileStoreNames(names -> {
            String fsStr = "";
            String[] stringArray = names;
            int n = ((String[])names).length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                fsStr = String.valueOf(fsStr) + (fsStr.isEmpty() ? "" : ", ") + "\"" + f + "\"";
                ++n2;
            }
            param_fs_names.setValue(fsStr);
        });
        BooleanParameterImpl one_per_fs = this.add(new BooleanParameterImpl("diskmanager.one.op.per.fs", "ConfigView.section.file.one.op.per.fs"), new List[0]);
        BooleanParameterImpl one_per_fs_conc_read = this.add(new BooleanParameterImpl("diskmanager.one.op.per.fs.conc.read", "ConfigView.section.file.one.op.per.fs.conc.read"), new List[0]);
        one_per_fs_conc_read.setIndent(1, true);
        one_per_fs.addEnabledOnSelection((Parameter)one_per_fs_conc_read);
        BooleanParameterImpl disk_cache = new BooleanParameterImpl("diskmanager.perf.cache.enable", "ConfigView.section.file.perf.cache.enable");
        this.add(disk_cache, new List[0]);
        long kinb = DisplayFormatters.getKinB();
        long max_mem_bytes = Runtime.getRuntime().maxMemory();
        long mb_1 = 1L * kinb * kinb;
        long mb_32 = 32L * mb_1;
        IntParameterImpl cache_size = new IntParameterImpl("diskmanager.perf.cache.size", "", 1, COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB);
        this.add(cache_size, new List[0]);
        cache_size.setLabelText(MessageText.getString("ConfigView.section.file.perf.cache.size", new String[]{DisplayFormatters.getUnitBase10(2)}));
        cache_size.setSuffixLabelText(MessageText.getString("ConfigView.section.file.perf.cache.size.explain", new String[]{DisplayFormatters.formatByteCountToKiBEtc(mb_32), DisplayFormatters.formatByteCountToKiBEtc(max_mem_bytes), "https://wiki.biglybt.com/"}));
        IntParameterImpl cache_not_smaller_than = new IntParameterImpl("diskmanager.perf.cache.notsmallerthan", "");
        this.add(cache_not_smaller_than, 1, new List[0]);
        cache_not_smaller_than.setMinValue(0);
        cache_not_smaller_than.setLabelText(MessageText.getString("ConfigView.section.file.perf.cache.notsmallerthan", new String[]{DisplayFormatters.getUnitBase10(1)}));
        BooleanParameterImpl disk_cache_read = new BooleanParameterImpl("diskmanager.perf.cache.enable.read", "ConfigView.section.file.perf.cache.enable.read");
        this.add(disk_cache_read, 1, new List[0]);
        BooleanParameterImpl disk_cache_write = new BooleanParameterImpl("diskmanager.perf.cache.enable.write", "ConfigView.section.file.perf.cache.enable.write");
        this.add(disk_cache_write, 1, new List[0]);
        BooleanParameterImpl disk_cache_flush = new BooleanParameterImpl("diskmanager.perf.cache.flushpieces", "ConfigView.section.file.perf.cache.flushpieces");
        this.add(disk_cache_flush, 1, new List[0]);
        BooleanParameterImpl disk_cache_trace = new BooleanParameterImpl("diskmanager.perf.cache.trace", "ConfigView.section.file.perf.cache.trace");
        this.add(disk_cache_trace, 1, new List[0]);
        disk_cache.addEnabledOnSelection(cache_not_smaller_than, disk_cache_trace, disk_cache_read, disk_cache_write, disk_cache_flush, disk_cache_trace);
        IntParameterImpl paramMaxOpenFiles = new IntParameterImpl("File Max Open", "ConfigView.section.file.max_open_files");
        this.add(paramMaxOpenFiles, 2, new List[0]);
        paramMaxOpenFiles.setSuffixLabelKey("ConfigView.section.file.max_open_files.explain");
        IntParameterImpl write_block_limit = new IntParameterImpl("diskmanager.perf.write.maxmb", "");
        this.add(write_block_limit, 2, new List[0]);
        write_block_limit.setLabelText(MessageText.getString("ConfigView.section.file.writemblimit", new String[]{DisplayFormatters.getUnitBase10(2)}));
        write_block_limit.setSuffixLabelKey("ConfigView.section.file.writemblimit.explain");
        IntParameterImpl check_piece_limit = new IntParameterImpl("diskmanager.perf.read.maxmb", "");
        this.add(check_piece_limit, 2, new List[0]);
        check_piece_limit.setLabelText(MessageText.getString("ConfigView.section.file.readmblimit", new String[]{DisplayFormatters.getUnitBase10(2)}));
        check_piece_limit.setSuffixLabelKey("ConfigView.section.file.readmblimit.explain");
        disk_cache.addEnabledOnSelection((Parameter)cache_size);
    }
}

