/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.pifimpl.local.ui.config.UIParameterImpl;
import com.biglybt.ui.config.BaseConfigSection;
import com.biglybt.ui.config.ConfigSectionRebuildRunner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ConfigSectionImpl
implements BaseConfigSection {
    public static final String L10N_SECTION_PREFIX = "ConfigView.section.";
    private final String sectionID;
    private final String parentSectionID;
    private final int minUserMode;
    private int defaultMode = 0;
    private boolean isBuilt = false;
    private String[] defaultUITypes = null;
    private ConfigSectionRebuildRunner rebuildRunner;
    protected final Map<String, ParameterImpl> mapPluginParams = new LinkedHashMap<String, ParameterImpl>();

    public ConfigSectionImpl(WeakReference<BasicPluginConfigModel> model_ref) {
        BasicPluginConfigModel model = (BasicPluginConfigModel)model_ref.get();
        if (model == null) {
            this.sectionID = "DEAD" + Math.random();
            this.parentSectionID = "root";
        } else {
            String section = model.getSection();
            this.sectionID = section == null || section.isEmpty() ? "" + model : section;
            String parentSection = model.getParentSection();
            this.parentSectionID = parentSection == null || parentSection.isEmpty() ? "root" : parentSection;
        }
        this.minUserMode = 0;
    }

    public ConfigSectionImpl(String sectionID, String parentSectionID) {
        this(sectionID, parentSectionID, 0);
    }

    public ConfigSectionImpl(String sectionID, String parentSectionID, int minUserMode) {
        this.sectionID = sectionID;
        this.parentSectionID = parentSectionID;
        this.minUserMode = minUserMode;
    }

    @Override
    public final String getConfigSectionID() {
        return this.sectionID;
    }

    @Override
    public final String getParentSectionID() {
        return this.parentSectionID;
    }

    @Override
    public final void postBuild() {
        this.isBuilt = true;
    }

    @Override
    public final boolean isBuilt() {
        return this.isBuilt;
    }

    public final void setDefaultUserModeForAdd(int defaultMode) {
        this.defaultMode = defaultMode;
    }

    public final void setDefaultUITypesForAdd(String ... defaultUITypes) {
        this.defaultUITypes = defaultUITypes;
    }

    @SafeVarargs
    protected final <T extends ParameterImpl> T add(T param, List<Parameter> ... otherLists) {
        return this.add(param, this.defaultMode, otherLists);
    }

    @SafeVarargs
    protected final <T extends ParameterImpl> T add(T param, int minMode, List<Parameter> ... otherLists) {
        return this.add(this.guessParamName(param, true), param, minMode, otherLists);
    }

    @SafeVarargs
    protected final <T extends ParameterImpl> T add(String key, T param, List<Parameter> ... otherLists) {
        int minMode = 3;
        List<Parameter>[] listArray = otherLists;
        int n = otherLists.length;
        int n2 = 0;
        while (n2 < n) {
            List<Parameter> otherList = listArray[n2];
            for (Parameter child : otherList) {
                int childMinMode = child.getMinimumRequiredUserMode();
                if (childMinMode < minMode && (minMode = childMinMode) == 0) break;
            }
            if (minMode == 0) break;
            ++n2;
        }
        if (minMode > 2) {
            minMode = this.defaultMode;
        }
        return this.add(key, param, minMode, otherLists);
    }

    @SafeVarargs
    protected final <T extends ParameterImpl> T add(String key, T param, int minMode, List<Parameter> ... otherLists) {
        if (this.isBuilt) {
            Debug.out(String.valueOf(this.getConfigSectionID()) + "] can't add " + key + " after build()");
            return param;
        }
        if (otherLists != null) {
            List<Parameter>[] listArray = otherLists;
            int n = otherLists.length;
            int n2 = 0;
            while (n2 < n) {
                List<Parameter> list = listArray[n2];
                list.add(param);
                ++n2;
            }
        }
        if (minMode != 0) {
            param.setMinimumRequiredUserMode(minMode);
        }
        if (this.defaultUITypes != null) {
            param.setAllowedUiTypes(this.defaultUITypes);
        }
        if (param instanceof ParameterGroupImpl) {
            ((ParameterGroupImpl)param).setId(key);
        }
        this.mapPluginParams.put(key, param);
        return param;
    }

    protected String guessParamName(Parameter param, boolean warnExists) {
        String name = param.getConfigKeyName();
        if (name == null || name.isEmpty()) {
            if (param instanceof HyperlinkParameter) {
                name = ((HyperlinkParameter)param).getHyperlink();
                if (this.mapPluginParams.containsKey(name)) {
                    name = String.valueOf(name) + "/" + param.toString();
                }
            } else if (param instanceof ActionParameter) {
                name = String.valueOf(((ActionParameter)param).getActionResource()) + "," + param.toString();
            } else if (param instanceof ParameterGroupImpl) {
                name = ((ParameterGroupImpl)param).getGroupTitleKey();
                if ((name == null || name.isEmpty()) && ((name = param.getLabelKey()) == null || name.isEmpty())) {
                    name = param.toString();
                }
            } else {
                name = param instanceof UIParameterImpl ? param.toString() : param.getLabelKey();
            }
        }
        if (name == null || name.isEmpty()) {
            if (Constants.isCVSVersion()) {
                Logger.log(new LogEvent(LogIDs.PLUGIN, 1, String.valueOf(this.getConfigSectionID()) + "] param (" + param + ") missing config key, use #add(key, ...). Will make up name"));
            }
            name = param.toString();
        }
        if (warnExists && this.mapPluginParams.containsKey(name)) {
            if (Constants.isCVSVersion()) {
                Logger.log(new LogEvent(LogIDs.PLUGIN, 1, String.valueOf(this.getConfigSectionID()) + "] Already have key '" + name + "' " + this.mapPluginParams.get(name)));
            }
            name = String.valueOf(name) + "/";
        }
        return name;
    }

    @Override
    public final Parameter[] getParamArray() {
        return this.mapPluginParams.values().toArray(new Parameter[0]);
    }

    @Override
    public final ParameterImpl getPluginParam(String key) {
        return this.mapPluginParams.get(key);
    }

    public final String findPluginParamKey(Parameter param) {
        for (String key : this.mapPluginParams.keySet()) {
            if (param != this.mapPluginParams.get(key)) continue;
            return key;
        }
        return null;
    }

    @Override
    public void saveConfigSection() {
    }

    @Override
    public void deleteConfigSection() {
        for (ParameterImpl parameter : this.mapPluginParams.values()) {
            parameter.destroy();
        }
        this.mapPluginParams.clear();
        this.isBuilt = false;
    }

    @Override
    public final int getMinUserMode() {
        return this.minUserMode;
    }

    @Override
    public void setRebuildRunner(ConfigSectionRebuildRunner rebuildRunner) {
        this.rebuildRunner = rebuildRunner;
    }

    @Override
    public void requestRebuild() {
        if (this.rebuildRunner != null) {
            this.rebuildRunner.rebuildSection(this);
        }
    }

    @Override
    public final int getMaxUserMode() {
        int maxMode = this.getMinUserMode();
        if (maxMode == 2) {
            return maxMode;
        }
        for (ParameterImpl parameter : this.mapPluginParams.values()) {
            int minMode = parameter.getMinimumRequiredUserMode();
            if (minMode > maxMode && (maxMode = minMode) == 2) break;
        }
        return maxMode;
    }

    @Override
    public String getSectionNameKey() {
        return ConfigSectionImpl.getSectionNameKey(this.sectionID);
    }

    public static String getSectionNameKey(String sectionID) {
        String section_key = sectionID.startsWith("!") && sectionID.endsWith("!") ? sectionID : L10N_SECTION_PREFIX + sectionID;
        if (!MessageText.keyExists(section_key) && MessageText.keyExists(sectionID)) {
            section_key = sectionID;
        }
        return section_key;
    }

    @Override
    public List<Parameter> search(Pattern regex) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (ParameterImpl parameter : this.mapPluginParams.values()) {
            if (!parameter.search(regex)) continue;
            result.add(parameter);
        }
        return result;
    }

    public static interface ConfigDetailsCallback {
        public void run(Map<String, ParameterImpl> var1);
    }
}

