/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionInterfaceTags
extends ConfigSectionImpl {
    public static final String REFID_TORRENT_ADD_AUTO_TAG = "torrent-add-auto-tag";
    public static final String SECTION_ID = "style.tags";
    protected boolean skipTidy = false;

    public ConfigSectionInterfaceTags() {
        super(SECTION_ID, "style", 0);
    }

    @Override
    public void build() {
        this.buildGeneral();
        this.buildUISpecific();
        this.buildFiles();
        this.buildTracker();
    }

    protected void buildUISpecific() {
    }

    protected void buildGeneral() {
        ArrayList listGeneral = new ArrayList();
        BooleanParameterImpl persistSwarmTags = new BooleanParameterImpl("Show Swarm Tags In Overview", "label.show.swarm.tags.in.overview");
        persistSwarmTags.setAllowedUiTypes("swt");
        this.add(persistSwarmTags, 1, listGeneral);
        IntParameterImpl autoReapply = new IntParameterImpl("Tag Auto Full Reapply Period Secs", "tag.auto.reapply.period", 0, Integer.MAX_VALUE);
        this.add(autoReapply, 1, listGeneral);
        ParameterGroupImpl pgGeneral = new ParameterGroupImpl("ConfigView.section.global", listGeneral);
        this.add("pgGeneral", pgGeneral, new List[0]);
    }

    protected String getAutoTagExts(int i) {
        return COConfigurationManager.getStringParameter("File Auto Tag Exts " + (i == 0 ? "" : " " + i));
    }

    protected void setAutoTagExts(int i, String str) {
        COConfigurationManager.setParameter("File Auto Tag Exts " + (i == 0 ? "" : " " + i), str);
    }

    protected String getAutoTagTag(int i) {
        return COConfigurationManager.getStringParameter("File Auto Tag Name " + (i == 0 ? "" : " " + i), null);
    }

    protected void setAutoTagTag(int i, String str) {
        COConfigurationManager.setParameter("File Auto Tag Name " + (i == 0 ? "" : " " + i), str);
    }

    private void buildFiles() {
        int i;
        ArrayList<Parameter> listAutoTag = new ArrayList<Parameter>();
        BooleanParameterImpl auto_tag_enable = new BooleanParameterImpl("Files Auto Tag Enable", "label.enable.auto.tagging");
        this.add(auto_tag_enable, listAutoTag);
        this.add("f0", new LabelParameterImpl(""), listAutoTag);
        if (this.isSWT()) {
            this.add("f0.1", new LabelParameterImpl(""), listAutoTag);
            this.add("f0.2", new LabelParameterImpl(""), listAutoTag);
        }
        int num_tags = COConfigurationManager.getIntParameter("Files Auto Tag Count", 1);
        boolean tidied = false;
        if (this.skipTidy) {
            this.skipTidy = false;
        } else {
            i = num_tags - 1;
            while (i >= 1) {
                String exts = this.getAutoTagExts(i);
                String tag = this.getAutoTagTag(i);
                if (exts != null && !exts.isEmpty() || tag != null && !tag.isEmpty()) break;
                --num_tags;
                tidied = true;
                --i;
            }
            if (tidied) {
                COConfigurationManager.setParameter("Files Auto Tag Count", ++num_tags);
            }
        }
        i = 0;
        while (i < num_tags) {
            this.addAutoTagLine(listAutoTag, i);
            ++i;
        }
        BooleanParameterImpl auto_tag_best = new BooleanParameterImpl("Files Auto Tag Best Size", "ConfigView.label.auto.tag.best.size");
        this.add(auto_tag_best, listAutoTag);
        this.add("f1", new LabelParameterImpl(""), listAutoTag);
        if (this.isSWT()) {
            this.add("f1.1", new LabelParameterImpl(""), listAutoTag);
            this.add("f1.2", new LabelParameterImpl(""), listAutoTag);
        }
        this.addAutoTagLine(listAutoTag, -1);
        ActionParameterImpl addButton = new ActionParameterImpl(null, "ConfigView.label.addanothertag");
        this.add("addButton", addButton, listAutoTag);
        addButton.addListener(param -> {
            int num = COConfigurationManager.getIntParameter("Files Auto Tag Count", 1);
            COConfigurationManager.setParameter("Files Auto Tag Count", num + 1);
            this.skipTidy = true;
            this.requestRebuild();
        });
        this.add("f2", new LabelParameterImpl(""), listAutoTag);
        if (this.isSWT()) {
            this.add("f2.1", new LabelParameterImpl(""), listAutoTag);
            this.add("f2.2", new LabelParameterImpl(""), listAutoTag);
        }
        BooleanParameterImpl auto_tag_mod = new BooleanParameterImpl("Files Auto Tag Mod Enable", "ConfigView.label.auto.tag.allow.mod");
        this.add(auto_tag_mod, listAutoTag);
        ParameterGroupImpl pgExtensionTagging = new ParameterGroupImpl("ConfigView.label.lh.ext", listAutoTag);
        this.add("pgAutoTagging", pgExtensionTagging, new List[0]);
        pgExtensionTagging.setNumberOfColumns(this.isSWT() ? 4 : 2);
        pgExtensionTagging.setReferenceID(REFID_TORRENT_ADD_AUTO_TAG);
        auto_tag_enable.addEnabledOnSelection(listAutoTag.subList(1, listAutoTag.size()).toArray(new Parameter[0]));
        ArrayList<ParameterGroupImpl> listFiles = new ArrayList<ParameterGroupImpl>();
        listFiles.add(pgExtensionTagging);
        ParameterGroupImpl pgFiles = new ParameterGroupImpl("ConfigView.section.files", listFiles);
        this.add("pgFiles", pgFiles, new List[0]);
        pgFiles.setNumberOfColumns(1);
    }

    protected boolean isSWT() {
        return false;
    }

    protected void addAutoTagLine(List<Parameter> listAutoTag, int index) {
        if (index == -1) {
            LabelParameterImpl autoTagNoMatchInfo = new LabelParameterImpl("label.assign.to.tag.default");
            this.add(autoTagNoMatchInfo, listAutoTag);
            StringParameterImpl tagParam = new StringParameterImpl("File Auto Tag Name Default", "label.assign.to.tag");
            this.add(tagParam, listAutoTag);
            tagParam.setWidthInCharacters(15);
        } else {
            StringParameterImpl tagExts = new StringParameterImpl("File Auto Tag Exts " + (index == 0 ? "" : " " + index), "ConfigView.label.file.exts");
            this.add(tagExts, listAutoTag);
            StringParameterImpl tagParam = new StringParameterImpl("File Auto Tag Name " + (index == 0 ? "" : " " + index), "label.assign.to.tag");
            this.add(tagParam, listAutoTag);
            tagParam.setWidthInCharacters(15);
        }
    }

    private void buildTracker() {
        if (!COConfigurationManager.getBooleanParameter("PluginInfo.azbuddy.enabled")) {
            return;
        }
        ArrayList listTracker = new ArrayList();
        BooleanParameterImpl auto_tag_enable = new BooleanParameterImpl("Auto Tag Interesting Trackers", "label.auto.tag.interesting.trackers");
        this.add(auto_tag_enable, listTracker);
        ParameterGroupImpl pgTracker = new ParameterGroupImpl("label.tracker", listTracker);
        this.add("pgTracker", pgTracker, new List[0]);
        pgTracker.setNumberOfColumns(2);
    }
}

