/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.logging.impl.FileLogging;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.Constants;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class ConfigSectionLogging
extends ConfigSectionImpl {
    public static final String SECTION_ID = "logging";
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final int[] logFileSizes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 75, 100, 200, 300, 500};

    public ConfigSectionLogging() {
        super(SECTION_ID, "root");
    }

    @Override
    public void build() {
        BooleanParameterImpl force_debug;
        BooleanParameterImpl enable_logger = new BooleanParameterImpl("Logger.Enabled", "ConfigView.section.logging.loggerenable");
        this.add(enable_logger, new List[0]);
        BooleanParameterImpl enableFileLogging = new BooleanParameterImpl("Logging Enable", "ConfigView.section.logging.enable");
        this.add(enableFileLogging, new List[0]);
        enableFileLogging.setIndent(1, true);
        ArrayList listFileLogging = new ArrayList();
        DirectoryParameterImpl pathParameter = new DirectoryParameterImpl("Logging Dir", "ConfigView.section.logging.logdir");
        this.add(pathParameter, listFileLogging);
        pathParameter.setDialogTitleKey("ConfigView.section.logging.choosedefaultsavepath");
        String[] lmLabels = new String[logFileSizes.length];
        int[] lmValues = new int[logFileSizes.length];
        int i = 0;
        while (i < logFileSizes.length) {
            int num = logFileSizes[i];
            lmLabels[i] = " " + num + " MB";
            lmValues[i] = num;
            ++i;
        }
        IntListParameterImpl paramMaxSize = new IntListParameterImpl("Logging Max Size", "ConfigView.section.logging.maxsize", lmValues, lmLabels);
        this.add(paramMaxSize, listFileLogging);
        StringParameterImpl timeStamp = new StringParameterImpl("Logging Timestamp", "ConfigView.section.logging.timestamp");
        this.add(timeStamp, 2, listFileLogging);
        timeStamp.setWidthInCharacters(20);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 3;
        int[] logTypes = nArray;
        LogIDs[] logIDs = FileLogging.configurableLOGIDs;
        ArrayList listFileFilter = new ArrayList();
        this.add("t0", new LabelParameterImpl(""), listFileFilter);
        int i2 = 0;
        while (i2 < logTypes.length) {
            this.add("t" + (i2 + 1), new LabelParameterImpl("ConfigView.section.logging.log" + i2 + "type"), listFileFilter);
            ++i2;
        }
        String sFilterPrefix = "ConfigView.section.logging.filter";
        LogIDs[] logIDsArray = logIDs;
        int n = logIDs.length;
        int n2 = 0;
        while (n2 < n) {
            LogIDs logID = logIDsArray[n2];
            LabelParameterImpl title = new LabelParameterImpl("");
            this.add(logID.toString(), title, listFileFilter);
            title.setLabelText(MessageText.getString("ConfigView.section.logging.filter." + logID, logID.toString()));
            int[] nArray2 = logTypes;
            int n3 = logTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                int logType = nArray2[n4];
                BooleanParameterImpl check = new BooleanParameterImpl("bLog." + logType + "." + logID, "");
                this.add(check, listFileFilter);
                ++n4;
            }
            ++n2;
        }
        ParameterGroupImpl pgFileFilter = new ParameterGroupImpl("ConfigView.section.logging.filter", listFileFilter);
        this.add("pgFileFilter", pgFileFilter, listFileLogging);
        pgFileFilter.setNumberOfColumns(logTypes.length + 1);
        ParameterGroupImpl pgFileLogging = new ParameterGroupImpl(null, listFileLogging);
        this.add("pgFileLogging", pgFileLogging, new List[0]);
        pgFileLogging.setIndent(3, false);
        enableFileLogging.addEnabledOnSelection((Parameter)pgFileLogging);
        enable_logger.addEnabledOnSelection(enableFileLogging, pgFileLogging);
        enable_logger.addListener(param -> {
            if (!enable_logger.getValue()) {
                enableFileLogging.setValue(false);
            }
        });
        if (Constants.IS_CVS_VERSION) {
            force_debug = new BooleanParameterImpl("Logger.DebugFiles.Disable", "ConfigView.section.logging.disabledebugfiles");
            this.add(force_debug, new List[0]);
        } else {
            force_debug = new BooleanParameterImpl("Logger.DebugFiles.Enabled.Force", "ConfigView.section.logging.forcedebug");
            this.add(force_debug, new List[0]);
        }
        this.add(new IntParameterImpl("Logger.DebugFiles.SizeKB", "ConfigView.section.logging.debugfilesize", 10, Integer.MAX_VALUE), 1, new List[0]);
        StringParameterImpl name = new StringParameterImpl("Advanced Option Name", "label.name");
        this.add(name, 2, new List[0]);
        name.setWidthInCharacters(20);
        StringParameterImpl value = new StringParameterImpl("Advanced Option Value", "label.value");
        this.add(value, 2, new List[0]);
        value.setWidthInCharacters(12);
        ActionParameterImpl set_option = new ActionParameterImpl(null, "Button.set");
        this.add(set_option, 2, new List[0]);
        set_option.addListener(param -> {
            String key = name.getValue().trim();
            if (key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if (key.length() > 0) {
                if (key.startsWith("!")) {
                    key = key.substring(1);
                }
                String val = value.getValue().trim();
                boolean is_string = false;
                if (val.startsWith("'") && val.endsWith("'") || val.startsWith("\"") && val.endsWith("\"")) {
                    val = val.substring(1, val.length() - 1);
                    is_string = true;
                }
                if (val.length() == 0) {
                    COConfigurationManager.removeParameter(key);
                } else if (is_string) {
                    COConfigurationManager.setParameter(key, val);
                } else {
                    String lc_val = val.toLowerCase(Locale.US);
                    if (lc_val.equals("false") || lc_val.equals("true")) {
                        COConfigurationManager.setParameter(key, lc_val.startsWith("t"));
                    } else {
                        try {
                            long l = Long.parseLong(val);
                            COConfigurationManager.setParameter(key, l);
                        }
                        catch (Throwable e) {
                            COConfigurationManager.setParameter(key, val);
                        }
                    }
                }
                COConfigurationManager.save();
            }
        });
        ParameterGroupImpl pgAdvSetting = new ParameterGroupImpl("dht.advanced.group", name, value, set_option);
        this.add("pgAdvSetting", pgAdvSetting, new List[0]);
        pgAdvSetting.setMinimumRequiredUserMode(2);
        pgAdvSetting.setNumberOfColumns(3);
        ActionParameterImpl generate_stats_button = new ActionParameterImpl("ConfigView.section.logging.statsinfo", "ConfigView.section.logging.generatediagnostics");
        this.add(generate_stats_button, new List[0]);
        generate_stats_button.addListener(param -> {
            try {
                generate_stats_button.setEnabled(false);
                HashSet<String> types = new HashSet<String>();
                types.add(".*");
                Map<String, Object> reply = CoreStats.getStats(types);
                reply = new TreeMap<String, Object>(reply);
                Iterator<Map.Entry<String, Object>> it = reply.entrySet().iterator();
                StringBuilder buffer = new StringBuilder(16000);
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (entry == null) continue;
                    buffer.append(entry.getKey()).append(" -> ").append(entry.getValue()).append("\r\n");
                }
                String str = buffer.toString();
                Logger.log(new LogEvent(LOGID, "Stats Info:\n" + str));
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.copyToClipboard(str);
                }
            }
            finally {
                generate_stats_button.setEnabled(true);
            }
        });
        ActionParameterImpl generate_button = new ActionParameterImpl("ConfigView.section.logging.generatediagnostics.info", "ConfigView.section.logging.generatediagnostics");
        this.add(generate_button, new List[0]);
        generate_button.addListener(param -> {
            try {
                generate_button.setEnabled(false);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                AEDiagnostics.generateEvidence(pw);
                pw.close();
                String evidence = sw.toString();
                Logger.log(new LogEvent(LOGID, "Evidence Generation:\n" + evidence));
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.copyToClipboard(evidence);
                }
            }
            finally {
                generate_button.setEnabled(true);
            }
        });
    }
}

